---
title: ampere-theorem-torus-solenoid
published: false
routable: false
visible: false
lessons:
    -
        slug: ampere-integral-cylindrical-symmetry-toroidal-coil-3-method
        name: LINÉAIRE-3 : Ampère intégral et bobines toriques
        order: 2
    -
        slug: symmetry-axial-vectors-magnetic-field-toroidal-coil-3
        name: CONCEPT-3 : Symétries, vecteurs axiaux et bobines toriques
        order: 2
    - 
        slug: ampere-integral-cylindrical-symmetry-toroidal-coil-3-mathtool
        name: OUTIL-MATH : Calcul intégral, coordonnées cylindriques et bobines toriques
        order: 2
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Etape 7 : En test auprès d'étudiants</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème d'**Ampère intégral** :

#### Aux bobines toriques à section quelconque


![](bobine-torique-reelle_L1200.jpg)   
_Bobine torique à section rectangulaire._


<br>
![](ampere-etape-0_v5.jpg)
<br>

#### Pourquoi créer un modèle physique de la bobine ?

* La **réalité**  ultime d'une bobine torique est *hors d'atteinte d'une description*.   

* La **bobine** constituée du fil conducteur enroulé sur son support torique est *imparfaite* :   
   * _possibles déformations locales du fil qui entrainent une section droite non parfaitement constante._
   * _chevauchement possible de spires qui peuvent être non jointives._   
   * _courant traversant le fil non parfaitement uniforme sur toute section droite de fil._  
   * ...

* Cependant le *concepteur et fabriquant* d'une bobine torique fait en sorte de 
    **réaliser une bobine** torique **proche d'une bobine torique "idéale"**,  de forme torique
    parfaite et parcourue à sa surface par un
    courant le plus homogène possible :   
   * il utilisera préférentiellement un *fil conducteur de section petite*,
   * et prendra soin de rendre les *spires jointives* lors de l'enroulement du fil.


#### Quel modèle physique choisissons-nous ?
   

* Par **choix**, nous décrirons une bobine dont l'*empilement des spires* reste d'*épaisseur faible*.

* Ainsi, le **modèle physique représentatif** de la bobine torique sera constitué :  
   * d'un *fil conducteur* (isolé en surface) de *section négligeable*.
   * l'enroulement du fil comprend un grand *nombre N de spires*.
   * les spires sont *jointives*.
   * Le fil est parcouru par un *courant $`I`$ constant*.   
     _($`I`$ est constant car l'étude est faite dans le cadre de la magnétostatique)_

* *Dans la suite*, nous considérerons une **bobine torique à section rectangulaire**,
  comme sur la photo présentée.

! *Note* :
! Ce modèle pourrait être décliné en une version ou la distribution de courants
! est décrite par un vecteur densité surfacique de courant $`\overrightarrow{j^{2D}}`$ adapté.   
! 
! Cependant, en pratique l'intensité $`I`$ du courant injecté dans la bobine est
! l'une des données principales (avec les caractéristiques de la bobine) pour créer le champ magnétique
! souhaité.
!
! Il est donc intéressant d'exprimer le champ magnétique en tout point de l'espace
! en fonction de $`I`$ plutôt qu'en fonction de $`\overrightarrow{j^{2D}}`$.
! 
! Par ailleurs, $`\overrightarrow{j^{2D}}`$ n'aurait pas une valeur constante
! selon sa direction ou sa distance par rapport à l'axe de révolution du tore.


#### Quel est l'intérêt d'un modèle physique s'il ne fait que s'approcher de la réalité ?

* Un **modèle physique** de causes *permet de prédire*
  les effets attendus en tout point de l'espace, grâce aux lois de la physique.

* La **réalisation** d'une bobine torique tentera de *s'approcher au mieux du modèle* physique.

* Le **champ magnétique prédit** est celui qui est *réalisé et mesuré en pratique*, à de petites variations près,
  souvent infimes ou négligeables, dues aux imperfections de la bobine réelle comparée à son idéalisation.



<br>
![](ampere-etape-1_v5.jpg)
<br>


![](magnetostatics-toroidal-coil-1_v4_L1200.gif)   
_Modélisation physique d'une bobine torique à section rectangulaire._   
_Étape 1 : détermination de la direction de B à l'aide des invariances et symétries_
_de la distribution de courants._ $`\mathcal{P}_1`$ _est plan de symétrie._


#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques
   $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.


#### De quelles coordonnées dépend $`\overrightarrow{B}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{B}}`$** possède les *invariances de la distribution des courants*

* $`\mathbf{I\text{ dans bobine torique }\Longrightarrow}`$ **$`\boldsymbol{\mathbf{\overrightarrow{B}=\overrightarrow{B}(\rho\,,z)}}`$**


#### Comment déterminer la direction de $`\overrightarrow{B}`$ ?

* *Par l'* **étude des symétries** *de la distribution de courant $`\overrightarrow{j}`$*.   
<br>

1. Soit un **point $`M(\rho\,\varphi,z)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et l'axe $`Oz`$ est *plan de symétrie* pour la distribution de courant.
3. Le champ magnétique **$`\overrightarrow{B}`$ étant un vecteur axial**, en tout point d'un plan de symétrie 
   il est perpendiculaire à ce plan. Le plan de symétrie $`P_1`$ étant déterminé, la
   *direction de $`\overrightarrow{B}`$, selon $`\overrightarrow{e_{\varphi}}`$*, est 
   *totalement déterminée*.
 

* De façon plus concise :   
<br>
**En tout point $`M`$** l'espace,   
*$`\left.\begin{array}{l} \overrightarrow{B}\;\text{vecteur axial} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie}\end{array}\right\}\,\Longrightarrow`$* 
**$`\boldsymbol{\mathbf{\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}}}`$**


#### Comment s'exprime $`\overrightarrow{B}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\overrightarrow{j}`$ :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{B}=\overrightarrow{B}(\rho\,,z) \\
\text{Symétries}\Longrightarrow\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{B}=B_{\varphi}(\rho\,,z)\,\overrightarrow{e_{\varphi}}}`$**


<br><br>
![](ampere-etape-2_v5.jpg)
<br>

![](magnetostatics-toroidal-coil-2_v4_L1200.gif)   
_Étape 2 : choix d'un contour d'Ampère adapté_ $`\Gamma_A`$ _et de son orientation_$`(\Longrightarrow\;\Gamma_{A\,or.})`$ _,_
_puis calcul de la circulation du champ magnétique._


#### Quel contour d'Ampère $`\Gamma_A`$ choisir ?

* Le **contour d'Ampère $`\mathbf{\Gamma_A}`$** doit :
   * être une *ligne fermée*.
   * *contenir le point $`M`$* quelconque.
   * permettre un *calcul simple de $`\displaystyle\oint_{\Gamma_A} \overrightarrow{B}\cdot \overrightarrow{dl}`$*.
   
* Que savons nous ? <br>
  Les invariances et symétries $`\Longrightarrow`$*$`\;\overrightarrow{B}=B_{\varphi}(\rho\,,z)\,\overrightarrow{e_{\varphi}}`$* 


* *Choix de $`\mathbf{\Gamma_A}`$* : **cercle**,
   * inscrit dans le plan qui **contient de point $`M`$** et **perpendiculaire à l'axe $`Oz`$**.
   * de **rayon $`\rho`$**, coordonnées du point $`M`$ considéré.


#### Que signifie orienter le contour d'Ampère $`\Gamma_A`$ choisi ?

* orienter signifie **donner un sens "positif" de circulation**, *indiqué par une flèche* sur le contour.

* Ce sens positif **fixe le sens des vecteurs déplacement élémentaire $`\mathbf{\overrightarrow{dl}}`$ ** le long du contour : .   


#### Le choix de l'orientation est-il important ?

* Ne pas oublier d'**orienter le contour d'Ampère** est *important*.

* Choisir **un sens plutôt que l'autre** n'a *pas d'importance*.   
  <br>
  En effet :   
  * le théorème d'Ampère est une égalité entre 2 membres :   
  $`\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\,\oiint_{\mathscr{S}_A}\overrightarrow{j}\cdot\overrightarrow{dS}`$
  * Les orientations de $`\overrightarrow{dl}`$ et $`\overrightarrow{dS}`$ sont liées.
  * Changer le sens de $`\overrightarrow{dl}`$ changera aussi le sens de $`\overrightarrow{dS}`$.   
    Cela revient à multiplier par $`-1`$ chaque membre de l'égalité,    
    ce qui ne modifie pas la solution de l'équation.


#### Que vaut la circulation de $`\overrightarrow{B}`$ le long de $`\Gamma_A`$ ?

* Le **signe** devant l'expression finale contenant $`B_{\varphi}(\rho\,,z)`$ *dépend de l'orientation choisie* sur $`\mathbf{\Gamma_A}`$.

* Choisissons comme **sens positif** le **sens trigonométrique direct**, *indiqué par une flèche* sur le cercle $`\mathbf{\Gamma_A}`$.   
  <br>
  **$`\Longrightarrow\mathbf{\overrightarrow{dl}=+\,\rho\,d\varphi\,\overrightarrow{e_{\varphi}}}`$** avec $`d\varphi>0`$.

* **$`\displaystyle\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$**   
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{En se rappelant que :}}}`$
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{invariances + symétries }\Longrightarrow \vec{B}=B_{\varphi}(\rho\,,z)\,\vec{e_{\varphi}}}}`$   
<br>
$`\displaystyle\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}\big(B_{\varphi}(\rho\,,z)\,\overrightarrow{e_{\varphi}}\big)\cdot \big(+\rho\,d\varphi\,\overrightarrow{e_{\varphi}}\big)`$    
<br>
$`\displaystyle\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}B_{\varphi}(\rho\,,z)\,\rho\,\big(\overrightarrow{e_{\varphi}}\cdot \overrightarrow{e_{\varphi}}\big) d\varphi`$      
<br>
$`\displaystyle\quad\quad=\rho\,B_{\varphi}(\rho\,,z)\,\oint_{\varphi=0}^{\varphi=2\pi}d\varphi`$    
<br>
**$`\mathbf{\displaystyle\quad\quad = 2\pi\,\rho\, B_{\varphi}(\rho)}`$**


<br>
![](ampere-etape-3_v5.jpg)
<br>

#### Existe t-il plusieurs surfaces d'Ampère dont l'intensité les traversant est simple à déterminer ?

<br>
![](magnetostatics-toroidal-coil-3_v4_1200.jpg)   
_Étape 3 : lorsque la distribution de courant est caractérisée par l'intensité_ $`I`$_, toute surface d'Ampère_
$`S_{A_or.}`$ _permet de déterminer facilement le terme_ $`\sum\overline{I}`$.   
<br>

* Le *modèle de bobine torique proposé* décrit la distribution de courants par le 
**courant d'intensité $`I`$** parcourant la bobine.

* De ce fait, la difficulté de trouver une surface orientée d'Ampère $`\S_{A\,or.}`$ s'appuyant sur le contour orienté d'Ampère $`\Gamma_{A\,or.}`$ et telle que sur chacun des éléments vectoriels de surfaces $`\overrightarrow{dS}`$ le produit scalaire $`\overrightarrow{j}\cdot\overrightarrow{dS}`$ soit simple à calculer est relaxée, puisque ce calcul est déjà réalisé lorsque $`I`$ est donné et que son sens est précisé $`(d\overline{I}=\vec{j}\cdot\vec{dS}`$.

* **Ainsi, toute surface convient** lorsque l'on visualise bien la distribution des courants.

#### Quelle est la surface d'Ampère la plus simple ?

<br>
![](magnetostatics-toroidal-coil-3_v4_L1200.gif)   
_Étape 3 : la surface d'Ampère_ $`(\Longrightarrow\;S_{A\,or.})`$ _la plus simple sera le disque qui s'appuie sur le cercle_ $`\Gamma_{A_or.}`$. 
_Les orientations de la surface et du contour d'Ampère sont liées par la règle de la main droite._   
<br>


* Cependant, choisis la *surface d'Ampère la plus simple*, 
soit le **disque qui s'appuie sur le cercle $`\Gamma_{A\,or;}`$** contenant le point $`M`$ (donc de rayon $`\rho`$) et d'axe $`Oz`$ (donc situé dans un plan $`z=cst`$).    
_(C'est la surface qui aurait été choisie si la distribution de courants avait été décrite par un vecteur densité surfacique de courants_ $`\overrightarrow{j^{2D}}`$ _par exemple)_    
<br>
Dans ce cas, la *visualisation* des courants traversant $`\S_{A\,or.}`$ est *particulièrement simple* à déterminer sur deux vues en coupe :
   * coupe dans le plan contenant le point $`M`$ et l'axe $`Oz`$.
   * coupe dans le plan contenant le point $`M`$ et perpendiculaire à l'axe $`Oz`$.

#### Comment orienter cette surface d'Ampère ?

* Les *orientations* du *contour d'Ampère $`\Gamma_{A\,or;}`$* et de la *surface d'Ampère $`S_{A\,or;}`$* associée
  sont *couplées* par la **règle de la main droite** d'orientation de l'espace .

* Ainsi, *si une orientation* (arbitraire) est *déjà choisie sur le contour d'Ampère*,    
  **alors l'orientation de la surface d'Ampère** est **déjà déterminée** par la règle 
  de la main droite.

* Cette orientation de la surface d'Ampère *permet de définir*
  le **sens** d'orientation de chacunes des **surfaces élémentaires $`\overrightarrow{dS}`$** 
  composant la surface d'Ampère.

* Le sens d'orientation choisi précédemment pour $`\Gamma_{A\,or;}`$ (sens trogonométrique direct)
  ayant conduit à la définition des  éléments vectoriels de longueur
  *$`\boldsymbol{\mathbf{\overrightarrow{dl}=+\rho\,d\varphi\,\overrightarrow{e_{\varphi}}}}`$* sur le contour
  (avec $`d\rho > 0`$) , *implique*
  la définition des éléments vectoriels de surface 
  *$`\boldsymbol{\mathbf{\overrightarrow{dS}=+\rho\,d\rho\,d\varphi\,\overrightarrow{e_z}}}`$*
  (avec $`(\rho > 0\text{  et  } d\varphi > 0`$).   
  
* Les deux orientations (contour et surface d'Ampère) étant liées, il aurait été 
  **possible d'orienter d'abord la surface** d'Ampère, puis
  *en déduire celle du contour*.   
  Pour l'orientation choisie, nous pouvons écrire :   
  <br>
  **$`\boldsymbol{\mathbf{\overrightarrow{dl}=+\,\rho\,d\varphi\,\overrightarrow{e_{\varphi}}}}`$**
  **$`\boldsymbol{\mathbf{\quad\Longleftrightarrow\quad
  \overrightarrow{dS}=+\,\rho\,d\rho\,d\varphi\,\overrightarrow{e_z}}}`$**   
  


<br>
![](ampere-etape-4_v5.jpg)
<br>

#### Pourquoi considérer différents domaines de l'espace ?

_Cette étape est parfois omise par les étudiants en difficultés._

<br>
![](magnetostatics-toroidal-coil-4_v4_L1200.gif)   
_Étape 4 : différents domaines de l'espace doivent être considérés pour le calcul de_ $`\overrightarrow{B}`$
_dans tout l'espace._   
<br>

* Le **calcul de $`\displaystyle\sum\overline{I}`$**, intensité algébrique  traversant $`\S_{A\,or.}`$, 
  sera différent dans *différents domaines* de l'espace.

* Nous identifions quatre domaines :
   * domaine **$`\mathbf{A}`$** : *au dessus et au dessous* de la bobine torique :
     **$`\mathbf{z<0 \quad \text{ou} \quad z>H}`$**   
    <br>
   * domaine **$`\mathbf{B}`$** : dans le domaine *plan de la bobine, à l'extérieur* de celle-ci :
     **$`\mathbf{0 < z < H \quad \text{ et } \quad \rho > R_2}`$**   
    <br>
   * domaine **$`\mathbf{C}`$** : dans le domaine *plan de la bobine, à l'intérieur* de celle-ci :
     **$`\mathbf{0 < z < H \quad \text{ et } \quad R_1 < \rho < R_2}`$**   
     <br>
   * domaine **$`\mathbf{D}`$** : dans le domaine *plan de la bobine, au centre* de celle-ci :
     **$`\mathbf{0 < z < H \quad \text{ et } \quad \rho < R_1}`$**


#### Comment terminer le calcul de $`\overrightarrow{B}`$ dans tout l'espace ?

<br>
![](magnetostatics-toroidal-coil-5_v4_L1200.gif)   
_Étapes 4 : calcul de_ $`\overrightarrow{B}`$ _dans les différents domaines._   
<br>

-------

* *Dans chaque domaine*, calculer l'**expression de $`\displaystyle\sum\overline{I}`$**, 
puis déduire $`\overrightarrow{B}`$ de son *égalité avec* l'
**expression de $`\displaystyle\oint_{\Gamma_{A\,or.}}\overrightarrow{B}\cdot\overrightarrow{dl}`$** 
précédemment trouvée.   
Ainsi :

* **Pour $`\boldsymbol{\mathbf{\quad z < 0 \quad \text{ou} \quad z > H}}`$**,   
l'observation sur les schémas
en coupe montre que la somme algébrique des intensités traversant la surface d'Ampère 
orientée est nulle :   
<br>
*$\mathbf{\displaystyle\sum_{S_{A\,or.}}\overline{I} =0}$*.   
<br>
Cela implique *au final* un **champ magnétique nul** dans ce domaine.
<br>
$`\left.\begin{matrix}
\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}\\
\oint \overrightarrow{B}\cdot\overrightarrow{dl}=+2\pi\rho\,B_{\varphi}
=\mu_0\sum \overline{I}=0\\
\end{matrix}\right\}\Longrightarrow`$
**$`\;\color{brown}{\mathbf{\overrightarrow{B}=\overrightarrow{0}}}`$**   


<br>
* **Pour $`\boldsymbol{\mathbf{\quad  0 < z < H \quad \text{ et }\quad  \rho > R_2}}`$**  
  Tu observes que la surface orientée d'Ampère *$`S_{A\,or.}`$ est traversée par*      
   * *$`N`$ spires* portant chacunes par une même *intensité $`I`$ comptée positivement*,   
   * *$`N`$ spires* portant chacunes toujours la même *intensité $`I`$ comptée négativement* cette fois.

   Au total, l'intensité traversant la surface d'Ampère est nulle :   
  <br>
  *$\mathbf{\displaystyle\sum_{S_{A\,or.}}\overline{I} =+\,N\,I\,-\, N\,I=0}$*.   
<br>
Cela implique *au final* un **champ magnétique nul** dans ce domaine.
<br>
$`\left.\begin{matrix}
\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}\\
\oint \overrightarrow{B}\cdot\overrightarrow{dl}=+2\pi\rho\,B_{\varphi}
=\mu_0\sum \overline{I}=0\\
\end{matrix}\right\}\Longrightarrow`$
**$`\;\color{brown}{\mathbf{\overrightarrow{B}=\overrightarrow{0}}}`$**   

<br>
* **Pour $`\boldsymbol{\mathbf{\quad  0 < z < H \quad \text{ et }\quad  R_1 < \rho < R_2}}`$**  
  La surface orientée d'Ampère *$`S_{A\,or.}`$* est *seulement traversée par*      
   * *$`N`$ spires* portant chacunes par une même *intensité $`I`$ comptée négativement*.     

   Au total, l'intensité traversant la surface d'Ampère est $`-\,N\,I`$ :
  <br>
  *$\mathbf{\displaystyle\sum_{S_{A\,or.}}\overline{I} =-\, N\,I}$*.   
<br>
Cela implique *au final* dans ce domaine un **champ magnétique nul**d'expression :
<br>
$`\left.\begin{matrix}
\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}\\
\oint \overrightarrow{B}\cdot\overrightarrow{dl}=+2\pi\rho\,B_{\varphi}
=\mu_0\sum \overline{I}=-\,N\,I\\
\end{matrix}\right\}\Longrightarrow`$
**$`\;\color{brown}{\mathbf{\overrightarrow{B}=-\dfrac{\mu_O\,N\,I}{2\pi\,\rho}\overrightarrow{e_{\varphi}}}}`$**   

<br>
* **Pour $`\boldsymbol{\mathbf{\quad  0 < z < H \quad \text{ et }\quad  \rho < R_1}}`$**  
La somme algébrique des intensités traversant la surface d'Ampère 
orientée est nulle :   
<br>
*$\mathbf{\displaystyle\sum_{S_{A\,or.}}\overline{I} =0}$*.   
<br>
Cela implique *au final* un **champ magnétique nul** dans ce domaine.
<br>
$`\left.\begin{matrix}
\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}\\
\oint \overrightarrow{B}\cdot\overrightarrow{dl}=+2\pi\rho\,B_{\varphi}
=\mu_0\sum \overline{I}=0\\
\end{matrix}\right\}\Longrightarrow`$
**$`\;\color{brown}{\mathbf{\overrightarrow{B}=\overrightarrow{0}}}`$**   


<br>
![](ampere-etape-5_v5.jpg)
<br>


#### Profil du champ magnétique créé

A rédiger

#### La démonstration s'adapte à toute forme de section de bobine torique.

A rédiger

point conducteur, dans la zone $`z < 0`$ et $`z > H`$, 
les zones B, C et D sont définies en références à des rayons intérieurs
et extérieurs qui dépendent de z : $`R_1(z)`$ et $`R_2(z)`$.


#### De la bobine torique au solénoïde infini

A rédiger

point conducteur, la démonstration du théorème d'Ampère intégral s'applique
à toute taille. On avait fait tendre le contour vers 0 pour déduire le théorème
d'Ampère local.
Ici, en définissant $`\Delta R = \dfrac{R_2-R_1}{2}`$   
et $`R_1 = r-\Delta R`$ et $`R_2 = r+\Delta R`$
En faisant tendre $`r\rightarrow\infty`$, on retrouve, pour un observateur proche
d'une partie du tore, la géométrie du solénoïde infini, et les résultats qui vont
avec.
