---
title: 'Gauss local distribution cylindrique'
published: true
routable: true
visible: true
lessons:
    -
        slug: electrostatics-cylindrical-charge-direct-gauss-integral-local
        name: PARALLÈLE : Comparaison calcul direct, Gauss intégral et local
        order: 3
    -
        slug: gauss-local-cylindrical-symmetry-3-linear
        name: LINÉAIRE : Symétrie cylindrique avec Gauss local
        order: 2
    -
        slug: plane-cylindrical-spherical-distribution-gauss-local
        name: PARALLÈLE : Gauss local : charges planes, cylindriques et sphériques
        order: 2
    -
        slug: gauss-local-cylindrical-symmetry-3-method
        name: LINÉAIRE : De Gauss local aux charges à symétrie de révolution
        order: 2  
    -   
        slug: gauss-theorem-cylindrical-symmetry-3
        name: "PARALLÈLE : Symétrie cylindrique, Gauss intégral et local"
        order: 3
    -  
        slug: gauss-local-cylindrical-symmetry-3-mathtool
        name: OUTIL-MATH : Gauss local et charges cylindriques
        order: 2
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Lecture under construction*, **not validated**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-EN_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Stage 3 : in writing : 1/3</summary>  
1. Brainstorming
2. In structuring
3. In writing : 1/3
4. In writing : 2/3
5. In writing : 3/3
6. Under review
7. Tested with students
8. Validated, still incomplete
9. Validated, sufficient basis
10. Validated, operational, in constant improvement
</details>

<!--MétaDonnée : ... -->

##### Foothills pathway :&nbsp; _Physics, applied mathematics_

---------------------------

##### Application of the **Local Gauss** theorem to 


### **Cylindrical symmetry charge distributions**

#### Comment sont-elles définies ?

* Ici définie, une distribution de charge à symétrie cylindrique *possède* deux symétries,
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.

* Tout **plan contenant l'axe de révolution** est *plan de symétrie* pour la charge électrique.

#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.

#### Comment caractériser un distribution de charges à symétrie cylindrique ?

* La distribution de charges est décrite par une **densité de charge $`\dens=\dens(\rho,\varphi,z)`$**.
<br>
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel}\dens= \dens(\rho,\xcancel{\varphi}, z)`$**.
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\dens= \dens(\rho,\varphi, \xcancel{z})`$**.
<br>
* *Au final*, la densité volumique de charge **$`\dens`$ ne dépend que de z** :   
*$`\mathbf{\left.\begin{array}{l}
\dens=\dens\,(\rho, z) \\
\dens=\dens\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\dens=\dens(\rho)}`$**

<br>

![](electrostatics-gauss-cylindrical-charge-distribution-1-v7_L1200.gif)
_Un cylindre infini est, lorsqu'il est chargé uniformément en volume, l'exemple le plus simple de distribution de charge à symétrie cylindrique. Corriger_ $`\vec{e_r}`$ _en_ $`\vec{e_{\rho}}`$.


#### De quelles coordonnées dépend  $`\overrightarrow{E}`$ ?

* **L'effet** possède les *invariances de sa cause* :   
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{E}}`$** possède les *invariances de $`\dens`$*   

* $`\mathbf{\dens=\dens(\rho)\Longrightarrow}`$**$`\mathbf{\overrightarrow{E}=\overrightarrow{E}(\rho)}`$** 

#### Comment déterminer la direction de $`\overrightarrow{E}`$ ?

* *Par l'* **étude des symétries** *de la distribution de charges $`\dens`$*.

![](electrostatics-gauss-cylindrical-charge-distribution-2-v7_L1200.gif) 
_figure temporaire à réviser : corriger_ $`\vec{e_r}`$ _en_ $`\vec{e_{\rho}}`$. _Remplacer_ $`\mathscr{P}_2`$ _par_ $`\mathscr{P}_0`$. _En effet, pour le point suivant, nous réserverons la notation_ $`\mathscr{P}_i`$ _avec_ $`i\in\mathbb{N}^*`$ _aux plans contenant l'axe_ $`Oz`$. _Rajouter la notation $`\Delta`$ pour l'axe_ $`Oz`$.

<!-------------------------------------------------------
* **$`\overrightarrow{E}`$** est un *vecteur polaire*.
* *$`\mathbf{\mathcal{P}_1=}`$* **$`\mathbf{\mathcal{P}_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})}`$** est *plan de symétrie* pour  $`\dens`$.
* *$`\mathbf{\mathcal{P}_2=}`$* **$`\mathbf{\mathcal{P}_2\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})}`$** est *plan de symétrie* pour  $`\dens`$.
* *$`\mathbf{\mathcal{P}_1\cap\mathcal{P}_2=\mathcal{D}(M, \overrightarrow{e_{\rho}})}`$* 
------------------------------------>

* **En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie} \\
P_2\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})\; \text{plan de symétrie}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**   
<br>
_et donc future écriture quand la figure sera modifiée :_  
*$`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
P_0\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})\; \text{plan de symétrie} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie} \\
\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**  


#### Comment s'exprime  $`\overrightarrow{E}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\dens`$ :   
**En tout point $`M`$** de l'espace,   
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{E}=\overrightarrow{E}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}}}`$**

#### Y-a-t'il des lieux où $`\overrightarrow{E}`$ est déjà totalement déterminé par les symétries et invariances ?

_figure à joindre_

**En tout point $`M\in Oz`$** :
* $`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
\exists P_1\mid P_1\supset Oz  \text{ , plan de symétrie} \\
\exists P_2 \ne P_1 \mid P_2\supset Oz  \text{ , plan de symétrie}
\end{array}\right\}\,\Longrightarrow`$**$`\mathbf{\overrightarrow{E}=E_z\,\overrightarrow{e_z}}`$**

* $`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
P_0\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})\; \text{plan de symétrie} \\
\end{array}\right\}\,\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}+E_{\varphi}\,\overrightarrow{e_{\varphi}}}`$**

* $`\left.\begin{array}{l} 
\overrightarrow{E}=0\,\overrightarrow{e_{\rho}}+ 0\,\overrightarrow{e_{\varphi}}+E_z\,\overrightarrow{e_z} \\
\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}+E_{\varphi}\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}
\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{E}=0\,\overrightarrow{e_{\rho}}+ 0\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}=\overrightarrow{0}}`$** 

Donc **par raisons de symétries**, le *champ électrique *est *nul en tout point de l'axe de révolution $`Oz`$* :   
<br>
**$`\mathbf{\overrightarrow{E}(\rho=0) = \overrightarrow{0}}`$**


#### Quelle expression de la divergence de  $`\overrightarrow{E}`$ choisir ?

* L'étude se réalise dans le repère cylindrique  $`(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, z)`$

* $`\Longrightarrow`$ nous choisissons l'*expression en coordonnées cylindriques* de la divergence  :   
<br>
**$`\mathbf{div\overrightarrow{E}=
\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}
+\dfrac{\partial\,E_z}{\partial\,z}}`$**

#### Qu'implique la direction de $`\overrightarrow{E}`$ ?

* L'étude des symétries de la distribution de charge implique en tout point de l'espace :    **$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**

* $`\Longrightarrow`$ les autres composantes de champ *$`\mathbf{E_{\varphi} \text{ et } E_z}`$ sont nulles* en tout point de l'espace :
<br>
$`\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}=E_{\rho}\,\overrightarrow{e_{\rho}}+0\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}`$
  **$` \Longrightarrow\left\{
\begin{array}{l}
\mathbf{E_{\varphi}=0} \\
\mathbf{ E_z=0}
 \end{array}
 \right.`$**
 
* Si $`\mathbf{E_{\varphi}=E_z=0}`$ en tout point de l'espace $`\mathscr{E}`$, alors leur valeur nulle ne varie pas d'un point à un autre point voisin par translation élémentaire $`dz`$ ou variation élémentaire d'angle $`d\varphi`$. Donc *les dérivées partiellles de $`\mathbf{E_{\varphi}\text{ et }E_z}`$ par rapport à $`\mathbf{z\text{ et }\varphi}`$ sont nulles*.   
$`\mathbf{\forall M \in \mathscr{E}\, , E_{\varphi}=E_z=0}`$
  **$` \Longrightarrow\left\{
\begin{array}{l}
\mathbf{\dfrac{\partial E_{\varphi}}{\partial\varphi}=0 \;\;\text{ et } \;\;\dfrac{\partial E_{\varphi}}{\partial z}=0} \\
\mathbf{\dfrac{\partial E_z}{\partial\varphi}=0 \;\;\text{ et } \;\;\dfrac{\partial E_z}{\partial z}=0}
 \end{array}
 \right.`$**
 
* $`\Longrightarrow`$ l'expression de *la divergence de $`\overrightarrow{E}`$ se simplifie* en tout point de l'espace :   
**$`\mathbf{div\overrightarrow{E}}`$**
$`\require{\cancel}=\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\xcancel{\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}}
+\xcancel{\dfrac{\partial\,E_z}{\partial\,z}}`$
**$`\mathbf{\quad\quad=\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}}`$**


#### Qu'impliquent les invariances de  $`\overrightarrow{E}`$ ?

* L'étude des invariances de la distribution de charge implique en tout point de l'espace :   **$`\mathbf{\overrightarrow{E}=\overrightarrow{E}(\rho)}=E_{\rho}(\rho)\,\overrightarrow{E_\rho}`$** 

* Dans l'espression $`\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}`$, le terme **$`\rho\,E_{\rho}(\rho)`$** est une **fonction de la seule coordonnée $`\rho`$**. l'opérateur de *dérivée partielle* $`\dfrac{\partial}{\partial\,\rho}`$ peut être *remplacée par* l'opérateur de *dérivée totale* $`\dfrac{d}{d\rho}`$.

* $`\Longrightarrow`$  la divergence de $`\overrightarrow{E}`$ se réécrit :   
**$`\mathbf{div\overrightarrow{E}=\dfrac{1}{\rho}\cdot\dfrac{d\left(\rho\,E_{\rho}\right)}{d\rho}}`$**

#### Comment remonter à l'expression de $`\overrightarrow{E}`$ ?

* $`div\overrightarrow{E}=\dfrac{1}{\rho}\cdot\dfrac{d\left(\rho\,E_{\rho}\right)}{d\rho}`$ permet l'*écriture de la différentiel $`d\left(\rho\,E_{\rho}\right)`$* de la fonction $`\rho\,E_{\rho}`$ sous la forme :   
<br>
**$`\mathbf{d\left(\rho\,E_{\rho}\right)=\rho\,div\overrightarrow{E}\cdot d\rho}`$**

* L'*intégration de $`d\left(\rho\,E_{\rho}\right)`$ entre $`\rho=0`$ et $`\rho_M`$*, $`M=M(\rho_M\,,\varphi_M\,, z_M)`$ étant un point quelconque de l'espace donne :   
<br>
**$`\displaystyle\mathbf{\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)=\rho_M\,E_{\rho}(\rho_M)-0\times E_{\rho}(0)}`$**

* **par raisons de symétries**, *$`\mathbf{\overrightarrow{E}}`$ est nul sur l'axe $`\mathbf{Oz}`$*,     
$`\overrightarrow{E}(\rho=0) = \overrightarrow{0} \Longrightarrow 0 \times E_{\rho}(0)=0`$,    
(il suffisait de montrer que le champ garde une valeur finie en $`\rho=0`$)  
<br>
$`\quad\Longrightarrow`$ **$`\displaystyle\mathbf{\rho_M\,E_{\rho}=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**

* Nous obtenons alors, *en tout point $`\mathbf{M=M(\rho_M\,,\varphi_M\,, z_M)}`$*,    
<br>
**$`\left\{\begin{array}{l}
\mathbf{\rho_M=0\Longrightarrow \overrightarrow{E}=\overrightarrow{0}} \\
\mathbf{\displaystyle\rho_M\gt 0 \Longrightarrow \overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)\cdot\overrightarrow{e_{\rho}}}
\end{array}\right.`$**

#### Comment faire le lien avec la distribution de charges puis en déduire $`\overrightarrow{E}`$ ?

* Calculer la champ électrique $`\overrightarrow{E}`$ revient à calculer une intégrale dont l'intégrande est la différentielle $`d\left(\rho\,E_{\rho}\right)`$ :    
<br>
$`\displaystyle\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)\cdot\overrightarrow{e_{\rho}}`$


* Cette différentielle s'exprime simplement en fonction de la divergence de $`\overrightarrow{E}`$, et le théorème de Gauss local relie cette divergence à la densité volumique de charge $`\dens^{3D}`$. Nous obtenons une *expression de $`d\left(\rho\,E_{\rho}\right)`$ en fonction de $`\dens^{3D}`$* :   
<br>
$`\left.\begin{array}{l}
d\left(\rho\,E_{\rho}\right)=\rho\,div\overrightarrow{E}\cdot d\rho \\
div\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}
\end{array}\right\}`$$`\Longrightarrow`$
**$`\mathbf{d\left(\rho\,E_{\rho}\right)=\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot d\rho}`$**

* Dès lors, l'intégration relie en chaque point le champ électrique local à la densité volumique de charge locale :
<br>
$`\left.\begin{array}{l}
\displaystyle\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)\cdot\overrightarrow{e_{\rho}}\\
d\left(\rho\,E_{\rho}\right)=\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot d\rho
\end{array}\right\}`$$`\Longrightarrow`$
**$`\displaystyle\mathbf{\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot\overrightarrow{e_{\rho}}}`$**

* **Ces résultats**   
    * Sur l'axe de révolution $`Oz`$ ($`\rho_M=0`$ :   
    $`\overrightarrow{E}=\overrightarrow{0}`$
    * Partout ailleurs :     
    $`\displaystyle\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot\overrightarrow{e_{\rho}}`$   
    <br>
   sont *commun à toutes les distributions* de charge à symétrie cylindrique invariantes par translation selon $`Oz`$.

* Le **calcul final de $`\overrightarrow{E}`$** nécessite de *connaître l'expression mathématique pour $`\mathbf{\dens^{3D}}`$* en chaque point de l'espace.    
<br>
$`\Longrightarrow`$ **différentes distributions de charge sont étudiées** *dans la suite de cette page*.

<br>

---------------------

#### **1 -** Cylindre infini de rayon $`R`$ chargé uniformément en volume

##### Description de $`\dens`$ :

* **$`\left\{\begin{array}{ll}
\rho\le R \Longrightarrow \dens^{3D}(\rho)=\dens^{3D}_0 = cste\gt 0 \\
\rho\gt R \Longrightarrow \dens^{3D}(\rho)= 0
\end{array}\right.`$**   

<!------------
* Nombre de sous-espaces complémentaires à prendre en compte : 2
   * sous-espace $`\mathscr{E}_{int}`$, caractérisé par $`\dens=\dens^{3D}_0`$ et tel que $`\rho\le R`$.
   * sous-espace $`\mathscr{E}_{ext}`$, caractérisé par $`\dens=0`$ et tel que $`\rho \gt R`$

*  L'*objectif final* est de calculer le champ électrique **$`\mathbf{\overrightarrow{E}}`$ en tout point $`\mathbf{M=(\rho_M\,\varphi_M\,z_M)}`$** de l'espace.
*  **2 cas sont à prendre en compte**, selon que le point *$`M`$ est situé à l'intérieur* $`(\rho_M\le R)`$ ou *à l'extérieur* $`(\rho_M\gt R)`$ du cylindre chargé de rayon $`R`$.


**Pour tout point $`\mathbf{M=M(\rho_M\,\varphi_M\, z_M)}`$** de l'espace, la synthèse des résultats donne :   
(ne pas oublier le facteur $`1\,/\,\epsilon_0`$)
----------->

<br>
**$`\large\text{Pour  }\mathbf{\rho_M = 0}`$** :    
L'étude des symétries nous a permis d'affirmer précédemment que :    
**$`\mathbf{\overrightarrow{E}(\rho=0) = \overrightarrow{0}}`$**
<br>

<br>
**$`\large\text{Pour  }\mathbf{0\lt \rho_M\le R}`$** :    
donc à l'*intérieur du cylindre chargé* mais hors axe de révolution :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\int_{\rho=0}^{\rho_M}\rho\,d\rho`$    
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\,\bigg[ \dfrac{\rho^2}{2}\bigg]_0^{\rho_M}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{\rho_M^2\,\dens_0^{3D}}{2\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)=\dfrac{\rho_M\,\dens_0^{3D}}{2\epsilon_0}
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{\rho_M\,\dens^{3D}_0}{2\,\epsilon_0}\,\overrightarrow{e_{\rho}}}`$**
<br>

<br>
**$`\large\text{Pour  }\mathbf{\rho_M\gt R}`$** :    
donc à l'*extérieur du cylindre chargé* :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\int_{\rho=0}^{R}\rho\,d\rho
+\int_{R}^{\rho_M}0\,d\rho`$   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\,\bigg[ \dfrac{\rho^2}{2} \bigg]_0^{R}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{R^2\,\dens_0^{3D}}{2\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)=\dfrac{R^2\,\dens_0^{3D}}{2\,\epsilon_0\,\rho_M}
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{R^2\,\dens^{3D}_0}{2\,\epsilon_0\,\rho_M}\,\overrightarrow{e_{\rho}}}`$**

<br>

---------------------

#### **2 -** Cylindre infini de rayon $`R`$ chargé non uniformément en volume

##### Description de $`\dens`$ :

* Prenons l'**exemple** de la distribution :

**$`\quad\left\{\begin{array}{ll}
\rho\le R \Longrightarrow & \dens^{3D}(\rho) = A\,\rho^2 \\
&\text{ avec }A = cste \gt 0 \\
\rho\gt R \Longrightarrow & \dens^{3D}(\rho)= 0
\end{array}\right.`$**   

<br>
**$`\large\text{Pour  }\mathbf{\rho_M = 0}`$** :    
L'étude des symétries nous a permis d'affirmer précédemment que :    
**$`\mathbf{\overrightarrow{E}(\rho=0) = \overrightarrow{0}}`$**
<br>

<br>
**$`\large\text{Pour  }\mathbf{0\lt \rho_M\le R}`$** :    
donc à l'*intérieur du cylindre chargé* mais hors axe de révolution :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\; A\,\rho^2}{\epsilon_0}\,d\rho`$    
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{A}{\epsilon_0}\int_{\rho=0}^{\rho_M}\rho^3\,d\rho`$   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{A}{\epsilon_0}\,\bigg[ \dfrac{\rho^4}{4} \bigg]_0^{\rho_M}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{A\,\rho_M^4}{4\,\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)\;=\dfrac{A\,\rho_M^3}{4\,\epsilon_0}   
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{A\,\rho_M^3}{4\,\epsilon_0}\,\overrightarrow{e_{\rho}}}`$**
<br>


<br>
**$`\large\text{Pour  }\mathbf{\rho_M\gt R}`$** :    
donc à l'*extérieur du cylindre chargé* :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**    
<br>
$`\displaystyle\hspace{2.6cm}=\int_{\rho=0}^{R}\dfrac{\rho\; A\,\rho^2}{\epsilon_0}\,d\rho
+\int_{R}^{\rho_M}0\,d\rho`$    
<br> 
$`\displaystyle\hspace{2.6cm}=\dfrac{A}{\epsilon_0}\int_{\rho=0}^{R}\rho^3\,d\rho`$  
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{A\,R^4}{4\,\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons au final :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)\;=\dfrac{A\,R^4}{4\,\epsilon_0\,\rho_M}   
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{A\,R^4}{4\,\epsilon_0\,\rho_M}\,\overrightarrow{e_{\rho}}}`$**

<br>

---------------------

#### **3 -** Cylindre infini creux de rayons intérieur $`R_{int}`$ et extérieur $`R_{ext}`$ 

<br>

---------------------

#### **4 -** Cylindre infini de rayon $`R`$ chargé uniformément en surface

* C'est, entre autre mais pas seulement,  le cas précédent dans la limite où $`R_{int}\longrightarrow R_{ext}=R`$)    
  $`\Longrightarrow \dens^{3D} \text{ est modélisée par } \dens^{2D} `$  
  
##### Description de $`\dens`$ :

* **$`\quad\left\{\begin{array}{ll}
\rho\lt R \Longrightarrow & \dens^{3D}(\rho) = 0 \\
\rho = R  \Longrightarrow & \dens^{2D}(\rho)=  \dens^{2D}_0=cst \ne 0 \\
\rho\gt R \Longrightarrow & \dens^{3D}(\rho) = 0 \\
\end{array}\right.`$**   




