---
title: Introduction à l'étude de l'instrumentation pour l'astronomie
published: true
routable: true
visible: false
lessons:
    - slug: introduction-instrumentation-for-astronomy-4
      name: LINÈAIRE : Introduction à l'instrumentation pour l'astronomie
      order: 1
---


### Instrumentation et représentation de l'Univers : <br>une approche historique

#### 1 - Le rôle de l'observation dans l'astronomie
<br>
Qui pourrait prétendre aujourd'hui que les représentations que les femmes et les hommes
se font de l'univers ne dépendent pas de l'instrumentation astronomique ? Comment ces 
images somptueuses de nébuleuses, de matière interstellaire ou de galaxies seraient-elles
entrées dans nos représentations du ciel sans les grands télescopes au sol ou dans l'espace,
équipés de récepteurs sophistiqués?  N'en a-t-il pas toujours été ainsi ? Poser la 
question est y répondre. 

Pourtant le rôle joué par l'observation dans l'acquisition des connaissances astronomiques 
est objet de débat. Cette question est à rapprocher du problème que gnoséologique traditionnel
sur la fonction des sens dans l'acquisition des connaissances humaines. 
<!--!!!!! *Terminologie : gnoséologie*
!!!!! À faire-->
Décliner sous de multiples formes, cette question est évoquée plaisamment par Jean de la Fontaine
dans sa fable "un animal dans la lune". 

> "Pendant qu'un philosophe assure
Que toujours par leur sens les hommes sont dupés,
Un autre philosophe jure
Qu'ils ne nous ont jamais trompés. 
Tous les deux ont raison ; ... "

et de poursuivre 

> "La raison décide en maîtresse.
Mes yeux, moyennant ce secours,
Ne me trompent jamais en me mentant toujours."
<!--
!! *Pour aller plus loin : Jean de la Fontaine*
!! A faire
-->

Cette approche dialectique de Jean de LA FONTAINE exprime une idée implicitement 
admise dans leur pratique par les astronomes modernes. C'est désormais un truisme 
que d'évoquer une action correctrice de la "raison", c'est à dire de présupposés 
théoriques pour "interpréter" une observation. C'est aussi une banalité que d'admettre 
que la mise en oeuvre des "sens", autrement dits "des observations" est une phase 
indispensable dans le processus d'acquisition des connaissances en astronomie. 
Ces choses n'ont pas toujours paru aussi claires.  Et aujourd'hui encore elles 
sont enjeu de débat philosophique ; même si les présupposés en la matière, largement
acceptés dans la pratique et souvent inconsciemment par la grande majorité de la communauté 
astronomique, constituent dans les faits le dépassement de la contradiction préconisée 
par Jean de la Fontaine !   

Cette situation est l'héritage d'une longue histoire de l'astronomie au cours de 
laquelle deux principaux courants d'idées se sont affrontés. Cet affrontement pris 
corps et se formalisa dès l'Antiquité grecque entre le IV<sup>ème</sup> et leVI<sup>ème</sup> 
siècle avant notre ère. Il a subsisté depuis en traversant toute l'histoire du monde occidental. 
L'un des courants établit que la perfection abstraite comme principe, premier 
ayant une nature divine. PLATON, illustre porte drapeau de se courant philosophique, précise par exemple :

> " ... le dieu, ayant décidé de former le Monde, le plus possible à la ressemblance 
du plus beau des êtres intelligibles et d'un Être parfait en tout, en a fait un Vivant unique ...".

Connaître le monde se réduit ainsi à rechercher la perfection abstraite, notamment
des nombres et des formes ; la démarche sera ainsi d'ordre théorique et/ou spéculatif
sans qu'à aucun moment n'apparaisse l'opportunité d'une confrontation à un autre type 
de réalité concrète (qui d'ailleurs n'existe pas vraiment dans cette conception du monde). 
Dans ce courant d'idées, l'instrumentation n'a pas sa place ; elle est inutile. 

L'autre courant d'idée peut être illustré par les propos de LUCRECE ou ceux énoncés 
un peu plus de deux siècles plus tôt par ÉPICURE. 

> "Le principe qui sera notre point de départ, c'est que rien, jamais, n'est engendré
de rien par l'effet d'un pouvoir divin".
 (LUCRECE, page 133 du livre de Marcel CONCHE,  édition de Mégare, 1990)

> "Rien ne vient du non-être ... l'univers a toujours été et sera toujours..." (EPICURE)

> "En quoi donc devraient-on avoir la plus grande foi que dans les sens ? S'il nous trompent, 
la raison pourra t'elle déposer contre eux, elle qui en est issue tout entière ?" (LUCRECE)

> "En étudiant la nature, il ne faut pas se conformer à des principes sans fondement 
et à des lois abstraites, mais être attentif à ce que suggèrent les phénomènes" 
(EPICURE, Lettre à Pythoclés sur les Météores)

Ce courant d'idées pose donc comme principe premier que l'univers existe indépendamment 
de la conscience que l'on peut en avoir. Pour le connaître, nous allons raisonner à partir 
des informations recueillies par "nos sens"("nos observations"). Il est clair que, 
dans ce courant d'idées, l'observation ou la mesure occupe une place centrale. 
Au point de faire dire  à KANT  dans sa "critique de la raison pure" : EPICURE ne
dépasse jamais, dans ces raisonnements, les limites de l'expérience. 

Mais reconnaissont à KANT l'honnêteté du doute, car il place une note correctrice dans sa déclaration :

> "Tel est l'opposition entre l'Épicurisme et le Platonisme. Chacun d'eux dit plus 
qu'il ne sait. Le premier encourage et fait avancer le savoir, mais au préjudice de 
l'intérêt pratique ; le second fournit à l'intérêt pratique mais [...]  tout ce dont
nous ne pouvons avoir qu'un savoir spéculatif, il permet à la raison de s'attacher 
à des explications idéalistes des phénomènes naturels et de négliger par rapport à 
eux l'investigation physique."

Sa note a été éclairante :

> "C'est, cependant, encore une question que celle de savoir si EPICURE a jamais
avancé ces principes en qualité d'affirmation objective. Si [...] il aurait montré 
en cela un esprit plus véritablement philosophique qu'aucun des sages de l'Antiquité, 
que dans l'explication des phénomènes, il faille procéder comme si le champ de la 
recherche n'était borné par aucune limite ni par aucun commencement du monde, qu'il
faille admettre la matière du monde comme elle doit l'être, si nous voulons en être 
instruit par l'expérience, que l'on ne doit rechercher d'autre origine des événements
que celle qui est déterminée par les lois immuables de la nature, et qu'enfin l'on ne
doive recourir à aucune cause distincte du monde, ce sont là, encore à présent, des
principes très justes, mais très peu observés, qui permettent d'étendre la philosophie 
spéculative..." (KANT,  Critique de la raison pure).

Ainsi se dessinent les conditions d'une démarche féconde qui permet de dépasser la 
contradiction entre l'acceptation de l'observation comme moment fondamental de la 
connaissance et la nécessité d'une représentation abstraite du phénomène étudié.

GALILEE illustre dans sa pratique le dépassement concret de cette contradiction, 
ouvrant par là l'ère de l'astronomie moderne en adoptant une démarche "scientifique".
À l'idée que le monde "est écrit en langage mathématique", GALILEE ajoute une activité
de développement instrumental. Il associe dans sa pratique de recherche,
1. l'usage concret d'une nouvelle instrumentation
2. l'approfondissement d'une pensée abstraite destinée à dépasser les apparences pour 
accéder aux lois essentielles des phénomènes réels.

Ce faisant, GALILEE intègre le courant de pensée, déjà formulé, confusément, par 
PYTHAGORE (qui place le nombre au noeud des descriptions de l'univers) avec l'autre 
courant, le matérialisme épicurien qui suppose l'existence de l'Univers indépendant
de notre conscience et place l'usage de nos sens (donc l'observation et/ou la mesure
et/ou l'expérimentation) sur le chemin de notre connaissance de l'univers. Ainsi,
contrairement à l'idéalisme philosophique de filiation platonicienne qui borne le 
champ de la connaissance à la spéculation abstraite, le matérialisme épicurien devient
fécond dès lors qu'il intègre et dépasse l'horizon de la simple observation (ou de la 
perception des sens) en accédant aux besoins de décrire la réalité par une théorie, 
si possible écrite "en langage mathématiques". C'est cette confrontation théorie/mesure 
qui fondent la démarche scientifique, notamment en astronomie. 

Une théorie, une description abstraite d'un phénomène ou d'un objet, ne deviennent 
"scientifiques" que si elles sont susceptibles d'induire une prévision (si possible quantitative) 
qui pourra ultérieurement être confronté à la réalité par l'observation/mesure/expérience.   
Cette confrontation sera un moment essentiel de la validation de la théorie ou de la 
description abstraite, moment essentiel mais pas élément exclusif de validation.
La validation d'une théorie passe toujours par diverses étapes dont l'ultime, le débat 
épistémologique (pluraliste) ne peut et ne doit pas être exclu. 

Ainsi, nous rencontrerons, tout au long de l'histoire de l'astronomie, l'affrontement 
entre ces deux grands courants. C'est cette polarisation qui crée le cadre des relations
établies tout au long de l'histoire entre le développement de l'instrumentation astronomique
et les représentations de l'univers. L'histoire de l'astronomie à l'histoire des relations 
multiples tissées entre les représentations de l'Univers et les mesures (ou observations)
accomplies grâce à une instrumentation en évolution. À un instant donné l'existence 
et la disponibilité d'une instrumentation ont toujours résulté de causes multiples : 
volonté des astronomes certes mais aussi des possibilités technologiques et surtout, 
de la capacité de disposer des ressources économiques nécessaires (avec tout ce que 
cela implique dans l'organisation sociale,  économique, politique et culturelle de la société). 
L'histoire de l'astronomie et de son instrumentation est éclairante à ce sujet. 
Elle permet de mettre en relation d'une part l'instrumentation et les représentations 
de l'univers, et d'autre part les activités de recherche (au sein desquels se développent 
l'instrumentation) et la société. 

<br>
<!--Comment aborder un cours sur "l' instrumentation pour l'astronomie"? La plupart des 
enseignements ou des ouvrages publiés sur cette question, limitent leur champ au 
traitement d'un nombre plus ou moins grand de problèmes que la _physique_ permet 
de résoudre et qui ont un rapport plus ou moins direct avec les instruments (ou le
plus souvent avec des méthodes de mesure).

Pourtant, pour l'étudiant de _physique_ qui aborde une formation destinée à le préparer
à la recherche en _astronomie_, la difficulté est grande de replacer chacun des problèmes
de physique dans le très vaste champ de l'instrumentation astronomique. Les problèmes 
rencontrés dans la pratique de l'astronomie, notamment pour sa composante instrumentale, 
ne sont pas tous solubles à l'instant où on pourrait le souhaiter et leur identification 
ne va pas toujours de soi. Enfin, l'instrumentation pour l'_astronomie_ se développe
toujours dans un champ d'activité humaine très vaste qui lui attribue un caractère 
multidimensionnelle très complexe. De ce fait, tout approche fondée exclusivement sur 
_la physique et les mathématiques_ ne pourra aborder une étude de l'instrumentation 
en astronomique qui prennent en compte toute sa complexité. En particulier dans la 
plupart des ouvrages publiés sur le sujet, la composante humaine pourtant essentielle, e
st occultée. Le but fixé dans notre approche est d'aborder de front la complexité de la question.
L'ambition est davantage d'identifier les problèmes que de les résoudre : pour beaucoup 
d'entre eux, notamment pour tous ceux qui peuvent être traités par la physique, 
des renvoies seront faits vers des ouvrages publiés. Les parties développées ou 
détaillées seront celles qui font défaut dans les publications disponibles ou 
qui sont apparues comme les plus chargés de lacunes dans les générations
d'étudiants rencontrés. 

Le parti pris est de traiter des concepts susceptibles de rendre compte de la réalité d
e l'instrumentation pour l'astronomie. Cette priorité mise, des conceptions seront des 
concessions seront faites, notamment avec la rigueur mathématique des calculs présentés. 
Ces derniers n'ont jamais un caractère bien original et le lecteur intéressé pourra 
toujours consulter les ouvrages de mathématiques adéquat. Un autre compromis a été 
recherché dans le choix des questions abordées. Ce choix résulte des lacunes constatées 
parmi les connaissances d'une douzaine de générations d'étudiants du DEA Toulouse. 
L'objectif de ce cours étant d'être utile, beaucoup de problèmes ou de domaine, 
généralement bien maîtrisés par les étudiants ont été omis ou simplement effleurés ; 
d'autres, même d'un niveau modeste et en principe déjà traités (en second cycle universitaire 
ou dans le cas d'autres cours) mais dans la maîtrise s'est avérée fragile, ont été abordés, parfois exhaustivement. Enfin, l'approche des questions n'a pas hésité à sortir des sentiers battus du standard universitaire. La raison est toujours autant pédagogique que philosophique. Pédagogique car des approches diverses sont toujours bénéfiques. Pour accéder à une meilleure compréhension. Philosophique car la volonté de se soustraire à un enseignement dogmatique doit enduire un comportement pratique ouvert et risqué. Plutôt que de vouloir transmettre un savoir constitué (c'est à dire un état des connaissances figé), ce cours à l'ambition d'aider les étudiants à se poser des questions sur la base de connaissances en évolution. Il leur appartiendra, ensuite, de les reformuler à leur convenance et de tenter d'y répondre en faisant appel aux connaissances acquises dans les autres cours, dans leurs études et leurs expériences personnelles.    
L'approche ici présentée tente d'être globalisante pour poser les problèmes ; son 
cheminement va du général au particulier, même si le général limite parfois la description 
à un niveau relativement superficiel et souvent abstrait.   
Les 5 questions fondamentales sous-jacentes, posées relativement à l'instrumentation 
à l'astronomie, sont :
* qu'est-ce que c'est ?
* de quoi c'est fait ?
* comment ça fonctionne ? 
* à quoi cela sert ? 
* Vers quoi cela évolue ? 

Il est très facile de répondre à ces quatre questions sur des exemples. Il est moins 
aisé de les aborder d'un point de vue général. Plutôt que de tenter des réponses 
séparées à chacune des questions, une démarche de mise en perspective historique 
a été préférée. Cette approche est apparue plus fructueuse, ne serait-ce que pour
appréhender les effets d'évolution indispensables pour préparer l'approche au problème
de l'avenir de l'instrumentation en astronomie. Or, c'est l'avenir qui occupe la place
centrale des préoccupations dès qu'il s'agit de formation...    
Enfin, notre approche c'est limité à l'instrumentation pour l'_astronomie_ 
du rayonnement électromagnétique.    
Elle est étroitement corrélée à l'essentiel des connaissances relatives à l'univers.
Dans le passé, l'étude des météorites et des Rayons Cosmiques (particules chargées ou
neutres, animées de vitesse dans les valeurs approchent parfois en ordre de grandeur 
celle de la lumière, $`c=299\,792\,458 \;m\,s^{-1}`$), a joué un rôle modeste,
comparativement à celui de l'astronomie électromagnétique. Au cours des dernières décennies, 
les sondages in situ des plasma spatiaux ont apporté beaucoup à la connaissance de la
magnétosphère terrestre et du milieu interplanétaire ; mais ces mesures ne concernent 
que le Système Solaire. Aujourd'hui la mesure des flux de neutrino est tout à fait intéressante,
mais son intérêt reste focalisé sur l'étendue plus précises des structures internes des 
étoiles ou des phénomènes d'explosion de supernova. La détection des zones gravitationnelles 
ouvre les perspectives d'une nouvelle astronomie tant les potentialités en ce domaine son
vastes : mais nous nous sommes encore aujourd’hui que dans des phases initiales de programmes
envisagés pour le siècle prochain.    
Aussi, nous paraît-il acceptable de borner, pour l'instant, l'étude de l'instrumentation
à celle de l'astronomie du rayonnement électromagnétique.
Afin d'alléger la lecture, trois types de renvois ont été systématiquement faits. Les références 
bibliographiques sont rejetés dans l'annexe A4 où elles ont été classées par chapitre. 
Chaque nom des grandes figures de l'astronomie fait l'objet d'une fiche ;  ces fiches sont 
classées par ordre chronologique dans l'annexe 1 ("fiches biographiques et séquentielles). 
La description de chaque type d'instruments et celle de quelques systèmes instrumentaux exemplaires 
ou récents a été renvoyée dans des fiches classées dans l'annexe A2. Quelques rappels de 
techniques mathématiques élémentaires sont indiquées dans l'annexe A3. Enfin, un lexique des 
mots clés a été rédigé et mis dans l'annexe A5 : ce lexique est d'importance car comme l'a écrit 
EPICURE dans sa lettre a Hérodote : "il faut savoir à quoi renvoie les mots afin que nous ayons 
une pierre de touche à laquelle rapporter les opinions... afin que les notions restées floues
ne nous rejettent pas dans l'incertitude... afin que nous ne parlions pas pour ne rien dire."

Enfin, le souci majeur qui a présidé à la réduction de secours et __la mise en relation__ 
d'éléments que la réalité rassemble mais que l'approche cloisonnée des disciplines dissocie 
(y compris au sein de la physique lorsque, par exemple, il faut passer de la photométrie à 
l'optique géométrique, puis à l'optique ondulatoire, puis à la physique quantique appliquée 
à l'étude des photons).  L'approche est donc délibérément multidimensionnelle au risque de
demeurer superficielle. Les sciences construisent des démarches, étayées par des présupposés
philosophiques : l'histoire de l'astronomie illustre superbement se fait. Pourtant, un prudent 
silence évite presque toujours d'afficher ces présupposés et de discuter cette mise en relation 
science/philosophie. Le risque a été pris de l'évoquer clairement en avançant sans masque. 
Au lecteur de corriger les biais qu'il ne manquera pas de discerner, et d'entreprendre un 
travail personnel pour penser par lui-même. 

Guy Serra

<br>
-->

#### 2 - L'astronomie et les préhistoires
<br>
Quand commence l'astronomie ? Sans doute il y a bien longtemps lorsque la pensée 
abstraite est devenue accessible aux femmes et aux hommes de la préhistoire. 
Encore qu'il faille se méfier des mots. L'astronomie de ses époques reculées n'avait 
de commun avec la nôtre que l'objectif de connaissance de l'univers ; cet univers 
pouvant souvent se réduire au ciel avec les phénomènes qui s'y déroulent. De plus, 
le mot "préhistoire" s'applique à des époques et des sociétés humaines qui ne possèdent
pas l'écriture. Autant dire que la préhistoire ne peut pas se réduire à un intervalle 
de temps dans une chronologie universelle de l'évolution humaine.   
Il n'y a pas une préhistoire, mais de nombreuses préhistoires dans certaines s'achève 
de nos jours. L'étude des sociétés préhistoriques quasi contemporaines montre toute la
richesse culturelle que de telles sociétés peuvent avoir. Malheureusement, l'absence 
d'écriture établit un certain type de limitation absolue dans l'acquisition et la 
perpétuation des connaissances. En particulier, le savoir va évoluer sans cesse en 
perdant la connaissance des états antérieurs. Aussi est-il très difficile, souvent 
impossible, de percevoir par exemple, quelles étaient les connaissances astronomiques
des sociétés préhistoriques de l'Europe occidentale. Certains chercheurs voient dans 
des monuments mégalithiques, comme celui de Stonehenge en Grande-Bretagne, des observatoires 
enregistrant les directions caractéristiques des solstices et des équinoxes. Si tel 
était le cas, le gigantisme dans l'instrumentation astronomique ne date pas d'aujourd'hui!
Mais il est bien difficile de conclure sur ce sujet, à cause de la pauvreté des informations
disponibles à ce jour.

Sans doute aussi, existait-il dans l'Amérique précolombienne des "observatoires" 
astronomique de pierre (Le Caracol de Chichen Itza au Yucatan ?)  permettant la mesure
d'angles formés par différentes directions des astres "visibles", dont les plus importants
étaient, d'évidence, le soleil et la lune. Il s'en est fallu de peu pour que nous 
puissions beaucoup mieux connaître cette "astronomie" et ses instruments puisque 
le peuple aztèque, par exemple, possédait une langue et un ensemble de signes constituant
une forme très archaïque d'écriture.  
Les Mayas avaient eux aussi, dès le V<sup>ème</sup> siècle, deux types d'écriture primitive.
Malheureusement les conquérants européens, dans leur volonté d'imposer le dogme chrétien, 
détruisirent la plupart des manuscrits mayas et aztèques dont beaucoup avaient, pour support,
des écorces d'arbres. Il ne reste aujourd'hui que des monuments de pierre dont une des fonctions
semble bien avoir été celle d'observatoires astronomiques ; des recherches sont en 
cours sur ce sujet. D'autres vestiges existent comme, par exemple, un objet en mosaïque, 
calendrier aztèque attestant une connaissance du temps corrélé au mouvement des astres.
Indépendamment de l'écriture, des gravures sur roche témoignent de l'intérêt que les 
êtres humains ont souvent porté au phénomène du ciel. Des symboles figurants la lune, 
le soleil et les étoiles ont été gravés sur de nombreux rochers depuis les Pyrénées 
jusqu'en Amérique du Nord. Mais l'interprétation de tous ces pictogrammes demeure 
problématique. Il faut attendre l'écriture pour accéder à un ensemble suffisant 
d'informations pour caractériser une "astronomie".
Ce n'est probablement pas un hasard si les trois foyers indépendants d'apparition 
de l'écriture coïncident parfaitement avec les trois sites où s'est accomplie,
quelques millénaires plutôt et de manière probablement indépendantes, la révolution
néolithique. 

Voici environ une dizaine de milliers d'années, des peuples se sédentarisent en Mésopotamie,
en tirant principalement leurs ressources d'une agriculture naissante. Cette révolution 
constitue le passage des sociétés préhistoriques paléolithiques (dont l'économie repose 
entièrement sur l'exploitation directe des ressources naturelles par la chasse, la pêche
et la cueillette) aux sociétés néolithiques déjà proches des civilisations protohistoriques.
<!--
!!!!! *Terminologie : préhistorique, protohistoriques, historique*    
!!!!! À faire.
-->
En moins d'un millénaire, cette révolution économique sociale et culturelle s'étend 
tout autour de la partie orientale du bassin méditerranéen, depuis la Grèce jusqu'à 
l'Egypte. Durant les deux millénaires suivants cette zone s'agrandit vers le Caucase
et les régions de l'actuel Bulgarie alors que, parallèlement et de manière probablement 
indépendante, la révolution néolithique s'opère en Amérique Centrale. Vers 5000 à 6000 ans 
avant notre ère, ce dernier foyer s'est étendu sur une bonne partie du Mexique actuel. 
Dans le même temps, sur notre continent, les civilisations néolitiques habitent 
désormais tout le pourtour de la Méditerranée, sur une frange de terre très étroite 
dans la partie occidentale, alors qu'à l'Est l'expansion atteint la vallée de l'Indus ; 
une autre zone traverse l'Europe de la mer Noire à la mer du Nord. Simultanément, 
et probablement encore une fois de manière indépendante, un troisième foyer de civilisation 
néolithique apparaît dans la plaine de Chine, le long du "fleuve Jaune" (Houang-Ho ou Huanghe,
ou encore Huang Hé). Il faudra encore 3,5 millénaires pour que dans cette vallée fertile
apparaissent l'écriture du chinois ancien. Une riche civilisation évoluera dans cette région,
de manière relativement autonome, pendant de très nombreux siècles. Une astronomie se
développera, avec des instruments et des représentations originales de l'univers. 
Sans doute, beaucoup de travail reste à faire pour comparer le cours de cet astronomie, 
très florissante à certaines époques, avec celle qui s'est développée depuis la Mésopotamie
ancienne jusqu'à l'Europe occidentale de la Renaissance, en passant par la Grèce antique
et l'Égypte. 

Mais revenons en arrière, vers la première moitié du quatrième millénaire avant notre ère.
Probablement dans les basses vallées de l'Euphrate et du Tigre, à proximité du Golfe
Persique les sumériens gravent des signes cunéiformes qui constituent la souche commune
la plus ancienne de la plupart des langues parlées et écrites en usage aujourd'hui
(exception faite de celles dérivant de la souche du chinois ancien). Avec l'apparition 
de l'écriture, des textes sont écrits qui fournissent quantité d'informations sur
cette civilisation.

<br>

#### 3 - L'astronomie et son instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; en Mésopotamie antique
<br>
Les premiers textes qui abordent des questions touchant à l'astronomie sont des environs 
du XVII<sup>ème</sup> siècle avant notre ère. S'il nous renseignent sur l'astronomie 
de l'époque, ils révèlent aussi un fond culturel, probablement hérité de civilisations
préhistoriques. Après la révolution néolithique va exister une représentation de l'univers
proche des apparences perceptibles par nos sens, en même temps que se développe une pensée
abstraite déjà très élaborée. Avec l'opiniâtre volonté de se libérer d'une soumission
aux forces aux occultes de la nature, la pensée humaine amorce dans la Mésopotamie 
ancienne un cheminement qui la conduira quelques siècles plus tard au rationalisme 
grec de l'Antiquité. Dans le même temps, le maintien de conceptions et de pratiques 
religieuses constitue le fond culturel à l'origine <!--de la Bible et--> des religions
monothéistes. Ainsi, la culture mésopotamienne est-elle à l'origine d'une double 
filiation contradictoire. Cette dualité se retrouve dans l'enchevêtrement de l'astronomie 
et de l'astrologie dans la Mésopotamie dans la Mésopotamie antique, qui se développe dans
la période allant de l'avènement de l'écriture (vers 3200 &plusmn; 200 ans) à la 
suprématie de la Grèce antique vers 600 &plusmn; 100 ans avant notre ère. 

La représentation de l'univers consiste en une boule creuse ayant deux hémisphères 
distinctes :  l'En haut correspondant au ciel, et l'En bas, déjà identifié à l'enfer.   
Les deux hémisphères sont séparés par une couche liquide, la mer au centre de laquelle
surnage la terre. La nature de la terre est distincte de celle des autres régions de
l'univers ; elle est l'habitat des êtres humains. Beaucoup de phénomènes, notamment
terrestres, restent mystérieux ; leurs occurrences ainsi que les forces qui semblent
les animer vont être soumises à l'action de divinités. À l'image des structures de
la société mésopotamienne, les divinités sont fortement hiérarchisées et une subtile
organisation du travail répartit les attributions de chacune. Les divinités demeurent
là où les humains ne sont pas : dans le ciel et dans l'enfer. L'intérêt qu'elles 
portent aux personnes humaines est occasionnel, même si il est clair que face à 
elles le statut de l'humain est conçu davantage comme celui d'un serviteur que d'un
être libre. Inventés et fabriqués par les dieux pour produire par leur travail les 
biens de consommation et d'usage, les êtres humains étaient en quelque sorte les 
employés des divinités. Celle-ci leur adressaient leurs consignes au travers de 
messages écrits corrélés toujours un phénomène occasionnel qui rompait la routine
quotidienne. Ainsi, l'écriture se faisait dans des objets accessibles dans l'environnement 
des êtres humains. Deux catégories d'objets existaient, celle des objets terrestres 
et celles des objets et phénomènes du ciel. De ce fait, le ciel était d'une sorte 
de tableau sur lequel tout changement devenait un message à décrypter, message dont
le contenu était une prescription pour l'avenir des humains. L'idée d'associer la 
lecture du ciel à une divination déterminant l'avenir, constitue probablement l'origine
principale de l'astrologie ; sa source remonte à la Mésopotamie antique. 

De fait, pour identifier le message divin, il convenait de faire la part des configurations
invariantes du ciel et donc sans intérêt, avec les changements porteurs d'information.
Deux types de besoin en résultaient : bien connaître le ciel invariant et assurer
une surveillance continue du ciel. Si le premier pouvait être comblé par des efforts
d'individus solitaires, le second nécessitait des moyens en personnel ! Il est probable 
aussi que, parallèlement à cette "logique de recherche" cohérente avec le système 
d'idées dominantes, la curiosité humaine tendue vers la volonté de mieux connaître 
pour mieux maîtriser son devenir a dû jouer un rôle non négligeable. Toujours est-il
qu'au premier millénaire avant notre ère la séquence zodiacale était identifiée. 
Les sept astres majeurs étaient repérés depuis longtemps : à côté du soleil (Shamash) 
et de la lune (Sîn), les cinq planètes majeures étaient connues : Vénus (Ishtar, 
nom de la déesse de l'amour), Jupiter ("l'astre blanc"), Mercure ("le mouflon"), 
Mars ("l'enflammé", sans doute à cause de sa couleur rouge perceptible à l’œil nu) 
et Saturne ("le constant"). Dès le milieu du second millénaire un "traité" était
publié ; il fut remanié et complété jusqu'au milieu du premier millénaire. Une mission 
des astres est identifiée comme devant définir et régler l'ordre du temps. Ainsi 
apparaît le besoin de connaître, donc de mesurer, le mouvement des astres, c'est-à-dire
l'évolution de la direction dans laquelle on les voit. Est-ce l'origine des premiers 
instruments d'astronomie connus de manière fiable? Toujours est-il qu'apparaît le
gnomon et les polos (voir l'axe "parallèle" de ce cours, partie "Instruments et
systèmes instrumentaux").

<br>

#### 4 - L'astronomie et son instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; dans la Grèce antique et l'Empire romain
<br>
Beaucoup d'auteurs accordent peu de place à la Grèce antique quand il 
s'agit de traiter de l'instrumentation pour l'astronomie. N'est-ce point le résultat 
d'une vision trop superficielle qui réduit l'instrumentation des objets inerte ?
Pourtant, des tables astronomiques mésopotamiennes des second et premier millénaires 
avant notre ère, aux compilations de Ptolémée (vers +150), que de chemin parcouru 
sur le plan des mesures du mouvement des astres, de leur précision et de leur interprétation!
On a aussi beaucoup limité l'astronomie grecque au spéculation de l'époque classique
(de - 500 à moins 300), sans doute à cause de l'éblouissement causé par PLATON et au 
poids du dogme aristotélicien qui pesa de manière hégémonique sur près de deux millénaires. 
Aujourd'hui encore l'influence de ce dogme persiste et il n'est pas rare de le voir surgir
à nouveau dans des pratiques de recherche contemporaines...   

Le monde grec, surtout si on s'intéresse principalement à la dimension culturelle, 
se définit davantage par un ensemble de caractères de civilisation que par une localisation 
géographique. On a coutume de distinguer une époque "archaïque" (de -800 à moins 500), 
une période "classique" (de -500 à -323) et une période "hellénistique" (de -323 
à la fin du premier siècle avant notre ère) avant la fusion définitive dans l'Empire romain.

Mais dès l'époque archaïque, la civilisation grecque ne saurait se limiter à une 
seule région de la péninsule des Balkans. Aux implantations insulaires et sur la côte 
occidentale de l'actuelle Turquie s'ajoutent très vite des colonies et cités-états 
en Italie du Sud, en Sicile, Sardaigne, sur les côtes provençales, catalanes, andalouses 
et africaines.  De fréquences échanges, commerciaux et de peuplement, s'opèrent très vite.
Ces mouvements ne feront que s'accroître, au point de constituer sous Alexandre (vers -330 / -340)
un immense "Empire" s'étendant des colonies de la Méditerranée occidentale à la vallée
de l'Indus, englobant dans cette "Grèce antique", par exemple, la Mésopotamie et l'Égypte.
Ainsi, la Grèce antique peut-elle être vue comme l'étape succédant à la riche civilisation
mésopotamienne, en englobant de très nombreuses contrées même si leur lien politique avec 
la Grèce proprement dite fut parfois ténu ou épisodique. Ainsi, par exemple, l'Égypte vécut
une réelle osmose culturelle avec les cités grecques même si des liens politiques de
fédération ou d'assujettissement n'existèrent seulement qu'à la fin de la période classique (- 332 / -330). 
Après cet épisode s'ensuivit une "indépendance" de l'Égypte sous le règne des Lagides qui apparaît, 
de fait, sur les plans respectivement économique et politique,  comme une réelle colonisation 
de ce pays par une minorité "grecque". L'époque qui commence vers la fin du III<sup>ème</sup> 
siècle avant notre ère fut extrêmement riche sur le plan culturel, très féconde en acquisition
de connaissances nouvelles. Les événements majeurs en astronomie se produisirent désormais
sur le sol égyptien et la capitale culturelle de la "Grèce antique" était devenue Alexandrie.

Le rayonnement de cette cité se perpétua d'ailleurs avec l'annexion de l'Égypte à 
l'Empire romain (-30) pour se prolonger encore pendant une demi-douzaine de siècles 
au moins. Il est vrai qu'en astronomie, l'Empire romain n'apporta pas un réel renouvellement 
des idées ni un élargissement notable des connaissances. Aussi, peut-on inscrire la culture 
astronomique des pays colonisés par Rome puis celle de tout l'Empire romain (à partir du 1er
siècle avant notre ère) dans le prolongement continu de l'astronomie "grecque". Il faut se
garder toutefois d'une vue trop réductrice sur cette période qui couvre plus d'un millénaire 
et qui se réfère à une zone géographique qui va bien au-delà du pourtour du bassin méditerranéen.
Surtout que ces civilisations connurent des époques très fécondes avec la simultanéité 
de représentations de l'univers diversifiées, et quelquefois franchement opposées. 

Dès le V<sup>ème</sup> siècle avant notre ère la pensée grecque, si elle reste fortement
influencée par les modèles de la Mésopotamie ancienne, marque très vite une rupture 
quant à la perception de la place des hommes dans la nature. Ainsi l'observation 
du ciel n'est plus motivée par la nécessité d'identifier le message des divinités,
mais bien plutôt par la volonté de connaître les lois auxquelles obéit le monde. 
Ces évolutions de la pensée humaine ont un ancrage essentiellement collectif. 
La pensée novatrice d'un individu isolé qui n'est pas relayée par une appropriation 
collective d'un groupe humain (pour la traduire ensuite, en actes concrets), reste 
en général sans lendemain ; elle disparaît dans l'oubli provisoire ou définitif. 
Dans le cas heureux ou le succès social d'une pensée individuelle s'affirme, un
autre problème apparaît : celui d'une reconnaissance de paternité ! Combien de
querelles et de polémiques ont entouré l'attribution de paternité pour les découvertes
importantes ! De sorte qu'il est toujours difficile d'affirmer que telle ou telle
personne est la première à avoir eu l'idée originale ou avoir accompli la découverte
marquante. 
La marche d'incertitude ne peut jamais s'annuler ;  elle s'accroît d'autant plus 
que notre regard se porte sur le passé. Au point que pour l'Antiquité, certains 
auteurs mettent même parfois en doute le fait qu'un supposé grand personnage ait 
pu exister. Il en est ainsi, par exemple, pour des auteurs dont l'oeuvre originale
supposée ne nous est pas parvenue. Nous ne la connaissons qu'au travers de citations
plus ou moins reformulées. Pourtant, il est commode de jalonnais l'évolution de
la pensée humaine par des noms célèbres qui marquent notre culture. Au fond, même
s'ils ne sont pas les créateurs originaux, même s'ils n'ont jamais existé, leurs 
noms restent attachés à une étape marquante de la connaissance ; ils deviennent 
une aide précieuse pour un repérage historique. Ainsi, pour THALES, la nature 
n'est pas soumise au pouvoir arbitraire des divinités (qui ont d'autres préoccupations !),
mais elle obéit à des lois qu'il faut désormais découvrir. L'objectif de la connaissance
du ciel s'est déplaçé vers une approche "rationnelle" primitive. Toutefois les
représentations de l'univers restent fortement marquées par celles de la Mésopotamie
ancienne. Pour ANAXIMANDRE le ciel est sphérique avec une Terre en forme de cylindre aplatie
(galette). Doit-on à ce penseur l'introduction dans la Grèce antique du gnomon connu 
des mésopotamiens ? Certains auteurs lui ont attribué aussi la première fabrication
du cadran solaire, quand d'autres considèrent que son origine vient d'Egypte. 

Un des élèves d'ANAXIMANDRE (lui-même élève de THALES) est le célèbre PYTHAGORE. 
Même si on ne lui doit pas le théorème qui porte son nom, ce penseur marque durablement
la pensée de son temps. Il est à l'origine de la structuration de référentiels toujours
en vigueur, comme par exemple les sept notes de la gamme chromatique (en référence 
au sept "planètes" ?), ou le mot COSMOS désignant le monde "ordonné" dans lequel
nous sommes. Dans le cadre d'un système de pensée philosophique et politique 
(autour duquel se constitua une sodalité idéologique qui persista à bien après sa mort),
PYTHAGORE identifia le nombre comme principe premier.  L'harmonie de la nature était vue
comme une sorte de reflet de l'harmonie des nombres. Cette idée forte toujours persistante
est probablement une des racines de la pensée de PLATON. PYTHAGORE apparaît bien comme
"l'inventeur" de cet argumentation qui conduit à placer la Terre sphérique au centre
d'un ciel lui aussi sphérique (en raison toujours de ce fameux principe d'harmonie). 
Ainsi, à partir d'arguments dont l'abstraction peut surprendre près de six siècles 
avant notre ère, l'hypothèse hardie (et contraire aux perceptions immédiates) d'une
Terre sphérique est avancée. La hardiesse de cette hypothèse ne se limite pas à une
question de forme, mais aussi au fait qu'une Terre sphérique doit "tenir en l'air".

Ce courant de la pensée astronomique se poursuit au début de la période classique
avec ANAXAGORE pour qui la Terre plate flotte dans l'air : même si les textes disponibles
disent peu de chose sur le sujet, on ne voit pas comment l'observation n'occuperait
pas une place réellement importante. ANAXAGORE semble bien avoir discerné la nature
des éclipses, et  explique que la Lune est éclairée par le Soleil. Avec METON un
effort de rationalisation du calendrier apparaît. C'est à PHYLOLAOS qu'on attribue
la première affirmation que la Terre n'est pas le centre du monde. Elle tourne en
24 heures dans le plan équatorial autour d'un gigantesque feu central. Les autres
astres tournent eux aussi, mais dans un autre plan (l'écliptique). La Lune est
toujours éclairée par le Soleil, lui-même réfléchissant la lumière du feu central. 
Il précise le phénomène des éclipses, et redécouvre peut-être la planète Saturne 
connue des mésopotamiens et de PYTHAGORE, mais qui avait semble-t-il été oubliée. 
Cette représentation atteste à la fois d'une pensée abstraite élevée et d'une réelle
base de connaissances résultant d'un effort persistant d'observation et probablement
de mesures des angles (pour discerner la différence des plans de rotation).

à suivre ...
<br>

#### 5 - L'astronomie et son instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; au Moyen Âge

<br><br>

#### 6 - Les révolutions de l'astronomie<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; à la Renaissance

<br><br>

#### 7 - L'astronomie et son instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; l'essor aux Temps modernes

<br><br>

#### 8 - La place de l'instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; dans l'histoire de l'astronomie

<br><br>

#### 9 - La place de l'instrumentation<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; dans l'astronomie d'aujourd'hui









