---
title: Synthèse
routable: false
visible: false
lessons:
    -
        slug: cylindrical-charge-or-current-distributions-integral
        name: PARALLÈLE : Distributions cylindriques de charges et de courants
        order: 3
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etape 3 : Ecriture : 1/3</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème d' **Ampère intégral** aux :


### **Distributions cylindriques de courant**

* Le terme **cylindrique** réfère à l'*aspect extérieur* de la distribution de courant.


#### Propriétés nécessaires au théorème d'Ampère

* Le théorème d'Ampère sera utilisable si une distribution cylindrique ... à terminer    

<!--ATTENTION : ce qui est ici en commentaire est probablement faux----------
de courant possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.
--------------------------------------------------------------------------->

#### Y a t-il plusieurs configurations vérifiant ces propriétés ?

* La cause du champ $`\overrightarrow{B}`$ étant vectorielle, *deux  configurations de* **courant** sont possibles. Le déplacement des charges peut s'effectuer :
   *  **en direction de l'axe de révolution** : c'est le cas d'un *fil électrique rectiligne* infini parcouru par un courant.   
      $`\Longrightarrow``$ tout plan contenant l'axe de révolution est plan de symétrie pour le courant.
   *  en **tournant circulairement autour de l'axe de révolution** : c'est le cas d'un *solénoïde* infini parcouru par un courant.   
      $`\Longrightarrow`$ tout plan contenant l'axe de révolution est plan d'anti-symétrie pour le courant.

----------------------

#### LES COURANTS S'ENROULENT AUTOUR DE L'AXE DE RÉVOLUTION <br><br> cas du solénoïde conducteur infini.

----------------------

#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.

#### Comment caractériser cette distribution de courant ?

![](magnetostatics_bobine_modelisations_1_L1200.gif)

* Dans le cas où la *section droite* du fil conducteur constituant le solénoïde est *négligée*, le **courant** est simplement décrit 
 par l'intensité *$`I`$* qui parcourt le solénoïde. Le **sens du courant** dans le solénoïde est *précisé par une flèche*.   
 _(en magnétostatique, le courant est constant, donc son sens ne varie pas au cours du temps)._

* Dans le cas contraire où la *section droite* est *non négligée*, le courant est décrit par un
 **vecteur densité de courant $`\overrightarrow{j}`$**.
<br>
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel} \overrightarrow{j} = \overrightarrow{j}(\rho,\xcancel{\varphi}, z)`$**.   
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\overrightarrow{j}= \overrightarrow{j}(\rho,\varphi, \xcancel{z})`$**.   
<br>
* *Au final*, le vecteur densité volumique de courant **$`\overrightarrow{j}`$ ne dépend que de z** :   
*$`\mathbf{\left.\begin{array}{l}
\overrightarrow{j}=\overrightarrow{j}\,(\rho, z) \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)}`$**


#### De quelles coordonnées dépend $`\overrightarrow{B}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{B}}`$** possède les *invariances de $`\overrightarrow{j}`$*

* $`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)\Longrightarrow}`$ **$`\mathbf{\overrightarrow{B}=\overrightarrow{B}(\rho)}`$**


#### Comment déterminer la direction de $`\overrightarrow{B}`$ ?

* *Par l'* **étude des symétries** *de la distribution de courant $`\overrightarrow{j}`$*.   
<br>
Que la distribution de courant soit modélisée par un courant $``I``$ parcourant le solénoïïde infini :

![](magnetostat-bobine-1-symetries-direction-B_v2_L1200.gif)

<br>
ou soit modélisée par un vecteur densité de courant $`\overrightarrow{j}`$ :

![](magnetostat-bobine-2-symetries-direction-B_L1200.gif)

1. Soit un **point $`M(\rho_M\,\varphi_M,z_M)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et perpendiculaire à l'axe $`Oz`$ est *plan de symétrie* pour la distribution de courant.
3. Le champ magnétique **$`\overrightarrow{B}`$ étant un vecteur axial**, en tout point d'un plan de symétrie 
   il est perpendiculaire à ce plan. Le plan de symétrie $`P_1`$ étant déterminé, la
   *direction de $`\overrightarrow{B}`$, selon $`\overrightarrow{e_z}`$*, est 
   *totalement déterminée*.
4. _Étape non nécessaire :_    
_Le plan_ $`P_2`$ _qui contient le point $`M`$ et l'axe $`Oz`$ est_
 _plan d'anti-symétrie pour la distribution de courant. En tout point d'un plan_
_d'anti-symétrie, $`\overrightarrow{B}`$ vecteur axial est contenu dans ce plan, ce qui est bien vérifié._   


* De façon plus concise :   
<br>
**En tout point $`M`$** l'espace,   
*$`\left.\begin{array}{l} \overrightarrow{B}\;\text{vecteur axial} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}})\; \text{plan de symétrie}\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{B}=B_z\,\overrightarrow{e_z}}`$**
<br>

#### Comment s'exprime $`\overrightarrow{B}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\overrightarrow{j}`$ :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{B}=\overrightarrow{B}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{B}=B_z\,\overrightarrow{e_z}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{B}=B_z(\rho)\,\overrightarrow{e_z}}`$**



#### Y-a-t'il des lieux où $`\overrightarrow{B}`$ est déjà totalement déterminé par les symétries et invariances ?

à faire


#### Quel contour d'Ampère $`\Gamma_A`$ choisir ?

* Le **contour d'Ampère $`\mathbf{\Gamma_A}`$** doit :
   * être une *ligne fermée*.
   * *contenir le point $`M`$* quelconque.
   * permettre un *calcul simple de $`\displaystyle\oint_{\Gamma_A} \overrightarrow{B}\cdot \overrightarrow{dl}`$*.

<br> 
![](magnetostatics-solenoid-ampere-contour_v2_L1200.gif)   
<br>

* *Choix de $`\mathbf{\Gamma_A}`$* : un **rectangle ABCD**   
   * inscrit *dans le* **plan** qui **contient de point $`M`$** et **l'axe $`Oz`$**.
   * dont deux **branches BC et DA** sont *parallèles à l'axe $`Oz`$* et de *longueur $`h`$*,  
     $`\Longrightarrow`$ sur ces branches, $`\overrightarrow{dl} \parallel \overrightarrow{B}`$   
     $`\Longrightarrow\quad\overrightarrow{dl} \cdot \overrightarrow{B}=\pm\, B\,dl`$   
   * et les deux autres **branches AB et CD** ont la *direction de $`\overrightarrow{e_{\rho}}`$*,   
     $`\Longrightarrow`$ sur ces branches, $`\overrightarrow{dl} \perp \overrightarrow{B}`$   
     $`\Longrightarrow\quad\overrightarrow{dl} \cdot \overrightarrow{B}=0`$    
   *  La branche **DA contient le point $`M`$** considéré, et est donc située à la distance *$`\boldsymbol{\rho_{DA}=\rho_M}`$* de $`Oz`$.
   * La branche **BC** est **rejetée à distance infinie** de $`Oz`$,    
     *$`\boldsymbol{\rho_{BC}\longrightarrow\infty}`$*,   
     où le champ magnétique est postulé nul : *$`\displaystyle\lim_{\rho_{BC}\rightarrow\infty}\overrightarrow{B}=\overrightarrow{0}`$*   
$`\Longrightarrow\quad\overrightarrow{dl} \cdot \overrightarrow{B}=0`$   

! *Remarque*   
! Le fait de considérer le champ magnétique nul à distance infinie de l'axe de révolution
! se déduit du champ magnétique créé dans tous l'espace par une bobine torique idéale.
! En effet l'étude de ce cas avec le théorème d'Ampère qui démontre un champ magnétique nul en tout point
! à l'extérieur de la bobine torique, a été conduite sans aucune condition restritive sur $`R_1`$ et $`R_2`$, 
! respectivement valeurs des rayons intérieur et extérieur du tore.   
! Un solénoïde infini de rayon $`R`$ peut s'interpréter comme le cas limite d'une bobine torique où les
! rayons $`R_1`$ et $`R_2`$ tendent tous deux vers l'infini, en gardant constant la différence $`R_2 - R_1 = R`$.   
! Il serait possible d'en déduire que le champ magnétique est nul en tout point à l'extérieur du solénoïde, résultat
! que nous allons retrouver à partir du postulat $`\displaystyle\lim_{\rho_{BC}\rightarrow\infty}\overrightarrow{B}=\overrightarrow{0}`$.


#### Que signifie orienter le contour d'Ampère $`\Gamma_A`$ choisi ?

* orienter signifie **donner un sens "positif" de circulation**, *indiqué par une flèche* sur le contour.

* Ce sens positif **fixe le sens des vecteurs déplacement élémentaire $`\mathbf{\overrightarrow{dl}}`$ ** le long du contour : .   
  <br>
  figure explicative à faire.


#### Le choix de l'orientation est-il important ?

* Ne pas oublier d'**orienter le contour d'Ampère** est *important*.

* Choisir **un sens plutôt que l'autre** n'a *pas d'importance*.   
  <br>
  En effet :   
  * le théorème d'Ampère est une égalité entre 2 membres :   
  $`\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\,\oiint_{\mathscr{S}_A}\overrightarrow{j}\cdot\overrightarrow{dS}`$
  * Les orientations de $`\overrightarrow{dl}`$ et $`\overrightarrow{dS}`$ sont liées.
  * Changer le sens de $`\overrightarrow{dl}`$ changera aussi le sens de $`\overrightarrow{dS}`$.   
    Cela revient à multiplier par $`-1`$ chaque membre de l'égalité,    
    ce qui ne modifie pas la solution de l'équation.


#### Que vaut la circulation de $`\overrightarrow{B}`$ le long de $`\Gamma_A`$ ?

* Le **signe** devant l'expression finale contenant $`B_{\varphi}(r)`$ *dépend de l'orientation choisie* sur $`\mathbf{\Gamma_A}`$
* Dans ce cas où la contour $`\mathbf{\Gamma_A}`$ est un rectangle ABCD, il suffit d'indiquer le sens positif choisi sur l'une des quatres branches pour
  déterminer totalement le sens de parcours sur tout $`\mathbf{\Gamma_A}`$. 

<br>
![](magnetostatics-solenoid-ampere-sens-contour_L1200.gif)   
<br>

  Choisissons par exemple la branche DA qui contient le point $`M`$ :

* Si **$`\mathbf{\;\overrightarrow{dl}_{DA}=+\,dz\,\overrightarrow{e_z}}`$** :
 <br><br>
 **$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$**    
 <br>
   $`\displaystyle\quad\quad=\int_{DA} \overrightarrow{B}(\rho_{DA})\cdot\overrightarrow{dl}_{DA} + \int_{AB} \underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{AB}}_{\color{blue}{\quad\;=\,0\\car\,\vec{B}\,\perp\,\vec{dl}_{AB}}}`$    
   $`\displaystyle\quad\quad\quad +\int_{BC} \underbrace{\overrightarrow{B}(\rho_{BC})}_{\color{blue}{=\,\vec{0}}}\cdot\overrightarrow{dl}_{BC} + \int_{CD}\underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{CD}}_{\color{blue}{\quad\;=\,0\\car\,\vec{B}\,\perp\,\vec{dl}_{CD}}}`$   
 <br>
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{En se rappellant que :}}}`$
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{invariances + symétries }\Longrightarrow \vec{B}=B_z(\rho)\,\vec{e_z}}}`$   
 <br>
 $`\quad\quad\displaystyle = \int_{DA}\big(B_z(\rho_{DA})\,\overrightarrow{e_z}\big)\cdot\big(dz\,\overrightarrow{e_z}\big)`$   
 <br>
 $`\quad\quad\displaystyle = \int_{DA}\;B_z(\rho_{DA})\,\big(\overrightarrow{e_z}\cdot\overrightarrow{e_z}\big)\,dz`$   
 <br>
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{Le sens de parcours est indiqué}}}`$
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{par l'ordre des bornes d'intégration}}}`$   
 <br>
 $`\quad\quad\displaystyle  = \int_{z=z_0}^{z=z_0+h} B_z(\rho_{DA})\,dz`$  
 <br>
 $`\quad\quad\displaystyle  = \Big[ B_z(\rho_{DA})\times z\Big]_{z_0}^{z_0+h}`$   
 <br>
 $`\quad\quad\color{blue}{\scriptsize{\quad M\in [DA]\;\Longrightarrow \;\rho_{DA}=\rho_M}}`$  
 <br>
 **$`\quad\quad\displaystyle\mathbf{\boldsymbol{ = h\; B_z(\rho_M)}}`$** 

<br>
* Si *$`\mathbf{\;\overrightarrow{dl}_{DA}=-\,dz\,\overrightarrow{e_z}}`$* :
 <br><br>
 *$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$*    
 <br>
 $`\displaystyle\quad\quad=\int_{DA} \overrightarrow{B}(\rho_{DA})\cdot\overrightarrow{dl}_{DA} + \int_{AB} \underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{AB}}_{\color{blue}{\quad\;=\,0}}`$    
 $`\displaystyle \quad\quad\quad +\int_{BC} \underbrace{\overrightarrow{B}(\rho_{BC})}_{\color{blue}{=\,\vec{0}}}\cdot\overrightarrow{dl}_{BC} + \int_{CD}\underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{CD}}_{\color{blue}{\quad\;=\,0}}`$   
 <br>
 $`\displaystyle\quad\quad = \int_{DA}\big(B_z(\rho_{DA})\overrightarrow{e_z}\big)\cdot\big(-\,dz\,\overrightarrow{e_z}\big)`$   
 <br>
 $`\displaystyle\quad\quad = \int_{z=z_0+h}^{z=z_0} B_z(\rho_{DA})\,dz`$  
 <br>
 $`\displaystyle\quad\quad = \Big[ B_z(\rho_{DA})\times z\Big]_{z_0+h}^{z_0}`$   
 <br>
 *$`\displaystyle\quad\quad\mathbf{\boldsymbol{ = -\, h\; B_z(\rho_M)}}`$*




#### Quelle surface ouverte $`\mathscr{S}_A`$ s'appuyant sur $`\Gamma_A`$ choisir ?


##### 1 - Le courant est représenté par $`j^{3D}`$

* La **surface d'Ampère $`\mathscr{S}_A`$** doit :
   * être une *surface ouverte s'appuyant sur le contour d'Ampère $`\Gamma_A`$*.
   * permettre un *calcul simple de $`\displaystyle\oiint_{\mathscr{S}_A} \;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}`$*.

<br>
![](magnetostatics-solenoid-ampere-j-surface_v2_L1200.gif)   
<br>

* *Choix de $`\mathbf{\Gamma_A}`$* : la **portion de plan** *qui s'appuie sur le rectangle ABCD*,   
  $`\Longrightarrow \forall M\in \mathbf{\Gamma_A}, \overrightarrow{dS}_M = \pm\; d\rho\,dz\,\overrightarrow{e_{\varphi}}`$   
  *$`\displaystyle\Longrightarrow\;\forall M\in\mathscr{S}_A\,,\;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm\; j^{3D}\,dS`$*   
   ($`+`$ ou $`-`$ selon l'orientation du rectangle plein $`\mathscr{S}_A`$).

!!!! *Attention*   
!!!!
!!!! Dans cette distribution de courant, $`\mathbf{\boldsymbol{\overrightarrow{j^{3D}}=j_{\varphi}^{3D}(\rho)\,\overrightarrow{e_{\varphi}}}}`$.   
!!!!
!!!! *Dans l'espression* $`\mathbf{\boldsymbol{\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm\; j^{3D}\,dS}}`$, *ne pas confondre*
!!!! * $`\mathbf{j^{3D}}`$ : composante de $`\overrightarrow{j^{3D}}`$ selon $`\overrightarrow{e_{\varphi}}`$ qui peut être positive ou négative selon le sens du courant.    
!!!! *avec*    
!!!! * $`\mathbf{\Vert \,\overrightarrow{j^{3D}} \,\Vert}`$ : norme du vecteur $`\overrightarrow{j^{3D}}`$ qui est toujours positive.


##### 2 - Le courant est représenté par $`I`$ 

* Toute surface qui s'appuie sur le rectangle ABCD convient,   
  Il faudra juste faire la somme algébriques des intensités $`\overline{I}`$ qui traversent la surface choisie.

* Mais le **rectangle plein ABCD** reste le *choix le plus simple* et judicieux.

<br>
![](magnetostatics-solenoid-ampere-I-surface_L1200.jpg)   
<br>




#### Comment orienter $`\mathscr{S}_A`$ ?

* Les **orientations du contour et de la surface** d'Ampère associée sont *couplées par la règle de la main droite*.



* Donc l'orientation du rectangle plein $`\mathscr{S}_A`$ dépend de l'orientation choisie sur le rectangle $`\Gamma_A`$ ,   


##### 1 - Le courant est représenté par $`j^{3D}`$

* **$`\mathbf{\overrightarrow{dS}=\,+\,d\rho\,dz\,\overrightarrow{e_{\varphi}}\Longleftrightarrow\overrightarrow{dl}_{DA}=+\,dz\,\overrightarrow{e_z}}`$**  
   $`d\rho`$ et $`dz`$ représentant des accroissements élémentaires ($`d\rho > 0`$ et $`dz > 0`$).

<br>
![](magnetostatics-solenoid-ampere-j-sens-direct-surface_L1200.gif)   
<br>

* *$`\mathbf{\overrightarrow{dS}=\,-\,d\rho\,dz\,\overrightarrow{e_{\varphi}}\Longleftrightarrow\overrightarrow{dl}_{DA}=-\,dz\,\overrightarrow{e_z}}`$*   
   $`d\rho`$ et $`dz`$ représentant des accroissements élémentaires ($`d\rho > 0`$ et $`dz > 0`$).
   <br>
image
   <br>



#### Quelle expression simple du théorème d'Ampère obtient-on alors ?





à faire

A TERMINER avec différents cas.



