---
title: Properties of the conservative vector fields
published: false
routable: false
visible: false
lessons:
    - slug: gauss-ampere-theorems-demonstration
      name: PARALLÈLE : Les bases pour physiciens au niveau contreforts
      order: 1
---


<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!------Commentaire----------------------------
!  *Thème* :<br>
! *Electrostatique / Démonstration du théorème de Gauss, forme intégrale et forme locale*<br>
! Guide pour établir les 3 parties : main, overview, beyond<br>
!
!  (_précède le thème : Electrostatique : Application du théorème de Gauss, forme intégrale et forme locale._)
----------------------------------------------->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------

### MÉCANIQUE NEWTONIENNE : ÉNERGÉTIQUE


#### Définitions et propriétés<br>**Gradient**<br>**Champs vectoriels conservatifs**

#### Définitions, énoncé et démonstration<br>**Potentiel et énergie potentielle**<br>**Énergie cinétique**<br>**Théorème de conservation de l'énergie mécanique**

<br>

GRADIENT  D'UN  CHAMP SCALAIRE<br>_" du champ scalaire au champ vectoriel "_
: ---

  *Définition du gradient* :
  
  Soit $`\phi`$ un champ scalaire.   
  En un point quelconque de l'espace, un déplacement élémentaire $`\overrightarrow{dl}`$ induit
  une variation élémentaire $`d\phi`$ de la valeur du champ.   
  
  Le vecteur $`\overrightarrow{grad}\,\phi`$ réalise ne lien entre $`d\phi`$ et $`\overrightarrow{dl}`$ au point considéré :
  
 $`\mathbf{d\phi=\overrightarrow{grad}\,\phi\cdot\overrightarrow{dl}}`$
 
 *Expressions du gradient*
 
   Coordonnées cartésiennes :   
   $`\begin{align}
   \overrightarrow{grad}\,\phi &=\dfrac{\partial \phi}{\partial x}\,\overrightarrow{e_x}+\dfrac{\partial \phi}{\partial y}\,\overrightarrow{e_y}+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z} \\
    &=\overrightarrow{\nabla}\,\phi
    \end{align}`$
    
   &nbsp;&nbsp;avec opérateur nabla :
   &nbsp;&nbsp;$`\overrightarrow{\nabla}=\dfrac{\partial}{\partial x}\,\overrightarrow{e_x}+\dfrac{\partial}{\partial y}\,\overrightarrow{e_y}+\dfrac{\partial}{\partial z}\,\overrightarrow{e_z}`$

   Coordonnées cylindriques :   
   $`\overrightarrow{grad}\,\phi=\dfrac{\partial \phi}{\partial \rho}\,\overrightarrow{e_{\rho}}+\dfrac{1}{\rho}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z}`$

   Coordonnées sphériques :   
   $`\overrightarrow{grad}\,V=\dfrac{\partial \phi}{\partial r}\,\overrightarrow{e_r}+\dfrac{1}{r}\,\dfrac{\partial \phi}{\partial \theta}\,\overrightarrow{e_{\theta}}+\dfrac{1}{r\,sin\,\theta}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}`$
 
  *Champ de gradient d'un champ scalaire* :  
  
  L'ensemble des vecteurs gradients en tout point de l'espace est un champ vectoriel, appelé champ de gradient
  
  *Opérateur gradient*
  
  L'opérateur $`\overrightarrow{grad}`$, appliqué à un champ scalaire $`\phi`$ et en un point de l'espace, donne
  le vecteur $`\overrightarrow{grad}\,\phi`$
  
  ---
  
  *Propriétés du gradient*
  
  En tout point de l'espace :
  * $`\overrightarrow{grad}\,\phi`$ pointe en direction et sens où un
   vecteur déplacement  élémentaire $`\overrightarrow{dl}`$ de norme constante $`\Vert\overrightarrow{dl}\Vert`$ 
   induit la variation élémentaire maximale $`d\phi_{MAX}`$ (>0).
  * dans cette direction et sens de variation maximale :
    $`\dfrac{d\phi_{MAX}}{\Vert\overrightarrow{dl}\Vert}=\Vert\overrightarrow{grad}\,\phi\Vert`$
  
  ---

   *Théorème du gradient*
  
  à continuer... nécessaire ici?
    
    
    
CHAMP VECTORIEL CONSERVATIF<br>_" du champ vectoriel (conservatif) aux champs scalaires "_
: ---

  *Définition d'un champ vectoriel conservatif*

  Un champ vectoriel $`\overrightarrow{X}`$ est conservatif si et seulement si il s'identifie
  au champ de gradient d'un champ scalaire $`\phi`$ :

  $`\mathbf{\overrightarrow{X}(\vec{r})\text{ est conservatif }}`$
  $`\mathbf{\Longleftrightarrow\;\exists\,\phi(\vec{r}), \overrightarrow{X(\vec{r})}=\overrightarrow{grad}\,\big(\phi(\vec{r})\big)}`$
  
  *Propriété d'un champ vectoriel conservatif*
  
  La circulation d'un champ vectoriel conservatif $`\overrightarrow{X}=\overrightarrow{grad}(\phi)`$ entre deux points $`M_1`$ et $`M_2`$ ne dépend que
  égale à $`\phi(M_2)-\phi(M_1)`$, quelque-soit le chemin suivi entre ces deux points :
  
  $`\displaystyle\begin{align}\mathbf{\int_{M_1}^{M_2}\overrightarrow{X}\cdot\overrightarrow{dl}}&=\int_{M_1}^{M_2} \overrightarrow{grad}(\phi)\cdot\overrightarrow{dl}\\
    & = \displaystyle\int_{M_1}^{M_2} d\phi\mathbf{\;\;=\phi(M_2)-\phi(M_1)}\\
    \end{align}`$
    
  $`\Longrightarrow`$ La circulation d'un champ vectoriel conservatif le long d'un contour (chemin fermé) est nulle.

  
  
POTENTIEL, ÉNERGIE POTENTIELLE,<br> THÉORÈME DE CONSERVATION DE L'ÉNERGIE MÉCANIQUE
: ---

  ATTENTION!! INEXACTITUDES !! EN COURS DE REDACTION !!
  
  *Champs conservatifs en physique*
  
  En physique, les champs d'interaction fondamentaux $`\overrightarrow{X}`$ sont conservatifs,   
  en particulier le champ gravitationnel $`\mathcal{\overrightarrow{G}}`$ et le champ électrostatique $`\overrightarrow{E}`$.   
  <br>
  En électromagnétisme classique :
  * le champ électrique a une composante conservative (le champ électrostatique) et une composante non conservative (un champ électromoteur).
  * le champ magnétique est non conservatif.
  
  *Potentiel*
  
  Un champ scalaire $`\phi`$ tel que $`-\overrightarrow{grad}\,\phi=\,\overrightarrow{X}`$ est appelé "potentiel".
  
  * Potentiel gravitationnel $`\phi_{grav}`$ : $`-\,\overrightarrow{grad}\,\phi_{grav}=\mathcal{\overrightarrow{G}}`$
  * Potentiel électrostatique $`\phi_{elec}`$, noté $`V`$ : $`-\,\overrightarrow{grad}\,V=\overrightarrow{E}`$
  
  *Énergie potentielle*
  
  Une particule de sensibilité $`s`$ à une interaction conservative $`\overrightarrow{X}`$, qui voit en sa position $`\overrightarrow{r}`$ 
  la valeur de potentiel $`\phi_X(\vec{r}`$, possède l'énergie potentielle $`\mathcal{E}_X^{pot}=s\,\phi_X(\vec{r})`$.

  * Interaction gravitationnelle :   
    sensibilité à la gravitation : masse grave = masse, noté $`m`$, telle que $`m\ge 0`$.  
    Energie potentielle gravitationnelle : $`\mathcal{E}_{grav}^{pot}=m\,\phi_{grav}(\vec{r})`$

  * Interaction électrique :   
    sensibilité à l'électromagnétisme : charge électrique, noté $`q`$, telle que $`q\in\mathbb{R}`$,   
    Energie potentielle électrostatique : $`\mathcal{E}_{elec}^{pot}=q\,V(\vec{r})`$
   
  Il existe toujours une infinité de potentiels $`\phi`$ tels que $`-\overrightarrow{grad}\,\phi=\overrightarrow{X}`$   
  (exemple : $`\phi`$ et $`\phi+const`$)   
  $`\Longrightarrow`$ l'énergie potentielle n'est pas définie et n'a donc pas d'existence réelle.   
  Mais,   
  la circulation d'un champ conservatif entre deux points $`M_1`$ et $`M_2`$ ne dépend pas du chemin suivi :   
  $`\Longrightarrow`$ la différence d'énergie potentielle $`\mathcal{E}^{pot}(M_2)-\mathcal{E}^{pot}(M_1)`$ entre deux points $`M_1`$ et $`M_2`$ est définie.
  
  ---

  *Définition et théorème de l'énergie cinétique*
  
   Pour une particule de masse $`m`$ et de vitesse $`\overrightarrow{\mathscr{v}}`$ dans le référentiel d'observation,   
   L'énergie cinétique est définie par : $`\mathbf{\mathcal{E}^{cin}=m\,\mathscr{v}^2}`$
   
   Le travail de la force qui s’exerce sur un point matériel entre deux instants $`t_1\text{ et }t_2`$ est égal
   à la variation d’énergie cinétique entre ces deux instants :
   
   $`\mathbf{\displaystyle\mathcal{W}\,(t_1,t_2)=\int_{t_1}^{t_2}\overrightarrow{F}\cdot\overrightarrow{dl}=\mathcal{E}^{cin}(t_2)-\mathcal{E}^{cin}(t_1)}`$ 
   
   _ou, équivalent :_
   
   Le travail de la force qui s’exerce sur un point matériel le long de sa trajectoire limité entre deux points s $`M_1`$ et $`M_2`$, 
   est égal à la variation d’énergie cinétique entre ces deux points.
   
   $`\mathbf{\displaystyle\mathcal{W}\,(M_1,M_2)=\int_{M_1}^{M_2}\overrightarrow{F}\cdot\overrightarrow{dl}=\mathcal{E}^{cin}(M_2)-\mathcal{E}^{cin}(M_1)}`$ 

  ---
  
  *Définition et théorème de conservation de l'énergie mécanique*
  
  L'énergie mécanique $`\mathcal{E}^{méc}`$ est la somme de l'énergie cinétique et de l'énergie potentielle :   
  $`\mathbf{\mathcal{E}^{méc}=\mathcal{E}^{cin}+\mathcal{E}^{pot}}`$
  
  Dans un référentiel d'inertie (= galiléen), l'énergie mécanique d'un point matériel reste constante, lorsque
  ce point se déplace librement dans un ou plusieurs champs d'interaction conservatifs :   
  $`\mathbf{\mathcal{E}^{méc}=\mathcal{E}^{cin}+\mathcal{E}^{pot}=constante}`$
  
  


  
   
   

En début de construction ! stade très très préliminaire.

déjà poser des qestions,    
mettre les équations qui seront utilisées.

#### LE  GRADIENT

<br>
#### Qu'est-ce qu'un champ scalaire ?

_Exemple "intuitif" d'un champ scalaire défini sur un espace 2D : une carte météorologique, qui donne_
_une représentation des températures constatées ou prévues au niveau du sol._

![](scalar-field-example-temperatures_v2_L800.gif)   

1. Un **champ scalaire** est une *grandeur physique scalaire définie en tout point de l'espace*. 

2. Ce champ est *mathématiquement modélisé* par une **fonction scalaire $`\phi(\vec{r})`$ continue et dérivable**.

3. Les **lignes de niveaux** (2D) ou **surfaces de niveaux** (3D) sont des ensembles continus de points de l'espace 
*caractérisés par une même valeur de champ*.

<!-------------------------
*Mathématiquement*, un champ scalaire $`\phi`$ défini sur l'espace euclidien classique (dimension 3) muni de coordonnées cartésiennes $`(x\,,y\,,z)`$ , s'écrit :
 
 * lorsque la *valeur* scalaire est *réelle* :   
 $`\Phi\quad : \mathbb{R}^3\,\longrightarrow\,\mathbb{R}\, x \,\longmapsto\,\Phi(x)`$
 * lorsque la valeur scalaire est complexe :   
 $`\Phi\quad : \mathbb{R}^3\,\longrightarrow\,\mathbb{C}\, x \,\longmapsto\,\Phi(x)`$
 

! Á tout champ scalaire tu pourras associer un champ de gradient.
------------------------>
 


#### Qu'est-ce qu'un champ vectoriel ?

_Exemple "intuitif" d'un champ vectoriel, défini sur un espace 2D : une carte météorologique, qui donne_
_une représentation de la vitesse des vents mesurée ou prévue au niveau du sol._

![](vector-field-example-speed-wind_v2_L800.gif)   

1. Un **champ vectoriel** est une *grandeur physique vectorielle définie en tout point de l'espace*. 

2. Ce champ est *mathématiquement modélisé* par une **fonction vectorielle $`\overrightarrow{X}(\vec{r})`$ continue et dérivable**.   

3. Les **lignes de champ** sont lignes telles qu'en chaque point d'une ligne, le *champ vectoriel* est *tangent à la ligne*.   
   Chaque ligne de champ porte l'information sur la direction du champ en chacun de ses point, mais *pas d'information sur la norme*.

4. Chaque ligne de champs est *orientée par une flèche* qui indique le *sens du champ vectoriel* sur la ligne.

<!----------------------
*Mathématiquement*, un champ vectoriel $`\overrightarrow{X}`$ défini **sur l'espace euclidien** classique (dimension 3) 
**muni de coordonnées cartésiennes  , s'écrit :   
--------------------->

!!!! *Attention :    
!!!! Tu ne pourras pas* toujours *considérer qu'un champ vectoriel $`\overrightarrow{X}`$ est le gradient d'un champ scalaire*.   
 
 
#### Quelle différence, en physique, entre direction et sens ?

**En français et en physique**, le **mot "direction"** à une *signification différente* de celle *du langage commun*.

* Dans le **langage commun**, regarder dans une direction signifie regarder *devant soi en pointant son regard vers un point* de l'espace.   
<br>
![](direction-common-language_L630.jpg)

* Dans le **langage de la physique, en France**, le mot direction a une *autre signification* :

   * Une **direction**, indiquée en un point, est *portée par une droite* qui contient ce point.   
<br>
![](direction-in-french-physics_L630.jpg)

   * Une *direction plus* un **sens**, indiqués en un point, sont *portés par un axe*, droite orientée par une **flèche qui indique le sens**.   
<br>
![](direction-sens-1_L630.jpg)

   * Une **direction** possède donc *2 sens* possibles.   
<br>
![](direction-sens-1-2_L630.gif)

 
#### Qu'est-ce qu'un champ uniforme, ou au contraire non-uniforme ?

* Un **champ scalaire uniforme**, à un instant $`t`$, est un champ de *valeur constante* dans l'espace,
ou de façon plus réaliste dans un *domaine spécifié de l'espace*.

* Un **champ vectoriel uniforme**, à un instant $`t`$, est un champ de *vecteur constant* 
(donc en norme, en direction et en sens) dans l'espace,
ou de façon plus réaliste dans un *domaine spécifié de l'espace*.

#### Qu'est-ce qu'un champ stationnaire, ou au contraire variable ?

* Un **champ stationnaire** *ne dépend pas du temps*.   
  Tu le noteras,   
   * pour un champ scalaire : *$`\mathbf{\phi(\vec{r})}`$*
   * pour un champ vectoriel : *$`\mathbf{\overrightarrow{X}(\vec{r})}`$*

* Un **champ variable** est un champ qui n'est pas stationnaire, donc qui *varie en fonction du temps*.
  Tu le noteras,   
   * pour un champ scalaire : *$`\mathbf{\phi(\vec{r},t)}`$*
   * pour un champ vectoriel : *$`\mathbf{\overrightarrow{X}(\vec{r},t)}`$*


#### Qu'est-ce que le gradient d'un champ scalaire ?

##### Vecteur gradient en tout point d'un champ scalaire

figure à faire.

* En un **point$`M`$**  quelconque de l'espace, un champ scalaire à une valeur *$`\phi_M`$*.
* Si, partant de ce point, tu fais un **déplacement élémentaire $`\overrightarrow{dl}`$**, 
  alors la valeur du champ varie d'une *quantité élémentaire $`d\phi`$*.
* A un déplacement particulier $`\overrightarrow{dl}_0`$ correspond une variation particuliare $`d\phi_0`$.
 <br>
* Le **vecteur gradient** :
    * est le *lien entre $`\overrightarrow{dl}`$ et $`d\phi`$*
    * *permet le* **calcul au premier ordre** *de $`d\phi`$ pour tout $`\overrightarrow{dl}`$*, suivant
      sa formule de **définition** :   
    <br>
    **$`\large{\mathbf{d\phi_M=\overrightarrow{grad}\phi_M\cdot\overrightarrow{dl}}}`$**  

##### Le Champ gradient, appelé "gradient" 

* Le vecteur gradient est défini :
   * en tout point d'un champ scalaire
   * donc en tout point de l'espace
  $`\Longrightarrow`$ l'*ensemble des vecteurs $`\overrightarrow{grad}\phi_M`$* sur tous les points $`M`$ de l'espace
    définit un *champ vectoriel appelé* **gradient de $`\phi`$**.

    
##### L'opérateur gradient

* L'*opération $`\overrightarrow{grad}`$* qui, appliqué *en un point $`M`$* quelconque
* de l'espace, *associe le vecteur $`\overrightarrow{grad}\phi_M`$*, est
  appelée **opérateur gradient**.


#### Que représente le vecteur gradient ?

figure à faire.

En tout point $`M`$ de l'espace, la variation élémentaire $`d\phi`$ calculée au 
  premier ordre et correspondant à un vecteur déplacement élémentaire $`\overrightarrow{dl}`$ 
  se décompose en :   
<br>
**$`\mathbf{d\phi}`$**$`\;=\overrightarrow{grad}\,\phi\cdot\overrightarrow{dl}`$
**$`\mathbf{\;=\big\Vert\overrightarrow{grad}\,\phi\big\Vert\cdot\big\Vert\overrightarrow{dl}\big\Vert\cdot cos\theta}`$**

avec *$`\mathbf{\theta=\big(\widehat{\overrightarrow{grad}\,\phi\,,\overrightarrow{dl}}\big)}`$*

De cette expression se montrent les propriétés du vecteur gradient ;

* Si le *déplacement élémentaire $`\overrightarrow{dl}`$* se fait **selon une ligne de niveau** ou **une surface de niveau**,
  alors par définition **$`\mathbf{d\phi=0}`$**. Deux cas sont alors possibles : 

   * *$`\mathbf{\overrightarrow{grad}\,\phi_M=\overrightarrow{0}}`$* : la champ scalaire $`\mathbf{\phi}`$ présente un **extremum local** au point $`M`$.   
   * *$`\mathbf{\cos\theta= 0\;\Longrightarrow\;\theta=\dfrac{\pi}{2}}`$* : le vecteur **$`\mathbf{\overrightarrow{grad}\,\phi_M}`$** a une direction 
     **perpendiculaire à la ligne** de niveau (champ 2D) **ou la surface de niveau** (champ 3D) en $`M`$.

_petite figure à faire_

* Si le *déplacement élémentaire $`\overrightarrow{dl}`$*, à norme constante, **induit une variation maximale $`\mathbf{d\phi_M^{max}}`$**,
  alors :  
    * *$`\mathbf{\cos\theta=+1\;\Longrightarrow\;\theta=0}`$*,  
    <br>
    $`\Longrightarrow`$  le vecteur **$`\mathbf{\overrightarrow{grad}\,\phi_M}`$** pointe dans le 
    **sens où le champ $`\phi`$ croît le plus rapidement**.   
    <br>
    $`\Longrightarrow`$*$`\mathbf{\quad\big\Vert\overrightarrow{grad}\,\phi\big\Vert = \dfrac{d\phi_M^{max}}{\big\Vert\overrightarrow{dl}\big\Vert}}`$*

_petite figure à faire_   
_petite figure à faire_


#### Comment se détermine l'expression du gradient dans un système de coordonnées ?

Soit un système de **coordonnées orthogonales directes $`(\alpha\,,\beta\,,\gamma)`$**.

En un point quelconque de l'espace de coordonnées $`(\alpha\,,\beta\,,\gamma)`$ est associée 
la base des vecteurs unitaires 
*$`(\overrightarrow{e_{\alpha}}\,,\overrightarrow{e_{\beta}}\,,\overrightarrow{e_{\gamma}})`$ orthonormée et directe*.
 
Dans cette base, soient :   
* $`(X_{\alpha}\;,\;X_{\beta}\;,\;X_{\gamma})`$ 
les composantes inconnues du vecteur $`\overrightarrow{grad}\,\phi`$ :   
$`\color{brown}{\mathbf{\overrightarrow{grad}\,\phi=X_{\alpha}\;\overrightarrow{e_{\alpha}}+X_{\beta}\;\overrightarrow{e_{\beta}}+X_{\gamma}\;\overrightarrow{e_{\gamma}}}}`$
* $`(dl_{\alpha}\;,\;dl_{\beta}\;,\;dl_{\gamma})`$ 
les composantes connues du vecteur $`\overrightarrow{dl}`$ :   
* $`\color{blue}{\mathbf{\overrightarrow{dl}=dl_{\alpha}\;\overrightarrow{e_{\alpha}}+dl_{\beta}\;\overrightarrow{e_{\beta}}+dl_{\gamma}\;\overrightarrow{e_{\gamma}}}}`$

Par définition :

$`\color{brown}{\mathbf{d\phi=\overrightarrow{grad}\,\phi\cdot\overrightarrow{dl}}}`$

$`\;=\big(X_{\alpha}\;\overrightarrow{e_{\alpha}}+X_{\beta}\;\overrightarrow{e_{\beta}}+X_{\gamma}\;\overrightarrow{e_{\gamma}}\big)
\cdot\big(dl_{\alpha}\;\overrightarrow{e_{\alpha}}+dl_{\beta}\;\overrightarrow{e_{\beta}}+dl_{\gamma}\;\overrightarrow{e_{\gamma}}\big)`$

$`\begin{align}
\; &= X_{\alpha}\,dl_{\alpha}\,\big(\overrightarrow{e_{\alpha}}\cdot\overrightarrow{e_{\alpha}}\big)
+X_{\alpha}\,dl_{\beta}\,\big(\overrightarrow{e_{\alpha}}\cdot\overrightarrow{e_{\beta}}\big)
+X_{\alpha}\,dl_{\gamma}\,\big(\overrightarrow{e_{\alpha}}\cdot\overrightarrow{e_{\gamma}}\big)\\
&\; + X_{\beta}\,dl_{\alpha}\,\big(\overrightarrow{e_{\beta}}\cdot\overrightarrow{e_{\alpha}}\big)
+X_{\beta}\,dl_{\beta}\,\big(\overrightarrow{e_{\beta}}\cdot\overrightarrow{e_{\beta}}\big)
+X_{\beta}\,dl_{\gamma}\,\big(\overrightarrow{e_{\beta}}\cdot\overrightarrow{e_{\gamma}}\big)\\
&\; + X_{\gamma}\,dl_{\alpha}\,\big(\overrightarrow{e_{\gamma}}\cdot\overrightarrow{e_{\alpha}}\big)
+X_{\gamma}\,dl_{\beta}\,\big(\overrightarrow{e_{\gamma}}\cdot\overrightarrow{e_{\beta}}\big)
+X_{\gamma}\,dl_{\gamma}\,\big(\overrightarrow{e_{\gamma}}\cdot\overrightarrow{e_{\gamma}}\big)\\
\end{align}`$

$`\color{brown}{\mathbf{\; = X_{\alpha}\,dl_{\alpha}+X_{\beta}\,dl_{\beta}+X_{\gamma}\,dl_{\gamma}}}`$

Par ailleurs, $`\phi`$ étant un champ scalaire, sa différentielle exprimée en fonction des $`d\alpha\,,d\beta\,,d\gamma`$ s'écrit :

<!---------------------
$`\mathbf{d\phi=\left.\dfrac{\partial \phi}{\partial \alpha}\right|_M\cdot dl_{\alpha} + \left.\dfrac{\partial \phi}{\partial \beta}\right|_M\cdot dl_{\beta} + \left.\dfrac{\partial \phi}{\partial \gamma}\right|_M\cdot dl_{\gamma}}`$
--------------------->

*$`\color{blue}{\mathbf{d\phi}}`$*$`\;=\dfrac{\partial \phi}{\partial \alpha}\cdot d\alpha + \dfrac{\partial \phi}{\partial \beta}\cdot d\beta + \dfrac{\partial \phi}{\partial \gamma}\cdot d\gamma`$

*$`\color{blue}{\;=
\dfrac{\partial \phi}{\partial \alpha}\,\dfrac{\partial \alpha}{\partial l_{\alpha}}\, \mathbf{dl_{\alpha}}
+\dfrac{\partial \phi}{\partial \beta}\,\dfrac{\partial \beta}{\partial l_{\beta}}\, \mathbf{dl_{\beta}}
+\dfrac{\partial \phi}{\partial \gamma}\,\dfrac{\partial \gamma}{\partial l_{\gamma}}\, \mathbf{dl_{\gamma}}}`$*

La comparaison terme à terme de ces deux expressions de $`d\phi`$ donne :

$`X_{\alpha}=\dfrac{\partial \phi}{\partial \alpha}\,\dfrac{\partial \alpha}{\partial l_{\alpha}}\quad`$,$`\quad X_{\beta}=\dfrac{\partial \phi}{\partial \beta}\,\dfrac{\partial \beta}{\partial l_{\beta}}\quad`$,$`\quad X_{\alpha}=\dfrac{\partial \phi}{\partial \gamma}\,\dfrac{\partial \gamma}{\partial l_{\gamma}}`$

Soit

$`\color{brown}{\mathbf{
\overrightarrow{grad}\,\phi=
\dfrac{\partial \alpha}{\partial l_{\alpha}}\,\dfrac{\partial \phi}{\partial \alpha}\,\overrightarrow{e_{\alpha}}
+\dfrac{\partial \beta}{\partial l_{\beta}}\,\dfrac{\partial \phi}{\partial \beta}\,\overrightarrow{e_{\beta}}
+\dfrac{\partial \gamma}{\partial l_{\gamma}}\,\dfrac{\partial \phi}{\partial \gamma}\,\overrightarrow{e_{\gamma}}
}}`$

##### Expression du gradient en coordonnées cartésiennes

$`\left.\begin{array}{l}
dl_x=dx \Longrightarrow \dfrac{\partial x}{\partial l_x}=1\\
dl_y=dy \Longrightarrow \dfrac{\partial y}{\partial l_y}=1\\
dl_z=dz \Longrightarrow \dfrac{\partial z}{\partial l_z}=1\\
\end{array}\right\}`$
$`\Longrightarrow\color{brown}{\mathbf{
\overrightarrow{grad}\,\phi=
\dfrac{\partial \phi}{\partial x}\,\overrightarrow{e_x}
+\dfrac{\partial \phi}{\partial y}\,\overrightarrow{e_y}
+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z}
}}`$


##### Expression du gradient en coordonnées cylindriques

$`\left.\begin{array}{l}
dl_{\rho}=d\rho\Longrightarrow \dfrac{\partial \rho}{\partial l_{\rho}}=1\\
dl_{\varphi}=\rho\,d{\varphi} \Longrightarrow \dfrac{\partial \varphi}{\partial l_{\varphi}}=\dfrac{1}{\rho}\\
dl_z=dz \Longrightarrow \dfrac{\partial z}{\partial l_z}=1\\
\end{array}\right\}`$
$`\Longrightarrow\color{brown}{\mathbf{
\overrightarrow{grad}\,\phi=
\dfrac{\partial \phi}{\partial \rho}\,\overrightarrow{e_{\rho}}
+\dfrac{1}{\rho}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}
+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z}
}}`$

##### Expression du gradient en coordonnées sphériques

$`\left.\begin{array}{l}
dl_r=dr\Longrightarrow \dfrac{\partial r}{\partial l_r}=1\\
dl_{\theta}=r\,d{\theta} \Longrightarrow \dfrac{\partial r}{\partial l_r}=\dfrac{1}{r}\\
dl_{\varphi}=r\,\sin\theta\,d\varphi \Longrightarrow \dfrac{\partial \varphi}{\partial l_{\varphi}}=\dfrac{1}{r\,\sin\theta}\\
\end{array}\right\}`$
$`\Longrightarrow\color{brown}{\mathbf{
\overrightarrow{grad}\,\phi=
\dfrac{\partial \phi}{\partial r}\,\overrightarrow{e_r}
+\dfrac{1}{r}\,\dfrac{\partial \phi}{\partial \theta}\,\overrightarrow{e_{\theta}}
+\dfrac{1}{r\,\sin\theta}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}
}}`$

<br>

----------------------------------------------------------

#### CHAMP VECTORIEL CONSERVATIF, POTENTIEL et ÉNERGIE POTENTIEL


<!-----------------
#### Quand un champ vectoriel est-il conservatif ?


#### Comment est modélisée une interaction mécanique entre deux corps en physique classique ?

interaction mécanique / concept de force entre les deux corps qui interagissent /
champ d'interaction associé / 
----------------->


#### Quel lien entre champ de force conservatif $`\overrightarrow{X}`$ et le potentiel associé $`\phi_X`$ ?

_Exemple d'un champ de force créé et du potentiel associé. Il pourrait s'agir ici de trois
charges électriques positives._

![](from-conservative-interaction-to-potential_L800.gif)

* Soient une distribution spatiale de corps sensibles à une *interaction $`\overrightarrow{X}`$*.
* Ces corps sont la causes d'un champ d'interaction appelé **champ de force $`\overrightarrow{X}`$** s'étendant à tous l'espace.
* Si ce champ de force est **conservatif**, il *dérive d'un* champ scalaire appelé **potentiel** noté **$`\phi_X`$**, tel que :   
  <br>
  **$`\large{\mathbf{\overrightarrow{X}=-\overrightarrow{grad}\,\phi_{X}}}`$**.   
  <br>
* Représenté dans un plan ou dans l'espace, $`\phi_X`$ est *visualisé par ses* **lignes ou surfaces équipotentielles**.
* Le signe $`-`$ assure qu'en chaque point de vecteur position $`\vec{r}`$ , le vecteur *$`\overrightarrow{X}(\vec{r})`$
  pointe en direction et sens* où **$`\phi_X`$ décroit le plus rapidement**.   

---

* La norme $`\big\Vert\overrightarrow{X}\big\Vert`$ indique la pente de $`\phi_X`$ dans cette direction :  
     $`\big\Vert\overrightarrow{X}\big\Vert=\left|\dfrac{d\phi_X}{dr}\right|_{MAX}`$   
     $`\Longrightarrow`$ Si les lignes ou surfaces **équipotentielles** sont *séparées par une même valeur $`\Delta\phi_X`$*, 
     alors :   
     **plus $`\big\Vert\overrightarrow{X}\big\vert`$ est grand** *plus les équipotentielles sont resserrées*.`
* En un point ou **$`\overrightarrow{X}=\overrightarrow{0}`$**, *$`|d\phi_X\,/\,dr|_{MAX}=0`$* entraîne que   
     \- $`\phi_X`$ est *localement uniforme*.   
     \- $`\phi_X`$ passe par un *extremum* en ce point.  

!!! *Exemples* :
!!!
!!! * Le *champ électrostatique $`\overrightarrow{E}`$* est un champ de force conservatif qui dérive
!!! d'un *potentiel électrostatique* noté *$`V`$*.
!!!
!!! * Le *champ gravitationnel $`\overrightarrow{\mathcal{G}}`$* est un champ de force conservatif qui dérive
!!! d'un *potentiel gravitationnel* noté *$`\phi`$* ou $`\phi_{grav}`$.


#### Pourquoi le signe "$`-`$" dans $`\overrightarrow{X}=-\,\overrightarrow{grad}\,\phi_X`$ ?

* Se verra ci-dessous, dans la suite.
* *Cela assurera que* : 
   * la **force $`\overrightarrow{F}_X`$** qu'exerce le champ $`\overrightarrow{X}`$ sur une particule sensible la *dirige vers les potentiels décroissants*.
   * $`\Longrightarrow`$ pour la particule, l'**énergie potentielle $`\mathcal{E}^{pot}`$ diminue** *à mesure que l'énergie cinétique $`\mathcal{E}^{cin}`$ augmente*.
   * $`\Longrightarrow`$ *permet d'établir* la **loi de conservation de l'énergie mécanique** :    
     dans un référentiel d'inertie, *$`\mathcal{E}^{cin}+\mathcal{E}^{pot}=const`$*


#### Quelle force $`\overrightarrow{F_X}`$ exerce le champ $`\overrightarrow{X}`$ sur une particule ?

référentiel d'inertie, force centrale

![](from-interaction-to-force_L800.gif)


* Soit une **particule** de *sensibilité $`\alpha`$* à un *champ de force centrale conservatif $`\overrightarrow{X}`$* :
<br> 
La **force d'interaction $`\overrightarrow{F}_X`$** qui s'exerce sur la particule, lorsque c'est une force **centrale**, s'écrit :   
<br>
$`\color{brown}{\large{\mathbf{\overrightarrow{F}_X=\alpha\,\overrightarrow{X}}}}`$

!!! *Exemples* :
!!!
!!! * Le *champ électrostatique $`\overrightarrow{E}`$* est un champ de *force centrale*.  
!!! La *sensibilité* d'un corpuscule à l'interaction électrostatique est quantifiée par la *charge électrique $`q`$*.   
!!! La charge peut être positive, nulle, ou négative.   
!!! La force électrostatique $`\overrightarrow{F}_E`$ qui s'exerce sur une charge $`q`$ à la position où règne
!!! un champ électrostatique $`\overrightarrow{E}`$ est :    
!!! *$`\overrightarrow{F}_E=q\,\overrightarrow{E}`$*.
!!! 
!!! * Le *champ gravitationnel $`\overrightarrow{\mathcal{G}}`$* est un champ de *force centrale*.   
!!! La *sensibilité* d'un corpuscule à l'interaction gravitationelle est quantifiée par la *masse $`m`$*.   
!!! La masse peut être positive, nulle.  
!!! La force gravitationnelle $`\overrightarrow{F}_G`$ qui s'exerce sur une masse $`m`$ à la position où règne
!!! un champ gravitationnel $`\overrightarrow{\mathcal{G}}`$ est :    
!!! *$`\overrightarrow{F}_G=m\,\overrightarrow{\mathcal{G}}`$*.



#### Comment retrouver la force conservative $`\overrightarrow{F_X}`$ à partir du potentiel $`\phi_X`$ ?

<br>

$`\left.\begin{array}{l}
\overrightarrow{F}_X=\alpha\,\overrightarrow{X}\\
\overrightarrow{X}=-\;\overrightarrow{grad}\,\phi_X
\end{array}\right\}\Longrightarrow\color{brown}{\large{\mathbf{\overrightarrow{F}_X=-\;\alpha\;\,\overrightarrow{grad}\,\phi_X}}}`$


#### Quel lien entre force conservative $`\overrightarrow{F_X}`$ et l'énergie potentielle $`\mathcal{E}^{pot}`$ ?

![](difference-of-potential-energy_v2_L800.gif)

* Le **travail d'une force** a la *dimension d'une énergie*.

* La **travail élémentaire** *de la force conservative* $`\overrightarrow{F}_X`$ qui s'exerce 
 sur une particule de sensibilité $`\alpha`$ constante à un champ de force $`\overrightarrow{X}`$ 
 lors d'un déplacement élémentaire $`\overrightarrow{dl}`$ s'écrit :
<br>
$`\begin{align}
\displaystyle\color{brown}{\large{\mathbf{\overrightarrow{F}_X\cdot\overrightarrow{dl}}}} & =\alpha\,\overrightarrow{X}\cdot\overrightarrow{dl}\\
& =\,\alpha\,\big(-\,\overrightarrow{grad}\,\phi_X\big) \cdot\overrightarrow{dl} \\
& =-\,\alpha\,\underbrace{\big(\overrightarrow{grad}_X\,\phi_X\cdot\overrightarrow{dl}\big)}_{=\;d\phi\;,\text{ dfn de } \overrightarrow{grad}\,\phi}\\
& =-\,\alpha\;d\phi_X \\
\\
& \color{blue}{\large{\mathbf{\;=-\;d(\alpha\;\phi_X)}}} \\
\\
& \color{brown}{\large{\mathbf{\;=-\;d\mathcal{E}_X^{pot}}}}\\
\end{align}`$

* Par défintion, l'**énergie potentielle** de la particule dans ce champ de force, noté $`\mathcal{E}_X^{pot}`$ est :   
<br>
$`\color{brown}{\large{\mathbf{\mathscr{E}_X^{pot}=\alpha\;\phi_X}}}`$   

!!! *Exemples* :
!!!
!!! * L'énergie potentielle électrostatique $`\mathcal{E}_{elec}^{pot}`$ d'un corpuscule de charge $`q`$ localisé sur un potentiel électrostatique de valeur $`V`$ est :   
!!! $`\mathcal{E}_{elec}^{pot}=q\,V`$.
!!!
!!! * L'énergie potentielle gravitationnelle $`\mathcal{E}_{grav}^{pot}`$ d'un corpuscule de masse $`m`$ localisé sur un potentiel gravitationnel de valeur $`\phi`$ est :   
!!! $`\mathcal{E}_{elec}^{pot}=m\,\phi`$.


!!!! *ATTENTION* :   
!!!!
!!!! La *valeur de l'énergie potentielle* d'une particule en un point de l'espace n'est qu'un *intermédiaire de calcul*.
!!!! Elle n'a *pas de réalité physique*, puisqu'il existe une infinité de potentiels $`\phi_X`$ qui vérifient 
!!!! $`\overrightarrow{X}=-\;\overrightarrow{\phi_x}`$, et donc une infinité de valeurs possibles pour 
!!!! $`\mathcal{E}_X^{pot}`$ selon le potentiel choisi.   
!!!!
!!!! *Seules* : 
!!!!
!!!! * *la variation élémentaire $`d\mathcal{E}_X^{pot}`$ de l'énergie potentielle* lors
!!!! d'un déplacement élémentaire $`\overrightarrow{dl}`$,   
!!!!  
!!!! * *la variation d'énergie potentielle $`\overset{B}{\underset{A}{\Large{\Delta}}}(\mathcal{E}_X^{pot})`$* 
!!!! d'une particule entre deux points $`A`$ et $`B`$ de sa trajectoire   
!!!! 
!!!! *existent*.   
!!!! 
!!!! Elles *correspondent à de l'énergie perdue ou gagnée*, grandeur physique mesurable, par la particule qui se déplace dans le 
!!!! champ de force $`\overrightarrow{X}`$ auquel elle est sensible.

* Le **travail de la force conservative** s'exerçant sur la particule évalué sur une portion de *trajectoire d'extrémités $`A`$ et $`B`$* s'écrit :   
<br>
$`\begin{align}
\displaystyle\color{brown}{\large{\mathbf{\displaystyle\int_A^B\overrightarrow{F}_X\cdot\overrightarrow{dl}}}} & =-\,\int_A^B \mathcal{E}_X^{pot} \\
\\
& \color{brown}{\large{\mathbf{\;=-\,\bigg(\mathcal{E}_X^{pot}(B)-\mathcal{E}_X^{pot}(A)\bigg)}}}\\
\\
& \color{blue}{\large{\mathbf{\;=-\;\overset{B}{\underset{A}{\Large{\Delta}}}(\mathcal{E}_X^{pot})}}}\\
\end{align}`$


!!!!! *Notation* : 
!!!!!
!!!!! La *différence de valeur* d'une grandeur physique $`\mathcal{f}`$ 
!!!!! *entre un point initial $`A`$ et un point final $`B`$* s'écrit :   
!!!!! $`\overset{B}{\underset{A}{\Large{\Delta}}}(\mathcal{f})=\mathcal{f}(B)-\mathcal{f}(A)`$


#### Quel lien entre force totale appliquée $`\overrightarrow{F}_{tot}`$ et énergie cinétique $`\mathcal{E}^{cin}`$ ?

<br>

![](difference-of-kinetic-energy_v2_L800.gif)

* Ce lien **utilise la $`2^{ème}`$ loi de Newton**, aussi appelée *Relation fondamentale de la dynamique (RFD)* :   
  <br>
  **Dans un référentiel d'inertie (=galiléen)**, en chaque point de la trajectoire d'un corpuscule, 
   la dérivée du vecteur quantité de mouvement $`\vec{p}=m\,\vec{v}`$ par rapport
    au temps d'un corpuscule est égale à la force totale $`\overrightarrow{F}_{tot}`$ qui s'applique au corpuscule :
  <br>
  $`\color{brown}{\large{\mathbf{\overrightarrow{F}_{tot}=\dfrac{d\overrightarrow{p}}{dt}}}}`$

* Le **travail d'une force** a la *dimension d'une énergie*.

* $`\overrightarrow{F}_{tot}\cdot\overrightarrow{dl}=\dfrac{d\overrightarrow{p}}{dt}\cdot\overrightarrow{dl}`$,   
&nbsp;&nbsp;&nbsp; avec $`\overrightarrow{p}=m\,\overrightarrow{\mathscr{v}}`$,   
&nbsp;&nbsp;&nbsp; soit $`d\overrightarrow{p}=\dfrac{dm}{dt}\,\overrightarrow{\mathscr{v}}+m\,\dfrac{d\overrightarrow{\mathscr{v}}}{dt}`$

* Pour une **particule** *de masse constante* au cours de son déplacement, le **travail élémentaire**
de la *force totale* $`\overrightarrow{F}_{tot}`$, somme des forces
*$`\displaystyle\sum_i\overrightarrow{F_i}=\overrightarrow{F}_{tot}`$* qui s'exercent sur la particule s'écrit :   
<br>
$`\begin{align}
\color{brown}{\mathbf{\large{\overrightarrow{F}_{tot}\cdot\overrightarrow{dl}}}} & =\left(m\,\dfrac{d\overrightarrow{\mathscr{v}}}{dt}\right)\cdot\big(\overrightarrow{\mathscr{v}}\,dt\big)\\
& =m\,\left(\dfrac{d\overrightarrow{\mathscr{v}}}{dt}\cdot\overrightarrow{\mathscr{v}}\right)\,dt\\
& =m\,\left(\dfrac{1}{2}\,\dfrac{d\big(\overrightarrow{\mathscr{v}}\cdot\overrightarrow{\mathscr{v}}\big)}{dt}\right)\,dt\\
& =m\,\left(\dfrac{1}{2}\,\dfrac{d\,\mathscr{v}^2}{dt}\right)\,dt\\
& \color{blue}{\mathbf{\large{=d\left(\dfrac{m\,\mathscr{v}^2}{2}\right)}}}\\
& \color{brown}{\mathbf{\large{=d\mathcal{E}^{cin}}}}\\
\end{align}`$

* Par définition, l'**énergie cinétique**, de notation **$`\mathbf{\mathcal{E}^{cin}}`$** est :   
<br>
$`\color{brown}{\large{\mathbf{\mathcal{E}^{cin}=\dfrac{m\,\mathscr{v}^2}{2}}}}\color{blue}{\large{\mathbf{\;=\dfrac{p^2}{2\,m}}}}`$


! *Remarque :* 
!
! En physique classique, comme le vecteur vitesse $`\vec{\mathscr{v}}`$ qui entre dans sa définition,    
! L'*énergie cinétique* est une grandeur physique *relative*, car elle *varie d'un référentiel d'inertie (galiléen) à un autre*.


* La **circulation de la force totale** s'exerçant sur un corpuscule e masse constante,
évaluée sur une portion de *trajectoire d'extrémités $`A`$ et $`B`$* s'écrit :  
<br>
$`\begin{align}
\color{brown}{\large{\mathbf{\displaystyle\int_A^B\overrightarrow{F}_{tot}\cdot\overrightarrow{dl}}}} & =\int_A^B d\left(\dfrac{m\,\mathscr{v}^2}{2}\right)\\
& =\int_A^B d\mathcal{E}^{cin}\\
\\
& \color{brown}{\large{\mathbf{\;=\mathcal{E}^{cin}(B)-\mathcal{E}^{cin}(A)}}}\\
\\
& \color{blue}{\large{\mathbf{\;=\overset{B}{\underset{A}{\Large{\Delta}}}(\mathcal{E}^{cin})}}}\\
\end{align}`$
<br>


#### Que dit le théorème de conservation de l'énergie mécanique ?

##### Dans un référentiel d'inertie (= galiléen)

![](theorem-mechanical-energy-conservation_L800.gif)

* **Lorsque** la *force totale* qui s'applique à une particule *est conservative*,   
  <br>
  $`\color{brown}{\mathbf{\large{\overrightarrow{F}_{tot}=\overrightarrow{F}_X}}}`$   
  <br>
  **alors,**   
  <br>
  $`\left.\begin{array}{l}
  \overrightarrow{F}_{tot}\cdot\overrightarrow{dl}=+\;d\mathcal{E}^{cin}\\
  \overrightarrow{F}_{tot}\cdot\overrightarrow{dl}=-\;d\mathcal{E}^{pot}\\
  \end{array}\right\}`$$`\Longrightarrow
  \color{brown}{\mathbf{\large{d\mathcal{E}^{cin}+d\mathcal{E}^{pot}=0}}}`$   
  <br>
   $`\quad\Longrightarrow
  \color{blue}{\mathbf{\large{d\,\big(\mathcal{E}^{cin}+\mathcal{E}^{pot}\big)=0}}}`$   
  <br>
   $`\quad\Longrightarrow
  \color{brown}{\mathbf{\large{d\mathcal{E}^{méc}=0}}}`$   

* Par définition, l'**énergie mécanique**, de notation **$`\mathcal{E}^{méc}`$**, est :   
  <br>
  $`\color{brown}{\mathbf{\large{\mathcal{E}^{méc}=\mathcal{E}^{cin}+\mathcal{E}^{pot}}}}`$ 

* Par intégration sur une portion de trajectoire d'extrémités $`A`$ et $`B`$ :
  <br>
    $`\left.\begin{array}{l}
  \int_A^B\overrightarrow{F}_{tot}\cdot\overrightarrow{dl}=+\;\overset{B}{\underset{A}{\large{\Delta}}}\mathcal{E}^{cin}\\
  \int_A^B\overrightarrow{F}_{tot}\cdot\overrightarrow{dl}=-\;\overset{B}{\underset{A}{\large{\Delta}}}\mathcal{E}^{pot}\\
  \end{array}\right\}`$
$`\Longrightarrow\color{brown}{\mathbf{\large{\overset{B}{\underset{A}{\Large{\Delta}}}\mathcal{E}^{cin}+\overset{B}{\underset{A}{\Large{\Delta}}}\mathcal{E}^{pot}=0}}}`$   
  <br>
$`\quad\Longrightarrow\color{blue}{\mathbf{\large{\overset{B}{\underset{A}{\Large{\Delta}}}\big(\mathcal{E}^{cin}+\mathcal{E}^{pot}\big)=0}}}`$   
  <br>
$`\quad\Longrightarrow\color{brown}{\mathbf{\large{\overset{B}{\underset{A}{\Large{\Delta}}}\mathcal{E}^{méc}=0}}}`$


  
-





 
<!--Pour que le signe du potentiel permette de définir bune grandeur qui se conserve l'énergie

Dans un référentiel galiléen, Force d'une interaction s'exercant sur une pârticule sensible à cette interaction :

---> 







