---
title: 'Framework of a fictif euclidian space-time'
published: true
routable: true
visible: false
lessons:
    -
      slug: from-classical-to-relativistic-universe-through-euclidian-space-time
      name: CONCEPT : Espace-temps euclidien, étape conceptuel entre univers classique et relativiste.
      order: 2
---


<!---------------------------
lessons:
    - slug: stationary-electric-field
      order: 2
----------------------------->

<!--MétaDonnée : ... -->

$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Colline

---------------------------

*Cadre __fictif__ d'un espace-temps euclidien :*   

##### Un ESPACE-TEMPS euclidien : étape conceptuelle

<br>

RÉSUMÉ
:
*Corps* :   
\- tout être ou objet matériel localisé dans l'espace-temps.   
*Observateur* :   
\- Corps percevant l'espace et le temps, et d'autres corps dans l'espace et le temps.   
\- Il peut mesurer des durées $`\Delta t`$ et des longueurs $`\Delta l`$ à l'aide d'une 
horloge et d'une règle, immobiles par rapport à lui le temps de la mesure.    
\- Il repère la position de corps dans l'espace-temps en choisissant une origine 
de l'espace-temps et des coordonnées $`(x,y,z,t)`$.   
*Autres corps dans l'espace-temps* :   
\- immobiles ou en mouvements par rapport à un observateur.  
\- et repérés par leurs coordonnées spatio-temporelles $`(x,y,z,t)`$.   
*Évènement* :   
\- position dans l'espace-temps d'un corps, d'une interaction ou d'une
coïncidence entre deux ou plusieurs corps.   
*Espace-temps euclidien* :   
$`\Longleftrightarrow`$ il existe des systèmes de coordonnées rectilignes spatio-temporels 
$`(O,x,y,z,t)`$ appelées cartésiennes, tels que, pour tout couple d'évènements $`A`$ 
et $`B`$, le résultat de la mesure 
$`s_{AB}=\sqrt{c^2\Delta t_{AB}^2+\Delta x_{AB}^2+\Delta y_{AB}^2+\Delta z_{AB}^2}`$    
\- avec c une 
constante fondamentale de l'espace-temps ayant la dimension d'une vitesse, est le 
même pour tout observateur.   
\- écriture $`\Delta u_{AB}^{\;2}=(u_B-u_A)^2`$, avec $`u`$ une coordonnée.   
*Perception de l'espace et du temps par un observateur*.  
\- l'observateur vit l'instant présent d'un temps fléché du passé vers le futur.   
\-  à chaque instant $`t`$, l'observateur perçoit un espace euclidien :    
il existe des systèmes de coordonnées spatiales $`(O,x,y,z)`$ appelées cartésiennes
tels que, pour tout couple de points $`C`$ et $`D`$, le résultat de la mesure 
$`\Delta l_{CD}=\sqrt{\Delta x_{CD}^2+\Delta y_{CD}^2+\Delta z_{CD}^2}`$   
est le même pour tout autre 
observateur immobile par rapport au premier et au même instant.   
*Ligne d'univers d'un corps* :   
\- ensemble des positions $`(x,y,z,t)`$ de l'espace-temps occupées par le corps.   
\- équation de la ligne d'univers : fonction $`f(x,y,z,t)`$ des coordonnées spatio-temporelles
d'une ligne d'univers telle que $`f(x,y,z,t)=0`$.   
*Observateur galiléen* :   
$`\Longleftrightarrow`$ un corps soumis à aucune interaction est observé immobile 
  ou se déplaçant selon une ligne d'univers rectiligne.   
*D'observateur galiléen à observateur galiléen*,   
en translation rectiligne l'un par rapport à l'autre à la vitesse constante $`V`$ 
selon une direction $`\Delta`$ :   
\- facteur de Lorentz : $`\Gamma = \dfrac{1}{\sqrt{1-V^2/c^2}}`$.   
Chaque observateur observe pour les corps en mouvement une même :   
\- dilatation des longueurs dans la direction $`\Delta`$ 
d'un rapport $`\Gamma`$.   
\- conservation des longueurs dans la direction perpendiculaire à $`\Delta`$   
\- contraction des durées, d'un rapport $`\Gamma`$.   
*Caractère absolu ou relatif d'une grandeur* :   
\- relatif : dont la valeur mesurée dépend de l'observateur.   
\- absolu : dont la valeur mesurée est la même pour tous les observateurs.   
*Caractère des grandeurs usuelles*.  
\- relativité des longueurs $`\Delta l`$    
\- relativité des durées $`\Delta t`$.  
$`\Longrightarrow`$ relativité des angles $`\varphi = \text{arctg}(\Delta l_{opposé} / \Delta l_{adjacent})`$.  
$`\Longrightarrow`$ relativité des vitesses linéaires $`\mathscr{v} = \Delta l / \Delta t`$.    
$`\Longrightarrow`$ relativité des accélérations linéaires $`a = \Delta\mathscr{v} / \Delta t`$.  
$`\Longrightarrow`$ relativité des vitesses angulaires $`\omega = \Delta \varphi / \Delta t'`$.  
$`\Longrightarrow`$ relativité des accélérations angulaires $`\dpt{\omega} = \Delta \omega / \Delta t'`$.  

(note pour le rédacteur : il y aura bien un équivalent à ce cours de niveau inférieur, niveau plaine)


## <p style="font-size:70%;text-align: center;">Premiers pas vers<br>la révolution conceptuelle qui t'attend</p>

#### Une étape importante

* Un **espace-temps euclidien** est une *étape vers la relativité* restreinte, puis générale d(Einstein.
* Il permet de visualisaer et de **comprendre la nature géométrique** *des paradoxes apparent* (pour notre intuition) de la relativité.
* Les **effets relativistes** dans ce chapitre, sont de même nature, mais *inversés par rapport à la relativité*.

#### Penser l'espace et le temps différemment

![](espace-temps-euclidien-1_v2_L1200.gif)   
_Représentation symbolique : des corps immobiles et en mouvements ont chacun leur propre perception de l'espace et du temps._


* Il n'existe plus d'espace et de temps universelle.
* Des **corps** (êtres vivants observateurs, objets, tout corps matériel) **immobiles ou en mouvement** 
  les uns par rapport aux autres *dans un espace-temps** ici fictif et euclidien.   

!! *Pour aller plus loin* :
!! * L'espace-temps minkovskien de la *relativité restreinte* est une modélisation plus étrange mais beaucoup 
!! *plus précise, explicative et prédictive de l'univers* 
!!  dans lequel nous sommes nés, que la mécanique classique.
!! * *En ce sens*, la relativité restreinte n'est pas une fiction, mais elle te donne une vision 
!! certes à première vue étrange mais *"plus réaliste"* que la très intuitive mécanique classique.
!!
!! <details markdown=1>
!! <summary>Des modèles encore plus réalistes</summary>
!! * L'espace-temps de type riemannien de la *relativité générale* donne une vision *encore plus réaliste*.
!! <br>
!! * Sur le chemin de la compréhension ultime de note Univers, Une *autre révolution conceptuelle très différente*
!! et tout aussi étrange sera pour toi la découverte de la *mécanique quantique*.   
!! * La mécanique quantique non relativiste de permettra de comprendre le comportement très étrange du monde des
!! particules élémentaires, mais avec des applications macroscopiques et technologiques majeures.
!! * La mécanique relativiste restreinte a permi de prédire l'existence de l'anti-matière avant sa découverte expérimentale.
!! * L'unification de la relativité générale et mécanique quantique, résistent à ce jour aux physiciens.
!! * De par leurs natures fondamentalement différentes, déterministe pour la relativité, et probabiliste pour la mécanique
!! quantique, ces deux théories exptrèmement prédictives dans leurs domaines respectifs, semblent irréconciliables.
!! * Dans leur recherche d'une théorie du Tout, nombres de physiciens pensent qu'une réponse éventuelle nécessitera
!! une nouvelle et totale révolution conceptuelle.
!! </details>
!! <br>
!!

* Chaque **corps** à *sa propre perception de l'espace et du temps*,   
  <br>
  et les **résultats de mesure** effectués sur un même évènements lui sont *propres*.

#### Une classe de corps partageant une même perception de l'espace temps.

![](espace-temps-euclidien-2_v2_L1200.gif)   
_Représentation symbolique : des corps galiléens immobiles les uns par rapport aux autres partagent leur propre perception de l'espace et du temps._


* Tous les **corps immobiles par rapport à un corps galiléen**
   * *percoivent un même espace-temps*,   
   * et donc *partagent les mêmes résultats de mesures* effectuées sur un même évènement.

!! *Pour aller plus loin* :
!! Ce point sera à la base de la *notion de référentiel* qui sera vue au niveau Contreforts :<br>
!! Un référentiel sera défini comme un observateur muni d'une règle et d'une horloge, et tout objet
!! de position fixe par rapport à cet observateur.

<br>

# <p style="font-size:60%;text-align: center;">Un ESPACE-TEMPS EUCLIDIEN</p>

## <p style="font-size:70%;text-align: center;">espace-temps euclidien... à changer</p>

#### Quelle différence entre un espace et un temps indépendants, et un espace-temps ?

A faire

<!-----------

##### Un espace et un temps indépendants

* **Deux mots, "espace" et "temps"**, pour parler de notre perception de l'espace et du temps, montre
  bien qu'il s'agit de *deux réalités* vécues percues comme *distinctes et indépendantes*, de *natures différentes*.

* L'**espace a trois dimensions**, ce qui signifie qu'il faut et il suffit de *trois nombres réels* appelés
  "coordonnées spatiales" souvent notées $`(x_P,y_P,z_P)`$ *pour localiser de façon unique tout point* P dans l'espace.   
  <br>
  Connaissant les coordonnées spatiales de deux points dans l'espace, il est possible de quantifier un **intervalle d'espace**
  entre ces deux points, représenté par un nombre réel dont la valeur ne dépend pas des coordonnées choisies, 
  en définissant une *notion de distance* entre ces deux points.

* Le **temps a une seule dimension**, ce qui signifie qu'il faut et il suffit d'*un seul nombre réel* appelé
  "coordonnée temporelle" ou "date" souvent noté $`t`$ *pour localiser de façon unique un instant* dans le temps.   
  <br>
  Connaissant les dates de deux instants dans le temps, il est possible de quantifier l'**intervalle de temps**
  entre ces deux instants, en définissant une *notion de durée* entre ces deux instants.

* **Distance** et **durée** sont de natures différentes, comme l'espace et le temps, et *ne peuvent se comparer*. 

##### Un espace-temps

* **Un seul mot "espace-temps"** pour parler de l'espace et du temps, montre que sous ces deux réalités d'apparences différentes
  se cache *une seule réalité* dans laquelle *l'espace et le temps sont liés*, et donc non indépendants.

* L'espace-temps a trois plus une égale quatre dimensions, ce qui signifie qu'il faut et il suffit 
  de *quatre nombres réels* appelés "coordonnées spatio-temporelles" souvent notées $`(x_P,y_P,z_P, t_P)`$ 
  *pour localiser de façon unique tout évènements* P se produisant dans l'espace-temps.  

* Connaissant les coordonnées spatio-temporelles de deux évènements situés dans l'espace-temps, il doit être possible
  de quantifier l'**intervalle d'espace-temps**
  entre ces deux évènements, en définissant une *distance-spatio-temporelle* entre ces deux évènements.

* Cette distance spatio-temporelle combine à la fois la distance spatiale et la distance temporelle. 


#### Qu'est-ce qu'une distance dans un espace-temps?

* L'**espace et le temps** sont intuitivement *perçus de natures différentes*,
   * un **intervalle d'espace** ou **distance** $`\Delta l_A^B`$ entre deux points $`A`$ et $`B`$ à la *dimension d'une longueur* 
   notée [L],   
   _et dans le système international d'unités, se mesure en mètre (m)._
   * un **intervalle de temps** ou **durée** $`\Delta t_C^D`$ entre deux instants $`t_C`$ et $`t_D`$ à la *dimension d'un temps* 
   notée [T],   
   _et dans le système international d'unités, se mesure en seconde (s)._

* Pour **rendre comparable un longueur et une durée**, *multiplie toute durée $`\Delta t`$ par $`c`$*, 
  un nombre réel constant auquel tu associes la *dimension d'une vitesse, noté [V]*=[L]/[T].   
  _Dans le système international d'unités, $``c``$ se mesure en mètre par seconde (ms<sup>-1</sup>)._

  Ainsi la quantité **$`c\Delta t`$** sera de *même nature qu'une longueur $`\Delta l`$*.


_animation 1_
_1 - Tout observateur ou corps matériel ne perçoit que l'instant présent d'un temps fléché du passé vers le futur._
_2 - à chaque instant il perçoit un espace à 3 dimensions,_
_3 - et d'autres corps matériels immobiles (a) ou en mouvement (b) par rapport à lui._
L'espace se reproduit à chaque instant.

_animation 2_
_1 - L'observateur dispose mesure des durées avec une horloge immobile par rapport à lui.
_2 - dipose d'une règle mesure des longueurs avec une règle rigide immobile par rapport à lui.






## <p style="font-size:70%;text-align: center;">Perceptions propres d'un observateur galiléen<br>dans un espace-temps euclidien</p>



#### Qu'est-ce qu'un observateur ?


#### Qu'est-ce qu'un observateur galiléen ou d'inertie ?


#### Que perçoit un observateur galiléen dans un espace-temps euclidien?

<!-------------
>
* L'**observateur** vit dans l'*instant présent d'un temps fléché du passé vers le futur*.   
  <br>
  Il mesure le temps avec une **horloge immobile par rapport à lui-même**. 
  L'ensemble des *corps immobiles* par rapport à lui
   * l'observateur
   * 
  
  partagent *un même écoulement du temps*, que cela soit :
   * le mécanisme d'oscillation dans son horloge.
   * ses pensées
   * ses processus biologiques (vieillissement cellulaire ou division cellulaire) se produiront à la même vitesse.
   * sa durée de vie ne sera ni augmentée, ni diminuée.
   
   
  Sa perception du temps est identique à celle d'un observateur dans 
  l'espace et le temps universels et indépendants de la mécanique classique, sauf que le temps
  n'est pas universelle, l'observateur et tout corps immobile par rapport à lui vivent dans son temps propres,
  ou partagent le même temps propre.
  <br>

* L'observateur vit dans un *espace euclidien à trois dimensions*, c'est à dire
  il existe des systèmes de coordonnées de l'espace $`(O,x,y,z)`$ couvrant tout l(espace et appelées 
  cartésiens, tels que pour tout points $`A`$ et $`B`$ dans l'espace, à tout instant $`t`$ de son temps propre, le résultat de la mesure 
  $`\Delta l_{AB}(t)=\sqrt{\Delta x_{AB}^2(t)+\Delta y_{AB}^2(t)+\Delta z_{AB}^2(t)}`$    
  \- avec écriture $`\Delta u_{AB}(t)^{\;2}=(u_B(t)-u_A(t))^2`$, avec $`u`$ une coordonnée spatiale.  
  <br>
  Sa perception de l'espace est identique à celle d'un observateur dans l'espace euclidien de la mécanique classique.   

![observateur, sa grille spatiale et son temps]()

* En particulier, à tout instant :
   * L'**écart entre deux droites parallèles** reste *constant*.
   * Le **rapport entre la circonférence $`C`$ et le rayon $`R`$** de tout cercle égale
     *deux fois le nombre $`\pi=3,14159...`$* :   
     **$`C=2\,\pi\,R`$**
   * La **somme des angles aux sommets de tout triangle** égale le *nombre $`\pi=3,14159...`$*.

![la grille spatiale et droites parallèles, propriétés du cercle et triangle]()






------------->


<br>

## <p style="font-size:70%;text-align: center;">Corps matériels et observateurs galiléens</p>


#### Observateur et corps matériel

A faire

<br>

#### L'observateur, son espace et son temps propres

A faire

<br>


#### L'observateur ou un corps, son espace et son temps propres

A faire

<br>


#### La ligne d'univers d'un observateur ou d'un corps matériel

A faire

<br>


#### L'observateur galiléen

A faire

<br>

#### Mouvement relatif entre observateurs,<br> non galiléens et galiléens

A faire

montrer qu'un déplacement de translation uniforme entre deux observateurs correspond
à une rotation de leur projection propre de l'esoace-temps, d'un angle   
$`\alpha = \arctan\left(\dfrac{V}{c}\right)`$


<br>

## <p style="font-size:70%;text-align: center;">Dilatation des longueurs , contraction du temps , relativité de la simultanéïté</p>


#### Présentation de la scène d'étude :<br> un train, une gare et des personnages

##### Les personnages

* Pour accompagner les démonstrations, considère *quatre personnages* auxquels
tu pourras t'identifier,   
**Alba, Benjamin, Chloé, Dylan**   
qui seront *respectivement représentés* ou symbolisés sur les animations par les 
lettres *A, B, C, D*.

* *Chacun possède* 
   * **une montre** identique aux autres, qui lui indique son *temps propre*, et lui
     permet de déterminer des **durées propres** entre deux évènements.
   * **une règle rigide** identique aux autres qui lui permet de mesurer des *distances propres*
     (entre deux corps) et des *longueurs propres* d'un corps rigide dans toutes les directions
     possibles.
  
A faire : figure des 4 personnages avec chacun sa montre et sa règle rigide.

##### Les procédures de mesure

* Les déterminations de *date*, les mesures de *durées* se font **montre immobile**
  par rapport à l'observateur.

* Les déterminations de *distance* ou de *longueurs* sont réalisées par 
  deux **mesures de position à un même instant** et avec la **règle immobile** par rapport à l'observateur.
  
<!--

* La *synchronisation entre montres* se fait au même instant, montres immobiles
  par rapport à leur observateur, observateurs immobiles entre eux.
-->


##### La scène

* **Benjamin, Chloé et Dylan** sont *assis dans un train*,
   * **Benjamin et Chloé** sur des places situées sur une *même rangée*.
   * **Benjamin et Dylan** sur des places *coté fenêtre* d'un même côté du train.
* **Alba** est debout, *immobile sur le quai* de la gare.
   
* Les *animations* sont faites à tout instant où **Alba, Benjamin et Chloé** 
  *sont alignés*, donc perpendiculairement à la direction des rails.   

*  *Deux cas* sont étudiés, lorsque   
   1. le **train** est *à l'arrêt* en gare.
   2. le **train** *passe en gare à vitesse constante*, donc sans s'arrêter, les rails étant rectilignes.

A faire : figure des deux cas.

<br>

!! Pour aller plus loin : A faire
!! Le rôle de l'avènement des chemins de fer à la fin du 19<sup>ème</sup> siècle,
!! sur le chemin de la révolution relativiste des notions d'espace et de temps,
!! avant, clochers des villages sonnaent midi quand le soleil était au zénith, problème
!! chaque village avait sa propre heure, chemin de fer nécessite de définir un temps
!! (classique) uniforme à l'échelle d'un compagbie de chemin de fer, d'un pays...
!! D'où un départ de réflexions ... Einstein,
!! et ici le choix du train pour étudier les effets relativistes.

<br>

#### Voyageurs assis dans le train : un espace et un temps partagé

A faire

!! *Pour aller plus loin* , à faire   
!! Vers la notion de référentiel (niveau 3 et 4), et notamment discussion de
!! la définition d'un référentiel parfois rencontrée qui inclut tous les corps
!! immobiles entre eux. En retrouver.


#### Le train est stationné en gare, immobile

<br>

![](train-speed-0-persons-ABCD_L1200.jpg)

à faire, continuer, améliorer

* **Benjamin, Chloé et Dylan** sont *assis dans le train*. 
* **Alba** est *sur le quai* de la gare, devant le *train à l'arrêt*.
* Tous, Alba, Benjamin, Chloé, et Dylan sont *immobiles les uns par rapport aux autres*,   
  donc **leurs lignes d'univers sont parallèles** entre elles,   
  ils partagent **un même temps**,   
  et toutes les **durées** qu'ils mesureront *entre deux mêmes évènements* donneront le
  **même résultat**.

* A chaque instant, ils partagent alors **un même espace**,    
  donc les **mesures de distance** qu'ils réaliseront entre eux-mêmes ou entre deux mêmes objets,
  les mesures **de longueurs d'objets selon toutes les directions** possibles, leurs 
  donneront le **même résultat**.

* Ainsi **deux évènements sumiltanés pour l'un** d'entre eux seront *simultanés pour les autres*.

* Leurs montres indiquent respectivement les temps :   
$`\hspace{1cm}t_A`$ pour Alba,     
$`\hspace{1cm}t_B`$ pour Benjalin,         
$`\hspace{1cm}t_C`$ pour Chloé,      
$`\hspace{1cm}t_D`$ pour Dylan.    
<br>
**S'ils synchronisent leurs montres**, alors à tout instant leurs montres indiquent
la *même heure* :   
*$`\hspace{1cm}t_A = t_B = t_C = t_D`$*

<br>

figure à faire, partage d'un même espace instantané pour A, B, C et D






<br>

![](train-speed-0-persons-BCD_2_L1200.jpg)

<br>

#### Le train ne s'arrête pas, il passe en gare à grande vitesse

<br>

![](train-speed-V-persons-ABCD_L1200.jpg)

<br>

![](train-speed-V-persons-BCD_2_L1200.jpg)

<br>

##### A faire : conservation des longueurs perpendiculaires au déplacement

figures et animations à faire

première figure ;

![](train-euclidian-spece-time-conservation-perpendicular-V-distances-1-v4.gif)

deuxième figure :

à faire

<br>

##### A faire : dilatation des longueurs dans le sens du déplacement

figures et animations à faire

première figure : (longueurs différentes)

![](train-euclidian-spece-time-dilatation-parallel-V-distances-1_L1200.gif)

deuxième figure : (démonstration du rapport de dilataion)   

à faire

<br>


##### A faire : relativité de la simultanéïté

figures et animations à faire

<br>

##### A faire : contraction du temps

figures et animations à faire

<br>

##### A faire : la loi de compsition des vitesses

figures et animations à faire

<br>

## <p style="font-size:70%;text-align: center;">Des paradoxes apparents qui n'en sont pas</p>

A faire

<br>


## <p style="font-size:70%;text-align: center;">Cônes de lumières</p>

A faire

![](euclidian-space-time-3D-A-1_L1200.gif)
_test de figure,<br>

<br>


## <p style="font-size:70%;text-align: center;">figure en attente<br> de positionnement</p>


![](maxim-1-euclidian-space-time-fr_L1200.jpg)   

![](maxim-1-euclidian-space-time-es_L1200.jpg)   

![](maxim-1-euclidian-space-time-en_L1200.jpg)   

<br><br>

![](maxim-2-euclidian-space-time-fr_L1200.jpg)   

![](maxim-2-euclidian-space-time-es_L1200.jpg) 

o

![](maxim-2bis-euclidian-space-time-es_L1200.jpg) 

![](maxim-2-euclidian-space-time-en_L1200.jpg)   


choix des coordonnées xyt pour la prochiane figure

<br>

et autres figures à venir

Chapitrage :

A

I - ... (système de coordonnées propores d'un observateur)

Système de coordonnées spatiotemporelles : (x,t) (x,y,t) (x,y,z,t)

Ligne d'univers

Perception spatiale instantanée


II - Observation de corps immobiles ou en mouvement

III Système de coordonnées propres d'un corps en mouvement

IV Transformation des durées et des longueurs

B

I relativité de l'espace temps

II principe de relativité d'Einstein

III Les transformations de Lorentz

C (Dynamique des corps en mouvement relatifs)

D (Ebergétique des xorps en mouvement relatifs)




<br>
