---
title: 'The concept of light ray '
media_order: 'rays_forest.jpg,viajar1.jpg,OG_rayons_foret.mp3,OG_rayons_foret.ogg'
---

### Fundamentals of geometric optics

#### Geometric optics: <br> a simple physical model.

Its *fundamentals* are:
* The concept of **light ray** : oriented trajectory of light energy
* The concept of **refractive index** : characterizes the apparent speed of light in a homogeneous medium
* The **Fermat's principle**

##### Ray of light

![](rays_forest.jpg)

<!--For the audio:
Walking in the forest on a hot summer day is a huge pleasure. The contrast between the freshness of the shaded parts by the foliage and the tree trunks, and the heat in the direct sunlight is striking. The beams of direct light increase the temperature of the air, making you sweat, and hit your skin giving you this slight sensation, not unpleasant because mastered, burning. The light carries energy .... As you walk, you can anticipate, hurry to the arrival of a shaded area, because the play of light with the trees zebra the space around you. In the air with the unique and wonderful scents of the forest, the rays of light propagate in straight lines, they follow the path of propagation of the luminous energy .-->

[AUDIO : _the intuition of the "ray of light" during a walk in the forest_](OG_rayons_foret.mp3)

The **light rays** are *oriented lines* that in each of their points indicate the *direction of propagation of the luminous energy*.

The light rays follow *straight lines in a homogeneous medium*.

Light rays *do not interact with each other*

##### The refraction index

**Refractive Index $`n`$** &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
**$`n \; = \; \dfrac{c}{v}`$**
* **`c`** : *speed of light in vacuum* (absolute limit)
* **`v`** : *speed of light in the middle* homogeneous

**$`\Longrightarrow \: : \: n`$** : physical dimension **without dimension** and **always > 1**.

Dependency : **$`n \; = \; n (\nu) \; \; \; `$**, or **$` \; \; \; n \; = \; n (\lambda_0) \; \ ; \; `$** *(with $`\lambda_0`$ wavelength in vacuum)*

<!--
I wanted to make this important remark here, but it is not simple: with Doppler effect, medium of propagation does not move with respect to the observer ... I must think to make the warning in the main text, and a summary of all this in for example a parallel 1:

!!!! ATTENTION: the $`\nu`$ frequency of a wave (temporal magnitude) measured by a given observer does not depend on the propagation 
!!!! medium in which the measurement takes place. This is not the case of the measured wavelength $`\lambda`$, which depends on the propagation medium because the propagation speed of the $V$ wave may depend on this medium. Frequency, wavelength and speed of propagation of a wave are related
!!!! by the equation $'\lambda\;=\;\dfrac{V}{\nu}'$, but : <br>
!!!! the **fundamental quantity** (independent of the middle) is the **frequency $`\nu`$ (the temporal magnitude)**.
-->

!! TO GO FURTHER :
!!
!! over the entire electromagnetic spectrum and for any medium:
!! $`n`$: complex value dependent on the $\nu$ frequency of the electromagnetic wave, strong variations representative of all light / matter interaction mechanisms: $`n (\nu) = \Re[n(\nu )] + \Im[n(\nu)]`$ <br>
!!
!! In the visible domain (where $`\lambda_0`$ is more used than $`\nu`$) and for transparent medium : <br>
!! real value, small variations of $`n`$ with $`\lambda_0`$ $`\left(\frac{\Delta n}{n} < 1\%\right)`$

##### Optical path

**optical path** *$`\delta`$* &nbsp;&nbsp;&nbsp;&nbsp; $`=`$
**euclidean length** *$`s`$* &nbsp;&nbsp;&nbsp; $`\times`$ &nbsp;&nbsp; **refractive index** *$`n`$*

* **$`\Gamma`$** : *path (solid line) between 2 fixed points A and B*
* **$`\mathrm{d}s_P`$** : *element of infinitesimal length at point P on path $`\Gamma`$*
* **$` n_P`$** : *refractive index at point P*
* **$`\mathrm{d}\delta_P`$** : *infinitesimal optical path at point P on path $`\Gamma`$*

Optical path along a path between 2 fixed points A and B :
**$`\delta\;=\;\displaystyle\int_{P \in \Gamma}\mathrm{d}\delta_P\;`$$`=\;\displaystyle\int_{P \in \Gamma}n_P\cdot\mathrm{d}s_P`$**

* **$`\delta`$** $`=\displaystyle\int_{\Gamma}n\cdot\mathrm{d}s\;=\;\int_{\Gamma}\dfrac{c}{v}\cdot\mathrm{d}s`$ = $`c\;\displaystyle\int_{\Gamma}\dfrac{\mathrm{d}s}{v}`$ = *$`\;c\;\tau`$*
* **$`\delta`$** is *proportional to the travel time*.

