---
title: 'Gauss local distribution cylindrique'
published: true
routable: true
visible: true
lessons:
    -
        slug: electrostatics-cylindrical-charge-direct-gauss-integral-local
        order: 3
    -
        slug: plane-cylindrical-spherical-distribution-gauss-local-overview
        order: 2
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. 
!!!! Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

##### Application du théorème de **Gauss local** aux :  
------------------------------------------------------

### **Distributions cylindriques de charge** 

#### Comment sont-elles définies ?

* La distribution de charge possède un **axe unique de révolution**.
* Tout **plan contenant l'axe de révolution** est *plan de symétrie* pour la charge électrique.

#### Quel repère de l'espace choisir ?

* Repère de l'espace adapté :     
   **Repère cylindrique  $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, z)}`$**       
      avec **$`\mathbf{Oz}`$ = axe de révolution**.
      
#### Comment caractériser un distribution de charge à symétrie cylindrique ?

* Une distribution de charge est décrite par une **densité de charge $`\dens`$**.
      
*  **Invariance par rotation d'angle $`\Delta\varphi`$ quelconque**  
  **$`\mathbf{\Longrightarrow \dens}`$**$`=\require{\cancel} \dens(\rho,\xcancel{\varphi}, z)`$
  **$`\mathbf{ =\dens(\rho, z)}`$**
  
<br><br>
  
### **Distributions cylindriques de charge,<br> invariantes par translation quelconque selon $`z`$**
     
#### De quelles coordonnées dépend $`\dens`$ ?

* **Étude des invariances** *de la distribution de charges $`\dens`$* :

![](electrostatics-gauss-cylindrical-charge-distribution-1-v7_L1200.gif)   
_cylindre infini uniformément chargé en volume. Corriger_ $`\vec{e_r}`$ _en_ $`\vec{e_{\rho}}`$.

* invariance par rotation d'angle $`\Delta\varphi`$ quelconque $`\require{\cancel}\Longrightarrow \dens= \dens(\rho,\xcancel{\varphi}, z)`$
* invariance par translation de longueur $`\Delta z`$ quelconque $`\require{cancel}\Longrightarrow \dens= \dens(\rho,\varphi, \xcancel{z})`$

* *$`\mathbf{\left.\begin{array}{l}
\overrightarrow{\dens}=\overrightarrow{\dens}\,(\rho, z) \\
\overrightarrow{\dens}=\overrightarrow{\dens}\,(\rho, \varphi) 
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\dens=\dens(\rho)}`$**

#### De quelles coordonnées dépend  $`\overrightarrow{E}`$ ?

* **L'effet** possède les *invariances de sa cause* :   
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{E}}`$** possède les *invariances de $`\dens`$*   

* $`\mathbf{\dens=\dens(\rho)\Longrightarrow}`$**$`\mathbf{\overrightarrow{E}=\overrightarrow{E}(\rho)}`$** 

#### Comment déterminer la direction de $`\overrightarrow{E}`$ ?

* *Par l'* **étude des symétries** *de la distribution de charges $`\dens`$*.

![](electrostatics-gauss-cylindrical-charge-distribution-2-v7_L1200.gif) 
_figure temporaire à réviser : corriger_ $`\vec{e_r}`$ _en_ $`\vec{e_{\rho}}`$.

<!-------------------------------------------------------
* **$`\overrightarrow{E}`$** est un *vecteur polaire*.
* *$`\mathbf{\mathcal{P}_1=}`$* **$`\mathbf{\mathcal{P}_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})}`$** est *plan de symétrie* pour  $`\dens`$.
* *$`\mathbf{\mathcal{P}_2=}`$* **$`\mathbf{\mathcal{P}_2\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})}`$** est *plan de symétrie* pour  $`\dens`$.
* *$`\mathbf{\mathcal{P}_1\cap\mathcal{P}_2=\mathcal{D}(M, \overrightarrow{e_{\rho}})}`$* 
------------------------------------>

* **En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie} \\
P_2\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})\; \text{plan de symétrie}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**

#### Comment s'exprime  $`\overrightarrow{E}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\dens`$ :   
**En tout point $`M`$** de l'espace,   
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{E}=\overrightarrow{E}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}}}`$**

#### Quelle expression de la divergence de  $`\overrightarrow{E}`$ choisir ?

* L'étude se réalise dans le repère cylindrique  $`(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, z)`$

* $`\Longrightarrow`$ nous choisissons l'*expression en coordonnées cylindriques* de la divergence  :   
<br>
**$`\mathbf{div\overrightarrow{E}=
\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}
+\dfrac{\partial\,E_z}{\partial\,z}}`$**

#### Qu'implique la direction de $`\overrightarrow{E}`$ ?

* L'étude des symétries de la distribution de charge implique en tout point de l'espace :    
**$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**

* $`\Longrightarrow`$ les autres composantes de champ *$`\mathbf{E_{\varphi} \text{ et } E_z}`$ sont nulles* 
en tout point de l'espace :   
<br>
$`\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}=E_{\rho}\,\overrightarrow{e_{\rho}}+0\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}`$
  **$` \Longrightarrow\left\{
\begin{array}{l}
\mathbf{E_{\varphi}=0} \\
\mathbf{ E_z=0}
 \end{array}
 \right.`$**
 
* Si $`\mathbf{E_{\varphi}=E_z=0}`$ en tout point de l'espace $`\mathscr{E}`$, alors 
leur valeur nulle ne varie pas d'un point à un autre point voisin par translation 
élémentaire $`dz`$ ou variation élémentaire d'angle $`d\varphi`$.   
Donc *les dérivées partiellles de $`\mathbf{E_{\varphi}\text{ et }E_z}`$ par rapport 
à $`\mathbf{z\text{ et }\varphi}`$ sont nulles*.   
<br>
$`\mathbf{\forall M \in \mathscr{E}\, , E_{\varphi}=E_z=0}`$
  **$` \Longrightarrow\left\{
\begin{array}{l}
\mathbf{\dfrac{\partial E_{\varphi}}{\partial\varphi}=0 \;\;\text{ et } \;\;\dfrac{\partial E_{\varphi}}{\partial z}=0} \\
\mathbf{\dfrac{\partial E_z}{\partial\varphi}=0 \;\;\text{ et } \;\;\dfrac{\partial E_z}{\partial z}=0}
 \end{array}
 \right.`$**
 
* $`\Longrightarrow`$ l'expression de *la divergence de $`\overrightarrow{E}`$ se simplifie* en tout point de l'espace :   
* <br>
**$`\mathbf{div\overrightarrow{E}}`$**
$`\require{\cancel}=\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\xcancel{\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}}
+\xcancel{\dfrac{\partial\,E_z}{\partial\,z}}`$
**$`\mathbf{\quad\quad=\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}}`$**


#### Qu'impliquent les invariances de  $`\overrightarrow{E}`$ ?

* L'étude des invariances de la distribution de charge implique en tout point de l'espace :   **$`\mathbf{\overrightarrow{E}=\overrightarrow{E}(\rho)}=E_{\rho}(\rho)\,\overrightarrow{E_\rho}`$** 

* Dans l'espression $`\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}`$, le terme $`\rho\,E_{\rho}(\rho)`$ est une fonction de la seule coordonnée $`\rho`$. l'opérateur de dérivée partielle $`\dfrac{\partial}{\partial\,\rho}`$ peut être remplacée par l'opérateur de dérivée totale $`\dfrac{d}{d\rho}`$.

* $`\Longrightarrow`$  l'opérateur de dérivée partielle $`\dfrac{\partial}{\partial\,\rho}`$ 
peut être remplacée par l'opérateur de dérivée totale $`\dfrac{d}{d\rho}`$, et la divergence
$`\overrightarrow{E}`$ de se réécrit :   
<br>
**$`\mathbf{div\overrightarrow{E}=\dfrac{d\left(\rho\,E_{\rho}\right)}{d\rho}}`$**

#### Comment calculer $`\overrightarrow{E} ?`$

à terminer

<br>
$`\Longrightarrow`$ *différentes distributions de charge sont étudiées* dans la suite.

<br>


<br>

#### **1 -** Cylindre infini de rayon $`R`$ chargé uniformément en volume

##### Description de $`\dens`$ :

* **$`\left\{\begin{array}{ll}
\rho\le R \Longrightarrow \dens^{3D}(\rho)=\dens^{3D}_0 = cste\ne 0 \\
\rho\gt R \Longrightarrow \dens^{3D}(\rho)= 0
\end{array}\right.`$**   

* Nombre de sous-espaces complémentaires à prendre en compte : 2
   * sous-espace $`\mathscr{E}_{int}`$, caractérisé par $`\dens=\dens^{3D}_0`$ et tel que $`\rho\le R`$.
   * sous-espace $`\mathscr{E}_{ext}`$, caractérisé par $`\dens=0`$ et tel que $`\rho \gt R`$

<!--Cela peu paraître inutile car évident pour les professeurs, mais leurs cerveaux ont eu des années pour intégrer cela. La non conscience qu'il faille considérer différents cas selon la position du point M pour le calcul de $`Q_{int}`$  (que cela soit par manque de visualisation ou sous l'effet du stress d'un examen) est une cause non négligeable d'erreurs. D'où la volonté ici d'emphaser ce point en parlant de sous-espaces.--->

![](electrostatics-gauss-cylindrical-charge-distribution-4-v3_L1200.jpg)   
_figure temporaire à réviser._


<br>

--------------------------------

#### **2 -** Cylindre infini de rayon $`R`$ chargé non uniformément en volume

##### Description de $`\dens`$ :

* Prenons l'**exemple** de la distribution :

**$`\quad\left\{\begin{array}{ll}
\rho\le R \Longrightarrow & \dens^{3D}(\rho) = A\,\rho^2 \\
&\text{ avec }A = cste \ne 0 \\
\rho\gt R \Longrightarrow & \dens^{3D}(\rho)= 0
\end{array}\right.`$**   

<!--exemple2 à garder : \dens^{3D}(\rho) =  \dfrac{A}{\rho^2} -->


* Nombre de sous-espaces complémentaires à prendre en compte : 2
   * sous-espace $`\mathscr{E}_{int}`$, caractérisé par $`\dens=\dens^{3D}=A\,\rho^2`$ et tel que $`\rho\le R`$.
   * sous-espace $`\mathscr{E}_{ext}`$, caractérisé par $`\dens=0`$ et tel que $`\rho \gt R`$

à terminer

<br>

-----------------------

#### **3 -** Cylindre infini creux de rayons intérieur $`R_{int}`$ et extérieur $`R_{ext}`$ 

* description de $`\dens`$ :

**$`\quad\left\{\begin{array}{ll}
\rho\le R_{int} \Longrightarrow & \dens^{3D}(\rho) = 0 \\
R_{int} \le \rho\le R_{ext} \Longrightarrow & \dens^{3D}(\rho) \ne 0 \\
\rho\gt R_{int} \Longrightarrow & \dens^{3D}(\rho) = 0
\end{array}\right.`$**   

Nous pouvons considérer **2 méthodes équivalentes**

##### Théorème de Gauss en considérant 3 sous-espaces complémentaires

* Les sous-espaces complémentaires à prendre en compte sont : 
   * sous-espace intérieur $`\mathscr{E}_{int}`$, caractérisé par $`\dens=\dens^{3D}=0`$ et tel que $`\rho\lt R_{int}`$.
   * sous-espace milieu $`\mathscr{E}_{mil}`$, caractérisé par $`\dens=\dens^{3D}\ne 0`$ et tel que $`R_{int}\le\rho\le R_{ext}`$.
   * sous-espace extérieur $`\mathscr{E}_{ext}`$, caractérisé par $`\dens=\dens^{3D}=0`$ et tel que $`\rho \gt R_{ext}`$

à terminer

##### Utiliser le théorème de superposition

à terminer

<br>

-----------------------------

#### **4 -** Cylindre infini de rayon $`R`$ chargé uniformément en surface

* C'est, entre autre mais pas seulement,  le cas précédent dans la limite où $`R_{int}\longrightarrow R_{ext}=R`$)    
  $`\Longrightarrow \dens^{3D} \text{ est modélisée par } \dens^{2D} `$  
  
##### Description de $`\dens`$ :

* **$`\quad\left\{\begin{array}{ll}
\rho\lt R \Longrightarrow & \dens^{3D}(\rho) = 0 \\
\rho = R  \Longrightarrow & \dens^{2D}(\rho)=  \dens^{2D}_0=cst \ne 0 \\
\rho\gt R \Longrightarrow & \dens^{3D}(\rho) = 0 \\
\end{array}\right.`$**   

* Nombre de sous-espaces à prendre en compte : 2
   * sous-espace $`\mathscr{E}_{int}`$, caractérisé par $`\dens=\dens^{3D}_0`$ et tel que $`\rho\le R`$.
   * sous-espace $`\mathscr{E}_{ext}`$, caractérisé par $`\dens=0`$ et tel que $`\rho \gt R`$

à développer et terminer


<br>

--------------------------------

#### **5 -** Fil rectiligne infini uniformément chargé


<br>

-------------------------------

#### **6 -** Cylindres creux coaxiaux

Cas particulier où ils portent des charges opposées, lien avec le condensateur cylindrique. Parallélisme possible. 

(deux méthodes équivalentes)

Pour aller plus loin, discuter du caractère "cas d'école" de ces distributions,
et introduire le phénomène d'influence qui est au programme un peu plus tard, et qui a par ailleurs déjà été vu au niveau collines.













