---
title: 'Application du théorème de Gauss : 1° étape, symétries et invariances'
published: true
routable: true
visible: false
lessons:
    -
        slug: electrostatics-gauss-application-method-3
        order: 1
    -
        slug: gauss-integral-cylindrical-symmetry-3-method-main
        order: 1
    -
        slug: gauss-integral-cylindrical-symmetry-3-method-synthese
        order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

### Application du théorème de Gauss

#### Introduction

Dans les cas où il s'applique facilement, le **théorème de Gauss**, dans sa forme intégrale comme dans sa forme locale, *remplace des calculs directs* qui seraient *très complexes* à mener.

Pour cela, la **condition** est de *disposer d'un minimum d'informations* préliminaires à l'application du théorème. Il faut connaître :
* la **direction du champ électrique $`\overrightarrow{E}`$** en tout point $`M`$ de l'espace.
* le **nombre minimum de composantes** dont dépend du champ électrique $`\overrightarrow{E}`$, et **leur identification**.

Ces informations minimales sur le champ électrique $`\overrightarrow{E}`$,sont *extraites de l'étude des invariances et des symétries* de ses causes, c'est à dire dela  distribution de charge à l'origine de ce champ $`\overrightarrow{E}`$.

C'est pour cela que le théorème de Gauss n'est utilisable pour des distributions de charges simples, présentant des symétries et des invariances évidentes. 

Ces distributions de charges sont :
* des cylindres infinis pleins ou creux chargés.
* des sphères pleines ou creuses chargés.
* des plans infinis de toute épaisseur.

qui doivent en outre présenter les invariances et symétries adéquates.

Par contre, le théorème de superposition permet de déterminer le champ électrique de toute combinaison de ces distributions de charges.

!! *Pour aller plus loin* : *Théorème de Gauss et Électromagnétisme*
!!
!! L'étude du théorème de Gauss en électrostatique, à cette étape contrefort, permet de se familiariser avec les concepts, et de calculer le champ électrostatique $`\overrightarrow{E}`$ créé par des distributions immobiles de charge $`\dens`$ hautement invariantes et symétriques.
!!
!! *L'électromagnétisme permettra de calculer le champ électromagnétique $`(\overrightarrow{E}, \overrightarrow{B})`$ créé par des distributions de charges et de courants $`(\dens, \overrightarrow{j})`$ variables dans le temps*, avec pour apport fondamental un couplage entre les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ lorsque ceux-ci varient dans le temps.
!!
!! L'ensemble de *l'électromagnétisme est contenu dans quatre équations* appelées équations *de Maxwell*. Ces quatre équations fondamentales exprimées sous forme locale, ont aussi une expression intégrale. Le théorème de Gauss, dans sa forme locale comme dans sa forme intégrale, dans sa démonstration comme dans ses applications, restera totalement inchangé en électromagnétisme.
!!
!! *Le théorème de Gauss*  est votre *première équation de Maxwell*, dans sa forme locale comme dans sa forme intégrale. Dans le cadre de l'électromagnétisme, il pourra être simplement renommer théorème de Maxwell-Gauss.

La **première étape**, commune à l'application du théorème de **Gauss de forme intégrale comme de forme locale**, est donc l'*étude des symétries et invariances* de la distribution de charge considérée.

#### 1° étape : étude des invariances et symétries

Au cours de cette étude, nous sommes amenés à :
* **choisir le repère de l'espace** le mieux adapté à la distribution de charge, sinon le nombre de composantes non nulles du champ  $`\overrightarrow{E}`$ seront toujours au nombre de trois.
* **déterminer les invariances** de la distribution de charge, afin d'identifier les composantes nulles de $`\overrightarrow{E}`$. Si une composante de champ est nulle, alors le champ de dépend pas de cette composante.
* **identifier les plans de symétries et/ou d'antisymétries** suffisants pour déterminer la direction de $`\overrightarrow{E}`$.

Reprenons ces 3 points.

##### Choix du repère de l'espace

Ce choix du repère de l'espace **résulte de l'observation** *des invariances et des symétries* de la distribution de charge. 

Mais celles-ci ne peuvent s'exprimer en terme de coordonnées et de vecteurs de base associés avant que ne soit explicitement précisé le repère.

!!!! *Attention* :   
!!!! Vous avez identifié un repère $`(O, \overrightarrow{e_{\alpha}},\overrightarrow{e_{\beta}},\overrightarrow{e_{\gamma}})`$ comme étant bien adapté à la distribution de charge observée.   
!!!!
!!!! Si vous communiquez votre étude à d'autres (publication, travail en équipe, copie d'examen) il ne suffit pas de nommer le repère choisi. 
!!!!
!!!! *Il faut préciser la position de l'origine $`O`$ du repère et l'orientation des axes* permettant de définir les coordonnées $`(\alpha, \beta, \gamma)`$ et les vecteurs de base associés *en fonction des éléments descriptifs de la distribution*.
!!!
!!!! Sinon vous ne faites aucun couplage entre la distribution de charge observée et le repère de l'espace choisi, et votre étude est alors vide de sens.

!!! *Exemple* : un cylindre infini uniformément chargé
!!! 
!!! Le cylindre possède une symétrie de révolution autour d'un axe $`\Delta`$. Si vous choisissez le repère cylindrique $`(O, \overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$, précisez que l'axe $`Oz`$ est l'axe de révolution $`\Delta`$ du cylindre, l'origine $`O`$ pouvant être situé n'importe-où sur $`\Delta`$.
!!!
!!! Il est souvent plus simple et explicite de se référer à un schéma faisant apparaître la distribution des charges et le repère choisi.


##### Etude des invariances

L'étude des invariances :
   * **identifie les composantes non nulles** (en nombre minimum) dont dépend $`\overrightarrow{E}`$.
   * ne donne *aucune information sur la direction de $`\overrightarrow{E}`$*.
<br>

Soit un *système de coordonnées $`(\alpha, \beta, \gamma)`$*.   
**De façon générale** *et en tout point de l'espace*, l'écriture la plus développée du vecteur champ électrique s'écrit :

*$`\mathbf{\overrightarrow{E}=E_{\alpha}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\alpha}}
+E_{\beta}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\beta}}}`$*
*$`\mathbf{+E_{\gamma}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\gamma}}}`$*

L'étude des invariances ne s'intéressant pas à la direction de $`\overrightarrow{E}`$, le champ peut s'écrire ici plus simplement :

**$`\mathbf{\overrightarrow{E}=\overrightarrow{E}(\alpha, \beta, \gamma)}`$**


!!!! *Attention* :    
!!!! Une *erreur* souvent observées et *ici barrée*, est d'écrire *pour cette écriture générale* :
!!!!
!!!! *$`\require{cancel}\mathbf{\overrightarrow{E}=\xcancel{E_{\alpha}(\alpha)}\overrightarrow{e_{\alpha}} + \xcancel{E_{\beta}(\beta)}\overrightarrow{e_{\beta}}+\xcancel{E_{\gamma(\gamma)}\overrightarrow{e_{\gamma}}}}`$*
!!!!
!!!! C'est bien sûr faux et la suite de l'étude le sera également.    
!!!! Une composante vectorielle $`E_{\alpha}\;\overrightarrow{e_{\alpha}}`$ peut varier en amplitude $`E_{\alpha}`$ en se déplaçant dans les 3 directions de l'espace. $`E_{\alpha}`$ doit dépendre de façon générale des trois coordonnées $`(\alpha, \beta, \gamma)`$ :
!!!!
!!!! $`\mathbf{E_{\alpha}=E_{\alpha}(\alpha, \beta, \gamma)}`$ est correct.

Une distribution de charge invariante $`\dens`$ par toute variation d'une coordonnée, par exemple la coordonnée $`\alpha`$, créé un champ électrique $`\overrightarrow{E}`$ qui ne dépend pas de cette coordonnée $`\alpha`$.

**$`\mathbf{\dens\,(\xcancel{\alpha},\beta, \gamma) =\dens\,(\beta,\gamma)}`$**
**$`\mathbf{\quad\Longrightarrow\quad\overrightarrow{E}\,(\xcancel{\alpha},\beta, \gamma)=\overrightarrow{E}\,(\beta, \gamma)}`$**

Si de plus la distribution de charge $`\dens`$ est invariante par toute variation d'une autre coordonnée, par exemple la coordonnée $`\gamma`$, alors $`\overrightarrow{E}`$ ne dépend pas non plus  de $`\gamma`$.

**$`\mathbf{\left.\begin{array}{c}
\dens\,(\xcancel{\alpha},\beta, \gamma) =\dens\,(\beta,\gamma) \\
\dens\,(\alpha),\beta, \xcancel{\gamma}) =\dens\,(\alpha,\beta)
\end{array}
\right\}}`$$`\mathbf{\Longrightarrow \dens = \dens (\beta)\Longrightarrow \overrightarrow{E}=\overrightarrow{E}\,(\beta)}`$**




##### Etude des symétries

L'étude des symétries :
   * **identifie la direction de $`\overrightarrow{E}`$**.
   * ne donne *aucune information sur les composantes dont dépend $`\overrightarrow{E}`$*.

<br>

Le champ électrique **$`\overrightarrow{E}`$** est un **vecteur polaire**. Causé par une distribution de charge $`\dens`$, il est donc :
* *contenu dans tout plan de symétrie* de $`\dens`$.
* *perpendiculaire à tout plan d'antisymétrie* de  $`\dens`$.

<br>

La **direction de $`\overrightarrow{E}`$** en un point $`M`$* est donc *déterminée dès* la connaissance
* d'un *plan unique d'antisymétrie* contenant le point $`M`$.
* de *deux plans de symétrie* qui s'interceptent au point $`M`$.

<br>

La méthode pour **déterminer la direction de $`\overrightarrow{E}`$ en tout point de l'espace** consiste donc à *considérer un point $`M`$ quelconque* de l'espace, et *rechercher les plans de symétrie ou d'antisymétrie qui passe par $`M`$* . 

Soit un *système de coordonnées $`(\alpha, \beta, \gamma)`$*.   
**De façon générale** *et en tout point de l'espace*, l'écriture la plus développée du vecteur champ électrique s'écrit :

*$`\mathbf{\overrightarrow{E}=E_{\alpha}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\alpha}}
+E_{\beta}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\beta}}}`$*
*$`\mathbf{+E_{\gamma}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\gamma}}}`$*

L'étude des symétries ne s'intéressant pas aux composantes de $`\overrightarrow{E}`$ mais seulement à sa direction, le champ peut s'écrire ici plus simplement :

**$`\mathbf{\overrightarrow{E}=E_{\alpha}\;\overrightarrow{e_{\alpha}}
+E_{\beta}\;\overrightarrow{e_{\beta}} +E_{\gamma}\;\overrightarrow{e_{\gamma}}}`$**

Soit un **point $`M`$ quelconque** *de coordonnées $`(\alpha, \beta, \gamma)`$*.

Si une distribution de charge $`\dens`$ comprend des charges négative et positives, le regard cherchera d'abord la présence d'un plan d'antisymétrie pour $`\dens`$ qui contient $`M`$ . Si un tel plan existe, par exemple le plan $`\mathcal{P}_A`$ qui contient le point $`M`$ et défini par les vecteurs $`\overrightarrow{e_{\alpha}}`$ et $`\overrightarrow{e_{\gamma}}`$, alors $`\overrightarrow{E}`$ est perpendiculaire à ce plan et s'écrit $`\overrightarrow{E}=E_{\beta}\;\overrightarrow{e_{\beta}}`$.

**$`\mathbf{\left.\begin{array}{c}
\overrightarrow{E} \text{ est un vecteur polaire } \\
\mathcal{P}_A\,(M, \overrightarrow{e_{\alpha}}, \overrightarrow{e_{\gamma}}) \text{ est plan d'antisymétrie }
\end{array}
\right\}}`$$`\mathbf{\Longrightarrow \overrightarrow{E}=E_{\beta}\overrightarrow{e_{\beta}}}`$**

Si n'existe pas de plan d'antisymétrie passant par $`M`$, mais que tout point $`M`$ appartient à deux plans de symétries, par exemples les plans $`\mathcal{P}_{S1}\,(M, \overrightarrow{e_{\alpha}}, \overrightarrow{e_{\beta}})`$ et  $`\mathcal{P}_{S2}\,(M, \overrightarrow{e_{\beta}}, \overrightarrow{e_{\gamma}})`$, alors la direction de $`\overrightarrow{E}`$ au point $`M`$ est celle de la droite $`\Delta=(M,\overrightarrow{e_{\beta}})`$ intersection entre ces deux plans. $`\overrightarrow{E}`$ s'écrit alors $`\overrightarrow{E}=E_{\beta}\;\overrightarrow{e_{\beta}}`$.

**$`\mathbf{\left.\begin{array}{c}
\overrightarrow{E} \text{ est un vecteur polaire } \\
\mathcal{P}_{S1}\,(M, \overrightarrow{e_{\alpha}}, \overrightarrow{e_{\beta}}) \text{ est plan de symétrie} \\
\mathcal{P}_{S2}\,(M, \overrightarrow{e_{\beta}}, \overrightarrow{e_{\gamma}}) \text{ est plan de symétrie} \\
\end{array}
\quad\right\}}`$$`\mathbf{\Longrightarrow \overrightarrow{E}=E_{\beta}\,\overrightarrow{e_{\beta}}}`$**



##### Synthèse de l'étude des invariances et symétries.

Il s'agit de rassembler au sein d'une même écriture les informations obtenues sur l'expression du champ électrique $`\overrightarrow{E}`$ en tout point de l'espace.

Soit un *système de coordonnées $`(\alpha, \beta, \gamma)`$*.   
Si l'étude des invariances de la distribution de charge conduit à $`\overrightarrow{E}=\overrightarrow{E}\,(\beta)`$ et si l'étude des symétrie de la distribution de charge conduit à $`\overrightarrow{E}=E_{\beta}\,\overrightarrow{e_{\beta}}`$
alors en tout point de l'espace l'expression du champ électrique se limite à 
$` \overrightarrow{E}=E_{\beta}\,(\beta)\,\overrightarrow{e_{\beta}}`$.

**$`\mathbf{\left.\begin{array}{l}
\text{Invariances}\Longrightarrow \overrightarrow{E}=\overrightarrow{E}\,(\beta) \\
\text{Symétries}\;\;\Longrightarrow \overrightarrow{E}=E_{\beta}\,\overrightarrow{e_{\beta}}
\end{array}\quad\right\}
\,\Longrightarrow}`$
$`\mathbf{\overrightarrow{E}=E_{\beta}\,(\beta)\,\overrightarrow{e_{\beta}}}`$**

!!!! *Attention* :   
!!!! Si en électrostatique l'étude de trois distributions de charge d'école conduit à :
!!!! * $`\overrightarrow{E}=\overrightarrow{E}_r\,(r)\;\overrightarrow{e_r}`$ en coordonnées sphériques $`(r, \varphi, \theta)`$ pour une sphère uniformément chargée.
!!!! * $`\overrightarrow{E}=\overrightarrow{E}_{\rho}\,(\rho)\;\overrightarrow{e_{\rho}}`$ en coordonnées cylindriques $`(r, \varphi, \theta)`$ pour un cylindre infini uniformément chargé.
!!!! * $`\overrightarrow{E}=\overrightarrow{E}_z\,(z)\;\overrightarrow{e_z}`$ en coordonnées cartésiennes 
!!! $`(x, y, z)`$ pour un plan $`xOy`$ uniformément chargé.
!!!
!!!! Il ne faut pas croire que toute composante de champ $`\overrightarrow{E}_{\alpha}`$ ne peut varier qu'en fonction de la coordonnée $`\alpha`$.   
!!!! Cela est vrai en magnétostatique dès cet étape contreforts. L'étude du champ magnétique créé par des distributions de courants permanents donne :
!!!! * $`\overrightarrow{B}=\overrightarrow{B}_{\theta}\,(\rho)\;\overrightarrow{e_{\theta}}`$ en coordonnées cylindriques pour un fi infini.
!!!! * $`\overrightarrow{B}=\overrightarrow{B}_{z}\,(\rho)\;\overrightarrow{e_z}`$ en coordonnées cylindriques pour une bobine infinie.
!!!!
!!!! Cela sera d'autant plus vrai vrai en électromagnétisme à l'étape montagne. Par exemple l'étude du champ électromagnétique $`(\overrightarrow{E}, \overrightarrow{B})`$ créé par un fil conducteur parcouru par un courant variable donnera :    
!!!! $`\left |\begin{array}{l} \quad\overrightarrow{E}=\overrightarrow{E}_{\rho}\,(\rho,z)\;\overrightarrow{e_{\rho}}+\overrightarrow{E}_z\,(\rho,z)\;\overrightarrow{e_z} \\ \quad\overrightarrow{B}=\overrightarrow{B}_{\theta}\,(\rho,z)\;\overrightarrow{e_{\theta}} \end{array}\right.`$
!!!! 
!!!! S'il est bon de se souvenir du résultat d'exemples, il est important de garder un esprit ouvert, et de redémontrer à chaque cas, par l'étude des symétries et invariances, l'expression générale du champ électrostatique $`\overrightarrow{E}`$ en tout point de l'espace. Cet entraînement indispensable pour la suite doit commencer dès cette étape électrostatique.










