---
title: "Boundary conditions, reflection and transmission"
published: true
routable: true
visible: false
---

<!------
## Reflected and transmitted electromagnetic waves at interfaces
-------->

#### Chapter 3

### Boundary conditions,<br>reflexion and transmission

<br>

---------------

#### 3.1 - Boundary conditions

Before considering the reflection and transmission of electromagnetic
waves between two media, we have to determine the relations governing
the be- haviour of the fields $`\overrightarrow{D}`$, $`\overrightarrow{B}`$, $`\overrightarrow{E}`$ and $`\overrightarrow{H}`$ at the
interface between two materials. Simply stated, these relations,
called the "__boundary conditions__" tell us that if we know the fields
in one material close to the separation surface then we can calculate
some components of these same fields in the other material (again,
close to the separation surface). We will consider an LHI material and
the relations we will find are valid __for any point__ close to the
separation surface and __for any time__. These two conditions are
important to find some of the results later in this chapter. The
boundary conditions can be obtained from the Maxwell equations. The
first two equations

équation 3.4

will give information on the normal components of $`\overrightarrow{D}`$ and $`\overrightarrow{B}`$,
while the third and fourth

équation 3.5

will give information on the tangential components of $`\overrightarrow{E}`$ and $`\overrightarrow{H}`$.

To obtain the boundary conditions we consider a surface separating two
Linear Homogeneous and Isotropic (LHI) media whose properties such as that
the permittivity and permeability are different. We denote as
$`\overrightarrow{E}_1\,,\overrightarrow{B}_1\,,\overrightarrow{D}_1`$ and $`\overrightarrow{H}_1`$ the fields present in
material 1 close to its surface. Likewise an index 2 will be used for
the fields in the second material.

<br>
![](electromag-in-media-reflexion-transmission-fig-31.jpg)   
_Figure 3.1 : Scheme for deriving boundary conditions for perpendicular field components._
_$`S_1\,, S_2`$ and $`S'`$ represent respectively the surface at the top, bot- tom and interface._
>

##### Normal components

__$`\overrightarrow{D}`$ vector__

Let's apply Maxwell equation (i) to the small cylinder showed in
figure [3.1] which extends from one side to the other on
the separation surface. This box has a base surface A and an
infinitesimally small thickness $`\delta`$. We get:

équation 3.6

If we now let $`\delta\longrightarrow 0`$ symmetrically with respect to the separation
surface such that the cylinder gets "pressed" onto the surface:

* The third term on the left hand side of the previous equation will
  be negligible as the flux of the vector $`\overrightarrow{D}`$, which is a finite
    quantity, through an infinitesimally small surface will approach
    0.

* The volume charge will be reduced to a surface charge at the
    interface only as the volume will approach 0. The volume charge
    density is replaced by a surface charge density $`\sigma`$ and the
    volume integral is replaced by surface integral over the middle
    surface $`S'`$.

We obtain:

équation 3.7

Now, considering that $`d\overrightarrow{a_2}=-d\overrightarrow{a_1}`$ we can write:

équation 3.8

Finally, as $`S_1=S'`$ and $`d\overrightarrow{a_2}=\overrightarrow{n}_{2\rightarrow 1}\,da_1`$ we can
write:

équation 3.9

or

équation 3.10

The normal component of the vector $`\overrightarrow{D}`$ is in general discontinuous.
It is continuos only if there are no conduction charges at the
separation surface.

__$`\overrightarrow{B}`$ vector__

The situation is identical for the vector $`\overrightarrow{B}`$, the only difference
being that the right hand side of the equation is always 0. We
conclude that:

équation 3.11

or

équation 3.12

The normal component of $`\overrightarrow{B}`$ is always conserved.


##### Tangential components

<br><br>
![](electromag-in-media-reflexion-transmission-fig-32.jpg)   
_Figure 3.2 : Contour for deriving boundary conditions for parallel field components._

__$`\overrightarrow{E}`$ vector__

We integrate the third Maxwell equation around the rectangular contour
C that straddles the boundary of width W and thickness $`\delta`$ as shown in
figure [3.2.]. We chose to integrate the line integral
following the right-hand sense relative to the surface normal
$`\overrightarrow{n_a}`$. By letting $`\delta\rightarrow 0`$, we get

équation 3.13

as the line integral along the sides goes to zero and the flux of the
induction field $`\overrightarrow{B}`$, which is a finite quantity, approaches 0.
Considering that $`\overrightarrow{CD}-\overrightarrow{AB}=d\vec{l}`$, we get:

équation 3.14

or again

équation 3.15

i.e. the tangential components of the electric field are always
conserved at the interface. This condition can also be written:

équation 3.16

__$`\overrightarrow{H}`$ vector__

Following the same reasoning as for the $`\overrightarrow{E}`$ vector we write for the
left hand side when $`\delta\rightarrow 0`$ :


équation 3.17

The right hand side needs more attention. The flux of the vector $`\overrightarrow{D}`$
approaches 0. However the flux of the vector $`\overrightarrow{J}`$ over an infinitesimal surface
can give a finite value: the surface integral reduces to an integral
over the line of width W equal to the side of the rectangle. No volume
current can contribute, however a surface current $`\overrightarrow{J}_S`$ (i.e. a
current flowing on the separation surface with dimensions $`[A/m]`$
not $`[A/m*^2]`$ as $`\overrightarrow{J}`$) can. This is typically the case of a
perfect conductor where a finite current can flow through a
infinitesimally small area. We get:

équation 3.18

or again

équation 3.19

i.e. the tangential components of the magnetic field $`\overrightarrow{H}`$ is
discontinuous unless no surface currents exist. As for the electric
field, this condition can also be written:

équation 3.20

!! *Summary*   
!! 
!! *vector form*   
!! * x
!! * x
!! * x
!! * x
!!
!! *component form*
!! * x
!! * x
!! * x
!! * x


! *Remarks*   
!
! * If medium 1 & 2 are perfect dielectrics then there are no charges
! nor surface currents at the interface, and so the tangential component
! of $`\overrightarrow{H}`$ and the normal component of $`\overrightarrow{D}`$ are both continuous.   
!
! * If medium 1 is a perfect dielectric and medium 2 is a perfect metal,
! there are charges and surface currents at the interface, and so the
! tangential component of $`\overrightarrow{H}`$ and the normal component of $`\overrightarrow{D}`$ are
! not continuous.   
!
! * In case of linear media, the 4 relations can be expressed in terms
! of $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ alone using the constitutive relations
! $`\overrightarrow{D}=\epsilon\,\overrightarrow{E}`$ and $`\overrightarrow{B}=\mu\,\overrightarrow{H}`$.

équation 

<br>

---------------

#### 3.2 - Reflection and transmission at normal incidence

<br>

We suppose that the *xy* plane at *z* = 0 is the boundary between
medium 1 and medium 2. A plane wave of angular frequency *ω*
travelling in medium 1 in the positive *z* direction and polarised
along the *x* axis makes a normal incidence at the interface with
medium 2.

##### Case 1: perfect dielectric/perfect conductor

We will first consider the case of a normal incidence for a wave
travelling in vacuum (a particular case of a perfect dielectric with
*ε* = *ε*~0~, *n* = 1, *µ* = *µ*~0~) at the interface with a perfect
conductor. For the perfect conductor, as *σ* , its penetration depth
*δ* 0, i.e. no electromagnetic field can exist inside it. No
transmission can occur, the wave is totally reflected. The incident
and reflected waves are:

équation 3.21

![](electromag-in-media-reflexion-transmission-fig-33a.jpg)   
![](electromag-in-media-reflexion-transmission-fig-33b.jpg)     
_Figure 3.3: Left: Normal incidence at the boundary between a perfect_
_dielectric and a perfect conductor. Right the total fields at a few_
_different times._

and

équation 3.22

Using the boundary conditions at the interface (*z* = 0) we have:

équation 3.23

as the boundary conditions are valid in any point of the surface and
at any time. We cab therefore write the reflected wave as:

équation 3.24

In medium 1 we have a superposition of the incident and reflected
waves. The total wave is given by:

équation 3.26

or in real notation

équation 

This wave represents a **stationary wave**1: a wave the oscillates in
place. The nodes and antinodes of the electric field and magnetic
field are out of phase

Be careful not to confuse a stationary wave with an evanescent wave.

by *π/*2. In particular the electric field has a node at the interface
(imposed by the boundary conditions) and the magnetic field as instead
an antinode at the interface. A stationary wave does not transport any
net energy. This can be readily understood as as much energy is
carried by the incident wave from right to left as the reflected one
in the opposite direction. Calculating the Poynting vector we have:

équation 3.27

which at any point *z* changes direction periodically. Its
time-averaged values is indeed *\<* $`\overrightarrow{S}`$*~tot~ \>~t~*= 0.

Due to the discontinuity of the magnetic field, a surface current
density must be present at the interface. Using the fourth boundary condition we get:

![](electromag-in-media-reflexion-transmission-fig-34a.jpg)   
![](electromag-in-media-reflexion-transmission-fig-34b.jpg)     
_Figure 3.4: Left: The incident, reflected and resulting wave at a_
_particular time. Right: The superposition of several resulting waves_
_at different times._

![](standing_wave_partial_reflection_SWR_2_v2.gif)

équation 

##### Case 2: 2 perfect dielectrics

We are dealing now with two perfect dielectrics. For the discussion we
will consider that the materials are non-magnetic (*µ* = *µ*~0~) and
that no charges nor currents exist at the interface (*σ~s~* = 0*,*
$`\overrightarrow{j}`$*~s~* = 0). The incident ware is given by

équation 3.28

![](electromag-in-media-reflexion-transmission-fig-35a.jpg)   
![](electromag-in-media-reflexion-transmission-fig-35b.jpg)     
_Figure 3.5: Left: Normal incidence at the boundary between twp perfect_
_dielectrics. Right the total fields in medium 1 at a few different_
_times showing a partial standing wave. The minimum amplitude of_
_$`\overrightarrow{E}`$*~tot~* is no more 0._

where **k**~1~ and *n*~1~ are the wavevecvtor and refractive index of
medium 1. The reflected and transmitted waves are:

équation 3.29

and

équation 3.30

We need now two boundary conditions to determine the reflected and
trans- mitted waves. Using the tangential boundary conditions for
$`\overrightarrow{E}`$ and $`\overrightarrow{H}`$ we have:

équation 3.31

Solving for *E*^0^ and *E*^0^ we obtain:

équation 

We can now define the

équation 

*   Reflection coefficient *r* = *^E^*0 = [*n* −*n*]{.underline}

and

équation 

*   the Transmission coefficient *t* = *^E^*0 = [2*n *]{.underline} .

équation 

<br>

------------------

#### 3.3 - Reflection and transmission at oblique incidence

<br>

We now turn to the more general case of an oblique incidence at an
arbitrary angle *θ~i~*. Before that we will need a few definitions and
considerations.

![](electromag-in-media-reflexion-transmission-fig-36.jpg)   
_Figure 3.6: Plane of incidence, *s* and *p* polarisations._

##### Plane of incidence

We first define the **plane of incidence** as the plane the contains
the incidence wavevector and the normal to the interface separating
the two materials. Let's consider a linearly polarised plane wave
making an oblique incidence at the interface between medium 1 and 2.
Two special cases arise:

*  if $`\overrightarrow{E}`$*~i~* is contained in the plane of incidence, the wave is
    said to be *p* (for parallel to the plane of incidence) or again
    Transverse Magnetic (TM) as the magnetic field will be
    perpendicular to the plane of incidence. The symbol "/I" is also
    often used.

*  if $`\overrightarrow{E}`$*~i~* is perpendicular to the plane of incidence, the wave
    is said to be *s* (for the german word for perpendicular - to the
    plane of incidence) or Transverse Electric (TE). The symbol "⊥" is
    used in this case.

Any other polarisation state can be decomposed into the sum of a TM
and TE wave.

##### Laws of reflection and refraction

We will derive here the laws of reflection and refraction by making
use of the boundary conditions which are independent on the
polarisation of the incident wave. W will not make any assumption on
the wavevector and frequencies of the wave. We implicitly assumed in
the previous section that the frequen- cies are the same as the
wavevectors's moduli in the same medium. We will
>
demonstrate it here. Let's consider the the general situation as of an
inci- dent, reflected and refracted wave as depicted in figure
[3.7.]. The three plane

![](electromag-in-media-reflexion-transmission-fig-37.jpg)   
_Figure 3.7: General case of reflection and refraction_

monochromatic wave are:

équation 

The boundary conditions are applied to the interface (*z* = 0) and
must be valid for **all points on the interface** and **for all
times**.

In *z* = 0, for the tangential component of the electric field we
have:

équation 

équation 3.35

where **r***~s~* is a vector on the interface.

i.  For this condition to be valid *t* we must have *ω* = *ω*^t^ =
    *ω*^tt^. As a consequence we have

équation 3.36

équation 3.37

ii. For this condition to be valid []{#_bookmark65 .anchor}∀**r***~s~*
    we must have:

équation 3.38

Taking the first two terms we can write

équation 3.39

As **r***~s~* belongs to the interface, (**k***~i~* **k***~r~*) is
normal to it. This means that the vectors **k***~i~*, **k***~r~* and
the normal belong to the same plane, i.e. the plane of incidence.

!! *First law of reflexion*   
!! ....

iii. Equation [3.38] can be recast as

équation 3.40

These relations can be satisfied only if all the *x* and *y*
components are the same. Taking the *x* components we can write

a. équation 

b. équation

c. equation

From the first two relations we get *θ~i~* = *θ~r~* as \|*k~i~*\| =
\|*k~r~*\|.

!! *Second law of reflexion*   
!! ....

From the first and the third we get \|*k~i~*\| sin *θ~i~* = \|*k~t~*\|
sin *θ~t~* or

!! *Snell law* 
!! ....

<br>

--------------

#### 3.4 - Fresnel's laws & Brewster's angle

<br>

From the previous section we can write the incident, reflected and
transmitted waves as:

equation

where the indices "1" and "2" indicate the first and second medium
physical quantities. We will now separate the discussion for a TE and
a TM wave. Due to the isotropic nature of the media considered here, a
TE incident wave will give rise to TE reflected and transmitted waves.
Likewise for a TM incident wave.

<br>

![](electromag-in-media-reflexion-transmission-fig-38a.jpg)   
<br>
![](electromag-in-media-reflexion-transmission-fig-38b.jpg)   
_Figure 3.8: Configuration for a TE and TM incidence._

__TE Wave__

$`\overrightarrow{E}`$ is tangential and $`\overrightarrow{B}`$ is contained in the plane of incidence.
From figure [3.8](#_bookmark67) we can write using the two tangential
boundary conditions and the relations $`\overrightarrow{B}`$ = *µH*, \|$`\overrightarrow{B}`$\| =
^[\|$`\overrightarrow{E}`$\|]{.underline}^ *n*:

equation

As before, we define the reflection and transmission coefficient for a
TE ( or

equation 3.42

which by solving the previous equations can be evaluated to:

equation 3.43

! *Remarks*   
! ....

__TM Wave__

$`\overrightarrow{E}`$ is s contained in the plane of incidence and $`\overrightarrow{B}`$ is
transverse. From figure [3.8](#_bookmark67) we can write using the two
tangential boundary conditions and the relations $`\overrightarrow{B}`$ = *µH*,
\|$`\overrightarrow{B}`$\| = ^[\|$`\overrightarrow{E}`$\|]{.underline}^ *n*:

equation 

Solving the system we obtain the reflection and transmission
coefficients for a TM (/I or *p*) wave as:

equation 3.44


##### Brewster's angle

Let's make a few considerations on the consequences of the Fresnel
relations by plotting the reflection coefficients for *s* and *p*
polarisations. We, first of all, separate the two cases according to
the relative value of the two media refrac- tive indices *n*~1~ and
*n*~2~. By using Snell-Descartes law *n*~1~ sin(*θ*~1~) = *n*~2~
sin(*θ*~2~) we have that

a.  If equation 

b.  If equation


##### Case a)

In this case, we consider the range 0 *θ*~1~ *π/*2 for the incident
angle *θ*~1~. Correspondingly, the refraction angle *θ*~2~ will vary
in the range 0 *θ*~2~ *θ*2*max*. Using Snell we have:

equation

![](electromag-in-media-reflexion-transmission-fig-39a.jpg)    
![](electromag-in-media-reflexion-transmission-fig-39b.jpg)    
_Figure 3.9: The snell law for *n*~1~ *\< n*~2~ and *n*~1~ *\n*~2~._



![](electromag-in-media-reflexion-transmission-fig-310a.jpg)    
![](electromag-in-media-reflexion-transmission-fig-310b.jpg)    
![](electromag-in-media-reflexion-transmission-fig-310a.jpg)    
![](electromag-in-media-reflexion-transmission-fig-310b.jpg)    
_Figure 3.10: Plot of the reflection_
_coefficients (*r*~⊥~ and *r*I/) and the correspond- ing reflectivities_
_(*R*~⊥~ and *R*I/) for case a (top) and case b (bottom)._

equation

This signifies that for the particular angle *θ~B~* (the Brewster's
angle) *r*I/(*θ~B~*) = 0, as shown in figure [3.10.](#_bookmark68) By
plotting the reflectance (*R* = \|*r*\|2), we see that no reflection 
occurs for *p*-polarised wave for *θ*~1~ = *θ~B~* and
the reflection for *p* waves is, in any case, much smaller than the
reflections for *s* waves for angles close to *θ~B~*. This phenomenon
suggests different applications:

*  The possibility of polarising unpolarised waves by reflection for an
    inci- dence angle *θ* = *θ~B~*: the reflected wave will be 100%
    linearly polarised while the transmitted one only partially
    polarised (see figure [3.11).](#_bookmark69)

*  The possibility of removing unwanted reflections by using polarisers
    (Po- laroid sun-glasses for instance, figure
    [3.12);](#_bookmark70)

*  The possibility of transmitting 100% of the intensity of an incident
    wave thought an interface using a proper polarisation and
    incidence angle.

![]()    
_Figure 3.11: An illustration of the_
_polarisation of light that is incident on an interface at Brewster's_
_angle._
_[https://en.wikipedia.org/wiki/Brewster'](https://en.wikipedia.org/wiki/Brewster%27s_angle)_
_[s_angle](https://en.wikipedia.org/wiki/Brewster%27s_angle)_


##### Case b)

In this case, total reflections will occur for angles *θ*~1~
*θ*1*lim*. The considera- tions on the Brewster's angle stated above
will still hold.

The condition *r~p~* = 0 inserted in the Fresnel equation gives

equation 3.45

while from Snell's law we have
 
equation 3.46

![]()    
_Figure 3.12: Photographs of a window taken_
_with a camera polariser filter rotated to two different angles. In the_
_picture at left, the polariser is aligned with the polarisation angle_
_of the window reflection. In the picture at right, the polariser has_
_been rotated 90° eliminating the heavily polarised reflected sunlight._
_[https://en.wikipedia.org/wiki/Brewster's_angle](https://en.wikipedia.org/wiki/Brewster%27s_angle)_

By multiplying the left and the right terms of the previous equations
together we get

equation 3.47

which gives as only possible solution *θ~B~* + *θ*~2~ = *π/*2 ( i.e.
the transmitted and reflected beams are perpendicular, see figure
[3.11)](#_bookmark69) and *θ~B~* = arctan [*n*2]{.underline} . It is easy 
to show that *θ~B~ \< θ*1*lim*, i.e. the Brewster's angle is
always smaller than the limit angle for total reflection.

##### Total internal reflection

Let's consider the oblique incidence shown in figure
[3.8.](#_bookmark67) The transmitted field is given by

equation 3.48

Using the boundary conditions we have previously found that

equation 3.49

Using this relation we can write

equation 3.50

When the incidence occurs at the limit angle *θ*~1~ = *θ*1*lim*, Snell
law gives *n*~2~ = *n*~1~ sin *θ*1*lim*. If now we increase the
incidence angle, we have *θ*~1~ *\θ*1*lim* and thus *n*~2~ *\< n*~1~
sin *θ*~1~ or *n*^2^ − *n*^2^ sin2 *θ*~1~ *\<* 0. Plugging this into
equation [3.49,] we

obtain:

equation 3.51

i.e. (*k*~2~)*~z~* is purely imaginary and the transmitted wave
becomes:

equation 3.52

The wave has a propagating character in the *x* direction and an
evanescent character in the *z* direction. Let's consider the case of
a TE wave. The Fresnel relation gives
 
equation 3.53

As (*k*~2~)*~z~* is purely imaginary we have, as expected,

equation

but also

equation 3.55

i.e. the reflected wave is totally reflected with a phase shift.

<br>

----------------

#### 3.5 - Oblique incidence onto a perfect conductor

<br>

We consider now a linearly polarised plane wave travelling in a
perfect dielec- tric making an oblique incidence onto a perfect
conductor. The case of vacuum is trivially obtained by setting the
refractive index *n* = 1. These calculations will serve as a basis for
the next chapter, which deals with rectangular metal- lic waveguides.
This is the reason why we adopt here a different frame with respect to
the previous sections. Once again we will deal with TE and TM waves
separately. As before, being the second medium a perfect conductor, no
electromagnetic fields can exists in it. We will deal only with the
incident and reflected fields.

##### TE Wave 

##### Incident fields

Considering the situation depicted in figure [3.13,] the
incident wavevector is given by:

equation 3.56

Inserting this into the incident fields, and calculating the components of the
$`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ fields form the picture (or using 
the plane wave rule $`\overrightarrow{B}_i=\dfrac{\overrightarrow{k}_i\times \overrightarrow{E}_i}{\omega}`$)
, we obtain :

equation
 
2there is "-" sign in front of the fields as the chosen electric field
drawn in figure [3.13](#_bookmark74) is antiparallel to the *x* axis.


![](electromag-in-media-reflexion-transmission-fig-313a.jpg)
![](electromag-in-media-reflexion-transmission-fig-313b.jpg)
_Figure 3.13 : Configuration des champs e.m pour le mode TE._

and

equation 3.58

##### Reflected fields

equation

The reflected electric field **[E]{.underline}***~r~* = *E*~0~ e*i*
(*ky* cos *θ* + *kz* sin *θ* − *ωt*)**ˆe***~x~* is obtained by
repeating the same procedure. Considering that the incident and
reflected angles are the same, we have:

equation

In addition, applying the boundary condition to the tangential
component of the electric field (which is here the total electric
field) we have *E~r~x* + *E~i~x* = 0. We finally obtain:

equation 3.59

and

equation 3.60

##### Total fields

equation 3.61

We calculate now the total fields **[E]{.underline}**

equation 3.62

existing in medium 1 for a TE wave:

equation 3.61

equation 3.62

field is parallel to the interface.

-   The fields have a standing wave character along the *y* axis (see
    figure [3.14] The positions of the nodes and
    antinodes plane for the electric field are given by:

@@@@@@@@@@@@@

! *Important remarks*   
! ...

![](electromag-in-media-reflexion-transmission-fig-314a.jpg)
![](electromag-in-media-reflexion-transmission-fig-314b.jpg)
_Figure 3.14: The total electric field_
_amplitude of a TE wave upon oblique incident onto a perfect conductor._
_The field has a propagation character along the *z* axis and a_
_standing wave character along the *y* axis. A node and an antinode_
_plane are displayed. The blue and red colours represent the minimum_
_and maximum of the field amplitude. You can easily reproduce this_
_pattern with water waves._


##### Poynting vector

To this aim it is convenient to revert to the real notation for the
fields:

equation 3.63

and

equation 3.64

we obtain:

equation 3.65

while its time average is:

equation 3.66

Power is therfore carried along the positive *z* direction and is null
on the nodal planes.

chap5 TM wave

The discussion is similar to the TE case with the role of $`\overrightarrow{E}`$ and
$`\overrightarrow{B}`$ exchanged. Referring to figure [3.13](#_bookmark74) we have
again for the wavevectors:

equation 3.67

and

equation 3.68

Using the boundary condition for the tangential component of the
electric field *E~r~z* + *E~i~z* = 0 and the fact the field experience
total reflection, $`\overrightarrow{E}`$*~i~* = $`\overrightarrow{E}`$*~r~* we obtain:

equation 3.69

and

equation 3.70

Finally, the total fields existing in medium 1 for a TM ( or *p*) wave
are given by:

equation

and

equation

The same remarks made for the total TE wave can repeated here for the
total TM wave we the appropriate changes for the role of the $`\overrightarrow{E}`$ and
$`\overrightarrow{B}`$ fields.

equation

, i.e. the magnetic field is

parallel to the interface.

-   The electric fields have a standing wave character along the *y*
    axis (see figure [3.14).](#_bookmark75) The positions of the nodes
    and antinodes planes for the magentic fields are given by:

equation

Finally, the time-averaged Poytining vector is given by:

equation

