---
title: Introduction à l'étude de l'instrumentation pour l'astronomie
published: false
routable: false
visible: false
lessons:
    - slug: introduction-instrumentation-for-astronomy-4
      name: LINÈAIRE : Introduction à l'instrumentation pour l'astronomie
      order: 1
---


### Étude de l'instrumentation pour l'astronomie

#### Introduction

<br>
Comment aborder un cours sur "l' instrumentation pour l'astronomie"? La plupart des 
enseignements ou des ouvrages publiés sur cette question, limitent leur champ au 
traitement d'un nombre plus ou moins grand de problèmes que la _physique_ permet 
de résoudre et qui ont un rapport plus ou moins direct avec les instruments (ou le
plus souvent avec des méthodes de mesure).

Pourtant, pour l'étudiant de _physique_ qui aborde une formation destinée à le préparer
à la recherche en _astronomie_, la difficulté est grande de replacer chacun des problèmes
de physique dans le très vaste champ de l'instrumentation astronomique. Les problèmes 
rencontrés dans la pratique de l'astronomie, notamment pour sa composante instrumentale, 
ne sont pas tous solubles à l'instant où on pourrait le souhaiter et leur identification 
ne va pas toujours de soi. Enfin, l'instrumentation pour l'_astronomie_ se développe
toujours dans un champ d'activité humaine très vaste qui lui attribue un caractère 
multidimensionnelle très complexe. De ce fait, tout approche fondée exclusivement sur 
_la physique et les mathématiques_ ne pourra aborder une étude de l'instrumentation 
en astronomique qui prennent en compte toute sa complexité. En particulier dans la 
plupart des ouvrages publiés sur le sujet, la composante humaine pourtant essentielle, e
st occultée. Le but fixé dans notre approche est d'aborder de front la complexité de la question.
L'ambition est davantage d'identifier les problèmes que de les résoudre : pour beaucoup 
d'entre eux, notamment pour tous ceux qui peuvent être traités par la physique, 
des renvoies seront faits vers des ouvrages publiés. Les parties développées ou 
détaillées seront celles qui font défaut dans les publications disponibles ou 
qui sont apparues comme les plus chargés de lacunes dans les générations
d'étudiants rencontrés. 

Le parti pris est de traiter des concepts susceptibles de rendre compte de la réalité d
e l'instrumentation pour l'astronomie. Cette priorité mise, des conceptions seront des 
concessions seront faites, notamment avec la rigueur mathématique des calculs présentés. 
Ces derniers n'ont jamais un caractère bien original et le lecteur intéressé pourra 
toujours consulter les ouvrages de mathématiques adéquat. Un autre compromis a été 
recherché dans le choix des questions abordées. Ce choix résulte des lacunes constatées 
parmi les connaissances d'une douzaine de générations d'étudiants du DEA Toulouse. 
L'objectif de ce cours étant d'être utile, beaucoup de problèmes ou de domaine, 
généralement bien maîtrisés par les étudiants ont été omis ou simplement effleurés ; 
d'autres, même d'un niveau modeste et en principe déjà traités (en second cycle universitaire 
ou dans le cas d'autres cours) mais dans la maîtrise s'est avérée fragile, ont été abordés, parfois exhaustivement. Enfin, l'approche des questions n'a pas hésité à sortir des sentiers battus du standard universitaire. La raison est toujours autant pédagogique que philosophique. Pédagogique car des approches diverses sont toujours bénéfiques. Pour accéder à une meilleure compréhension. Philosophique car la volonté de se soustraire à un enseignement dogmatique doit enduire un comportement pratique ouvert et risqué. Plutôt que de vouloir transmettre un savoir constitué (c'est à dire un état des connaissances figé), ce cours à l'ambition d'aider les étudiants à se poser des questions sur la base de connaissances en évolution. Il leur appartiendra, ensuite, de les reformuler à leur convenance et de tenter d'y répondre en faisant appel aux connaissances acquises dans les autres cours, dans leurs études et leurs expériences personnelles.    
L'approche ici présentée tente d'être globalisante pour poser les problèmes ; son 
cheminement va du général au particulier, même si le général limite parfois la description 
à un niveau relativement superficiel et souvent abstrait.   
Les 5 questions fondamentales sous-jacentes, posées relativement à l'instrumentation 
à l'astronomie, sont :
* qu'est-ce que c'est ?
* de quoi c'est fait ?
* comment ça fonctionne ? 
* à quoi cela sert ? 
* Vers quoi cela évolue ? 

Il est très facile de répondre à ces quatre questions sur des exemples. Il est moins 
aisé de les aborder d'un point de vue général. Plutôt que de tenter des réponses 
séparées à chacune des questions, une démarche de mise en perspective historique 
a été préférée. Cette approche est apparue plus fructueuse, ne serait-ce que pour
appréhender les effets d'évolution indispensables pour préparer l'approche au problème
de l'avenir de l'instrumentation en astronomie. Or, c'est l'avenir qui occupe la place
centrale des préoccupations dès qu'il s'agit de formation...    
Enfin, notre approche c'est limité à l'instrumentation pour l'_astronomie_ 
du rayonnement électromagnétique.    
Elle est étroitement corrélée à l'essentiel des connaissances relatives à l'univers.
Dans le passé, l'étude des météorites et des Rayons Cosmiques (particules chargées ou
neutres, animées de vitesse dans les valeurs approchent parfois en ordre de grandeur 
celle de la lumière, $`c=299\,792\,458 \;m\,s^{-1}`$), a joué un rôle modeste,
comparativement à celui de l'astronomie électromagnétique. Au cours des dernières décennies, 
les sondages in situ des plasma spatiaux ont apporté beaucoup à la connaissance de la
magnétosphère terrestre et du milieu interplanétaire ; mais ces mesures ne concernent 
que le Système Solaire. Aujourd'hui la mesure des flux de neutrino est tout à fait intéressante,
mais son intérêt reste focalisé sur l'étendue plus précises des structures internes des 
étoiles ou des phénomènes d'explosion de supernova. La détection des zones gravitationnelles 
ouvre les perspectives d'une nouvelle astronomie tant les potentialités en ce domaine son
vastes : mais nous nous sommes encore aujourd’hui que dans des phases initiales de programmes
envisagés pour le siècle prochain.    
Aussi, nous paraît-il acceptable de borner, pour l'instant, l'étude de l'instrumentation
à celle de l'astronomie du rayonnement électromagnétique.
Afin d'alléger la lecture, trois types de renvois ont été systématiquement faits. Les références 
bibliographiques sont rejetés dans l'annexe A4 où elles ont été classées par chapitre. 
Chaque nom des grandes figures de l'astronomie fait l'objet d'une fiche ;  ces fiches sont 
classées par ordre chronologique dans l'annexe 1 ("fiches biographiques et séquentielles). 
La description de chaque type d'instruments et celle de quelques systèmes instrumentaux exemplaires 
ou récents a été renvoyée dans des fiches classées dans l'annexe A2. Quelques rappels de 
techniques mathématiques élémentaires sont indiquées dans l'annexe A3. Enfin, un lexique des 
mots clés a été rédigé et mis dans l'annexe A5 : ce lexique est d'importance car comme l'a écrit 
EPICURE dans sa lettre a Hérodote : "il faut savoir à quoi renvoie les mots afin que nous ayons 
une pierre de touche à laquelle rapporter les opinions... afin que les notions restées floues
ne nous rejettent pas dans l'incertitude... afin que nous ne parlions pas pour ne rien dire."

Enfin, le souci majeur qui a présidé à la réduction de secours et __la mise en relation__ 
d'éléments que la réalité rassemble mais que l'approche cloisonnée des disciplines dissocie 
(y compris au sein de la physique lorsque, par exemple, il faut passer de la photométrie à 
l'optique géométrique, puis à l'optique ondulatoire, puis à la physique quantique appliquée 
à l'étude des photons).  L'approche est donc délibérément multidimensionnelle au risque de
demeurer superficielle. Les sciences construisent des démarches, étayées par des présupposés
philosophiques : l'histoire de l'astronomie illustre superbement se fait. Pourtant, un prudent 
silence évite presque toujours d'afficher ces présupposés et de discuter cette mise en relation 
science/philosophie. Le risque a été pris de l'évoquer clairement en avançant sans masque. 
Au lecteur de corriger les biais qu'il ne manquera pas de discerner, et d'entreprendre un 
travail personnel pour penser par lui-même. 

Guy Serra

