---
title: 'Spherical refracting surface  : overview'
media_order: dioptre-1.gif
---

### What is a refracting interface ? 

#### Refracting surface : physical description

* **Interface separating two transparent media of different refractive indices**.

* can be **found in nature** :<br>
Examples :<br>
\- a **plane refracting surface** : the *flat and quiet surface of a lake*.
\- a **spherical refracting surface** : a *fish ball aquarium*.

![](spherical-refracting-surface-example-1.jpg)<br>
Fig. 1. The spherical refracting interface of a fish ball aquarium.

* **appears in the design and modeling of other optical elements** :<br>
Examples :<br>
\- a **glass window pane** is the combinaison of *two parallel plane refracting interfaces* (air/glass, then glass/air), separated by the thickness of the pane.<br>
\- a **lens** is composed of *two consecutive curved (often spherical) refracting interfaces* (air/glass, then glass/air) that are rotational symmetrical around a same axis.

#### Refracting interface versus refracting surface

!!!! *DIFFICULT POINT* : One plane or spherical refracting interface has two different optical behaviors for image formation, 
is characterized by two different sets of parameters, depending of the direction of the light propagation.
!!!!
!!!!Consider a plane interface (a thick window whose thickness and effect can be neglected) separating air and water, 
and two twins (Thompson and Thomson) at equal distances on both sides of the interfaces (Fig. 2a).
!!!!
!!!! ![](plane-refracting-surface-1.jpg)<br>
!!!! Fig. 2a : The situation is not symmetrical.
!!!!
!!!! * When Thompson (in air) looks at Thomson (in water), the light propagates from Thomson to Thompson’s eyes. 
The fact is that Thompson sees the image of his brother closer than the real position of his brother (Fig. 2b)
!!!!
!!!! ![](plane-refracting-surface-2.jpg)<br>
!!!! Fig. 2b. Thompson sees his brother closer than his real position in water.
!!!!
!!!! * In the opposite situation, when Thomson (in water) looks at Thompson (in air), 
the light propagates from Thompson to Thomson’s eyes. 
And the fact is that Thomson sees the image of his brother farther away than his real position (Fig. 2c)<br>
!!!! (Strictly speaking, the eye of a fish should be considered in this situation, eyes well adapted to the vision in water, 
and in direct contact with water. If not, we should consider that the Thompson’s dive mask is filled with water,
to have Thomson’s eyes in contact with water and not add another water/air refracting interface 
(that of the dive mask) on the path of the light).
!!!!
!!!! ![](plane-refracting-surface-3.jpg)<br>
!!!! Fig. 2c. Thomson sees in brother farther than his real position in air.
!!!!
!!!! All this can be predicted and calculated, but this example shows that this air/water plane 
refracting interface corresponds to two different plane refracting surfaces :<br>
!!!!
!!!! * First case , refracting surface such as :<br>
!!!!   \- refracting index of the medium of the incident light : $n_{inc} = n_{water} = 1.33$<br>
!!!!   \- refracting index of the medium of the emergent light : $n_{eme} = n_{air} = 1$<br>
!!!!
!!!! *¨ Second case , refracting surface such as :<br>
!!!! \- refracting index of the medium of the incident light : $n_{inc} = n_{air} = 1$<br>
!!!! \- refracting index of the medium of the emergent light : $n_{eme} = n_{water} = 1.33$.
!!!!

#### Difference in terminology between Spanish, French and English

!!!! *BE CAREFUL* :<br>
!!!! In the same way as we use in English the single word "mirror" to qualify a "reflecting surface", in French is use the single word "dioptre" to qualify a "refracting surface".
!!!! The term "dioptre" in English is a unit of mesure of the vergence of an optical system. In French, the same unit of measure is named "dioptrie".
!!!! So keep in mind the following scheme :
!!!!
!!!! refracting surface : *EN : refracting surface* , *ES : superficie refractiva* , *FR : dioptre*.<br>
!!!! _A crystal ball forms a spherical refracting surface : un "dioptre sphérique" in French._
!!!!
!!!! unit of measure : *EN : dioptre* , *ES : dioptría* , *FR : dioptrie*.<br>
!!!! _My corrective lens for both eyes are 4 dioptres : "4 dioptries" in French._


#### Non stigmatism of spherical refracting surfaces

Ray tracing study of a **spherical refracting surface** :
[Click here for geogebra animation](https://www.geogebra.org/material/iframe/id/x4hxqekd)<br>

* **At each impact point** of the rays upon the spherical refracting surface, the **Snell-Descartes relation applies**.

![](dioptre-spherique-snell-law.png)<br>

*  A spherical refracting surface is **not stigmatic** : The *rays (or their extensions)* originating *from a same object point* and that emerge from the surfac egenerally *do not converge towards an image point*.

![](dioptre-spherique-non-stigmatique-1.png)<br>

* **If we limit the opening** of the spherical refracting surface so that only the rays 
meeting the surface near the vertex are refracted through the surface.

![](dioptre-spherique-non-stigmatique-2.png)<br>

* **and if** the object points remain close enough to the optical axis, so that the **angles of 
incidence and refraction remain small**, then for each object point an image point can be almost
defined, and therefore the spherical refracting surface becomes *quasi-stigmatic*.

![](dioptre-spherique-gauss-conditions.png)<br>


#### Gauss conditions / paraxial approximation and quasi-stigmatism

When spherical refracting surfaces are used under the following conditions, named **Gauss conditions** :<br>
\- All *incident rays lie close to the optical axis*<br>
\- The *angles of incidence and refraction are small*<br>
Then *the spherical refracting surfaces* can be considered *quasi-stigmatic*, and therefore they can be used to build optical images.

Mathematically, when an angle $`\alpha`$ is small $`\alpha < or \approx 10 ^\circ`$,  the following approximations can be made :<br>
$`sin(\alpha) \approx  tan (\alpha) \approx \alpha`$, and $`cos(\alpha) \approx 1`$.

*Geometrical optics limited to Gaussian conditions* is called *Gaussian optics* or *paraxial optics*.


#### Thin spherical refracting surface

We call **thin spherical refracting surface** a spherical refracting surface *used in the Gauss conditions*.


### How is modeled a spherical refracting surface in paraxial optics ?


#### Characterization of a spherical refracting surface

* 2 distincts points : **vextex S** and **center of curvature C** on the optical axis,
which defines $`\overline{SC}`$ : algebraic distance between vertex S and center C of curvature on optical axis.

* 2 refractive index values :<br>
\- **$`n_{inc}`$ : refractive index of the medium of the incident light**.<br>
\- **$`n_{eme}`$ : refractive index of the medium of the emergent light**.

* 1 arrow : indicates the *direction of light propagation*

![](dioptre-1.gif)


#### Analytical study 


* **Thin spherical refracting surface equation** = **conjuction equation** for a spherical refracting surface<br><br>
**$`\dfrac{n_{eme}}{\overline{SA_{ima}}}-\dfrac{n_{inc}}{\overline{SA_{obj}}}=\dfrac{n_{eme}-n_{inc}}{\overline{SC}}`$**&nbsp;&nbsp;  (equ.1)

* **Transverse magnification expression**<br><br>
 **$`\overline{M_T}=\dfrac{n_{inc}\cdot\overline{SA_{ima}}}{n_{eme}\cdot\overline{SA_{obj}}}`$**
&nbsp;&nbsp;  (equ.2)<br><br>
You know $`\overline{SA_{obj}}`$, $`n_{inc}`$ and $`n_{eme}`$, you have previously calculated $`\overline{SA_{ima}}`$, so you can calculate $`\overline{M_T}`$ and deduced $`\overline{A_{ima}B_{ima}}`$.


! *USEFUL* : The conjuction equation and the transverse magnification equation for a plane refracting 
!surface are obtained by rewriting these equations for a spherical refracting surface in the limit when
!
! $`|\overline{SC}|\longrightarrow\infty`$.<br> 
! Then we get *for a plane refracting surface :*
!
! * *conjuction equation :*&nbsp;&nbsp; $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=0`$ &nbsp;&nbsp; (equ.3)
!
! * *transverse magnification equation :*&nbsp;&nbsp; $`\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$
&nbsp;&nbsp; (equ.2, unchanged)<br><br>
! but (equ.3) gives $`\dfrac{\overline{SA_{ima}}}{\overline{SA_{obj}}}=\dfrac{n_{inc}}{n_{eme}}`$.<br>
! Copy this result into (equ.2) leads to $`\overline{M_T}=+1`$.


#### Graphical study

##### 1 - Determining object and image focal points

Positions of object focal point F and image focal point F’ are easily obtained from the conjunction equation (equ. 1).

* Image focal length $`\overline{OF'}`$ : $`\left(|\overline{OA_{obj}}|\rightarrow\infty\Rightarrow A_{ima}=F'\right)`$<br>
&nbsp;&nbsp;&nbsp;&nbsp;(equ.1)$`\Longrightarrow\dfrac{n_{eme}}{\overline{SF'}}=\dfrac{n_{eme}-n_{inc}}{\overline{SC}}`$
$`\Longrightarrow\overline{SF'}=\dfrac{n_{eme}\cdot\overline{SC}}{n_{eme}-n_{inc}}`$ &nbsp;&nbsp;(equ.4)

* Object focal length $`\overline{OF}`$ : $`\left(|\overline{OA_{ima}}|\rightarrow\infty\Rightarrow A_{obj}=F\right)`$<br>
&nbsp;&nbsp;&nbsp;&nbsp;(equ.1) $`\Longrightarrow-\dfrac{n_{inc}}{\overline{SF}}=\dfrac{n_{eme}-n_{inc}}{\overline{SC}}`$
$`\Longrightarrow\overline{SF}=-\dfrac{n_{inc}\cdot\overline{SC}}{n_{eme}-n_{inc}}`$ &nbsp;&nbsp;(equ.5)

!!!! *ADVISE* :<br>
!!!! Memory does not replace understanding. Do not memorise (equ.4) and (equ.5), but understand
!!!! the definitions of the object and image focal points, and know how to find these two equations 
!!! from the conjuction equation for a spherical refracting surface.
!!!!

! *NOTE 1* :<br>
! An optical element being convergent when the image focal point is real, 
! so when $`\overline{OF}>0`$ (with optically axis positively oriented in the direction of the light propagation), 
! you can deduce from (equ.4) that is spherical refracting surface is convergent if and only if its center
! of curvature C is in the mmedium of highest refractive index.
!

##### 2 - Thin spherical refracting surface representation

* **Optical axis = revolution axis** of the refracting surface, positively **oriented** in the direction of 
propagation of the light (from the object towards the refracting surface)

* Thin spherical refracting surface representation :<br><br>
\- **line segment**, perpendicular to the optical axis, centered on the axis with symbolic 
**indication of the direction of curvature** of the surface at its extremities.<br><br>
\- **vertex S**, that locates the refracting surface on the optical axis.<br><br>
\- **nodal point C = center of curvature**.<br><br>
\- **object focal point F and image focal point F’**.

! *NOTE 2*<br>
! The direction of the curvature does not presume the convergent or divergent character
! of the diopter. It also depends on the refractive index values on each side of the spherical 
! refracting surface. look at what happens to the incident ray parallel to the optical axis 
in Figures 6 and 7, and 8 and 9, and review NOTE 1.
!


#### Non stigmatism of spherical refracting surfaces

Ray tracing study of a **spherical refracting surface** :
[Click here for geogebra animation](https://www.geogebra.org/material/iframe/id/gvkqgrpe)<br>
