---
title: Équations de Maxwell , fondement de l'électromagnétisme
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - les équations de Maxwell
      order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-isotropic-media
       name: PARALLÈLE : Propagation des ondes EM, du vide aux milieux matériels isotropes
       order: 1
    -
        slug: maxwell-equations-in-EM-learning-pattern
        name: SITUATION : Les équations de Maxwell dans l'électromagnétisme
        order: 2
    -   
        slug: combinaison-operators-for-electromagnetism
        name: OUTIL-MATH : Combinaison d'opérateurs pour l'électromagnétisme
        order: 2

---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\speed{\mathscr{v}}`$
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Quel fut le travail de Maxwell ?

* *Jusqu'au milieu du XIVème siècle*, **électricité, magnétisme et optique** étaient étudiés dans des *domaines scientifiques distincts*. 

* Cependant l'*observation de phénomènes naturels et d'expériences de laboratoire* montrèrent une
**interaction incomprise entre électricité, magnétisme,** voire **optique**.
    * naturel : la foudre peu charger des objets métalliques, aimante le fer, créé un éclair.
    * expériences :   
      \- un courant dévie l'aiguille d'une boussole.   
      \- le déplacement d'un aimant créé un courant.

* Bon mathématicien, **Maxwell** fait *synthèse des résultats expérimentaux* de son époque
qui se résume en 4 équations, les *équations de Maxwell*.

* Ces 4 équations **unifient électricité, magnétisme et optique** au sein de l'électromagnétisme,   
  et élargissent l'optique à un *monde nouveau : les ondes électromagnétiques*.

![](Maxwell-equation-fr.png)
_Maxwell modifie deux des équations de l'électrostatique et de la magnétostatique en
introduisant des termes de couplage entre E et B,
et révolutionne ainsi la physique._

#### Pourquoi disons-nous "équations" et pas "théorèmes" de Maxwell ?

* Les **4 équations de Maxwell** *ne sont pas démontrées*, donc elles ne constituent pas des théorèmes.
* Elles sont *posées et supposées vraies*, ce **sont des postulats**.


<!-----------------
#### Pourquoi ces équations fondent l'électromagnétisme ?

#### Quel est le domaine de validité de ces équations ?
------------------>

<br> 

------------

<br>

#### Que sont ces 4 équations de Maxwell ?

##### Sous forme locale 
_(fondamental, connaître)_

* Deux **expressions de la divergence** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ *inchangées par rapport au cas stationnaire* (électrostatique et magnétostatique) :

   * **$`\large{\mathbf{div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Gauss*).

   * ** $`\large{\mathbf{div \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-flux*).


* Deux **expressions du rotationnel** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ qui *changent et couplent les champs $`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$* :

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Faraday*).

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Ampère*).

* où :
   * $`\dens=\dens^{3D}`$ est la densité volumique de charge. 
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ est le vecteur densité volumique de courant. 

------------------

* Et ces équations *réécrites avec l'opérateur nabla : $`\mathbf{\nabla}`$ *

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**


------------------


##### Sous forme intégrale
_(savoir redémontrer)_


* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

* **Maxwell-Gauss** :   
     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
\iiint_{\Ltau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\Ltau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Maxwell-flux** :

     
  À tout instant t, et pour tout volume $`\tau`$ :
  
     * $`\forall \overrightarrow{r}, div \overrightarrow{B} = 0`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0 \\
\iiint_{\Ltau} div\;\overrightarrow{B} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Maxwell-Faraday** :

     
  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :

   * $`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}`$
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$  
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
\text{Newton : espace et temps indépendants,} \\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$   
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\begin{array}{l}
  &nbsp; \\
 \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
\end{array}`$**   
<br>   
   *  Cette équation joue un *rôle important pour les phénomènes d'induction*.    
      _La quantité_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$ 
      _d'appelation historique imparfaite "force électromotrice (fem)", homogène à une tension, est à l'origine d'un courant_
      _électrique traversant le contour $`\Gamma`$ si celui-ci représente un circuit conducteur._
     

---------------

* **Maxwell-Ampère** :

  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :
<br>

$`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
  $`\Longrightarrow`$$` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$  
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
\text{Newton : espace et temps indépendants},\\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$$`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$   
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$

**$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
$`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**

<br> 

------------

<br>

#### Pourquoi parlons-nous de champ électromagnétique ?

* Les 2 équations de couplage de $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ impliquent 
que **variables, $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ ne peuvent exister l'un sans l'autre**.

* Le terme *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implique $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* Le terme *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implique $`\overrightarrow{B}\ne \overrightarrow{0}`$*
 
<br> 

------------

<br>

#### Que disent les équations de Maxwell sur la conservation de la charge ?

##### Loi de conservation de la charge électrique

* Dans la matière, les **charges électriques** sont portées par les *électrons* et
les *protons* des noyaux atomiques. *En physique classique*, ces particules existent, 
et elles **ne peuvent ni surgir du vide, ni disparaître**.

* Ainsi le **principe de conservation de la charge** électrique peut se résumer en une phrase :   
<br>
! *Dans tout volume de l'espace et pendant une durée donnée, la charge électrique*
! *qui entre dans ce volume moins la charge électrique*
! *qui en sort est égale à la variation de la charge dans le volume.* 
<br>
Cela se traduit en *écriture mathématique* par l'**expression intégrale**:   
<br>
Pour toute surface fermée $`S`$ délimitant un volume macroscopique $`\Ltau`$,   
<br>
**$`\mathbf{\oiint_{S\leftrightarrow\Ltau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\Ltau}\dfrac{\partial\dens}{\partial t}\cdot d\tau=0}`$**   
<br>
qui s"énonce :   
<br>
! *Le flux du vecteur densité de courant volumique à travers une surface fermée,*
! *est égal à la dérivée temporelle de la charge totale contenue à l'intérieur de cette surface fermée.*

![](charge-conservation-law-L1200.jpg)

* Cette égalité étant vérifiée quelque-soit le volume d'intégration, c'est que 
  l'égalité porte sur les intégrandes eux-mêmes.   
  $`\Longrightarrow`$ la loi de conservation a aussi une **expression locale**, valide en tout point de l'espace, qui s'écrit :   
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**   

<br><br>

![](charge-conservation-1-L1200.jpg)

<br>

##### Etude des équation de Maxwell

* **Partons de** la combinaison d'opérateurs remarquable, valable pour tout champ vectoriel $`\overrightarrow{U}`$,
   qui s'énonce     
  *" La divergence du rotationnel d'un champ vectoriel est toujours nulle. "* :    
  <br>
  $`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,`$*$`\quad \mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{X}\big)=0}`$*.   
  <br>
  et appliquons là au champ d'induction magnétique  $`\overrightarrow{B}`$ :    
  <br>
  **$`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{B}\big)=0}`$**.

* La *loi de Maxwell-Ampère*   
  *$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$*   
  permet d'écrire :     
  <br>
  **$`\mathbf{div\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0}`$**

* En divisant les termes de droite et de gauche par $`\mu_0`$, l'équation se simplifie :   
  <br>
  $`div\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* L'équation contient déjà $`\overrightarrow{j}`$, je cherche à faire apparaître $`\dens`$.   
  Pour cela, je cherche à faire apparaître $`div\,\overrightarrow{j}`$ pour ensuite utiliser la loi de maxwell-Gauss.   
  <br>
  $`div\,\overrightarrow{j} + div\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

<!--------------------
L'espace et le temps étant découplés en physique classique, l'ordre de différentiation
et intégration n'importe pas si elles s'appliquent l'une à des coordonnées spatiales
et l'autre au temps. Ainsi :

$`div\,\overrightarrow{j} +
\dfrac{\partial}{\partial t}\Big(\epsilon_0\, div\,\overrightarrow{E}\Big)=0`$

ce qui permet d'écrire,

$`div\,\overrightarrow{j} + \dfrac{\partial\dens}{\partial t}=0`$

Je reconnais là la loi de conservation de la charge.
----------------------->

* Dans le cadre de la *physique classique, espace et temps sont indépendants*, 
l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   
<br>
*$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right)`$*    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}\left(div\right)`$*.   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Nous obtenons :   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**$`\mathbf{div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}\left(div\,\overrightarrow{E}\right)=0}`$**


* En utilisant la *loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}`$*   
  <br>
nous obtenons l'**équation de conservation locale de la charge** électrique en régime variable (donc toujours vérifiée) :   
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**


! *Les équations de Maxwell contiennent et impliquent la conservation de la charge électrique.*



<!--Plutôt pour partie principale--------------------

* Il faut faire apparaître les distributions de charge $`\dens^{3D}`$ et de vecteur  densité de courant volumique $`\overrightarrow{j}^{3D}`$.    
Pour cela nous utilisons la loi de Maxwell-Ampère    
* $`\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$   
<br>
$`div\big(
\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Simplifions en divisant de chaque côté par la constante magnétique $`\mu_0`$ :   
<br>
$`div\,\big(
\;\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Dans le cadre de la physique classique, espace et temps sont indépendants, l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   

$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right) `$    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.
$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}
\left(div\right)`$.   
Nous obtenons :   
<br>
$`div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}
\left(div\,\overrightarrow{E}\right)=0`$

* En utilisant la loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}`$ nous obtenons l'équation de conservation locale de la charge électrique en régime variable (donc toujours vérifiée) :   
<br>
$`div\,\overrightarrow{j} +\dfrac{\partial \dens^{3D}}{\partial t}=0`$
--------------------->

* Nous pouvons *intégrer cette égalité locale* sur un volume $`\tau`$ quelconque :   
<br>
$`\displaystyle\iiint_{\Ltau} \Big(div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}\big)\,d\tau=0`$   
<br>
*$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{j}\,d\tau+\iiint_{\Ltau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$*

* Le *théorème d'Ostrogradski* (= théorème *de la divergence*) précise que pour tout champ 
$`\overrightarrow{U}`$ vectoriel et pour tout volume $`\tau`$,    
*$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{U}\,d\Ltau=\oiint_S \overrightarrow{U}\cdot dS`$*,   
$`S`$ étant la surface fermée que délimite le volume $`\tau`$.   
<br>
*Appliqué au premier terme* de l'égalité, nous obtenons :   
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} + \iiint_{\Ltau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$**.  

* En remarquant de nouveau qu'*espace et temps sont indépendants en physique classique*, l'ordre de dérivation ou intégration par une variable spatiale et une variable temporelle n'importe pas :    
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{\partial}{\partial t} \left(\iiint_{\Ltau}\dens \,d\tau\right)=0`$**.    

* En constatant que *$`\displaystyle\iiint_{\Ltau}\dens^{3D} \,d\tau`$ est la charge totale $`Q_{int}`$* 
contenue dans le volume $`\tau`$, nous obtenons l'**expression intégrale de la loi de conservation** de la. charge :   
<br>
**$`\mathbf{\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{dQ_{int}}{dt}=0}`$**.    

<br> 

------------

<br>

#### Le champ électromagnétique peut-il céder de l'énergie à la matière ?

##### Puissance cédée à un porteur de charge

* La **sensibilité** d'une particule **à l'interaction électromagnétique** se quantifie
par le paramètre appelé *charge* électrique de la particule.   

* La force qui décrit l'*action d'un champ électromagnétique $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$* 
sur une particule de charge $`q`$ est la **force de Lorentz** d'expression :   
<br>
**$`\overrightarrow{F}_{\,Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{\speed}\land\overrightarrow{B}\Big)`$**<br>
<br>
&nbsp;&nbsp;où $`\overrightarrow{\speed}`$ est le vecteur vitesse de la particule dans le référentiel d'inertie de l'observation.

* *Lors d'un déplacement élémentaire $`\overrightarrow{dl}`$* de la particule dans le champ électromagnétique
$`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$, le **travail de la force de Lorentz** s'écrit :   
<br>
**$`d\mathcal{W}_{\,Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$**,   
<br>
soit   
<br>
$`\begin{align}
d\mathcal{W}_{\,Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{\speed}\land\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
&\\
&= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{\speed}\land\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
&\\
&= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big) \\
\end{align}`$   
<br>
où $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)`$ est le produit mixte de la séquence des trois vecteurs.

* Les *vecteurs $`\overrightarrow{\speed}`$ et $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$* étant *colinéaires*, le produit mixte 
est nul :   
<br>
*$`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$*,

!!!! 
!!!! <details markdown=1>
!!!! <summary>Rappels sur le produit mixte</summary>
!!!! Le produit mixte de trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$, noté $`(\vec{a}\,,\vec{b}\,,\vec{c})`$
!!!! est défini par :    
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{a}\land\vec{b})\cdot\vec{c}`$.   
!!!! Il est alors facile de démontrer qu'il est invariant par permutation circulaire des 3 vecteurs :
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{b}\,,\vec{c}\,,\vec{a})=(\vec{c}\,,\vec{a}\,,\vec{b})`$.
!!!! C'est donc un nombre réel, dont la valeur absolue s'identifie au volume du parallélépipéde 
!!!! créé les trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$.
!!!!
!!!! Dans le cas étudié, deux vecteurs au moins du produit mixte $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)`$
!!!! sont colinéaires car $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$.
!!!! Je peux dès lors m'assurer que ce produit mixte est nulle,    
!!!! * soit en remarquant que trois vecteurs dont deux sont colinéaires s'inscrivent dans un même plan (2D)   
!!!! et donc le volume (3D) construit par ces trois vecteurs est nul : 
!!!! $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$   
!!!! * soit en utilisant l'invariance du produit mixte par permutation circulaire,    
!!!! $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{\speed},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{\speed},\overrightarrow{\speed},\overrightarrow{B}\Big)`$
!!!! et en remarquant que le produit vecoriel de deux vecteurs colinéaires est nul :
!!!! $`\big\Vert\overrightarrow{\speed}\land\overrightarrow{\speed}\big\Vert=\big\Vert\overrightarrow{\speed}\big\Vert\cdot\big\Vert\overrightarrow{\speed}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{\speed}\land\overrightarrow{\speed}=\overrightarrow{0}`$   
!!!! $`\Longrightarrow \Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>
!!!! 

* $`\Longrightarrow`$ le **travail de la force de Lorentz** se simplifie :   
<br>
**$`d\mathcal{W}_{\,Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$**

! *Remarque :*
!
! La *force magnétique $`\overrightarrow{F}_{\,magn.}=q\,\overrightarrow{\speed}\land\overrightarrow{B}`$*, 
! par nature perpendiculaire au vecteur vitesse $`\overrightarrow{\speed}`$ et donc au vecteur déplacement 
! élémentaire $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$ en tout point de la trajectoire de la particule
! de charge $`q`$, *ne travaille pas* :
!
! $`\mathbf{d\mathcal{W}_{\,magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *Le travail de la force de Lorentz se limite au travail de la force électrique* :
!
! $`\mathbf{d\mathcal{W}_{\,Lorentz} = d\mathcal{W}_{\,élec} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

* La **puissance élémentaire cédée par le champ** à cette particule s'écrit :   
<br>
**$`\mathbf{\mathcal{P}_{cédée} = \dfrac{d\mathcal{W}_{\,Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{\speed}}`$**

##### Puissance cédée dans un matériau avec un seul type porteur de charge

* Si le **milieu matériel** contient *$`n`$ porteurs identiques de charge $`q`$ par unité de volume*,
alors un volume élémentaire $`d\tau`$ contient $`n\,\tau`$ porteurs de charge 
et la **puissance élémentaire cédée** par le champ électromagnétique s'écrit :   
<br>
**$`d\mathcal{P}_{cédée} = \mathcal{n}\,\big( q\,\overrightarrow{E}\cdot\overrightarrow{\speed}\big)\,d\tau`$**

* Exprimée *avec la densité volumique de charge $`\dens=\mathcal{n}\,q`$* :   
<br>
$`d\mathcal{P}_{cédée} = \big(\mathcal{n}\, q\big)\,\overrightarrow{E}\cdot\overrightarrow{\speed}\,d\tau = = \dens\,\overrightarrow{E}\cdot\overrightarrow{\speed}\,d\tau`$

* Exprimée *avec le vecteur densité volumique de courant $`\overrightarrow{j}=\dens\,\overrightarrow{\speed}`$*, en remarquant que 
$`\overrightarrow{E}\cdot\overrightarrow{\speed}=\overrightarrow{\speed}\cdot\overrightarrow{E}`$ :   
<br>
**$`d\mathcal{P}_{cédée} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau`$**

##### Puissance cédée dans un matériau avec un seul type porteur de charge

* Lorsqu'un matériau contient **plusieurs types de porteurs de charges $`q_i`$** 
en *concentrations $`n_i* et animées de *vitesses de dérives $`\overrightarrow{v_d\,i}`$* :   
<br>
$`\displaystyle d\mathcal{P}_{cédée} = \sum_{i=1}^p \big(\mathcal{n}_i\,q_i\,\overrightarrow{E}\cdot\overrightarrow{\speed_i}\big)\,d\tau`$   
<br>
$`\displaystyle d\mathcal{P}_{cédée} = \sum_{i=1}^p \dens_i\,d\tau\,\overrightarrow{E}\cdot\overrightarrow{\speed_i}`$   
<br>
$`\displaystyle d\mathcal{P}_{cédée} =  \sum_{i=1}^p\overrightarrow{j_i}\cdot\overrightarrow{E}\,d\tau`$   
<br>
*$`d\mathcal{P}_{cédée} = \overrightarrow{j}_{total}\cdot\overrightarrow{E}\,d\tau`$*

* En posant plus simplement *$`\overrightarrow{j}_{total}=\overrightarrow{j}`$* :     
<br>
**$`\large{\mathbf{d\mathcal{P}_{cédée} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

* La *puissance cédée* par le champ électromagnétique *dans un volume $`\tau`$* s'appelle **$`\large{\text{Effet Joule}}`$**   
<br>
**$`\large{\displaystyle\mathbf{\mathcal{P}_{cédée} = \iiint_{\Ltau}\big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

<br> 

------------

<br>

#### Le champ électromagnétique contient-t-il de l'énergie ?

* Si le *champ électromagnétique* peut céder de l'énergie à la matière, c'est que lui-même il **contient de l'énergie**.

* Un champ électromagnétique $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ s'étendant dans l'espace, 
  l'énergie contenue dans le champ est décrite par 
  une **densité volumique d'énergie électromagnétique $`\dens_{énergie-EM}^{3D}`$** définie en chaque point de l'espace.

* A partir des équations de Maxwell, on montre avec une combinaison d'opérateur adéquate (à faire) que cette
  densité volumique $`\dens_{énergie-EM}^{3D}`$ *possède deux composantes* :   
   * une *composante électrique $`\;\dens_{énergie-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*
   * une *composante magnétique $`\;\dens_{énergie-EM}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
   
* Ainsi, en tout point de l'espace :   
  <br>
  **$`\large{\mathbf{\dens_{énergie-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}}}`$**


* L'énergie électromagnétique $`\mathcal{E}_{EM}`$ contenue **dans un volume $`\tau`$** s'exprime :   
  <br>
  **$`\displaystyle\large{\mathbf{\mathcal{E}_{EM}=\iiint_{\Ltau} \left(\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}\right) d\tau}}`$**

<br>

------------

<br>

#### Pourquoi parlons-nous d'ondes électromagnétiques ?

##### Equation d'onde

* Pour un *champ vectoriel $`\overrightarrow{U}(\overrightarrow{r},t)`$*, l'**équation d'onde de d'Alembert** s'écrit :   
<br>
**$`\Delta \overrightarrow{U} - \dfrac{1}{\speed^2} \; \dfrac{\partial^2 \;\overrightarrow{U}}{\partial\; t^2}=0`$**   

* L'expression de l'*opérateur Laplacien vectoriel $`\Delta`$* en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :   
<br>
*$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$*

* L'**idée** est de *calculer pour chacun des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$* 
l'expression de *son Laplacien*, pour voir si une identification avec l'équation d'onde est
réalisée.


##### Etude de la composante $`\overrightarrow{E}`$ du champ électromagnétique.


* Pour **établir l'expression $`\;\;\Delta \overrightarrow{E}`$**, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ *à partir des équations
de Maxwell*.


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$   
<br>
En physique classique, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle n'importe pas, donc :   
<br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$   
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
*$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$*
<br><br>

* *$`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right)`$*

<br>


* La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :   
<br>
$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$   
<br>
ce qui donne par identification au premier terme de l'équation d'onde :   
<br>
**$`\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}}`$**   
<br>
_(équation de propagation du champ électrique)_

##### Etude de la composante $`\overrightarrow{B}`$ du champ électromagnétique.

* Une *étude de forme identique* (proposée en autotest dans la partie beyond) me conduirait 
pour le champ magnétique  $`\overrightarrow{B}`$ à l'équation de propagation :   
<br>
**$`\mathbf{\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}}`$**   
<br>
_(équation de propagation du champ magnétique)_

##### Propagation d'une onde électromagnétique dans la matière

* L'étude part des équations de Maxwelle et des deux équations   
<br>
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}`$   
<br>
$`\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$   
<br>
et fait l'objet de tout un **développement dans un chapitre ultérieur**.


##### Propagation d'une onde électromagnétique dans le vide

 * L'*espace vide* est caractérisé par une absence de charges, fixes ou en mouvement. 
 La densité volumique de charge $`\dens_{vide}`$ de même que le vecteur densité volumique de courant
 $`\overrightarrow{j}_{vide}`$ ont une valeur nulle dans tout l'espace vide,   
 <br>
 *$`\dens_{vide}=0\quad\text{et}\quad\overrightarrow{j}_{vide}=\overrightarrow{0}`$*.
 
 * Dès lors, la propagation de l'onde électromagnétique dans le vide s'exprime sous la forme
 du système de **deux équations de d'Alembert** :   
 <br>
**$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$**   
<br>
**$`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$**

!!!! *Attention* :   
!!!!
!!!! Les *équations de Maxwell impliquent la propagation du champ électromagnétique*.
!!!!
!!!! *Mais,*
!!!!
!!!! Les *deux équations d'onde pour les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$
!!!! n'impliquent pas les équations de Maxwell*.
!!!!
!!!! Tout champ $`\overrightarrow{E}`$ qui vérifie 
!!!! $`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! et tout champ $`\overrightarrow{B}`$ qui vérifie
!!!! $`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! ne décrivent la propagation d'une onde électromégnétique que si  $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$
!!!! vérifient les équations de Maxwell.


##### Célérité de la vitesse de la lumière dans le vide

* L'identification des équations de propagation des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$
avec l'équation d'onde de d'Alembert montre que *le champ électroimagnétique se propage à la célérité*   
<br>
*$`\large{\mathscr{v}=\dfrac{1}{\sqrt{\epsilon_0\,\mu_0}}}`$*

* La *célérité de la lumière dans le vide*, notée *$`\mathbf{c}`$* est une **constante fondamentale** de l'univers, et sa valeur exacte est :  
<br>
*$`\large{c=299 792 458 m\,s^{-1}\approx 3\times 10^8 m\,s^{-1}}`$*

!! *Pour aller plus loin* :   
!!
!! Les équations de propagation des ondes électromagnétiques, établies ici dans le cadre
!! de la physique classique,   
!! prévoient que les ondes électromagnétiques se propagent dans le vide à la célérité
!! $`c=1/\sqrt{\epsilon_0\,\mu_0}`$, célérité constante indépendante du mouvement de l'observateur.   
!!
!! ceci est en contradiction avec la loi d'addition des vitesses en mécanique classique, qui
!! résulte des transformations de Galilée.
!!
!! $`\Longrightarrow`$ pendant la seconde moitié du $`19^{ème}`$ siècle, le travail de physiciens fut
!! d'essayer de modifier les équations de Maxwell pour les rendre compatibles avec la physique classique.   
!!
!! Mais ce fut l'inverse qu'il fallait faire : modifier la mécanique de Newton, base de la physique classique,
!! pour la rendre compatible avec les équations de Maxwell.
!!
!! Ce travail inverse fut celui d'Albert Einstein, qui publia en 1905 un article intitulé   
!! "Sur l'électrodynamique des corps en mouvement",   
!! qui fut la naissance de la théorie de la Relativité restreinte, qui bouleverse notre conception
!! de l'espace et du temps.
!!
!! Plus tard, en 1915, Einstein soumet un article intitulé   
!! "Les fondements de la théorie de la Relativité Générale"   
!! qui bouleverse notre conception du rapport entre l'espace-temps et son contenue en matière et énergie.
!!
!! *Physique Newtonienne* :   
!! espace + temps + matière + énergie.   
!!
!! *Physique relativiste au sens restreint* :   
!! espace-temps + matière-énergie ($`E=m\,c^2`$).   
!!
!! *Physique relativiste au sens général* :   
!! espace-temps-matière-énergie.   

<br>

-------

<br>

#### Qu'est-ce que le spectre électromagnétique ?


* **Maxwell** émet l'hypothèse que *la lumière* visible, dont on venait de mesurer la vitesse à partir
 de l'observation astronomique du mouvement des satellites de Jupiter, *est une onde électromagnétique*.   
<br>
$`\Longrightarrow`$ la lumière n'est qu'une toute petite partie des ondes électromagnétiques.   
<br>
$`\Longrightarrow`$ tout un *monde nouveau de "lumières"* se révèle, appelé **spectre électromagnétique**.   

![](astro-electromagnetic-spectrum-N4_1_fr_L1200.jpg)

* En particulier, **la connaissance de l'univers** résultait de sa seule observation dans le domaine visible,

![](ciel-visible-bsp_L1200.jpg)

* *s'étend maintenant à l'ensemble du spectre électromagnétique*.

![](ciel-images-bsp_L600_transparence.gif)

<br>

------

<br>

#### Qu'est-ce que le vecteur de Poynting ?


* L'**onde électromagnétique contient de l'énergie**
   * avec *en chaque point de l'espace* une **densité volumique d'énergie $`\dens_{énergie-EM}^{3D}`$**,   
    \- avec une *composante électrique $`\dens_{énergie-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*,   
    \- avec une *composante magnétique $`\dens_{énergie-EM}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
   * qui **se déplace dans le vide** *à la vitesse $`c`$*. 

   
   
* Le **vecteur de Poynting** traduit ce fait, et permet le *calcul de l'énergie* d'une onde électromagnétique
  incidente *sur une surface quelconque par seconde*.
 
* Le **vecteur de Poynting**, définit en chaque point de l'espace, est *défini par* la relation :   
<br>
   *$`\large{\mathbf{d\mathcal{P}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$*   
<br>
où $`d\mathcal{P}`$ est la *puissance élémentaire* de l'onde électromagnétique
*rayonnée à travers l'élément de surface* $`\overrightarrow{dS}`$.

![](poynting-vector-1_L1200.jpg)

* Son **expression** en fonction des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ est :   
  <br>
  **$`\large{\mathbf{\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}}}`$**

* *Unité SI* : **$`\mathbf{W\,m^{-2}}`$**

! *Remarque 1* :   
!
! Le déplacement d'une charge $`(unité SI : C)`$ contenue dans un volume élémentaire
! $`d\tau\quad (SI : ! m^3)`$ de densité volumique de 
! charge $`\dens_{charge}^{3D}\quad (SI : C\,m^{-3})`$ à une vitesse 
! $`\overrightarrow{\mathscr{v}_d}\quad (SI : m\,s^1)`$ :   
! * permet de définir un vecteur densité de courant (électrique) volumique 
! $`\overrightarrow{j}_{courant}^{3D}=\dens_{charge}^{3D}\,\mathscr{v}_d\,,\quad (SI : A\,m^{-2})`$,
!  * et ainsi permet de calculer l'intensité élémentaire $`dI\quad (SI : A = C\,s-{-1})`$ du courant qui traverse
! tout élément de surface 
! $`\overrightarrow{dS}\quad (SI : m^2)`$,   
! $`dI= \overrightarrow{j}_{courant}^{3D}\cdot\overrightarrow{dS}`$,   
!
! de même,  
! 
! le déplacement de l'énergie $`(unité SI : J)`$ de l'onde électromagnétique contenue 
! dans un volume élémentaire $`d\tau\quad (SI : ! m^3)`$ de densité volumique d'énergie
! $`\dens_{énergie_EM}^{3D}`$ à la célérité $`c`$ :   
! * permet de définir l'équivalent d'un vecteur densité de puissance de l'onde électromagnétique 
! , appelé *vecteur de Poynting* et noté *$`\overrightarrow{\Pi}\quad (SI : J\,s^{-1}\, m^{-2}=W\, m^{-2}=`$,
! * ce qui permet de calculer la puissance élémentaire $`d\mathcal{P}\quad (SI : W)`$ de l'onde EM qui traverse tout élément de surface 
! $`\overrightarrow{dS}`$,   
! $`d\mathcal{P}= \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$.   

! *Remarque 2* :   
!
! *L'expression du vecteur de Poynting* en fonction du champ électrique et du champ magnétique de l'onde,
! ainsi que *sa signification*, sont *plus faciles à retenir* si l'on choisit de l'exprimer 
! *en fonction du champ d'excitation magnétique $`\overrightarrow{H}`$*.  
!
! *__Dans le vide__ (et uniquement dans le vide)* :   
!  Le champ magnétique est aussi bien décrit par le champ d'induction 
! $`\overrightarrow{B}`$ qui intervient dans la force de Lorentz qui induit les effets, 
! que par le champ d'excitation magnétique $`\overrightarrow{H}`$.  
! Ces deux champs sont proportionnels, le rapport de proportionnalité étant la constante magnétique $`\mu_0`$ :   
! <br>
! $`\overrightarrow{B}=\mu_0\,\overrightarrow{B}\quad\text{(dans le vide)}`$
!
! L'expression dans le vide du vecteur de Poynting est alors :   
! <br>
! $`\overrightarrow{\Pi}=\overrightarrow{E}\land\overrightarrow{H}`$
!
! En se souvenant 
! * de l'électrostatique que l'unité SI de $`\overrightarrow{E}`$ est le $`V\,m^{-1}`$,   
! * de la magnétostatique que l'unité SI de $`\overrightarrow{H}`$ est le $`A\,m^{-1}`$,   
! * de l'étude des circuits que $`\mathcal{P}\,(W) = U\,(V)\times I\,(A),   
!
! alors l'*unité SI du vecteur de Poynting* apparaît facilement comme le *$`V\,A\,m^{-2}= W\,m^{-2}`$*
! 
! Dans le système international de mesure, le Vecteur de Poynting s'exprime en *Watt par mètre carré*.
!
! La *grandeur physique du vecteur de Poynting* est une *puissance par unité de surface*.


<br>

------

<br>

#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?

* Se calcul simplement par l'expression :   
<br>
**$`\large{\mathbf{\mathcal{P}=\iint_S \overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$**  


#### Comment émettre une onde électromagnétique ?

* Il suffit d'**accélérer une particule chargée**.

<!---------------------
#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles
---------------------->








