---
title: Géométrie et coordonnées - proposition 2
published: true
routable: true
visible: false
lessons:
   - slug: geometry-coordinates-prop2-123-panorama-overview
     order: 1
   - slug: geometry-coordinates-prop2-1-linear
     order: 2
   - slug: geometry-coordinates-prop2-1-parallel
     order: 2
---



---------------------------------------------

!!!! *Attention : COURS EN CONSTRUCTION :*    
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

<!--MétaDonnée : ... -->

---------------------------------------------

!   
! *LE  TEMPS  ET  L'ESPACE*   
! (sera probablement un bloc - une page html - à part entière)
!

<!-- partie synthèse du chapitre "Perception et représentation du temps"-->

### Le temps


#### Que perçois-je du temps?


#### Qu'est-ce qu'un phénomène cyclique?


#### Comment puis-je mesurer la durée entre deux évènements ?


#### Comment puis-je repérer un évènements dans le temps?


#### De quoi pouvons nous convenir ensemble sur le temps?


#### Quelles sont les unités de mesure des durées?


#### Quelle différence entre durée et date ?


#### Comment trouver la durée entre deux évènements connaissant leurs dates?


--------------------------

<!-- partie synthèse du chapitre "Perception et représentation de l'espace"-->

### L'espace


#### Que perçois-je de l'espace?


#### Comment situer un objet par rapport à moi?


##### Qu'est-ce que la distance?


##### Qu'est-ce que la direction?


#### Que signifie "l'espace possède 3 dimensions"?


#### De quoi pouvons nous convenir ensemble sur l'espace?


#### Quelles sont les unités de mesure des longueurs?


#### Comment localiser un objet de façon utile pour tous?

Il faudra préciser des éléments de vocabulaire.
Idée :
Localiser $`\equiv`$ situer $`\equiv`$ positionner (ou trouver la position) $`\equiv`$ repérer
Dans le langage courant :   
situer < trouver la position < repérer $`\le`$ localiser
(c'est difficile, chaque mots a toujours différents usages, différentes définitions...)

(là, on verra que pour trouver une réponse complète à cette question, on aura
besoin des propriétés de l'espace : donc de sa géométrie)

#### Comment trouver la distance entre deux objets connaissant leurs positions?

(c'est la suite, donc idem, on aura besoin de la géométrie de notre espace sensible, donc euclidienne)



<!--====================================================-->

!   
! *LA  GEOMETRIE  DE  L'ESPACE*   
! (sera probablement un bloc - une page html - à part entière dans cette proposition)
! <!--(autre type de titre possible : " ... ")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! <br>
! </details>

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :

1 - Sègment de droites, droites et demi-droites   
1.1 - Le sègment de droite     
1.2 - Du sègment de droite et à la droite     
1.3 - Droites séquentes et droites parallèles     
2 - Le plan   
3 - La sphère   
4 - Le cercle   
4.1 - Le cercle   
4.2 - l'arc de cercle   
5 - Les angles    
5.1 - Comment définir un angle    
5.2 - comment quantifier un angle    
5.3 - Les angles remarquables     
5.3.1 - L'angle complet : 360°      
5.3.2 - L'angle plat : 180°      
5.3.3 - L'angle droit : 90°      
5.3.4 - L'angle de 45°      
5.3.5 - L'angle de 60°   
5.3.6 - L'angle de 30°   
5.3.7 - Réaliser un angle de valeur donnée.   


------------------------------------

<!--====================================================-->

!   
! *DES  FIGURES  ET  DES  VOLUMES*   
! (sera probablement un bloc - une page html - à part entière)
! <!--(autre type de titre possible "J'identifie et réalise des formes, je calcul des surface et des volumes")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>  
! Idée d'un bloc très "utilitaire". Pour apprendre à reconnaître, nommer et savoir comment contruire des formes, et à recevoir les formules mathématiques pour s'entraîîner à calculer des aires et des volumes.<br>
! <br>
! </details>

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :

1 - Lignes, surfaces et volumes   
2 - Les figures simples dans un plan :     
2.1 - Les quadrilatères   
2.1.1 - Le quadrilatère   
2.1.2 - Le rectangle et le carré   
2.1.2 - Le parallélogramme et le losange   
2.1.3 - Le trapèze   
2.2 - Les triangles   
2.2.1 - Le triangle   
2.2.2 - Le triangle rectangle   
2.2.3 - Les triangles isocèle et équilatéral (est-ce vraiment utile?)   
2.2.4 - Triangles semblables    
2.2.5 - Tracer un triangle de longueurs de côtés données.   
2.3 - Les polygones   
2.4 - Le cercle   
3 - Les volumes simples dans l'espace :     
3.1 - Le cube et le parallélépipède rectangle   
3.2 - Les prismes (avec pour base différents polygones)    
3.3 - Les pyramides (avec pour base différents polygones)    
3.4 - Le cylindre   
3.5 - La sphère   

---------------------------

<!--====================================================-->

!   
! *GÉOMÉTRIE  ET  RÈGLES  DE  CALCUL*   
! (sera probablement un bloc - une page html - à part entière dans cette proposition)
!  <!--(autre type de titre possible "La géométrie m'aide à calculer")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! un tel bloc "Géométrie et règles de calcul" peut à ce niveau aider ceux qui ont des problèmes avec les règles du calcul numérique.<br>
! <br>
! </details>  

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :

1 - Triangles semblables et théorème de Thalès    
2 - Carrés, rectangles, triangles rectangles et le théorème de Pythagore   
3 - Carrés, rectangles, et l'égalité $`(a+b)^2=a^2+b^2+2ab`$   
4 - La projection parallèle   
5 - Cercle, projection, et fonctions sinus et cosinus   
6 - Le nombre $`\large{\pi}`$   

---------------------------------------

<!--====================================================-->

!   
!  *INVARIANCES  ET  SYMÉTRIES  EN  GÉOMÉTRIE*  
!  <!--(autre type de titre possible "Je vois des formes symétriques")--> 
!  (sera probablement un bloc - une page html - à part entière dans cette proposition)
!  Question : Dès ce niveau 1? ou on démarre au niveau 2?   
!  
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! À faire. symétrie par rapport à un point, à une droite, à un plan...<br>
! <br>
! Ce sujet mériterait un chemin pédagogique sur 4 niveaux à lui tout seul.<br>
! <br>
! Mais déjà cela conduit à mettre en valeur (ou être sûr qu'ils apparaissent dans le chapitre DES FIGURES ET DES VOLUMES, je pense en particulier à l'hexagone) les traingles, parallélogrammes quadrilatères et l'hexagone, car on peut remplir un plan avec chacun d'eux sans laisser d'interstices vides. Permiers pas vers les cristaux. On peut prendre comme exemple très concret les formes possibles pour l'élément de base d'une mosaïque ou d'un dallage (en considérant des joints extrêmement fins).<br>
! <br>
! et peut-être les volumes platoniciens? Pas grande utilité de fait. Peut-être simplement dans une partie "beyond"?<br>
! <br>
! </details> 

--------------------------------------------------

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :

<!--====================================================-->

!   
!  *SYSTÈMES  DE  COORDONNÉES*   
!  (sera probablement un bloc - une page html - à part entière dans cette proposition)
!  <!--(autre type de titre possible "Je me situe sur Terre, je repère des lieux")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! Introduire les systèmes de coordonnées.
! <br>
! </details>  

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :

1 - Je repère à l'aide de coordonnées
2 - Je localise sur le globe terrestre
3 - J'utilise une carte routière.
4 - Je situe avec table d'orientation panoramique
5 - Je fais une course d'orientation
5.1 - avec géolocalisation par satellite.
5.2 - avec une carte et une boussole.
5.3 - sans instrument ni carte.
6 - Du globe terretre à une carte du monde.

----------------------------------------------

<!--====================================================-->

!   
!  *DES  GRANDEURS  PHYSIQUES  QUI  VARIENT, ET  LEURS  REPRESENTATIONS*   
!  (sera probablement un bloc - une page html - à part entière dans cette proposition)
!  <!--(autre type de titre possible "Je modélise la nature")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! L'idée est d'introduire :<br>
! - pour la suite dans ce niveau 1, les grandeurs comme la vitesse, l'accélération, les forces, qui ne se résument pas à un nombre.<br>
! - pour le niveau 2, idem, et on commencera à parler de grandeurs scalaires et vectorielles.<br>
! - pour le niveau 3, les grandeurs et champs scalaires et vectoriels.<br>
! - pour le niveau 4, les grandeurs et champs tensoriels, avec le tenseur comme une généralisation et un dépassement des scalaires et des vecteurs.
! <br>
!
! Donc déjà par dire ce qu'est une grandeur physique (je ne vois pas de mot plus simple pour ce niveau).<br>
! Les grandeurs physiques qui peuvent s'exprimer par un nombre (exemple : température) et par une flèche plus ou moins longues (exemple : vitesse du vent).<br>
! Ces grandeurs peuvent varier dans l'espace comme dans le temps.<br>
! Comment représenter les variations spatiales de ces grandeurs :<br>
! - une carte météorologique des température.<br>
! - une  carte météorologique des vents.<br>
! et leurs variations temporelles
! - pour continuer avec les exemples météorologiques et faire prendre conscience de l'urgence climatique :<br>
! &nbsp;&nbsp; - animation (gif) prévisions températures moyennes sur le globe -->2100 pour différents scénarios.<br>
! &nbsp;&nbsp; - graphique (température moyenne/temps) -->2100 sur une zone donnée du globe.<br>
! <br>
! Lien direct avec un bloc en mathématique sur les fonctions et leurs représentation, avec possibilité d'affichage en parallèle dans un mode.<br>
! <br>
! </details>  

---------------------------------------

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :

<!--====================================================-->

!   
!  *MODELISER  LES  PHENOMENES  OBSERVÉS*   
!  (sera probablement un bloc - une page html - à part entière dans cette proposition)
!  <!--(autre type de titre possible "Je modélise la nature")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! Il s'agit en fait sans le dire d'une première introduction (sans le dire) à la méthode scientifique. A partir des observations sur le temps, l'espace, les corps immobiles et en mouvements et des propriétés géométriques de l'espace et des nombres et des opérations d'introduire  la notion de modélisation physique.<br>  
! <br>
! Et de façon plus concrête, à partir des ces éléments de perceptions et de la mathématique, d'introduire la physique classique et la physique moderne.<br> 
! <br>
! Même si on doit bétonner la physique classique, car c'est celle qui est utile dans la vie de tous les jours, celle qui se "ressent" dans notren expérience du quotidien et qui nous permet de réaliser tout projet à ce niveau 1, il est important d'avoir une connaisance culturelle sur la physique moderne. Et la mise en parallèle de la physique classique, des relativités et quantique permet de mieux comprendre les "bases" de chacune, comment elles façonnent chacune notre vision du monde et se complètent, et de comprendre la notion-même de "modèle".<br>
! <br>
! Donc, a priori, se dirige en ce qui concerne la physique classique, vers la première étape de cinématique (sans dire ce mots), débarrassée des coordonnées. Donc a priori, on partirait des notions de position, de vitesse et d'accélération. Puis (sans le dire) vers des sensations physiques utiles, puis des concepts de dynamique et d'énergétique. <br>
! <br>
! </details>  

--- à faire ---
Quelles questions se poser sur ce thème ?   
Les chapitres du cours correspondants sont :


<!--====================================================-->

--------------------------------------------------------------------

### Tests de visualisation (notamment sur smartphones) de figures,


! *Concernant le temps et l'espace
!


#### Que perçois-je du temps?

* Je vis dans l'**instant présent**.
* J'ai conscience d'un **temps fléché**, qui s'écoule *du passé vers le futur*.

![](mechanics-time-now_v2_fr.gif)   
_Ma perception du temps_

#### Comment mesurer l'intervalle de temps entre deux évènements ?

* **intervalle de temps** = **durée**.

* Je perçois des **évènements cycliques** .   
_(rythme des *saisons*, *cycle de la lune*, alernance *jour-nuit*, *mouvement du balancier* d'un pendule,_ 
_*incrémentation des secondes* sur un affichage digital du temps...)._

(figure à créer, gif avec plusieurs exemples de cycle)

* Les *cycles* des différents évènements observés sont **cohérents entre eux**.
(...)

* $`\Longrightarrow`$ pour **mesurer la durée entre deux évènements**, je peux
  *choisir un évènement cyclique comme référence*,   
  et définir comme **unité de temps** la *durée de son cycle*.

* L'**intervalle de temps** entre deux évènements, exprimée *dans l'unité de mesure choisie*, est 
le *nombre de cycle de référence compté entre ces deux évènements*.

(figure à créer: indiquant la façon mesurer des durée et de dater des évènements, avec comme légende
"Mon temps propre").


#### Comment repérer un évènements dans le temps?

* **repérer dans le temps** = **dater**

* Je veux *dater un évènement $`T`$* dans le temps.

* Je peux *choisir un évènement de référence $`T_O`$*,    
   puis *compter le nombre de cycle de référence* entre $`T_O`$ et $`T`$.  

* La **date** de l'évènement $`T`$, exprimée *dans l'unité de temps choisie*, est le
*nombre de cycle de référence entre $`T_O`$ et $`T`$*.


#### Quelle est l'unité de temps dans le système international de mesure?

la seconde, à développer.

Les autres unités usuelles (peut-être seulement dans la partie principale)



#### Que perçois-je de l'espace?

Je perçois dans l'espace des corps immobiles ou en mouvement.


##### Des objets et des êtres plus ou moins loin

> Parler de la notion de distance et de longueur.   
> Figure à faire : par exemple une photo de 3 objets plus ou moins proches, avec focalisations successivement sur les 3 objets.

##### Comment mesurer l'intervalle d'espace entre deux objets immobiles ?

> Idée :   
> - distance entre 2 objets, ou entre les deux extrémités d'un même objet.   
> - mesurer c'est comparer et compter.    
> - nécessité d'un étalon de longueur, qui définit une unité de mesure.    
> - etc...    


##### Quelle est l'unité de longeur dans le système international de mesure?

> - le mètre
> - ses sous et ses sur-multiples


##### Que signifie "l'espace a 3 dimensions" ?

![](time-space-euclidian-geometry-3D-space_serieA_L740_v3.gif)   
_Ma perception de l'espace_

Sur la figure, je suis localisé dans l'espace, et mon regard pointe l'horizon situé devant moi.

* *Je peux me déplacer* :
   * en **avant ou** en **arrière**.
   * à **gauche ou** à **droite**.
   * en **haut ou** en **bas**   
   _(me lever ou m'accroupir, ou sur un escalier ou avec un avion)_

* Et **ces déplacements** peuvent être simultanés, ils **sont indépendants**.   
  _Par exemple :_
   * _je vais me déplacer en avant vers la gauche._
   * _un avion gagne de la hauteur en tournant vers la droite._
   
De la même façon, je peux dire :

> Figure à faire, pour rompre la longueur du texte. Exemple : sur une scène où l'on voit
> un objet, indiquer 3 flèches successives, orientées devant-derrière, gauche-droite, haut-bas,
> qui indique un chemin possible  pour rejopindre l'objet.

* Un *objet extérieur se situe* :
   * **devant ou derrière** moi.
   * à **gauche ou** à **droite**.
   * plus **haut ou** plus **bas**.
   
* Et *localiser* cette objet nécessite de *préciser sa distance dans ces 3 directions*.   
  _Par exemple, sur la figure le sommet de l'arbre le plus proche est situé devant, sur la gauche et plus haut._

J'ai *besoin de définir* **trois directions indépendantes**
   * pour *préciser un déplacement*.
   * pour *localiser* quelque-chose.   
   
**$`\Longrightarrow`$ L'espace possède trois dimensions (3D)**.   
<br>*Trois dimensions* = *trois degrés de liberté*.


##### Comment situer des objets par rapport à moi ?


##### Comment situer des objets par rapport à un repère fixe ?


#### Que pouvons nous convenir ensemble sur le temps et l'espace ?

![](clock-time-numbered_L746.gif)

1. **Je** *perçois l'espace à travers le temps*, et j'y observe des corps immobiles et en mouvement.
2. **Tu** *perçois l'espace à travers le temps*, et tu y observes des corps immobiles et en mouvement.
3. **Tous**, *nous percevons tous l'espace à travers le temps*, et nous y observons des corps 
immobiles et en mouvement.

**$`\quad\Longrightarrow`$ Que pouvons nous convenir ensemble ?**

Dans la **vie quotidienne** :   

* Nous sommes *tous confrontés aux mêmes cycles*.   
_(rythme des *saisons*, *cycle de la lune*, alernance *jour-nuit*, *mouvement du balancier* d'un pendule,_ 
_*incrémentation des secondes* sur un affichage digital du temps...)._

* Nos *montres et horloges indiquent la même heure*, mesures les mêmes durées.

* Lors de nos échanges, nous remarquons que : 
   * *nous mesurons les mêmes durées* entre deux évènements.
   * *deux évènements simultanés pour moi sont simultanés pour tous*.

**$`\quad\Longrightarrow`$ Nous convenons d'un temps universel**   
<br> *universel* = *partagé, commun à tous*
   

* $`\quad\Longrightarrow`$ nous pouvons définir en commun des unités de mesures, nous accorder sur des dates et des durées.    
  

> à continuer, sur l'espace, et l'indépendance entre l'espace et le temps.
    

! *Concernant les angles remarquables*  
!


#### Qu'est-ce qu'un angle ?



#### Comment mesurer un angle quelconque ?

*A l'échelle d'une feuille de papier*

à faire, idées :   
\- $`\equiv`$ échelle de quelques centimètres.   
\- avec un rapporteur
\- unité de degré d'arc.
\- mesure au degré près.   
\- permet de discerner par la mesure 360 angles différents
\- ...

![](protrator-measurement-angle-FR_L600.gif)


*A l'échelle d'un terrain*

à faire, idées :   
\- demander aux collègues ou étudiants en gnéie civil


#### Combien puis-je discerner de valeurs d'angle à l'oeil nu?

à faire, idées :   
\- une douzaine

#### Qu'est-ce qu'un angle remarquable ?

C'est un *angle qui* **peut se tracer sans effectuer de mesure**.   

> à terminer : donc avec quoi?

#### Quels sont les angles réalisables avec uen simple feuille de papier de forme quelconque ? 

> à faire :   
> Par pliage : 360° et 0°, 180° , 90° , 45° , ...   
> figure animés en cours de réalisation.


#### Quels sont les angles réalisables avec un simple élément rigide de longueur quelconque? 

à faire : idées :   
avec compas ou cordelette à l'échelle de la feuille de papier   
avec une corde à l'échelle d'un terrain   
\- 360° et 0°, 180° , 60°   
\- puis multiples 120°,  180°   
\- puis sous-multiples 90° ,   45°  , 30°   
il est toujours possible de diviser un angle par deux.


##### Que représente l'angle de 60° ?

![](angle60construction.gif)   

1. L'angle de *60° divise un disque* en **6 parts d'aires égales**.
  _(exemple : un gâteau en 6 parts égales)_

2. L'angle de *60° divise un plan infini* en **6 parts d'aires (infinies) égales**.   
  _(attention : tout surface plane réelle est limitée et non infinie. Sur la figure_
  _la feuille de papier n'est pas séparée en 6 surfaces d'aires égales.)_


##### Comment construire un angle de 60° ?

![](angles-60-construction_L900.gif)   
_Attention : comprendre visuellement un figure ne suffit pas._   
_Comprendre un concept nécessite de se le réexpliquer après quelques jours et en absence de toute figure._   
_Acquérir une compétence nécessite de réaliser un projet la mettant en oeuvre après quelques jours et en absence de toute figure._

Pour un défi dans la partie "au-delà" :   
* Tracer deux droites d'un plan, séquantes en un point et séparées par un angle de 60° :
   * sur une feuille de papier avec un compas.
   * sur un tableau, avec une ficelle est une craie ou un feutre.
   * sur un terrain, avec une corde et un pieu.
   * sur le sol, simplement avec vos deux pieds.
   * 


##### Que représente l'angle de 30° ?

> à terminer.

1. L'angle de *30° divise un disque* en **12 parts d'aires égales**.
  _(exemple : un gâteau en 12 parts égales)_

2. L'angle de *30° divise un plan infini* en **12 parts d'aires (infinies) égales**.   
  _(attention : tout surface plane réelle est limitée et non infinie. Sur la figure_
  _la feuille de papier n'est pas séparée en 12 surfaces d'aires égales.)_


##### Comment construire un angle de 30° ?

![](angles-30-construction_L900.gif)   
_Attention : comprendre visuellement un figure ne suffit pas._   
_Comprendre un concept nécessite de se le réexpliquer après quelques jours et en absence de toute figure._   
_Acquérir une compétence nécessite de réaliser un projet la mettant en oeuvre après quelques jours et en absence de toute figure._

Pour un défi dans la partie "au-delà" :   
* Tracer deux droites d'un plan, séquantes en un point et séparées par un angle de 30° :
   * sur une feuille de papier avec un compas.
   * sur un tableau, avec une ficelle est une craie ou un feutre.
   * sur un terrain, avec une corde et un pieu.
   * sur le sol, simplement avec vos deux pieds.


<!--------------------------
5.3 - Les angles remarquables     
5.3.1 - L'angle complet : 360°      
5.3.2 - L'angle plat : 180°      
5.3.3 - L'angle droit : 90°      
5.3.4 - L'angle de 45°      
5.3.5 - L'angle de 60°   
5.3.6 - L'angle de 30°   
5.3.7 - Réaliser un angle de valeur donnée.   
----------------->

*Idée pour un  développement dans la partie "au-delà" ?*   
Pourquoi les données cycliques sont souvent divisées en 8 au 12 phases, alors que nos 10 doigts
ont fait que tout calcul numérique se fait en base 10?    
Une idée :    
cycle représenté par un cercle, 360°/10=36° n'est pas un angle remarquable...   
Plus facile de diviser un cacrcle en 8 ou 12 parties égales...


! *Concernant "Des figures et des volumes"*
!

#### ...


#### Qu'est-ce un quadrilatère ?

* **Quatres points quelconques** de l'espace *ne s'inscrivent pas dans un plan* en général . 

* **Quatres points dans un même plan** définissent un *quadrilatère*.   
<br>   
![](geometry-euclidian-quadrilateral-360_1_L1200.jpg)

* *Propriété* : **somme des angles = 360°**.   
<br>  
![](geometry-euclidian-quadrilateral-360_6_L1200.jpg)

#### Que sont les quadrilatères particuliers ?

* **Trapèze** : *quadrilatère à deux côtés parallèles*.

* **Parallélogramme** :   
*quadrilatère dont les côtés sont parallèles deux à deux*.   
&nbsp;&nbsp;&nbsp;&nbsp;ou (équivalent)    
*quadrilatère dont les longueurs de côtés opposés sont égales*.    
<br>   
![](geometry-euclidian-quadrilateral-parallelogram_L1200.jpg)

* **Rectangle** : *quadrilatère avec 4 angles droits*   
<br>   
![](geometry-euclidian-quadrilateral-rectangle_L1200.jpg)

* **Carré** : *quadrilatère avec 4 angles droits et de côtés de longueurs égales*   
<br>   
![](geometry-euclidian-quadrilateral-carre_L1200.jpg)

* **Losange** : *quadrilatère dont tous les côtés sont égaux*.   
<br>   
![](geometry-euclidian-quadrilateral-rhombus_L1200.jpg)


#### Comment définir et calculer l'aire d'un rectangle ?

*Il s'agit d'une* **définition**     
car les aires des autres formes se déduisent de l'aire d'un rectangle.

![](aire-rectangle_L1200.jpg)

* L'**aire $`\mathbf{A}`$ d'un rectangle** *de côtés de longueurs $`a`$ et $`b`$* exprimées 
  dans une même unité de mesure _um_ s'écrit : 
<br>   
**$`\mathbf{A=a\times b}`$** _$`\quad um^2`$_

* **$`\Longrightarrow`$** l'**aire A d'un carré** *de côtés de longueur $`a`$* exprimée dans l'unité de mesure _um_ s'écrit :
<br>   
**$`\mathbf{A=a^2}`$** _$`\quad um^2`$_

#### Comment calculer l'aire d'un parallélogramme ?

*Se déduit de l'aire d'un rectangle.*

![](aire-parallelogramme-2_L1200.gif)

* **aire A d'un parallélogramme** *de côté de longueur $`a`$ et de hauteur $`h`$* exprimés 
  dans une même unité de mesure _um_ s'écrit :   
<br>
**$`\mathbf{A=a\times h}`$** _$`\quad m^2`$_


#### Comment calculer l'aire d'un triangle ?

*Se déduit de l'aire d'un rectangle.*

![](aire-triangle_L1200.gif)

* L'**aire A d'un triangle quelconque** *de base de longueur $`a`$ et de hauteur $`h`$* exprimés 
  dans une même unité de mesure _um_ s'écrit :   
<br>   
* **$`\mathbf{A=\dfrac{a\times h}{2}}`$**  _$`\quad m^2`$_

* L'aire A d'un triangle rectangle :
   * défini par la longueur $`a`$ de sa base et sa hauteur $`h`$ exprimés 
     dans une même unité de mesure _um_ s'écrit comme pour le triangle quelconque :   
   $`\mathbf{A=\dfrac{a\times h}{2}}\quad um^2`$_
   * défini par les longueurs $`a`$ et $`b`$ des côtés adjacent et opposé... (définir avant côtés adjacent, opposé, l'hypothénuse).    
   $`\mathbf{A=\dfrac{a\times b}{2}}\quad um^2`$_    
_dans ce cas, on voit que $`b=h`$_



! *concernant le théorème de Pythagore, le théorème de Thalès, et les liens entre géométrie et règles de calcul numérique*  
!


#### Identité remarquable $`(x+y)^2=x^2+y^2+2xy`$

* Un **carré de côté $`\mathbf{a+b}`$** peut se décomposer en :
  * un *carré de côté $`\mathbf{a}`$*   
  *$`\quad\quad\large + `$*
  * un *carré de côté $`\mathbf{b}`$*   
  *$`\quad\quad\large + `$*
  * *deux rectangles de côtés $`\mathbf{a}`$ et $`\mathbf{b}`$*. 

![](_a-plus-b_2_v2.gif)

* **$`\mathbf{\Longrightarrow}`$ l'aire $`\mathbf{(a+b)^2}`$** du carré de côté $`a+b`$ est égale à :
  * l'*aire $`\mathbf{a^2}`$* du carré de côté $`a`$      
  *$`\quad\quad\large + `$* 
  * l'*aire $`\mathbf{b^2}`$* du carré de côté $`b`$   
  *$`\quad\quad\large + `$*  
  * *l'aire $`\mathbf{2\times ab}`$* des deux rectangles de côtés $`a`$ et $`b`$. 

![](_a-plus-b_2.jpg)



![](geometry-a2plusb2-identity-L1200.gif)

**vue du côté du calcul**    
(affiché ici à la suite, ou un peu mieux construit pour un affichage en mode parallèle?)

Par définition de la fonction puissance 2 : *$`\mathbf{x^2 = x \times x}`$*,

**$`\mathbf{(x+y)^2\;=\; (x+y) \times (x+y)}`$**

Créer une figure animée pour expliquer le passage entre ces 2 égalités,

**$`\mathbf{(x+y)^2= (x\times x) + (x\times y) + (y\times x) + (y\times y)}`$**

L'ordre des termes au sein d'une addition n'importe pas : *$`\mathbf{a+b=b+a}`$* ,

**$`\mathbf{(x+y)^2\;= (x\times x) + (y\times y) + (x\times y) + (y\times x)}`$**

L'ordre des termes au sein d'une multiplication n'importe pas : *$`\mathbf{a\times b=b \times a}`$* ,

donc $`(x\times y) + (y\times x) = (x\times y) +(x\times y) = 2 \times (x\times y)`$

$`\quad = (y\times x) +(y\times x) = 2 \times (y\times x)`$ ,

**$`\mathbf{(x+y)^2= (x\times x) + (x\times x) + 2 \times y\times x}`$**

Simplification d'écriture : *$`\mathbf{x\times y = x\cdot y = xy = yx = y\cdot x = y\times x}`$*,

**$`\mathbf{(x+y)^2=xx+yy+2xy= x^2 + y^2 + 2xy}`$**



#### Qu'est-ce que le théorème de Pythagore ?

##### Est-il important ?

Incorporer la figure chronologie-importance-sciences-&-techniques

##### Comment le démontrer ?

* Il existe de nombreuses démonstrations du théorème de Pythagore

*Une démonstration purement géométrique*

![](pythagore-v2_L1000.gif)

(ce texte sera peut-être à déplacer dans la partie "main", à voir en construisant cette partie "main").

Soient **$`a`$ et $`b`$ deux nombres quelconques**.

1. *Partir d'un* **carré** de longueur **de côté $`a+b`$** :
   * Y *faire apparaître* **deux carrés** :
      * un carré de longueur **de côté $`a`$**.
      * un carré de longueur **de côté $`b`$**.
   * Dans l'espace restant, *faire apparaître* **4 triangles rectangles** semblables :
      * de **côtés adjacent et opposé** de longueurs **$`a`$ et $`b`$**.
      * de longueur d'**hypothénuse** **$`c`$**.

2. *Partir de ce même carré* :
    * *Déplacer les 4 triangles* rectangles précédents, de façon à y *faire apparaitre un* **unique carré** :   
    $`\Longrightarrow`$ la longueur **de côté** de ce carré est égale à **$`c`$**,   
      longueur de l'hypothénuse des 4 triangles.
      

![](geometry-pythagore-2-v2_L1200.jpg)


3. A partir du premier cas, l'**aire $`(a+b)^2`$** du grand carré *est égale à la somme* :
   * de l'**aire $`a^2`$** du premier carré.
   * de l'**aire $`b^2`$** du second carré.
   * et **4 fois l'aire $`ab/2`$** de chaque triangle rectangle.

4. Dans le second cas, l'**aire $`(a+b)^2`$** du grand carré *est égale à la somme* :
   * de l'**aire $`c^2`$** du grand carré.
   * et **4 fois l'aire $`ab/2`$** de chaque triangle rectangle.


![](pythagore-3.gif)
<!--possibilité refaire cette figure encore plus fluide de mouvement,
pour une taille mémoire pas beaucoup plus grande...-->

5. *Par comparaison*, j'obtiens :   
$`\quad a^2+b^2+4\cdot\dfrac{ab}{2}=c^2+4\cdot\dfrac{ab}{2}`$   
*puis en soustrayant $`4\,ab/2`$ de chaque côté* de l'équation   
j'obtiens la *relation fondatrice* du théorème d'Ampère :   
*$`\quad \mathbf{a^2+b^2=c^2}`$*.    
   

##### Comment s'énonce le théorème de Pythagore ?

*Énoncé mathématique*

* **Dans un triangle rectangle**
   * de *côtés adjacent et opposés* de longueurs *$`\mathbf{a}`$ et $`\mathbf{b}`$*,
   * d'*hypothénuse* de longueur *$`\mathbf{c}`$*   
La relation suivante **est toujours vraie** :   
<br>
**$`\quad\large\mathbf{ a^2+b^2=c^2}`$**


*Énoncé avec le langage des mots*

* **"Dans un triangle rectangle, le carré de l'hypothénuse est égal à la somme des carrés des côtés adjacent et opposé."**



#### Théorème de Thalès, et la règle de trois

Figure animée à faire.


---------------

! *Je localise sur le globe terrestre*
!

<!--#### Une belle planète-->

<!--##### Comment repérer un lieu à la surface de la Terre?-->

#### Comment situer ma ville ? un autre lieu ?

<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/earth_find_your_location_ALowB2.mp4" type="video/mp4">
</video>

<!----------------------

[](beautiful-blue-planet.gif)

* Tu repères la forme des continents.
* Tu repères approximativement un lieu en le positionnant entre des points particuliers sur la surface terrestre :<br>
\- la pointe d'un continent.<br>
\- la courbure d'un fleuve.<br>
\- ...<br>

##### Qu'est-ce qu'un repère ?


##### Qu'est-ce que l'axe Sud-Nord ?

* Il passe par les pôles nord et sud géographiques.

* (faire animation ou petite video de 24h de rotation terrestre, avec éclairement solaire, au 21 juin)<br>
Cela montrera que le pôle nord voit toujours le solei,k que le pôle sud reste dans la nuit. Que les durées jours nuits tendent à s'égaliser quand on tend vers l'équateur. Cela fera l'objet d'un défi dans la partie "Beyond" :)

* Dans la partie beyond aussi, montrrer comment on peut repérer les pôles géographiques à partir de la surface terrestre. Nord, étoile polaire à la verticale? et le ciel tourne autour? Le ciel semble tourner autour de la verticale aux pôles.


##### Pourquoi des coordonnées liées à la Terre ?
![](earth-rotation.gif)<br>
_La Terre vue d'un satellite géostationnaire_




Pour essayer video courte

Le niveau 1 sera plus court, on peu mettre de petites vidéos attrayantes.

Il faut faire quelques chapitres, et tester comment cela, passe, 
les remarques d'ado (10-14ans), adultes faiblement scolarisés

Ceci est juste un tout premier jet, il faudra beaucoup tester l'attarctivité là...


#### Une belle planète


#### La Terre tourne sur elle-même autour de son axe sud-nord.

<!---------------------------------------------


La Terre tourne sur elle-même en 24h.
L'axe Sud-Nord est un bon repère.
Le pôle nord et la pôle sudsont des endroits que l'on peut atteindre et repérer.
L'ensemble des lieux à mi distance des deux pôles est l'équateur.

(ce gif est à edécouper et il faut rajouter les références copyright, ....
mais il est presque aussi lourd qu'une vidéo... alors?)

------------------------------------------------

#### La Terre vue d'un satellite géostationnaire

-------------------------------------------------

Pour localiser une ville sur la Terre, il faut un repère fixe par rapport à la Terre.

Et là on repasse à un schéma, ou un schéma animé gif,
pour expliquer latitude, longitude

et les maps internets rajoutent l'altitude

et exemples?

Rendre cela intéressant?
------------------------------------------------->

---------------

! *J'utilise une carte géographique*
!


----------------------------------------

! *Je situe avec une table d'orientation panoramique*
!


#### Qu'est-ce qu'une table d'orientation ?

Idée : dans quelle direction (et sens) à partir d'un point d'observation ?   
$`\Longrightarrow`$ les 4 points cardinaux : est, sud, ouest, nord,   
et les intermédiaires sud-est, sud-ouest, nord-ouest et nord-est.   
$`dans le champ de vue, tout point de la surface terrestre est localisé dans 8 domaines de direction.   

<!--Idée :---------------------
localiser, c'est comparer et encadrer.
------------------------------->

#### Comment puis-je repérer la direction d'un lieu ?

![](viewpoint-indicator-2_v2_L850.gif)    
(figure modifiable, ou qui peut se changer)
_Fig.  : Le lieu indiqué par la flèche violette est situé en direction du sud-ouest._

Idée : comment préciser mieux la direction ?    
\- passage de 8 à 16 domaines de localisation :
sud , sud-sud-ouest, sud-ouest, ouest-sud-ouest, ouest, ouest-nord-ouest, nord-ouest, nord-nord-ouest, nord, etc...    
\- passage de 16 à ... 360 domaines de localisation :   
Trop nombreux, ils ne sont pas nommés, mais ils sont délimités par des nombres entiers allant de 0 à 359 (360 est le retour à 0).   
* système de coordonnées
  *  une origine du système.
  *  le plan horizontal contenant l'origine.
  *  l'axe sud-nord, pointant vers le nord.
  *  la verticale à l'origine, orientée vers le haut.
  *  un sens choisi autour de la verticalde, pour la graduation des angles en degré.
discours à construire...
direction (et sens) d'un lieu est repéré par l'angle $`\varphi`$ entre l'axe Sud-Nord et la direction où il est observé depuis l'origine.   
difficile de déterminer exactement la valeur de l'angle $`\varphi`$, on évalue un encadrement de façon à pouvoir dire avec une grande confiance
que le lieu recherché se situe dans l'encadrement donné de la valeur de $`\varphi`$.


![](viewpoint-indicator-3_v3_L850.gif)
(figure modifiable, ou qui peut se changer)
_Fig.  : Le lieu indiqué par la flèche violette est situé en direction du sud-sud-ouest.   
Le lieu indiqué est caractérisé par l'angle $`\varphi=120 \pm 2°`$_


#### Comment connaître sa distance ?

![](viewpoint-indicator-4_v2_L850.gif)   
Tout peut être amélioré ou changé.


#### Comment indiquer l'altitude d'un sommet montagneux?

![](viewpoint-indicator-5_L850.gif)

-----------------

! *Du globe terretre à une carte du monde*
!
<!--
Là, à faire. Mais pour dire (sans le dire à ce niveau 1) qu'aucune projection de
la surface d'une sphère sur un plan ne peut conserver les angles et les distances...

Pour tester la visibilité des figures avant finition :

Idée de question :"Pourquoi faire une carte de la Terre?"   
Réponse possible : "Pour envelopper d'un seul regard la totalité de la surface terrestre."  
-->

#### Pourquoi faire une carte de la Terre ?

* Pour **envelopper d'un seul regard la surface terrestre** en totalité.

![](earth-map-earth-globe-geometry-1_L1200.gif)

Et *peut-être aussi* pour :

* **comparer les tailles des continents**.
 
* **trouver le chemin le plus court** entre villes éloignés.


#### Comment réaliser une carte de la Terre?"  

Une **première idée** :

![](earth-map-earth-globe-geometry-2_L1000.gif)

* *En tout lieu sur Terre*, le **méridien** (nord-sud) et le **parallèle** (est-ouest) **sont perpendiculaires**
 
* *Sur une feuille de papier*, je trace :
   * *verticalement* **les méridiens**,
   * *horizontalement* **les parallèles**.
    
* **$`\mathbf{\Longrightarrow}`$** Comme sur la surface terrestre,   
*en tout point de la feuille*, le **méridien** (vertical) et le **parallèle** (horizontal) **sont perpendiculaires**.

* *Sur la feuille je reporte* **les couleurs des continents et des océans** en s'aidant des méridiens et parallèles.

J'ai ainsi réalisé une **carte de la surface terrestre**.

<!--
Idée de question :"Comment réaliser une carte de la Terre?"  
Réponse possible :   
Une première idée :  
\- en chaque lieu de la Terre, le méridien et le parallèle qui passe par ce lieu sont orthogonaux".   
donc :   
\- reporter verticalement sur une carte les méridiens, et horizontalement les parallèles.   
\_ en chaque pixel de cette carte, reporter la couleur du pixel correspondant sur le globe terrestre.  
-->

#### Ma carte ainsi réalisée est-elle fiable ?

* **Puis-je y comparer** *des distances ?*, et *des surfaces ?*

##### Non, sur ma carte les distances ne sont pas respectées

![](earth-map-earth-globe-geometry-3_L1000_v2.gif)  

* **Je ne peux pas comparer des distances** avec précision.

* *Par exemple* :
   * L'**équateur terrestre**, *40 000 km* de circonférence,   
   (**E** sur la figure)
   * Le **cercle polaire**, *16 000 km* de circonférence,   
   (**C** sur la figure)
   * Le **pôle sud**, *un simple lieu* sur Terre,  
   (**P** sur la figure)   
   sont *représentés par* des **lignes de longueurs égales** sur la carte.   
   (égales à la largeur de la carte)


##### Non, sur ma carte les chemins les plus courts ne sont pas des segments de droite.

*Qu'est-ce qu'un grand cercle sur une sphère ?*

* Un **grand cercle** sur une sphère est un *cercle dont tout diamètre passe par le centre de la sphère*.
`
* Soit $`\mathscr{S}`$ une sphère de centre $`O`$ :
   * Le **cercle $`\mathscr{C_1}`$** dont un diamètre $`\mathscr{D_1}`$ ne passe par par $`O`$ n'est *pas un grand cercle*.
   * Le **cercle $`\mathscr{C_2}`$** dont un diamètre $`\mathscr{D_2}`$ passe par $`O`$ est un *grand cercle*.

![](grand-cercle-1_L1200.gif)


*Qu'elle est le chemin le plus court sur une sphère entre deux de ses points ?*


* Le **chemin le plus court entre deux points sur la surface d'une sphère** est le *plus petit arc du
grand cercle qui contient ces deux points*.

* Soient deux points $`P`$ et $`Q`$ sur une sphère $`\mathscr{S}`$ de centre $`O`$ :
   * Le **plus petit arc du cercle $`\mathscr{C_0}`$** joignant$`P`$ et $`Q`$ n'est *pas le chemin le plus court*.
   * Le **plus petit arc du cercle $`\mathscr{C_1}`$** joignant$`P`$ et $`Q`$ n'est *pas le chemin le plus court*.
   * Le **plus petit arc du grand cercle $`\mathscr{C_2}`$** joignant$`P`$ et $`Q`$ est le *chemin le plus court*.

![](grand-cercle-2_L1200.gif)


* Un **grand cercle** est l'intersection entre la sphère et un plan passant par son milieu.   
$`\Longrightarrow`$ ce plan *coupe la sphère en deux demi-sphères*.

![](grand-cercle-orange_L1200.jpg)   
_Nous découpons en général une orange selon un grand cercle._


      
*Sur la figure suivante :*

* **A - Sur le globe terrestre** sont représentés les **plus courts chemins entre** :   
   1. chemin *vert* : **Fort-de-France - La Rochelle**.
   2. chemin *bleu* : **Montréal - Oslo**.
   3. chemin *rouge* : **Libreville - Macapá**.

![](earth-map-earth-globe-geometry-trips_v5_L900.gif)

* **B - Sur la carte** obtenue, ces chemins les plus courts **ne sont pas des segments de droites**.

   * **$`\Longrightarrow`$ en général** les **segments de droite** sur la carte ne représentent  **pas les chemins les plus courts** sur la surface terrestre entre ces deux points.
   
   * **Seule exception** :  lorsque les **deux points** sont **situés sur l'équateur terrestre**.    
    _Cas du chemin rouge Libreville - Macapá_   
    En effet l'*équateur terrestre* est le *seul grand cercle du globe* dont la représentation est une *ligne droite sur ma carte*.
        

<!--##### Non, les formes sont déformées et les aires ne peuvent se comparer.

figure à faire   


<!--
\- Je ne peux pas déterminer le chemin le plus court entre deux lieux de la Terre :   
$nbsp;$nbsp;\- à faire, mais la trajectoire la plus courte prise entre deux points de la Terre 
ne correspond pas à un sègment de droite sur la carte.
-->

<!--##### Non, les formes sont déformées et les aires ne peuvent se comparer.

figure à faire   -->


#### Existe-t-il une projection d'une sphère sur un plan qui respecte toutes les distances, aires et angles?

* **Non, une telle projection n'existe pas**.

![](geometry-euclidian-non-euclidian-orange_L1200.gif)
_Il n'existe aucune façon d'aplanir un minimum une peau d'orange sans la déformer, sans la déchirer_   
<!--merci pour l'idée Martin :)-->

*Pourquoi ?*

* C'est un point qui sera développé dans les niveaux supérieurs.   
En quelques mots : la **géométrie à la surface 2D d'une sphère** n'est *pas la géométrie euclidienne de notre espace 3D usuel*.



#### Comment réaliser au mieux la surface terrestre sur une carte?"  

à commenter

![](earth-projection-final-stage_v1_L1000.gif)


#### A quoi correspond un point de la carte ?

à faire. Idées :

* un point sur la surface terrestre

* un axe, partant du centre de la sphère et passant par un point de sa surface.

image à faire.


#### Comment représenter une direction dans l'espace ?


à faire. Idée :

à partir remarque précédente, plaçons-nous au centre d'une sphère imaginaire.   
Regarder dans une direction quelconque fait un point à la surface de la sphère.   
Projetons cette sphère sur un plan. Chaque point de la projection est une direction
spatiale observée depuis le centre de la sphère.  

Par référence au point précédent, quel équateur, quelles pôles choisir pour la sphère imaginaire?   
On introduit le plan galactique. Lien vers la représentation du ciel, et le thème transverse les couleurs de l'univers
et un autre sur la cosmologie.



<!--
Idée : en tout point de la surface terrestre, le méridien et le parallèle qui passent
par ce point sont perpendiculaires (dans le plan tangent en ce point à la "sphère" terrestre,
mais à l'échelle de l'homme, localement le sol au niveau de la mer ou en plaine, est perçu
comme un plan). La direction du méridien est donné par l'axe sud-nord, et la direction du parallèle
est donné par l'axe est-ouest d'une boussole placée à l'horizontale. (Là encore à ce niveau 1, ne parler de la distinction
entre nord géographique et le nord magnétique que dans un apparté "au-delà").
-->

---------------


! *De la plaine horizontale à la sphère terrestre*
!

objectifs :   
(sans le dire comme cela : une sphère est localement assimilable à un plan)
(la Terre est ronde, bien sûr. Comment le prouver? (dans des points "au-delà")


---------------


! *Je fais une course d'orientation*
!


! TEST VIDEO/GIF, EN/HORS CONNEXION
!

##### Le gif tout seul, issu de la vidéo de StD

![](test-meca-1-mp4-gif-steph-durand_v5.gif)  
_Indépendance des mouvements en x et en y._   
_La résistance de l'air est négligeable dans cette expérience._

Un charriot avance à vitesse constante, et un mécanisme dans le charriot projette une balle vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.


##### Ceci est une vidéo associée avec commande html pour la vidéo

1. sans le Gif ni le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
</video>
-->

2. sans le Gif ni le texte associé, mais avec phrase    
Your browser does not support the video tag.

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
Your browser does not support the video tag.
</video>
-->

3. avec le Gif mais sans le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
![](test-meca-1-mp4-gif-steph-durand_v2.gif)
</video>
-->

4. avec le Gif et le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
![](test-meca-1-mp4-gif-steph-durand_v2.gif)   
<br>
Voici un mouvement horizontal à vitesse constante,   
Et voici un mouvement vertical en chute libre, ascendant, puis descendant.   
Et maintenant la combinaison des deux mouvements :   
Pendant que le charriot avance à vitesse constante, la balle est projetée vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.
</video>
-->

##### Ceci est une vidéo associée avec commande markdown

2. sans le Gif ni le texte associé, mais avec phrase    

<!--
![Your browser does not support the video tag.](Méca-1-step-durand_10is.mp)
-->

3. avec le Gif mais sans le texte associé

<!--
![test-meca-1-mp4-gif-steph-durand_v5.gif](Méca-1-step-durand_10is.mp)
-->

4. avec le Gif et le texte associé

<!--
![![](test-meca-1-mp4-gif-steph-durand_v5.gif)   
Voici un mouvement horizontal à vitesse constante,   
Et voici un mouvement vertical en chute libre, ascendant, puis descendant.   
Et maintenant la combinaison des deux mouvements :   
Pendant que le charriot avance à vitesse constante, la balle est projetée vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.](Méca-1-step-durand_10is.mp)
-->



