---
title: 'Beyond-chirality-4'
published: true
routable: true
visible: false
lessons:
    -
        slug: chirality-4
        name: LINÉAIRE-2 : La chiralité
        order: 2
---



A organiser, compléter, améliorer ...

Mettre sous forme de bibliographie par thème?


#### **1. "Searching for Chiral Molecules in Space"**
**Auteurs** : Brett A. McGuire et al.
**Revue** : *Science* (2022)
**Lien** : [DOI:10.1126/science.abo4767](https://doi.org/10.1126/science.abo4767) (version gratuite via [NASA ADS](https://ui.adsabs.harvard.edu/abs/2022Sci...376..745M/abstract))

---

##### **Contexte et objectifs**
- **Problématique** : La vie sur Terre utilise presque exclusivement des acides aminés "gauches" (forme L) et des sucres "droits" (forme D). D’où vient cette asymétrie ? Une piste est de chercher des molécules chirales dans l’espace interstellaire, où des processus physiques pourraient favoriser une forme plutôt que l’autre.
- **Objectif** : Détecter et analyser des molécules chirales dans des nuages moléculaires ou des météorites pour comprendre l’origine de l’homochiralité du vivant.

---

##### **Méthodes utilisées**
1. **Spectroscopie rotationnelle** :
   - Les molécules dans l’espace émettent ou absorbent des ondes radio à des fréquences spécifiques (comme une "empreinte digitale").
   - Les télescopes radio (comme ALMA au Chili) permettent de détecter ces signatures et de distinguer les formes chirales.

2. **Analyse de météorites** :
   - Certaines météorites (comme Murchison) contiennent des acides aminés chiraux. Leur analyse en laboratoire révèle un léger excès de la forme L, similaire à celui observé sur Terre.

3. **Modélisation théorique** :
   - Simulation des conditions spatiales (rayonnement UV, champs magnétiques) pour comprendre comment une forme chirale pourrait être favorisée.

---

##### **Résultats principaux**
1. **Détection de molécules chirales dans l’espace** :
   - L’article rapporte la détection de **propylène oxyde (CH₃CHCH₂O)**, une molécule chirale, dans le nuage moléculaire Sagittarius B2 (près du centre de la Voie lactée).
   - C’est la première molécule chirale détectée dans l’espace interstellaire (2016), confirmée par des observations ultérieures.

2. **Excès de forme L dans les météorites** :
   - Les analyses de la météorite de Murchison montrent un excès de **5 à 10 % de la forme L** pour certains acides aminés (comme l’alanine et la valine).
   - Cet excès est similaire à celui observé dans les organismes terrestres, suggérant un lien entre la chiralité spatiale et terrestre.

3. **Mécanismes possibles d’asymétrie** :
   - **Lumière UV circulairement polarisée** : Dans l’espace, la lumière des étoiles peut être polarisée (tourne dans un sens précis). Des expériences en laboratoire montrent que cette lumière peut détruire préférentiellement une forme chirale, laissant un excès de l’autre.
   - **Champs magnétiques chiraux** : Certains modèles suggèrent que des champs magnétiques asymétriques dans les nuages moléculaires pourraient aussi favoriser une forme.

---

##### **Figures clés (description)**
1. **Spectrum du propylène oxyde** :
   - Un graphique montre les pics d’absorption radio du propylène oxyde dans Sagittarius B2, avec des pics distincts pour chaque forme chirale (comme deux "empreintes" légèrement décalées).

2. **Excès de forme L dans Murchison** :
   - Un tableau ou un graphique compare la proportion de formes L et D pour plusieurs acides aminés dans la météorite, avec un excès systématique de L.

3. **Schéma du mécanisme de polarisation** :
   - Une illustration montre comment la lumière UV polarisée interagit avec les molécules chirales, détruisant préférentiellement une forme.

---

##### **Implications et questions ouvertes**
- **Origine de la vie** : Si la chiralité du vivant vient de l’espace, cela soutient l’hypothèse que les briques de la vie (comme les acides aminés) ont été apportées sur Terre par des météorites ou des comètes.
- **Asymétrie universelle ?** : Est-ce que cette préférence pour la forme L est spécifique à notre système solaire, ou est-elle universelle ? Des observations futures (avec le télescope James Webb) pourraient le dire.
- **Expériences en cours** : Des missions spatiales (comme OSIRIS-REx, qui a rapporté des échantillons de l’astéroïde Bennu) analysent actuellement la chiralité des molécules extraterrestres.

---
##### **Pour le cours : Points à retenir**
- **Détection historique** : Le propylène oxyde est la première molécule chirale détectée dans l’espace.
- **Lien avec la vie** : L’excès de forme L dans les météorites suggère que la chiralité du vivant pourrait venir de l’espace.
- **Mécanismes physiques** : La lumière polarisée et les champs magnétiques pourraient expliquer cette asymétrie.

---
---

#### **2. "Chirality and Dark Energy"**
**Auteur** : Lawrence M. Krauss
**Revue** : *Symmetry* (2020)
**Lien** : [DOI:10.3390/sym12091432](https://doi.org/10.3390/sym12091432) (accès ouvert)

---

##### **Contexte et objectifs**
- **Problématique** : L’énergie noire (responsable de l’accélération de l’expansion de l’univers) reste l’un des plus grands mystères de la cosmologie. Certaines théories suggèrent qu’elle pourrait être liée à des champs quantiques chiraux, qui brisent la symétrie gauche-droite de l’univers.
- **Objectif** : Explorer comment la chiralité des champs quantiques pourrait influencer la dynamique de l’univers, notamment via l’énergie noire.

---
