---
title: 'Symétries, Vecteurs polaires et axiaux'
published: true
routable: true
visible: false
lessons:
    -
        slug: symmetries-polar-and-axial-vectors
        name: PARALLÈLE-3 : Symétries, Vecteurs polaires et axiaux
        order: 1
    -
        slug: symmetry-axial-vectors-magnetic-field-toroidal-coil-3
        name: CONCEPT-3 : Symétries, vecteurs axiaux et bobines toriques
        order: 1
    -
        slug: symmetry-axial-vectors-magnetic-field-solenoid-3
        name: CONCEPT-3 : Symétries, vecteurs axiaux et solénoïdes
        order: 1
    -
        slug: symmetry-axial-vectors-magnetic-field-wire-3
        name: CONCEPT-3 : Symétries, vecteurs axiaux et câbles rectilignes coaxiaux
        order: 1
    -
        slug: symmetry-polar-vectors-electric-field-cylindrical-charge-3
        name: CONCEPT-3 : Symétries, vecteurs polaires et distributions cylindriques de charges
        order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

Stade très très préliminaire. En phase de réflexion.

### Symétrie ou antisymétrie d'un système physique par rapport à un plan

<br>

#### Comment caractériser un système physique ?

* Un observateur peut caractériser un objet par :
   * une **qualité** : propriété *non mesurable* qu'un observateur peut attribuer.   
     _Exemple : la couleur d'un objet._
   * une **grandeur physique** : propriété *mesurable*, qui peut donc être *quantifiée par un ou plusieurs nombres*
     exprimés dans une *unité de mesure*.
     _Exemple : la longueur d'une règle, exprimée en mètre_

<br>

#### Qu'est-ce qu'une grandeur physique scalaire ? vectorielle ?

* grandeur physique **scalaire** : sa *mesure* est un *nombre unique*, réel ou complexe.
* grandeur physique **vectorielle** : sa *mesure* est représentée par un *vecteur*,   
  donc dans l'espace euclidien tridimensionnel de la physique classique par *3 nombres réels ou complexes*
  qui sont les composantes du vecteurs exprimées dans une base vectorielle.

!!    
!! <details markdown=1><summary><strong>Pour aller plus loin :</strong> grandeurs physiques tensorielles</summary>
!!   
!! *Certaines grandeurs physiques* sont **plus complexes qu'un vecteur**.
!! Les décrire et les mesurer nécessitera l'apprentissage du nouveau concept de tenseur.
!!
!! _Par exemple, définir la contrainte en un point d'un solide nécessite de connaître les forces_
!! _qui s'exercent sur les faces d'un volume élémentaire entourant ce point, forces exercées par les_
!! _éléments de volume adjacents. Dans l'espace 3D de la mécanique newtonienne dans lequel un système_
!! _de coordonnées orthogonales est choisi, le volume élémentaire est un parallélépipède rectangle._ 
!! _Connaître l'état de contrainte nécessite alors de connaître les 3 composantes des forces qui_ 
!! _s'exercent sur chacune des 6 faces du volume élémentaire. Il sera montré que seules 9 = 3<sup>2</sup> composantes_
!! _suffiront à décrire la contrainte._
!!
!! Les *tenseurs* permettront de quantifier aussi une *propriété physique* dans un matériau anisotrope,
!! la propriété physique permettant de calculer la réponse d'une matériau (par exemple la déformation)
!! lorsqu'il est soumis à une excitation (par exemple un contrainte). 
!!
!! Les *tenseurs* seront des entités mathématiques obéissant à certaines lois, qui auront, dans
!! un espace tridimensionnel, *3<sup>n</sup> composantes, n* étant un entier appelé *ordre du tenseur*.
!! Ainsi un tenseur 
!! - d'*ordre 0* possède 3<sup>0</sup>= 1 composante, et généralise la notion de *scalaire*.
!! - d'*ordre 1* possède 3<sup>1</sup>= 3 composantes, et généralise la notion de *vecteur*.
!!
!! Au-delà de la physique classique, le *tenseur* sera l'*outil mathématique* pour décrire la réalité
!! dans le cadre de la *relativité générale* d'Einstein, tant pour décrire grandeurs et
!! propriétés physique, que la structure même de l'espace-temps.
!! </details>

<br>

#### Quelle nécessité de définir une convention d'orientation de l'espace ?

* 

Définir une convention d'orientation de l'espace est nécessaire pour établir un cadre
de référence cohérent dans lequel nous pouvons décrire et interpréter les phénomènes physiques.
Voici quelques points pour expliquer cette nécessité :

    Consistance des descriptions physiques : En physique, il est crucial que les
    expériences et les observations puissent être décrites de manière cohérente et partagée. 
    Une convention d'orientation de l'espace fournit une base commune pour décrire 
    la direction des vecteurs, des forces, des champs, etc.

    Facilitation des calculs et des analyses : En choisissant une convention d'orientation, 
    nous simplifions les calculs et les analyses en définissant des règles claires pour la 
    manière dont les grandeurs physiques sont orientées et manipulées. Cela permet 
    une compréhension plus aisée et des calculs plus efficaces.

    Interprétation des résultats expérimentaux : Les résultats expérimentaux doivent être
    interprétés dans un contexte cohérent. En ayant une convention d'orientation bien
    définie, nous pouvons interpréter correctement les données expérimentales et tirer
    des conclusions précises sur les phénomènes étudiés.

    Compatibilité avec les lois fondamentales de la physique : Certaines lois physiques, 
    telles que les lois de conservation, dépendent de la direction des grandeurs physiques.
    Une convention d'orientation de l'espace assure que ces lois sont respectées et que 
    les résultats obtenus sont compatibles avec les principes fondamentaux de la physique.

En résumé, définir une convention d'orientation de l'espace est essentiel pour établir un 
cadre de référence commun, faciliter les calculs et les analyses, 
interpréter les résultats expérimentaux et garantir la cohérence avec les lois fondamentales de la physique.

    Axes de référence : Dans un système de coordonnées cartésiennes à trois dimensions (x, y, z), 
    la convention de la main droite définit les axes de la manière suivante :
        L'axe x pointe vers la droite.
        L'axe y pointe vers le haut.
        L'axe z pointe vers l'avant (ou vers vous).

    Produit vectoriel : En utilisant la règle de la main droite, le produit vectoriel de deux v
    ecteurs est déterminé en alignant les doigts de la main droite selon la direction du premier 
    vecteur et en tournant les doigts vers le deuxième vecteur. Le pouce indique alors 
    la direction du produit vectoriel.

    Coordonnées positives : Dans cette convention, les coordonnées positives sont 
    déterminées par la direction des axes selon lesquels nous mesurons. 
    Par exemple, si nous utilisons la convention de la main droite, 
    les coordonnées positives sont celles qui se déplacent dans le sens 
    de l'axe x vers la droite, de l'axe y vers le haut et de l'axe z vers l'avant.

    Rotation : Lorsque nous effectuons une rotation dans un système de coordonnées 
    utilisant la convention de la main droite, la direction de rotation suit les 
    règles de la main droite. Par exemple, le pouce pointe dans la direction de l'axe de rotation, 
    tandis que les autres doigts montrent la direction positive autour de cet axe.

En utilisant la convention de la main droite, nous pouvons établir un cadre de référence 
cohérent pour décrire les vecteurs, les forces, les champs, etc., dans l'espace tridimensionnel.
Cette convention est largement utilisée en physique et en ingénierie pour sa simplicité
et sa facilité d'utilisation.



<br>


#### Qu'est-ce que la règle de la main droite ?

A faire

![](physics-mechanics-space-orientation-right-hand-rule-direction_L1200_horiz_vert.jpg)

Autre dénomination : règle du tir-bouchon

A expliquer

![](physics-mechanics-space-orientation-right-hand-rule-direction_L1200_axis.jpg)



<br>


#### Quelle différence entre une grandeur physique polaire et axiale ?

##### Grandeur physique polaire, ou vraie

* Une **grandeur physique polaire** ou **vraie** dans sa définition et donc sa mesure *ne nécessite pas de convention d'orientation* de l'espace.  

* Si une **grandeur physique polaire** qui caractérise une propriété d'une entité réelle est
  de type *scalaire*, et que sa *valeur réelle* peut prendre des valeurs positives ou négatives,
  alors le **signe** est une *propriété intrinsèque* de l'entité.

!!!!! *Terminologie* : adjectif *intrinsèque*
!!!!!
!!!!! - qui appartient en propre,<br>
!!!!! - qui est indépendant de facteurs extérieurs
!!!!!
!!!!! _(définition du dictionnaire de "linternaute.fr")_
!!!!!
!!!!! adjectif très utilisé en physique, ainsi que son *opposé : extrinsèque*.

!!! *Un exemple : La charge électrique*.
!!!
!!! * Les *particules élémentaires* (électrons, neutrons, protons, les différents types de quarks) possèdent
!!! *plusieurs propriétés physiques*, comme la *masse*, la *charge électrique*, ...
!!! * La *mesure de la charge* électrique est un *nombre réel* qui peut être *potitif, négatif ou nul*.
!!! * Le *signe* de la charge électrique est une *propriété intrinsèque* du corps portant la charge électrique.   
!!! exemples : 
!!! &nbsp;&nbsp; la charge électrique d'un électron est toujours négative.
!!! &nbsp;&nbsp; la charge électrique d'un proton est toujours positive.
!!!
!!! L'attribution d'une charge négative à l'électron et d'une charge positive au proton résulte
!!! d'un choix historique, une convention initiale historique qui entre dans la définition de l'électron
!!! et du proton.
!!!
!!! Mais le signe ne résulte pas d'une règle d'orientation de l'espace.


* Si la **grandeur physique polaire** est de type *vectorielle*, alors dans un système donné de coordonnées, 
  les *composantes individuelles* du vecteur peuvent être *positives, négatives ou nulles*.   
  <br>
  Mais là encore,
  le **signe** de chaque composante exprime une *propriété intrinsèque* du corps, exprimée dans le système de coordonnées
  choisi.

!!! *Exemples de grandeurs physiques polaires ou vraies*
!!!
!!! * La *température* d'un corps.
!!! * la *longueur* d'une règle.
!!! * le *volume* d'un corps.
!!! * la *charge électrique* d'une particule.
!!! * le *vecteur position* $`\vec{r}=\overrightarrow{OM}`$ _d'un point $`M`$ par rapport
!!!   au point origine $`O`$ d'un repère de l'espace.
!!! * le *vecteur vitesse* $`\vec{v}=\dfrac{d\vec{r}}{dt}`$ d'un point $`M`$.
!!! * le *vecteur accélération* $`\vec{a}=\dfrac{d\vec{v}}{dt}=\dfrac{d^2\vec{r}}{dt^2}`$
!!!  d'un point $`M`$.
!!! * le *vecteur quantité de mouvement* $`\vec{p}=m\,\vec{v}`$ d'un corpuscule au point $`M`$ de masse $`m`$. 
!!! * le *vecteur force* totale $`\vec{F}`$ appliquée à un corpuscule de masse $`m`$ au point $`M`$,
!!!   relié en physique classique
!!!   au vecteur accélération par la seconde loi de Newton $`\vec{F}=\dfrac{d\vec{p}}{dt}`$.
!!! * le *vecteur champ électrique* $`\vec{E}`$ qui exerce une force $`\vec{F}=q\,\vec{E}`$
!!!   sur un corpuscule de charge électrique $`q`$.
!!! * un *vecteur élément de courant* $`I\,\overrightarrow{dl}=\dens_{charge}^{3D}\overrightarrow{v}=\overrightarrow{j}d\tau`$.

  <!--------------------------------------------
  _Exemples de grandeurs physiques polaires ou vraies :_   
  * _La __température__ d'un corps._
  * _la __longueur__ d'une règle._
  * _le __volume__ d'un corps._
  * _la __charge__ électrique d'une particule._
  * _le __vecteur position__ $`\vec{r}=\overrightarrow{OM}`$ _d'un point $`M`$ par rapport_
    _au point origine $`O`$ d'un repère de l'espace._
  * _le __vecteur vitesse__ $`\vec{v}=\dfrac{d\vec{r}}{dt}`$ d'un point $`M`$_.
  * _le __vecteur accélération__ $`\vec{a}=\dfrac{d\vec{v}}{dt}=\dfrac{d^2\vec{r}}{dt^2}`$_
    _d'un point $`M`$._ 
  * _le __vecteur quantité de mouvement__ $`\vec{p}=m\,\vec{v}`$ d'un corpuscule au point $`M`$ de masse $`m`$._ 
  * _le __vecteur force__ totale $`\vec{F}`$ appliquée à un corpuscule de masse $`m`$ au point $`M`$,_
    _relié en physique classique_
    _au vecteur accélération par la seconde loi de Newton $`\vec{F}=\dfrac{d\vec{p}}{dt}`$._
  * _le __vecteur champ électrique__ $`\vec{E}`$ qui exerce une force $`\vec{F}=q\,\vec{E}`$_
    _sur un corpuscule de charge électrique $`q`$._
  * _un_ __vecteur élément de courant__ $`I\,\overrightarrow{dl}=\dens_{charge}^{3D}\overrightarrow{v}=\overrightarrow{j}d\tau`$.
-------------------------------->

##### Grandeur physique axiale, ou pseudo grandeur physique.

* Par opposition au cas précédent, une **grandeur physique axiale** ou **peudo-grandeur physique** 
  dans sa mesure *nécessite une* **convention d'orientation de l'espace**.  

* Si une **grandeur physique axiale** qui caractérise une propriété d'une entité réelle est
  de type *scalaire*, et que sa *valeur réelle* peut prendre des valeurs positives ou négatives,
  alors le **signe** dépend d'une *convention d'orientation de l'espace*.

!!! *Exemples de grandeurs physiques axiales*
!!! 
!!! * le **vecteur champ magnétique** $`\vec{B}`$ qui exerce une force $`\vec{F}=q\,\vec{v}\wedge\vec{B}`$
!!!   sur un corpuscule de charge électrique $`q`$ et de vitesse $`\vec{v}`$.
!!! * le **moment $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)`$ d'une force** $`\vec{F}`$ appliquée en un point $`P`$
!!!   par rapport à un point $`O`$ : $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)=\overrightarrow{OP}\wedge\overrightarrow{F}`$.

<!----------------
!! *Pour aller plus loin* :
!! <details markdown=1><summary>Tenseurs polaires et axiaux.</summary>
!!
!! _niveau supérieur, "montagne"_
!!
!! Les *tenseurs* sont une *généralisation des scalaires et des vecteurs*.
!! Leur étude est nécessaire, car certaines grandeurs et propriétés physiques ont besoin,
!! pour être décrites quantitativement, de plus de composantes que les 3 composantes d'un
!! vecteur exprimé dans une base donnée.</details><br>
!! <br>
--------------->

  <!--------------------------
  _Exemples :_   
  * _le __vecteur champ d'induction magnétique__ $`\vec{B}`$ qui exerce une force $`\vec{F}=q\,\vec{v}\wedge\vec{B}`$_
    _sur un corpuscule de charge électrique $`q`$ et de vitesse $`\vec{v}`$._
  * _le __moment $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)`$ d'une force__ $`\vec{F}`$ appliquée en un point $`P`$_
    _par rapport à un point $`O`$ : $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)=\overrightarrow{OP}\wedge\overrightarrow{F}`$._
 ------------------------------->


<br>


#### Pourquoi distinguer les grandeurs polaires des grandeurs axiales ?

<br>
*De part et d'autre*, ou *sur un plan de symétrie ou d'antisymétrie pour sa cause*, un **effet** a
un *comportement différent* selon sa **nature polaire ou axiale**.

!! *Pour aller plus loin* :  
!! <details markdown=1><summary>Propriétés physiques polaires et axiales, et symétries cristallines.</summary>
!!
!! _niveau supérieur, "montagne"_
!!
!! Une *propriété physique* est ce qui *relie deux grandeurs physiques* caractérisant
!! un corps donné. Pour une grandeur physique *"excitation"* appliquée à un corps, 
!! la propriété physique *"réponse"* du corps à l'excitation dépend de la propriété
!! physique du corps qui relie excitation et réponse.
!!
!! _Par exemple, en tout point $`P`$ d'un corps matériel, un champ électrique_ $`\vec{E}_P`$ _donné appliqué de l'extérieur_ 
!! _en ce point (excitation) induit en ce point un vecteur densité volumique de courant_ $`\vec{j}_P`$ _(réponse)_
!! _naissance en tout point du corps à un vecteur densité volumique de courant, dont l'amplitude dépend du matériau_
!! _à travers sa propriété physique conductivité électrique_ $`\sigma_p`$ _au point_ $`P`$ :<br>
!! $`\vec{j}_P = \sigma_P\;\vec{E}_P`$<br>
!!
!! * Une *propriété physique isotrope* est quantifiée par un *simple nombre réel (tenseur de rang 0)*<br>
!! * Une *propriété physique anisotrope* est quantifiée par un *vecteur (tenseur de rang 1)* ou un
!! *tenseur de rang supérieur à 2*.
!!
!! Dans un cristal, la *nature polaire ou axiale d'une propriété physique* sera *importante*, 
!! pour *déterminer la forme générale du tenseur représentatif* selon les diverses symétries
!! cristallines.
!!
!! La maîtrise des propriétés anisotropes ouvre la porte à des effets physiques insoupçonnés
!! qui sont à la base de nombreux dispotitifs  optiques, optoélectroniques, électromécaniques, etc.</details><br>
!! <br>

<br>


#### Qu'est-ce que le symétrique d'un point par rapport à un plan ?

Un système physique qui admet un plan de symétrie est un système dans lequel 
certaines propriétés ou caractéristiques restent inchangées lorsque nous effectuons
une réflexion par rapport à ce plan. 

Plus précisément, un plan de symétrie est un plan tel que toute opération 
de réflexion par rapport à ce plan laisse le système inchangé.

![](Point-mirror-symmetry_L1200.gif)

Cristaux : Dans la cristallographie, de nombreux cristaux possèdent des plans de symétrie qui préservent la structure cristalline. Par exemple, dans un cristal de sel, un plan de symétrie pourrait diviser le cristal en deux moitiés identiques.

Molécules : Les molécules peuvent également présenter des plans de symétrie. Par exemple, la molécule d'eau (H2O) a un plan de symétrie qui divise la molécule en deux parties symétriques par rapport à l'atome d'oxygène.

Objets géométriques : Certains objets géométriques, tels que les carrés et les rectangles, ont des plans de symétrie qui divisent l'objet en parties symétriques.

Systèmes physiques abstraits : Dans des contextes plus abstraits, tels que la théorie des champs en physique des particules, certains systèmes peuvent admettre des symétries continues qui incluent des plans de symétrie. Par exemple, dans certaines théories de champ, les champs peuvent avoir des configurations qui sont symétriques par rapport à certains plans.


La présence d'un plan de symétrie dans un système physique est souvent utilisée pour simplifier l'analyse et la modélisation de ce système, car elle permet de réduire le nombre de degrés de liberté à considérer. De plus, les plans de symétrie sont souvent associés à des lois de conservation ou à des propriétés remarquables du système.

#### Qu'est ce qu'un système physique qui admet un plan de symétrie ?

Un système physique qui admet un plan d'antisymétrie est un système dans lequel certaines propriétés ou caractéristiques changent de signe (ou de manière opposée) lorsqu'on effectue une réflexion par rapport à ce plan. Contrairement à un plan de symétrie où les propriétés restent inchangées, un plan d'antisymétrie induit des changements opposés dans le système après la réflexion.

<br>


#### Qu'est ce qu'un système physique qui admet un plan d'antisymétrie ?

    Phénomènes électromagnétiques : Dans certaines situations impliquant des champs électriques et magnétiques, un plan d'antisymétrie peut être observé. Par exemple, dans une onde électromagnétique, la direction du champ électrique peut être perpendiculaire à la direction du champ magnétique, et ces deux champs peuvent changer de signe lorsqu'on effectue une réflexion par rapport à un plan spécifique.

    Ondes sonores : Dans certains cas, notamment lors de la propagation des ondes sonores, un plan d'antisymétrie peut être présent. Par exemple, la variation de pression le long d'une onde sonore peut changer de signe lorsqu'on effectue une réflexion par rapport à un plan donné.

    Asymétrie de polarisation : Dans certains matériaux ou systèmes optiques, l'orientation de la polarisation de la lumière peut changer de signe lorsqu'on effectue une réflexion par rapport à un plan de réflexion spécifique. Cette asymétrie de polarisation est un exemple d'antisymétrie optique.

    Effet de chiralité : La chiralité est une propriété géométrique de certains objets qui ne sont pas superposables à leur image miroir. Les systèmes physiques qui présentent des propriétés chiroptiques, telles que les molécules chirales, montrent souvent une forme d'antisymétrie par rapport à un plan de réflexion.

En résumé, un système physique qui admet un plan d'antisymétrie est un système où certaines propriétés changent de signe lorsqu'on effectue une réflexion par rapport à ce plan. Ces plans d'antisymétrie sont importants pour comprendre les asymétries et les propriétés non symétriques observées dans divers phénomènes physiques.

A faire


