---
title: Deux défis sur les systèmes optiques
published: true
routable: true
visible: true
lessons:
    -
        slug: annex-optical-systems
        name: Défis sur les systèmes optiques
        order: 1
---


! *DÉFI  :*<br>
! *"Je regarde une cathédrale à travers une lentille boule. Puis-je prédire mon observation ?"*.<br>
! <br>
! _Aptitude testée : Savoir poser un problème et conduire des calculs_<br>
! <br>
! ![](lensball-brut-820-760.jpg)<br>
! <br>
! *Durée de découverte : 2 heures*<br>
! *Durée de résolution : 30 minutes*
! <details markdown=1>
! <summary>
! Je choisis ce défi.
! </summary>
! La lentille-boule est une sphère de rayon $`R=5 cm`$, réalisée dans un verre
! d'indice de réfraction $`n_{verre}=1.5`$. La cathédrale à une hauteur totale,
! depuis sa base jusqu'au sommets de ses tours, de 90 mètres. Je me tiens à
! 400 mètres de la cathédrale (cette distance est la distance cathédrale-oeil). 
! Je regarde la cathédrale à travers la lentille-boule, située à 20 centimètres
! de mon oeil. Que-suis sensé voir ?
!
! * _La durée de résolution représente le temps qui serait typiquement alloué à la résolution_
! _de ce problème, s'il faisait partie d'un examen d'optique géométrique de_
! _première année universitaire._
!
! * _La durée de découverte est le temps estimé pour préparer ce défi, en absence_
! _d'entraînement. Cette durée est juste une indication. Prends autant de temps que_
! _nécessaire. <br>
!
! Le temps de s'interroger sereinement sur la façon de traiter le problème,_
! _sur la méthode de résolution et sa validité, sur les approximations possibles_ 
! _si elles se justifient, le temps qu'il faut pour vérifier les équations_ 
! _si tu ne les as pas préalablement mémorisées et le temps pour effectuer le calcul, sont importants._
!
! <details markdown=1>
! <summary>
! Prêt pour les questions ?
! </summary>
! <!--question 1-->
! <details markdown=1>
! <summary>
! Quel cadre scientifique choisis-tu pour étudier ce problème ?
! </summary>
! * Toutes les tailles caractéristiques dans ce problème sont beaucoup plus grandes
! que les longueurs d'onde de la lumière visible ($`\lambda\approx 0,5\mu m`$), donc
! je vais étudier ce problème dans le cadre de l'optique géométrique.
!
! * Depuis la lentille-boule, la cathédrale est observée sous un angle apparent de
! $`arctg\left(\dfrac{90}{400}\right)=13°`$.
! Pour cette valeur d'angle, il semble raisonnable d'étudier ce problème dans le sous-cadre
! de l'optique gaussienne, c'est à dire de considérer que les approximations de Gauss
! (ou approximations paraxiales) sont suffisantes pour décrire mes observations.<br>
!
! _En absence de critères plus précis, comme la taille du pixel d'un capteur matriciel photosensible_
! _qui enregistrerait une image réalisée dans son plan, on considère comme ordre de grandeur, que_
! _des angles $`\alpha`$ d'incidence et de réfraction limités à $`10\;(\alpha\le 10°)`$ permettent_
! _d'utiliser sereinement les conditions de Gauss pour réaliser la prévision._
! </details>
! <!--question 2-->
! <details markdown=1>
! <summary>
! Décris le système optique qui modélise la lentille-boule.
! </summary>
!
! * La lentille-boule se modélise comme deux dioptres sphériques partageant
! le même centre de courbure, et de rayons de courbure opposés (en valeurs algébriques).
!
! </details>
! <!--question 3-->
! <details markdown=1>
! <summary>
! Quelle est ta méthode de résolution ?
! </summary>
! <!-----* You don't use general equations 3a and 3b for a thick lens, they are too complicated 
! to remind, and you don't have in m3p2 to "use" but to "build a reasoning". And you don't
! know at this step how to handle with centered optical systems.-->
! * Je calcule l'image de la cathédrale par le premier dioptre sphérique $`DS_1`$ rencontré par la lumière
! lors de sa propagation depuis l'object "cathédrale" vers l'oeil final.<br>
! Cette image devient objet pour le second dioptre sphérique $`DS_2`$ rencontré par la lumière, ce
! qui me permet de calculer la taille, la position et le sens de l'image finale qui sera observée par l'oeil.
!
! * Pour un dioptre sphérique, les équations générales sont :<br><br>
! $`\dfrac{n_{fin}}{\overline{SA}_{ima}}-\dfrac{n_{ini}}{\overline{SA}_{obj}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$ 
! pour la position.<br>
! <br>
! $`\overline{\large{\gamma}}_{trans}=\dfrac{n_{ini}\cdot\overline{SA}_{ima}}{n_{fin}\cdot\overline{SA}_{obj}}`$ 
! pour le grandissement transversal.
!
! </details>
! <!--question 4-->
! <details markdown=1>
! <summary>
! Comment poser les calculs ?
! </summary>
!
! * L'axe optique est la droite qui joint le centre C de la lentille boule à mon oeil
! orientée positivement selon le sens de propagation de la lumière pour cette observation,
! soit de la cathédrale vers l'oeil.
! * Premier dioptre sphérique $`DS1`$ : $`\overline{S_1C_1}=+5\:cm`$, $`n_{ini}=1`$ (air) 
! et $`n_{fin}=1.5`$ (verre).<br>
!  Second dioptre sphérique $`DS2`$ : $`\overline{S_2C_2}=-5\:cm`$, $`n_{ini}=1.5`$ (verre) 
! et $`n_{fin}=1`$ (air)<br>
!  Distance entre les sommets des dioptres $`DS1`$ and $`DS2`$ : $`\overline{S_1S_2}=+10\:cm`$<br>
!  Objet cathédrale $`AB`$ :  $`\overline{AB}=90\;m`$ et $`\overline{S_1A}=-400\;m`$<br>
!  J'appelle $`\overline{A_1B_1}`$ l'image intermédiaire (l'image de l'objet cathédrale
! donnée par $`DS1`$.
!
!  * Les équations spécifiques pour $`DS1`$ sont :<br><br> 
! $`\dfrac{1.5}{\overline{S_1A_1}}-\dfrac{1}{\overline{S_1A}}=\dfrac{0.5}{\overline{S_1C_1}}`$ (équ. DS1a),<br>
! <br>
! et <br>
! $`\overline{\gamma}_{trans}=\dfrac{\overline{S_1A_1}}{1.5\cdot\overline{S_1A}}`$ (équ. DS1b)<br><br>
! Les équations spécifiques pour  $`DS2`$ sont :<br><br> 
! $`\dfrac{1}{\overline{S_2A'}}-\dfrac{1.5}{\overline{S_2A_1}}=-\dfrac{0.5}{\overline{S_2C_2}}`$  (équ. DS2a),<br>
! <br>
! et <br>
! $`\overline{\gamma}_{trans}=\dfrac{1.5\cdot\overline{S_2A'}}{\overline{S_2A_1}}`$ (équ. DS2b)<br><br>
! Le liens entre ces deux équations est :<br>
! $`\overline{S_2A_1}=\overline{S_2S_1}+\overline{S_1A_1}=\overline{S_1A_1}-\overline{S_1S_2}`$.
!
! </details>
! <!--question 5-->
! <details markdown=1>
! <summary>
! Vois-tu une approximation possible qui serait facile à justifier ? 
! </summary>
! * Dans le domaine visible, les valeurs de l'indice de réfraction du matériau transparent 
! sont comprises dans l'intervalle [1 ; 2].
! En conséquence les distances focales objet et images d'une surface réfractive sphérique
! doivent rester du même ordre de grandeur que le rayon de courbure,
! soit quelques centimètres dans ce cas (nous parlons ici en valeur absolue).
!
! * Je peux vérifier ce fait pour $`DS1`$ ($`|S_1C_1|=5\;cm`$) en utilisant l'équation DS2a :<br>
! \- considérant $`\overline{S_1A_1}\longrightarrow\infty`$ pour obtenir la distance focale objet
! $`\overline{S_1F_1}`$}, j'obtiens :<br>
! $`-\dfrac{1}{\overline{S_1F_1}}=\dfrac{0.5}{\overline{S_1C_1}}`$ 
! $`\Longrightarrow=\overline{S_1F_1}=-10\;cm`$<br><br>
! \- considérant $`\overline{S_1A}\longrightarrow\infty`$ pour obtenir la distance focale image 
! $`\overline{S_1F'_1}`$, j'obtiens :<br>
! $`\dfrac{1.5}{\overline{S_1F'_1}}=\dfrac{0.5}{\overline{S_1C_1}}\Longrightarrow\overline{S_1F'_1}=+15\;cm`$
! 
! * La distance entre la cathédrale et la lentille boule  $`|\overline{S_1A}|=90\;m`$ est
! très grande devant la distance focal objet $`|\overline{S_1F_1}|=10\;cm`$. Je peux considérer
! la cathédrale comme un objet "à l'infini" de la lentille-boule, ce qui implique une image
! $`\overline{A_1B_1}`$ de la cathédrale réalisée quasiment dans le plan focal image de $`DS1`$ : 
! $`\overline {S_1A_1}=\overline {S_1F'_1}=+15cm`$.<br>
! Donc je peux utiliser directement l'équation DS2a en considérant que :<br>
! $`\overline{S_2A_1}=\overline{S_2F'_1}=\overline{S_2S_1}+\overline{S_1F'_1}`$ 
! $`=\overline{S_1F'_1}-\overline{S_1S_2}=+15-10=+5\;cm`$..
!
! </details>
! <details markdown=1>
! <summary>
! Où se situe l'image finale, et quelle est sa taille ?
! </summary>
!
! * Pour réaliser les calculs, je dois choisir une unité de mesure adaptée, 
! ici le centimètre et le mètre semblent adaptés. Je choisis d'utiliser le mètre.
! * L'équation DS1a donnes :<br>
! <br>
! $`\dfrac{1.5}{\overline{S_1A_1}}-\dfrac{1}{-400}=\dfrac{0.5}{0.05}`$ $`\Longrightarrow\overline{S_1A_1}=0.15\;m`$<br>
! <br>
! En affichant le résultat avec plus de deux chiffres significatifs, la calculatrice donne $`0.150037`$, ce qui
! est très proche de la valeur $`\overline{S_1F'_1}=+0.15\;m`$. Cela montre que l'approximation
! $`\overline{S_1A_1}=\overline{S_1F'_1}`$ que j'aurais pu faire est pleinement justifiée.
! 
! * L'équation DS2a donne :<br>
! <br>
! $`\dfrac{1}{\overline{S_2A'}}-\dfrac{1.5}{-0.1+0.15}=\dfrac{-0.5}{-0.05}`$ 
! $`\Longrightarrow\overline{S_2A'}=0.025\;m`$
!
! * L'image finale est réelle, et se positionne à 2,5cm de la lentille, entre la lentille-boule et mes yeux.
!
! * La taille d'une image (transversalement à l'axe optique) est donnée par le grandissement 
! transversal $`\overline{\large{\gamma}}_{trans}`$.  Par définition $`\overline{\large{\gamma}}_{trans}`$ est le rapport de la taille
! de l'image finale $`\overline{A'B'}`$ à la taille de l'objet $`\overline{AB}`$, tailles exprimées en notation algébrique.
! En considérant l'image intermédiaire, je peux écrire :<br><br>
!  $`\overline{\large{\gamma}}_{trans}=\dfrac{\overline{A'B'}}{\overline{AB}}`$ 
! $`=\dfrac{\overline{A'B'}}{\overline{A_1B_1}}\times\dfrac{A_1B_1}{\overline{AB}}`$<br><br>
! C'est le produit des deux grandissements transversals de la cathédrale donnés
! par les deux dioptres sphériques constituant la lentille-boule. En effet : <br><br>
! $`\overline{\large{\gamma}}_{trans}`$ dû à $`DS1`$ est <br>
! <br>
! $`\overline{\large{\gamma}}_{trans}=\dfrac{\overline{S_1A_1}}{1.5\cdot\overline{S_1A}}`$
! $`=\dfrac{+0.15}{1.5\times(-400)}=-0.00025`$<br><br>
! $`\overline{\large{\gamma}}_{trans}`$ dû à $`DS2`$ est <br>
! <br>
! $`\overline{\large{\gamma}}_{trans}=\dfrac{1.5\cdot\overline{S_2A'}}{\overline{S_2A_1}}`$ 
! $`=\dfrac{1.5\cdot\overline{S_2A'}}{\overline{S_1A_1}-\overline{S_1S_2}}`$
! $`=\dfrac{1.5\cdot0.025}{+0.15-0.10} =0.75`$<br><br>
! Donc $`\overline{\large{\gamma}}_{trans}`$ réalisé par la lentille-boule est :<br><br>
! $`\overline{\large{\gamma}}_{trans}=-0.00025\times0.75`$ $`=-0.00019\approx-1.9\cdot10^{-4}`$<br><br>
! L'image finale est  $`\dfrac{1}{-1.9\cdot10^{-4}}\approx5300`$ plus petite que l'objet cathédrale.<br><br> 
! $`\overline{\large{\gamma}}_{trans}=\dfrac{\overline{A'B'}}{\overline{AB}}\approx8\cdot10^{-4}`$ 
! $`\Longrightarrow\overline{A'B'}=\overline{AB} \times \overline{\large{\gamma}}_{trans}`$
! $`=1.9\cdot10^{-4} \times 90\;m=-0.017\;m`$<br><br>
! L'image a une hauteur de 1.7 cm et elle est inversée.
!</details>
!
!<!--question 7-->
!<details markdown=1>
!<summary>
! Sous quel angle apparent mon oeil voit-il la cathédrale ?
!</summary>
! * Située à une distance de 400 mètres d'un observateur, la cathédrale de hauteur 90 m est observé sous 
! un angle apparent de $`\underline{\alpha}=arctan\left(\dfrac{90}{400}\right)=0.221\;rad=12.7°`$.<br>
! Pour un calcul strictement exact au regard des données du problème, 
! si le point $`O`$ représente la position de l'oeil sur l'axe optique
! alors la distance cathédrale-oeil à pour valeur <br>
! <br>
! $`\begin{align}\overline{AO} &= \overline{AS_1} + \overline{S_1S_2} + \overline{S_2O} \\
! &= 400 + 0,1 + 0,2 = 400,3\quad(m)\end{align}`$ <br>
! <br>
! et la valeur exacte de l'angla apparent sous lequel l'oeil voit directement l'objet cathédrale est <br>
! <br>
! $`\overline{\alpha}=arctan\left(\dfrac{90}{400,3}\right)=0.221\;rad=12.671 ..°\approx 12.7°`$.<br>
! <br>
! * L'image de la cathédrale est inversée, de taille $`\overline{A'B'}=-1.7\,cm`$, et
! elle est localisée sur l'axe optique par la distance $`\overline{S_2A'}=+ 2,5\,cm`$.
! Si l'oeil est positionné à la distance $`$`\overline{S_2O'}= +20\,cm`$ de la lentille,
! alors la distance oeil-image est :<br>
! <br>
! $`\begin{align}\overline{OA'} &= \overline{OS_2} + \overline{S_2A'} \\
! &= +0,025 - 0,2 = - 0,175\quad(m)\end{align}`$ <br>
! <br>
! L'oeil voit l'image de la cathédrale à travers la lentille-boule sous l'angle apparent <br>
! <br>
! $`\overline{\alpha'}=arctan\left(\dfrac{-1.7}{17.5}\right)=-0.097\;rad=-5.6°`$<br>
! <br>
! * Le grossissement $`\overline{G}`$ de la cathédrale vue à travers la lentille-boule par l'oeil dans sa position est <br> 
! <br>
!  $`\overline{G}=\dfrac{\overline{\alpha'}}{\overline{\alpha}}=\dfrac{-0.097}{0.221}=-0.44`$.<br><br>
!  Le signe de $`\overline{G}`$ indique que la cathédrale apparaît inversée, ses tours en bas.
!
! ![](lentille-boule-orleans-1bis.jpg)<br>
! _Cathedral of Orleans (France) : photo illustrant qualitativement le défi._
! </details>
! </details>
! </details>
! </details>
!

!! *CULTURE SCIENTIFIQUE :*<br>
!! *Lentille gravitationnelle (ou Anneau d'Einstein) due à un trou noir ou une galaxie.*<br>
!!
!! ![](Einstein-ring-free.jpg)
!!
!! <details  markdown=1>
!! <summary>
!! Un trou noir comme une galaxie lointaine donnent une ou des images déformées de galaxies situées derrière eux.
!! De ce fait ils agissent un peu comme une lentille convergente qui réalise une image des objets situés derrière elle.
!! Quelles sont les similarités et les différences entre ces phénomènes observés?
!! </summary>
!! En cours de rédaction. 
!! </details>





  



