---
title: Équations de Maxwell , fondement de l'électromagnétisme
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - les équations de Maxwell
      order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-isotropic-media
       name: PARALLÈLE : Propagation des ondes EM, du vide aux milieux matériels isotropes
       order: 1
    -
        slug: maxwell-equations-in-EM-learning-pattern
        name: SITUATION : Les équations de Maxwell dans l'électromagnétisme
        order: 2

---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Quel fut le travail de Maxwell ?

* *Jusqu'au milieu du XIVème siècle*, **électricité, magnétisme et optique** étaient étudiés dans des *domaines scientifiques distincts*. 

* Cependant l'*observation de phénomènes naturels et d'expériences de laboratoire* montrèrent une
**interaction incomprise entre électricité, magnétisme,** voire **optique**.
    * naturel : la foudre peu charger des objets métalliques, aimante le fer, créé un éclair.
    * expériences :   
      \- un courant dévie l'aiguille d'une boussole.   
      \- le déplacement d'un aimant créé un courant.

* Bon mathématicien, **Maxwell** fait *synthèse des résultats expérimentaux* de son époque
qui se résume en 4 équations, les *équations de Maxwell*.

* Ces 4 équations **unifient électricité, magnétisme et optique** au sein de l'électromagnétisme,   
  et élargissent l'optique à un *monde nouveau : les ondes électromagnétiques*.

![](Maxwell-equation-fr.png)
_Maxwell modifie deux des équations de l'électrostatique et de la magnétostatique en
introduisant des termes de couplage entre E et B,
et révolutionne ainsi la physique._

#### Pourquoi disons-nous "équations" et pas "théorèmes" de Maxwell ?

* Les **4 équations de Maxwell** *ne sont pas démontrées*, donc elles ne constituent pas des théorèmes.
* Elles sont *posées et supposées vraies*, ce **sont des postulats**.

#### Pourquoi ces équations fondent l'électromagnétisme ?

#### Quel est le domaine de validité de ces équations ?

#### Que sont ces 4 équations de Maxwell ?

##### Sous forme locale 
_(fondamental, connaître)_

* Deux **expressions de la divergence** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ *inchangées par rapport au cas stationnaire* (électrostatique et magnétostatique) :

   * **$`\large{\mathbf{div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Gauss*).

   * ** $`\large{\mathbf{div \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-flux*).


* Deux **expressions du rotationnel** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ qui *changent et couplent les champs $`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$* :

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Faraday*).

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Ampère*).

* où :
   * $`\dens=\dens^{3D}`$ est la densité volumique de charge. 
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ est le vecteur densité volumique de courant. 

------------------

* Et ces équations *réécrites avec l'opérateur nabla : $`\mathbf{\nabla}`$ *

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**


------------------


##### Sous forme intégrale
_(savoir redémontrer)_


* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

* **Maxwell-Gauss** :   
     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
\iiint_{\Ltau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\Ltau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Maxwell-flux** :

     
  À tout instant t, et pour tout volume $`\tau`$ :
  
     * $`\forall \overrightarrow{r}, div \overrightarrow{B} = 0`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0 \\
\iiint_{\Ltau} div\;\overrightarrow{B} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Maxwell-Faraday** :

     
  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :

   * $`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}`$
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$  
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
\text{Newton : espace et temps indépendants,} \\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$   
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\begin{array}{l}
  &nbsp; \\
 \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
\end{array}`$**   
<br>   
   *  Cette équation joue un *rôle important pour les phénomènes d'induction*.    
      _La quantité_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$ 
      _d'appelation historique imparfaite "force électromotrice (fem)", homogène à une tension, est à l'origine d'un courant_
      _électrique traversant le contour $`\Gamma`$ si celui-ci représente un circuit conducteur._
     

---------------

* **Maxwell-Ampère** :

  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :
<br>

$`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
  $`\Longrightarrow`$$` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$  
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
\text{Newton : espace et temps indépendants},\\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$$`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$   
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$

**$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
$`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**



#### Pourquoi parlons-nous de champ électromagnétique ?

* Les 2 équations de couplage de $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ impliquent 
que **variables, $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ ne peuvent exister l'un sans l'autre**.

* Le terme *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implique $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* Le terme *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implique $`\overrightarrow{B}\ne \overrightarrow{0}`$*


#### Que disent les équations de Maxwell sur la conservation de la charge ?

* Partons de la combinaison d'opérateurs remarquable, valable pour tout champ vectoriel $`\overrightarrow{U}`$,    
 $`div\,\overrightarrow{rot}\,\overrightarrow{U}=0`$,      
et appliquons là au champ d'induction magnétique  $`\overrightarrow{B}`$ :    
<br>
$`div\,\overrightarrow{rot}\,\overrightarrow{B}=0`$

* Il faut faire apparaître les distributions de charge $`\dens^{3D}`$ et de vecteur  densité de courant volumique $`\overrightarrow{j}^{3D}`$.    
Pour cela nous utilisons la loi de Maxwell-Ampère    
* $`\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$   
<br>
$`div\big(
\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Simplifions en divisant de chaque côté par la constante magnétique $`\mu_0`$ :   
<br>
$`div\,\big(
\;\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Dans le cadre de la physique classique, espace et temps sont indépendants, l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   

$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right) `$    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.
$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}
\left(div\right)`$.   
Nous obtenons :   
<br>
$`div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}
\left(div\,\overrightarrow{E}\right)=0`$

* En utilisant la loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}`$ nous obtenons l'équation de conservation locale de la charge électrique en régime variable (donc toujours vérifiée) :   
<br>
$`div\,\overrightarrow{j} +\dfrac{\partial \dens^{3D}}{\partial t}=0`$

* Nous pouvons intégrer cette égalité locale sur un volume $`\tau`$ quelconque :   
<br>
$`\displaystyle\iiint_{\Ltau} \Big(div\,\overrightarrow{j} +\dfrac{\partial \dens^{3D}}{\partial t}\Big)\,d\tau=0`$

$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{j}\,d\tau+
 \iiint_{\Ltau}\dfrac{\partial \dens^{3D}}{\partial t}\Big)\,t\tau=0`$

Le théorème d'Ostrogradski (= théorème de la divergence) précise que pour tout champ 
$`\overrightarrow{U}`$ vectoriel et pour tout volume $`\tau`$,    
$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{U}\,d\Ltau=\oiint_S \overrightarrow{U}\cdot dS`$,   
$`S`$ étant la surface fermée que délimite le volume $`\tau`$.   
<br>
Appliquons-le au premier terme de notre égalité :   
<br>
$`\displaystyle\oiint_S \overrightarrow{U}\cdot \overrightarrow{dS} + \iiint_{\Ltau}\dfrac{\partial \dens^{3D}}{\partial t}\Big)\,t\tau=0`$.  
<br>
En remarquant de nouveau qu'espace et temps sont indépendants en physique classique, l'ordre de dérivation ou intégration par une variable spatiale et une variable temporelle n'importe pas :    
<br>
$`\displaystyle\oiint_S \overrightarrow{U}\cdot \overrightarrow{dS} +\dfrac{\partial \dens^{3D}}{\partial t} \left(\iiint_{\Ltau}\dens^{3D} \,d\tau\right)=0`$.    
<br>
et en constatant que $`\displaystyle\iiint_{\Ltau}\dens^{3D} \,d\tau`$ est la charge totale $`Q_{int}`$ contenue dans le volume $`\tau`$, nous obtenons la relation intégrale de la loi de conservation de la. charge :   
<br>
$`\displaystyle\oiint_S \overrightarrow{U}\cdot \overrightarrow{dS} +\dfrac{\partial Q_{int}}{\partial t}=0`$.    
<br>
qui s'énonce "Le flux du vecteur densité de courant volumique à travers une surface fermée, et égale à la dérivée temporelle de la charge totale contenue à l'intérieur de cette surface fermée."



#### Le champ électromagnétique peut-il céder ou prendre de l'énergie à la matière ?

Le champ électromagnétique agissant sur les particules chargées (électrons, ions, …) de la
matière (à travers la force de Lorentz) peut lui communiquer de l'énergie.

* Un porteur de charge $`q_1`$ animé de la vitesse $`\overrightarrow{\mathscr{v_1}}`$ dans le référentiel d'observation et qui ressent à son endroit un champ électromagnétique $`\big(\overrightarrow{E}\,,\,(\overrightarrow{B}\big)`$ subit la force de Lorentz $`\overrightarrow{F}_{Lor}`$ :   
<br>
$`\overrightarrow{F}_{Lor}=q_1\,\big(\overrightarrow{E}+\overrightarrow{\mathscr{v_1}}\land\overrightarrow{B}\big)`$ 

* Lors d'un déplacement élémentaire $`d\mathscr{l_1}`$ de la charge, la force de Lorentz produit le travail élémentaire $`d\mathcal{W}`$ :   
<br>
$`d\mathcal{W}=\overrightarrow{F}_{Lor}\cdot d\mathscr{l_1}`$
$`\quad q_1\,\big(\overrightarrow{E}+\overrightarrow{\mathscr{v_1}}\land\overrightarrow{B}\big) \cdot d\mathscr{l}`$
$`\quad q_1\,\big(\overrightarrow{E}) \cdot d\mathscr{l_1}\big)+\big(\overrightarrow{\mathscr{v_1}}\land\overrightarrow{B}\big) \cdot d\mathscr{l_1}\big)`$

* Le vecteur vitesse de définition $`{\mathscr{v_1}=\dfrac{d\mathscr{l_1}}{dt}`$ est toujours parallèle à $`\mathscr{l_1}`$, donc :
   * le produit mixte des trois vecteurs $`{\mathscr{v_1}}\,,\,\overrightarrow{B}\text{ et }d\mathscr{l_1}`$ est nul :   
      $`{\mathscr{v_1}}\land\overrightarrow{B}\big) \cdot d\mathscr{l_1}=0`$
   * $`\Longrightarrow`$ la force magnétique ne travaille pas.
Ainsi le travail élémentaire de la force de Lorentz sur un porteur est celui de sa seule composante électrique :   
<br>
$`d\mathcal{W}_1=\overrightarrow{F}_{Lor}\cdot d\mathscr{l_1}=q_1\,\overrightarrow{E}\cdot d\overrightarrow{\mathscr{l_1}}`$

La puissance $`\mathcal{P_1}`$ reçue par un porteur s'exprime, en remarquant que 
$`{\mathscr{l_1}=\overrightarrow{\mathscr{v_1}}\,dt`$ :
<br>
**$`\mathcal{P}_1=\dfrac{d\mathcal{W}_1}{dt}`$**$`\quad=\dfrac{q_1\,\overrightarrow{E}\cdot d\overrightarrow{\mathscr{l_1}}{dt}`$
$`\quad =\dfrac{q_1\,\overrightarrow{E}\cdot }=\overrightarrow{\mathscr{v_1}}\,dt }{dt}`$
**$`\quad =q_1\,\overrightarrow{E}\cdot }=\overrightarrow{\mathscr{v_1}`$**

Si le milieu contient $`n_1`$ porteurs identiques de charge $`q_1`$ par unité de volume, alors un volume élémentaire $`d\tau`$ contient $`n_1\,\tau`$ porteurs de charge et reçoit du champ la puissance élémentaire :   
<br>
$`d\mathcal{P}=n_1\,d\tau\,\mathcal{P}_1=n_1\, q_1\,\overrightarrow{E}\cdot }=\overrightarrow{\mathscr{v_1}\,d\tau




#### Le champ électromagnétique contient-t-il de l'énergie ?

à faire

#### Pourquoi parlons-nous d'ondes électromagnétiques ?

à faire


#### Qu'est-ce que le vecteur de Poynting ?

à faire

#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?

à faire

#### Le champ électromagnétique peut-il céder ou prendre de l'énergie à la matière ?

à faire

#### Comment émettre une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles


#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles









