---
title: Les ondes
published: false
routable: false
visible: false
lessons:
    -
      slug: waves-2
      name: LINÉAIRE-2 : Les Ondes
      order: 2
    -
      slug: panorama-waves-23
      name: PANORAMA-23 : Les ondes
      order: 1
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Colline

---------------------------

### LES ONDES

### **Les condes**<br>*et les phénomènes ondulatoires*   

<br><br>

RÉSUMÉ
: ---


<!--! sous chapitre # : LES  ONDES  MÉCANIQUES-->
<!--! sous chapitre ## : La nature des ondes mécaniques-->
<br><br>

![](titre-ondes_L1200.jpg)

![](sous-titre-ondes-mecaniques_L1200.jpg)

#### Qu'est-ce qu'une onde mécanique ?

* Dans l'expression **ondes mécaniques**, le terme mécanique fait référence à un *milieu matériel*.

* Un **milieu matériel** est composé de *particules matérielles* (atomes, molécules) qui interagissent entre elles. 
  Ce milieu peut être solide, liquide ou gazeux.

* Un **milieu à l'équilibre** signifie que chaque particule occupe une position d'*équilibre stable* 
  où les *forces* qui s'exercent sur elle *s'annulent*.

* Une **perturbation** se produit lorsqu'une *particule* est *temporairement déplacée* 
  de sa position d'équilibre.

   * **Après la perturbation**, la stabilité de l'équilibre signifie que les forces agissent pour 
     ramener la particule à sa position d'équilibre, créant une *force de rappel*.
   * À cause de son *inertie*, la particule dépasse souvent sa position d'équilibre 
     avant d'être ramenée. Cela crée un **mouvement d'oscillation** qui s'atténue progressivement.

* La **particule déplacée** perturbe l'équilibre des particules voisines, devenant 
  ainsi elle-même une **source de perturbation**. Son *mouvement d'oscillation se transmet* 
  aux particules voisines avec un *léger retard* dû à leur inertie et une *légère atténuation*.

* Ainsi, la **perturbation se propage** :
   * *dans l'espace*, d'une particule à l'autre.
   * *dans le temps*, en raison du retard de mouvement d'une particule à ses voisines.

* Une **onde mécanique** est l'expression qui décrit le phénomène de *propagation 
  d'une perturbation* dans un *milieu matériel*.


#### Pourquoi se limiter d'abord aux ondes mécaniques ?

* Des **phénomènes observés dans ondes mécaniques**, comme la diffraction et les interférences,
 sont **communs à tout type d'ondes** et **propres aux ondes**, y compris celles 
  qui sont moins intuitives comme les ondes électromagnétiques, gravitationnelles, ou de probabilité.

   * Les *ondes électromagnétiques* se propagent dans le vide, sans milieu matériel.
   * Les *ondes gravitationnelles* sont des perturbations de l'espace-temps lui-même.
   * Les *ondes de probabilité* décrivent la propagation de la probabilité de présence 
     d'une particule, matériel comme l'électron ou non matériel comme le photon, dans un état donné.

* Dans un premier temps,   
les **ondes mécanique, plus intuitives**, permettent de *mieux s'approprier les phénomènes ondulatoires* 
(diffraction, interférences).    
Puis,    
**L'observation de ces phénomènes** permet d'*identifier la nature ondulatoire* de l'origine de ces phénomènes.


#### Que transporte une onde mécanique ?

* Une *onde transporte* de l'**énergie** et de la **quantité de mouvement** sur 
  de longues distances, car elle met en mouvement de la matière dans le milieu perturbé.   
_Par exemple, un bouchon flottant sur l'eau se met à osciller verticalement lorsqu'il_
_est atteint par des vaguelettes, même s'il est loin du point d'impact._

* Cependant l'*onde ne transporte* **pas de matière**, car les particules oscillent 
  simplement autour de leur position d'équilibre.   
 _Le bouchon n'est pas transporté par la vague sur de longues distances, il oscille sur place._


#### Quels sont les acteurs d'une onde mécanique ?

* Une onde mécanique implique généralement **trois acteurs** avec des *rôles distincts* : la source, le milieu et le capteur.
   * La **source S** impose la *perturbation* au milieu matériel.
   * Le **milieu matériel** *propage* cette perturbation à une *vitesse dépendant du milieu*, vitesse mesurée par un observateur M immobile dans ce milieu.
   * Le **capteur C** détecte la perturbation.


#### Qu'est-ce qui détermine la vitesse de propagation ?

à faire, dépend du milieu.

Jusqu'à quel niveau de détail aller à ce niveau 2? 



#### Qu'est-ce qu'un milieu homogène et isotrope ?

à faire


<br><br>

![](sous-titre-ondes-electromagnetiques_L1200.jpg)

à faire


<br><br>

![](titres_ondes-ecrire-caracteriser_L1200.jpg)

![](sous-titre-ondes-ecriture-mathematique_L1200.jpg)


#### Comment décrire mathématiquement une perturbation ?

* A l'**échelle atomique**, les particules du milieu matériel sont les atomes. 
  La *taille caractéristique* de cette échelle est l'*angström*, le dixième de nanomètre.  
  Les **atomes sont disjoints**, même s'ils sont liés dans les solides et liquides.   
<br>
La *plupart des observations* se font à une **échelle bien plus grande**.   
_Par exemple, la plus petite taille visible à l'œil nu est d'environ un dixième_
_de millimètre, soit un million de fois plus grande qu'un angström._    
<br>
Ainsi dans la description physique d'une onde, on appelle **"particule de matière"** 
le *plus petit volume observable* à l'échelle considérée. À moins de travailler 
à l'échelle atomique, ces volumes qualifiés d'élémentaires se touchent, et donc
les "particules" sont **jointives**.    
<br>
La *perturbation* est alors décrite par une **fonction mathématique $`\phi`$ continue** 
dans l'espace et le temps :   
<br>
$`\large\phi = \;`$**$`\large\boldsymbol{\mathbf{\phi\,(\,\alpha,\,\beta,\,\gamma,\,t\,)}}`$**   
<br>
&nbsp;&nbsp;&nbsp;&nbsp;où les coordonnées spatiales $`(\alpha,\beta,\gamma)`$ sont des nombres réels.

!!!! *Attention :* Les *coordonnées spatiales* indiquent la *position d'équilibre* de la particule,    
!!!! et non sa position perturbée par l'onde au cours du temps.


#### Peut-on simplifier cette description mathématique?

* L'**univers** présente **trois dimensions spatiales**. Dans un système de coordonnées spatiales,
  tout point peut être précisé par la donnée de trois nombres réels $`(\alpha,\beta,\gamma)`$.

* Une **onde matérielle** se propage nécessairement dans un *volume limité*, et présente une certaine *forme*.


##### Onde unidimensionnelle

* L'**onde unidimensionnelle** est une *idéalisation*.

<br>
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/wave-square_L1000.gif)   
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/wavepacket_non-dispersive-v2_L1000.gif)   
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/1D-corde-vibrante-f1-harm24_v2_L1000.gif)   
_figures a, b, c : Exemples d'onde unidimensionnelle._


* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **ligne** dont la section droite est invisible.   
  <br>
  Dans ce cas, les deux dimensions spatiale de la section peuvent être négligées. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point sur la ligne avec **seulement une coordonnée**. La fonction prend alors la forme :   
  <br>
  $`\large\phi = \;`$**$`\large\boldsymbol{\mathbf{\phi\,(\,\alpha,\,t\,)}}`$**

<br>
##### Onde bidimensionnelle

* L'**onde bidimensionnelle** est une *idéalisation*.

<br>
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/different-waves-2.gif)   
_figures d, e, f, g : exemples d'onde bidimensionnelle._


* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **surface** dont l'épaisseur est invisible.   
  <br>
  Dans ce cas, la dimension spatiale de l'épaisseur peut être négligée. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point de la surface avec **seulement deux coordonnées**. La fonction prend alors la forme :   
  <br>
  $`\large\phi = \;`$**$`\large\boldsymbol{\mathbf{\phi\,(\,\alpha,\,\beta,\,t\,)}}`$**

<br>

#### Comment décrire physiquement une perturbation ?

##### Perturbation mécanique

* La *perturbation* d'une onde mécanique correspond, en chaque point de l'espace, 
  à un **déplacement** de matière par rapport à sa position d'équilibre. Ce déplacement 
  peut être décrit par :
   * une *fonction scalaire $`\phi`$* qui donne une distance ou **longueur**.
   * une *fonction vectorielle $`\vec{\phi}`$* qui donne un vecteur avec une **norme** 
     représentant la **longueur** et une **direction** indiquant le sens du déplacement.

* L'aspect oscillatoire du déplacement par rapport à l'équilibre peut entraîner des 
  variations de **densité volumique** dans le milieu de propagation _(comme pour le son dans l'air)_.
  Dans ce cas :
    *la fonction $`\phi`$* est scalaire et représente une **densité volumique**.

* D'*autres grandeurs physiques* peuvent être utilisées si elles permettent la *mesure de l'onde*.


##### Perturbation électromagnétique

à faire

décrire,  
montrer les deux figures classiques d'une onde électromag   
une moparisation recatiligne, l'autre élliptique.
oeil non sensible à polarisation
technique ou i,tervient polarisation (ciné 3D)

figures en attente

![](linear-electromag-wave-n3_L1200.gif)   

![](elliptic-wave-electromag-wave-n3_L1200.gif)  



#### Comment décrire mathématiquement la propagation ?

 A faire, couplage spécifique des coordonnées d'espace et de temps.
 
 <br><br>
 
 ![](sous-titre-ondes-caracterisation_L1200.jpg)
 
 
#### Quelle différence entre onde et signal ?

* une **onde** est un *phénomène naturel* de *propagation dans l'espace et le temps*.

* un **signal** est une *codage temporel intentionnelle d'information*, qui *utilise une onde pour se transmettre* d'un point à un autre de l'espace.

!! <details markdown=1>
!! <summary>Pour aller plus loin : signal analogique ou numérique</summary>
!!
!! * Un *signal* est *analogique* si il est *mesurable à tout instant* et peut prendre 
!! comme *valeur tout nombre réel*.<br>
!!
!! * Un *signal* est *numérique* est un signal *discontinu* (discret) qui ne peut prendre 
!! qu'un *nombre fini de valeurs*, par exemple soit 0 soit 1 pour un signal binaire.
!! </details markdown=1>

<!--Texte ci-dessus pas convainquant. A retravailler...
!! Cette définition intuitive est toutefois incomplète. <br>
!! Mathématiquement, la fonction représentative est une *fonction dérivable* (et donc continue) 
!! définie de $`mathbb{R}`$ (représentant le temps) dans $`mathbb{R}`$ (représentant la 
!! grandeur physique codant l'information).

!! Cette définition intuitive est toutefois incomplète. <br>
!! Mathématiquement, la fonction représentative est une *fonction non dérivable* à valeurs 
!! discontinues (discrètes).
-------------->

------------

<br>

#### Qu'est-ce qu'une onde périodique?

* Le **milieu** considéré est en général *homogène et isotrope*.

* Une **onde périodique** est la décomposition de l'onde en un *plus petit motif qui se répète* de façon jointive.


##### Point de vue de la source ou d'un capteur.

* La *source* ou le *capteur* d'une onde est *localisé* en un point donné de l'espace, l'**onde** est représentée alors par une simple **fonction dépendant du temps : $`\Phi(t)`$*.

* On parle alors de la *périodicité temporelle*.

* Le plus petit **motif** est une *perturbation temporelle de forme donnée* définie sur un *intervalle de temps limité*.
   * L'intervalle de temps est appelée **période temporelle** de l'onde détectée, et se note en générale **$`T`$**.
   * La forme du motif est représentée par une fonction $`g_0(t)`$ définie sur $`T`$.

* L'onde détectée périodique est reconstruite en reproduisant le motif $`g_0(t)`$ à intervalles de temps réguliers $`\Delta t`$ égaux à la période temporelle : $`\Delta t = T`$.

_figure ou animation à faire_


##### Point de vue du milieu matériel

* A tout instant $`t`$, la perturbation du milieu est représentée uniquement par **fonction dépendant de coordonnées spatiales : $`\Phi(\alpha,\beta,\gamma)`$**.

* On parle alors de la **périodicité spatiale**.

* Le plus petit **motif** est une *perturbation spatiale de forme donnée* définie sur dans un *espace limité*.

* L'espace ayant trois dimensions, définir une périodicité spatiale nécessite de préciser un peu la forme spatiale de l'onde. *Deux formes simples d'onde* se distinguent, l'*onde plane* et l'*onde
sphérique* (3D) ou circulaire (2D).

   ##### *L'onde plane*

à faire


   ##### *L'onde sphérique (3D) ou circulaire (2D)*

à faire


##### Relation entre les deux points de vue.

à faire

Idée : de l'onde sphérique d'une source ponctuelle à l'onde plane observée à grande distance.

------------

<br>

#### Qu'est-ce qu'une onde harmonique ?

 A faire
 
 <br>

##### Quel est l'intérêt des ondes harmoniques ?

 A faire
 
 <br>

##### Comment caractériser une onde harmonique ?

 A faire
 
------------

<br>

#### Qu'est-ce que le principe de superposition des ondes ?


 A faire
 
 <br><br>
 
 
![](sous-titre-ondes-stationnaires_L1200.jpg)

------------

<br>

#### Qu'est-ce qu'une onde stationnaire ?

 A faire
 
 <br>


##### Quelle différence entre onde progressive et onde stationnaire ?


 A faire
 
 
##### Où trouve-t-on des ondes stionnaires ?

A faire. Idées : instruments de musique. Cordes, et analogie avec tuyaux
 
 <br><br>
 
![](titre-ondes-copuscules-phenomenes-analogues_L1200.jpg)


#### Quelles sont les phénomènes analogues aux ondes et aux corpuscules ?

* Il existe des **analogies** entre certains *phénomènes ondulatoires* et certains *faits corpusculaires*.

* Lorsque *une onde* rencontre une *interface* (surface de séparation entre deux milieux différents)
  *"suffisamment grande et lisse"* :

   * Le phénomène de **réflexion** de l'onde **à l'interface** évoque le *rebond* d'une *balle sur un mur*.
     
   * De façon plus abstraite, le phénomène de **réfraction** de l'onde **à travers l'interface**,
     peut être comparé à la *trajectoire toujours réalisée par un corpuscule*, trajectoire qui optimise une
     grandeur physique appelée action.   
     !! <details markdown=1><summary>Pour aller plus loin : vers Fermat et Lagrange</summary>
     !! 
     !! Cette analogie est directement utilisée pour expliquer le phénomène de réfraction en
     !! optique géométrique. L'optique géométrique utilise la notion de rayon lumineux et fait
     !! totalement abstraction de la notion d'ondes lumineuses.   
     !! La démonstration de la 
     !! *loi de la réfraction* sera expliqué en terme de *principe de Fermat*, appliqué à calculer
     !! la *trajectoire optimum de deux corpsucules* dans l'exercice de Maria et Simon. 
     !! Le terme optimum sera précisé.
     !! 
     !! Au-delà, au niveau montagne, ce lien sera précisé avec la vision de Lagrange sur la mécanique
     !! classique.
     !!
     !! La vision de Hamilton de la mécanique classique donnera un lien direct vers
     !! la mécanique quantique.
     !! </details>

* L'**effet Doppler** classique exprime aussi bien le *décalage entre fréquence* d'une onde périodique
mesurée au niveau de sa source et d'un capteur, et la *différence de durée* perçue par un observateur 
entre deux événements éloignés dans l'espace et le temps.

!!!!! <details markdown=1><summary>Terminologie : Interface versus surface</summary>
!!!!!
!!!!! * Pour un humain, le terme *surface* désigne la *partie visible et accessible* d'un objet.<br>
!!!!! _C'est par exemple la partie de la table qui est_
!!!!! _au contact direct de l'air et que l'on peut toucher ou observer._
!!!!! <br>
!!!!! Si le terme "sous-face" était employé, il désignerait la partie cachée ou située de l'autre côté de
!!!!! cette surface, que l'humain ne peut ni voir ni toucher.   
!!!!! <br>
!!!!! L'emploi du terme "surface" implique le choix d'un côté d'observation.
!!!!!
!!!!! * Le terme *interface* définit la *frontière entre deux milieux différents*,<br>
!!!!! _par exemple le bois de la table et l'air_,<br>
!!!!! *sans faire référence à un côté où se situerait un observateur. 
!!!!! <br>
!!!!! Le terme interface est à privilégier lorsqu'un phénomène est décrit de façon indépendante
!!!!! d'un humain qui serait observateur.<br>
!!!!! _Par exemple la lumière peut passer indifféremment de l'air à l'eau,_
!!!!! _comme de l'eau à l'air._
!!!!! </details>

! *Note* <br>
!
! La *source de ces analogies* est la *dualité onde-corpuscule*, réalité ultime
! et cachée à nos yeux.   
! Cette réalité cachée est révélée par quelques expériences simples et accessibles
! comme l'expérience des fentes d'Young. Elle est totalement observée dans nos
! laboratoires, et intervient fondamentalement dans beaucoup de nos technologies.
!
! La *dualité onde-corpuscule* est maîtrisée dans le cadre de la *mécanique quantique*.

<br>

![](sous-titre-effet-doppler_L1200.jpg)

#### Qu'est-ce que l'éffet Doppler ?

* L'*effet Doppler* décrit exprime le **décalage du durée** entre deux impulsions,
  mesuré **au niveau de la source et du capteur**.

* L'étude se limite au cas où *source et capteur* se déplacent sur une **même droite**,
  chacun à **vitesse constante**.

<!--
* Sur cette droite, le **détecteur** reste *toujours du même côté* de la source.
-->


#### L'effet Doppler classique, pour les ondes mécaniques


* La vitesse de *propagation des ondes mécaniques* est toujouts *très inférieure à $`c`$* la
  vitesse de la lumière dans le vide :   
  <br>
  **$`\large\mathbf{\boldsymbol{\mathscr{v}_{propag}\ll c}}`$**   
  <br>
  L'effet peut donc s'étudier dans le cadre de la physique classique, où *temps et espace*
  sont indépendants et **universels**.   
  <br>
  Ainsi l'effet Doppler peut s'étudier à l'aide d'un graphique 2D classique, où :
  * l'**axe vertical** représente le **temps**
  * l'**axe horizontal**représente l'**espace**, soit la droite dans laquelle s'inscrivent
  les déplacements de la source comme du capteur.

* Il faut tenir compte de quatre instants :
    * **$`\mathbf{t_1}`$** l'instant où une *source émet* une *première impulsion*.
    * **$`\mathbf{t_1}'`$** l'instant où un *capteur détecte* cette *première impulsion*.
    * **$`\mathbf{t_2}`$**  l'instant où la *source émet* une *deuxième impulsion*.
    * **$`\mathbf{t_2}'`$** l'instant où le *capteur détecte* cette *deuxième impulsion*.   
   
   de trois vitesses, exprimées *par rapport au milieu matériel* :
    * **$`\mathbf{\mathscr{v}_{prop}}`$** la *vitesse de propagation des impulsions*.
    * **$`\mathbf{\mathscr{v}_{source}}`$** la *vitesse de la source*.
    * **$`\mathbf{\mathscr{v}_{capteur}}`$** la *vitesse du capteur*.
    
*  **Trois cas** se distinguent :
   * $`\mathbf{\mathscr{v}_{capteur}\lt\mathscr{v}_{prop}}`$ : cas le plus courant correspondant
     au *régime subsonique*.
   * $`\mathbf{\mathscr{v}_{capteur}=\mathscr{v}_{prop}}`$ : cas limite du *mur du son*
   * $`\mathbf{\mathscr{v}_{capteur}=\mathscr{v}_{prop}}`$ : c'est le *régime hypersonnique*.


##### 1 - Cas où $`\mathbf{\mathscr{v}_{capteur} \lt \mathscr{v}_{propag}}`$

* C'est le cas où l'**onde émise** par la source *atteint toujours le capteur*.   
<br>
Ceci implique donc que la **vitesse du capteur** est *inférieure 
à la vitesse de propagation* de l'onde, caractéristique du régime subsonnique.

   * La *source émet* la **première impulsion à l'instant $`\mathbf{t_1}`$**.   

   * Le *capteur détecte* cette **première impulsion à l'instant $`\mathbf{t_1}'`$**, alors qu'il 
  est situé à la *distance $`\mathbf{d_{impuls.1}}`$  de la source* au moment de l'émission 
  la première impulsion.  
<br>
$`\mathbf{d_{impuls.1}}`$ est donc la distance parcourue par l'impulsion entre son instant 
$`\mathbf{t_1}`$ d'émission et l'instant $`\mathbf{t_1}'`$ où elle est détectée.    
<br>
Se propageant entre ces deux instants dans le milieu matériel à la vitesse $`\mathscr{v}_{prop}`$,
tu as la première relation :   
<br>
*$`\mathbf{d_{impuls.1} = \mathscr{v}_{prop}\times (t_1' - t_1)}`$*   

   * La *source émet* une **seconde impulsion à l'instant $`\mathbf{t_2}`$**.   
<br>
Figure ou animation à faire.  
<br>

   * Le *capteur détecte* cette **seconde impulsion à l'instant $`\mathbf{t_2}'`$**, alors qu'il
est situé à la *distance $`d_{impuls.2}`$ de la source* au moment où elle émet la seconde impulsion.   
<br>
$`\mathbf{d_{impuls.2}}`$ est donc la distance parcourue par la deuxième impulsion entre son instant $`\mathbf{t_2}`$
d'émission et l'instant $`\mathbf{t_2'}`$ où elle est détectée. L'impulsion se propageant dans le milieu
matériel à la vitesse $`\mathscr{v}_{prop}`$, tu as une deuxième relation :   
<br>
*$`\mathbf{d_{impuls.2} = \mathscr{v}_{prop}\times (t_2' - t_2)}`$*.   

* Avant une synthèse finale, **plusieurs cas** sont à étudier selon les mouvements de la source et du capteur, 
  donnant des *expressions différentes de l'effet Doppler* :

<br>

----------------

   * **Source et capteurs s'éloignent**, et se dirigent en *sens inverse*

![](doppler-1-n2_L1200.png)
<br>

* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *ajouter la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *ajouter la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, + d_{source} + d_{capteur}}`$*   
<br>
$`\color{blue}{\scriptsize{soit}}`$   
<br>
$`\begin{align}
\underbrace{\mathscr{v}_{propag.}\cdot (t_2' - t_2)}_{\color{blue}{d_{impuls.2}}}&=
\underbrace{\mathscr{v}_{propag.}\cdot (t_1' - t_1)}_{\color{blue}{d_{impuls.1}}}\\
& \hspace{1cm} + \underbrace{\mathscr{v}_{source}\cdot (t_2 - t_1)}_{\color{blue}{d_{source}}}\\
& \hspace{2cm} +\underbrace{\mathscr{v}_{capteur}\cdot (t_2' - t_1')}_{\color{blue}{d_{capteur}}}
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{si cette étape t'est nécessaire, simplifie la manipulation
à venir }}}`$   
$`\color{blue}{\scriptsize{\text{en évitant les produits de somme :}}}`$  
<br>
$`\begin{align}
\mathscr{v}_{propag.}\,t_2' - \mathscr{v}_{propag.}\,t_2 &= \mathscr{v}_{propag.}\,t_1' -  \mathscr{v}_{propag.}\,t_1\\
& \hspace{0.6cm} + \mathscr{v}_{source}\,t_2 - \mathscr{v}_{source}\,t_1\\
& \hspace{0.6cm} +\mathscr{v}_{capteur}\,t_2' - \mathscr{v}_{capteur}\,t_1'
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{Sépare d'un côté de l'équation les instants en ' propres
}}}`$  
$`\color{blue}{\scriptsize{\text{  à la réception,et de l'autre les instants propres à l'émission :
}}}`$  
<br>
$`\begin{align}
&\mathscr{v}_{propag.}\,t_2' - \mathscr{v}_{propag.}\,t_1' - \mathscr{v}_{capteur}\,t_2'+ \mathscr{v}_{capteur}\,t_1'\\
& \hspace{0.2cm} =  \mathscr{v}_{propag.}\,t_2 -  \mathscr{v}_{propag.}\,t_1 + \mathscr{v}_{source}\,t_2 - \mathscr{v}_{source}\,t_1 
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{et simplifie l'expression en factorisant :}}}`$   
<br>
$`\begin{align}
&\mathscr{v}_{propag.}\,(t_2' - t_1') - \mathscr{v}_{capteur}\,(t_2' - t_1') \\
&\hspace{1cm} = \mathscr{v}_{propag.}\,(t_2 - t_1) + \mathscr{v}_{source}\,(t_2 - t_1)
\end{align}`$   
<br><br>
$`\begin{align}
& (t_2' - t_1')\; (\mathscr{v}_{propag.} - \mathscr{v}_{capteur})\\
&\hspace{1cm} = (t_2 - t_1)\;(\mathscr{v}_{propag.}+ \mathscr{v}_{source})
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{Au final, tu obtiens :}}}`$   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}+ \mathscr{v}_{source}}
{\mathscr{v}_{propag.} - \mathscr{v}_{capteur}}}}`$

<br>

-----------------

   * **Source et capteurs se rapprochent**, se dirigeant en *sens inverse*

![](doppler-2-n2_L1200.png)

<br>
* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *soustraire la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *soustraire la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, - d_{source} - d_{capteur}}`$*  
<br>

* Un **calcul** *analogue au précédent* te conduit à :   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}- \mathscr{v}_{source}}
{\mathscr{v}_{propag.} + \mathscr{v}_{capteur}}}}`$


<br>

-----------------

   * **Source et capteurs se rapprochent**, se dirigeant tous deux dans le *sens 
     de propagation* de l'onde qui les relie

![](doppler-3-n2_L1200.png)   
<br>
* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *soustraire la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *ajouter la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, - d_{source} + d_{capteur}}`$*  
<br>

* Un **calcul** *analogue au précédent* te conduit à :   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}- \mathscr{v}_{source}}
{\mathscr{v}_{propag.} - \mathscr{v}_{capteur}}}}`$

<br>

-----------------

   * **Source et capteurs se rapprochent**, se dirigeant tous deux dans le *sens 
     contraire à la propagation* de l'onde qui les relie

![](doppler-4-n2_L1200.png)   
<br>
* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *ajouter la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *soustraire la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, + d_{source} - d_{capteur}}`$*  
<br>

* Un **calcul** *analogue au précédent* te conduit à :   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.} + \mathscr{v}_{source}}
{\mathscr{v}_{propag.} + \mathscr{v}_{capteur}}}}`$

<br>

-----------------

* **Synthèse des différents cas**

<br>
**$`\large\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.} \pm \mathscr{v}_{source}}
{\mathscr{v}_{propag.} \pm \mathscr{v}_{capteur}}}}`$**   
<br>
avec :

   * **$`\large{+}\,\mathscr{v}_{source}`$** si la *source* va dans le *sens inverse de propagation*.
   * **$`\large{-}\,\mathscr{v}_{source}`$** si la *source* va dans le *sens de la propagation*.
   * **$`\large{+}\,\mathscr{v}_{capteur}`$** si le *capteur* va dans le *sens inverse de propagation*.
   * **$`\large{-}\,\mathscr{v}_{capteur}`$** si le *capteur* va dans le *sens de la propagation*.
<br><br>

!! *Pour aller plus loin : La notation algébrique*
!!
!! à faire


*Effet Doppler classique et ondes périodiques*

* Ces **deux impulsions** représentent un même *trait caractéristique du motif 
temporel* d'une onde périodique, considérées *sur deux motifs consécutifs*.   
La durée entre ces deux impulsions représente alors la **période temporelle $`T`$ ** de l'onde :   
<br><br>
$`\boldsymbol{\mathbf{(T_{capteur})= (T_{source})\cdot \dfrac{\mathscr{v}_{propag.} \pm \mathscr{v}_{source}}
{\mathscr{v}_{propag.} \pm \mathscr{v}_{capteur}}}}`$ 
<br><br>


* S'adressant à des ondes périodiques, l'**effet Doppler** s'exprime le plus souvent
en *fonction de la fréquence $`\nu`$* de l'onde :   
<br>
$`\big(T_{capteur}\big)^{-1}= 
\underbrace{
\Big(T_{source}\cdot\dfrac{\mathscr{v}_{propag.}\pm \mathscr{v}_{source}}{v_{propag.} 
\pm \mathscr{v}_{capteur}}\Big)^{-1}
}_{
\color{blue}{(xy)^m = x^m\,y^m}
}`$   
<br><br>
$`\underbrace{\big(T_{capteur}\big)^{-1}}_{
\color{blue}{\nu = 1\,/\,T}}
= \underbrace{\big(T_{source}\big)^{-1}}_{
\color{blue}{\nu = 1\,/\,T}}
\cdot \left(\dfrac{\mathscr{v}_{propag.}
\pm \mathscr{v}_{source}}{\mathscr{v}_{propag.} \pm \mathscr{v}_{capteur}}\right)^{-1}`$   
<br>
<br>
**$`\large\boldsymbol{\mathbf{\boldsymbol{\nu_{capteur}= \nu_{source}\cdot \dfrac{\mathscr{v}_{propag.}
\pm \mathscr{v}_{capteur}}{\mathscr{v}_{propag.} \pm \mathscr{v}_{source}}}}}`$**

<br>
*Effet Doppler classique et ondes non-périodiques*

à faire.

<br>
*Effet Doppler classique et évènements indépendants*

à faire

! *Note :*
! 
! Cet effet Doppler entre deux évènements distincts perçus par un
! observateur grâce à une onde matérielle qu'ils émettent, est un
! phénomène classique tout à fait intuitif et compréhensible.
!
! Il ne doit pas être confondu avec le phénomène de contraction des durées,
! plus subtile et d'ampleur moindre dans le monde de tous les jours, décrit
! par la théorie de la relativité restreinte, puis générale.

<br><br>

##### 2 - Cas où $`\mathbf{\mathscr{v}_{capteur} = \mathscr{v}_{propag}}`$

à faire.

<br><br>

##### 3 - Cas où $`\mathbf{\mathscr{v}_{capteur}\gt \mathscr{v}_{propag}}`$

à faire.

<br><br>

##### Quand observe-t-on cet effet Doppler classique ?

à faire

<br>

<br><br>

##### Cas où $`\mathbf{\mathscr{v}_{capteur} = \mathscr{v}_{propag}}`$

à faire.

<br><br>

##### Cas où $`\mathbf{\mathscr{v}_{capteur}\gt \mathscr{v}_{propag}}`$

à faire.

<br><br>

--------------------

<br>

#### L'effet Doppler relativiste des ondes électromagnétiques

à faire.

<br><br>


![](sous-titre-ondes-reflexion_L1200.jpg)

#### Réflexion à une interface

À faire. Idées :  En terme d'onde, en terme de rebond, vers un lien dualité onde-corpuscule possible?
Lien avec l'optique géométrique et la loi de la réflexion.


<br><br>

![](sous-titre-ondes-refraction_L1200.jpg)


#### Qu'est-ce que le phénomène de réfraction ?

<br>

* Le **phénomène de réfraction** correspond à une *modification de la direction* de propagation
d'une onde *à la traversée d'une interface* entre deux milieux différents.   

* Ce phénomène de réfraction est **propre à toute onde**. Il s'observe en *optique, acoustique, sismologie, ...*

![refraction d'une onde plane sur un dioptre plan](
https://m3p2.com/fr/temporary_ins/waves/n3/overview/wave-optics-n3-refraction-1_v2_L1000.gif)
_Modélisation du phénomène de réfraction d'une onde plane._

* La **période temporelle $`T`$** de l'onde, **grandeur fondamentale** propre à l'onde et donc 
  *ne dépend pas du milieu* de propagation.

* **Chacun des milieux**, de part et d'autre de l'interface, est caractérisé par 
   *sa propre vitesse de propagation* de l'onde.

* La **longueur d'onde $`\lambda`$**, distance parcourue par l'onde 
  au cours d'une période temporelle $`T`$, *dépend de la célérité* $`\mathscr{v}`$ et donc *du milieu*.

<br>

##### Quel rôle joue l'interface entre les deux milieux ?
<br>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-intro-1_L1200.gif)

**a** - L'onde plane incidente change de direction à la traversée de l'interface entre les deux milieux.

**b** - Le **principe de Huygens-Fresnel** postule une *continuité de phase* de la fonction 
d'onde *à la traversée de l'interface* entre les deux milieux.

**c** - *Dans le plan de l'interface*, la fonction d'onde a une **périodicité $`\Lambda`$** 
qui dépend de l'angle d'incidence.


<br>

##### Quelle propriété de l'onde varie à la traversée de l'interface ?   
<br>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-intro-2_L1200.gif)

* La **grandeur physique fondamentale** caractérisant une onde progressive *est temporelle*, soit :
   * sa période temporelle *$`T`$ ou* sa fréquence temporelle *$`\nu=1\,/\,T`$*.
   * sa pulsation *$`\omega = 2\pi\,\nu = 2\pi\,/\,T`$* pour une *onde harmonique*.
   

* L'**onde** progressive plane harmonique de *période temporelle $`T`$* présente :

   * une **longueur d'onde $`\lambda_1`$** *$`\; = \mathscr{v}_1\;T`$* dans le milieu 1 ou sa célérité est $`\mathscr{v}_1`$.
   * une **longueur d'onde $`\lambda_2`$** *$`\; = \mathscr{v}_2\;T`$* dans le milieu 1 ou sa célérité est $`\mathscr{v}_2`$.

<br>

##### Que représente un rayon ?<br> Et comment caractériser sa trajectoire ?   
<br>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-intro-3_L1200.gif)

* L'**onde** plane progressive harmonique **propage de l'énergie** 
   * dans sa *direction de propagation*.
   * *perpendiculaire au fronts d'onde*.

* La *direction de propagation* de l'énergie peut être représentée par un **rayon**.   
  _trajectoire fléchée de couleur jaune sur la figure._

* La **trajectoire du rayon** est *déviée à l'interface*.

* Les **angles d'incidence et de réfraction** du rayon sont repérés *par rapport à la normale* à l'interface
  au point où le rayon traverse l'interface.
   * **$`\theta_1`$** est l'*angle d'incidence*.
   * **$`\theta_2`$** est l'*angle de réfraction*.

<br>
   
##### Quelle est la loi de la réfraction ?   
<br>

* Les deux angles **$`\theta_1`$ et $`\theta_2`$** peuvent s'exprimer en *fonction* des longueurs d'ondes
*$`\lambda_1`$ et $`\lambda_2`$*, et d'une **longueur de référence commune**, la longueur d'onde **$`\Lambda`$**
dans le plan de l'interface.

* Les relations utilisent le *théorème de Pythagore* dans un triangle rectangle.

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-relation-1_L1200.jpg)

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-relation-2_L1200.jpg)


* Exprimons cette longueur de référence commune dans chaque milieu :   
  <br>
  **$`\large{\boldsymbol{\mathbf{\Lambda = \dfrac{\lambda_1}{sin\,\theta_1}}}}\quad`$** 
  et *$`\quad\large{\boldsymbol{\mathbf{\Lambda = \dfrac{\lambda_2}{sin\,\theta_2}}}}`$*.   

* Nous en déduisons la **loi de la réfraction** :   
  <br>
  $`\left.\begin{align}
   &\Lambda = \dfrac{\lambda_1}{sin\,\theta_1}\\
   &\Lambda = \dfrac{\lambda_2}{sin\,\theta_2}
   \end{align}\right\}\Longrightarrow\;\dfrac{sin\,\theta_1}{\lambda_1}=\dfrac{sin\,\theta_2}{\lambda_2}`$   
   <br>
   $`\hspace{2.5cm}\Longrightarrow\;\dfrac{sin\,\theta_1}{\mathscr{v}_1\,T}=\dfrac{sin\,\theta_2}{\mathscr{v}_2\,T}`$   
   <br>
   $`\hspace{2.5cm}\Longrightarrow\;\color{brown}{\large{\boldsymbol{\mathbf{\dfrac{sin\,\theta_1}{\mathscr{v}_1}=\dfrac{sin\,\theta_2}{\mathscr{v}_2}}}}}`$
   

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-relation-3_L1200.jpg)


C'est incomplet. Traiter à la suite le phénomène de réflexion totale..

<br>

##### Quel est le lien avec l'Optique géométrique ?

<br>

* La célérité **$`c=3\times 10^8\;m\,s^{-1}`$** de la lumière dans le vide est une **constante fondamentale de la nature**.   
  L'expérience, comprises dans le cadre de la relativité d'Einstein, montre que $`c`$ est une *vitesse limite infranchissable*.

* Dans un **matériau transparent**, isotrope et homogène, tout se passe comme si la lumière se propage en ligne droite
  à une *célérité $`\mathscr{v}`$* qui dépend du matériau.

* Caractéristique du matériau, la célérité $`\mathscr{v}`$ s'exprime à travers la 
  notion d'*indice de réfraction* $`n`$ défini par :   
  <br>
  *$`\large{\mathbf{n=\dfrac{c}{\mathscr{v}}}}`$*.

* La *loi de la réfraction en optique géométrique* s'exprime en utilisant la notion d'indice de réfraction
  pour caractériser les milieux de part et d'autre de leur interface.   
  <br>
  Connue sous le nom de **Loi de Snell-Descartes**, elle s'écrit :   
  <br>
  **$`\large{\mathbf{n_1\cdot sin\,\theta_1 = n_2\cdot sin\,\theta_2}}`$**


<br><br>

![](titre-ondes-phenomenes_L1200.jpg)


#### Quelles sont les phénomènes propres aux ondes ?

* Ces phénomènes ne sont pas décrits par la physique classique appliquée aux corps et corpuscules.

* Lorsque *une ou plusieurs ondes* se propagent dans *un même milieu* :

   * Le phénomène d'**interférence** peut être observé en présence de plusieurs ondes.
     
   * Le phénomène de **diffraction** peut être observé lorsqu'un obstacle pertube la propagation d'une onde.


![](sous-titre-ondes-interference_L1200.jpg)

#### Qu'est-ce que le phénomène d'interférence ?

<br>

* Le **phénomène d'interférence** est le fait que lorsque *des ondes se superposent* dans l'espace et le temps,
l'*amplitude de l'onde resultante* n'est *pas la somme des amplitudes* des ondes en présence.

![interférences entre deux ondes sphériques d'égale amplitiudes et déphasées de pi,
et propagation des zéros](https://m3p2.com/fr/temporary_ins/waves/n3/overview/2_sources_circulaires_dephasees_pi_v2_L1000.gif)

* La figure ci-dessus est la **représentation symbolique des interférences** créées par la 
  *superposition de deux ondes circulaires synchrones*, de même amplitude mais en opposition de phases à leurs sources.

* L'*interprétation des couleurs* se rapproche de l'expérience de la cuve à onde.
    * zone du **bleu le plus foncé** : *valeur maximale* pour l'élongation de l'onde résultante.   
      _(crêtes des vaguelettes observées)._
    * zone du **bleu le plus clair** : *valeur minimale*.
      _(creux des vaguelettes observées)._
    * zone de **bleu moyen** : *élongation nulle*.

  * On discerne des **lignes stationnaires** sur lesquelles l'*élongation EST nulle*.    
    Elles correspondent à des zones qui restent non perturbées.
    

<!----------------
!!! déphasées de $`/pi`$ à leurs sources
!!! <details markdown=1>
!!! <summary>Représentation symbolique des interférences créées par deux ondes sphériques.<br>
!!! </summary>
!!! La figure représente les interférences de deux ondes progressives sphériques $`U_1(\vec{r},t)`$ et $`U_1(\vec{r},t)`$, synchrones mais 
!!! déphasées de $`/pi`$ à leurs sources en $`S_1`$ et $`S_2`$.
!!! Afin de mieux visualiser le phénomène, la modélisation des sources sphériques n'est pas physique. 
$`U(\vec{r},t)=U_0\cdot\cos(k r-\omega t)`$ au lieu de $`U(\vec{r},t)=\dfrac{U_0}(r}\cdot\cos(kr-\omega t)`$ 
pour une onde progressive sphérique se propageant dans l'espace. Pour une onde sphérique réelle non amortie, 
la décroissance en $`1/r`$ de l'amplitude de l'onde à partir de sa source en $`r=0`$ permet la conservation de
l'énergie. 
Considérons une onde dont la puissance transportée 
En effet, au cours de sa progression, l'intensité $`I_O`$ proportionnelle en tout point à $`U_O^2`$ ontenue sur un front d'onde se répartie 
sur la surface $`4\pi r^2`$ sur une sphère de rayon croissant r au fur et à mesure de la progression.
de ra
Le modèle mathémait
!!! Même en absence de phénomène
!!! l'équation de propagation
!!! </details>


* Une onde projette de l'énergie.

* Le **phénomène d'interférence** apparaît lors de la *superposition de plusieurs ondes* dans l'espace.

* Il y a interference lorsque la *distribution spatiale d'énergie résultante* d'une superposition d'ondes
  n'est **pas égale à** la *somme des distributions d'énergie propres à chaque onde* prise isolément.


---------------->



##### Que signifient "interférences constructives" et "interférence destructives" ?


##### Que représentent les noeuds et les ventres ?


##### Quelle lien entre interférences et ondes stationnaires ?

<br>

 
 <br><br>
 
![](sous-titre-ondes-diffraction_L1200.jpg)


#### Qu'est-ce que le phénomène de diffraction ?

 A faire
 
 <br>
 
 
#### Qu'est-ce que le principe d'Huygens-Fresnel ?

A faire
 
 <br>



---

En attente pour effet doppler

![](wave-doppler-forward-1_L900.gif)

serait mieux si c'était la source qui se déplace..

Source et détecteur immobiles dans le milieu

![](waves-doppler-immob_1ok_L900.gif)

![](waves-doppler-immob_2ok_L900.gif)


<!--Grand chapitre ## : Les ondes en général<br> des propriétés observées au phénomène ondulatoire--->




