---
title: 'Le dioptre sphérique en approximation paraxiale'
---

### Interface réfractante et dioptre

Une **interface réfractante** est la *frontière séparant deux milieux  différents optiquement transparents, homogènes et isotropes*, caratérisés par deux indices de réfraction de valeurs différentes.

Les interface réfratantes les plus rencontrées sont les interfaces réfractantes planes et sphériques.

#### Interface réfractante plane

À une **interface réfractante** : les *milieux sont différents de part et d'autre* de l'interface, **le plan que définit l'interface n'est pas un plan de symétrie**. Optiquement, cela se traduit par le fait que les images vues par un observateur d'un objet situé de l'autre côté du dioptre ne seront pas les mêmes si les positions de l'observateur et de l'objet sont échangées. Les images observées ne se situeront pas à la même distance de l'interface. Ainsi, même si les  images ont la même taille (cas particulier d'un dioptre plan) l'objet ne sera pas vue sous un même angle apparent.

!!! *Figure "disymétrie optique d'une interface"* : 
!!!! Deux frères jumeaux situés à même distance mais de part et d'autre d'une interface air-eau, ne verront pas la même image l'un de l'autre. 
!!! L'interface étant plane et les indices de réfraction de l'air et de l'eau étant $n_{air}=1$ et $n_{eau}=4/3$, par rapport à la position réelle de son frère l'un des jumeaux verra l'image de son frère rapprochée d'un facteur 3/4, l'autre la verra éloignée dun facteur 4/3. Pour ce dioptre plan travaillant dans les conditions de Gauss (_pour se rapprocher de ces conditions, chaque jumeau regarde sont frère entre le sommet de la tête et le bout de la main_), les images des deux jumeaux ont la même taille que les jumeaux eux-même : le grandissement transversal est égal à un ($G_T$=1). Pour le jumeau qui voit les distances rapprochées d'un facteur 3/4, le grandissement longitudinal de l'image de son frère est égal à trois quarts ($G_L$=3/4). Ce même grandissement longitudinal est de quatre tiers ($G_L$=4/3) pour le jumeau qui voit les distances augmentées d'un facteur 4/3. Les jumeaux observent ici des images de leur frère de mêmes tailles mais situées à des distances différentes d'eux-mêmes, alors ils ne se verront pas sous un même angle apparent : chacun d'eux verra son frère avec un grossissement différent.
!!!
!!! _*En toute rigueur* : nous avons négligé ici l'épaisseur de la paroi de verre qui joue comme une double interface plane. Cette paroi de faible épaisseur ne fait que décaler chaque image vue d'une distance inférieure à son épaisseur. Les jumeaux sont représentés avec un masque de plongée. Ainsi les yeux du jumeau situé dans l'eau ne sont pas au contact direct de l'eau, s'interpose entre son frère et ses yeux une autre interface, l'interface eau-air (en négligeant l'effet de la double interface que forment les deux faces du masque). Dans ces conditions, l'image vue par le jummeau dans l'eau ne correspondrait pas à celle indiquée sur la figure. Nous pourrions considérer que le jumaux dans l'eau retire son masque pour l'expérience, mais alors sa vision serait floue, parce que l'oeil humain est prévu pour être au contact de l'air. Nous remplaçons pour l'expérience l'oeil du jumeau immergé par l'oeil d'un poisson sitié à la même position._

*Selon le sens de propagation de la lumière* (du milieu d'indice $n_a$ vers le milieu d'indice $n_B$, ou l'inverse), une interface réfractante plane définira **deux comportements optiques différents**. 

**Ce résultat se généralise aux interfaces non planes** dont le comportement sera étudié au niveau "contreforts".

#### Interface réfractante et dioptre

*Pour maîtriser les images observées à travers une interface réfractante*, Il est *nécessaire de préciser* non seulement les indices de réfraction des deux milieux de par et d'autre de l'interface, mais *également le sens de propagation de la lumière à travers l'interface* : nous parlerons alors de *dioptre*.

&nbsp;&nbsp;&nbsp;**1 interface réfractante = 2 dioptres**

Définition d'un **dioptre** : *interface séparent deux milieux différents*, optiquement homogène et isotrope, *d'indices de réfraction $n$ et $n'$*, *$n$* étant l'*indice du milieu dans lequel se propage la lumière incidente* sur le dioptre,  *$n'$* étant l'*indice du milieu dans lequel se propage la lumière transmise* après traversée de l'interface.

<!-- à réserver au niveau 3, surtout pour l'espagnol et l'anglais qui parle e surface et non de dioptre. Quand je regarde une surface réfractante, je peux dire "je vois un dioptre", parce que l'action de regarder une surface réfractante impose un sens de propagation de la lumière, le milieu final d'indice de réfraction $n_{fin}$ étant celui dans lequel je me situe, le plus souvent l'air. Mais en tant qu'acteur de la science et la technologie, concevant des systèmes optiques comprenant des interfaces réfractantes entre des milieux où je ne me situe pas, je dois considérer qu'une interface réfractante définit deux dioptres : &nbsp;&nbsp;&nbsp;*1 interface réfractante = 2 dioptres*-->

<!--cet "ATTENTION ci-dessous intéresse plus le niveau 3-->
!!!! *ATTENTION* :<br>
!!!! Si il existe en espagnol et en anglais respectivement les simples mots "espejo" et "mirror" pour qualifier une surface réfléchissante, il n'existe pas dans ces deux langues un simple mot pour qualifier une surface réfractante ("dioptre" en français). Ainsi dans ces deux langues, un "dioptre" sera qualifié par sa simple description "surface réfractante", soient "superficie refractiva" en espagnol et "refracting surface" en anglais. En anglais, le terme "dioptre" existe, mais il désigne une unité de mesure de la vergence (du pouvoir réfractant), unité appelée "dioptrie" en français et "dioptría" en espagnol. Donc se souvenir du schéma suivant :
!!!!
!!!! surface réfractante : *FR : dioptre* , *ES : superficie refractiva* , *EN : refracting surface*.<br>
!!!! _la surface d'une boule de cristal forme un dioptre sphérique : une "spherical refracting surface" et "superficie refractiva esférica" respectivement en espagnol et anglais._
!!!!
!!!! unité de mesure : *FR : dioptrie* , *ES : dioptría* , *EN : dioptre*.<br>
!!!! _Les verres correcteurs de mes deux yeux ont une même puissance de 4 dioptries : "4 dioptries" et "4 dioptres" respectivement en espagnol et anglais._

#### Dioptre sphérique.

#### Etude analytique de la position et de la forme d'une image.

Un **dioptre sphérique** en optique anlytique paraxial est caractérisé par "trois grandeurs physiques" :
* **$`n_{ini}`$** : *indice de réfraction du milieu initial* (milieu situé du côté de la lumière incidente).
* **$`n_{fin}`$** : *indice de réfraction du milieu final* (milieu situé du côté de la lumière émergeante, après réfraction par le dioptre).
* **$`\overline{SC}`$** : *distance algébrique entre le __sommet S__* (point d'intersection du dioptre avec l'axe optique, son axe de révolution) *et le __centre de courbure C__* de la surface sphérique du dioptre.

! *IMPORTANT* : L'étude analytique ci-dessous s'applique aussi pour un dioptre pla,. Il sufit de remarquer qu'un dioptre plan est un dioptre sphérique dont le rayon de courbure tend vers l'infini.

Soit un *point objet* **$`B_{obj}`$** dont la projection orthogonale sur l'axe optique donne le *point objet*  **$`A_{obj}`$**. Si le point objet est situé sur l'axe optique, alors $`B_{obj}=A_{obj}`$ et nous l'appellerons point objet $`A_{obj}`$. Le pint objet $`B_{obj}`$ peut aussi bien être **réel** *que* **virtuel**.

Le **calcul de la position** du *point image* **$`B_{ima}`$**, *point conjugué du point objet $`B_{obj}`$* par le dioptre, s'effectue en **deux étapes** :

1.  J'utilise la **relation de conjugaison du dioptre sphérique** pour calculer la *position du point* **$`A_{ima}`$**, $`A_{ima}`$ étant la *projection orthogonale sur l'axe optique du point image* $`B_{ima}`$. 

**$`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$**

Pour réaliser ceci *je dois connaître la __distance algébrique__* **$`\overline{SA_{obj}}`$**, et le *calcul de la __distance algébrique__* **$`\overline{SA_{ima}}`$** le long de l'axe optique *me donne la position du point $`A_{ima}`$*.
<!--conjugación-->

2. J'utilise la **formule du "grandissement transversal" pour un dioptre sphérique** pour calculer la *__valeur algébrique__ du grandissement transversale* **$`\overline{M_T}`$** *du sègment $`[A_{obj}B_{obj}]`$*, puis j'en déduis la *__longueur algébrique__* **$`\overline{A_{ima}B_{ima}}`$** du sègmentt $`[A_{ima}B_{ima}]`$, c'est à dire la distance entre le point image $`B_{ima}`$ et sa projection orthogonale sur l'axe optique $`A_{ima}`$.

Par *definition :* **$`\overline{M_T}=\dfrac{\overline{A_{ima}B_{ima}}}{\overline{A_{obj}B_{obj}}}`$**.
Son *expression pour un dioptre sphérique* est : **$`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$**.

Je connais $`\overline{SA_{obj}}`$, $`n_{ini}`$ and $`n_{fin}`$, j'ai précédemment calculé $`\overline{SA_{ima}}`$, alors je peux déterminer $`\overline{M_T}`$ et en déduire $`\overline{A_{ima}B_{ima}}`$


! *IMPORTANT* : La relation de conjugaison et la formule du grandissement transversal pour un dioptre plan s'obtiennent facilement en réécrivant la relation de conjugaison et la formule du grandissement transversal pour un dioptre pour un dioptre sphérique dans la limite d'un rayon de courbure qui tend vers l'infini :  $`|\overline{SC}|\longrightarrow\infty`$.<br> Cela donne *pour un dioptre plan :*
!
! * *relation de conjugaison :*&nbsp;&nbsp; $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=0`$.
!
! * *formule du grandissement transversal :*&nbsp;&nbsp; $`\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ &nbsp;&nbsp; (unchanged).
!
! Ceci généralise et complète votre maîtrise du dioptre plan par rapport à ce que vous avez vu dans votre parcours pédagogiques en plaine et collines sur les dioptres plan.


#### Etude graphique de la position et de la forme d'une image.



