---
title: 'new course  : overview'
---

### The mirror

#### What is a mirror ?

##### Objective

* initial : to **reflect** light, to **focus or disperse light**.
* Ultimate : to **realize images**, alone or as part of optical instruments.

##### Physical principle

* uses the **phenomenon of reflection**, described by the law of reflection.

##### Constitution

*  Usually plane or curved (spherical for the most simple to realize,
parabolic or elliptical) **surface, highly polished** so that its surface 
state deviates from its theoretical form of less than $`\lambda/10`$ at each point
of its surface ($`\lambda`$ being the wavelength in vacuum of the light to be reflected).
To increase the reflectivity of the mirror (percentage of reflected light 
intensity per the total of the incident light intensity), the surface is
**most often metallized**.

##### Interest in optics

* **One of the most importante simple optical component** that is used *alone or 
* combined in a series in most optical instruments* : some telephotos, 
* reflecting telescopes.

#### Why to study plane and spherical mirrors?

* **Plane and spherical mirrors** are the *most technically easy to realize*, 
so they are the *most common and cheap*.
* In paraxial optics, the optical properties of a **plane mirror** are those 
of a *spherical mirror of infinite radius of curvature*.
Plane mirror, concave and convex spherical mirror

![](plane-concave-convex-mirrors.png)<br>
Fig. 1. a) plane    b) concave    c) convex   mirrors

#### Are plane and spherical mirrors stigmatic?

##### Perfect stigmatism of the plane mirror

* A plane mirror is **perfectly stigmatic**.
* Object and image are symmetrical on both side of the surface of the plane mirror.
* A real object gives a virtual image.<br> A virtual object gives a real image.

##### Non stigmatism of the spherical mirror

* In each point of the spherical mirror, the law of reflection applies.
* A spherical mirror is not stigmatic: The rays (or their extensions) 
* coming from an object point generally do not converge towards an image 
* point (see Fig. 2.)
* 
![](spherical-mirror-rays-stigmatism-1000-1.jpg)<br>
Fig. 2. Non stigmatism of a convexe mirror.

![](spherical-mirror-rays-stigmatism-1000-2.jpg)<br>
Fig. 3. But when we limit the aperture of the mirror,

![](spherical-mirror-rays-stigmatism-1000-3.jpg)<br>
Fig. 4 . and limit the conditions of use to small angles of incidence and 
refraction are small, then a point image can be defined : the mirror becomes
quasi-stigmatic.

* Spherical mirrors with a limited aperture (see Fig. 3.) and used so that 
angles of incense and emergence remain small (see Fig. 4.), become quasi-stigmatic.

##### Gauss conditions / paraxial approximation and quasi-stigmatism

* When spherical refracting surfaces are used under the following conditions, named **Gauss conditions** :<br>
\- The *angles of incidence and refraction are small*<br>
(the rays are slightly inclined on the optical axis, and intercept the spherical surface in the 
vicinity of its vertex),<br>
then the spherical refracting surfaces can be considered *quasi- stigmatic*, and therefore they 
*can be used to build optical images*.

* Mathematically, when an angle $`\alpha`$ is small ($`\alpha < or \approx 10 ^\circ`$), the following 
approximations can be made :<br>
$`sin(\alpha) \approx  tan (\alpha) \approx \alpha`$ (rad), et $`cos(\alpha) \approx 1`$.

* Geometrical optics limited to Gaussian conditions is called **Gaussian optical** or **paraxial optics**.
 
#### The thin spherical mirror (paraxial optics)

* We call **thin spherical mirror** a *spherical mirror used in the Gauss conditions*.

##### Analytical study (in paraxial optics)

* **Spherical mirror equation** = **conjuction equation** for a spherical mirror :<br><br>
$`\dfrac{1}{\overline{SA_{ima}}}+\dfrac{1}{\overline{SA_{obj}}}=\dfrac{2}{\overline{SC}}`$&nbsp;&nbsp;(equ.1)

* **Transverse magnification expression** :<br><br>
$`\overline{M_T}=-\dfrac{\overline{SA_{ima}}}{\overline{SA_{obj}}}`$&nbsp;&nbsp;(equ.2)

You know $`\overline{SA_{obj}}`$ , calculate $`\overline{SA_{ima}}`$ using (equ. 1) 
then $`\overline{M_T}`$ with (equ.2), and deduce $`\overline{A_{ima}B_{ima}}`$.

! *USEFUL 1* :<br>
! The conjunction equation and the transverse magnification equation for a plane mirror 
! are obtained by rewriting these two equations for a spherical mirror in the limit when
! $`|\overline{SC}|\longrightarrow\infty`$.
! Then we get for a plane mirror : $`\overline{SA_{ima}}=\overline{SA_{obj}}`$ and
! $`\overline{M_T}=+1`$.

! *USEFUL 2* :<br>
! *You can find* the conjunction and the transverse magnification *equations for a plane mirror directly from 
! those of the spherical mirror*, with the following assumptions :<br>
! $`n_{eme}=-n_{inc}`$<br>
! (to memorize : medium of incidence=medium of emergence, therefor same speed of light, but direction
! of propagation reverses after reflection on the mirror)<br>
! are obtained by rewriting these two equations for a spherical refracting surface in the limit 
! when $`|\overline{SC}|\longrightarrow\infty`$.
! Then we get for a plane mirror :<br>
! $`\overline{SA_{ima}}=\overline{SA_{obj}}`$ and $`\overline{M_T}=+1`$

##### Graphical study

*1 - Determining object and image focal points*

Positions of object focal point F and image focal point F’ are easily obtained from the conjunction
equation (equ. 1).

* Image focal length $`\overline{OF'}`$ : $`\left(|\overline{OA_{obj}}|\rightarrow\infty\Rightarrow A_{ima}=F'\right)`$<br><br>
(equ.1) $`\Longrightarrow\dfrac{1}{\overline{SF'}}=\dfrac{2}{\overline{SC}}\Longrightarrow\overline{SF'}=\dfrac{\overline{SC}}{2}`$

* Object focal length $`\overline{OF}`$ : $`\left(|\overline{OA_{ima}}|\rightarrow\infty\Rightarrow A_{obj}=F\right)`$<br><br>
(equ.2) $`\Longrightarrow\dfrac{1}{\overline{SF}}=\dfrac{2}{\overline{SC}}\Longrightarrow\overline{SF}=\dfrac{\overline{SC}}{2}`$

*2 - Thin spherical mirror representation*

* **Optical axis = revolution axis** of the mirror, positively **oriented** in the direction of propagation of the incident light.

* Thin spherical mirror equation :<br><br>
\-**line segment**, perpendicular to the optical axis, centered on the axis with symbolic *indication of the 
direction of curvature* of the surface at its extremities, and *dark or hatched area on the non-reflective 
side* of the mirror.<br><br>
\-**vertex S**, that locates the refracting surface on the optical axis;<br><br>
\-**nodal point C = center of curvature**.<br><br>
\-**object focal point F** and **image focal point F’**.

##### Examples of graphical situations, with analytical results to train

[Click here for geogebra animation](https://www.geogebra.org/m/jwgy9q7z)

* with **real objects** 

![](Thin-spherical-mirror-InfAC-1000.jpg)<br>
Fig. 5.  Concave mirror with object between infinity and C

![](Thin-spherical-mirror-CAF-1000.jpg)<br>
Fig. 6.  Concave mirror with object between C and F/F’

![](Thin-spherical-mirror-FAS-1000.jpg)<br>
Fig. 7.  Concave mirror with object between F/F’ and S

![](Thin-spherical-mirror-InfAS-1000.jpg)<br>
Fig. 8.  Convex mirror




















