---
title: 'Application du théorème de Gauss intégral : méthode'
published: true
routable: true
visible: false
lessons:
    -
        slug: electrostatics-gauss-application-method-3
        name: LINÉAIRE-3 : Théorème de Gauss : méthode générale
        order: 2
    -
        slug: gauss-integral-cylindrical-symmetry-3-method
        name: LINÉAIRE-3 : De Gauss intégral aux charges à symétrie cylindrique
        order: 3
    -  
        slug: gauss-integral-demonstration-towards-application
        name: PARALLÈLE-3 : Gauss intégral, démonstration vers application
        order: 3
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Loiint{\displaystyle\mathop{{\iint}\mkern-22mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-6_L1200.jpg)<details>
<summary>Etape 6 : Relecture</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

### Forme intégrale

#### Introduction :

Soit une *distribution de charges maintenues immobiles* dans l'espace décrite par une densité de charge $`\dens`$.

Le **Théorème de Gauss intégral** démontre que le flux $`\Phi_E`$ du vecteur champ électrique à travers toute *surface fermée $`S`$* de l'espace est égal à la *charge totale $`Q_{int}`$ contenue à l'intérieur de $`S`$* divisée par la constante diélectrique $`\epsilon_0`$.<br>
<br>**$`\large\mathbf{\Phi_E=\Loiint_S \overrightarrow{E}\cdot\overrightarrow{dS}=\dfrac{Q_{int}}{\epsilon_0}}`$**

**Le théorème de Gauss intégral s'applique** quelque soit le niveau de modélisation et d'approximation des distributions de charges :
*  avec une *densité volumique de charges $`\dens^{3D}`$*.

mais aussi 
*  avec une *densité surfacique de charges $`\dens^{2D}`$*, lorsque les charges sont réparties en surface sur une profondeur que la modélisation 2D néglige.
*  avec une *densité linéïque de charges $`\dens^{1D}`$*, lorsque les charges sont réparties sur une ligne dont la modélisation 1D néglige la section droite.

!!! *Terminologie* : une section droite est une section perpendiculaire à la direction longitudinale.

C'est d'ailleurs ce théorème de Gauss intégral qui **démontre les discontinuités du champ électrostatique** *à la traversée d'une surface chargée* à cette étape contrefort, et que seront démontrées les discontinuités des champs $`\overrightarrow{E}`$ et $`\overrightarrow{D}`$ à l'étape suivante de montagne, en électromagnétisme dans le vide et dans la matière.

Ces **résultats concernant la discontinuité** du champ électrostatique à la traversée d'une surface chargée sont *nécessaires si le théorème de Gauss local est utilisé* pour calculer le champ  $`\overrightarrow{E}`$ en tout point de l'espace *avec modélisation 2D* de la distribution de charges.

!! *Pour aller plus loin* :   
!! *Théorème de Gauss intégral et réflexion/transmission des ondes électromagnétiques*.
!!
!! Lorsque  lors de sa propagation *une onde électromagnétique $`(\overrightarrow{E}, \overrightarrow{B})`$ rencontre une surface* séparant deux milieux différents (entre deux milieux matériels comme des conducteurs, des isolants, ou entre le vide et un milieu matériel), *une partie de l'onde est réfléchie et l'autre est transmise*. 
!!
!! *Les relations de Fresnel précisent les propriétés des ondes réflechies et transmises* (amplitude, déphasage, polarisation, direction) . Elles permettent de retrouver en les relations Snell-Descartes $`(n_1\,\sin\, i_1=n_2\,\sin\, i_2)`$ et de la réflexion $`(i_1 = i_2)`$ de l'optique géométrique, tout en révélant toute une réalité hors d'atteinte de l'optique géométrique (polarisation des ondes, part de l'énergie réflechie et part de l'énergie transmise, ...).
!!
!! Les propriétés de conduction de l'électricité, de polarisation et d'aimantation des milieux matériels nécessite l'usage de deux nouveaux champs, champ d'induction électrique $`\overrightarrow{D}`$ et champ d'excitation magnétique $`\overrightarrow{H}`$ en complément des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$.
!!
!! Le *théorème de Gauss intégral*, dans sa forme et sa notation présente et appliqué à certains de ces champs, *intervient directement dans l'établissement des relations de Fresnel*. 

#### 2° étape : Choix de la surface de Gauss et calcul du flux

Le théorème de Gauss permet de calculer le champ électrique en un point $`M`$ quelconque, donc en tout point $`M`$ de l'espace.

À cette étape 2, l'intérêt se porte sur le *premier terme du théorème de Gauss*. Il s'agit d'**identifier la surface de Gauss** $`\mathcal{S}_G`$ puis de **calculer le flux** de $`\overrightarrow{E}`$ à travers cette surface.       
<br>
*ÉTAPE 2 :* **$`\large\mathbf{\Loiint_{\mathcal{S}_G}\overrightarrow{E}\cdot\overrightarrow{dS}}`$** *$`\large = \dfrac{Q_{int}}{\epsilon_0}`$*.

D'une façon générale, la **surface de Gauss** sera :
* un **prisme droit à base quelconque**, contenant le point $`M`$ pour une *distribution de charges 
présentant un plan de symétrie ou d'antisymétrie*.
* une **sphère** contenant le point $`M`$ pour une *distribution de charges à symétrie sphérique*.
* un **cylindre** contenant le point $`M`$^pour une *distribution de charges à symétrie cylindrique*.   


##### Éléments physiques conduisant à ces choix.

Si le théorème de Gauss est vrai quelque-soit la surface fermée considérée, aussi complexe soit-elle, il ne peut nous aider à calculer le champ électrique $`\overrightarrow{E}`$ dans tout l'espace que si chacun de ses termes est facile à calculer.

C'est l'**expression du champ électrique** déduite par l'étude des symétries et invariances qui *permet de déterminer la surface de Gauss* adaptée.

<!--------------------------
Supposons que *dans un repère de l'espace
$`(O, \overrightarrow{e_{\alpha}},\overrightarrow{e_{\beta}},\overrightarrow{e_{\gamma}})`$*, les symétries et invariances nous indiquent que le champ électrique est de la forme    **$`\mathbf{\overrightarrow{E}=E_{\beta}\,(\beta)\,\overrightarrow{e_{\beta}}}`$**.
--------------------------->

Le calcul du flux de $`\overrightarrow{E}`$ à travers la surface fermée de Gauss $`\mathcal{S}_ﬁ`$ nécessite de calculer en chacun de ses éléments de surface $`dS`$ constitutifs le produit scalaire $`\overrightarrow{E}\cdot\overrightarrow{dS}`$.

Une **surface de Gauss adaptée** sera donc une surface de Gauss qui **vérifie 3 conditions** :

* *les éléments vectoriels de surface $`\overrightarrow{dS}`$ vérifient* :   
<br>
* **$`\mathbf{\overrightarrow{dS}\parallel\overrightarrow{E}}`$**, car alors le produit scalaire se résumera au simple produit des composantes selon $`\beta`$ de chacun de ces vecteurs.    
Si  $`\overrightarrow{E}=E_{\beta}(\beta)\;\overrightarrow{e_{\beta}}`$ renoté $`\overrightarrow{E}=E\;\overrightarrow{e_{\beta}}`$ et si $`\overrightarrow{dS}=dS\;\overrightarrow{e_{\beta}}`$, alors :   
*$`\mathbf{\overrightarrow{dS}\parallel \overrightarrow{E} \Longrightarrow\overrightarrow{dS}\cdot \overrightarrow{E}} `$*
$`= \left(dS\;\overrightarrow{e_{\beta}}\right)\cdot \left( E\;\overrightarrow{e_{\beta}}\right)`$   
$`\hspace{4.5cm}=  E\;dS \times ( \underbrace{\overrightarrow{e_{\beta}}\cdot \overrightarrow{e_{\beta}}}_{=\;1})`$
*$`\hspace{4.5cm}\mathbf{=  E\; dS}`$*   
<br>
* **$`\mathbf{\overrightarrow{dS}\perp\overrightarrow{E}}`$**, car alors le produit scalaire est nul :   
*$`\mathbf{\overrightarrow{dS}\perp\overrightarrow{E}\Longrightarrow\overrightarrow{E}\cdot\overrightarrow{dS}=0}`$*.      
! *Note* : l'ensemble des surfaces élémentaires $`\overrightarrow{dS}`$ de la surface de Gauss
! $`S_G`$ ne doivent pas vérifier $`\overrightarrow{dS}\perp\overrightarrow{E}`$, sinon tu aurais 
! $`\displaystyle\oiint_{S_G} \overrightarrow{E}\cdot\overrightarrow{dS}=0`$ et 
! le théorème de Gauss se limiterait au résultat $`0=0`$, résultat vrai mais qui n'aiderait pas au calcul
! du champ électrique.

* **En chaque point $`P`$** de la surface de Gauss
**où $`\overrightarrow{dS}\parallel\overrightarrow{E}`$**, la **composante de
$`\overrightarrow{E}`$ selon $`\overrightarrow{dS}`$** a une même valeur unique, une **valeur constante , ou une valeur nulle**.   
<br>
En effet, le *théorème de Gauss+ est une *équation unique*, qui ne doit donc 
contenir qu'*une seule inconnue*, la valeur constante non nulle de la composante de
$`\overrightarrow{E}`$ selon $`\overrightarrow{dS}`$ lorsque $`\overrightarrow{dS}\parallel\overrightarrow{E}`$.   
! *Note* :    
! Cette remarque est indispensable pour le calcul de $`\overrightarrow{E}`$
! créé par un plan infini chargé uniformément.  
!
! Il faudra alors considérer un élément de symétrie supplémentaire par rapport à 
! l'étude d'une distribution de charge à symétrie cylindrique ou sphérique.
<br>
!!! *Contre-exemple* :   
!!! 
!!! Supposons que dans un repère de l'espace
!!! $`(O, \overrightarrow{e_{\alpha}},\overrightarrow{e_{\beta}},\overrightarrow{e_{\gamma}})`$,
!!! les symétries et invariances nous indiquent que le champ électrique est de la forme 
!!! $`\overrightarrow{E}=E_{\beta}\,(\beta)\overrightarrow{e_{\beta}}`$   
!!! 
!!! Utilisons le théorème de Gauss pour déterminer le champ en un point $`M`$ quelconque de 
!!! coordonnées $`(\alpha_M, \beta_M, \gamma_M)`$
!!! avec l'indice $`M`$ ici précisé pour la démonstration. La surface de Gauss doit 
!!! nécessairement contenir le point $`M`$, 
!!! donc l'une de ses surfaces élémentaires doit avoir pour coordonnées
!!!  $`\overrightarrow{dS}=\overrightarrow{dS}(\alpha_M, \beta_M, \gamma_M)`$.
!!!
!!! Choisissons une surface de Gauss dont en chacun de ses points de coordonnées
!!!  $`(\alpha, \beta, \gamma)`$    
!!! les surfaces élémentaires $`\overrightarrow{dS}=\overrightarrow{dS}(\alpha, \beta, \gamma)`$ qui vérifient 
!!! $`\overrightarrow{dS}\parallel\overrightarrow{E}`$ 
!!! se classent en deux catégories :       
!!!   * $`\overrightarrow{dS}=\overrightarrow{dS}(\alpha, \beta_M, \gamma)`$ avec $`\beta_M`$ coordonnée $`\beta`$ 
!!! du point $`M`$.
!!!   * $`\overrightarrow{dS}=\overrightarrow{dS}(\alpha, \beta_0, \gamma)`$ avec $`\beta_0\ne\beta_M`$.
!!!
!!! Les flux élémentaires $`\overrightarrow{E}\cdot\overrightarrow{dS}`$ en chaque point de la surface
!!! de Gauss se classeront aussi en deux catégories, à savoir :   
!!! * $`\overrightarrow{E}(\alpha, \beta_M, \gamma)\cdot\overrightarrow{dS}(\alpha, \beta_M, \gamma)`$.
!!! * $`\overrightarrow{E}(\alpha, \beta_0, \gamma)\cdot\overrightarrow{dS}(\alpha, \beta_0, \gamma)`$.
!!!
!!! Le champ électrique étant inconnu (c'est l'objectif du théorème de Gauss de le calculer), deux inconnues de 
!!! champ apparaîtraient dans le calcul du flux de 
!!! $`\overrightarrow{E}`$ à travers la surface de Gauss $`S_G`$ :
!!! * inconnue 1 : $`E_{\beta}(\beta_M)`$.
!!! * inconnue 2 : $`E_{\beta}(\beta_0)`$.   
!!!
!!! Au final, l'équation unique composant le théorème de Gauss ne permettrait pas alors de calculer 
!!! $`\overrightarrow{E}`$.
<br>
!!!! *Attention* :   
!!!! *Ne pas confondre composante et amplitude* de $`\overrightarrow{E}`$.   
!!!! *Faire attention aux signes*.
!!!! 
!!!! Lorsque nous écrivons d'un vecteur $`\overrightarrow{U}=U\;\overrightarrow{e_U}`$ , 
!!!! avec $`\overrightarrow{e_U}=\dfrac{\overrightarrow{U}}{\lVert \overrightarrow{U} \rVert}`$,    
!!!! $`U`$ est ici la composante de $`\overrightarrow{U}`$.   
!!!!    * la *composante $`U`$* peut être *positive ou négative*.
!!!!    * l'*amplitude ou norme $`\lVert \overrightarrow{U} \rVert`$* est *toujours positive*.
!!!!
!!!! L'étude des *symétries et invariances* d'une distribution de charge ne donne que la direction, mais elle
!!!!  *n'indique pas le sens* de $`\overrightarrow{E}`$,. 
!!!!
!!!! En physique : *1 direction = 2 sens possibles*
!!!!
!!!! Le* sens de  $`\overrightarrow{E}`$* peut être *déduit intuitivement* de l'observation de la distribution de
!!!! charges. En tout point de l'espace :
!!!!   *  $`\overrightarrow{E}`$ pointe en direction opposé à la direction d'une charge positive.
!!!!   *  $`\overrightarrow{E}`$ pointe dans la direction d'une charge négative.
!!!!
!!!! Le *théorème de Gauss* permet de calculer $`\overrightarrow{E}`$, et par conséquent *détermine aussi le sens* 
!!!! de  $`\overrightarrow{E}`$. Pour cela il faut précisément *respecter les signes* :
!!!!    * signe $`+`$ ou $`-`$ devant une composante (dont la valeur, déterminée par la suite, pourra elle-même 
!!!! être positive ou négative).
!!!!    * signes $`+`$ ou $`-`$ des charges dans la distribution.
!!!!
!!!! *Les erreurs de signe*, par omission ou par négligence, *sont des erreurs fréquentes*.

<br>

----------

#### 3° étape : Calcul de la charge dans le volume de Gauss, et calcul de $`\overrightarrow{E}`$

Cette étape consiste dans le *deuxième terme du théorème de Gauss* à **identifer et calculer la charge totale** contenue à l'intérieur de la surface de Gauss.   
<br>
*ÉTAPE 3 :* $`\large\Loiint_{\mathcal{S}_G}\overrightarrow{E}\cdot\overrightarrow{dS}=\dfrac{1}{\epsilon_0}\,\cdot`$**$`\,\large\mathbf{Q_{int}}`$**.



##### Calcul de $`Q_{int}`$ dans les différentes régions de l'espace identifiées.

* En genéral, il n'y a **pas une fonction mathématique unique**
 *décrivant dans tout l'espace $`\dens^{3D}`$* la densité volumique de charges.   
 !!! *Exemple :*
 !!!
 !!! Même dans un cas très simple boule de rayon $`R`$ chargée dans son volume avec une
 !!! densité volumique uniforme $`\dens^{3D}`$,   
 !!! la distribution des charges dans tout l'espace nécessite deux expressions mathématiques
 !!! différentes :   
 !!! * pour $`r\le R\;:\;\dens^{3D}=\dens_O`$
 !!! $`\quad\text{,   avec }\dens_O =\text{ const.}`$
 !!!
 !!! * pour $`r \gt R\;:\;\dens^{3D}=0`$<br>
 !!!
 !!! Il faudra donc identifier ces deux régions complémentaires de l'espace.
 !!!
 !!! Le calcul du flux aura deux expressions différentes dans ces deux régions

* Il faut **identifier les différents domaines** de l'espace, dont les *frontières* séparent
  *deux expressions mathématiques différentes de $`\dens^{3D}`$*.

* La **calcul de $`\mathbf{\displaystyle\iiint_{\Ltau_G}\dens^{3D}\cdot\overrightarrow{d\Ltau}}`$**
  est *effectué dans chaque domaine* identifié.

<br>

-----------------

#### 4° étape, finale  : Calcul de $`\overrightarrow{E}`$

Cette **étape ** consiste à, *dans chacun des domaines* identifiés de l'espace, **réaliser l'égalité** entre le *premier terme de champ* et le *deuxième terme de charge* du théorème de Gauss, pour en 
**déduire l'expression du champ électrique $`\overrightarrow{E}`$**.   
<br>
*ÉTAPE FINALE  :* *$`\large\Loiint_{\mathcal{S}_G}\overrightarrow{E}\cdot\overrightarrow{dS}`$* 
**$`\mathbf{\large =\dfrac{1}{\epsilon_0}}`$**  *$`\,\large Q_{int}`$*.

!!!! *ATTENTION* : l'erreur la plus courante à ce stade est d'oublier la permettivité du vide $`\epsilon_0`$, aussi appelée constante diélectrique.





