

## Git

### The easy way

Use Gitlab's WebIDE.
You won't be able to 100% accurately preview the result until you commit and the servers are updated.

### The powerful way

Run the website locally and preview your changes instantly.
Head over to the [sources of the server instance](https://m3p2.ljbac.com/m3p2/grav-website) to learn how to set it up.


## File Structure

Each page is a directory.


### File names

We define as *slug-case* what some call *kebab-case*.

- lowercase
- alphanumeric
- joined with `-`
- `a-z`, no diacritics
- starts with a letter (probably best)


#### Directories

`[<NN>.]<slug>`

The numbers prefix can be ignored when building links, its purpose is to order sibling pages.

Set the english slug ; localized slugs can be set in frontmatters like so:

```yaml
title: Joyeux Noël!
slug: joyeux-noel
```


#### Markdown files

`<template>[.<lang>].md`

The *name of the file* will define the *template of the page*, that is how the content will appear.

> For example, the template `columns` will display the children of the page as columns.

The available templates are :
- `default`
- `portal`
- `topics`
- `topic`
- `columns`
- `textbook`
- `cheatsheet`
- `annex`

Right now there are not many differences between the various templates but there may be later.



#### Other files

- Use **slug-case** with the occasional snake between slugs.
- Be expressive.  This is an exercise in aphorisms. `fig-a_rays-through-convex-lens.png`
- use a ISO 639-1 code as suffix like an extension like so: `textbook.fr.md`.



### Markdown Cheatsheet

```
# Header <h1>
## Header <h2>
…
###### Header <h6>

*emphasis*
**strong**

Go [there](https://…)
[Current chapter](.)
[Parent chapter](..)
[Sibling chapter](../another-chapter)
[Child chapter](chapter)

![Description of the image](local-image.png)

! blue notice
!! green notice
!!! orange notice
!!!! red notice
!!!!
!!!! still the same red notice
```

> More at Gitlab's [Markdown documentation](https://docs.gitlab.com/ee/user/markdown.html).


### LateX

You can use LateX in the courses :

    $`E = m \cdot c^2`$

yields $`E = m \cdot c^2`$

> You can omit the _backticks_ (`) but the preview in gitlab won't work.


### Mermaid

You can display flowcharts in the courses :

    ``` mermaid
    graph LR
        subgraph Course
            File[File]
        end
    
        Student((Student))
    
        Student --> |reads| File
    ```

yields

``` mermaid
graph LR
  subgraph Course
    File[File]
  end

  Student((Student))

  Student --> |reads| File
```

> `LR` is for Left to Right. You could use `TB` for Top to Bottom.

GANTT diagrams and sequence diagrams are also available.
Read on [mermaid's documentation](https://mermaidjs.github.io/) for more information.


### Table demo

| A | B |   | D |   |
|---|---|---|---|---|
|   |   |   |   |   |
|   |   | X |   |   |
|   |   | X |   | _test_  |
