---
title : magnetostatics-overview
published : false
visible : false
---

<!--titre partie principale : MAGNÉTOSTATIQUE -->


## Quelles perceptions m'indiquent la présence d'un champ magnétique statique?
<!--titre équivalent partie principale : LE CHAMP MAGNÉTIQUE -->


Il faudra une introduction....
Cette belle photo qui résume bien notre lien sensible (dans notre vie de chaque
jour) avec le champ magnétique, pourra après, lorsque les niveaux 1 et 2 seront 
créés, passer dans ces niveaux inférieurs. Pour l'instant, elle est là.

![](magnetic-field-in-life-2.jpg)


## Quels effets induit un champ magnétique statique ?
<!--titre équivalent partir principale : LE CHAMP MAGNÉTIQUE -->

### Une force sur une particule chargée en mouvement

### Une force sur un conducteur parcouru par un courant

### Force résultante sur une spire parcourue par un courant

#### Spire dans un champ magnétique uniforme

#### Spire dans un champ magnétique non uniforme

### Moments et couple exercés sur une spire parcourue par un courant


magnétostatique.. statique..


## Pourquoi se limiter aux vide ou aux milieu non magnétiques ?
<!--titre équivalent partir principale : MAGNETOSTATIQUE dans le VIDE ou les MILIEUX
NON MAGNETIQUES -->


## Comment se créer un champ magnétique statique ?

Là aussi, cette photo pourra passer au niveaux 1 et 2 quand ils seront créés sur 
le magnétisme.

![](coil-magnetic-field-1-L1200-LR.jpg)


### Un courant élémentaire stationnaire

![](causes-magnetism-B-L1200-gif.gif)

![](causes-magnetism-H-L1200-gif.gif)

Biot et Savart


<!--### Un champ électrique variable dans le temps (à virer, pas magnétostatique)-->

## Que te dit le théorème d'Ampère intégral ?
<!-- l'équivalent partie "main" sera ""Théorème d'Ampère (intégral)"-->

* Soit une **distribution quelconque de courant** dans l'espace, qui créé *un champ 
magnétique* $`\overrightarrow{B}`$ en tout point de l'espace,<br><br>
et soit un **ligne fermée C quelconque** dans l'espace.

![](Ampere-theorem-1-L1200.jpg)

* Soit une **surface ouverte S quelconque qui s'appuie sur le contour C**.

![](Ampere-theorem-2-L1200.jpg)

* Choisis une **orientation quelconque du contour C**, et **oriente en conséquence
chaque surface élémentaire dS** constituant la surface S selon la **règle d'orientation 
de l'espace dite "de la main droite"**.

![](Ampere-theorem-3-L1200.jpg)

Partant de la loi de Biot et Savart, le théorème d'Ampère montre que :

* La **circulation du champ d'induction magnétique $`B`$ le long du contour C**
est égale à la *somme algébrique des courants électriques traversant la surface S*, <br><br>
**$`\oint_C \overrightarrow{B} \cdot \overrightarrow{dl} = \mu_0 \cdot \sum_n \overline{I_n}`$** <br>  
ou, ce qui revient au même, au *flux du vecteur densité volumique de courant à travers la surface S*<br><br>
**$`\oint_C \overrightarrow{B} \cdot \overrightarrow{dl} = \mu_0 \cdot \iint_S \overrightarrow{j} \cdot \overrightarrow{dS}`$** 

<!--![](Ampere-theorem-4-L1200.jpg)-->

----------

![](Ampere-theorem-4-portrait-L620.jpg)

----------
## Quelle est l'utilité du théorème d'Ampère intégral ?

## Comment dois-tu l'utiliser ?

## Pourquoi le théorème d'Ampère intégral est-il insuffisant ?

![](ampere-integral-insuffisant-L1200.gif)<br>
_Champ magnétique créé par 3 courants électriques rectilignes, infinis et stationnaires,
se propageant dans une direction perpendiculaire au plan de représentation du champ
magnétique._

* Dans les *cas simples*, **l'oeil humain repère immédiatement** les points centre de rotation
des lignes de champ magnétique, qui localisent *les causes
du champ magnétique* dans le plan d'observation. 

* Le **théorème d'Ampère intégral** précise, lors d'une circulation non nulle du champ magnétique
le long d'un chemin fermé, la somme totale des courants à l'origine de cette circulation, 
mais *ne permet pas la localisation précise des sources* du champ magnétique.

* Il **doit exister une propriété locale** (à l'échelle mésoscopique, donc apparaissant ponctuelle
 à la résolution de l'observation) qui en tout point de l'espace *relie le champ magnétique
à sa cause élémentaire locale*.

## Une idée pour relier une propriété locale du champ magnétique locale à sa cause ?

* Dans la **démonstration du théorème dAmpère** (partie principale), *aucune échelle de taille n'est précisée* 
pour les choix du contour d'Ampère et d'une surface s'appuyant sur ce contour.

* $`\Longrightarrow`$ idée 1 : faire tendre le contour d'Ampère vers un 
**contour mésoscopique plan autour de chaque point** de résolution de l'espace, 
 la *circulation* ainsi calculée sera une *propriété locale du champ*.

* $`\Longrightarrow`$ idée 2 : choisir pour *surface associée* la 
**portion de plan mésoscopique délimité par le contour précédent**,  le *flux du courant* 
à travers cette surface mésoscopique déduit du théorème d'Ampère 
sera ainsi un *courant local*.

* Cette idée est à la **base de la notion de champ rotationnel** d'un champ vectoriel.

## Qu'est-ce que le champ rotationnel de B ?

Le champ rotationnel de B est un **champ vectoriel**.

En *tout point M de l'espace*, le vecteur **$`\overrightarrow{rot}\;\overrightarrow{B_M}`$ indique** :

* en mots :<br>
\- le **plan local** dans lequel s'effectue la **rotation de $`\overrightarrow{B_M}`$** par sa *direction*.<br>
$`\Longrightarrow`$ la *direction de $`\overrightarrow{j}`$*, vecteur densité volumique de courant.<br><br>
\- le **sens de la rotation** de $`\overrightarrow{B_M}`$ par le *sens de $`\overrightarrow{rot}\;\overrightarrow{B_M}`$
et la *règle d'orientation* de l'espace.<br>
$`\Longrightarrow`$ le *sens de $`\overrightarrow{j}`$*, vecteur densité volumique de courant.<br><br>
\- l'**intensité du champ magnétique créé** par *norme de $`\overrightarrow{rot}\;\overrightarrow{B_M}`$*<br>
$`\Longrightarrow`$ la *norme de $`\overrightarrow{j}`$*, vecteur densité volumique de courant.

* mathématiquement et plus précis : **$`\overrightarrow{rot}\;\overrightarrow{B}=\mu_0 \cdot \overrightarrow{j}`$**
 

## Comment se détermine son expression en coordonnées cartésiennes ?


![](Rotationnel-B-cartesian-web-L1200-ok.jpg)

![](Rotationnel-B-cartesian-2-web-L1200-ok.jpg)

![](Rotationnel-B-cartesian-3-web-L1200-ok.jpg)

## Comment visualiser et mémoriser le théorème de Stokes ?
<!-- l'équivalent partie "main" sera ""Le théorème de Stokes"-->
*Guide de démonstration et Aide à la mémorisation*

C'est pour l'instant un essai de dimensionnement des figures

* **2 figures côte-à-côte**, OK pour smartphone orientation portrait 300px?

![](Th-Stokes-1-L1200.jpg)

![](Th-Stokes-2-L1200.jpg)

![](Th-Stokes-3-L1200.jpg)

![](Th-Stokes-4-L1200.jpg)

![](Th-Stokes-5-L1200.jpg)

![](Th-Stokes-6-L1200.jpg)

![](Th-Stokes-7-L1200.jpg)

![](Th-Stokes-8-L1200.jpg)

![](Th-Stokes-9-L1200.jpg)

![](Th-Stokes-10-L1200.jpg)

* Ou **1 figure GIF** ?

![](Th-Stokes-gif-1-L600.gif)

![](Th-Stokes-gif-2-L600.gif)

![](Th-Stokes-gif-3-L600.gif)

![](Th-Stokes-gif-4-L600.gif)

![](Th-Stokes-gif-5-L600.gif)

![](Th-Stokes-gif-6-L600.gif)

![](Th-Stokes-gif-7-L600.gif)

![](Th-Stokes-gif-8-L600.gif)

![](Th-Stokes-gif-9-L600.gif)

![](Th-Stokes-gif-10-L600.gif)


## Que te dit le théorème d'Ampère local ?
<!-- l'équivalent partie "main" sera ""Théorème d'Ampère (intégral)"-->


