---
title: "Boundary conditions, reflection and transmission
published: true
routable: true
visible: false
---

<!------
## Reflected and transmitted electromagnetic waves at interfaces
-------->

### Boundary conditions, reflection and transmission

#### chap2 Boundary conditions

Before considering the reflection and transmission of electromagnetic
waves between two media, we have to determine the relations governing
the be- haviour of the fields $`\overrightarrow{D}`$, $`\overrightarrow{B}`$, $`\overrightarrow{E}`$ and $`\overrightarrow{H}`$ at the
interface between two materials. Simply stated, these relations,
called the "*boundary conditions*" tell us that if we know the fields
in one material close to the separation surface then we can calculate
some components of these same fields in the other material (again,
close to the separation surface). We will consider an LHI material and
the relations we will find are valid **for any point** close to the
separation surface and **for any time**. These two conditions are
important to find some of the results later in this chapter. The
boundary conditions can be obtained from the Maxwell equations. The
first two equations

i.  tS

$`\overrightarrow{D}`$ · *d*$`\overrightarrow{S}`$ = *Q^encl.^*
>
(3.1)

ii. tS $`\overrightarrow{B}`$ · *d*$`\overrightarrow{S}`$ = 0 (3.2)

(3.3)

will give information on the normal components of $`\overrightarrow{D}`$ and $`\overrightarrow{B}`$,
while the third and fourth

iii. t $`\overrightarrow{E}`$ · *d***l** = − [d]{.underline} { $`\overrightarrow{B}`$ · *d*$`\overrightarrow{S}`$ (3.4)

iv. t $`\overrightarrow{H}`$ · *d***l** = *I^encl.^* + [d]{.underline} { $`\overrightarrow{D}`$ · *d*$`\overrightarrow{S}`$
    (3.5)

~C~ d*t* ~S~

(3.6)

will give information on the tangential components of $`\overrightarrow{E}`$ and $`\overrightarrow{H}`$.
>
To obtain the boundary conditions we consider a surface separating two
Linear 49

![](media/image167.jpeg)nˆ2 1 cylinder

boundary 1

medium 1

medium 2

da~2~
>
nˆ~1~ ~2~
>
(J\'*~s~*
>
top, bottom and middle surfaces
>
of the box used to calculate the flux
>
Figure 3.1: []{#_bookmark59 .anchor}Scheme for deriving boundary
conditions for perpendicular field components. S~1~, S~2~ and S^t^
represent respectively the surface at the top, bot- tom and interface.
>
Homogeneous and Isotropic (LHI) media whose properties such as that
the permittivity and permeability are different. We denote as
$`\overrightarrow{E}`$~1~, $`\overrightarrow{B}`$~1~, $`\overrightarrow{D}`$~1~ and $`\overrightarrow{H}`$~1~ the fields present in
material 1 close to its surface. Likewise an index 2 will be used for
the fields in the second material.

__**Normal components**__

__D vector__

Let's apply Maxwell equation (i) to the small cylinder showed in
figure [3.1](#_bookmark59) which extends from one side to the other on
the separation surface. This box has a base surface A and an
infinitesimally small thickness *δ*. We get:
>
tS $`\overrightarrow{D}`$ · d**a** = {S
>
$`\overrightarrow{D}`$~1~ · d**a**~1~ + {S
>
$`\overrightarrow{D}`$~2~ · d**a**~2~ + {S

side

$`\overrightarrow{D}`$ · d**a** = {*V*
>
*ρ~c~* d*V.*
>
If we now let *δ* 0 symmetrically with respect to the separation
surface such that the cylinder gets "pressed" onto the surface:

-   The third term on the left hand side of the previous equation will
    be negligible as the flux of the vector $`\overrightarrow{D}`$, which is a finite
    quantity, through an infinitesimally small surface will approach
    0.

-   The volume charge will be reduced to a surface charge at the
    interface only as the volume will approach 0. The volume charge
    density is re- placed by a surface charge density *σ~s~* and the
    volume integral is replaced by surface integral over the middle
    surface S^t^.

We obtain:

{S1 {S {Sl

$`\overrightarrow{D}`$~1~ · d**a**~1~ + $`\overrightarrow{D}`$~2~ · d**a**~2~ = *σ~s~* d*a.* (3.7)
>
Now, considering that d**a**~2~ = −d**a**~1~ we can write:

{S ($`\overrightarrow{D}`$~1~ − $`\overrightarrow{D}`$~2~) · d**a**~1~ = {Sl *σ~s~* d*a.* (3.8)

Finally, as S~1~ = S^t^ and d**a**~1~ = **nˆ**~2→1~d*a*~1~ we can
write:
>
**nˆ**~2→1~ · ($`\overrightarrow{D}`$~1~ − $`\overrightarrow{D}`$~2~) = *σ~s~* (3.9)
>
or
>
*D*~1*n*~ − *D*~2*n*~ = *σ~s~* (3.10)
>
The normal component of the vector $`\overrightarrow{D}`$ is in general discontinuous.
It is continuos only if there are no conduction charges at the
separation surface.

__chap5 B vector__

The situation is identical for the vector $`\overrightarrow{B}`$, the only difference
being that the right hand side of the equation is always 0. We
conclude that:
>
**nˆ**~2→1~ · ($`\overrightarrow{B}`$~1~ − $`\overrightarrow{B}`$~2~) = 0 (3.11)
>
or
>
*B*~1*n*~ − *B*~2*n*~ = 0 (3.12)
>
The normal component of $`\overrightarrow{B}`$ is always conserved.

__**Tangential components**__

![](media/image171.jpeg)

Figure 3.2: []{#_bookmark60 .anchor}Contour for deriving boundary
conditions for parallel field com- ponents.

__chap5 E vector__

We integrate the third Maxwell equation around the rectangular contour
C that straddles the boundary of width W and thickness *δ* as shown in
figure [3.2.](#_bookmark60) We chose to integrate the line integral
following the right-hand sense relative to the surface normal
**nˆ***~a~*. By letting *δ* → 0, we get
>
t $`\overrightarrow{E}`$ · *d***l** = $`\overrightarrow{E}`$~1~ · *A_B* + $`\overrightarrow{E}`$~2~ · *C_D* = −
[d]{.underline} { $`\overrightarrow{B}`$ · *d*$`\overrightarrow{S}`$ → 0 (3.13)
>
as the line integral along the sides goes to zero and the flux of the
induction field $`\overrightarrow{B}`$, which is a finite quantity, approaches 0.
Considering that *C_D* =
>
−*A_B* = d**l**, we get:
>
($`\overrightarrow{E}`$~1~ − $`\overrightarrow{E}`$~2~) · d**l** = 0 ∀d**l** /I to the separation
surface (3.14)
>
or again

*E*~1*T*~ − *E*~2*T*~ = 0 (3.15)

i.e. the tangential components of the electric field are always
conserved at the interface. This condition can also be written:
>
**nˆ**~2→1~ ***×*** ($`\overrightarrow{E}`$~1~ − $`\overrightarrow{E}`$~2~) = 0*.* (3.16)

__chap5 H vector__

Following the same reasoning as for the $`\overrightarrow{E}`$ vector we write for the
left hand
>
side when *δ* → 0: $`\overrightarrow{H}`$

C

· *d***l** = $`\overrightarrow{H}`$

~1~ · *A_B*

\+ $`\overrightarrow{H}`$~2~ · *C_D.*
>
(3.17)
>
The right hand side needs more attention. The flux of the vector $`\overrightarrow{D}`$
approaches
>
0\. However the flux of the vector $`\overrightarrow{j}`$ over an infinitesimal surface
can give a finite value: the surface integral reduces to an integral
over the line of width W equal to the side of the rectangle. No volume
current can contribute, however a surface current $`\overrightarrow{j}`$*~s~* (i.e. a
current flowing on the separation surface with dimensions \[*A/m*\]
not \[*A/m*^2^\] as $`\overrightarrow{j}`$) can. This is typically the case of a
perfect conductor where a finite current can flow through a
infinitesimally small area. We get:
>
or again
>
($`\overrightarrow{H}`$~1~ − $`\overrightarrow{H}`$~2~) · d**l** = *J~s~* (3.18)
>
*H*~1*T*~ − *H*~2*T*~ = *J~s~* (3.19)
>
i.e. the tangential components of the magnetic field $`\overrightarrow{H}`$ is
discontinuous unless no surface currents exist. As for the electric
field, this condition can also be written:
>
**nˆ**~2→1~ ***×*** ($`\overrightarrow{H}`$~1~ − $`\overrightarrow{H}`$~2~) = $`\overrightarrow{j}`$*~s~* (3.20)

#### chap2 Reflection and transmission at normal incidence

We suppose that the *xy* plane at *z* = 0 is the boundary between
medium 1 and medium 2. A plane wave of angular frequency *ω*
travelling in medium 1 in the positive *z* direction and polarised
along the *x* axis makes a normal incidence at the interface with
medium 2.

##### Case 1: perfect dielectric/perfect conductor

We will first consider the case of a normal incidence for a wave
travelling in vacuum (a particular case of a perfect dielectric with
*ε* = *ε*~0~, *n* = 1, *µ* = *µ*~0~) at the interface with a perfect
conductor. For the perfect conductor, as *σ* , its penetration depth
*δ* 0, i.e. no electromagnetic field can exist inside it. No
transmission can occur, the wave is totally reflected. The incident
and reflected waves are:

*i*

**[B]{.underline}***i* = *B*0 e*i*(*kz*−*ωt*)**ˆe***y* =
>
*i* e*i*(*kz*−*ωt*)**ˆe***y*
>
(3.21)
>
medium 1 perfect dielectric
>
$`\overrightarrow{E}`$*~i~*

$`\overrightarrow{B}`$*~i~* **k***~i~*

**k***~r~*

\", µ

![](media/image172.png)$`\overrightarrow{E}`$*~r~* $`\overrightarrow{B}`$*~r~*

medium 2 perfect conductor
>
![](media/image174.png)
>
$`\overrightarrow{j}`$*~s~* O y **n**ˆ
>
Figure 3.3: Left: Normal incidence at the boundary between a perfect
dielec- tric and a perfect conductor. Right the total fields at a few
different times.

and

0 *i*(*kz*+*ωt*) *r*
>
**[B]{.underline}***r* = *B*0 e−*i*(*kz*+*ωt*)**ˆe***y*
>
(3.22)
>
Using the boundary conditions at the interface (*z* = 0) we have:
>
*E~T~* ~1~ − *E~T~* ~1~ = 0 ⇒ $`\overrightarrow{E}`$*~T~* ~1~ = $`\overrightarrow{E}`$*~i~* + $`\overrightarrow{E}`$*~r~*
= 0 ⇒ *E*^0^ = −*E*^0^
>
(3.23)
>
as the boundary conditions are valid in any point of the surface and
at any time. We cab therefore write the reflected wave as:
>
*i* 0
>
**[B]{.underline}***r* = *B*0e−*i*(*kz*+*ωt*)**ˆe***y* = *i y*
>
(3.24)
>
In medium 1 we have a superposition of the incident and reflected
waves. The total wave is given by:
>
 $`\overrightarrow{E}`$*~tot~* = $`\overrightarrow{E}`$*~i~* + $`\overrightarrow{E}`$*~r~* = *E*^0^ (*e^ikz^* −
*e*^−*ikz*^l *e*^−*iωt*^ = 2*iE*^0^ sin(*kz*)*e*^−*iωt*^**ˆe***~x~*
>
(3.25)

*i* *i*

or in real notation

f $`\overrightarrow{E}`$*~tot~* = 2*E*^0^ sin(*kz*) sin(*ωt*)**ˆe***~x~*

*tot*

*i kz*
>
*ωt ~y~*
>
This wave represents a **stationary wave**1: a wave the oscillates in
place. The nodes and antinodes of the electric field and magnetic
field are out of phase
>
1Be careful not to confuse a stationary wave with an evanescent wave.
>
by *π/*2. In particular the electric field has a node at the interface
(imposed by the boundary conditions) and the magnetic field as instead
an antinode at the interface. A stationary wave does not transport any
net energy. This can be readily understood as as much energy is
carried by the incident wave from right to left as the reflected one
in the opposite direction. Calculating the Poynting vector we have:
>
$`\overrightarrow{S}`$ = [$`\overrightarrow{E}`$*tot **×***]{.underline} [$`\overrightarrow{B}`$*tot*]{.underline} =
*E*0*B*0 sin(2
>
) sin(2
>
)**ˆe**
>
(3.27)
>
*tot µ*0
>
*[i i]{.underline} kz µ*~0~
>
*ωt ~z~*
>
which at any point *z* changes direction periodically. Its
time-averaged values is indeed *\<* $`\overrightarrow{S}`$*~tot~ \>~t~*= 0.
>
Due to the discontinuity of the magnetic field, a surface current
density must

![](media/image175.png)![](media/image176.jpeg){width="2.4469674103237096in"
height="1.3326695100612422in"}E*max* E*min*

Figure 3.4: Left: The incident, reflected and resulting wave at a
particular time. Right: The superposition of several resulting waves
at different times. See the video of the simulation on the [moodle
page.](https://moodle.insa-toulouse.fr/course/view.php?id=621)
>
be present at the interface. Using the fourth boundary condition we
get:
>
**nˆ *× ***($`\overrightarrow{H}`$~1~ − 0) = $`\overrightarrow{j}`$*~s~*
>
⇒ $`\overrightarrow{j}`$*~s~* = −*n***ˆe***~z~ **×***
>
[*B~tot~*(*z* = 0)]{.underline}**ˆe** =
>
*µ*0 *y*
>
2*E*0 cos( )**ˆe**
>
*µ c*

0

##### Case 2: 2 perfect dielectrics

We are dealing now with two perfect dielectrics. For the discussion we
will consider that the materials are non-magnetic (*µ* = *µ*~0~) and
that no charges nor currents exist at the interface (*σ~s~* = 0*,*
$`\overrightarrow{j}`$*~s~* = 0). The incident ware is given by
>
f **[E]{.underline}***i* = *E*0 e*i*(*k*~1~*z*−*ωt*)**ˆe***x*
>
*E*^0^*n*
>
(3.28)
>
**[B]{.underline}***i* = *B*0 e*i*(*k*~1~*z*−*ωt*)**ˆe***y* = *i* 1
e*i*(*k*1*z*−*ωt*)**ˆe***y*
>
![](media/image177.png) ![](media/image180.png)
>
Figure 3.5: Left: Normal incidence at the boundary between twp perfect
dielectrics. Right the total fields in medium 1 at a few different
times showing a partial standing wave. The minimum amplitude of
$`\overrightarrow{E}`$*~tot~* is no more 0.
>
where **k**~1~ and *n*~1~ are the wavevecvtor and refractive index of
medium 1. The reflected and transmitted waves are:
>
**[E]{.underline}***r* = *E*0 e−*i*(*k*~1~*z*+*ωt*)**ˆe***x*

0

(3.29)
>
**[B]{.underline}***r* = *B*0 e−*i*(*k*~1~*z*+*ωt*)**ˆe***y* = − *Er
n*1
>
e−*i*(*k*~1~*zωt*)**ˆe***y*

and

*r c*
>
**[E]{.underline}***t* = *E*0 e*i*(*k*~2~*z*−*ωt*)**ˆe***x*

0

(3.30)

**[B]{.underline}** = *B*0 e*i*(*k*~2~*z*−*ωt*)**ˆe***y* = *Et n*2
e*i*(*k*~2~*z*−*ωt*)**ˆe***y*

*t t c*
>
We need now two boundary conditions to determine the reflected and
trans- mitted waves. Using the tangential boundary conditions for
$`\overrightarrow{E}`$ and $`\overrightarrow{H}`$ we have:

f *E*^0^ + *E*^0^ = *E*^0^

(3.31)

*n*~1~(*Ei* − *Er* ) = *n*~2~*Et*

Solving for *E*^0^ and *E*^0^ we obtain:
>
*r t*

 *E*0 = *n*1−*n*2 *E*0

 *E*0 = 2*n*1 *E*0

We can now define the
>
*t n*~1~+*n*~2~ *i*

-   Reflection coefficient *r* = *^E^*0 = [*n* −*n*]{.underline}

and
>
*r*0 1 2

*E n*~1~+*n*~2~

-   the Transmission coefficient *t* = *^E^*0 = [2*n *]{.underline} .

0 *n* 1
>
*E* 1+*n*2

#### chap2 Reflection and transmission at oblique incidence

We now turn to the more general case of an oblique incidence at an
arbitrary angle *θ~i~*. Before that we will need a few definitions and
considerations.

![](media/image182.png)Figure 3.6: Plane of incidence, *s* and *p*
polarisations.

##### chap5 Plane of incidence

We first define the **plane of incidence** as the plane the contains
the incidence wavevector and the normal to the interface separating
the two materials. Let's consider a linearly polarised plane wave
making an oblique incidence at the interface between medium 1 and 2.
Two special cases arise:

-   if $`\overrightarrow{E}`$*~i~* is contained in the plane of incidence, the wave is
    said to be *p* (for parallel to the plane of incidence) or again
    Transverse Magnetic (TM) as the magnetic field will be
    perpendicular to the plane of incidence. The symbol "/I" is also
    often used.

-   if $`\overrightarrow{E}`$*~i~* is perpendicular to the plane of incidence, the wave
    is said to be *s* (for the german word for perpendicular - to the
    plane of incidence) or Transverse Electric (TE). The symbol "⊥" is
    used in this case.

Any other polarisation state can be decomposed into the sum of a TM
and TE wave.

##### chap5 Laws of reflection and refraction

We will derive here the laws of reflection and refraction by making
use of the boundary conditions which are independent on the
polarisation of the incident wave. W will not make any assumption on
the wavevector and frequencies of the wave. We implicitly assumed in
the previous section that the frequen- cies are the same as the
wavevectors's moduli in the same medium. We will
>
demonstrate it here. Let's consider the the general situation as of an
inci- dent, reflected and refracted wave as depicted in figure
[3.7.](#_bookmark64) The three plane

![](media/image183.png)

Figure 3.7: []{#_bookmark64 .anchor}General case of reflection and
refraction
>
monochromatic wave are:
>
**[E]{.underline}***i* = $`\overrightarrow{E}`$0*ei*(**k***~i~*·**r**−*ωt*)
>
**[E]{.underline}** = $`\overrightarrow{E}`$0*ei*(**k***r* ·**r**−*ω*^l^*t*)
**[E]{.underline}** = $`\overrightarrow{E}`$0*ei*(**k***t*·**r**−*ω*^ll^*t*)
>
The boundary conditions are applied to the interface (*z* = 0) and
must be valid for **all points on the interface** and **for all
times**.
>
In *z* = 0, for the tangential component of the electric field we
have:
>
0 *ei*(**k***~i~*·**r***~s~*−*ωt*) + $`\overrightarrow{E}`$0
>
*ei*(**k***r* ·**r***s*−*ω*^l^*t*) = $`\overrightarrow{E}`$0
>
*ei*(**k***t*·**r***s*−*ω*^ll^*t*) (3.35)
>
where **r***~s~* is a vector on the interface.

i.  For this condition to be valid *t* we must have *ω* = *ω*^t^ =
    *ω*^tt^. As a consequence we have

\|**k***~i~*\| = \|**k***~r~*\| = *[ω]{.underline} n*~1~ (3.36)

\|**k***~t~*\| = *[ω]{.underline} n*~2~ (3.37)

ii. For this condition to be valid []{#_bookmark65 .anchor}∀**r***~s~*
    we must have:

**k***~i~* · **r***~s~* = **k***~r~* · **r***~s~* = **k***~t~* ·
**r***~s~* (3.38)
>
Taking the first two terms we can write

(**k***~i~* − **k***~r~*) · **r***~s~* = 0*.* (3.39)

As **r***~s~* belongs to the interface, (**k***~i~* **k***~r~*) is
normal to it. This means that the vectors **k***~i~*, **k***~r~* and
the normal belong to the same plane, i.e. the plane of incidence.

iii. Equation [3.38](#_bookmark65) can be recast as

*x*(*k~i~*)*~x~* + *y*(*k~i~*)*~y~* = *x*(*k~r~*)*~x~* +
*y*(*k~r~*)*~y~* = *x*(*k~t~*)*~x~* + *y*(*k~t~*)*~y~* ∀*x, y* (3.40)
>
These relations can be satisfied only if all the *x* and *y*
components are the same. Taking the *x* components we can write

a.  (*k~i~*)*~x~* = \|*k~i~*\| sin *θ~i~*

b.  (*k~r~*)*~x~* = \|*k~r~*\| sin *θ~r~*

c.  (*k~t~*)*~x~* = \|*k~t~*\| sin *θ~t~*

From the first two relations we get *θ~i~* = *θ~r~* as \|*k~i~*\| =
\|*k~r~*\|.
>
From the first and the third we get \|*k~i~*\| sin *θ~i~* = \|*k~t~*\|
sin *θ~t~* or

#### chap2 Fresnel's laws & Brewster's angle

From the previous section we can write the incident, reflected and
transmitted waves as:
>
**[E]{.underline}***i* = $`\overrightarrow{E}`$0*ei*\[**k**~1~(*x* sin *θ*~1~+*z* cos
*θ*~1~)−*ωt*\] **[E]{.underline}***r* = $`\overrightarrow{E}`$0*ei*\[**k**~1~(*x* sin
*θ*~1~−*z* cos *θ*~1~)−*ωt*\] **[E]{.underline}***t* =
$`\overrightarrow{E}`$0*ei*\[**k**~2~(*x* sin *θ*~2~+*z* cos *θ*~2~)−*ωt*\]
>
where the indices "1" and "2" indicate the first and second medium
physical quantities. We will now separate the discussion for a TE and
a TM wave. Due to the isotropic nature of the media considered here, a
TE incident wave will give rise to TE reflected and transmitted waves.
Likewise for a TM incident wave.

##### chap3 TE Wave TM Wave

![](media/image184.png) ![](media/image187.png)
>
Figure 3.8: []{#_bookmark67 .anchor}Configuration for a TE and TM
incidence.

__**chap5 TE Wave**__

$`\overrightarrow{E}`$ is tangential and $`\overrightarrow{B}`$ is contained in the plane of incidence.
From figure [3.8](#_bookmark67) we can write using the two tangential
boundary conditions and the relations $`\overrightarrow{B}`$ = *µH*, \|$`\overrightarrow{B}`$\| =
^[\|$`\overrightarrow{E}`$\|]{.underline}^ *n*:
>
 *n*1 (*E*^0^ − *E*^0^) cos *θ*~1~ = *n*2 *E*^0^ cos *θ*~2~
>
As before, we define the reflection and transmission coefficient for a
TE ( or

s)  wave as:

*E*0 *E*0

*r*~⊥~ = *^[r]{.underline}^ , t*~⊥~ = *^[t]{.underline}^ ,* (3.42)
>
0 0

*i* *i*

which by solving the previous equations can be evaluated to:
>
 *n*1 cos *θ*~1~ − *n*2 cos *θ*~2~
>
cos *θ*~1~ + cos *θ*~2~ *µ*~1~ *µ*~2~
>
[2*n*1]{.underline} cos *θ*~1~
>
*µ*~1~

*.* (3.43)

*t*⊥ = *n*~1~ *n*~2~
>
cos *θ*~1~ + cos *θ*~2~ *µ*~1~ *µ*~2~

__**chap5 TM Wave**__

$`\overrightarrow{E}`$ is s contained in the plane of incidence and $`\overrightarrow{B}`$ is
transverse. From figure [3.8](#_bookmark67) we can write using the two
tangential boundary conditions and the relations $`\overrightarrow{B}`$ = *µH*,
\|$`\overrightarrow{B}`$\| = ^[\|$`\overrightarrow{E}`$\|]{.underline}^ *n*:

 *n*1 (*E*^0^ − *E*^0^) = *n*2 *E*^0^ *.*

Solving the system we obtain the reflection and transmission
coefficients for a TM (/I or *p*) wave as:

 *n*1 cos *θ*~2~ − *n*2 cos *θ*~1~

cos *θ*~1~ + cos *θ*~2~ *µ*~2~ *µ*~1~
>
[2*n*1]{.underline} cos *θ*~1~
>
*µ*~1~

*.* (3.44)

*t*I/ = *n*~2~ *n*~1~



chap4 Brewster's angle

cos *θ*~1~ + cos *θ*~2~ *µ*~2~ *µ*~1~
>
Let's make a few considerations on the consequences of the Fresnel
relations by plotting the reflection coefficients for *s* and *p*
polarisations. We, first of all, separate the two cases according to
the relative value of the two media refrac- tive indices *n*~1~ and
*n*~2~. By using Snell-Descartes law *n*~1~ sin(*θ*~1~) = *n*~2~
sin(*θ*~2~) we have that

a.  If *n*~1~ *\< n*~2~ −→ *θ*~1~ *\θ*~2~

b.  If *n*~1~ *\n*~2~ −→ *θ*~1~ *\< θ*~2~

chap5 Case a)

In this case, we consider the range 0 *θ*~1~ *π/*2 for the incident
angle *θ*~1~. Correspondingly, the refraction angle *θ*~2~ will vary
in the range 0 *θ*~2~ *θ*2*max*. Using Snell we have:

i.  For *θ*~1~ = 0 → *θ*~2~ = 0, =⇒ *r*~⊥~ = *r*I/ =
    [*n*1−*n*2]{.underline} *\<* 0.

n~1~ \< n~2~ n~1~ \n~2~

![](media/image190.png)

Figure 3.9: The snell law for *n*~1~ *\< n*~2~ and *n*~1~ *\n*~2~.
>
1.0
>
n~1~ = 1
>
1.0
>
0.8
>
0.5 n~2~ = 1.5 ✓*B*
>
0.0
>
0.6
>
0.4
>
-0.5
>
-1.0
>
r*~?~*
>
r*~k~*

0 20 40

60 80
>
0.2
>
0.0

0 20 40

60 80
>
Angle of incidence (deg) Angle of incidence (deg)

1.0

0.5

0.0

-0.5

-1.0

0 20

40 60 80
>
1.0
>
0.8
>
0.6
>
0.4
>
0.2
>
0.0

0 20

40 60 80
>
Angle of incidence (deg) Angle of incidence (deg)
>
Figure 3.10: []{#_bookmark68 .anchor}Plot of the reflection
coefficients (*r*~⊥~ and *r*I/) and the correspond- ing reflectivities
(*R*~⊥~ and *R*I/) for case a (top) and case b (bottom).

ii. For *θ*~1~ = *π/*2 → *θ*~2~ = *θ*2*max* =⇒ *r*~⊥~ = −1 and *r*I/ =
    +1

This signifies that for the particular angle *θ~B~* (the Brewster's
angle) *r*I/(*θ~B~*) = 0, as shown in figure [3.10.](#_bookmark68) By
plotting the reflectance (*R* = \|*r*\|2), we see that
>
no reflection occurs for *p*-polarised wave for *θ*~1~ = *θ~B~* and
the reflection for *p* waves is, in any case, much smaller than the
reflections for *s* waves for angles close to *θ~B~*. This phenomenon
suggests different applications:

-   The possibility of polarising unpolarised waves by reflection for an
    inci- dence angle *θ* = *θ~B~*: the reflected wave will be 100%
    linearly polarised while the transmitted one only partially
    polarised (see figure [3.11).](#_bookmark69)

-   The possibility of removing unwanted reflections by using polarisers
    (Po- laroid sun-glasses for instance, figure
    [3.12);](#_bookmark70)

-   The possibility of transmitting 100% of the intensity of an incident
    wave thought an interface using a proper polarisation and
    incidence angle.

![](media/image191.png){width="2.991770559930009in"
height="2.5861450131233594in"}

Figure 3.11: []{#_bookmark69 .anchor}An illustration of the
polarisation of light that is incident on an interface at Brewster's
angle.
[https://en.wikipedia.org/wiki/Brewster'](https://en.wikipedia.org/wiki/Brewster%27s_angle)
[s_angle](https://en.wikipedia.org/wiki/Brewster%27s_angle)

chap5 Case b)

In this case, total reflections will occur for angles *θ*~1~
*θ*1*lim*. The considera- tions on the Brewster's angle stated above
will still hold.
>
The condition *r~p~* = 0 inserted in the Fresnel equation gives
>
*n*~1~ cos *θ*~2~ = *n*~2~ cos *θ~B~* (3.45) while from Snell's law we
have
>
*n*~2~ sin *θ*~2~ = *n*~1~ sin *θ~B~.* (3.46)
>
![](media/image4.jpeg){width="3.0679155730533685in"
height="0.9943744531933508in"}
>
Figure 3.12: []{#_bookmark70 .anchor}Photographs of a window taken
with a camera polariser filter rotated to two different angles. In the
picture at left, the polariser is aligned with the polarisation angle
of the window reflection. In the picture at right, the polariser has
been rotated 90° eliminating the heavily polarised reflected sunlight.
[https://en.wikipedia.org/wiki/Brewster's_angle](https://en.wikipedia.org/wiki/Brewster%27s_angle)
>
By multiplying the left and the right terms of the previous equations
together we get
>
sin 2*θ~B~* = sin 2*θ*~2~ (3.47)
>
which gives as only possible solution *θ~B~* + *θ*~2~ = *π/*2 ( i.e.
the transmitted and reflected beams are perpendicular, see figure
[3.11)](#_bookmark69) and *θ~B~* = arctan [*n*2]{.underline} . It is
>
easy to show that *θ~B~ \< θ*1*lim*, i.e. the Brewster's angle is
always smaller than the limit angle for total reflection.

chap4 Total internal reflection

Let's consider the oblique incidence shown in figure
[3.8.](#_bookmark67) The transmitted field is given by
>
$`\overrightarrow{E}`$*t* = $`\overrightarrow{E}`$0*ei*\[(*k*~2~)*~x~x*+(*k*~2~)*~z~z*−*ωt*\] (3.48)
>
Using the boundary conditions we have previously found that
>
[]{#_bookmark71 .anchor}( 2 *ω*2 2

*k*~2~)*~x~* = (*k*~1~)*~x~* = *k*~1~ sin *θ*~1~ and *k*2 = *n*2*.*
(3.49)

*c*2
>
Using this relation we can write

(*k*~2~)2 = *k*^2^ − (*k*~2~)2 = *[ω]{.underline}* (*n*^2^ − *n*^2^ sin2
*θ*~1~) *.* (3.50)

When the incidence occurs at the limit angle *θ*~1~ = *θ*1*lim*, Snell
law gives *n*~2~ = *n*~1~ sin *θ*1*lim*. If now we increase the
incidence angle, we have *θ*~1~ *\θ*1*lim* and thus *n*~2~ *\< n*~1~
sin *θ*~1~ or *n*^2^ − *n*^2^ sin2 *θ*~1~ *\<* 0. Plugging this into
equation [3.49,](#_bookmark71) we
>
obtain:
>
2 1

(*k*~2~)

= *i[ω]{.underline}* j*n*^2^ sin2 *θ*~1~ − *n*^2^
>
(3.51)
>
i.e. (*k*~2~)*~z~* is purely imaginary and the transmitted wave
becomes:
>
$`\overrightarrow{E}`$*t* = $`\overrightarrow{E}`$0*ei*\[(*k*~2~)*~x~x*−*ωt*\]*e*−(*k*~2~)*~z~z* (3.52)
>
The wave has a propagating character in the *x* direction and an
evanescent character in the *z* direction. Let's consider the case of
a TE wave. The Fresnel relation gives
>
*r* = [*n*~1~ cos *θ*~1~ − *n*~2~ cos *θ*~2~]{.underline} =
[(*k*~1~)*~z~* − (*k*~2~)*~z~*]{.underline}
>
(3.53)

⊥ *n*~1~ cos *θ*~1~ − *n*~2~ cos *θ*~2~ (*k*~1~)*~z~* + (*k*~2~)*~z~*

As (*k*~2~)*~z~* is purely imaginary we have, as expected,
>
\|*r*~⊥~\| = 1 (3.54)
>
but also

*r*~⊥~ = \|*r*~⊥~\|*e^iφ^* = *e^iφ^* (3.55)

i.e. the reflected wave is totally reflected with a phase shift.

chap2 Oblique incidence onto a perfect conductor

We consider now a linearly polarised plane wave travelling in a
perfect dielec- tric making an oblique incidence onto a perfect
conductor. The case of vacuum is trivially obtained by setting the
refractive index *n* = 1. These calculations will serve as a basis for
the next chapter, which deals with rectangular metal- lic waveguides.
This is the reason why we adopt here a different frame with respect to
the previous sections. Once again we will deal with TE and TM waves
separately. As before, being the second medium a perfect conductor, no
electromagnetic fields can exists in it. We will deal only with the
incident and reflected fields.

chap5 TE Wave Incident fields

Considering the situation depicted in figure [3.13,](#_bookmark74) the
incident wavevector is given by:

0

1

**k***~i~* = −*k* cos *θ*

*,* (3.56)
>
1 *k* sin *θ*
>
$`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ fields form the picture (or using the plane wave rule
**[B]{.underline}***~i~*
>
we obtain[2](#_bookmark73):
>
= [**k***~i~ **×***]{.underline} $`\overrightarrow{E}`$*~i~* ),

*ω*

**[E]{.underline}***i* = []{#_bookmark73 .anchor}−*E*0 e*i* (−*ky* cos
*θ* + *kz* sin *θ* − *ωt*)**ˆe***x* (3.57)
>
2there is "-" sign in front of the fields as the chosen electric field
drawn in figure [3.13](#_bookmark74) is antiparallel to the *x* axis.

chap3 TE Wave TM Wave

![](media/image192.png)![](media/image194.png)

Figure 3.13: []{#_bookmark74 .anchor}Configuration des champs ´e.m
pour le mode TE.
>
and
>
$`\overrightarrow{B}`$ = 1
>
*i* 1
>
0
>
− *nE*0 sin *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
*,* (3.58)

chap5 Reflected fields

1 − *nE*0 cos *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
The reflected electric field **[E]{.underline}***~r~* = *E*~0~ e*i*
(*ky* cos *θ* + *kz* sin *θ* − *ωt*)**ˆe***~x~* is obtained by
repeating the same procedure. Considering that the incident and
reflected angles are the same, we have:

0

1

**k***~r~* = *k* cos *θ ,*

1

1 *k* sin *θ*
>
In addition, applying the boundary condition to the tangential
component of the electric field (which is here the total electric
field) we have *E~r~x* + *E~i~x* = 0. We finally obtain:

**[E]{.underline}***r* = *E*0e*i* (*ky* cos *θ* + *kz* sin *θ* −
*ωt*)**ˆe***x* (3.59)

and

$`\overrightarrow{B}`$ = 1
>
*r* 1
>
0
>
*nE*0 sin *θ* e*i* (*ky* cos *θ* + *kz* sin *θ ωt*) *c*
>
*.* (3.60)

chap5 Total fields

1 − *nE*0 cos *θ* e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
We calculate now the total fields **[E]{.underline}**
>
= **[E]{.underline}** + **[E]{.underline}** , **[B]{.underline}** =
**[B]{.underline}** + **[B]{.underline}**
>
existing in
>
medium 1 for a TE wave:
>
⊥ *i r* ⊥ *i r*

**[E]{.underline}** = *E*0 (e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*) −
e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)l **ˆe***x* =

= 2*iE*~0~ sin (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)
>
**ˆe***~x~*
>
*.* (3.61)

\'- amp..li,.tude

., \'-
>
propa..g,.ation
>
., pola\'-r..is,.a.,tion
>
The total magnetic field is given by:
>
0
>
1

$`\overrightarrow{B}`$ = 1

2*inE*0 sin *θ* sin (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)
>
*.* (3.62)

**-- [B]{.underline}**~⊥~

= [2*nE*~0~]{.underline} *\_u*
>
*c*
>
cos *θ* e*i* (*kz* sin *θ* − *ωt*), i.e. the magnetic
>
field is parallel to the interface.

-   The fields have a standing wave character along the *y* axis (see
    figure [3.14).](#_bookmark75) The positions of the nodes and
    antinodes plane for the electric field are given by:

    -   $`\overrightarrow{E}`$ = **0** for *y~n~*

*nπ k* cos *θ*

, *n* integer

-   **[E]{.underline}** \| is maximum for *y~p~*

= [(2*p* + 1)*π*]{.underline} , *p* integer.
>
*k θ*
>
![](media/image196.jpeg)same *z* components
>
![](media/image198.png) propagating wave // *z*
>
antiparallel *y* components
>
 standing wave // *y*
>
Figure 3.14: []{#_bookmark75 .anchor}The total electric field
amplitude of a TE wave upon oblique incident onto a perfect conductor.
The field has a propagation character along the *z* axis and a
standing wave character along the *y* axis. A node and an antinode
plane are displayed. The blue and red colours represent the minimum
and maximum of the field amplitude. You can easily reproduce this
pattern with water waves.

chap5 Poynting vector

To this aim it is convenient to revert to the real notation for the
fields:

$`\overrightarrow{E}`$~⊥~ = −2*E*~0~ sin (*ky* cos *θ*) sin (*kz* sin *θ* − *ωt*)
**ˆe***~x~,* (3.63)

and

$`\overrightarrow{B}`$ = 1
>
⊥ 1
>
0
>
−2 *c* sin *θ* sin (*ky* cos *θ*) sin (*kz* sin *θ* − *ωt*)
>
*.* (3.64)
>
1 −2 *c* cos *θ* cos (*ky* cos *θ*) cos (*kz* sin *θ* − *ωt*)
>
Calculating $`\overrightarrow{S}`$ = [$`\overrightarrow{E}`$⊥ ***×***]{.underline} [$`\overrightarrow{B}`$⊥]{.underline}

*µ*~0~

1

we obtain:

0

$`\overrightarrow{S}`$ = − *µ c θ*
>
*ky θ*
>
*kz θ* − *ωt*
>
*.* (3.65)

*nE*^2^

4 sin *θ µ*~0~*c*
>
sin2
>
(*ky*
>
cos

*θ*) sin2

(*kz*
>
sin

*θ* − *ωt*)

while its time average is:

($`\overrightarrow{S}`$)*~t~* =

2
>
[0]{.underline} sin *θ* sin2
>
*µ*~0~*c*
>
(*ky* cos *θ*) **ˆe***~z~* (3.66)
>
Power is therfore carried along the positive *z* direction and is null
on the nodal planes.

chap5 TM wave

The discussion is similar to the TE case with the role of $`\overrightarrow{E}`$ and
$`\overrightarrow{B}`$ exchanged. Referring to figure [3.13](#_bookmark74) we have
again for the wavevectors:
>
0 0
>
1 1
>
**k***~i~* = −*k* cos *θ*

1 *k* sin *θ*

*,* **k***~r~* = *k* cos *θ ,*
>
1 *k* sin *θ*

$`\overrightarrow{E}`$*~i~* = 1

1

0
>
*E*0 sin *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
*.* (3.67)

and

1 *E*0 cos *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
**[B]{.underline}** = − [*nE*0]{.underline} e*i* (−*ky* cos *θ* + *kz*
sin *θ* − *ωt*)**ˆe**

*,* (3.68)

Using the boundary condition for the tangential component of the
electric field *E~r~z* + *E~i~z* = 0 and the fact the field experience
total reflection, $`\overrightarrow{E}`$*~i~* = $`\overrightarrow{E}`$*~r~* we obtain:

$`\overrightarrow{E}`$*~r~* = 1

1

0
>
*E*0 sin *θ* e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
*.* (3.69)
>
and
>
1 −*E*0 cos *θ* e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
**[B]{.underline}** = − [*nE*0]{.underline} e*i* (*ky* cos *θ* + *kz*
sin *θ* − *ωt*)**ˆe**

*.* (3.70)

Finally, the total fields existing in medium 1 for a TM ( or *p*) wave
are given by:
>
$`\overrightarrow{E}`$ = 1
>
I/ 1
>
0
>
2*E*~0~ sin *θ* cos (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)
>
*.* (3.71)
>
and
>
1 −2*iE*~0~ cos *θ* sin (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)

**[B]{.underline}**~I/~

= −2 [*nE*0]{.underline} cos (*ky* cos *θ*) e*i* (*kz* sin *θ* −
*ωt*)**ˆe** *.* (3.72)
>
The same remarks made for the total TE wave can repeated here for the
total TM wave we the appropriate changes for the role of the $`\overrightarrow{E}`$ and
$`\overrightarrow{B}`$ fields.

**-- [B]{.underline}**~I/~

= − [2*nE*0]{.underline} e*i* (*kz* sin *θ* − *ωt*)**ˆe**

, i.e. the magnetic field is

parallel to the interface.

-   The electric fields have a standing wave character along the *y*
    axis (see figure [3.14).](#_bookmark75) The positions of the nodes
    and antinodes planes for the magentic fields are given by:

**-- [B]{.underline}**~I/~

= **0** for *y~n~*
>
= [(2*n* + 1)*π*]{.underline} , *n* integer.
>
*k θ*
>
**--** \|**[B]{.underline}**~I/~\| is maximum for *y~p~*
>
= *[pπ]{.underline}* , *p* integer.
>
*k θ*

Finally, the time-averaged Poytining vector is given by:

2*E*^2^*n*

[0]{.underline} 2

($`\overrightarrow{S}`$)*~t~* =

sin *θ* cos
>
*µ*~0~*c*
>
(*ky* cos *θ*) **ˆe***~z~* (3.73)
>
[]{#_bookmark76 .anchor}**Chapter 4**

# Metallic waveguides

chap2 Introduction

We propose to study in this chapter the conditions for propagation of
elm radiation in conductive rectangular waveguides and to identify the
main char- acteristic of this kind of propagation. We will introduce a
"practical approach" based on the previous chapter's results.

chap2 Practical approach

We have seen in the previous chapter that the oblique incidence of
plane waves on planar conductive materials gives rise to an
interference pattern between the incident and reflected waves such
that the resulting wave has propagating character along the *z* axis
and a standing wave pattern along the *y* axis (see figure
[4.1).](#_bookmark81) For TE modes we have:

[]{#_bookmark79 .anchor}$`\overrightarrow{E}`$~⊥~ = −2*E*~0~ sin (*k y* cos *θ*) sin
*k* sin *θ z* − *ωt***ˆe***~x~* (4.1)

and
>
\'-
>
[]{#_bookmark80 .anchor}0 2
>
*amp*..*li*,.*tude* .,
>
*wa*\'-*ve*..*v*,.*ec*.,*tor*
>
− 2*E*0 cos *θ* cos (*k y* cos *θ*) cos (*k z* sin *θ* − *ωt*) and
similarly for TM modes:

0

$`\overrightarrow{E}`$~I/~ = 2*E*~0~ sin *θ* cos(*k y* cos *θ*) cos(*k z* sin *θ* −
*ωt*)

−2*E*~0~ cos *θ* sin(*k y* cos *θ*) sin(*k z* sin *θ* − *ωt*)

(4.3)

$`\overrightarrow{B}`$~I/~ = −2*E*~0~ sin (*k y* cos *θ*) sin (*k z* sin *θ* − *ωt*)
**ˆe***~x~* (4.4)

73

![](media/image199.png)
![](media/image201.png){width="1.753584864391951in"
height="1.7708333333333333in"}
>
![](media/image202.png)![](media/image204.png)Figure 4.1:
[]{#_bookmark81 .anchor}TE and TM waves and their corresponding
standing wave be- haviour along the *y* axis.
>
These results are dictated by the boundary conditions at the air-metal
inter- face which impose that for every point on the boundary surface
and for all times the tangential component of the electric field
(incident + reflected) and the perpendicular component of the
induction field (incident + reflected) to be zero: $`\overrightarrow{E}`$*~t~* = 0 and
$`\overrightarrow{B}`$*~n~* = 0.
>
For TE modes this results in the fact that the total electric field
$`\overrightarrow{E}`$~⊥~ (it is
>
only tangential by definition) has nodes for *y* = *[nπ]{.underline}
[nπ]{.underline}*

*y*

*[nλ]{.underline}*
>
2 cos *θ*
>
where
>
*k~y~* = *k* cos *θ* is the *y* component of the wavevector. For TM
modes, we have instead $`\overrightarrow{E}`$ *~,z~* = 0 as the *z* component of the
total electric field represents the tangential component.
>
As the tangent component of the electric field is zero in the nodal
planes
>
*y* = *[π]{.underline} ,* [2*π*]{.underline} *,* [3*π*]{.underline}
>
. . . for TE and TM modes, placing a new conducting plate at
>
*ky ky ky*
>
the position of these planes would not disturb the total electric
field. Let's for instance place a conductive plate at the position of
the first node *y* = *b* = *[π]{.underline}* for a TE wave. We can see
that the incident wave, after striking the first plate will be
reflected towards the second plate where now will replicate the same
refection phenomenon with exactly the same incident angle and
automatically
>
satisfying the boundary conditions for the electric field: we have
obtained the confinement of the wave, i.e. the wave is guided.

chap4 Rectangular waveguides

Now, let's add two more conducting plates perpendicularly to the
previous ones, i.e. two new plates parallel to the *y* axis. The
boundary conditions to be satisfied at the new surfaces are:
>
$`\overrightarrow{E}`$*~t~* = 0 ⇒ *E~y~* = 0*, E~z~* = 0;
>
$`\overrightarrow{B}`$*~n~* = 0 ⇒ *B~x~* = 0
>
For **TE modes**, according to eq: [4.1](#_bookmark79) we have that
*E\_ x* and the only condition imposed on the electric field is that
its tangent component must be null, its perpendicular component can
well be discontinue. For the magnetic field (eq: [4.2),](#_bookmark80)
*B~x~* = 0 is already satisfied. In summary, nothing changes for the
electric or magnetic fields, but we have totally confined the
radiation in the *x* and *y* directions.
>
For **TM modes** (at least for TM~*m,*0~ or TM~0*,n*~, see later for
the definition of these modes), the boundary conditions cannot be
satisfied (try to show it). In what follows we will consider for
simplicity only the case of TE modes.

![](media/image206.png)

Figure 4.2: Rectangular waveguide with a TE mode.

chap2 TE modes

chap4 Mode numbering

In the previous example, we have chose the orientation of the frame to
describe the rectangular waveguide such that the successive reflection
of the electric field intervene between the conducting plates placed
at *y* = 0 and *y* = *b* where *b* = *[nλ]{.underline}* . We will
describe this wave as a TE~0*,n*~ which signifies that the reflection
occurs between the plates placed at *y* = 0 and *y* = *b* and that
>
![](media/image212.png) ![](media/image213.png)
>
![](media/image214.png) ![](media/image218.png)

Figure 4.3: The mode numbering convention.

there are *n* antinodes of the electric field standing wave between
these plates. Obviously the situation will be formally identical if
now we decide to force the successive refections along the other
conducting plates placed now at *x* = 0

and *x* = *a* where *a* = *[mλ]{.underline}* if the wave is TE for
**that reflection**: The electric

field must be now oriented along the *y* direction in order to be a TE
wave **for these new plates**.We will describe this wave as a
TE~*m,*0~ which signifies that the reflection occurs between the
plates placed at *x* = 0 and *x* = *a* and that there are *m*
antinodes of the electric field standing wave between these plates. If
two TE waves are simultaneously excited in the system (each one being
TE for its respective incidence), than we will describe this wave as a
TE*~m,n~*.

chap4 Properties of the confined modes

Let's try to find the dispersion relation of a rectangular waveguides
with a few simple considerations on TE~0*,n*~ waves in a waveguide
with dimensions *y* = *b* and *x* = *a*:

-   The wave is propagating in air (or vacuum for simplicity). The wave
    must satisfy the usual wave equation and dispersion relation *k* =
    *[ω]{.underline}* with

*k* = j*k*2 + *k*2 + *k*2.

-   We now consider that the boundary conditions impose restrictions on
    the possible values of *k~y~*. For what seen before, the
    propagation condition reads *k~y~* = *k* cos *θ* =
    *[nπ]{.underline}* , and being a TE~0*,n*~ wave we have *k~x~* =
    0.

-   the wave is propagating along the *z* axis and it is the **nature
    of** *k~z~*

which defines the type of propagation.

In summary, for TE waves:
>
⇒ Existence of a cut-off frequency. The dispersion relation is:

*k~z~* =

*ω*2
>
*c*2 −
>
*π*2*n*2 for a TE mode
>
*b*

*k~z~* =

We have for:
>
*k~z~* =
>
*ω*2
>
*c*2 −

*ω*2

*c*2 −

*π*2*n*2

*b*2 −
>
*π*2*m*2 for a TE mode
>
*a*
>
*π*2*m*2 for a TE mode
>
*a*
>
**a TE**~0*,n*~ **mode**
>
if *ω \ω~c~*
>
if *ω \< ω~c~*
>
= *[nπc]{.underline}*
>
*b*
>
= *[nπc]{.underline}*
>
*b*
>
→ *k~z~*
>
→ *k~z~*
>
∈ Re → Propagation without absorption for mode TE~*n,*0~
>
∈ Im → Evanescent wave for mode TE~0*,n*~
>
**a TE**~0*,n*~ **mode**
>
if *ω \ω~c~*
>
if *ω \< ω~c~*
>
= *[mπc]{.underline}*
>
*a*
>
= *[mπc]{.underline}*
>
*a*
>
→ *k~z~*
>
→ *k~z~*
>
∈ Re → Propagation without absorption for mode TE~*m,*0~
>
∈ Im → Evanescent wave for mode TE~*m,*0~
>
**a TE***~m,n~* **mode**
>
if = *mπc* 2 + *nπc* 2
>
Re Propagation without absorption for mode TE
>
if = *mπc* 2 + *nπc* 2
>
Re Evanescent wave for mode TE
>
where *ω~c~* is the cut-off angular frequency. So we can propagate and
ELM wave as a TE wave in rectangular waveguides only for frequencies
larger than the cut-off one: the waveguide acts as a high-pass filter.
>
Propagation in the waveguide is dispersive:
>
For TEM waves in free space we have: *k* = *ω/c* and *v~ϕ~* = *c*,
which is independent of *ω*: non-dispersive medium. For TE waves in
rectangular waveguides, we have in the case of a TE~0*,n*~ mode: (the
propagation is along the *z* axis):

and

[]{#_bookmark83 .anchor}*k~z~* =
>
*ω*
>
*ω*2
>
*c*2 −

*c*

*π*2*n*2 (4.5)
>
*b*
>
*v* = = = *f* (*ω*) (4.6)

*ϕ kz*

j1 −
>
*[ω]{.underline}c*[2]{.underline} *ω*2
>
![](media/image219.png)

Figure 4.4: A dispersion relation for a mode.

it is a dispersive medium.
>
Similarly we obtain for the group velocity:

*v~g~*

chap5 Geometrical interpretation

= *[∂ω]{.underline}*
>
*∂k~z~*

2

= *c* 1 − *c*
>
(4.7)

![](media/image228.png)

![](media/image230.png)
![](media/image231.png){width="2.0771489501312335in"
height="1.171874453193351in"}

Figure 4.5: The geometric interpretation of the dispersion.

We can understand the propagating behaviour of the TE wave using a
simple interpretation:

-   For *ω* = *ω~c~*, *k~z~* = *k* sin *θ* =0. This implies *θ* = 0. The
    wave is doing a normal incidence on the plates (no *z*
    progression) and *v~g~* = 0. In regions close to *ω~c~* the
    waveguides is highly dispersive.

-   For *ω* , *k~z~ ^[ω]{.underline}^* , *θ π/*2 and *v~g~ c*. The TE
    waves tends to have very large incidence angles and the guide
    behaves essentially as vacuum,

i.e. dispersionless.

-   We can rewrite the dispersion relation for a TE~0*,n*~ mode using
    wave- lengths. Eq [4.5](#_bookmark83) becomes:

1 = 1 2

1 2 (4.8)

*λ~z~* V *λ*

− *λy*
>
where *λ~z~* = *λ/* sin *θ* and *λ~y~* = *λ/* cos *θ*, or again

1 = 1 2

*n* 2 (4.9)
>
from which it is easy to confirm (see definition of *ω~c~*) that the
cut-off wavelength for a TE~0*,n*~ mode is *λ~c~* = [2*b*]{.underline}
.

![](media/image232.png)

![](media/image237.png){width="0.12802602799650042in"
height="9.562445319335083e-2in"}Figure 4.6: The phase and group
velocity variations vs angular frequency for a guided mode.

chap2 Power flow

The power density (power per unit surface, units \[*W/m*^2^\])
traversing the waveguide can be evaluated from the time-averaged
Poynting vector
>
(**P**) = ( [$`\overrightarrow{E}`$ × $`\overrightarrow{B}`$]{.underline} )*.* (4.10)
>
Let's consider a TE~0*,n*~ mode as described by equations
[4.1and](#_bookmark79) [4.2.](#_bookmark80) We can omit the pre-factor
"-2" from the amplitudes and use the fact that *k* cos *θ* = *k~y~* =
*nπ/b* and *k* sin *θ* = *k~z~*. We get
>
$`\overrightarrow{E}`$ = *E*~0~ sin *[nπ]{.underline}y* sin(*k z* − *ωt*)*\_e*
>
(4.11)

and

⊥ *b z* *x*
>
0
>
$`\overrightarrow{B}`$~⊥~ =  *E*0 *kz* sin ( *nπ y*) sin (*k~z~z* − *ωt*)
>
(4.12)

 *E*0 *nπ* cos ( *nπ y*) sin (*k~z~z* − *ωt*)

1 *E*^2^ *k~z~*

2 *[nπ]{.underline}*

(**P**) = 2 *cµ*0

sin
>
*k*
>
*y \_e~z~* (4.13)
>
*b*
>
The power transmitted by the guide (units \[*W* \]) can be found by
integrating the previous results over the cross-section of the
waveguide

= { *a* { *b*

= 1 *E*^2^ *k~z~*
>
(4.14)
>
i.e. the transmitted power is proportional to the cross-sectional area
of the waveguide. The practical limit of transmittable power is set by
the dielectric breakdown of the dielectric filling the waveguide. In
case of dry air, this limit is of about 3 MV/m.

# Exercices solved during tutorials

chap2 Exercice 1: Parallel-Plate Capacitor with a dielectric

Consider first an ideal parallel-plate capacitor made of two metallic
plates of surface *S* and separated by a distance *L*, as shown in
figure [4.7,](#_bookmark87) left. The top plate has a positive surface
charge while the bottom plate a negative one both with a density *σ*.
The surface *S* is sufficiently large and the distance *L*
sufficiently small that we can make the approximation of infinte
plates.

1.  By applying Gauss theorem to the surface *S*, show that the electric
    field is inside the capacitor is given by *E\_*0 = *σ/E*~0~.

2.  Let's suppose now that a linear homogeneous and isotropic perfect
    di- electric slab of thickness *d*~2~ and relative permittivity
    *E~r~* is inserted in between the parallel plates. Show that in the
    region occupied by the di- electric, "region 2", the total electric
    field is *E\_* = *[σ]{.underline} [σp]{.underline}* , where *σ* is
    the polarisation charge density appearing on the interfaces of the
    dielectric.

3.  Use the boundary condition for the dielectric displacement vector
    $`\overrightarrow{D}`$ and its constitutive relation to show that the total electric
    field in region 2

is *σ*

*E* =

*E*~0~*E~r~*

(4.15)
>
and then that the surface density of the polarisation charges *σ~p~*
appear- ing on the dielectric is
>
*σ* = *P* = *σ* 1 − [1]{.underline} *.* (4.16)

4.  The capacitance *C* is defined as the ratio between the charges on
    the capacitor plates to the capacitor potential difference. Show
    that due to the presence of the dielectric, the capacitance is given
    by

*σS*

*C* ∆*φ*

*Sε*~0~
>
((*L* − *d* ) + *d*2 l
>
(4.17)
>
2 *Er*

81

where ∆*φ* is the potential difference of the capacitor.

5.  Simplify the expression for the capacitance when the dielectric
    occupies the entire space between the parallel plate. What
    conclusions can we draw on the effect of a dielectric inside a
    capacitor? (Consider that typical values of *E~r~* for materials
    used in capacitors are: *E~r~*=2.1 for PTFE, *E~r~*=2.4 for
    polystyrene, *E~r~*=500 for barium strontium titanate).

![](media/image238.png){width="3.8531244531933506in"
height="2.3428116797900262in"}

Figure 4.7: []{#_bookmark87 .anchor}Left: Capacitor without
dielectric. The red arrows represents the electric field *E*~0~. The
cylinder is taken as the Gauss's surface to calculate the electric
field. *S* is the surface of the cylinder base. Right: A dielectric of
thickness *d*~2~ is inserted. The total electric filed inside the
dielectric is the sum of the electric field due to the charges *σ*
(red arrows) plus the electric field generated by the polarisation
charges *σ~p~* (blue arrows).

chap2 Exercice 2: The solar sail

Une voile solaire est un dispositif de propulsion qui utilise la
pression de ra- diation ´electromagn´etique ´emise par le soleil pour
se d´eplacer dans l'espace. La pression de radiation est tr\`es faible
mais comme dans l'espace il n'y a pratiquement aucune r´esistance, la
vitesse ne fait qu'augmenter et peut at- tendre des valeurs tr\`es
grandes. La voile solaire est propuls´ee par la pression produite par
les photons qui viennent la percuter. On peut aussi donner une
description du ph´enom\`ene en utilisant la physique ondulatoire pour
´evaluer la pression exerc´ee par la radiation.
>
Pour cela, on suppose que la voile est r´ealis´ee dans un conducteur
(par exem- ple une feuille m´etallique) d'indice de refraction complex
*n~c~* = *n*^t^*c* + *inc*tt. On consid\`ere que la radiation est
constitu´e par une onde plane monochromatique,
>
de pulsation *ω* et de vecteur d'onde *\_k~i~* = *k_e~z~* (*z \>* 0),
se propageante dans le vide et faisant une incidence normale avec le
conducteur. On supposera que le conducteur occupe le demi espace *z
\>* 0.

1.  Donner l'expression du champ ´electrique et magn´etique transmis en
    fonc- tion du coefficient de transmission *t*.

2.  Calculer la moyenne temporelle de la densit´e de force (force par
    unit´e de volume) que le champ ´electromagn´etique transmis exerce
    sur le charges du conducteur.

3.  A\` partir du r´esultat pr´ec´edent d´eterminer la moyenne
    temporelle de la

pression *\< P_rad \>* que la radiation ´electromagn´etique exerce sur
les
>
charges du conducteur.

4.  Montrer que dans l'approximation d'un tr\`es bon conducteur, la
    moyenne

temporelle de la pression de radiation peut s'´ecrire *\< P_rad*
>
*\>*= 2 *[\<S\--i>]{.underline}*
>
ou\` *\< S_i \>* est la moyenne temporelle du vecteur de Poynting de
l'onde incidente et *c* la vitesse de la lumi\`ere dans le vide.

5.  La radiation solaire proche de la terre est d'environ 1370 W/m2. Si
    la voile solaire a une surface de 30 m2 et une masse de 10 kg,
    calculer l'acceleration maximale que la voile peut atteindre proche
    de la terre. Si on suppose que cette acceleration peut ˆetre
    maintenue pendant une ann´ee, calculer la vitesse que la voile
    pourrait attendre.

6.  Si l'on souhaite faire l´eviter une pi\`ece d'un Euro (masse 7.5 g
    et diam\`etre 23.25 mm et soumis \`a la force gravitationnelle sur
    Terre) suppos´e par- faitement r´efl´echissante \`a l'aide d'un
    laser, quelle puissance devrions nous utiliser ?

chap2 Exercices 3 : Propagation d'une OPPM dans un M.L.H.I.

Dans cette s´erie d'exercices, on se propose d'´etudier les
caract´eristiques d'une
>
onde ´electromagn´etique *E\_* = *E\_*0 exp*i*(*\--k*·*\--r*−*ωt*)
plane, sinuso¨ıdale, polaris´ee rec-
>
tilignement qui se propage dans un M.L.H.I., lorsque l'on augmente la
pulsa- tion *ω*. Les caract´eristiques de l'onde seront d´eduites de
l'´equation de disper- sion du milieu.
>
![](media/image239.jpeg){width="2.5549989063867016in"
height="1.9949989063867017in"}
>
Figure 4.8: La voile solaire Cosmos 1.
>
https://fr.wikipedia.org/wiki/Cosmos 1

![](media/image240.jpeg){width="1.850624453193351in"
height="2.334374453193351in"}

Figure 4.9: *Sch´ema de principe du d´eplacement des charges dans la
ionosph\`ere.*

chap4 Le plasma et la pulsation de plasma

Dans un premier temps, on d´etermine une des grandeurs propres au
plasma, en l'absence d'onde ´electromagntique. Un plasma est un gaz
ionis´e, de permit- tivit´e di´electrique *E*~0~ et de perm´eabilit´e
magn´etique *µ*~0~, constitu´e d'´electrons de charge *e* et de masse
*m~e~*, et d'ions de charge +*e* et de masse *M* , ainsi que d'atomes
neutres. Les densit´es ´electronique *n~e~* et ionique *n~i~* ´etant
´egales, le plasma est ´electriquement neutre. Si le plasma est peu
dense et si sa temp´erature est peu ´elev´ee, on peut n´egliger les
collisions dues \`a l'agitation thermique : il s'agit de
l'*approximation des plasmas froids*.
>
On se propose de d´eterminer les oscillations propres au plasma,
caract´eris´ees
>
par la pulsation plasma. Pour cela, supposons que sous l'action d'un
champ
>
´electrique stationnaire *E\_*0, les ´electrons de densit´e *n~e~* se
d´eplacent en bloc suivant l'axe (*Oz*), d'une quantit´e *z*, les
ions, du fait de leur inertie beau- coup plus grande restent
immobiles. Il apparaˆıt donc un champ ´electrique *E\_*induit =
*E~z~\_e~z~* entre les deux r´egions ou\` les charges oppos´ees se
retrouvent accumul´ees.

1.  D´eterminer l'expression de *E~z~* en fonction de *e*, *n~e~*,*z* et
    *E*~0~, sachant que l'expression d'un champ ´electrique g´en´er´e
    par un plan de densit´e sur-

facique de charge *σ~S~*
>
plan.
>
s'´ecrit : *E\_* = *[σS]{.underline} \_n*, *\_n* ´etant un vecteur
normal \`a ce 2*E*~0~

2.  D´eterminer le mouvement des ´electrons lorsque'on annule *E\_*0 une
    fois l'´equilibre atteint. En d´eduire la valeur de leur pulsation
    propre appel´e *pulsation plasma*: *ω~p~*.

3.  Calculer la fr´equence plasma pour une couche moyenne de la
    ionosph\`ere pour laquelle la densit´e ´electronique est *n~e~* =
    1011 m−3.

*[Note :]{.underline} Les 3 exercices qui suivent d´emarrent aussi par
la d´etermination du mouvement des particules charg´ees en r´esolvant
leur ´equation du mouvement. Dans cette ´equation, la force
´electrostatique sera toujours celle g´en´er´ee par le champ
´electrique de l'onde EM. Ainsi, le passage de l'onde dans le
mat´eriau impose un r´egime sinuso¨ıdale de pulsation ω pour les
mouvements des par- ticules charg´ees. On pourra donc utiliser les
outils math´ematiques adapt´es (notation complexe) pour r´esoudre ces
´equations.*

chap4 Propagation dans un plasma froid

Il s'agit maintenant de d´eterminer les caract´eristiques d'une onde
´electro-
>
magn´etique plane, sinuso¨ıdale, polaris´ee rectilignement
*E[\_]{.underline}* = *E\_*0 exp{\[*i*(*\_k* · *\_r* − *ωt*)\]}
>
qui se propage dans un plasma froid tel que *n~e~* = *n~i~* = *n*. On
n´eglige ´egalement les interactions entre particules. Dans ces
conditions, les mouvements des particules ne sont d´etermin´es que par
leur inertie et par l'action du champ
>
´electrique de l'onde ´electromagn´etique se propageant dans le
plasma, le poids des particules ´etant n´egligeable.

1.  A partir de l'´equation du mouvement d'un ion (d'un ´electron)
    soumis \`a l'action de l'onde, calculer la densit´e de courant
    ionique *j~i~* (´electronique *j~e~*). En d´eduire la conductivit´e
    *σ* du milieu.

2.  On pose la pulsation plasma des ions Ω2 = *nie*2 , et 2 =

2 + Ω2.

*^p^ E*~0~*M*

*ωc ωp p*
>
Etablir l'´equation de dispersion du plasma en fonction de *c*, *ω* et
*ω~c~*.

3.  D´eterminer le domaine de pulsation pour lequel l'onde est
    ´evanescente et celui pour lequel l'onde est progressive. Tracer
    la courbe de dispersion *ω*(*k*).

4.  Exprimer la vitesse de phase *v~ϕ~* et la vitesse de groupe *v~g~*
    de l'onde progressive en fonction de *c* et des pulsations
    caract´eristiques du plasma.

5.  Exprimer l'indice de r´efraction *n~opt~* du milieu et repr´esenter
    sa variation

*n~opt~*(*ω*).

6.  L'onde se propage dans la direction des *z* croissants. Ecrire le
    champ

´electrique dans chacun des domaines de fr´equences d´etermin´es aux
ques- tions 3 et 4.

7.  L'onde ´electromagn´etique qui se propage est-elle transverse ?
    Justifier.

8.  Le plasma consid´er´e fait partie de la ionosph\`ere (couche
    atmosph´erique situ´ee environ entre 50 et 100 km de hauteur),
    l'ionisation ´etant assur´ee par le soleil. La densit´e *n* est
    alors gale 1*,* 22*.*1012 m−3. Les masses *M* et *m* (= 9*.*10−31
    kg) des ions et des ´electrons sont dans le rapport

*m* \'.:: 1850.
>
Que peut-on dire \`a propos des conductivit´es de ces deux types de
charge?
>
Tenir compte de cette information pour simplifier et calculer la
fr´equence de coupure du plasma, ainsi que la longueur d'onde de
coupure *λ~c~* cor- respondante.
>
A quelle cat´egorie d'ondes appartiennent celles qui sont susceptibles
de traverser la ionosph\`ere ?

9.  Les ´etoiles pulsar ´emettent des ondes radios. L'interval de
    r´eception sur terre entre les impulsions \`a 400 MHz et 200 MHz
    ´emises par une pulsar est de 4 s. Sachant que la densit´e
    d'´electrons dans l'espace interstellaire est de 3×104m−3,
    calculer la distance du pulsar

chap4 Propagation dans un di´electrique

On peut consid´erer le milieu di´electrique comme ´etant constitu´e
d'ions im- mobiles (charge +*e*) et d'´electrons (charge *e*, masse
*m*), ces derniers restant toujours li´es aux ions. Les densit´es *n*
des ions et des ´electrons, par unit de vol- ume, sont suppos´ees
´egales. On adopte un mod\`ele dans lequel chaque ´electron est
consid´er´e "libre" (comme pour un conducteur), mais rappel´e vers un
ion par une force de rappel qu'on supposera ´elastique et de la forme
*K_r~e~* pour un petit d´eplacement *\_r~e~* de l'´electron par
rappo[rt]{.underline} \`a l'ion. Concernant les

´electrons, on posera leur pulsation propre *ω*~0~ = / *[K]{.underline}*
et leur pulsation plasma

*m* 2 2 2
>
est d´efinie comme dans l'exercice pr´ec´edent. On posera aussi Ω =
*ω*~0~ + *ωp* .

1.  On part du principe fondamental de la dynamique appliqu´e \`a un
    ´electron dont on n´egligera le poids. Indiquer la d´emarche du
    calcul qu'il convient d'effectuer pour ´etablir l'´equation de
    dispersion du milieu. D´eterminer cette ´equation.

2.  On augmente progressivement la fr´equence de l'onde incidente aux
    valeurs les plus ´elev´ees possibles. Donner alors les
    caract´eristiques successives de la propagation de l'onde dans ce
    milieu. Combien y a-t-il de bandes passantes ? de bandes non
    passantes ? Tracer la courbe de dispersion du milieu.

3.  Exprimer l'indice de r´efraction *n~opt~* du milieu et tracer sa
    variation en fonction de *ω*.

4.  Quelles information peut-on extraire \`a partir d'une mesure de
    r´eflectivit´e d'un di´electrique?

5.  Dans un di´electrique r´eel les ´electrons sont soumis \`a une force
    de frot- tement *F\_* = *ma_v* (qui d´ecrit les pertes par
    irradiation). Qu'est-ce que l'on peut conclure sur la nature de la
    propagation dans ce cas?

![](media/image241.png){width="5.18375in" height="3.0147911198600177in"}

Figure 4.10: *Haut: partie r´eelle et imaginaire de la function
di´electrique d'un conducteur selon le mod\`ele utilis´e dans
l'exercice avec ω~p~* = 1016 *rad/s et τ* = 10−14 *s. Bas: partie
r´eelle et imaginaire du vecteur d'onde correspondant.*
>
![](media/image242.png){width="5.191874453193351in"
height="1.5131244531933508in"}
>
Figure 4.11: *Gauche: partie r´eel et imaginaire de l'indice de
refraction du conducteur consid´er´e dans la figure pr´ec´edente.
Droite: le pouvoir r´eflecteur correspondant.*

chap4 Propagation dans un conducteur m´etallique

Dans un mod\`ele simple, un m´etal (le cuivre notamment) peut
s'assimiler un milieu L.H.I., de constantes di´electrique et
magn´etique *E*~0~ et *µ*~0~, ´electriquement neutre, constitu´e de
*n* ions (charge +*e*) fixes et de *n* ´electrons mobiles (charge *e*,
masse *m*). Ces derniers subissent des collisions. A l'´echelle
m´esoscopique, les collisions sont ´equivalentes une force de
frottement visqueux oppose leur vitesse *\_v* telle que *F\_* =
*ma_v*, ou\` *a* repr´esente la fr´equence des collisions lie au
>
temps de relaxation *τ* du m´etal par *a* = [1]{.underline} . On
posera qu'en r´egime permanent

*τ* 2

la conductivit´e du conducteur est *σ*~0~ = *ne τ* .

*m*

1.  En appliquant le principe fondamental de la dynamique \`a un
    ´electron (on n´egligera son poids), exprimer la conductivit´e *σ*
    en r´egime variable du mat´eriau en fonction de *σ*~0~ et du
    produit *ωτ* et donner les expressions de sa partie r´eelle *σ*^t^
    et imaginaire *σ*^tt1^.

Exprimer ensuite la conductivit´e en fonction de la pulsation de
plasma

*ω* = *ne*2 . Donner l'expression de la relation de dispersion du milieu

en fonction de *σ* et en d´eduire la nature de la propagation de
l'onde
>
´electromagn´etique susceptible de se trouver dans le conducteur.

2.  On suppose que la fr´equence de l'onde est suffisamment faible pour
    que *ωτ* 1. Donner l'expression approch´ee de la conductivit´e. En
    con- sid´erant que la conductivit´e en r´egime permanent des
    conducteurs est de l'ordre de 107 S/m, et que *τ* 10−14,
    simplifier la relation de dispersion, en d´eduire la nature de la
    propagation dans le milieu et la

1Comme pour l'exercice pr´ec´edent, on peut calculer la relation de
dispersion en utilisant deux m´ethodes: 1) On consid\`ere que *Er* = 1
et on calcul la conductivit´e *σ*. 2) On consid\`ere que *σ* = 0 et on
calcul la fonction di´electrique relative. Les deux m´ethodes donnes
le mˆeme r´esultat.
>
r´egion spectrale ou\` la condition *ωτ* 1 est satisfaite. Exprimer
ensuite l'indice de r´efraction *n~opt~* du m´etal et sa valuer.
Qu'est-ce que l'on peut conclure sur le pouvoir r´eflecteurs des
m´etaux dans ce domain spectral?

3.  On suppose maintenant la fr´equence de l'onde est telle que *ωτ* 1.

Donner l'expression approch´ee de la relation de dispersion et
determiner la nature de la propagation dans les deux cas suivants:

i.  Cas *ω \< ω~p~*.

ii. Cas *ω \ω~p~*. A\` quel domain spectrale correspondents ces
    pulsations?

![](media/image243.png){width="4.752498906386702in"
height="1.9049989063867017in"}

Figure 4.12: *Some critical frequency values (from "Born and Wolf,
Principle of Optics")*

chap4 3.5 Ecran pour t´el´ecommunications (extrait examen 2012-2013)

On se propose d'´etudier la possibilit´e d'empˆecher les
communications des t´el´ephones portables dans une salle de cours. La
strat´egie c'est d'appliquer aux fenˆetres une fine couche d'un
mat´eriau absorbant la radiation centr´ee sur l'´emission des
t´el´ephones portable (ft´el=1GHz=109 Hz) mais non absorbant dans le
spectre du visible (*λ^vis^*=500nm=5x10−7m). Ce mat´eriau est
consid´er´e comme un milieu LHI globalement neutre (*ρ~tot~*=0) et non
magn´etique (*µ*=*µ*~0~). Pour les fr´equences t´el´ephoniques sa
permittivit´e relative et sa conductivit´e sont respectivement :
>
*E*^t´el^=100 et *σ*^t´el^=107 S/m.
>
Pour les fr´equences visibles sa permittivit´e relative et sa
conductivit´e sont respectivement :
>
*E^vis^*=10 et *σ^vis^*=102 S/m.

1.  Ecrire les ´equations de Maxwell dans ce milieu, en supposant valide
    la loi d'Ohm locale (j=*σ*E).

2.  En d´eduire l'´equation de propagation, du champ ´electrique en
    fonction de *µ*~0~,c, *E~r~* et *σ*.

3.  En supposant pour *E\_* la forme suivante *E[\_]{.underline}* =
    *E\_*0*e^i^*^(*kz*−*ωt*)^, ou\` *k* est le

vecteur d'onde et *ω* la pulsation, donner l'´equation de dispersion
du milieu.

4.  Faire une ´evaluation num´erique des diff´erents termes apparaissant
    dans la relation de dispersion pour les fr´equences
    t´el´ephoniques et visibles.

    -   Partie fr´equences t´el´ephoniques :

5.  Pour les fr´equences t´el´ephoniques, donn[er un]{.underline}e
    formule approch´ee de

la relation de dispersion en fonction de *α* = [2]{.underline} .
Comment qualifier ce mat´eriau dans le domaine des fr´equences
t´el´ephoniques ? Quel est le type de
>
propagation ? (on rappelle que
>
√*i* =
>
[1+*i*]{.underline}
>
√2

6.  Ecrire l'expression d'un OPPM se propageant dans ce mat´eriau aux

fr´equences t´el´ephoniques selon Oz dans les sens de z positifs.

7.  On suppose que le signal des antennes relais des t´el´ephones ait
    une amplitude du champ ´electrique E~antenne~=1V/m proches de la
    salle, et que un t´el´ephone peut r´epondre s'il rec¸oit un signal
    d'au moins 1*µ*V/m. En n´egligeant les effet de r´eflexion aux
    surfaces, calculer l'´epaisseur minimal du milieu \`a d´eposer sur
    les fenˆetres afin d'empˆecher tout communication t´el´ephonique.

8.  Montrer que l'indice de r´efraction complexe *[N]{.underline}* du
    milieu peut s'´ecrire

*[N]{.underline}* = *n*(*i*) + *i n*(*ii*) avec *n*(*i*) = *n*(*ii*).

9.  On consid\`ere maintenant l'effet de la r´eflexion air (indice
    n*~air~*=1) -- milieu. Evaluer en forme approch´ee le pouvoir
    r´eflecteur. Conclure.

    -   Partie fr´equences du visible :

10. Pour le visible (*λ^vis^*=500nm), donner une formule approch´ee de
    la relation de dispersion. Comment qualifier ce mat´eriau dans le
    domaine du visible? Quel est le type de propagation ?

11. Evaluer l'impact pour la vue.

chap2 Exercice 4: R´eflexion m´etallique d'une onde polarise circulairement

Une onde plane poss´edant une polarisation circulaire gauche, se
propageant dans l'air dans le demi-espace *z* 0, dans la direction
(*Oz*) a pour expression du champ ´electrique r´eel:

*E\_* (*z, t*) = *E*~0~ \[cos (*kz* − *ωt*) *\_e~x~* − sin (*kz* − *ωt*)
*\_e~y~*\]

1.  D´eterminer l'expression du champ magn´etique *B\_* (*z, t*). Donner
    les ex- pressions des champs complexes *E\_ , B\_* associ´e au
    champ ´electro-magn´etique.

2.  Calculer le vecteur de Poynting associ´e cette onde. Commenter le
    r´esultat.

3.  L'onde se r´efl´echit sous incidence normale sur un miroir plan
    m´etallique de conductivit´e infinie, plac´e dans le plan *z* = 0.

    a.  D´eterminer l'´etat de polarisation de l'onde r´efl´echie (*E\_*
        t(*z, t*)*, B\_* t(*z, t*)).

    b.  D´eterminer les expressions du champ ´electromagn´etique
        r´esultant

(*E_T* (*z, t*)*, B\_ T* (*z, t*)) dans la r´egion *z* ≤ 0. En d´eduire
la valeur du

vecteur de Poynting Π*\_* total de l'onde r´esultante. Commenter.

c.  D´eterminer les densit´es surfaciques de charge *σ~S~*(*t*) et de
    courant

*\_j~S~*(*t*) dans le plan du miroir.

4.  L'onde plane, polarise circulaire gauche, arrive maintenant sous une
    in- cidence *θ* avec la normale au miroir m´etallique. D´eterminer
    *σ~S~*(*x, y, t*) dans cette nouvelle configuration.

chap2 Exercice 5: Cas pratiques de la propagation guid´ee

1.  Un guide d'onde, suppos´e parfait, doit pouvoir fonctionner en mode
    TE~*m,*0~ jusqu'\`a un ordre *p* mais aussi transmettre une bande de
    fr´equence comprise entre *f*~1~ et *f*~2~, avec *f*~1~ *\f*~2~.
    Quelles doivent ˆetre les dimensions

*a* et *b* du guide ? (Rappel: *a* est la dimension du guide suivant
(*Ox*) et
>
*b* celle suivant (*Oy*)).

2.  A partir d'un guide d'onde rectangulaire de dimensions connues (*a
    \b*), d´eterminer sa bande passante pour le mode TE~*m,*0~.

3.  Un guide d'onde carr´e, rempli d'air, a pour dimension *a* = *b* =
    2*,* 4 *cm*. Il est excit´e par deux petites antennes
    perpendiculaires aux faces or- thogonales, c'est dire
    parall\`element (*Ox*), et (*Oy*). Ecrire la condition de
    propagation des modes fondamentaux TE~1*,*0~, et TE~0*,*1~. En
    d´eduire la bande passante, et application num´erique pour les modes
    fondamentaux.

4.  Trouver le premier mode sup´erieur et ´ecrire la condition de non
    propa- gation de ce mode.
