---
title: "Combinaisons d'opérateurs"
published: true
routable: true
visible: false
lessons:
    - slug: combinaison-operators-for-electromagnetism
      name: OUTIL-MATH : Combinaison d'opérateurs pour l'électromagnétisme
      order: 1
---

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Combinaisons d'opérateurs

<br>


PRINCIPALES COMBINAISONS
: ---

    Soient $`\overrightarrow{U}`$ un champ vectoriel et $`\phi`$ un champ scalaire quelconques :

   * $`\mathbf{\overrightarrow{rot}\big(\,\overrightarrow{grad}\,\phi\big)=\overrightarrow{0}}`$   
     
     * Est utilisée pour montrer qu'un champ vectoriel dérive d'un champ scalaire :   
     $`\overrightarrow{rot}\,\overrightarrow{U}=\overrightarrow{0}\quad\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=\overrightarrow{grad}\,\phi`$
     * En physique, un champ d'interaction $`\overrightarrow{U}`$ dérive d'un potentiel scalaire $`\phi`$
       $`\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=- \overrightarrow{grad}\,\phi`$,    
       le signe $`-`$ permettant de définir une énergie mécanique qui se conserve.

   * $`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{U}\big)=0}`$   
     * Est utilisée pour montrer qu'un champ vectoriel dérive d'un champ vectoriel :   
     $`div\,\overrightarrow{U}=0\quad\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=\overrightarrow{rot}\,\overrightarrow{V}`$
     * En physique, si $`\overrightarrow{U}`$ est un champ d'interaction, $`\overrightarrow{V}`$ est son potentiel vecteur.

   ---

   *Laplacien $`\Delta\,\phi`$ d'un champ scalaire $`\phi`$*

   * Définition de l'opérateur laplacien scalaire :  
     $`\mathbf{\Delta=div\big(\overrightarrow{grad}\big)}`$ 
 
   * Utilité en physique :   
     * équation d'onde (ou équation de d'Alembert) :   
       $`\Delta\,\phi-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \phi}{\partial t^2}=0`$
     * équation de Poisson :   
       $`\Delta\,\phi-f=0\quad`$, avec $`f`$ champ scalaire.
     * éuqtaion de Laplace :   
       $`\Delta\,\phi=0`$

   * Expression en coordonnées cartésiennes :   
     $`\Delta\,\phi=\dfrac{\partial^2 \phi}{\partial x^2}+\dfrac{\partial^2 \phi}{\partial y^2}+\dfrac{\partial^2 \phi}{\partial z^2}`$    
     et expression avec l'opérateur nabla $`\nabla`$ :   
     $`\Delta\,\phi=\overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,\phi`$
  
   * <details markdown=1>
      <summary>Expressions en coordonnées cylindriques et sphériques</summary>
      * coordonnées cylindriques $`(\rho\,,\,\varphi\,,\,z)`$ :   
        <br>
       $`\Delta\,\phi=\dfrac{1}{\rho}\cdot\dfrac{\partial}{\partial \rho}\left(\rho\,\dfrac{\partial \phi}{\partial \rho}\right)`$
        $`\;+\;\dfrac{1}{\rho^2}\cdot\dfrac{\partial^2 \phi}{\partial \varphi^2}`$
        $`\;+\;\dfrac{\partial^2 \phi}{\partial z^2}`$   
       <br>
      * coordonnées sphérique $`(r\,,\,\theta\,,\,\varphi)`$ :   
        <br>
       $`\Delta\,\phi=\dfrac{1}{r}\cdot\dfrac{\partial^2}{\partial r^2}(r\phi)`$
       $`\;+\;\dfrac{1}{r^2\,\sin\theta}\cdot\dfrac{\partial}{\partial \theta}\left(\sin\theta\dfrac{\partial \phi}{\partial \theta}\right)`$
       $`\;+\;\dfrac{1}{r^2\,\sin^2\theta}\cdot\dfrac{\partial^2 \phi}{\partial \varphi^2}`$


   ---
   
   *Laplacien $`\Delta\,\overrightarrow{U}`$ d'un champ vectoriel $`\overrightarrow{U}`$*
   
   * Définition opérateur laplacien vectoriel :    
   $`\mathbf{\overrightarrow{\Delta}=\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
   -\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$

   * Utilisé en physique dans l'équation d'onde vectorielle :   
     $`\Delta\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial \overrightarrow{U}}{\partial t^2}=0`$

   * Expression en coordonnées cartésiennes de base unitaire $`(\vec{e_x}\,,\,\vec{e_y}\,,\,\vec{e_z})`$ :   
     $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
     \dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\\
     \dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\\
     \dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}
     \end{array}\right)`$   
     <br>
     et expression avec l'opérateur nabla $`\nabla`$ :   
     $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
     \Delta\,U_x\\
     \Delta\,U_y\\
     \Delta\,U_z\\
     \end{array}\right)`$
     $`\;=\left(\begin{array}{l}
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_x\\
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_y\\
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_z\\
     \end{array}\right)`$

   * <details markdown=1>
      <summary>Expressions en coordonnées cylindriques et sphériques</summary>
      * dans la base cylindrique unitaire $`(\vec{e_{\rho}}\,,\,\vec{e_{\phi}}\,,\,\vec{e_z})`$ :   
        <br>
       $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
         \Delta_{cyl}U_{\rho}\\
         \Delta_{cyl}U_{\phi}\\
         \Delta_{cyl}U_z
     \end{array}\right)`$   
     <br>
     où $`\Delta_{cyl}`$ est l'expression du laplacien scalaire en coordonnées cylindriques.
      * dans la base sphérique unitaire $`(\vec{e_r}\,,\,\vec{e_{\theta}}\,,\,\vec{e_{\phi}})`$ :   
        <br>
       $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
         \Delta_{sph}U_r\\
         \Delta_{sph}U_{\theta}\\
         \Delta_{sph}U_{\phi}
     \end{array}\right)`$   
     <br>
     où $`\Delta_{sph}`$ est l'expression du laplacien scalaire en coordonnées sphériques.
      </details>



   


<br>

**POUR L'ÉTUDE DES PHÉNOMÈNES DE PROPAGATION**

----------------------------

#### L'opérateur laplacien scalaire, et la propagation d'un champ scalaire.

##### 1 - Opérateur laplacien scalaire et équation d'onde d'un champ scalaire.

* Un *champ scalaire $`f`$ se propage* s'il vérifie l'**équation d'onde scalaire**.
  <br>
  L'écriture générale de cette équation *utilise l'opérateur lagrangien scalaire $`\Delta`$* et s'écrit :   
  <br>
  **$`\Delta\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$**

* Cet opérateur laplacien scalaire **$`\Delta`$ possède une existence en soi**, 
  *indépendante de son expression dans un système de coordonnées* donné, de même qu'un vecteur à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée **en coordonnées cartésiennes**, l'*équation d'onde scalaire* s'écrit :   
  <br>
  *$`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$*
  <br>
  l'expression du laplacien scalaire **$`\Delta`$ en coordonnées cartésienne** étant :   
  <br>
  **$`\Delta=\dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$**

!!! *Exemples de champs scalaires* :   
!!! * le champ des température dans l'atmosphère terrestre.
!!! * le champ de la densité volumique de masse du globe terrestre, ou de l'atmosphère terrestre.

##### 2 - Champ scalaire et opérateur $`\overrightarrow{grad}`$

* Un **champ scalaire $`f`$**, fonction continue et au moins une fois dérivable de l'espace, peut être
  caractérisé *en chacun de ses points* par un *vecteur gradient $`\overrightarrow{grad}\,f`$*.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de gradient $`\overrightarrow{grad}\,f`$* qui est un **champ vectoriel**.

##### 3 - Définition du laplacien scalaire à partir du gradient

* Le **champ de gradient $`\overrightarrow{grad}\,f`$** d'un champ scalaire $`f`$ au moins deux fois dérivable, peut être caractérisé
  *en chacun de ses points* par sa *divergence $`div\,\overrightarrow{grad}\,f`$*.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le **champ de divergence $`div\,\overrightarrow{grad}\,f`$** qui est un champ scalaire.

* Cherchons l'expression de ce champ de divergence en fonction du champ f, en coordonnées cartésiennes.
   * L'expression cartésienne du gradient d'un champ $`f`$ est :   
     $`\overrightarrow{grad}\,f=\dfrac{\partial f}{\partial x}\overrightarrow{e_x}+\dfrac{\partial f}{\partial y}\overrightarrow{e_y}+\dfrac{\partial f}{\partial z}\overrightarrow{e_z}`$
   * L'expression cartésienne de la divergence d'un champ $`\overrightarrow{U}`$ est :  
     $`div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}`$
   * La combinaison des deux expressions permet d'exprimer la 
     *divergence du gradient de $`f`$ en coordonnées cartésiennes* :   
     <br>
     *$`div\,\overrightarrow{grad}\,f`$*
     $`\quad= \dfrac{\partial}{\partial x}\left(\dfrac{\partial f}{\partial x}\right)+\dfrac{\partial}{\partial y}\left(\dfrac{\partial f}{\partial y}\right)+\dfrac{\partial}{\partial z}\left(\dfrac{\partial f}{\partial z}\right)`$
     *$`\quad = \dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}`$*   
     <br>
     et l'**opérateur $`div\,\overrightarrow{grad}`$ en coordonnées cartésiennes** :   
     <br>
     **$`div\,\overrightarrow{grad}= \dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$**

* Nous reconnaissons l'expression cartésienne de l'opérateur laplacien.

* L'opérateur combiné $`div\,\overrightarrow{grad}`$ constitue la **définition de l'opérateur laplacien scalaire** :   
<br>
**$`\large{\Delta}=div\;\overrightarrow{grad}`$**

##### 4 - Relation entre les propriétés locales d'un champ scalaire et sa propagation

* Tout champ scalaire $`f`$ (continue et au moins deux fois dérivable) possède son champ de gradient $`\overrightarrow{f}`$.
* *Si le gradient de $`\overrightarrow{f}`$ vérifie l'* **équation d'onde** :   
  <br>
  *$`\large{div\,\overrightarrow{grad}\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0}`$*      
  <br>
  ou écrit avec le laplacien scalaire :   
  <br>
  **$`\large{\Delta\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0}`$**      
  <br>
  **alors le champ scalaire $`f`$ se propage** *à la célérité $`\mathscr{v}`$*.

<br>

-----------------------------------

#### L'opérateur laplacien vectoriel, et la propagation d'un champ vectoriel

##### 1 - Opérateur laplacien vectoriel et équation d'onde d'un champ vectoriel.

* Un *champ vectoriel $`\overrightarrow{U}`$ se propage* s'il vérifie l'**équation d'onde vectorielle**.
  <br>
  L'écriture générale de cette équation *utilise l'opérateur lagrangien vectoriel $`\overrightarrow{\Delta}`$* et s'écrit :   
  <br>
  **$`\overrightarrow{\Delta}\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}`$**

* Cet opérateur laplacien vectoriel **$`\overrightarrow{\Delta}`$ possède une existence en soi**, 
  *indépendante de son expression dans un système de coordonnées* donné, de même qu'un vecteur 
  à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée **en coordonnées cartésiennes**,   
    * Le *champ vectoriel* s'écrit :   
    <br>
    *$`\overrightarrow{U}=U_x\,\overrightarrow{e_x}+U_y\,\overrightarrow{e_y}+U_z\,\overrightarrow{e_z}`$*
    * et l'*équation d'onde vectoriel* se décompose en :   

    *$`\left\{\begin{array}{l}
    \;\left(\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_x}{\partial t^2}=0\\
    \;\left(\dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_y}{\partial t^2}=0\\    
    \;\left(\dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_z}{\partial t^2}=0   
    \end{array}\right.`$*   
    <br>
    *Chacune des composantes du champ vérifie l'équation d'onde scalaire*.

* L'expression du laplacien vectoriel **$`\overrightarrow{\Delta}\,\overrightarrow{U}`$**
  d'un vecteur $`\overrightarrow{U}`$ **en coordonnées cartésiennes** est :   
  <br>
  $`\overrightarrow{\Delta}`$
  $`=\left(
   \begin{array}{l}
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}
    \end{array}
   \right)`$**


<br>

##### 2 - Champ vectoriel et opérateurs $`div`$ et $`\overrightarrow{rot}`$

* Un **champ vectoriel $`\overrightarrow{U}`$**, fonction continue et au moins une fois dérivable de l'espace,
  peut être caractérisé *en chacun de ses points* par un *scalaire divergence $`div\,\overrightarrow{U}`$* et
  un *vecteur rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$*   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de divergence $`div\,\overrightarrow{U}`$* 
  qui est un **champ scalaire**.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$* 
  qui est un **champ vectoriel**.

<br>

##### 3 - Définition du laplacien vectoriel à partir de la divergence et du rotationnel

* Le **champ de divergence $`div\,\overrightarrow{U}`$** d'un champ vectoriel $`\overrightarrow{U}`$ au moins 
  deux fois dérivable, peut être caractérisé *en chacun de ses points* par : 
   * *son gradient $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$*   
   <br>
   **$`\Longrightarrow`$** nous pouvons cronstruire le 
   **champ de gradient $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$**
   qui est un champ vectoriel.

* Cherchons les coordonnées cartésiennes de $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$`\color{blue}{div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}}`$

* La divergence d'un champ vectoriel est un champ scalaire.   
      Le gradient d'un champ scalaire $`f`$ est le champ vectoriel, qui s'exprime en coordonnées cartésiennes :

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$`\overrightarrow{grad}\,f=\left(
\begin{array}{l}
\dfrac{\partial f}{\partial x}\\
\dfrac{\partial f}{\partial y}\\
\dfrac{\partial f}{\partial z}
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; donc :

$`\overrightarrow{grad}\big(\color{blue}{div\,\overrightarrow{U}}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial}{\partial x}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial y}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial z}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; et nous obtenons l'expression **en coordonnées cartésiennes** :

$`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$
**$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$**

<br>

----------------------------------

<br>


* Le **champ de rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$** d'un champ vectoriel $`\overrightarrow{U}`$ au moins 
  deux fois dérivable, peut être caractérisé *en chacun de ses points* par : 
   * son *rotationnel $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$*   
   <br>
   **$`\Longrightarrow`$** nous pouvons cronstruire le 
   **champ de rotationnel $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$**
   qui est un champ vectoriel.

* Cherchons les coordonnées cartésiennes de $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$.

$`\color{blue}{\overrightarrow{rot}\,\overrightarrow{U}=
\left(\begin{array}{l}
\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}\\
\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}\\
\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}
\end{array}\right)}`$


$`\overrightarrow{rot}\big(\color{blue}{\overrightarrow{rot}\,\overrightarrow{U}\big)}`$
$`\quad =
\left[\begin{array}{l}
\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}}
\right)
-\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}}
\right)\\
\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}}
\right)
-\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}}
\right)\\
\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}}
\right)
-\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}}
\right)\end{array}\right]`$

 &nbsp;&nbsp;&nbsp;&nbsp; Nous obtenons alors l'expression **en coordonnées cartésiennes** :

$`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
**$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_y}{\partial y\,\partial x}
-\dfrac{\partial^2 U_x}{\partial y^2}
-\dfrac{\partial^2 U_x}{\partial z^2}
+\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 U_z}{\partial z\,\partial y}
-\dfrac{\partial^2 U_y}{\partial z^2}
-\dfrac{\partial^2 U_y}{\partial x^2}
+\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 U_y}{\partial x\,\partial z}
-\dfrac{\partial^2 U_x}{\partial x^2}
-\dfrac{\partial^2 U_z}{\partial y^2}
+\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$**

<br>

----------------------------------

<br>

Un **fait important** apparaît par 
*soustraction* des composantes cartésiennes *de $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$*
*et de $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$*

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$
$`\quad - \quad
\left(\begin{array}{l}
\dfrac{\partial^2 U_y}{\partial y\,\partial x}
-\dfrac{\partial^2 U_x}{\partial y^2}
-\dfrac{\partial^2 U_x}{\partial z^2}
+\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 U_z}{\partial z\,\partial y}
-\dfrac{\partial^2 U_y}{\partial z^2}
-\dfrac{\partial^2 U_y}{\partial x^2}
+\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 U_y}{\partial x\,\partial z}
-\dfrac{\partial^2 U_x}{\partial x^2}
-\dfrac{\partial^2 U_z}{\partial y^2}
+\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$

$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\quad\quad - \dfrac{\partial^2 U_y}{\partial y\,\partial x}
+\dfrac{\partial^2 U_x}{\partial y^2}
+\dfrac{\partial^2 U_x}{\partial z^2}
-\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\quad\quad - \dfrac{\partial^2 U_z}{\partial z\,\partial y}
+\dfrac{\partial^2 U_y}{\partial z^2}
+\dfrac{\partial^2 U_y}{\partial x^2}
-\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \dfrac{\partial^2 U_y}{\partial x\,\partial z}
+\dfrac{\partial^2 U_x}{\partial x^2}
+\dfrac{\partial^2 U_z}{\partial y^2}
-\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$

* L'ordre de dérivation n'important pas,    
$`\big(\text{exemple :}\;\dfrac{\partial^2}{\partial x\,\partial y}=\dfrac{\partial^2}{\partial y\,\partial x}\big)`$,   
  nous remarquons alors que toutes les dérivées partielles du second ordre correspondant à
  des termes croisés de coordonnées s'annulent :

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
$`\require{cancel}\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\, \partial y}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial x \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial y\,\partial x}}}
+\dfrac{\partial^2 U_x}{\partial y^2}
+\dfrac{\partial^2 U_x}{\partial z^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial z\,\partial x}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial y \,\partial x}}}+\dfrac{\partial^2 U_y}{\partial y^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial z\,\partial y}}}
+\dfrac{\partial^2 U_y}{\partial z^2}
+\dfrac{\partial^2 U_y}{\partial x^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial x\,\partial y}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial z \,\partial x}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial z \,\partial y}}}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\,\partial z}}}
+\dfrac{\partial^2 U_x}{\partial x^2}
+\dfrac{\partial^2 U_z}{\partial y^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y\,\partial z}}} \\
\end{array}\right)`$

* Au total nous obtenons l'expression simple **en coordonnées cartésiennes** :

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
**$`\quad =\left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\\
\dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\\
\dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$**

* Nous reconnaissons l'expression cartésienne de l'opérateur laplacien vectoriel.

* L'opérateur combiné $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
constitue la **définition de l'opérateur laplacien vectoriel** :   
<br>
**$`\large{\overrightarrow{\Delta}=\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$**

<br>

----------------------------------

<br>

##### 4 - Relation entre les propriétés locales d'un champ vectoriel et sa propagation

* Tout champ vectoriel $`\overrightarrow{U}`$ (continue et au moins deux fois dérivable) 
possède son champ $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$.

* *Si le champ vectoriel $`\overrightarrow{U}`$ vérifie l'* **équation d'onde** :   
  <br><br>
  *$`\large{\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$
$`\;\;\large{-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}}`$*      
  <br><br>
  ou écrit avec le laplacien vectoriel :   
  <br><br>
  **$`\large{\overrightarrow{\Delta}\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}}`$**      
  <br><br>
  **alors le champ vectoriel $`f`$ se propage** *à la célérité $`\mathscr{v}`$*.







