---
title: 'Distributions cylindriques de charge'
published: true
routable: true
visible: false
lessons:
    -
        slug: gauss-integral-cylindrical-symmetry-3-linear
        name: LINÉAIRE : Symétrie cylindrique avec Gauss intégral
        order: 1
    -
        slug: gauss-local-cylindrical-symmetry-3-linear
        name: LINÉAIRE : Symétrie cylindrique avec Gauss local
        order: 1
    -   
        slug: gauss-theorem-cylindrical-symmetry-3
        name: "PARALLÈLE : Symétrie cylindrique, Gauss intégral et local"
        order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------


### Distributions de charge à symétrie cylindrique


##### Définition et propriétés d'une distribution de charge à symétrie cylindrique. <!-- et repère cylindrique $`(O,\rho, \varphi, z)`$-->

<br>
Une distribution de charge, notée $`\dens`$, à symétrie cylindrique sera ici définie comme une distribution qui possède à la fois une symétrie
de révolution autour d'un axe appelé axe de révolution, et une symétrie de translation selon ce même axe de révolution.

Le système de coordonnées spatiales le mieux adapté pour décrire une telle distribution est le 
système de coordonnées cylindriques $`(O, \rho, \varphi, z)`$ où l'axe $`Oz`$ est l'axe de révolution du cylindre.
L'origine $`O`$ du système de coordonnées est un point choisi sur l'axe de révolution.
$`(\rho, \varphi, z)`$ sont les coordonnées cylindriques associées à tout point de l'espace.

La base orthonormée associée pour exprimer des grandeurs vectorielles dérivant de cette distribution de charge est
la base cylindrique $`(\overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$. 
$`(O,\overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$ est le repère orthonormé cylindrique
associé.

Toute distribution de charge $`\dens`$ exprimée en coordonnées cylindriques s'écrit $`\dens(\rho, \varphi, z)`$.
Considérons un point $`P`$ quelconque de l'espace de coordonnées $`(\rho_P,\varphi_P,z_P)`$.

La symétrie de révolution autour de l'axe $`Oz`$ signifie la valeur de la densité de charge
est égale ce point $`P`$ et en tout point $`M`$ de coordonnées de type $`(\rho_M,\varphi_M,z_M)=(\rho_P,\varphi_P+\Delta\varphi,z_P)`$
où $`\Delta\varphi\in[0,\,2\pi[`$. Il n'est alors plus nécessaire d'exprimer la densité de charge $`\dens`$ en fonction de $`\varphi`$,
et nous écrirons :

$`\require{cancel}\dens=\dens(\rho,\xcancel{\varphi},z)=\dens(\rho,z)`$.

La symétrie de translation selon l'axe $`Oz`$ signifie que la valeur de la densité de charge
est égale ce point $`P`$ et en tout point $`M`$ de coordonnées de type $`(\rho_M,\varphi_M,z_M)=(\rho_P,\varphi_P,z_P+\Delta z)`$
où $`\Delta z\in ]-\infty,\,+\infty[`$. La valeur de la densité de charge $`\dens`$ ne dépend alors plus de la coordonnée $`z`$
et nous écrirons :

$`\require{cancel}\dens=\dens(\rho,\varphi,\xcancel{z})=\dens(\rho,\varphi)`$.

Au final, l'expression d'une distribution de charge à symétrie cylindrique, lorsqu'elle s'exprime
dans un système de coordonnées cylindrique adapté (système pour lequel l'axe $`Oz`$ est l'axe de révolution
de la distribution de charge), ne dépend plus que de la coordonnées $`\rho`$.

$`\left.\begin{array}{l}
\dens=\dens\,(\rho, z) \\
\dens=\dens\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow\dens=\dens(\rho)`$



##### Distributions volumique, surfacique et linéïque de charge

L'espace réel perçu possède 3 dimensions, les charges occupent les trois dimensions 
spatiales et tout point point de l'espace peut être caractérisé par une densité volumique de charge $`\dens`$
d'unité SI (pour Système International d'unité) $`Cm^{-3}`$.

$`\dens = \dens\,(\rho, \varphi, z)\quad`$ $`Cm^{-3}`$

!!!! *Attention* :   
!!!!
!!!! La *lettre grecque "rho"* désigne traditionnellement à la fois :
!!!! * la *coordonnée rho* du repère cylindrique.
!!!! * une *densité volumique* (densité volumique de charge, densité volumique de masse = masse volumique, ...).
!!!!
!!!! Pour distinguer ces deux significations de la lettre rho et éviter toute confusion, *M3P2 utilise* deux police de caractères différentes de cette même lettre rho :
!!!!
!!!! * *$`\large\rho`$* est la *coordonnée rho* du repère cylindrique.   
!!!! * *$`\dens`$* représente une *densité volumique*.

<!------
Dans le cas de charges localisées au voisinage d'une surface ,sur une couche d'épaisseur $`e`$ négligeable, 
alors un point de cette surface peut être caractérisé par une densité surfacique de charge $`\dens^{2D}`$
d'unité SI $`Cm^{-2}`$. Densité surfacique se dit aussi densité superficielle. Si les charges 
sont sur la surface latérale du cylindre, la densité surfacique s'écrit :

$`\dens^{2D} = \dens^{2D}\,(\varphi, z)\quad`$ $`Cm^{-2}`$

Dans la case de charges réparties sur une ligne de section droite $`S_{\perp}`$ négligeable, 
tout point de cette ligne peut être caractérisé par une densité linéïque de charge $`\dens^{1D}`$
d'unité SI $`Cm^{-1}`$. Dans ce cas la densité linéïque de charge s'écrit : 

$`\dens^{1D} = \dens^{1D}\,(z)\quad`$ $`Cm^{-1}`$

-------->

! *Important* :   
!
! *Densités surfaciques et linéïque* de charge résultent d'une *idéalisation*, d'une *modélisation 2D et 1D* de la distribution des charges dans l'espace.   
!
! Si d'une façon générale, à l'échelle d'observation les grandeurs physiques et les champs varient de façon continue dans l'espace 3D, *des discontinuités peuvent apparaître* lors des modélisations 2D ou 1D.    
!
! Ces discontinuités correspondent à une perte d'information, aux variations continues ignorées des grandeurs physiques et des champs le long des dimensions négligées. 

!! *Pour aller plus loin* :   
!!
!! Un *point* est une *abstraction mathématique sans dimension* (0D) de volume nul. 
!!
!! Il représente un *petit volume* entourant tout point M, *non résolu à l'échelle d'observation* spatiale, mais suffisamment grand pour que la valeur moyenne de la grandeur physique exprimée en ce point soit statistiquement stable à l'échelle d'observation temporelle.  
!!  
!! Un tel volume est dit *volume mésoscopique*. 
!! 
!! Cette notion de volume mésoscopique sera précisée et utilisée dans les diverses études 
!! sur les propriétés physiques de la matière, dès ce niveau contrefort puis au niveau montagne.


<!--------
##### Les distribution de charge à symétrie de révolution, de forme cylindrique

  
Un cylindre de rayon $`R`$ uniformément chargé est un exemple de distribution de charge 
à symétrie de révolution qui peut être décrite, dans le repère cylindrique associé, par :

* la densité volumique de charge $`dens^{3D}`$ :   
$`\left\{\begin{array}{ll}
\rho\le R \Longrightarrow \dens^{3D}(\rho)=\dens^{3D}_0 = cste\ne 0 \\
\rho\gt R \Longrightarrow \dens^{3D}(\rho)= 0
\end{array}\right.`$

* lorsque la section droite du fil est négligée, par la densité surfacique de charge $`\dens^{1D}`$ : 
$`\left\{\begin{array}{ll}
r = 0 \Longrightarrow \dens^{1D}(\rho)=\dens^{1D}_0 = cste\ne 0 \\
r \ne 0 \Longrightarrow \dens^{1D}(\rho)=0
\end{array}\right.`$
-------->







