---
title: Équations de Maxwell , fondement de l'électromagnétisme
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - les équations de Maxwell
      order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-media
       name: PARALLÈLE : Propagation des ondes EM, du vide aux milieux matériels
       order: 1

---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Quel fut le travail de Maxwell ?

À construire... synthèse des résultats expérimentaux de l'époque... AU final (cel à pris du temps)
4 équations posées.

![](Maxwell-equation-fr.png)

#### Pourquoi disons-nous "équations" et pas "théorèmes" de Maxwell ?

#### Pourquoi ces équations fondent l'électromagnétisme ?

#### Quel est le domaine de validité de ces équations ?

#### Que sont ces 4 équations de Maxwell ?

##### Sous forme locale

* Deux **expressions de divergence** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ *inchangées par rapport au cas stationnaire* (électrostatique et magnétostatique) :

   * **$`\mathbf{div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Gauss*).

   * ** $`\mathbf{div \overrightarrow{B} = 0}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-flux*).


* Deux **expressions de rotationnel** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ qui *changent et couplent les champs $`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$* :

   * **$`\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**
   &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Faraday*).

   * **$`\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Ampère*).

* où :
   * $`\dens=\dens^{3D}`$ est la densité volumique de charge. 
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ est le vecteur densité volumique de courant. 

------------------

* Et ces équations *réécrites avec l'opérateur nabla : $`\mathbf{\nabla}`$ *

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**


------------------


##### Sous forme intégrale

* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

* *Maxwell-Gauss* :   
     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
\iiint_{\Ltau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\Ltau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**


* *Maxwell-flux* :

     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, \overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}`$
  $`\Longrightarrow \iiint_{\Ltau} \overrightarrow{rot} \;\overrightarrow{E}\,d\tau = \iiint_{\Ltau}\left(-\dfrac{\partial \overrightarrow{B}}{\partial t}\right) d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} \overrightarrow{rot} \;\overrightarrow{E}\,d\tau = \iiint_{\Ltau}\left(-\dfrac{\partial \overrightarrow{B}}{\partial t}\right) d\tau \\
\text{Newton : espace et temps indépendants
\end{array}\right\}
\Longrightarrow`$
$`\iiint_{\Ltau} \overrightarrow{rot} \;\overrightarrow{E}\,d\tau = -\dfrac{\partial \overrightarrow{B}}{\partial t}\iiint_{\Ltau}\overrightarrow{B} d\tau`$   


   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0 \\
\iiint_{\Ltau} div\;\overrightarrow{B} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

* *Maxwell-Faraday* :

     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{B} = 0`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0`$   


$`\left.\begin{array}{l}
\cdot\cdot\cdot \\
\cdot\cdot\cdot
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\cdot\cdot\cdot}`$**

* *Maxwell-Ampère* :

$`\left.\begin{array}{l}
\cdot\cdot\cdot \\
\cdot\cdot\cdot
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\cdot\cdot\cdot}`$**



#### Pourquoi parlons-nous de champ électromagnétique ?


#### Le champ électromagnétique contient-t-il de l'énergie ?


#### Pourquoi parlons-nous d'ondes électromagnétiques ?


#### Qu'est-ce que le vecteur de Poynting ?


#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?


#### Comment émettre une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles


#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles









