---
title: 'nouveau cours : synthèse'
published: true
visible: true
---

### Qu'est ce que l'imagerie optique?

#### Objectif

* **Optique** $\Longrightarrow$ domaines *visible* + *proche infrarouge* + *proche UV*

* **Réaliser des images optiques d'objects physiques** pour être *vues à l'oeil nu* *ou* pour être *capturées par un capteur d'image*.

* **par l'utilisation** d'*éléments optiques simples* qui peuvent être combinés en *systèmes optiques* pour former des *instruments optiques*.

#### Object physique

* **Objet physique** : *volume* de matière (solide ou liquide) *grand* (comparé à  $\lambda_{optical}$) dont *la surface externe peut être décomposée mentalement en un très grand nombre de surfaces microscopiques*.

* **Point objet physique** = **source ponctuelle** : <br>
\- *surface microscopique* partie de la surface totale de l'objet physique.<br>
\- *émet* or *diffuse la lumière dans toutes les direction* en dehors du volume. Se dit de façons équivalentes :  émet une *onde sphérique* (_optique ondulatoire_), émet des **rayons lumineux** (_optique des rayons_), émet des *photons* (_optique quantique_) qui **divergent à partir de la source ponctuelle**.

* **Faisceau lumineux** issu du point source : partie de la *__lumière émise par une source ponctuelle__* qui *intercepte un système optique* ou *passe à travers un diaphragme* limitant l'ouverture du faisceau.
<!-- In the main part, make the difference between pencil or bundle of rays, and the beam of an extended source. In optics, only pencils are really importants.
And to say in a warning that if the difference is made in term between pencil and beam in English, it is not made in French (faiscaeu). In Spanish?-->

* **voir à l'oeil nu** = **vision directe** d'un objet : les *faisceaux* de tous les points source visible de l'objet *interceptent la pupille de mon oeil*.

![](vision-object-b.jpg)<br>
Fig. 1. Vision directe : les faisceaux de tous les points source visibles de l'objet interceptent la pupille de mon oeil.

#### Image optique

* L'objet est vu sous un **angle de vue**, dont la direction principale nommée **ligne de visée** définit (_lorsque orienté positivement dans le sens de la lumière incidente_) l'**axe optique** du système imageur.

* Le *faisceau lumineux issu et divergent de chaque point source* de l'objet et qui intercepte le système imageur, après interaction *converge vers un nouveau point* de l'espace appelé **point image réel**, ou *diverge à partir d'un nouveau point* de l'espace appelé **point image virtuel**.

* **Image** : *ensemble de tous les points réels et virtuels*. 
 
* **cohérence de forme** entre objet initial et son image, mais des *distorsions de forme peuvent apparaître*.

![](vision-image.jpg)<br>
Fig. 2a. Vision d'une image : un imageur (rectangle) a modifié les faisceaux incidents issu des points sources. Seuls les faisceaux issus des points images entrent dans mon oeil. Ici les points image sont réels.

![](image-virtuelle.jpg)<br>
Fig. 2b. Ici les points image sont virtuels.

#### Imageur optique, principes physiques de base

** Imageur** :
* **intercepte une partie de la lumière** émise ou diffusée par l'objet physique.
* *modifie le faisceau* de lumière issu de chaque source ponctuelle, en un **nouveau faisceau** qui :<br>
\- *converge* en un autre point de l'espace $\Longrightarrow$ *concentration d'énergie lumineuse* en ce point.<br>
\- *diverge* à partir d'un autre point de l'espace $\Longrightarrow$  *pas de concentration d'énergie lumineuse* en ce point.

**Imageur optique** :
* créé une *image* en **vraies trois dimensions** de la surface orientée vers l'imageur de l'object étendu.
* utilise les phénomènes de **réfraction et/ou réflexion**.
<!-- In main or beyond, talk about this, in a comment. Term "optical", contradiction. "visible?" or "refraction/reflexion use?". Holographic image work in the visible range too, but is based on diffraction pehnomenon. 
for science : optics refer specifically to the visible range.
for technology : same... but in geométrical optics, we consider only imager bse on refraction and reflexion phenomena-->
* peut être : un **élément optique simple mince** ou un **système optique centré**

![](vision-object-image-2.jpg)<br>
Fig. 3a. En utilisant les phénomènes de réfraction et réflexion, un imageur optique modifie les faisceaux incidents issus de chaque point source, pour donner des faisceaux émergents qui concentrent réellement l'énergie lumineuse des points source en des points images réelles, ou qui divergent à partir de points image virtuels. Ici une image réelle est observée.

![](Object-image_virtual.jpg)
Fig. 3b. Ici une image virtuelle est observée.

#### Element optique simple mince

*  souvent possède une **symétrie de révolution autour d'un axe**.<br>

![](sym_rev_2.gif)<br>
Fig. 4. Elément optique mince simple : élément réfractant ou réfléchissant, présentant une symétrie de révolution autour d'un axe.

* **Mince** $\Longrightarrow$ *diamètre $\gg$ épaisseur ou profondeur*.

* **Simple** : surfaces des éléments optiques *simples* sont *planes ou s'inscrivent dans une sphère.*

* **Elements optiques simples minces** étudiés seront :<br>
\- *dioptres plans* ou *dioptres sphériques minces*.<br>
\- *miroirs plans* ou *miroirs sphériques minces*.<br>
\- *lentilles minces*.

#### Système optique centré

* **Combinaison** *d'éléments optiques simples minces* **centrés** *sur un axe de révolution commun*  qui devient l'axe optique du système (_quand orienté positivement dans la direction de la lumière incidente sur le système)._

* *Intérêt* : peut être **caractérisé comme un tout**.

![](axe_opt.gif)<br>
Fig. 5. Système optique centré : combinaison d'éléments optiques simples minces centrés sur un axe de révolution commun.

### Quel cadre physique pour décrire l'imagerie optique ?

#### De l'idéalisation mathématique à la réalité physique.

* **Point** : concept mathématique de point mathematical.<br>
a une *position* dans l'espace, mais *pas d'extension*, *pas de volume*, *pas d'orientation*.

* **Point image** signification physique :  Le faisceau émergent d'un imageur converge (point image réel) ou semble diverger (point image virtuel) d'un volume de dans l'espace si petit que son *extension peut être négligée*, parce que :<br>
\- l'extension de son volume ne peut être résolue à l'oeil nu.<br>
\- la surface illuminée est inférieure au pixel d'un capteur d'image.

<!-- attention là : un peu faux, mais ne pas dire à ce niveau : un point "Pour aller plus loin" avec le critère de Shanon appliqué à l'imagerie? -->

* **système optique stigmatique** : *donne un point image à chaque point objet* (**n'existe pas**).

* **système optique quasi-stigmatique** : *dans certaines conditions d'utilisation* un élément ou un système optique peut devenir **presque stigmatique** = **quasi-stigmatique** et s'appeler *imageurs*.

* **Imageur optique** = **élément ou système optique quasi-stigmatique** utilisé pour la formation d'images.

<!-- image required, to explain difference between a quasi-stagmatic and a no stigmatic optical element-->

#### Cadre de l'approximation paraxiale de l'optique des rayons.

* Nous utilisons le concept de  **rayon lumineux**, base de *l'optique des rayons*

* **optique des rayons** = **optique géométrique**

* Quand les *systèmes optiques sont considérés comme stigmatiques*, leur étude est réalisée dans le cadre de l'**approximation paraxiale de l'optique des rayons**.

* **Optique paraxiale des rayons** = *approximation paraxiale de l'optique des rayons* = *approximation paraxiale de l'optique géométrique*

* Un *faisceau qui diverge d'une source ponctuelle*, est modifié par un imageur et après émergence, *converge à nouveau vers un point image réel* ou *diverge depuis un point image virtuel*.<br><br>
&nbsp;&nbsp;équivalent à <br><br>
\- *tous les rayons issus d'un point source* sont déviés par l'imageur et *se croisent à nouveau au point image réel conjugué*, ou *leurs prolongements se croisent au point image virtuelle conjugué*.<br><br>
$\Longrightarrow$  la **connaissance de seulement deux rayons différents** issus du même point source et traversant l'imageur **est suffisante** pour déterminer la position du point image conjugué.

* Pour toute source ponctuelle et pour tout imageur, les **trajectoires de 3 rayons particuliers seront spécifiées.**.

![](imagerie-rays-optics.gif)<br>
Fig. 6a. Optique des rayons lumineux : 3 rayons particuliers sont spécifiés (2 sont suffisants) qui permettent de localiser le point image de tout point objet. Sur cette figure, l'imageur est une lentille mince convergente, et pour cette position de l'objet, l'image obtenue est réelle.

![](imagerie-rays-optics-image-virtual.gif)<br>
Fig. 6b. Sur cette figure, l'imageur est une lentille mince divergente, et pour cette position de l'objet, l'image obtenue est virtuelle.

### Comment est modélisé et caractérisé un élement optique simple mince en optique paraxiale des rayons ?

#### Element optique simple mince

* **Element optique simple mince** = élément optique dont *l'épaisseur peut être négligée devant son diamètre* **$\Longrightarrow$ représenté par un plan (Elt)**.

* Element optique simple mince* possèdent une **symétrie de révolution autour d'un axe** :<br>
$\Longrightarrow$ mêm comprtement optique dans tout plan contenant l'axe de symétrie.<br>
$\Longrightarrow$ *source ponctuelle et point image conjugué appartiennent à un même plan qui contient l'axe de symétrie.<br>
$\Longrightarrow$ travailler dans la **vue en coupe** correspondant à ce plan est **suffisant**.

* **Représentation** dans une vue en coupe contenant l'axe de symétrie : *sègment de droite [Elt] perpendiculaire à l'axe optique*.

* *Localisation* avec son **sommet S** : intersection de [Elt] avec l'axe optique.

#### Comportement optique

* \- A chaque source ponctuelle B correspond un unique point image B'.<br>
\- A chaque point image B 'correspond un point source unique B :<br>
$\Longrightarrow$ **B et B' sont des points conjugués**.

![](objeto-imagen-bb.jpg)<br>
Fig. 7a. Le faisceau incident sur l'élément optique est issu d'une source ponctuelle B. Ici, le faisceau correspondant émergent de l'élément optique converge vers un point image B' qui est un point image réel, parce que l'énergie lumineuse du faisceau émergent en concentrée en B'.

![](object-image-conjugate-virtual.jpg)<br>
Fig. 7b. Le faisceau incident sur l'élément optique est issu d'une source ponctuelle B. Ici, le faisceau correspondant émergent de l'élément optique  diverge encore. Mais son prolongement montre qu'il diverge à partir d'un point image B' qui est un point image virtuel, parce que l'énergie lumineuse de ce faisceau émergent continue de se disperser dans l'espace : pas de concentration de cette énergie en B'.

* Toutes les sources ponctuelles (A ; B, C, ...) appartenant à un même plan object (PO) perpendiculaire à l'axe optique ont des points image conjugés (A' ; B', C', ...) situés dans un même plan image (PI) perpendiculaire à l'axe optique :<br>
$\Longrightarrow$ **(PO) et (PI) sont des plans conjugués**.
![](plano-objeto-plan-image-bb.jpg)<br>
Fig. 8.

#### Coordonnées pour localiser les points objet et image

* Chaque point (objet et image) est *projeté perpendiculairement sur l'axe optique* :<br>
\- souce ponctuelle B $\Longrightarrow$ point A sur l'axe optique.<br>
\- point image conjugué B' $\Longrightarrow$ point A' sur l'axe optique.<br>

* *Distance d'un point à l'imageur optique* : **distance algébrique entre le sommet de l'imageur et la projection du point**.<br>
 \- distance de la source ponctuelle B à l'imageur [Elt] :  **$\overline{SA}$**<br>
\- distance du point image conjugué B' à l'imageur  [Elt]  :  **$\overline{SA'}$**

* *Distance d'un point par rapport à l'axe optique* : **distance algébrique entre la projection du point et le point lui-même**.<br>
 \- distance de la source ponctuelle à l'axe optique :  **$\overline{AB}$**<br>
\- distance du point image conjugué à l'axe optique :  **$\overline{A'B'}$**

![](objeto-imagen-posicion-tamano-bb.jpg)<br>Fig. 9a.

![](object-image-plan-conjugate-virtual.jpg)<br>Fig. 9b.

#### Caractérisation d'un élément optique simple mince

**4 points ** *localisés sur l'axe optique* caractérisent le comportement optique : **S , C, F' and F**

* **S** : **sommet** de l'imageur mince : *indique sa position* dans l'espace, et sur l'axe optique.
*  **C** : **point nodal** : par définition *tous les rayons* (ou leurs prolongements) qui *passent par le point nodal C* ne sont *pas déviés* lors de la traversée de l'élément optique. Position caractérisés par sa distance algébrique au sommet S : $\overline{SC}$.<br>
Le *point nodal* est un *centre* (_dont la signification physique exacte dépend du type d'élement optique simple mince._)

*   **F'** : **point focal image** : tous les *rayons incidents* (ou leurs prolongement) *parallèles à l'axe optique* *après traversée* de l'imageur mince, *passent par F'*.
*   **F** : **point focal objet** : tous les *rayons incidents* (ou leurs prolongement)  *passant par F , ressortent** de l'imageur *parallèles à l'axe optique*.

qui définissent **3 plans importants, perpendiculaires à l'axe optique**

* **(Elt)** : représentation de **l'imageur miçnce, contient S** : les *rayons incidents changent de direction à la traversée de (Elt)*.
* **(P')** : **plan focal image, contient F'** : *tous les rayons incidents parallèles entre eux* issus d'une source ponctuelle à l'infini *quittent (Elt) pour converger* (ou leurs prolongements) *en un point image B' appartenant à (P')*. Localisation de B' dans (P') : *intersection du rayon passant par C avec (P')*.
* **(P)** : **plan focal objet, contient F** : *tous les rayons incidents provenant d'une même source ponctuelle B quittent (Elt) parallèles entre eux*, donnant un point image B' localisé à l'infini, *dans la direction du rayon passant par C*.

et **2 importantes distances algébriques**

* **$f'=\overline{SF'}$** : *distance algébrique entre l'imageur mince (Elt) et le plan focal image (P')* :<br>

* **$f=\overline{SF}$** : *distance algébrique entre l'imageur mince (Elt) et le plan focal objet (P)* :<br>


### Significations importantes des plans focaux

#### Plan focal image :

* *Sens physique* :<br> **objet B à l'infini $\Longleftrightarrow |\overline{SB}| \ll |f|$**.

* **Objet à l'infini  $\Longleftrightarrow$ image dans (P')**,  **visible à l'oeil nu** que l'élément optique soit convergent ou divergent.


![](plano-imagen-real-convergencia-bb.jpg)<br>
Fig. 10. Exemple : vision directe du ciel étoilé à travers un télescope. Un télescope n'est pas un imageur mince, mais la définition du plan focal image est la même).

* **Object at infinity  $\Longleftrightarrow$ ilmage dans (P')**, peut être **capturée par un capteur d'image** *seulement si l'élément optique est convergent (pour avoir une image réelle dans ce cas).
* 
![](plano-imagen-real-convergencia-pantalla-bb.jpg)<br>
Fig. 11. Exemple : photo prise avec un téléobjectif (un téléobjectif n'est pas un imageur mince, mais la définition du plan focal image est la même).

#### Plan focal object (P)

* *Sens physique* :<br> **image B' à l'infini $\Longleftrightarrow |\overline{SB'}| \ll |f'|$**.

* **Object dans (P) $\Longleftrightarrow$ image à l'infini**

![](plano-objeto-fisico-bb.jpg)<br>
Fig. 12. Exemples : l'objet peut être l'ampoule d'un phare, ou la pellicule d'un film dans un projecteur de cinéma non numérique (faisceaux émergents quasi-parallèles pour éclairer devant et loin dans les deux cas).

### Comment déterminer l'image donnée par un élément optique simple mince? 

•	Entropie statistique :  entièrement d’accord avec vous, avec un simple système à 2 états pour commencer, bien définir la limite thermodynamique, évoquer le théorème de Poincaré, entropie et information,
entropie et désordre, entropie et chaos, entropie de Tsallis, entropie conditionnelle, etc…

#### Etude graphique

##### Deux échelles différentes <!--of image point-->

* Objet et image :  *tailles transverses $|\overline{AB}|$, $|\overline{A'B'}\;\;\ll$ distances par rapport à l'élément optique* le long de l'axe optique $|\overline{SA}|$ , $|\overline{SA'}|$.<br>
$\Longrightarrow$ dimensions perpendiculaires à l'axe optique $\ll$ dimensions le long de l'axe optique. 

* Donc **Etude graphique précise** $\Longrightarrow$ *dilater fortement l'échelle pour les mesures de distances perpendiculaires à l'axe optique*.

![](objeto-imagen-posicion-tamano-bb.jpg)<br>
Fig. 13.

##### Déterminer les points conjugués <!--of image point-->

D'un point donné (objet ou image) **3 rayons de lumières spécifiques peuvent être tracés** (2 seulement sont nécessaires), dont l*intersection* (ou l'intersection de leurs prolongements) *donne le point conjugué* :

![](objeto-imagen-3-rayos-bb.jpg)
Fig. 14.

* **[Ray1]** : Rayons incidents (ou leurs prolongements) passant à travers le foyer objet F quittent (ou leurs prolongements) l'imageur parallèlement à l'axe optique.
* **[Ray2]** : Rayons incidents (ou leurs prolongements) parallèles à l'axe optique ressortent de l'imageur en passant (les rayons ou leurs prolongements) par le foyer image F'.
* **[Ray3]** : Rayons incidents passant par le point nodal C ne changent pas de direction en émergent de l'imageur. 

##### Conséquences des définitions des points focaux

* Les **rayons incidents parallèles entre eux** (ou leurs prolongements) se croisent en un *même point du plan focal image* (P').<br>
(localisation : intersection de (P') avec [Ray3])

* Les **rayons émergents parallèles entre eux** (ou leurs prolongements) divergent d'une *même source ponctuelle située dans le plan focal objet* (P).<br>
(localisation : intersection de (P) avec [Ray3])


##### Déterminer le rayon émergent correspondant à un rayon incident quelconque.

* **déviation d'un rayon lumineux par une élement optique mince** : *interaction locale au point d'impact* (réfraction or réflexion) entre le rayon incident et l'élément optique mince $\Longrightarrow$ *indépendent de la distance de la source ponctuelle à l'origine du rayon incident*.
 
* Si le rayon incident quelconque était émis par une**source ponctuelle B à l'infini** $\Longrightarrow$  le point image conjugué *B' serait dans le plan focal image (P')*.

* le **rayon issu de B** (à l'infini) **passant par le point C** *ne change pas de direction* $\Longrightarrow$ *localisation de B' dans (P')*.

* Le **rayon émergent** (ou son prolongement) correspondant au rayon incident quelconque = *ligne droite entre le point d'impact et B'*.

![](rayon-incident-quelconque-5.gif)<br>
Fig. 15.

##### Déterminer le rayon incident correspondant à un rayon émergent quelconque

* **déviation d'un rayon lumineux par une élement optique mince** : *interaction locale au point d'impact* (réfraction or réflexion) entre le rayon incident et l'élément optique mince $\Longrightarrow$ *indépendent de la distance au point image*.
 
* Si le rayon émergent quelconque participait à un **point image B' à l'infini** $\Longrightarrow$  la source ponctuelle conjugués *B serait dans le plan focal objet (P)*.

* Le **rayon émergent vers B'** (à l'infini) **passant par le point nodal C** ne change ps de direction* $\Longrightarrow$ *location de B dans (P)*.

* **rayon incident** correspondant (ou son prolongement) = *ligne droite entre le point d'impact et B*.


#### Etude analytique <!--of image point-->

##### Distance d'un point conjugué à l'élément optique mince

* déduite à partir de la **relation de conjugaison** de l'élement optique mince.

* seront donnés les relations de conjugaisons pour:<br>
\- *miroir sphérique mince*<br>
\- *dioptre sphérique mince*<br>
\- *lentille mince*<br>
(relations démontrées au niveau contreforts)

##### Distance d'un point conjugué à l'axe optique

* déduite à partir du **grandissement transverse $\gamma_T$**.

* **Définition** : **$\gamma_T=\dfrac{\overline{A'B'}}{\overline{A'B'}}$**

* **$\gamma_T>0$** *$\Longleftrightarrow$* **image droite**<br>
  **$\gamma_T<0$** *$\Longleftrightarrow$* **image inversée**

* **Expression** : *dépends du* type d' *élément optique simple* :<br>
Seront données les expressions pour :<br>
\- *miroir sphérique mince*<br>
\- *dioptre sphérique mince*<br>
\- *lentille mince*<br>
(relations démontrées au niveau contreforts)

* **valeur algébrique de  $\gamma_T$** : est une *fonction de $\overline{AB}$ et $\overline{A'B'}$*<br>
$\Longrightarrow$ dépends de la position des points conjugués<br>
$\Longrightarrow$ **ne caractérise pas l'élement optique** lui-même.

### Comment caractériser l'action d'un imageur ?

#### Caractériser un objet étendu

* Object étendu [AB] or [B$_1$B$_2$], **perpendiculairement à l'axe optique** :<br><br>
\- caractérisé par sa *taille algébrique transverse* (distance entre ses extrémités) : **$\overline{AB}$** ou **$\overline{B_1B_2}$**<br><br>
\- ou caractérisé par l'*angle apparent* (en valeur algébrique ou non) *sous lequel l'objet est vu depuis le point nodal* de l'oeil (vision directe) ou de l'imageur mince : **$\alpha$** ou **$\overline{\alpha}$**

* Object étendu [A$_1$A$_2$] **le long de l'axe optique** :<br><br>
caractérisé par sa *taille algébrique longitudinale* (distance entre ses extrémités) : **$\overline{A_1A_2}$** 

####  caractérisation de l'image étendue conjuguée

* Image étendue [A'B'] or [B'$_1$B'$_2$], **perpendiculairement à l'axe optique** :<br><br>
\- caractérisée par sa *taille algébrique* (distance entre ses extrémités) : **$\overline{A'B'}$** ou **$\overline{B_1'B_2'}$**<br><br>
\- ou caractérisée par l'*angle apparent* (en valeur algébrique ou non) *sous lequel l'objet est vu depuis le point nodal* de l'oeil (vision directe) ou de l'imageur mince : **$\alpha$** or **$\overline{\alpha}$**

* Image étendue  [A'$_1$A'$_2$] **le long de l'axe optique** :<br><br>
caractérisée par sa *taille algébrique* (distance entre ses extrémités) : **$\overline{A'_1A'_2}$** 

#### Caractériser l'action d'un imageur sur un objet étendu

L'imageur donne une image d'un objet. La **caractérisation de l'action de l'imageur** dépend de *comment sont caractérisés l'objet et l'image*.

##### Grandissement transverse d'un objet étendu

* *Objet et image* sont tous deux **caractérisés par leur taille algébriques transverses** :<br>
**$\Longrightarrow$** *action de l'imageur* caractérisée par **grandissement transverse $\gamma_T$**<br><br>
**$\gamma_T=\dfrac{image\:size}{objet\:size}=\dfrac{\overline{A'B'}}{\overline{AB}}$**

##### Grossissement d'un objet étendu

* *Objet et image* sont tous deux **caractérisés par leur angle apparent** :<br>
**$\Longrightarrow$** *action de l'imageur* caractérisée par le **grossissement $G$**<br><br>

**$G=\dfrac{image\:apparent\:angle}{objet\:apparent\:angle}=\dfrac{\overline{ \alpha'}}{\overline{ \alpha }}$**<br><br>
ou $G=\pm\dfrac{ \alpha'}{ \alpha }$, avec signe + si image droite, signe - si image inversée.<br><br>

![](apparent-magnitude-magnifying-glass-1018.gif)<br>
Fig. 16. Dans cette expérience, l'objet observé est situé à une certaine distance de la loupe, ainsi que l'oeil de l'observateur. Pour ces conditions d'utilisation, la loupe donne un grossissement de +2.5. Il y a des conditions  d'utilisation optimum de la loupe (voir chapitre "instruments optiques").

!!!! *ATTENTION*<br>
!!!! Un angle apparent sous lequel est vu un objet ou une image dépend de la distance entre l'objet ou l'image et le point nodal du système observateur (oeil humain, ou objectif d'un appareil photo par exemple) $\Longrightarrow$ Il faudra définir plus précisément l'angle apparent (voir chapitre "instruments optiques").

##### Grandissement longitudinal d'un objet étendu

* *Objet et image* sont tous deux **caractérisés par leur taille algébrique longitudinale** :<br>
**$\Longrightarrow$** *action de l'imageur* caractérisée par le **grandissement longitudinal $\gamma_L$**<br><br>
**$\gamma_L=\dfrac{image\:size}{objet\:size}=\dfrac{\overline{A'_1A_2'}}{\overline{A_1A_2}}$**





<!--
![](objeto-fisico-imagen-virtual-haz-3-rayons-pantalla-bb.jpg)

![](objeto-fisico-imagen-virtual-haz-3-rayos-bb.jpg)

![](objeto-fisico-imagen-virtual-pantalla-bb.jpg)

![](objeto-imagen-3-rayos-bb.jpg)

![](objeto-imagen-haz-3-rayos-bb.jpg)

![](plano-imagen-real-convergencia-bb.jpg)

![](objeto-imagen-posicion-tamano-bb.jpg)

![](plano-imagen-real-convergencia-pantalla-bb.jpg)

![](plano-objeto-fisico-bb.jpg)

![](plano-objeto-plano-imagen-real-pantalla-bb.jpg) -->





