---
title: Definir las herramientas matemáticas de nivel 3 : proposición 1 
published: true
routable: true
visible: false
lessons:
    - slug: define-234-mathematical-tools-p1
      order: 2
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\oint{\displaystyle\mathop{{\int}\mkern-16mu \scriptsize \bigcirc}}`$


#### Proposición 1

--------------------------------------------------------

#### Definir las herramientas matemáticas necesarias para el nivel 3 

--------------------------------------------------------

Por ahora, solo una **lista de necesidades en una primera clasificación** para organizar un poco la lluvia de ideas (conjuntos y logica, geometría, etc.). *No presagia títulos de capítulos*.

No presagia el programa de matemáticas, pero **permitirá de definir un programa de "herramientas matemáticas y conceptos físicos"**, que se construirá con los matemáticos.

Este tema "Herramientas matemáticas" será necesario, ya que será *común a todos los temas de las ciencias experimentales*. Cuando se utilizará una herramienta o concepto en el curso de un tema en particular, siempre será posible mostrar elementos de "Herramientas matemáticas" en modo paralelo.

No dude en crear una nueva clasificación si es necesario. 

-------------------------------------------------------------

Las *herramientas matemáticas de los niveles 1 y 2* **$`+`$** :

<!------------------------------------------------------------------------------
  NUNMERACION, OPERACIONES Y FUNCIONES COMUNES 
------------------------------------------------------------------------------->
! *Numeración, operaciones y funciones comunes *


(CME-FR) Buen dominio, con ejercicios de automatización.

* número imaginario **$`i`$**   
  Conjunto de los números imaginarios puros *$`\mathbb{I}`$* : **$`c=i\,b`$**    
  Conjunto de los números complejos $`\mathbb{C}`$ :    
  **$`c=a+i\,b= |c|\,e^{\,i\,\theta}`$**,   
   con **$`|c|=\sqrt{a^2 + b^2}`$** y **$`\theta\arctan\left(\dfrac{b}{a}\right)`$**     
  **$`c=a+i\,b= \mathcal{Re}(c)+i\,\mathcal{Im}(c)`$**

* función potencia $`y^x`$ 
* funcion exponencial **$`e^x`$**    
  Euler **$`e^{\,i\theta}=\cos\theta+ i\sin\theta`$**       
  **$`\cos\theta=\dfrac{e^{\,i\theta}+e^{\,-i\theta}}{2}`$**     
  ** $`\sin\theta=\dfrac{e^{\,i\theta}-e^{\,-i\theta}}{2i}`$**   
  <br>    
  y funciones hiperbólicas    
  **$`\cosh(x)=\dfrac{e^x+e^{\,- x}}{2}`$**   
  **$`\sinh(x)=\dfrac{e^x-e^{\,- x}}{2}`$**    

* **$`e^0=1 \quad , \quad`$**
**$`e^{\,i\frac{\pi}{2}}=i\quad , \quad`$**
**$`e^{\,i\pi}=-1\quad , \quad`$**, ...

* función logaritmo **$`log_p\,x`$**   
  propiedades de la función de registro, incluyendo la transformación de un producto en una suma : **$`log_p\,xy=log_p\,x+log_p\,y`$** 
  función logaritmo  **$`log_{10}\,x`$** en relación con la función potencia $`10^x`$   
  función logaritmo natural **$`Log\,x=ln\,x`$** en relación con $`exp(x)=e^x`$  

* notaciones reales y notación compleja : 
**$`\overrightarrow{U}=U_0\,\cos(k\,x-\omega t+\varphi)\overrightarrow{e}`$**   
**$`\overrightarrow{\underline{U}}=U_0\,e^{\,i\,(k\,x-\omega t+\varphi)}\overrightarrow{e}`$**
**$`\;=\underline{U_0}\,e^{\,i\,(k\,x-\omega t)}\overrightarrow{e}`$**       
**$`\overrightarrow{U}=\mathcal{Re}(\overrightarrow{\underline{U}})`$**

RESPONDER / COMENTAR :
(XXX'-YY') ...


---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------

<!------------------------------------------------------------------------------
  CONJUNTOS Y LÓGICA
------------------------------------------------------------------------------->
! *Conjuntos y lógica*

por hacer

RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------


<!------------------------------------------------------------------------------
 GEOMETRÍA Y COORDENADAS
------------------------------------------------------------------------------->
! *Geometría y coordenadas*

(CME-FR) Buen dominio, con ejercicios de automatización.

* Regla de *orientación del espacio*
   Sistemas de coordenadas, bases y r??? *directos o indirectos*

* *Coordenadas, bases vectoriales y ??? asociados*
   Bases y ???, *ortogonales, normalizadas, ortonormales, directos e indirectos*

* *Coordenadas cartesianas, cilíndricas y esféricas*
   * con *??? y bases asociadas*
   * *elementos infinitesimales* de longitud, área, volumen
   * expresiones de *operadores **$`\overrightarrow{grad}`$**, **$`div`$** et **$`\overrightarrow{rot}`$**
  
* *matriz de cambio de base ortonormal directo*:
  * $`\overrightarrow{e_i}\longrightarrow \overrightarrow{e_j}'`$ : $`(a)`$
  * $`\overrightarrow{e_j}'\longrightarrow \overrightarrow{e_i}'`$ : **$`(a')=(a)^t = (a)^{-1}`$**


RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------

<!------------------------------------------------------------------------------
  VECTORES, OPERADORES Y ANÁLISIS VECTORIAL
------------------------------------------------------------------------------->
! *Vectores y operadores, análisis de vectores*

(CME-FR) Buen dominio, con ejercicios de automatización.

*En una base euclidiana (3D)*:   

* Producto escalar **$`\overrightarrow{a}\cdot\overrightarrow{b}`$**
* Producto vectorial **$`\overrightarrow{a}\wedge\overrightarrow{b}`$** (notation $`\wedge`$ ou $`\times`$ )
* Producto mixto **$`(\overrightarrow{a},\overrightarrow{b},\overrightarrow{c})`$**

* Operadores **$`\overrightarrow{grad}`$**, **$`div`$** y **$`\overrightarrow{rot}`$** (notación $`\overrightarrow{rot}`$ ou $`\overrightarrow{curl}`$ )
  y notación con nabla (coordenadas cartesianas) :
  **$`\overrightarrow{\nabla}=\dfrac{\partial}{\partial x}\overrightarrow{e_x}+\dfrac{\partial}{\partial y}
  \overrightarrow{e_y}\dfrac{\partial}{\partial z}\overrightarrow{e_z}`$**

* Operador escalar laplaciano (coordenadas cartesianas)
 **$`\Delta=\dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$** 
 **$`\;=\overrightarrow{\nabla}\cdot\overrightarrow{\nabla}`$**

* Operador escalar de Alembert (coordenadas cartesianas)
*  **$`\Box=\Delta-\dfrac{1}{c^2}\dfrac{\delta^2}{\delta t^2}`$** (para las ondas)

* **$`\overrightarrow{rot}(\overrightarrow{grad}\,V)=0`$**, en relación con  
  $`\overrightarrow{rot}\,\overrightarrow{E}=0\quad\Longrightarrow\quad \exists V\;,\;\overrightarrow{E}=-\overrightarrow{grad}\,V`$

* **$`div\,(\overrightarrow{rot}(\overrightarrow{A}) =0`$**, en relación con    
  $`div\,\overrightarrow{B}=0 \quad\Longrightarrow\quad \exists \overrightarrow{A}\;,\;\overrightarrow{B}=\overrightarrow{rot}\,\overrightarrow{A}`$


RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------

<!------------------------------------------------------------------------------
MATRICES
------------------------------------------------------------------------------->
! *Matrices*

(CME-FR) Buen dominio, con ejercicios de automatización.

* Matrices $`(n,m)`$ : **$`\begin{pmatrix} a_{11} & \ldots & a_{1m} \\ \vdots & \ddots & \vdots \\ a_{n1} & \ldots & a_{nm}\\ \end{pmatrix}`$**
* Suma de matrices **$`(n,m) + (n,m)`$**
* Producto de matrices **$`(n,m)\cdot (m,p) dot`$**
* Matriz transpuesta de una matriz cuadrada
* Cálculo matricial
* Determinante de una matriz cuadrada: 
  **$`\begin{vmatrix} a_{11} & \ldots & a_{1n} \\ \vdots & \ddots & \vdots \\ a_{n1} & \ldots & a_{nn}\\ \end{vmatrix}`$**  

RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------


<!------------------------------------------------------------------------------
  FUNCIONES - CÁLCULO DIFERENCIAL E INTEGRAL
------------------------------------------------------------------------------->
! *Funciones - Cálculo diferencial e integral*

(CME-FR) 

* Pasaje de la notación $`f'(x_0)`$ a **$`\left.\dfrac{df}{dx}\right|_{x_0}`$**    
  Pasaje de la notación $`f'(x)`$ a **$`\dfrac{df}{dx}`$**   
  ...   
  de $`f^{(n)}(x_0)`$ a **$`\left.\dfrac{d^{n}f}{dx^{n}}\right|_{x_0}`$**   
  de $`f^{(n)}(x)`$ a **$`\dfrac{d^{n}f}{dx^{n}}`$**   

* función derivada y función primitiva.

* integral simple
  * indefinida **$`\displaystyle\int f(x)\,dx`$**
  * definida **$`\displaystyle\int_{x_1}^{x_2} f(x)\,dx`$**

* integral múltiple (variables independientes)
  *  **$`\displaystyle\iint f(x,y)\,dx\,dy`$**
  *  **$`\displaystyle\iiint f(x,y,z)\,dx\,dy\,dz`$**

* diferencia entre :
  *  **$`\displaystyle\int f(x)\,dx`$** et **$`\oint f(x)\,dx`$**
  *  **$`\displaystyle\iint f(x,y)\,dx\,dy`$** et **$`\oiint f(x,y)\,dx\,dy`$**

RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------

<!------------------------------------------------------------------------------
  ÉCUACIONES
------------------------------------------------------------------------------->
! *Ecuaciones*

(CME-FR) 

*Resolución de sistemas de ecuaciones lineales* por  *método de la Matriz*


RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------

<!------------------------------------------------------------------------------
  ECUACIONES DIFERENCIALES
------------------------------------------------------------------------------->
! Ecuaciones diferenciales*


* ecuaciones diferenciales lineales de orden 1 (para el concepto de constante de tiempo, carga y descarga de un condensador)
   * por ejemplo : $`x(t)`$ es una función del tiempo   
**$`a\cdot\dfrac{dx}{dt}+b x=0`$**   
(la o las notaciones utilizadas no estan definidas aquí)
   * luego con el segundo miembro sinusoidal  
**$`a\cdot\dfrac{dx}{dt}+b x=c`$** 

* ecuaciones diferenciales lineales de orden 2 (para el estudio de osciladores mecánicos o eléctricos) 
   * por ejemplo : $`x(t)`$ es una función del tiempo      
**$`a\cdot\dfrac{d^2 x}{dt^2}+b\cdot\dfrac{dx}{dt}+b\cdot x=0`$**   
(la o las notaciones utilizadas no estan definidas aquí)
   * luego con el segundo miembro sinusoidal    
**$`a\cdot\dfrac{d^2 x}{dt^2}+b\cdot\dfrac{dx}{dt}+b\cdot x=d \cdot\cos(\omega t)`$**    

* la ecuación de onda    
**$`\dfrac{\partial^2 f}{\partial x^2}=\dfrac{1}{v}\cdot\dfrac{\partial^2 f}{\partial t^2}`$**  

* Sistema de orden 1 y dimensión 2 (un primer acercamiento a la dinámica poblacional o un curso transversal sobre sistemas)   
   * **$`\left\{\begin{array}{l} \dfrac{dx}{dt} = f(x,y)\\ \dfrac{dy}{dt}=g(x,y) \end{array}\right.`$**    
       con, por ejemplo, el modelo depredador-presa de Lotka-Volterra  : $`f(x,y)= a\cdot x -b\cdot xy`$ et $`f(x,y)= - c\cdot x +d\cdot xy`$ (¿en este nivel 3?) 

* *saber poner una situación en forma de sistema de ecuaciones diferenciales*, aunque no esté resuelto.


RESPONDER / COMENTAR :
(XXX'-YY') ...

---------------------

(XXX-YY) ...

RESPONDER / COMENTAR :
(XXX'-YY') ...

------------------

<!------------------------------------------------------------------------------
AUTRES
------------------------------------------------------------------------------->

(XXX-YY)
...

RESPONDER / COMENTAR :
(XXX'-YY') ...



