---
title : electromagnetic-waves-propagation-in-vacuum
published : true
routable: true
visible : false
lessons:
    -
       slug: electromagnetic-waves-propagation-in-vacuum
       name: LINÉAIRE-4 : Propagation des ondes EM dans le vide
       order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-isotropic-media
       name: PARALLÈLE-4 : Propagation des ondes EM, du vide aux milieux matériels isotropes
       order: 2
    -
       slug: from-waves-towards-electromagnetic-waves
       name: "PANORAMA-4 : caractériser une onde électromagnétique"
       order: 2
---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Ecriture</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### ÉLECTROMAGNÉTISME

### **Propagation des ondes électromagnétiques** *dans le vide*

<br>

RÉSUMÉ
: ---

<br>

![](titres_equations-propagation-E-B-vacuum.jpg)


#### Quelles sont les équations de propagation du champ électromagnétique dans le vide ?

* Les quatre équations de Maxwell impliquent :   
<br>
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t} `$   
<br>
$`\Delta \overrightarrow{B}-\mu_0\epsilon_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$

* Le **vide** est un *milieu homogène et isotrope* caractérisé en chacun de ses points par :   
   * une densité volumique de charge nulle : *$`\mathbf{\dens(\overrightarrow{r},t)=0}`$*
   * un vecteur densité volumique de courant nul : *$`\mathbf{\overrightarrow{j}(\overrightarrow{r},t)=\overrightarrow{0}}`$*


* Les constantes $`\mu_0\,,\, \epsilon_0\text{ et } c`$ vérifient **$`\mathbf{\mu_0\,\epsilon_0\,c^2=1}`$**

* Les **équations de propagation dans le vide** de $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$ deviennent :  
  <br>
   **$`\mathbf{\large{\Delta \overrightarrow{E}-\dfrac{1}{c^2}\;\dfrac{\partial^2 \overrightarrow{E}}
{\partial t^2}=\overrightarrow{0}}}`$**   
   <br>
   **$`\mathbf{\large{\Delta \overrightarrow{B}-\dfrac{1}{c^2}\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=\overrightarrow{0}}}`$**

<!----------------------

#### Que signifie propagation "libre" dans le vide ?

à faire


#### Quel apport nouveau par rapport à l'optique ondulatoire ?

à faire
prévoir parallélisme entre ce chapitre et optique ondulatoire (volets interférence et diffraction)


#### Comment modéliser la propagation d'une onde EM?

-------------------------->

<!--------------
#### Quels sont les différents modèles simples d'onde EM ?

* 

<br>

#### Quel est l'intérêt du modèle de l'OPPM ?

* l'**OPPM** est une *onde Plane, Progressive et Monochromatique*.

à faire, vient du théorème de Fourier

<br>

#### Qu'est-ce que la structure d'une OPPM ?

* La **structure** définit les *liens entre les vecteurs $`\overrightarrow{E}\,,\overrightarrow{B}\text{ et }\overrightarrow{k}`$*

* Il est *plus facile* de révéler la structure d'une OPPM en décrivant l'**onde en notation complexe**.

* Étudions dans l'ordre la structure d'une onde plane (OP), d'une onde plane progressive (OPP), 
puis d'une onde plane progressive monochromatique (OPPM).

<br>
----------->


<br><br>

![](titres_electromagnetic-wave-P-vacuum.jpg)


#### Qu'est-ce qu'une onde électromagnétique plane (OEMP) ?

* Une **onde électromagnétique $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ plane** est par définition une onde 
  telle qu'à tout instant $`t`$, 
  il *existe une direction particulière* représentée par un vecteur unitaire *$`\mathbf{\vec{n}}`$* telle que le champ électromagnétique
  *$`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ est uniforme en tout plan perpendiculaire à $`\vec{n}`$*

figure à faire

<br>

##### Quelle est la structure du champ $`(\overrightarrow{E},\overrightarrow{B})`$ associé à l'OEMP ?

* Le champ électromagnétique *$`(\overrightarrow{E},\overrightarrow{B})`$ associé à l'OEMP* doit à la fois :
   * vérifier les **équations de Maxwell**.
   * être **uniforme dans des plans parallèles** entre eux.  
     
<br>

##### Comment conduire l'étude de ce champ ?

* **Choisissons $`\big(O\,,\vec{e_x}\,,\vec{e_y}\,,\vec{e_z}\big)`$** un repère cartésien tel qu'en tout point $`M`$ 
  de l'espace, le champ $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ soit uniforme dans le plan
  $`\big(M\,,\vec{e_x}\,,\vec{e_y}\big)`$ perpendiculaire à *$`\mathbf{\vec{n}=\vec{e_z}}`$*. Nous avons alors :   
  <br>
  **$`\boldsymbol{\mathbf{\dfrac{\partial \overrightarrow{E}}{\partial x}=\dfrac{\partial \overrightarrow{E}}{\partial y}=0}}`$**   
  <br>
   *$`\boldsymbol{\mathbf{\Longrightarrow
   \dfrac{\partial E_x}{\partial x}=\dfrac{\partial E_y}{\partial x}=\dfrac{\partial E_z}{\partial x}}}`$
   $`\boldsymbol{\mathbf{\,=\dfrac{\partial E_x}{\partial y}=\dfrac{\partial E_y}{\partial y}=\dfrac{\partial E_z}{\partial y}=0}}`$*   
   <br>
   et   
   <br>
   **$`\boldsymbol{\mathbf{\dfrac{\partial \overrightarrow{B}}{\partial x}=\dfrac{\partial \overrightarrow{B}}{\partial y}=0}}`$**   
  <br>
   *$`\boldsymbol{\mathbf{\Longrightarrow
   \dfrac{\partial B_x}{\partial x}=\dfrac{\partial B_y}{\partial x}=\dfrac{\partial B_z}{\partial x}}}`$
   $`\boldsymbol{\mathbf{\,=\dfrac{\partial B_x}{\partial y}=\dfrac{\partial B_y}{\partial y}=\dfrac{\partial B_z}{\partial y}=0}}`$*   

<br>

* L'équation de **Maxwell-Gauss** implique *dans le vide ($`\dens=0`$)* :   
  <br>
  $`\left.
    \begin{align} &\underbrace{div\,\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}=0}_{\color{blue}{\text{éq. de Maxwell-Gauss}\\
    \text{dans le vide}}}\\
    \\
    &\overrightarrow{E}\;uniforme\\
    &dans\;tout\;plan\;\perp\overrightarrow{e_z}\end{align}\right\}`$   
    <br>
    $`\Longrightarrow\left\{
    \begin{align}
    &\dfrac{\partial E_x}{\partial x}+\dfrac{\partial E_y}{\partial y}
    +\dfrac{\partial E_z}{\partial z}=0\\
    \\
    &\dfrac{\partial E_x}{\partial x}=\dfrac{\partial E_y}{\partial y}=0
    \end{align}\right\}`$
    **$`\large{\boldsymbol{\mathbf{\Longrightarrow\;\begin{align}\\\dfrac{\partial E_z}{\partial z}=0\\\\(équa.1)\end{align}}}}`$**   
    
<br>

* L'équation de **Maxwell-Faraday** implique :   
  <br>
  $`\left.
    \begin{align} 
    &\underbrace{\overrightarrow{rot}\,\overrightarrow{E}=-\dfrac{\partial \overrightarrow{B}}{\partial t}}
    _{\color{blue}{\text{éq. de Maxwell-Faraday}}}\\
    \\
    &\overrightarrow{E}\;uniforme\\
    &dans\;tout\;plan\;\perp\overrightarrow{e_z}\end{align}\right\}`$   
    <br>
    $`\Longrightarrow\left\{
    \begin{align}
    &\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}=-\dfrac{\partial B_x}{\partial t}\\
    &\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}=-\dfrac{\partial B_y}{\partial t}\\
    &\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}=-\dfrac{\partial B_z}{\partial t}\\
    \\
    &\dfrac{\partial E_x}{\partial x}=\dfrac{\partial E_y}{\partial x}=\dfrac{\partial E_z}{\partial x}
    =\dfrac{\partial E_x}{\partial y}\\
    &\quad =\dfrac{\partial E_y}{\partial y}=\dfrac{\partial E_z}{\partial y}=0
    \end{align}\right\}`$   
<br>
    **$`\large{\boldsymbol{\mathbf{\Longrightarrow\left\{
    \begin{align}
    &\dfrac{\partial B_x}{\partial t}=+ \dfrac{\partial E_y}{\partial z}\\
    \\
    &\dfrac{\partial B_y}{\partial t}=- \dfrac{\partial E_x}{\partial z}\\
    \\
    &\dfrac{\partial B_z}{\partial t}=0
    \end{align}
    \right\}\quad(équa.2)
    }}}`$**
    
 <br>
 
* L'équation de **Maxwell-Thomson** implique *dans le vide* :
  <br>
  $`\left.
    \begin{align} &\underbrace{div\,\overrightarrow{B}=0}_{\color{blue}{\text{éq. de Maxwell-Thomson}}}\\
    \\
    &\overrightarrow{E}\;uniforme\\
    &dans\;tout\;plan\;\perp\overrightarrow{e_z}\end{align}\right\}`$   
    <br>
    $`\Longrightarrow\left\{
    \begin{align}
    &\dfrac{\partial B_x}{\partial x}+\dfrac{\partial B_y}{\partial y}
    +\dfrac{\partial B_z}{\partial z}=0\\
    \\
    &\dfrac{\partial B_x}{\partial x}=\dfrac{\partial B_y}{\partial y}=0
    \end{align}\right\}`$
    **$`\large{\boldsymbol{\mathbf{\Longrightarrow\;\dfrac{\partial B_z}{\partial z}=0\quad(équa.3)}}}`$**   

<br>

* L'équation de **Maxwell-Ampère** implique *dans le vide ($`\overrightarrow{j}=\overrightarrow{0}`$)* :  
  <br>
  $`\left.
    \begin{align} 
    &\underbrace{\overrightarrow{rot}\,\overrightarrow{B}=
    \mu_0\,\overrightarrow{j}+\overbrace{\mu_0\epsilon_0}^{=\;\dfrac{1}{c^2}}\,\dfrac{\partial \overrightarrow{E}}{\partial t}}_{\color{blue}{\text{éq. de Maxwell-Faraday}}}
     =\dfrac{1}{c^2}\,\dfrac{\partial \overrightarrow{E}}{\partial t}\\
    \\
    &\overrightarrow{B}\;uniforme\;
    dans\;tout\;plan\;\perp\overrightarrow{e_z}\end{align}\right\}`$   
    <br>
    $`\Longrightarrow\left\{
    \begin{align}
    &\dfrac{\partial B_z}{\partial y}-\dfrac{\partial B_y}{\partial z}=\dfrac{1}{c^2}\;\dfrac{\partial E_x}{\partial t}\\
    &\dfrac{\partial B_x}{\partial z}-\dfrac{\partial B_z}{\partial x}=\dfrac{1}{c^2}\;\dfrac{\partial E_y}{\partial t}\\
    &\dfrac{\partial B_y}{\partial x}-\dfrac{\partial B_x}{\partial y}=\dfrac{1}{c^2}\;\dfrac{\partial E_z}{\partial t}\\
    \\
    &\dfrac{\partial B_x}{\partial x}=\dfrac{\partial B_y}{\partial x}=\dfrac{\partial B_z}{\partial x}=\dfrac{\partial B_x}{\partial y}\\
    &\quad =\dfrac{\partial B_y}{\partial y}=\dfrac{\partial B_z}{\partial y}=0
    \end{align}\right\}`$   
    <br>
    **$`\large{\boldsymbol{\mathbf{\Longrightarrow\left\{
    \begin{align}
    &\dfrac{\partial B_y}{\partial z}=- \dfrac{1}{c^2}\;\dfrac{\partial E_x}{\partial t}\\
    \\
    &\;\dfrac{\partial B_x}{\partial z}=+ \dfrac{1}{c^2}\;\dfrac{\partial E_y}{\partial t}\\
    \\
    &\;\dfrac{\partial E_z}{\partial t}=0
    \end{align}\right\}
    \quad(équa.4)
    }}}`$**

<br>

* Les *équations 1 et 4* impliquent la constance, soit l'**uniformité et la stationnarité de $`E_z`$**, composante 
  *selon la direction de propagation* du champ électrique $`\vec{E}`$ :   
  <br>
  $`\dfrac{\partial E_z}{\partial z}=0\quad\text{et}\quad\dfrac{\partial E_z}{\partial t}=0\quad\Longrightarrow`$**$`\large{\mathbf{\quad E_z = cste}}`$**   
  <br><br>
  De même, les *équations 2 et 3* impliquent la constance, soit l'**uniformité et la stationnarité de $`B_z`$**, composante 
  *selon la direction de propagation* du champ magnétique $`\vec{B}`$ :
  <br>
  $`\dfrac{\partial B_z}{\partial z}=0\quad\text{et}\quad\dfrac{\partial B_z}{\partial t}=0\quad\Longrightarrow`$**$`\large{\mathbf{\quad B_z = cste}}`$**   

<br>

##### Quelle différence entre l'O-EM-P et le champ électromagnétique associé ?

* Les ondes, quelles soient **ondes progressives ou ondes stationnaires**, décrivent des 
  *champs scalaires ou vectoriels non stationnaires*.   
  <br>
  Ainsi toute **composante stationnaire** du champ électromagnétique $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ 
  *n'appartient pas à l'onde électromagnétique*.   
  <br>
  Le champ électromagnétique **$`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$** se décompose ainsi en 
   * une *partie statique ou stationnaire*
   * une **partie non stationnaire appelé onde électromagnétique**.   


##### Quelle structure adopte l'O-EM-P ?

* Ainsi, les vecteurs **$`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ de l'onde électromagnétique** sont *perpendiculaires 
à la direction de propagation* représentée par un vecteur unitaire $`\overrightarrow{u}`$   
&nbsp;&nbsp;$`\Longrightarrow`$ l'**onde électromagnétique $`[\,\overrightarrow{E}\,;\,\overrightarrow{B}\;]`$** 
est dite *transverse*.

Figure à faire

! *Note* : Une analogie
!
! Le champ électromagnétique peut-être vu comme un océan.
! L'océan peut être profond. L'océan dans ses profondeurs n'est pas affecté
! par les oscillations de sa surface qui dépendent du temps (vagues et vaguelettes).
! En omettant l'existence de courants marins profonds, l'océan dans
! ses profondeurs peut être idéalisé comme un grand volume d'eau stagnante, de hauteur plus ou moins grandes selon la 
! position considérée sur le globe terrestre. Ainsi en est-il pour la partie stationnaire du champ électromagnétique.
!
! Par contre la surface de l'océan est agitée en permanence par les vagues ou des ondulations, analogues aux ondes
! électromagnétiques, partie non stationnaire du champ électromagnétique.

Figure animée symbolique à faire

<br><br>

![](titres_electromagnetic-wave-2P-vacuum.jpg)


#### Qu'est-ce qu'une onde électromagnétique plane progressive (O-EM-2P) ?

à faire. Résultat :

**$`\large{\mathbf{\overrightarrow{n}\wedge\overrightarrow{E}=c\,\overrightarrow{B}}}`$**

* $`\Longrightarrow`$ L' OPP est *transverse*.

* $`\Longrightarrow`$ *$`\;\big(\overrightarrow{n},\,\overrightarrow{E},\,\overrightarrow{B}\big)`$* forme un *trièdre rectangle direct*.

* $`\Longrightarrow\;`$ *$`\mathbf{\Vert \overrightarrow{B}\Vert = \dfrac{\Vert \overrightarrow{E}\Vert}{c}}`$*

<br><br>

![](titres_electromagnetic-wave-2PH-vacuum.jpg)


#### Qu'est-ce qu'une onde électromagnétique plane progressive harmonique (OEM2PH) ?


à faire. Résultat :

**$`\large{\mathbf{\overrightarrow{k}\wedge\overrightarrow{E}=\omega\,\overrightarrow{B}}}`$**

* $`\Longrightarrow`$ L' OPP est *transverse*.

* $`\Longrightarrow\;`$ *$`\big(\overrightarrow{k},\,\overrightarrow{E},\,\overrightarrow{B}\big)`$* forme un *trièdre rectangle direct*.

* $`\Longrightarrow\;`$ *$`\mathbf{\Vert \overrightarrow{B}\Vert \;=\; \dfrac{k}{\omega}\cdot\Vert \overrightarrow{E}\Vert\;=\; \dfrac{\Vert \overrightarrow{E}\Vert}{c}}`$*

<br>

#### Comment écrire simplement l'expression d'une OPPM ?

*  L'**écriture générale** d'une OPPM $`\mathbf{\big(\overrightarrow{E}\,\overrightarrow{B}\big)}`$ dans un *repère cartésien direct $`\mathbf{(O, \overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})}`$ 
quelconque* de l'espace, est :

$`\hspace{0.6cm}\overrightarrow{E}=\left|
   \begin{array}{l}
      E_x=E_{0x}\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_x^E)\\
      E_y=E_{0y}\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_y^E)\\
      E_z=E_{0z}\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_z^E)\\
   \end{array}
   \right.`$

$`\hspace{0.6cm}\overrightarrow{B}=\left|
   \begin{array}{l}
      B_x=B_{0x}\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_x^B)\\
      B_y=B_{0y}\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_y^B)\\
      B_z=B_{0z}\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_z^B)\\
   \end{array}
   \right.`$
   
* Les champs **$`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$** sont **liés** :
   * par les *équations de Maxwell*.
   * plus simplement par la propriété de 
l'OPPM, *$`\mathbf{\overrightarrow{k}\land\overrightarrow{E}=\omega\;\overrightarrow{B}}`$*   
&nbsp;&nbsp;*$`\Longrightarrow`$* La connaissance de *$`\mathbf{\overrightarrow{E}}`$ ou $`\mathbf{\overrightarrow{B}}`$ suffit*.   
&nbsp;&nbsp;**$`\Longrightarrow`$** En général, l'expression de **$`\mathbf{\overrightarrow{E}}`$ est gardée**.

* Je peux toujours choisir l'**un des vecteurs de base** *en direction et sens de $`\mathbf{\overrightarrow{k}}`$*.  
L'écriture de l'OPPM se simplifie alors.   
_Exemple avec_ $`\overrightarrow{e_z}=\overrightarrow{k}/k`$ :  

$`\hspace{0.6cm}\overrightarrow{E}=\left|\begin{array}{l}
      E_x=E_{0x}\cdot cos(kz - \omega\,t + \phi_x)\\
      E_y=E_{0y}\cdot cos(kz - \omega\,t + \phi_y)\\
      E_z=0
   \end{array}
   \right.`$   


#### Comment caractériser une OPPM ?


##### Les grandeurs fondamentales

Les **grandeurs fondamentales** décrivant l'OPPM (grandeurs *indépendantes du milieu de propagation*)
sont les **grandeurs temporelles** équivalentes suivantes :

* La **période temporelle $`\mathbf{T}`$**, souvent appelée "période" et exprimée **en $`s`$** dans le SI, 
est la *durée entre deux phases identiques successives* de l'onde en un point de l'espace.

* La **fréquence temporelle $`\mathbf{\nu}`$**, souvent appelée "fréquence" et exprimée **en $`Hz=s^{-1}`$** 
dans le SI, est le *nombre de période temporelle $`T`$ par unité de temps* (la seconde
dans le SI)

* La **pulsation $`\mathbf{\omega}`$**, exprimée **en $`rad.s^{-1}`$** dans le SI, est liée à la 
fréquence temporelle par la relation *$`\mathbf{\omega=2\,\pi\;\nu}`$*

##### Les grandeurs non fondamentales

Les **grandeurs non fondamentales** décrivant l'OPPM (grandeurs *qui varient
selon le milieu de propagation*) sont les **grandeurs spatiales** équivalentes suivantes :

* le milieu de propagation *étudié ici* est l'**espace vide**.

* la **vitesse de phase $`\mathbf{\mathscr{v}_{\phi}^{vide}}`$** exprimée **en $`m.s^{-1}`$** dans le SI est la vitesse
à laquelle un front d'onde de phase donnée se propage dans l'espace.<br>
La *vitesse de phase de l'onde électromagnétique dans le vide* est une **grandeur fondamentale**
de la nature, c'est la **vitesse de la lumière dans le vide**,    
notée c, sa *valeur exacte* a été fixée à **$`\mathbf{c=299\,792\,458\;m\,s^{-1}}`$**.   
La vitesse c de propagation de la lumière dans le vide
est indépendante de l'état de mouvement de l'observateur (contredisant l'intuition classique)

* la **longueur d'onde $`\mathbf{\lambda^{vide}=\mathscr{v}_{\phi}^{vide}\,T=\dfrac{\mathscr{v}_{\phi}^{vide}}{\nu}}`$** exprimée **en $`m`$** dans le SI, 
est la *période spatiale de l'onde* : distance entre deux fronts d'onde successifs de même phase, mesurée
dans la direction de propagation.   
<br>
Si l'onde électromagnétique n'est **étudiée que dans le vide**, on écrit *plus simplement* :   
**$`\mathbf{\lambda}`$** *$`\mathbf{=cT=\dfrac{c}{\nu}}`$*.

!!!! *Attention* :   
!!!! En terme d'écriture, *ne pas confondre* :   
!!!! * $`\mathbf{\mathscr{v}}`$, qui est une vitesse,
!!!! * *$`\mathbf{\nu}`$*, qui est une fréquence temporelle.

* le **vecteur d'onde $`\mathbf{\overrightarrow{k^{vide}}=\big\Vert\overrightarrow{k^{vide}}\big\Vert\;\overrightarrow{u}=\dfrac{\omega}{c}\;\overrightarrow{u}}`$** <br>
où *$`\mathbf{\overrightarrow{u}}`$* est le vecteur unitaire qui *indique la direction ET le 
sens de propagation* de l'onde,<br> et *$`\mathbf{k^{vide}=\big\Vert\overrightarrow{k^{vide}}\big\Vert}`$* est le 
*nombre d'onde*, exprimé *en $`\;rad.m^{-1}\;`$* dans le SI.   
<br>
Si l'onde électromagnétique n'est **étudiée que dans le vide**, on écrit *plus simplement* **$`\mathbf{\overrightarrow{k}}`$**.

* la **polarisation** de l'onde.   
  En général, on précise par la terminologie adaptée l'évolution dans le temps de $`\mathbf{\overrightarrow{E}}`$, soit :   
   * *polarisation rectiligne* en précisant le vecteur unitaire indiquant cette direction :   
   exemple: selon $`\mathbf{\overrightarrow{e_x}}`$
   * *polarisation elliptique, ou circulaire*, et on peut préciser *droite, ou gauche*.

<br><br>

![](titres_electromagnetic-wave-polarization.jpg)



#### Qu'est-ce que la polarisation d'une OPPM ?

à faire. En attendant :

La polarisation d'une OPPM décrit l'évolution temporelle de la direction des vecteurs
$`\overrightarrow{E}`$ et $`\overrightarrow{B}`$

$`\big(\overrightarrow{k},\,\overrightarrow{E},\,\overrightarrow{B}\big)`$* formant
un trièdre rectangle direct, seule l'évolution de la direction de $`\overrightarrow{E}`$
est en général décrite.

Polarisations 

<br>

![](sous-titres-linear-polarization.jpg)


#### Qu'est-ce qu'une OPPM polarisée rectilignement ?

* L'OPPM est **polarisée rectilignement**, si le vecteur *$`\overrightarrow{E}`$ garde une direction constante*
  au cours de sa propagation.

![](linear-electromag-wave-up-down-n4_L1200.gif)   

* Je peux toujours choisir **un deuxième vecteur de base** *en direction de $`\mathbf{\overrightarrow{E}}`$*.  
_Exemple d'une OPPM se propageant selon_ $`\overrightarrow{e_z}`$
 _et polarisée ractilignement selon_ $`\overrightarrow{e_x}`$ :   
<br>
$`\overrightarrow{E}=\left|\begin{array}{l}
      E_x=E_{0x}\cdot cos(kz - \omega\,t + \phi_x)\\
      E_y=0)\\
      E_z=0\\
   \end{array}
   \right.`$   
soit :   
$`\overrightarrow{E}=E_0\cdot cos(kz - \omega\,t + \phi)\cdot\overrightarrow{e_x}`$   
où $`\mathbf{\phi}`$ est le déphasage à l'origine des temps : $`\mathbf{\phi=\phi(t=0)}`$.

* Je peux toujours choisir **une origine des temps** *telle que $`\mathbf{\phi(t=0)=0}`$* :   
<br>
**$`\hspace{0.6cm}\large{\mathbf{\overrightarrow{E}=E_0\cdot cos(kz - \omega\,t)\cdot\overrightarrow{e_x}}}`$** 


<br>

![](sous-titres-circular-polarization.jpg)

#### Qu'est-ce qu'une OMMP polérisée circulairement ?

* L'OPPM est **polarisée circulairement**, si l'extrémité du vecteur *$`\overrightarrow{E}`$ décrit un cercle* dans le front d'onde au cours de sa propagation

![](left-circular-electromag-wave-up-down-n4_L1200.gif)   

<br>

![](sous-titres-elliptic-polarization.jpg)

#### Qu'est-ce qu'une OPPM polarisée elliptiquement ?

* polarisée elliptiquement, si l'extrémité du vecteur $`\overrightarrow{E}`$ décrit une ellipse
  dans le front d'onde au cours de sa propagation.

à faire


Créer page parallèle "composants de l'optique" n4, avec lames l/2, l/4, biprimse Wollaston, ...

Créer page parallèle "technologies et composants de l'opto-électronique" n4, avec effet électro-optique, ...
vers les propriétés anisotropes des cristaux.



<br><br>

![](titres_electromagnetic-wave-2PH-corpuscule-vacuum.jpg)


à faire

<br><br>

![](titres_electromagnetic-wave-towards-reality.jpg)


à faire












