---
title: Synthèse
routable: false
visible: false
lessons:
    -
        slug: cylindrical-charge-or-current-distributions-integral
        name: PARALLÈLE : Distributions cylindriques de charges et de courants
        order: 3
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etape 3 : Ecriture : 1/3</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème d' **Ampère intégral** aux :


### **Distributions cylindriques de courants**

* Le terme **cylindrique** réfère à l'*aspect extérieur* de la distribution de courants.


#### Propriétés nécessaires au théorème d'Ampère

* Le théorème d'Ampère' sera utilisable si une distribution cylindrique de courants possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

<!---------un peu inutile ici---------
! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.

* La cause du champ $`\overrightarrow{E}`$ (la charge électrique) étant un scalaire, tout plan contenant l'axe de révolution est plan de symétrie pour la charge électrique.
------------------------------------->

<!--ATTENTION : ce qui est ici en commentaire est probablement faux----------
de courant possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.
--------------------------------------------------------------------------->

#### Y a t-il plusieurs configurations vérifiant ces propriétés ?

* La cause du champ $`\overrightarrow{B}`$ étant vectorielle, *deux  configurations de* **courants** sont possibles. Le déplacement des charges peut s'effectuer :
   *  **en direction de l'axe de révolution** : c'est le cas d'un *fil électrique rectiligne* infini parcouru par un courant.   
      $`\Longrightarrow``$ tout plan contenant l'axe de révolution est plan de symétrie pour le courant.
   *  en **tournant circulairement autour de l'axe de révolution** : c'est le cas d'un *solénoïde* infini parcouru par un courant.   
      $`\Longrightarrow`$ tout plan contenant l'axe de révolution est plan d'anti-symétrie pour le courant.

----------------------

#### LES COURANTS S'ENROULENT AUTOUR DE L'AXE DE RÉVOLUTION <br><br> exemple : un solénoïde conducteur infini.

----------------------

#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.



#### Comment modéliser un solénoïde ?


* **$`\mathbf{a}\;:`$** Cette distribution de courants s'approche de celle réalisée dans un *solénoïde de rayon R et de longueur L* 
parcouru par un *courant constant I*,   
lorsque le fil du solénoïde à un diamètre D suffisamment faible *(D<<R)* et que
le solénoïde est suffisamment long *(L>>R)*.   
<br>
_C'est le cas pour l'essentiel des bobines_
_destinée à réaliser un champ magnétique en leur centre. Hors un "Effet de bord" lorsque_ 
_l'on s'approche des extrémités de la bobine, le champ magnétique_
_calculé avec le théorème d'Ampère représente avec une très bonne précision celui présent à l'intérieur de la bobine._   


![](magnetostatics_bobine_modelisations_1_L1200.gif)

Le théorème d'Ampère nécessitant ici de considérer une distribution de courants présentant une **symétrie de révolution**
et une **symétrie de translation** respectivement *autour et selon l'axe $`Oz`$*, cela implique de modéliser la bobine par, soit :

* **$`\mathbf{b}\;:`$** des *spires jointives* perpendiculaires à l'axe $`Oz`$, de sections nulles et parcourues par un même
courant constant $`I`$.

* **$`\mathbf{c}\;:`$** un champ de *vecteur densité volumique de courant $`\overrightarrow{j}^{3D}`$*  qui s'enroule autour de l'axe $   
  _Dans le cas d'une bobine, il peut y avoir plusieurs couches de spires donnant une certaine épaisseur._

* **$`\mathbf{d}\;:`$** un champ de *vecteur densité surfacique de courant $`\overrightarrow{j}^{2D}`$* qui s'enroule autour de l'axe $`Oz`$.



#### Comment caractériser cette distribution de courant ?


* Dans le cas où la *section droite* du fil conducteur constituant le solénoïde est *négligée*, le **courant** est simplement décrit 
 par l'intensité *$`I`$* qui parcourt le solénoïde. Le **sens du courant** dans le solénoïde est *précisé par une flèche*.   
 _(en magnétostatique, le courant est constant, donc son sens ne varie pas au cours du temps)._   


* Dans le cas contraire où la *section droite* est *non négligée*, le courant est décrit par un
 **vecteur densité de courant $`\overrightarrow{j}`$**.
<br>
   * *Un courant s'enroulant atour de l'axe de révolution* implique **$`\overrightarrow{j}=j(\rho,\varphi,z)\,\overrightarrow{e_{\varphi}}`$**
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel} \overrightarrow{j} = \overrightarrow{j}(\rho,\xcancel{\varphi}, z)`$**.   
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\overrightarrow{j}= \overrightarrow{j}(\rho,\varphi, \xcancel{z})`$**.   
<br>
* *Au final*, le vecteur densité volumique de courant **$`\overrightarrow{j}`$** est **dirigé selon $`\overrightarrow{e_{\varphi}}`$**
 et **ne dépend que de $`\rho`$** :   
*$`\mathbf{\left.\begin{array}{l}
\overrightarrow{j}=j\,\overrightarrow{e_{\varphi}} \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, z) \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\overrightarrow{j}=j_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}}`$**


#### De quelles coordonnées dépend $`\overrightarrow{B}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{B}}`$** possède les *invariances de $`\overrightarrow{j}`$*

* $`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)\Longrightarrow}`$ **$`\mathbf{\overrightarrow{B}=\overrightarrow{B}(\rho)}`$**


#### Comment déterminer la direction de $`\overrightarrow{B}`$ ?

* *Par l'* **étude des symétries** *de la distribution de courant $`\overrightarrow{j}`$*.   
<br>
Que la distribution de courant soit modélisée par un courant $``I``$ parcourant le solénoïïde infini :

![](magnetostat-bobine-1-symetries-direction-B_v2_L1200.gif)

<br>
ou soit modélisée par un vecteur densité de courant $`\overrightarrow{j}`$ :

![](magnetostat-bobine-2-symetries-direction-B_L1200.gif)

1. Soit un **point $`M(\rho_M\,\varphi_M,z_M)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et perpendiculaire à l'axe $`Oz`$ est *plan de symétrie* pour la distribution de courant.
3. Le champ magnétique **$`\overrightarrow{B}`$ étant un vecteur axial**, en tout point d'un plan de symétrie 
   il est perpendiculaire à ce plan. Le plan de symétrie $`P_1`$ étant déterminé, la
   *direction de $`\overrightarrow{B}`$, selon $`\overrightarrow{e_z}`$*, est 
   *totalement déterminée*.
4. _Étape non nécessaire :_    
_Le plan_ $`P_2`$ _qui contient le point $`M`$ et l'axe $`Oz`$ est_
 _plan d'anti-symétrie pour la distribution de courant. En tout point d'un plan_
_d'anti-symétrie, $`\overrightarrow{B}`$ vecteur axial est contenu dans ce plan, ce qui est bien vérifié._   


* De façon plus concise :   
<br>
**En tout point $`M`$** l'espace,   
*$`\left.\begin{array}{l} \overrightarrow{B}\;\text{vecteur axial} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}})\; \text{plan de symétrie}\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{B}=B_z\,\overrightarrow{e_z}}`$**

![](magnetostat-symetries-solenoide_L1200.jpg)   
<br>

#### Comment s'exprime $`\overrightarrow{B}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\overrightarrow{j}`$ :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{B}=\overrightarrow{B}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{B}=B_z\,\overrightarrow{e_z}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{B}=B_z(\rho)\,\overrightarrow{e_z}}`$**



#### Y-a-t'il des lieux où $`\overrightarrow{B}`$ est déjà totalement déterminé par les symétries et invariances ?

à faire


#### Quel contour d'Ampère $`\Gamma_A`$ choisir ?

* Le **contour d'Ampère $`\mathbf{\Gamma_A}`$** doit :
   * être une *ligne fermée*.
   * *contenir le point $`M`$* quelconque.
   * permettre un *calcul simple de $`\displaystyle\oint_{\Gamma_A} \overrightarrow{B}\cdot \overrightarrow{dl}`$*.

* Que savons nous ? <br>
  Les invariances et symétries $`\Longrightarrow`$*$`\;\overrightarrow{B}=B_z(\rho)\,\overrightarrow{e_z}`$*   

<br> 
![](magnetostatics-solenoid-ampere-contour_v2_L1200.gif)   
<br>

* *Choix de $`\mathbf{\Gamma_A}`$* : un **rectangle ABCD**   
   * inscrit *dans le* **plan** qui **contient de point $`M`$** et **l'axe $`Oz`$**.
   * dont deux **branches BC et DA** sont *parallèles à l'axe $`Oz`$* et de *longueur $`h`$*,  
     $`\Longrightarrow`$ sur ces branches, $`\overrightarrow{dl} \parallel \overrightarrow{B}`$   
     $`\Longrightarrow\quad\overrightarrow{dl} \cdot \overrightarrow{B}=\pm\, B\,dl`$   
   * et les deux autres **branches AB et CD** ont la *direction de $`\overrightarrow{e_{\rho}}`$*,   
     $`\Longrightarrow`$ sur ces branches, $`\overrightarrow{dl} \perp \overrightarrow{B}`$   
     $`\Longrightarrow\quad\overrightarrow{dl} \cdot \overrightarrow{B}=0`$    
   *  La branche **DA contient le point $`M`$** considéré, et est donc située à la distance *$`\boldsymbol{\rho_{DA}=\rho_M}`$* de $`Oz`$.
   * La branche **BC** est **rejetée à distance infinie** de $`Oz`$,    
     *$`\boldsymbol{\rho_{BC}\longrightarrow\infty}`$*,   
     où le champ magnétique est postulé nul : *$`\displaystyle\lim_{\rho_{BC}\rightarrow\infty}\overrightarrow{B}=\overrightarrow{0}`$*   
$`\Longrightarrow\quad\overrightarrow{dl} \cdot \overrightarrow{B}=0`$   

! *Remarque*   
! Le fait de considérer le champ magnétique nul à distance infinie de l'axe de révolution
! se déduit du champ magnétique créé dans tous l'espace par une bobine torique idéale.
! En effet l'étude de ce cas avec le théorème d'Ampère qui démontre un champ magnétique nul en tout point
! à l'extérieur de la bobine torique, a été conduite sans aucune condition restritive sur $`R_1`$ et $`R_2`$, 
! respectivement valeurs des rayons intérieur et extérieur du tore.   
! Un solénoïde infini de rayon $`R`$ peut s'interpréter comme le cas limite d'une bobine torique où les
! rayons $`R_1`$ et $`R_2`$ tendent tous deux vers l'infini, en gardant constant la différence $`R_2 - R_1 = R`$.   
! Il serait possible d'en déduire que le champ magnétique est nul en tout point à l'extérieur du solénoïde, résultat
! que nous allons retrouver à partir du postulat $`\displaystyle\lim_{\rho_{BC}\rightarrow\infty}\overrightarrow{B}=\overrightarrow{0}`$.


#### Que signifie orienter le contour d'Ampère $`\Gamma_A`$ choisi ?

* orienter signifie **donner un sens "positif" de circulation**, *indiqué par une flèche* sur le contour.

* Ce sens positif **fixe le sens des vecteurs déplacement élémentaire $`\mathbf{\overrightarrow{dl}}`$ ** le long du contour : .   
  <br>
  figure explicative à faire.


#### Le choix de l'orientation est-il important ?

* Ne pas oublier d'**orienter le contour d'Ampère** est *important*.

* Choisir **un sens plutôt que l'autre** n'a *pas d'importance*.   
  <br>
  En effet :   
  * le théorème d'Ampère est une égalité entre 2 membres :   
  $`\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\,\oiint_{\mathscr{S}_A}\overrightarrow{j}\cdot\overrightarrow{dS}`$
  * Les orientations de $`\overrightarrow{dl}`$ et $`\overrightarrow{dS}`$ sont liées.
  * Changer le sens de $`\overrightarrow{dl}`$ changera aussi le sens de $`\overrightarrow{dS}`$.   
    Cela revient à multiplier par $`-1`$ chaque membre de l'égalité,    
    ce qui ne modifie pas la solution de l'équation.


#### Que vaut la circulation de $`\overrightarrow{B}`$ le long de $`\Gamma_A`$ ?

* Le **signe** devant l'expression finale contenant $`B_{\varphi}(r)`$ *dépend de l'orientation choisie* sur $`\mathbf{\Gamma_A}`$
* Dans ce cas où la contour $`\mathbf{\Gamma_A}`$ est un rectangle ABCD, il suffit d'indiquer le sens positif choisi sur l'une des quatres branches pour
  déterminer totalement le sens de parcours sur tout $`\mathbf{\Gamma_A}`$. 

<br>
![](magnetostatics-solenoid-ampere-sens-contour_L1200.gif)   
<br>

  Choisissons par exemple la branche DA qui contient le point $`M`$ :

* Si **$`\mathbf{\;\overrightarrow{dl}_{DA}=+\,dz\,\overrightarrow{e_z}}`$** :
 <br><br>
 **$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$**    
 <br>
   $`\displaystyle\quad\quad=\int_{DA} \overrightarrow{B}(\rho_{DA})\cdot\overrightarrow{dl}_{DA} + \int_{AB} \underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{AB}}_{\color{blue}{\quad\;=\,0\\car\,\vec{B}\,\perp\,\vec{dl}_{AB}}}`$    
   $`\displaystyle\quad\quad\quad +\int_{BC} \underbrace{\overrightarrow{B}(\rho_{BC})}_{\color{blue}{=\,\vec{0}}}\cdot\overrightarrow{dl}_{BC} + \int_{CD}\underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{CD}}_{\color{blue}{\quad\;=\,0\\car\,\vec{B}\,\perp\,\vec{dl}_{CD}}}`$   
 <br>
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{En se rappellant que :}}}`$
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{invariances + symétries }\Longrightarrow \vec{B}=B_z(\rho)\,\vec{e_z}}}`$   
 <br>
 $`\quad\quad\displaystyle = \int_{DA}\big(B_z(\rho_{DA})\,\overrightarrow{e_z}\big)\cdot\big(dz\,\overrightarrow{e_z}\big)`$   
 <br>
 $`\quad\quad\displaystyle = \int_{DA}\;B_z(\rho_{DA})\,\big(\overrightarrow{e_z}\cdot\overrightarrow{e_z}\big)\,dz`$   
 <br>
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{Le sens de parcours est indiqué}}}`$
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{par l'ordre des bornes d'intégration}}}`$   
 <br>
 $`\quad\quad\displaystyle  = \int_{z=z_0}^{z=z_0+h} B_z(\rho_{DA})\,dz`$  
 <br>
 $`\quad\quad\displaystyle  = \Big[ B_z(\rho_{DA})\times z\Big]_{z_0}^{z_0+h}`$   
 <br>
 $`\quad\quad\color{blue}{\scriptsize{\quad M\in [DA]\;\Longrightarrow \;\rho_{DA}=\rho_M}}`$  
 <br>
 **$`\quad\quad\displaystyle\mathbf{\boldsymbol{ = h\; B_z(\rho_M)}}`$** 

<br>
* Si *$`\mathbf{\;\overrightarrow{dl}_{DA}=-\,dz\,\overrightarrow{e_z}}`$* :
 <br><br>
 *$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$*    
 <br>
 $`\displaystyle\quad\quad=\int_{DA} \overrightarrow{B}(\rho_{DA})\cdot\overrightarrow{dl}_{DA} + \int_{AB} \underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{AB}}_{\color{blue}{\quad\;=\,0}}`$    
 $`\displaystyle \quad\quad\quad +\int_{BC} \underbrace{\overrightarrow{B}(\rho_{BC})}_{\color{blue}{=\,\vec{0}}}\cdot\overrightarrow{dl}_{BC} + \int_{CD}\underbrace{\overrightarrow{B}\cdot\overrightarrow{dl}_{CD}}_{\color{blue}{\quad\;=\,0}}`$   
 <br>
 $`\displaystyle\quad\quad = \int_{DA}\big(B_z(\rho_{DA})\overrightarrow{e_z}\big)\cdot\big(-\,dz\,\overrightarrow{e_z}\big)`$   
 <br>
 $`\displaystyle\quad\quad = \int_{z=z_0+h}^{z=z_0} B_z(\rho_{DA})\,dz`$  
 <br>
 $`\displaystyle\quad\quad = \Big[ B_z(\rho_{DA})\times z\Big]_{z_0+h}^{z_0}`$   
 <br>
 *$`\displaystyle\quad\quad\mathbf{\boldsymbol{ = -\, h\; B_z(\rho_M)}}`$*




#### Quelle surface ouverte $`\mathscr{S}_A`$ s'appuyant sur $`\Gamma_A`$ choisir ?


##### 1 - Le courant est représenté par $`j^{3D}`$

* La **surface d'Ampère $`\mathscr{S}_A`$** doit :
   * être une *surface ouverte s'appuyant sur le contour d'Ampère $`\Gamma_A`$*.
   * permettre un *calcul simple de $`\displaystyle\oiint_{\mathscr{S}_A} \;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}`$*.

* Que savons nous ? <br>
  La distribution de courant vérifie $`\Longrightarrow`$*$`\;\overrightarrow{j}^{3D}=j^{3D}(\rho)\,\overrightarrow{e_{\varphi}}`$* 

<br>
![](magnetostatics-solenoid-ampere-j-surface_v2_L1200.gif)   
<br>

* *Choix de $`\mathbf{\Gamma_A}`$* : la **portion de plan** *qui s'appuie sur le rectangle ABCD*,   
  $`\Longrightarrow \forall M\in \mathbf{\Gamma_A}, \overrightarrow{dS}_M = \pm\; d\rho\,dz\,\overrightarrow{e_{\varphi}}`$   
  *$`\displaystyle\Longrightarrow\;\forall M\in\mathscr{S}_A\,,\;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm\; j^{3D}\,dS`$*   
   ($`+`$ ou $`-`$ selon l'orientation du rectangle plein $`\mathscr{S}_A`$).

!!!! *Attention*   
!!!!
!!!! Dans cette distribution de courant, $`\mathbf{\boldsymbol{\overrightarrow{j^{3D}}=j_{\varphi}^{3D}(\rho)\,\overrightarrow{e_{\varphi}}}}`$.   
!!!!
!!!! *Dans l'espression* $`\mathbf{\boldsymbol{\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm\; j^{3D}\,dS}}`$, *ne pas confondre*
!!!! * $`\mathbf{j^{3D}}`$ : composante de $`\overrightarrow{j^{3D}}`$ selon $`\overrightarrow{e_{\varphi}}`$ qui peut être positive ou négative selon le sens du courant.    
!!!! *avec*    
!!!! * $`\mathbf{\Vert \,\overrightarrow{j^{3D}} \,\Vert}`$ : norme du vecteur $`\overrightarrow{j^{3D}}`$ qui est toujours positive.


##### 2 - Le courant est représenté par $`I`$ 

* Toute surface qui s'appuie sur le rectangle ABCD convient,   
  Il faudra juste faire la somme algébriques des intensités $`\overline{I}`$ qui traversent la surface choisie.

* Mais le **rectangle plein ABCD** reste le *choix le plus simple* et judicieux.

<br>
![](magnetostatics-solenoid-ampere-I-surface_L1200.jpg)   
<br>




#### Comment orienter $`\mathscr{S}_A`$ ?

* Les **orientations du contour et de la surface** d'Ampère associée sont *couplées par la règle de la main droite*.



* Donc l'orientation du rectangle plein $`\mathscr{S}_A`$ dépend de l'orientation choisie sur le rectangle $`\Gamma_A`$ ,   


##### 1 - Le courant est représenté par $`j^{3D}`$

* **$`\mathbf{\overrightarrow{dS}=\,+\,d\rho\,dz\,\overrightarrow{e_{\varphi}}\Longleftrightarrow\overrightarrow{dl}_{DA}=+\,dz\,\overrightarrow{e_z}}`$**  
   $`d\rho`$ et $`dz`$ représentant des accroissements élémentaires ($`d\rho > 0`$ et $`dz > 0`$).

<br>
![](magnetostatics-solenoid-ampere-j-sens-direct-surface_v2_L1200.gif)   
<br>

* *$`\mathbf{\overrightarrow{dS}=\,-\,d\rho\,dz\,\overrightarrow{e_{\varphi}}\Longleftrightarrow\overrightarrow{dl}_{DA}=-\,dz\,\overrightarrow{e_z}}`$*   
   $`d\rho`$ et $`dz`$ représentant des accroissements élémentaires ($`d\rho > 0`$ et $`dz > 0`$).

<br>
![](magnetostatics-solenoid-ampere-j-sens-direct2-surface_v2_L1200.jpg)
<br>


#### Comment calculer l'intensité totale traversant $`\mathcal{S}_A`$, puis en déduire $`\overrightarrow{B}`$ ?


* **Les résultats précédents**
   * $`\overrightarrow{B}(\rho,\varphi,z) = B_z(\rho)\,\overrightarrow{e_z}`$
   * $`\oint_{\Gamma_A} \overrightarrow{B}\cdot\overrightarrow{dl} = \pm \;h\;B_z(\rho)`$   
     _le signe_ _$`+\text{ ou }-`$_ _dépendant de l'orientation de_ $`\Gamma_A`$ _choisie_

  sont *communs à toutes les distributions de courants de type $`\overrightarrow{j} = j_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}`$*.

* La **calcul de l'intensité totale à travers $`\mathcal{S}_A`$**, puis **de $`\overrightarrow{B}`$**
  *nécessite de connaître*, selon la description du courant :   
  * la *géométrie du solénoïde* (rayon, nombre de spires par unité de longueur), et
    le *sens de courant* le traversant, sens donné par une flèche sur un schéma descriptif.
  * l'*expression mathématique pour $`\overrightarrow{j}^{3D}`$* en chaque point de l'espace.
  $`\Longrightarrow`$ *différentes distributions de courants sont étudiées* dans la suite.


##### Calcul de l'intensité totale en valeur algébrique

##### *1* - Le courant est représenté par $`j^{3D}`$

* L'**intensité totale** traversant la surface d'Ampère $`\mathcal{S}_A`$ s'écrit :    
  <br>
  **$`\displaystyle\iint_{\mathcal{S}_A} = \overrightarrow{j}^{3D}\cdot\overrightarrow{dS}`$**

* Dans le cas étudié, $`\overrightarrow{j}=j_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}`$   
$`\Longrightarrow`$ le *sens du courant* dans le solénoïde est donc *donné par le signe de $`j_{\varphi}(\rho)`$*.

* L'**intensité totale en valeur algébrique** résulte simplement du calcul de 
  $`\iint_{\mathcal{S}_A} \overrightarrow{j}^{3D}\cdot\overrightarrow{dS}`$, en prenant le
  **$`\overrightarrow{dS}`$ correspondant à l'orientation choisie** de $`\mathcal{S}_A`$ :   
  $`\overrightarrow{dS}= +\,d\rho\,dz\,\overrightarrow{e_{\varphi}}`$ _ou_ $`\overrightarrow{dS}= -\,d\rho\,dz\,\overrightarrow{e_{\varphi}}`$. 

##### *2* - Le courant est représenté par $`I`$

* Le *sens de chaque courant* $`I`$ traversant $`\mathcal{S}_A`$ est *indiqué par sa flèche*. 

* Pour un courant d'intensité $`I`$ en valeur absolue,    
  son **intensité en valeur algébrique** est :   
   * **positive $`\overline{I}>0`$** si le courant *I traverse $`\mathcal{S}_A`$ dans le sens de $`\overrightarrow{dS}`$*,
     élément vectoriel de surface au point de traversé.
   * **négative $`\overline{I}<0`$** si le courant *I traverse $`\mathcal{S}_A`$ dans le sens opposé à $`\overrightarrow{dS}`$*.

* L'**intensité totale en valeur algébrique** est la somme des intensités algébriques des courants traversant $`\mathcal{S}_A`$ :   
  **$`\displaystyle\sum_{\mathcal{S}_A}\overline{I}`$**


##### Calcul de $`\overrightarrow{B}`$

* Il *résulte de la synthèse des résultats* précédents.

* L'**égalité entre les deux termes** du théorème d'Ampère *donne la composante $`B`$*
  du champ $`\overrightarrow{B}=B\,\overrightarrow{e_z}`$ en tout point de l'espace :
  <br>
  $`\left.\begin{align}
   &\oint_{\mathcal{S}_A}\overrightarrow{B}\cdot\overrightarrow{dl}\color{brown}{=\mu_0\sum\overline{I}}\\
   &\quad\quad\quad\quad OU \\
   &\oint_{\mathcal{S}_A}\overrightarrow{B}\cdot\overrightarrow{dl}\color{brown}{=\mu_0\iint \overrightarrow{j}\cdot\overrightarrow{dS}}\\
  \end{align}
  \right\}`$ **$`\Longrightarrow`$ expression de $`B`$**   
  <br>
  Ne pas oublier le terme $`\mu_0`$.

* L'écriture complète s'écrit **$`\overrightarrow{B}=B\,\overrightarrow{e_z}`$** 
  *en remplaçant sa composante $`B`$ par son expression.*

<br>

------------------------

#### **1 - ** Le solénoïde infini parcouru par un courant constant

* *Objectif d'apprentissage* : C'est la **modélisation simple d'une bobine** (la section du fil est négligée).   


##### Description puis modélisation du solénoïde parcouru par un courant $`I`$

* Le **solénoïde** est constitué d'un *fil conducteur enroulé en configuration hélicoïdale*, de façon à
  réaliser une bobine.

* La bobine est traversée par un **courant constant d'intensité $`I`$** dont 
  le *sens* est *indiqué par une flèche* sur le schéma.

* la **section du fil** conducteur est *négligée*,      
  donc la bobine peut être caractérisée par un unique *rayon $`R`$*
  séparant l'intérieur de l'extérieur.

* les **spires** sont *jointives* et disposées en *une seule couche*

* la **longueur $`L`$** de la bobine est grande devant son rayon : *$`L>>R`$*, 
  donc,
  pour le calcul de $`\overrightarrow{B}`$ à l'intérieur de la bobine, hors effets de bord, 
  le **modèle de la bobine** est celui d'un *solénoïde infini*.

* le solénoïde contient **n spires par unité de longueur**.


##### Calcul de l'intensité totale traversant $`\mathcal{S}_A`$, puis de $`\overrightarrow{B}`$

* Choisissons l'*orientation* positive du contour d'Ampère $`\Gamma_A`$ comme *indiqué sur la figure*,   
  $`\Longrightarrow\quad\overrightarrow{dl}_{DA}=+\,dz\;\overrightarrow{e_z}\quad\text{et}\quad \overrightarrow{dS}=+\,dS\overrightarrow{e_{\varphi}}`$      
  $`\hspace{2cm}\text{ avec } dz>0 et dS>0`$   
  <br>
  $`\Longrightarrow\quad\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}\,=\,`$ **$`\mathbf{h\,B_z(\rho_M)}`$**
  

##### **Pour $`\rho_M < R`$**

* Le point M est situé à l'**intérieur du solénoïde**,   
  $`\Longrightarrow`$ la surface d'Ampère $`\mathcal{S}_A`$ s'étend depuis $`\rho = \rho_M < R `$ jusqu'à $`\rho \leftarrow +\infty`$

* La  surface d'Ampère **$`\mathcal{S}_A`$** de hauteur h est *traversée par $`N=n\times h`$ spires*.

* *Pour le sens du courant indiqué* sur la figure, l'intensité algébrique du courant 
  dans chaque spire est   
   **$`\overline{I}=+\,I\quad`$**, avec $`I=|\overline{I}|`$.

* L'*intensité totale* traversant $`\mathcal{S}_A`$ s'écrit :   
  *$`\displaystyle\sum_{\mathcal{S}_A}\overline{I}=N\,\overline{I}= +\,n\,h\,I`$*

* Le *théorème d'Ampère*   
  *$`\displaystyle\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_O\sum_{\mathcal{S}_A}\overline{I}}`$*   
  <br>
  s'exprime **à l'intérieur** du solénoïde par    
  **$`\displaystyle\mathbf{h\,B_z(\rho_M) = +\,n\,h\,I}`$**   
  <br>

* Au final, **pour $`\boldsymbol{\mathbf{\rho < R}}`$**    
$`\left.\begin{array}{l}
\overrightarrow{B}=B_z(\rho)\,\overrightarrow{e_z}=B\,\overrightarrow{e_z} \\
h\,B= \mu_0\,h\,n\,I
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{B}=\mu_0\,n\,I\,\overrightarrow{e_z}}`$**   

<br>
  
![](magnetostat-solenoide-ampere-1_v2_L1200.gif) 
  
<br>


##### **Pour $`\rho_M > R`$**

* Le point $`M`$ est situé à l'**extérieur du solénoïde**   
  $`\Longrightarrow`$ la surface d'Ampère **$`\mathcal{S}_A`$** qui s'étend depuis $`\rho = \rho_M < R `$
  jusqu'à $`\rho \leftarrow +\infty`$ n'est *traversée par aucune spire*, donc *par aucun courant*.

* L'*intensité totale* traversant $`\mathcal{S}_A`$ est donc nulle    
  *$`\displaystyle\sum_{\mathcal{S}_A}\overline{I}=0`$*

* Le *théorème d'Ampère*   
  *$`\displaystyle\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_O\sum_{\mathcal{S}_A}\overline{I}}`$*   
  <br>
  s'exprime **à l'extérieur** du solénoïde par    
  **$`\displaystyle\mathbf{h\,B_z(\rho_M) = 0}`$**   
  <br>

* Au final,  **pour $`\boldsymbol{\mathbf{\rho > R}}`$**  
$`\left.\begin{array}{l}
\overrightarrow{B}=B_z(\rho)\,\overrightarrow{e_z}=B\,\overrightarrow{e_z} \\
h\,B= 0
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{B}=\overrightarrow{0}}`$**   

<br>

![](magnetostat-solenoide-ampere-2_L1200.jpg)   

<br>

##### Le choix de l'orientation n'influe pas

* Comme précisé précédemment, le **choix des orientations** de $`\Gamma_A`$ et $`\mathcal{S}_A`$
  (couplées par la règle de la main droite) *ne change pas le calcul* de $`\overrightarrow{B}`$.

* Le choix d'un sens d'**orientation, choix virtuel** dans la pensée de l'observateur pour décrire
  mathématiquement la situation, **ne peut pas modifier la réalité**, qui est le *champ magnétique* 
  *$`\overrightarrow{B}`$ créé par une distribution de courants*.

<br>

![](magnetostat-solenoide-ampere-2_L1200.gif)  

<br>

##### Champ magnétique créé par un solénoide.

* Le champ magnétique $`\overrightarrow{B}`$ créé par un **solénoïde infini** traversé par un **courant constant**
  d'intensité $`I`$ est 
   * *nul à l'extérieur* du solénoïde.
   * *uniforme et dirigé selon l'axe de révolution à l'intérieur* du solénoïde.

* Dans le cas d'un **solénoïde réel traversé par un courant continu**, hors effets de bord lorsque l'on s'approche des extrémités,
  le champ magnétique $`\overrightarrow{B}`$ est   
   * *à l'intérieur quasi-uniforme et quasi-unidirectionnel* (selon l'axe du solénoïde)   
   * *quasi-nul  à l'extérieur*.

<br>

![](magnetostat-solenoide-ampere-3_L1200.gif)  

<br>


------------------------

#### **2 - ** Cylindre infini, parcouru par une densité volumique de courant uniforme $`j^{3D}=j_0\;\overrightarrow{e_{\varphi}}`$.
à faire

<br>










