---
title: 'Cinématique du point'
published: true
routable: true
visible: false
lessons:
    -
      slug: point-kinematics
      name: LINÉAIRE-3 : Cinématique du point matériel
      order: 2
    -   
      slug: all-newton-classical-mechanics
      name: PARALLELE-3 : Mécanique de Newton
      order: 2
    -
      slug: all-newton-classical-point-mechanics
      name: PARALLELE : Mécanique de Newton
      order: 1
    - 
      slug: from-corpuscule-to-mechanical-wave-3
      name: PARALLÈLE-3 particule et onde.
      order: 1
    -   
      slug: classical-corpuscules-and-waves
      name: PARALLELE-3 : Mécanique de Newton, corpuscules et ondes
      order: 2
    -   
      slug: from-classical-world-to-wave-corpuscular-duality
      name: PARALLELE-3 : des ondes et corpuscules à la dualité onde-corpuscule
      order: 1
    -   
      slug: test-apparence-all-newton
      name: PARALLELE-3 : Mécanique de Newton
      order: 1
---

$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   
*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


<!------------
!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>
------------->

<!--MétaDonnée : ... -->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------

### MÉCANIQUE DU POINT MATÉRIEL

### **Le corpuscule**<br>*et la description de son mouvement`$*   

<br><br>

RÉSUMÉ
: ---
  
  *Le concept de corpuscule, et ses propriétés*
  
  __Corpuscule matériel__ : corps matériel apparaissant comme ponctuel à la résolution spatiale
    de l'observation, caractérisé par des grandeurs physiques caractérisant sa sensibilité à différentes interactions,  
   &ndash;&nbsp; sa masse grave pour l'interaction gravitationelle,   
   &ndash;&nbsp; sa charge électrique pour l'interaction électromagnétique,   
    à chaque instant localisé en un point de l'espace.
    
  __Représentation mathématique__ : un point $`P`$ de l'espace, repérable à chaque instant $`t`$ dans un référentiel 
    $`\mathscr{R}(O,x,y,z,t)`$ par son vecteur position $`\overrightarrow{r}(t)=\overrightarrow{OP}(t)`$ ou ses coordonnées
    cartésiennes $`\big(\,x(t),y(t),z(t)\,\big)`$.
    
  __Propriétés des corpuscules matériels__
  
  * __Localisé__ : en un point de l'espace.
  * __Suit une trajectoire__ selon des équations horaires.
  * __Transport d'énergie__ : en chaque point de sa trajectoire possède une énergie cinétique.
  * __Transport de matière__ : en chaque point de sa trajectoire, possède une quantité de mouvement.

<!------------------------
  *Référentiel, système de coordonnées et repère de l'espace associé*  
  
  __Référentiel  $`\mathscr{R}(O,x,y,z,t)`$__ : il est formé de tout observateur, capteur, actionneur, objet immobile
  par rapport à un système d'axes cartésiens $`(O,x,y,z,t)`$ associé à un corps étendu rigide, et muni d'une
  horloge synchronisée à un instant quelconque avec une même horloge horloge située au point origine du système d'axe.   
  Le repère de l'espace $`O\,\vec{e_x}\,\vec{e_y}\,\vec{e_z})`$ est le repère de 
  l'espace associé aux coordonnées cartésiennes $`(O,x,y,z,t)`$ 
  
  __Systèmes de coordonnée $`(O',\alpha,\beta,\gamma)`$__ : Tout système de coordonnées spatiales, cartésien ou non, immobile ou en moouvement dans
  un référentiel donné, de repère de l'espace associé. 
  
  __Repère de l'espace $`(O',\vec{\alpha},\vec{\beta},\vec{\gamma)}`$__ : repère de 
  l'espace associé au système de coordonnées $`(O',\alpha,\beta,\gamma)`$ 
  
  Dans un référentiel donné, un choix judiceux de système de coordonnées peut permettre de simplifier
  l'écriture mathématique de certains mouvements ou de certaines distributions spatiales de matière.
  
  *Principaux repères de l'espace, et leur système de coordonnées spatiales associé*    
  
  __Repère cartésien__
  
  __Repère cylindrique (3D) et polaire (2D)__
  
  __Repère sphérique__
  
  __Cas particulier :__<br>
  __Repère de Serret-Frenet* d'une trajectoire connue (1D)__
  
  Repère spatial associé à une trajectoire $`\mathscr{T}`$ (1D) dans l'espace (3D) où
  tout point $`P\in\mathscr{T}`$ est repéré par rapport à sa position $`P(t)`$ sur
  la trajectoire à l'instant $`t`$.
  
  A tout instant $`t`$, un point $`P(t)\in\mathscr{T}`$ 
  * parcourt la trajectoire à la vitesse   
  $`\vec(\mathscr{v}_P(t)=\dfrac{\vec{dl}_P(t)}{dt}`$<br>
  &nbsp &nbsp &nbsp &nbsp avec $`\vec{dl}_P(t)`$ élément d'arc sur $`\mathscr{T}`$ parcouru par $`P`$ en une durée $`dt`$
  et orienté dans le sens de  $`\vec(\mathscr{v}_P(t)`$.
  * subit l'accélération<br>
  $`\vec{a_M(t)=\dfrac{\vec{\mathscr{v}}_M(t)}{dt}\vec{a_M(t)=\vec{a_{M\;\parallel}(t)+\vec{a_{M\;\perp}(t)`$   
  &nbsp &nbsp &nbsp &nbsp avec $`\vec{a_{M\;\parallel}(t)\parallel \vec{\mathscr{v}}_M(t)`$,
  $`\vec{a_{M\;\perp}(t)\perp\vec{\mathscr{v}}_M(t)`$.
  
  Repère de Serret-Frenet : repère mobile cartésien $`
  
  
  
  
  se décompose en une partie colinéaire à 
  
  
  
  
  
  
  
    
------------------------>
<!------------------
  *Corpuscule* :  
  corps matériel localisé, apparaissant comme ponctuel (OD) à l'échelle de l'observation. 
  Dans le cadre de la mécanique du point, tout degré de liberté inacessible à l'échelle d'observation
  (rotation, vibration, ...) est négligé. Tout échange de quantité de mouvement ou d'énergie entre
  l'extérieur et les dimensions du corpuscule inacessibles à l'échelle d'obervation ne sont pas
  décrit par le modèle .... mal dit, confus... à refaire... en parallele avec la partie onde.
  *Méthode* :   
  l'extrémité $`M`$ du vecteur position $`\overrightarrow{OM}`$ ou les coordonnées $`(\alpha_M, \beta_M, \gamma_M)`$ 
  suivent un corpuscule en mouvement.
------------------>

#### Comment représenter un corpuscule dans l'espace ?

* Un **corpuscule $`M`$** est un corps occupant à chaque instant une *position déterminée dans l'espace*, et qui apparaît comme
  *ponctuel à la résolution spatiale d'observation*.   
  De ce fait, il est représenté par un **point $`M`$ dans l'espace**. 

#### Qu'est-ce que la cinématique du point ?

* La **cinématique** du point est la **description du mouvement** d'un corpscule dans l'espace et le temps, 
  *indépendamment des causes* qui créent ce mouvement.    
  _La relation entre le mouvement et ses causes est l'objet de la dynamique._

#### La descrition du mouvement dépend-t-elle du référentiel ?

* **Tout observateur observe des corps immobiles ou en mouvements** dans le référentiel qu'il définit, 
  *quelque-soit son propre état de mouvement* par rapport à d'autres corps ou observateurs, que son
  *référentiel* soit *galiléen ou non*.
  <br>
  Ainsi tout observateur peut effectuer des mesures de durées et de longueurs, déterminer des dates et des positions, 
  des vitesses et des accélérations, établir des équations horaires et des trajectoires.   
  <br>
   $`\Longrightarrow`$ En ce sens, les **techniques mathématiques** pour décrire le mouvement sont les mêmes pour tout observateurs, 
  *s'appliquent à tout référentiel*.

* Cependant, **deux observateurs** en mouvement l'un par rapport à l'autre et **observant un même corps**, 
  peuvent obtenir des résultats de mesures de *position*, de *vitesse* et d'*accélération*, déterminer des *équations horaires* et
  des *trajectoires differentes*.   
  <br>
  $`\Longrightarrow`$ Le **mouvement observé** et sa description mathématique *dépendent du référentiel* d'observation et de mesure.
 

<br>
![](title-point-kinematics-in-a-reference-frame_v2_L1200.jpg)   
<br>


#### Quelle différence entre référentiel et repère de l'espace ?

à faire.

<br> 
#### Quelles différences entre repères cartésiens et orthonormés, fixes ou mobiles ?

à faire.


#### Comment repérer un corpuscule dans l'espace ?

* Tout point matériel $`M`$ occupe une position dans l'espace et le temps.
<br>

* *Relativement à un système de coordonnées $`(O,\alpha,\beta,\gamma)`$*, la position
  du point $`M`$ **à un instant $`t_O`$** est repérée par ses **coordonnées spatiales   
  <br>
  $`\large{\big(\,\alpha_M(t_0)\,,\,\beta_M(t_0)\,,\,\gamma_M(t_0)\,\big)}`$**.
  <br>
  
* *Relativement au repère de l'espace 
  $`\Big(O,\,\overrightarrow{e_{\alpha}}_M(t_0)\,,\,\overrightarrow{e_{\beta}}_M(t_0)\,,\,\overrightarrow{e_{\gamma}}_M(t_0)\Big)`$*
  associé au système de coordonnées $`\big(\,\alpha_M(t_0)\,,\,\beta_M(t_0)\,,\,\gamma_M(t_0)\,\big)`$,   
  la position du point $`M`$ à un instant $`t_0`$ est repérée par son **vecteur position** d'écriture $`\overrightarrow{OM}(t_0)=\overrightarrow{r_M}(t_0)`$, tel que :
  <br><br>
  **$`\large{\begin{align}
  \overrightarrow{OM}(t_0)\;=\;\; &\alpha_M(t_0)\,\overrightarrow{e_{\alpha}}_M(t_0)\\
  &+\;\beta_M(t_0)\,\overrightarrow{e_{\beta}}_M(t_0)\\
  &+\;\gamma_M(t_0)\,\overrightarrow{e_{\gamma}}_M(t_0)
  \end{align}}`$**    
  <br><br>
  *Si et seulement si* **le repère de l'espace a été précisé précédemment**, alors le vecteur position
  peut s'exprimer seulement par ses composantes, et s'écrit alors :   
  <br>
  **$`\large{\overrightarrow{OM}=\begin{pmatrix}
  \alpha_M(t_0)\\
  \beta_M(t_0)\\
  \gamma_M(t_0)
  \end{pmatrix}}`$**

<br>

#### Quand les vecteurs de base dépendent-ils du temps ?

*  Un *observateur*, définissant un **référentiel $`\mathscr{R}`$** se choisit toujours
   un **repère cartésien** de l'espace $`(O,\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$
   *immobile* par rapport à lui, donc **fixe dans $`\mathscr{R}`$**.   
   Ce choix fait, un référentiel s'écrit alors $`\mathscr{R}(O,x,y,z,t)`$.   
   * $`\Longrightarrow`$ L'origine $`O`$ du repère est immobile relativement à l'observateur :   
     nous dirons alors que $`O`$ est fixe par rapport à $`\mathscr{R}`$.
   * $`\Longrightarrow`$ Chacun des vecteurs $`\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z}`$ de base garde
     chacun sa norme unité, sa direction et son sens au cours du temps relativement à l'obsevateur :    
     on dit *$`\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z}`$* sont *fixes par rapport à $`\mathscr{R}`$*.   
     <br>
     **$`\begin{align}
     \Longrightarrow \left.\dfrac{d\overrightarrow{e_x}}{dt}\right\vert_{\mathscr{R}}&=\overrightarrow{0}\;,\;
     \left.\dfrac{d\overrightarrow{e_y}}{dt}\right\vert_{\mathscr{R}}=\overrightarrow{0}\\
     &\text{et}\quad\left.\dfrac{d\overrightarrow{e_z}}{dt}\right\vert_{\mathscr{R}}=\overrightarrow{0}
     \end{align}`$** 

! *Rappel :*   
! Par définition, un  système de coordonnées *$`(O, x, y, z)`$* est *cartésien* si et seulement si   
! c'est un *système de coordonnées orthonormée tel que*    
! les *déplacements élémentaires* $`d\mathscr{l}_x\;,\;d\mathscr{l}_y\;,\;d\mathscr{l}_z`$ associés aux
! coordonnées sont *égaux aux variations élémentaires des coordonnées* 
! $`dx\;,\;dy\;,\;dz`$, soit :  
! 
! *$`\quad d\mathscr{l}_x=dx\;,\;d\mathscr{l}_y=dy\;,\;d\mathscr{l}_z=dz`$*.
!
! *Cela entraîne* comme conséquence que le vecteur déplacement élémentaire $`\overrightarrow{d\mathscr{l}}`$ vérifie   
!
! *$`\quad\overrightarrow{d\mathscr{l}}=dx\,\overrightarrow{e_x}\,+\,dy\,\overrightarrow{e_y}\,+\,dz\,\overrightarrow{e_z}`$*

!!!! *Attention :*
!!!! Certains auteurs ajoutent à la définition précédente d'un système de coordonnées cartésiennes, 
!!!! que celui-ci doit être de plus, par définition, immobile dans le référentiel d'observation.
!!!!
!!!! M3P2 ne retient pas cette définition, pour des questions de cohérence avec les chapitres concernant
!!!! les relativités (restreinte et générale) dans les différents niveaux.

<br>
* Un *observateur a le droit* de considérer, pour simplifier l'étude de certains problème, 
  un **repère cartésien $`(O',\overrightarrow{e_x'},\overrightarrow{e_y'},\overrightarrow{e_z'})`$ mobile** 
  relativement à lui-même.    
  Dans ce cas, *au moins un des quatre points suivants est vérifié* :   
  1. $`O`$ est mobile par rapport à $`\mathscr{R}`$, donc le vecteur *$`\overrightarrow{OO'}(t)`$ dépend du temps* :    
  2. <br>
    **$`\left.\dfrac{d\overrightarrow{OO'}}{dt}\right\vert_{\mathscr{R}}\ne\overrightarrow{0}`$**
  2. $`\overrightarrow{e_x'}`$ est mobile par rapport à $`\mathscr{R}`$, donc
     le vecteur *$`\overrightarrow{e_x'}(t)`$ dépend du temps* :   
     <br>
     **$`\left.\dfrac{d\overrightarrow{e_x'}}{dt}\right\vert_{\mathscr{R}}\ne\overrightarrow{0}`$**
  3. $`\overrightarrow{e_y'}`$ est mobile par rapport à $`\mathscr{R}`$, donc
     le vecteur *$`\overrightarrow{e_y'}(t)`$ dépend du temps* :   
     <br>
     **$`\left.\dfrac{d\overrightarrow{e_y'}}{dt}\right\vert_{\mathscr{R}}\ne\overrightarrow{0}`$**
  4. $`\overrightarrow{e_z'}`$ est mobile par rapport à $`\mathscr{R}`$, donc
      le vecteur *$`\overrightarrow{e_z'}(t)`$ dépend du temps* :    
     <br>
     **$`\left.\dfrac{d\overrightarrow{e_z'}}{dt}\right\vert_{\mathscr{R}}\ne\overrightarrow{0}`$**

<br>
* Les **systèmes de coordonnées cylindriques et sphériques** (systèmes de coordonnées orthonormées, mais non cartésiennes)
  possèdent des **vecteurs de base** orthonormée associée aux coordonnées, des vecteurs qui *suivent le point $`M`$*
  étudié. Si le point $`M`$ n'est pas immobile dans le référentiel d'observation, ces vecteurs sont alors **mobiles**.   
  <br>
  Ainsi, pour un **observateur définissant un référentiel $`\mathscr{R}(O,x,y,z,t)`$**, nous avons :   
  * en *coordonnées cylindriques $`(\rho,\varphi,z)`$*   
    <br>
    *$`\overrightarrow{e_{\rho}}=\cos\varphi\,\overrightarrow{e_x}+\sin\varphi\,\overrightarrow{e_y}`$*   
    <br>
    *$`\overrightarrow{e_{\varphi}}=-\sin\varphi\,\overrightarrow{e_x}+\cos\varphi\,\overrightarrow{e_y}`$*  
    <br>
    ce qui entraîne   
    <br>
    **$`\begin{align}
      \dfrac{d\overrightarrow{e_{\rho}}}{dt}&=\dfrac{d(\cos\varphi)}{dt}\,\overrightarrow{e_x}+\dfrac{d(\sin\varphi)}{dt}\,\overrightarrow{e_y}\\
      &=\dots\end{align}`$**   
    <br>
    **$`\begin{align}
      \dfrac{d\overrightarrow{e_{\varphi}}}{dt}&=\dfrac{d(-\sin\varphi)}{dt}\,\overrightarrow{e_x}+\dfrac{d(\cos\varphi)}{dt}\,\overrightarrow{e_y}\\
      &=\dots\end{align}`$**   
    <br>
    **$`\dfrac{d\overrightarrow{e_z}}{dt}=\overrightarrow{0}`$**   
    <br>
  * en *coordonnées sphériques $`(r,\theta,\varphi)`$*   
    <br>
    *$`\begin{align}
     \overrightarrow{e_r}(t)=\;&+\sin\theta(t)\cos\varphi(t)\,\overrightarrow{e_x}\\
     &+\sin\theta(t)\sin\varphi(t),\overrightarrow{e_y}+\cos\theta(t)\,\overrightarrow{e_z}
     \end{align}`$*   
     <br>
    *$`\begin{align}
     \overrightarrow{e_{\theta}}(t)=\;&+\cos\theta(t)\cos\varphi(t)\,\overrightarrow{e_x}\\
     &+\cos\theta(t)\sin\varphi(t),\overrightarrow{e_y}-\sin\theta(t)\,\overrightarrow{e_z}
     \end{align}`$*    
     <br>
    *$`\begin{align}
    \overrightarrow{e_{\varphi}}(t)=\;&-\sin\varphi(t)\,\overrightarrow{e_x}\\
     &+\,\cos\varphi(t)\,\overrightarrow{e_y}+0\,\overrightarrow{e_z}
    \end{align}`$*    
    <br>
    ce qui entraîne   
    <br>
    **$`\begin{align}
    \left.\dfrac{d\overrightarrow{e_r}}{dt}\right\vert_{\mathscr{R}}=&\dfrac{d(\sin\theta\,\cos\varphi)}{dt}\,\overrightarrow{e_x}\\
    &+\dfrac{d(\sin\theta\,\sin\varphi)}{dt}\,\overrightarrow{e_y}+\dfrac{d(\cos\theta)}{dt}\,\overrightarrow{e_z}
    \end{align}`$**   
    <br>
    **$`\begin{align}
    \left.\dfrac{d\overrightarrow{e_{\theta}}}{dt}\right\vert_{\mathscr{R}}=&\dfrac{d(\cos\theta\,\cos\varphi)}{dt}\,\overrightarrow{e_x}\\
    &+\dfrac{d(\cos\theta\,\sin\varphi)}{dt}\,\overrightarrow{e_y}-\dfrac{d(\sin\theta)}{dt}\,\overrightarrow{e_z}
    \end{align}`$**   
    <br>
    **$`\begin{align}
    \left.\dfrac{d\overrightarrow{e_{\varphi}}}{dt}\right\vert_{\mathscr{R}}=&\dfrac{d(-\sin\varphi)}{dt}\,\overrightarrow{e_x}\\
    &+\dfrac{d(\cos\varphi)}{dt}\,\overrightarrow{e_y}+ 0\,\overrightarrow{e_z}
    \end{align}`$**   


#### Pourquoi simplifier l'écriture des dérivées temporelles ?

* En cinématique, chaque *calcul de vitesse et d'accélération* peuvent utiliser un 
  **nombre important de dérivées premières ou secondes**. 
  La lecture d'un calcul utilisant les opérateurs $`\dfrac{d}{dt}`$
  et $`\dfrac{d^2}{dt^2}`$ peut être rendue *plus aisée en simplifiant l'écriture* de ces opérateurs.

* Les *dérivées premières et secondes* s'écrivent en mettant **respectivement un point et deux points au-dessus**
  de la cordonnée ou de composante qui est dérivée :   
  <br>
  *$`\large{\dfrac{dx}{dt}=\;}`$* **$`\large{\dpt{x}}`$**   
  <br>
  *$`\large{\dfrac{d^2x}{dt^2}=\;}`$* **$`\large{\ddpt{x}}`$**

* Cette écriture simplifiée s'applique à toute coordonnées.   
  $`\Longrightarrow`$ selon les systèmes de coordonnées choisis, nous ferons les équivalences :   
  * en coordonnées cartésiennes $`(x,y,z)`$ :   
  $`\dfrac{dx}{dt}=\;\dpt{x}\quad,\quad\dfrac{dy}{dt}=\;\dpt{y}\quad,\quad\dfrac{dz}{dt}=\;\dpt{z}`$   
  $`\dfrac{d^2x}{dt^2}=\;\ddpt{x}\quad,\quad\dfrac{d^2y}{dt^2}=\;\ddpt{y}\quad,\quad\dfrac{d^2z}{dt^2}=\;\ddpt{z}`$   
  * en coordonnées cylindriques $`(\rho,\varphi,z)`$, ou polaires $`(\rho,\varphi)`$ dans un plan $`z=const`$ :
  $`\dfrac{d\rho}{dt}=\;\dpt{\rho}\quad,\quad\dfrac{d\varphi}{dt}=\;\dpt{\varphi}\quad,\quad\dfrac{dz}{dt}=\;\dpt{z}`$    
  $`\dfrac{d^2\rho}{dt^2}=\;\ddpt{\rho}\quad,\quad\dfrac{d^2\varphi}{dt^2}=\;\ddpt{\varphi}\quad,\quad\dfrac{d^2z}{dt^2}=\;\ddpt{z}`$   
  * en coordonnées sphériques $`(\rho,\theta,\varphi)`$, ou polaires $`(\rho,\varphi)`$ dans un plan $`\theta=const`$ :   
  $`\dfrac{dr}{dt}=\;\dpt{r}\quad,\quad\dfrac{d\theta}{dt}=\;\dpt{\theta}\quad,\quad\dfrac{d\varphi}{dt}=\;\dpt{\varphi}`$   
  $`\dfrac{d^2r}{dt^2}=\;\ddpt{r}\quad,\quad\dfrac{d^2\theta}{dt^2}=\;\ddpt{\theta}\quad,\quad\dfrac{d^2\varphi}{dt^2}=\;\ddpt{\varphi}`$   

* Cette écriture peut s'appliquer aussi à tout vecteur dépendant du temps.

#### Comment caractériser le mouvement d'un corpuscule ?

à faire

<br>

#### Qu'est-ce que le vecteur vitesse $`\overrightarrow{\mathscr{v}}`$ ?

à faire

<br>

#### Quelles différences entre la vitesse $`\mathscr{v}`$, le vecteur vitesse $`\overrightarrow{\mathscr{v}}`$, et une de ses composantes $`\mathscr{v}_{\alpha}`$ ?

à faire

<br>

#### Qu'est-ce que le vecteur accélération $`\overrightarrow{\mathscr{a}}`$ ?

à faire

<br>

#### Quelles différences entre la accélération $`a`$, le vecteur accélération $`\overrightarrow{a}`$, et une de ses composantes $`a}_{\alpha}`$ ?

à faire

<br>

#### Qu'est-ce que le repère de Frenet ?

à faire

<br>

#### Quelle est la propriété de $`\overrightarrow{\mathscr{v}}`$ repère de Frenet ?

à faire

<br>

####  Qu'est-ce que l'accélération normale et l'accélération tangentielle ?

à faire

<br>

#### Quel est le vocabulaire pour qualifier le mouvement ?

à faire

<br>

#### Quels sont les mouvements simples ?

à faire

<br>



<br>
![](title-point-kinematics-between-2-reference-frames_v2_L1200.jpg)   
<br>

Questions


Cinématique

Brainstorming "programme et plan d'exposition" :    
(fortement susceptible d'évoluer)

1 - Description du mouvement dans un référentiel quelconque.    

1.1 - La description du mouvement (comment décrire un mouvement?).   

1.1.2 - Choix d'un système de coordonnées adapté (quel système de coordonnées choisir?).    

1.1.3 - Les principaux systèmes de coordonnées :    

1.1.3.1 - Repère cartésien	(INS-1 ; M3P2-3).  
<!--3 coordonnées de longueur-->
\-  Expression du vecteur position	
\-  Expression du vecteur déplacement élémentaire	
\- Expression du vecteur vitesse	
\-  Expression du vecteur accélération	

 1.1.3.2 - Repère cylindrique.  (INS-1 ; M3P2-3).    
<!--2 coordonnées de longueur et 1 coordonnée angulaire-->
\-  Expression du vecteur position	
\-  Expression du vecteur déplacement élémentaire	
\-  Expression du vecteur vitesse	
\-  Expression du vecteur accélération	

1.1.3.3 - Repère sphérique.  (INS-1 ; M3P2-3).  
<!--1 coordonnée de longueur et 2 coordonnées angulaires-->
\-  Expression du vecteur position	
\-  Expression du vecteur déplacement élémentaire	
\-  Expression du vecteur vitesse	
\-  Expression du vecteur accélération	

1.1.3.4 - Repère de Frenet.  (INS-1 ; M3P2-3).  
\-  Expression de la position.  
\-  Expression du vecteur déplacement élémentaire.  
\-  Expression du vecteur vitesse.  
\-  Expression du vecteur accélération.  

1 .1.4 - Les coordonnées curvilignes orthogonales généralisées.   (M3P2-4).  

1.2 - Qualification du mouvement    

1.2.1 - Aspect géométrique du mouvement. (INS-1 ; M3P2-3).  

(Sa forme dans l'espace : notion de trajectoire :   
rectiligne INS-1 ; M3P2-3, circulaire INS-1 ; M3P2-3,  hélicoïdale INS-1 ; M3P2-3,  parabolique M3P2-3, elliptique M3P2-3, quelconque M3P2-3).

1.2.2 - Aspect cinématique du mouvement  (INS-1 ; M3P2-3).  
   
(Sa cinématique dans le temps : notion d'équations horaires.   
mouvement uniforme, accéléré (accélération uniforme, non uniforme).   

1.2.3 - les mouvements simples.  

1.2.3.1 - Le mouvement rectiligne (INS-1 ; M3P2-3).    

\- Le mouvement rectiligne.     
\- Le mouvement rectiligne uniforme.     
\-  Le mouvement rectiligne uniformément accéléré (ou décéléré).   	
\-  Le mouvement rectiligne non uniformément accéléré (ou décéléré)	   

1.2.3.2 - Le mouvement circulaire ou hélicoïdal (INS-1 ; M3P2-3).     

 (le mouvement circulaire peut peut-être être traité comme cas particulier dans l'étude du
 mouvement hélicoïdale à ce niveau 3. En effet il aura déjà été vu sous un aspect non vactoriel au niveau 2.     
\-  Le mouvement circulaire	  
\-  Le mouvement circulaire uniforme	
\-  Le mouvement circulaire uniformément accéléré	 
\-  Le mouvement circulaire non uniformément accéléré	).  
<br>
\-  Le mouvement hélicoïdale.   
\-  Le mouvement hélicoïdale uniforme	 
\-  Le mouvement hélicoïdale uniformément accéléré.  	 
\-  Le mouvement hélicoïdale non uniformément accéléré	    

1.2.3.3 - Le mouvement quelconque (M3P2-3).    

\-  Trajectoire : une courbe 1D dans l'espace 2D.     
\-  Paramétrage de la trajectoire :      
&nbsp; &nbsp; &nbsp;  un paramètre.     
&nbsp; &nbsp; &nbsp; les paramètres simples.     
&nbsp; &nbsp; &nbsp; &nbsp;  la distance parcourue par rapport à un point initial.      
&nbsp; &nbsp; &nbsp; &nbsp; le temps depuis un point initial atteint à l'instant origine t=0.     
\-  La vitesse instantanée.     
\-  Le rayon de courbure instantané.     
\-  L'accélération  instantanée, composante tangentielle et composante normale.      


2 - Transformation du mouvement lors d'un changement de référentiel (INS-1 ; M3P2-3).   

\- Composition des vitesses et accélérations	  
\-  Dérivée d’un vecteur dans deux référentiels différents	   
\-  Vitesse d'entraînement.    
\-  Accélérations d'entraînement et de Coriolis	  

@@@@@@@@@@@@@@@@@@

