---
title: 'Domaine de validité de l''optique géométrique'
published : false
visible : false
---

###Domaine de validité de l'optique géométrique

L’**optique géométrique** *modélise le comportement de la lumière* avec les concepts de *rayon lumineux*, d'*indice de réfraction* et un principe de base : le *principe de Fermat* appliqué à la trajectoire des rayons lumineux.

Elle **permet de comprendre puis maîtriser la formation des images** par des *systèmes optiques de dimensions caractéristiques $a$ grandes devant la longueur d’onde $\lambda$ de la lumière $(a \ll  \lambda)$*. 

!! Même le diamètre de 2 millimètres de l'objectif d'un smartphone qui permet de prendre des photos est 2500 fois plus grand que la plus grande longueur d'onde du domaine visible (800nm)

Elle permet de comprendre **comment l'oeil perçoit son environnement**, comprendre et maîtriser le fonctionnement et les caractéristiques de tous les appareils d'optiques utilisés dans la vie de tous les jours : **loupes, miroirs, appareils photos, téléobjectifs, microscopes, télescopes et lunettes astronomiques ou terrestres**, ainsi que **lunettes et lentilles de vue** pour corriger un défaut de la vision.

L'optique géométrique  ne permet pas de comprendre les phénomènes lumineux induits par des systèmes optiques de taille caractéristique a de l'ordre de grandeur ou inférieure à la longueur d'onde &lambda; de la lumière $(a  \approx  \lambda\: ou\: a  \gg  \lambda)$ : les phénomène de diffraction et d'interférences lumineuses. Je comprendrai et maîtriserai ces phénomènes dans le cadre de l'optique ondulatoire, puis de façon plus approfondie dans le cadre de la théorie électromagnétique de Maxwell (Electromagnétisme).

!! Dans la vie de tous les jours, il est difficile de trouver un fait observable qui ne peut se comprendre que par un phénomène d'interférences lumineuses. Néanmoins l'un est spectaculaire et beau à observer, c'est la création des motifs colorés des couleurs de l'arc en ciel, observés à la surface d'une bulle de savon ou d'une fine couche d'huile recouvrant une flaque d'eau.

!! Par contre, trouver dans notre quotidien un fait observable qui ne peut s'expliquer que par un phénomène de diffraction et clairement attribuable à la diffraction  est quasiment impossible.

Elle ne permet pas de comprendre comment la lumière est créée ou absorbée par la matière, ni les phénomènes liés à la polarisation et à la diffusion de la lumière. Je comprendrai et maîtriserai ces phénomènes dans le cadre beaucoup plus large de l'électromagnétisme.

!!! L'exemple le plus évident du phénomène de diffusion est celui de la diffusion de la lumière du soleil par l'atmosphère terrestre. Cette diffusion entraîne d'une part que le ciel de jour est lumineux dans toutes ces directions, et pas seulement dans la direction du soleil, d'autre part que la couleur du ciel est bleue alors que la couleur du soleil est jaune. En effet, dans l'espace interplanétaire, le soleil m'apparaîtrait comme un disque lumineux jaune très intense dans un ciel d'un noir total, hormis les sources de lumière ponctuelles des planètes et des étoiles lointaines.

!!! L'oeil humain n'est pas sensible à la polarisation de la lumière, contrairement aux yeux ou photorécepteurs de certains animaux vertébrés ou invertébrés, comme l'abeille par exemple. Par contre, la technologie actuelle des films en 3D dans les salles de cinéma utilisent des lunettes grand public dont les verres sont polarisés. Différentes expériences mettant en évidence la polarisation de la lumière sont facilement réalisables chez soi en disposant de deux de ces paires de lunettes.

<!-- à mettre quelque-part dans /M : Voir la polarisation de la lumière à l'œil nu (brosse de Haidinger), relativement facile à observer avec un écran d'ordinateur de technologie à cristaux liquides (LCD),
et avec les lunettes 3D de cinéma : http://blog.guillaume-loubet.fr/polarisation-circulaire-et-cinema-3d -->

<!--p>Lorsque &lambda; n’est plus négligeable devant a, il faut tenir explicitement compte du caractère corpusculaire et ondulatoire de la lumière : c’est l’objet de l’optique physique. Ainsi l’optique géométrique ne permet pas de rendre compte des phénomènes d’interférences, de diffraction, elle ne permet pas d’expliquer le fonctionnement d’un Laser. Pour tout cela l’optique physique est nécessaire.</p-->

