---
title: "Combinaisons d'opérateurs"
published: true
routable: true
visible: false
---

### Combinaisons d'opérateurs


#### L'opérateur laplacien scalaire, et la propagation d'un champ scalaire.

##### Opérateur laplacien et équation d'onde d'un champ scalaire.

* Un champ scalaire $`\overrightarrow{U}`$ se propage s'il vérifie l'équation d'onde scalaire.
  <br>
  L'écriture générale de cette équation utilise l'opérateur lagrangien scalaire et s'écrit :   
  <br>
  $`\Delta\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=0`$

* Cet opérateur laplacien scalaire possède une existence en soit, indépendante de son expression dans un système
  de coordonnées donné, de même qu'un vecteur à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée en coordonnées cartésiennes, l'équation d'onde scalaire s'écrit :   
  <br>
  $`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$
  <br>
  l'expression du laplacien scalaire en coordonnées cartésienne étant :   
  <br>
  $`\Delta=\dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$

!!! *Exemples de champs scalaires* :   
!!! * le champ des température dans l'atmosphère terrestre.
!!! * le champ de la densité volumique de masse du globe terrestre, ou de l'atmosphère terrestre.

##### champ scalaire, opérateurs $`\overrightarrow{gradient}`$

* Un champ scalaire $`f`$, fonction continue et au moins une fois dérivable de l'espace, peut être
  caractérisé en chacun de ses points par un vecteur gradient $`\overrightarrow{grad}\,f`$.   
  <br>
  $`\Longrightarrow`$ nous pouvons construire le champ de gradient $`\overrightarrow{grad}\,f`$ qui est un champ vectoriel.

* Ce champ vectoriel $`\overrightarrow{grad}\,f`$, si $`f`$ est deux fois déribale, peut être caractérisé
  en chacun de ses points par sa divergence $`div\,\overrightarrow{grad}\,f`$.   
  <br>
  $`\Longrightarrow`$ nous pouvons construire le champ de divergence $`\overrightarrow{grad}\,f`$ qui est un champ scalaire.

* Cherchons l'expression de ce champ de divergence en fonction du champ f, en coordonnées cartésiennes.
   * L'expression cartésienne du gradient d'un champ $`f`$ est :   
     $`\overrightarrow{grad}\,f=\dfrac{\partial f}{\partial x}\overrightarrow{e_x}+\dfrac{\partial f}{\partial y}\overrightarrow{e_y}+\dfrac{\partial f}{\partial z}\overrightarrow{e_z}`$
   * L'expression cartésienne de la divergence d'un champ $`\overrightarrow{U}`$ est :  
     $`div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}`$   
   ce qui donne au total :   



* nous pouvons construire le champ scalaire
  $`div\,\overrightarrow{U} = div\big(\overrightarrow{grad}\,f`$.   
  <br>
  $`\Longrightarrow`$ A tout champ scalaire $`f`$, je peux associer le champ scalaire
  $`div\,\overrightarrow{U} = div\big(\overrightarrow{grad}\,f`$

* Ce champ scalaire  $`div\,\overrightarrow{U} = div\big(\overrightarrow{grad}\,f`$ possède une existence en soi,   
  indépendante de son expression dans un système de coordonnées donné.

* Construisons l'expression de ce champ scalaire $`div\,\overrightarrow{U} = div\big(\overrightarrow{grad}\,f`$ s'écrit :   
   * L'expression du gradient   
  $`\overrightarrow{grad}\,f=`$







#### L'opérateur laplacien vectoriel, et la propagation d'un champ vectoriel



* Un champ vectoriel $`\overrightarrow{U}`$ se propage s'il vérifie l'équation d'onde vectorielle.
  <br>
  L'écriture générale de cette équation utilise l'opérateur lagrangien vectoriel et s'écrit :   
  <br>
  $`\Delta\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=0`$

* Cet opérateur laplacien vectoriel possède une existence en soit, indépendante de son expression dans un système
  de coordonnées donné, de même qu'un vecteur à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée en coordonnées cartésiennes, l'équation d'onde s'écrit :   
  <br>
  $`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$
  <br>
  l'expression du laplacien en coordonnées cartésienne étant :   
  <br>
  $`\Delta=\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}`$


* Cherchons les coordonnées cartésiennes du premier terme, $`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)`$

$`\color{blue}{div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}}`$

* La divergence d'un champ vectoriel est un champ scalaire.   
      Le gradient d'un champ scalaire $`f`$ est le champ vectoriel, qui s'exprime en coordonnées cartésiennes :

$`\overrightarrow{grad}\,f=\left(
\begin{array}{l}
\dfrac{\partial f}{\partial x}\\
\dfrac{\partial f}{\partial y}\\
\dfrac{\partial f}{\partial z}
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; donc :

$`\overrightarrow{grad}\big(\color{blue}{div\,\overrightarrow{U}}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial}{\partial x}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial y}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial z}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; et nous obtenons :

$`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$


* Cherchons les coordonnées cartésiennes du deuxième terme, * $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$

$`\color{blue}{\overrightarrow{rot}\,\overrightarrow{E}=
\left(\begin{array}{l}
\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}\\
\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}\\
\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}
\end{array}\right)}`$


$`\overrightarrow{rot}\big(\color{blue}{\overrightarrow{rot}\,\overrightarrow{E}\big)}`$
$`\quad =
\left[\begin{array}{l}
\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}}
\right)
-\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}}
\right)\\
\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}}
\right)
-\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}}
\right)\\
\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}}
\right)
-\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}}
\right)\end{array}\right]`$

 &nbsp;&nbsp;&nbsp;&nbsp; Nous obtenons alors :

$`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$
$`\quad =
\left(\begin{array}{l}
\dfrac{\partial^2 E_y}{\partial y\,\partial x}
-\dfrac{\partial^2 E_x}{\partial y^2}
-\dfrac{\partial^2 E_x}{\partial z^2}
+\dfrac{\partial^2 E_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 E_z}{\partial z\,\partial y}
-\dfrac{\partial^2 E_y}{\partial z^2}
-\dfrac{\partial^2 E_y}{\partial x^2}
+\dfrac{\partial^2 E_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 E_y}{\partial x\,\partial z}
-\dfrac{\partial^2 E_x}{\partial x^2}
-\dfrac{\partial^2 E_z}{\partial y^2}
+\dfrac{\partial^2 E_z}{\partial y\,\partial z} \\
\end{array}\right)`$


&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; il reste simplement à combiner les résultats :

$`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$
$`\quad - \quad
\left(\begin{array}{l}
\dfrac{\partial^2 E_y}{\partial y\,\partial x}
-\dfrac{\partial^2 E_x}{\partial y^2}
-\dfrac{\partial^2 E_x}{\partial z^2}
+\dfrac{\partial^2 E_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 E_z}{\partial z\,\partial y}
-\dfrac{\partial^2 E_y}{\partial z^2}
-\dfrac{\partial^2 E_y}{\partial x^2}
+\dfrac{\partial^2 E_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 E_y}{\partial x\,\partial z}
-\dfrac{\partial^2 E_x}{\partial x^2}
-\dfrac{\partial^2 E_z}{\partial y^2}
+\dfrac{\partial^2 E_z}{\partial y\,\partial z} \\
\end{array}\right)`$

$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\quad\quad - \dfrac{\partial^2 E_y}{\partial y\,\partial x}
+\dfrac{\partial^2 E_x}{\partial y^2}
+\dfrac{\partial^2 E_x}{\partial z^2}
-\dfrac{\partial^2 E_z}{\partial z\,\partial x} \\
\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\quad\quad - \dfrac{\partial^2 E_z}{\partial z\,\partial y}
+\dfrac{\partial^2 E_y}{\partial z^2}
+\dfrac{\partial^2 E_y}{\partial x^2}
-\dfrac{\partial^2 E_x}{\partial x\,\partial y} \\
\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \dfrac{\partial^2 E_y}{\partial x\,\partial z}
+\dfrac{\partial^2 E_x}{\partial x^2}
+\dfrac{\partial^2 E_z}{\partial y^2}
-\dfrac{\partial^2 E_z}{\partial y\,\partial z} \\
\end{array}\right)`$

* L'ordre de dérivation n'important pas,    
  (exemple : $`\dfrac{\partial^2}{\partial x\,\partial y}=\dfrac{\partial^2}{\partial y\,\partial x})`$,   
  nous remarquons alors que toutes les dérivées partielles du second ordre correspondant à
  des termes croisés de coordonnées s'annulent :

$`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$
$`\require{cancel}\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\, \partial y}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial x \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 E_y}{\partial y\,\partial x}}}
+\dfrac{\partial^2 E_x}{\partial y^2}
+\dfrac{\partial^2 E_x}{\partial z^2}
-\color{blue}{\cancel{\dfrac{\partial^2 E_z}{\partial z\,\partial x}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial y \,\partial x}}}+\dfrac{\partial^2 U_y}{\partial y^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 E_z}{\partial z\,\partial y}}}
+\dfrac{\partial^2 E_y}{\partial z^2}
+\dfrac{\partial^2 E_y}{\partial x^2}
-\color{blue}{\cancel{\dfrac{\partial^2 E_x}{\partial x\,\partial y}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial z \,\partial x}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial z \,\partial y}}}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 E_y}{\partial x\,\partial z}}}
+\dfrac{\partial^2 E_x}{\partial x^2}
+\dfrac{\partial^2 E_z}{\partial y^2}
-\color{blue}{\cancel{\dfrac{\partial^2 E_z}{\partial y\,\partial z}}} \\
\end{array}\right)`$

* Au total nous obtenons l'expression simple :

**$`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$**
**$`\quad =
\left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}\\
\dfrac{\partial^2 U_y}{\partial y^2}\\
\dfrac{\partial^2 U_z}{\partial z^2}\\
\end{array}\right)`$**

Cette combinaison particulière d'opérateurs $`\overrightarrow{grad}`$, $`\overrightarrow{rot}`$ et $`div`$
constitue la **définition de l'opérateur Laplacien vectoriel** :

**$`\large{\overrightarrow{\Delta}=\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)}`$**



