---
title: Les Ondes
published: true
routable: true
visible: false
lessons:
    -   
      slug: classical-corpuscules-and-waves
      name: PARALLELE : Mécanique de Newton, corpuscules et ondes
      order: 3
    -   
      slug: from-classical-world-to-wave-corpuscular-duality
      name: PARALLELE : from corpuscules and waves to wave-corpuscular duality
      order: 2
---
$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


---


##### Randonnée Contreforts :&nbsp; _physiciens_

---------------------------

##### L'onde et la description de sa propagation

<br>


RÉSUMÉ<br> 
: ---

  *Le concept d'onde*    
  __Onde__ : perturbation d'un milieu caractérisé par une propriété physique scalaire $`\eta`$ ou vectorielle
  $`\vec{\eta}`$, qui s'étend de proche en proche sur des distances souvent bien plus grandes
  que l'amplitude de l'oscillation de chaque particule du milieu autour de sa position d'équilibre.
  * Onde __transversale__ : déplacement local du milieu perturbé est perpendiculaire à la direction de propagation.
  * Onde __longitudinale__ : déplacement local du milieu perturbé est parallèle à la direction de propagation.
  * Onde __progressive__ : la perturbation se propage sur de grandes distances.
  * Onde __stationnaire__ : la perturbation ne se propage pas.<br>
  Les ondes stationnaires résultent de la superposition d'ondes progressives.

  __Célérité__ $`v`$ : vitesse de propagation de la perturbation de l'onde progressive.<br>
  $`\mathscr{v} = \dfrac{\Delta \mathscr{l}}{\Delta t}`$, avec $`\Delta \mathscr{l}`$ distance parcourue par l'onde pendant la durée  $`\Delta t`$.

  -----------------------

  *L'onde périodique*   
  __Onde périodique__ : en tout point de l'espace de vecteur position $`\vec{r}`$ et à tout instant $`t`$, la perturbation $`U(\vec{r},t)`$ du milieu se répète à intervalles de temps réguliers :   
  $`U(\vec{r},t) = U(\vec{r}\,,\; t+n\times T)`$, avec $`n\in\mathbb{Z}`$ et $`T`$ une durée.    

  * __Propriété fondamentale__ de l'onde périodique : sa propriété temporelle décrite par les grandeurs physiques équivalentes :
      * La __période temporelle__ $`T`$ de l'onde (d'appellation commune : "période"), <br>
                   homogène à un temps : unité S.I., la "seconde" (notation $`s`$)..
      * La __fréquence temporelle__ $`\nu`$ $`\; = 1\,/\,T`$ : inverse de la période temporelle, <br> 
                   homogène à l'inverse d'un temps : unité S.I., le "hertz" (notation $`s^{-1}\equiv Hz`$) 

  * __Propriétés du milieu__ : On se limitera à la célérité $`\mathscr{v}`$
     * milieu __homogène__ (noté H) : $`\mathscr{v}`$  ne dépend pas de la position dans le milieu.
     * milieu __isotrope__ (noté I) : $`\mathscr{v}`$  ne dépend pas de la direction de propagation de l'onde.  
     * milieu __dispersif__ : la célérité dépend de la fréquence temporelle de l'onde :
     $`\mathscr{v} = \mathscr{v}(\nu) = \mathscr{v}(T)`$
     * milieu __non dispersif__ : la célérité de dépend pas de la fréquence temporelle de l'onde.
     
  * __Propriété de l'onde dans un milieu HI__  : sa propriété spatiale décrite par les grandeurs physiques équivalentes :
      * La période spatiale appelée __longueur d'onde__ $`\lambda`$, <br>
                   homogène à une longueur : unité S.I., le "mètre" (notation $`m`$), ou ses unités multiples
                   (kilomètre "$`km`$", ...) ou sous-multiples (millimètre "$`mm`$", micromètre "$`\micron m`$", 
                    nanomètre "$`nm`$",... )
      * La __fréquence spatiale__ $`1/\lambda$ : inverse de la longueur d'onde, <br> 
                   d'unité S.I., le $`m^{-1}`$ et ses miultiples et sous-multiples.

    -----------------------
    
    *L'onde périodique monofréquence temporelle*   
     Noms communs d'usage :   
     __Onde sinusoïdale__ = __Onde harmonique__ = (__onde monochromatique__ en optique).   

 

<br>

-----------------

Liste des questions et figures à faire... dans le désordre ...


#### Qu'est-ce qu'une onde ?


#### Quels phénomènes sont caractéristiques d'une onde ?


...


#### Qu'est-ce que le phénomène de réfraction ?


#### Qu'est-ce qu'une onde périodique ?


#### Quelles sont les différentes grandeurs physique caractérisant une onde périodique ?

![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_L1000.gif)


