---
title: Équations de Maxwell , fondement de l'électromagnétisme
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - les équations de Maxwell
      order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-isotropic-media
       name: PARALLÈLE : Propagation des ondes EM, du vide aux milieux matériels isotropes
       order: 1
    -
        slug: maxwell-equations-in-EM-learning-pattern
        name: SITUATION : Les équations de Maxwell dans l'électromagnétisme
        order: 2

---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\speed{\mathscr{v}}`$
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Quel fut le travail de Maxwell ?

* *Jusqu'au milieu du XIVème siècle*, **électricité, magnétisme et optique** étaient étudiés dans des *domaines scientifiques distincts*. 

* Cependant l'*observation de phénomènes naturels et d'expériences de laboratoire* montrèrent une
**interaction incomprise entre électricité, magnétisme,** voire **optique**.
    * naturel : la foudre peu charger des objets métalliques, aimante le fer, créé un éclair.
    * expériences :   
      \- un courant dévie l'aiguille d'une boussole.   
      \- le déplacement d'un aimant créé un courant.

* Bon mathématicien, **Maxwell** fait *synthèse des résultats expérimentaux* de son époque
qui se résume en 4 équations, les *équations de Maxwell*.

* Ces 4 équations **unifient électricité, magnétisme et optique** au sein de l'électromagnétisme,   
  et élargissent l'optique à un *monde nouveau : les ondes électromagnétiques*.

![](Maxwell-equation-fr.png)
_Maxwell modifie deux des équations de l'électrostatique et de la magnétostatique en
introduisant des termes de couplage entre E et B,
et révolutionne ainsi la physique._

#### Pourquoi disons-nous "équations" et pas "théorèmes" de Maxwell ?

* Les **4 équations de Maxwell** *ne sont pas démontrées*, donc elles ne constituent pas des théorèmes.
* Elles sont *posées et supposées vraies*, ce **sont des postulats**.

#### Pourquoi ces équations fondent l'électromagnétisme ?

#### Quel est le domaine de validité de ces équations ?

#### Que sont ces 4 équations de Maxwell ?

##### Sous forme locale 
_(fondamental, connaître)_

* Deux **expressions de la divergence** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ *inchangées par rapport au cas stationnaire* (électrostatique et magnétostatique) :

   * **$`\large{\mathbf{div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Gauss*).

   * ** $`\large{\mathbf{div \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-flux*).


* Deux **expressions du rotationnel** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ qui *changent et couplent les champs $`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$* :

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Faraday*).

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Ampère*).

* où :
   * $`\dens=\dens^{3D}`$ est la densité volumique de charge. 
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ est le vecteur densité volumique de courant. 

------------------

* Et ces équations *réécrites avec l'opérateur nabla : $`\mathbf{\nabla}`$ *

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**


------------------


##### Sous forme intégrale
_(savoir redémontrer)_


* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

* **Maxwell-Gauss** :   
     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
\iiint_{\Ltau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\Ltau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Maxwell-flux** :

     
  À tout instant t, et pour tout volume $`\tau`$ :
  
     * $`\forall \overrightarrow{r}, div \overrightarrow{B} = 0`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0 \\
\iiint_{\Ltau} div\;\overrightarrow{B} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Maxwell-Faraday** :

     
  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :

   * $`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}`$
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$  
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
\text{Newton : espace et temps indépendants,} \\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$   
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\begin{array}{l}
  &nbsp; \\
 \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
\end{array}`$**   
<br>   
   *  Cette équation joue un *rôle important pour les phénomènes d'induction*.    
      _La quantité_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$ 
      _d'appelation historique imparfaite "force électromotrice (fem)", homogène à une tension, est à l'origine d'un courant_
      _électrique traversant le contour $`\Gamma`$ si celui-ci représente un circuit conducteur._
     

---------------

* **Maxwell-Ampère** :

  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :
<br>

$`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
  $`\Longrightarrow`$$` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$  
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
\text{Newton : espace et temps indépendants},\\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$$`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$   
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$

**$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
$`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**



#### Pourquoi parlons-nous de champ électromagnétique ?

* Les 2 équations de couplage de $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ impliquent 
que **variables, $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ ne peuvent exister l'un sans l'autre**.

* Le terme *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implique $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* Le terme *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implique $`\overrightarrow{B}\ne \overrightarrow{0}`$*
 


#### Que disent les équations de Maxwell sur la conservation de la charge ?

##### Loi de conservation de la charge électrique

* Dans la matière, les **charges électriques** sont portées par les *électrons* et
les *protons* des noyaux atomiques. *En physique classique*, ces particules existent, 
et elles **ne peuvent ni surgir du vide, ni disparaître**.

* Ainsi le **principe de conservation de la charge** électrique peut se résumer en une phrase :   
<br>
! *Dans tout volume de l'espace et pendant une durée donnée, la charge électrique*
! *qui entre dans ce volume moins la charge électrique*
! *qui en sort est égale à la variation de la charge dans le volume.* 
<br>
Cela se traduit en *écriture mathématique* par l'**expression intégrale**:   
<br>
Pour toute surface fermée $`S`$ délimitant un volume macroscopique $`\Ltau`$,   
<br>
**$`\mathbf{\oiint_{S\leftrightarrow\Ltau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\Ltau}\dfrac{\partial\dens}{\partial t}\cdot d\tau=0}`$**   
<br>
qui s"énonce :   
<br>
! *Le flux du vecteur densité de courant volumique à travers une surface fermée,*
! *est égal à la dérivée temporelle de la charge totale contenue à l'intérieur de cette surface fermée.*

![](charge-conservation-law-L1200.jpg)

* Cette égalité étant vérifiée quelque-soit le volume d'intégration, c'est que 
  l'égalité porte sur les intégrandes eux-mêmes.   
  $`\Longrightarrow`$ la loi de conservation a aussi une **expression locale**, valide en tout point de l'espace, qui s'écrit :   
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**   

<br><br>

![](charge-conservation-1-L1200.jpg)

<br>

##### Etude des équation de Maxwell

* **Partons de** la combinaison d'opérateurs remarquable, valable pour tout champ vectoriel $`\overrightarrow{U}`$,
   qui s'énonce     
  *" La divergence du rotationnel d'un champ vectoriel est toujours nulle. "* :    
  <br>
  $`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,`$*$`\quad \mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{X}\big)=0}`$*.   
  <br>
  et appliquons là au champ d'induction magnétique  $`\overrightarrow{B}`$ :    
  <br>
  **$`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{B}\big)=0}`$**.

* La *loi de Maxwell-Ampère*   
  *$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$*   
  permet d'écrire :     
  <br>
  **$`\mathbf{div\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0}`$**

* En divisant les termes de droite et de gauche par $`\mu_0`$, l'équation se simplifie :   
  <br>
  $`div\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* L'équation contient déjà $`\overrightarrow{j}`$, je cherche à faire apparaître $`\dens`$.   
  Pour cela, je cherche à faire apparaître $`div\,\overrightarrow{j}`$ pour ensuite utiliser la loi de maxwell-Gauss.   
  <br>
  $`div\,\overrightarrow{j} + div\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

<!--------------------
L'espace et le temps étant découplés en physique classique, l'ordre de différentiation
et intégration n'importe pas si elles s'appliquent l'une à des coordonnées spatiales
et l'autre au temps. Ainsi :

$`div\,\overrightarrow{j} +
\dfrac{\partial}{\partial t}\Big(\epsilon_0\, div\,\overrightarrow{E}\Big)=0`$

ce qui permet d'écrire,

$`div\,\overrightarrow{j} + \dfrac{\partial\dens}{\partial t}=0`$

Je reconnais là la loi de conservation de la charge.
----------------------->

* Dans le cadre de la *physique classique, espace et temps sont indépendants*, 
l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   
<br>
*$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right)`$*    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}\left(div\right)`$*.   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Nous obtenons :   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**$`\mathbf{div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}\left(div\,\overrightarrow{E}\right)=0}`$**


* En utilisant la *loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}`$*   
  <br>
nous obtenons l'**équation de conservation locale de la charge** électrique en régime variable (donc toujours vérifiée) :   
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**


! *Les équations de Maxwell contiennent et impliquent la conservation de la charge électrique.*



<!--Plutôt pour partie principale--------------------

* Il faut faire apparaître les distributions de charge $`\dens^{3D}`$ et de vecteur  densité de courant volumique $`\overrightarrow{j}^{3D}`$.    
Pour cela nous utilisons la loi de Maxwell-Ampère    
* $`\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$   
<br>
$`div\big(
\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Simplifions en divisant de chaque côté par la constante magnétique $`\mu_0`$ :   
<br>
$`div\,\big(
\;\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Dans le cadre de la physique classique, espace et temps sont indépendants, l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   

$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right) `$    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.
$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}
\left(div\right)`$.   
Nous obtenons :   
<br>
$`div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}
\left(div\,\overrightarrow{E}\right)=0`$

* En utilisant la loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}`$ nous obtenons l'équation de conservation locale de la charge électrique en régime variable (donc toujours vérifiée) :   
<br>
$`div\,\overrightarrow{j} +\dfrac{\partial \dens^{3D}}{\partial t}=0`$
--------------------->

* Nous pouvons *intégrer cette égalité locale* sur un volume $`\tau`$ quelconque :   
<br>
$`\displaystyle\iiint_{\Ltau} \Big(div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}\big)\,d\tau=0`$   
<br>
*$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{j}\,d\tau+\iiint_{\Ltau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$*

* Le *théorème d'Ostrogradski* (= théorème *de la divergence*) précise que pour tout champ 
$`\overrightarrow{U}`$ vectoriel et pour tout volume $`\tau`$,    
*$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{U}\,d\Ltau=\oiint_S \overrightarrow{U}\cdot dS`$*,   
$`S`$ étant la surface fermée que délimite le volume $`\tau`$.   
<br>
*Appliqué au premier terme* de l'égalité, nous obtenons :   
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} + \iiint_{\Ltau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$**.  

* En remarquant de nouveau qu'*espace et temps sont indépendants en physique classique*, l'ordre de dérivation ou intégration par une variable spatiale et une variable temporelle n'importe pas :    
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{\partial}{\partial t} \left(\iiint_{\Ltau}\dens \,d\tau\right)=0`$**.    

* En constatant que *$`\displaystyle\iiint_{\Ltau}\dens^{3D} \,d\tau`$ est la charge totale $`Q_{int}`$* 
contenue dans le volume $`\tau`$, nous obtenons l'**expression intégrale de la loi de conservation** de la. charge :   
<br>
**$`\mathbf{\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{dQ_{int}}{dt}=0}`$**.    




#### Le champ électromagnétique peut-il céder de l'énergie à la matière ?

##### Puissance cédée à un porteur de charge

* La **sensibilité** d'une particule **à l'interaction électromagnétique** se quantifie
par le paramètre appelé *charge* électrique de la particule.   

* La force qui décrit l'*action d'un champ électromagnétique $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$* 
sur une particule de charge $`q`$ est la **force de Lorentz** d'expression :   
<br>
**$`\overrightarrow{F}_{\,Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{\speed}\land\overrightarrow{B}\Big)`$**<br>
<br>
&nbsp;&nbsp;où $`\overrightarrow{\speed}`$ est le vecteur vitesse de la particule dans le référentiel d'inertie de l'observation.

* *Lors d'un déplacement élémentaire $`\overrightarrow{dl}`$* de la particule dans le champ électromagnétique
$`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$, le **travail de la force de Lorentz** s'écrit :   
<br>
**$`d\mathcal{W}_{\,Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$**,   
<br>
soit   
<br>
$`\begin{align}
d\mathcal{W}_{\,Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{\speed}\land\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
&\\
&= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{\speed}\land\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
&\\
&= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big) \\
\end{align}`$   
<br>
où $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)`$ est le produit mixte de la séquence des trois vecteurs.

* Les *vecteurs $`\overrightarrow{\speed}`$ et $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$* étant *colinéaires*, le produit mixte 
est nul :   
<br>
*$`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$*,

!!!! 
!!!! <details markdown=1>
!!!! <summary>Rappels sur le produit mixte</summary>
!!!! Le produit mixte de trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$, noté $`(\vec{a}\,,\vec{b}\,,\vec{c})`$
!!!! est défini par :    
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{a}\land\vec{b})\cdot\vec{c}`$.   
!!!! Il est alors facile de démontrer qu'il est invariant par permutation circulaire des 3 vecteurs :
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{b}\,,\vec{c}\,,\vec{a})=(\vec{c}\,,\vec{a}\,,\vec{b})`$.
!!!! C'est donc un nombre réel, dont la valeur absolue s'identifie au volume du parallélépipéde 
!!!! créé les trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$.
!!!!
!!!! Dans le cas étudié, deux vecteurs au moins du produit mixte $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)`$
!!!! sont colinéaires car $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$.
!!!! Je peux dès lors m'assurer que ce produit mixte est nulle,    
!!!! * soit en remarquant que trois vecteurs dont deux sont colinéaires s'inscrivent dans un même plan (2D)   
!!!! et donc le volume (3D) construit par ces trois vecteurs est nul : 
!!!! $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$   
!!!! * soit en utilisant l'invariance du produit mixte par permutation circulaire,    
!!!! $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{\speed},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{\speed},\overrightarrow{\speed},\overrightarrow{B}\Big)`$
!!!! et en remarquant que le produit vecoriel de deux vecteurs colinéaires est nul :
!!!! $`\big\Vert\overrightarrow{\speed}\land\overrightarrow{\speed}\big\Vert=\big\Vert\overrightarrow{\speed}\big\Vert\cdot\big\Vert\overrightarrow{\speed}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{\speed}\land\overrightarrow{\speed}=\overrightarrow{0}`$   
!!!! $`\Longrightarrow \Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>
!!!! 

* $`\Longrightarrow`$ le **travail de la force de Lorentz** se simplifie :   
<br>
**$`d\mathcal{W}_{\,Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$**

! *Remarque :*
!
! La *force magnétique $`\overrightarrow{F}_{\,magn.}=q\,\overrightarrow{\speed}\land\overrightarrow{B}`$*, 
! par nature perpendiculaire au vecteur vitesse $`\overrightarrow{\speed}`$ et donc au vecteur déplacement 
! élémentaire $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$ en tout point de la trajectoire de la particule
! de charge $`q`$, *ne travaille pas* :
!
! $`\mathbf{d\mathcal{W}_{\,magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *Le travail de la force de Lorentz se limite au travail de la force électrique* :
!
! $`\mathbf{d\mathcal{W}_{\,Lorentz} = d\mathcal{W}_{\,élec} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

* La **puissance élémentaire cédée par le champ** à cette particule s'écrit :   
<br>
**$`\mathbf{\mathcal{P}_{cédée} = \dfrac{d\mathcal{W}_{\,Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{\speed}}`$**

##### Puissance cédée dans un matériau avec un seul type porteur de charge

* Si le **milieu matériel** contient *$`n`$ porteurs identiques de charge $`q`$ par unité de volume*,
alors un volume élémentaire $`d\tau`$ contient $`n\,\tau`$ porteurs de charge 
et la **puissance élémentaire cédée** par le champ électromagnétique s'écrit :   
<br>
**$`d\mathcal{P}_{cédée} = \mathcal{n}\,\big( q\,\overrightarrow{E}\cdot\overrightarrow{\speed}\big)\,d\tau`$**

* Exprimée *avec la densité volumique de charge $`\dens=\mathcal{n}\,q`$* :   
<br>
$`d\mathcal{P}_{cédée} = \big(\mathcal{n}\, q\big)\,\overrightarrow{E}\cdot\overrightarrow{\speed}\,d\tau = = \dens\,\overrightarrow{E}\cdot\overrightarrow{\speed}\,d\tau`$

* Exprimée *avec le vecteur densité volumique de courant $`\overrightarrow{j}=\dens\,\overrightarrow{\speed}`$*, en remarquant que 
$`\overrightarrow{E}\cdot\overrightarrow{\speed}=\overrightarrow{\speed}\cdot\overrightarrow{E}`$ :   
<br>
**$`d\mathcal{P}_{cédée} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau`$**

##### Puissance cédée dans un matériau avec un seul type porteur de charge

* Lorsqu'un matériau contient **plusieurs types de porteurs de charges $`q_i`$** 
en *concentrations $`n_i* et animées de *vitesses de dérives $`\overrightarrow{v_d\,i}`$* :   
<br>
$`\displaystyle d\mathcal{P}_{cédée} = \sum_{i=1}^p \big(\mathcal{n}_i\,q_i\,\overrightarrow{E}\cdot\overrightarrow{\speed_i}\big)\,d\tau`$   
<br>
$`\displaystyle d\mathcal{P}_{cédée} = \sum_{i=1}^p \dens_i\,d\tau\,\overrightarrow{E}\cdot\overrightarrow{\speed_i}`$   
<br>
$`\displaystyle d\mathcal{P}_{cédée} =  \sum_{i=1}^p\overrightarrow{j_i}\cdot\overrightarrow{E}\,d\tau`$   
<br>
*$`d\mathcal{P}_{cédée} = \overrightarrow{j}_{total}\cdot\overrightarrow{E}\,d\tau`$*

* En posant plus simplement *$`\overrightarrow{j}_{total}=\overrightarrow{j}`$* :     
<br>
**$`\mathbf{d\mathcal{P}_{cédée} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}`$**

* La **puissance cédée** par le champ électromagnétique **dans un volume $`\tau`$** :   
<br>
**$`\displaystyle\mathbf{\mathcal{P}_{cédée} = \iiint_{\Ltau}\big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}`$**

* C'est l'**$`\large\text{Effet Joule}}`$**


#### Le champ électromagnétique contient-t-il de l'énergie ?

à faire

#### Pourquoi parlons-nous d'ondes électromagnétiques ?

##### Equation d'onde

Pour un champ vectoriel $`\overrightarrow{X}(\overrightarrow{r},t)`$, l'équation d'onde de d'Alembert s'écrit :

$`\Delta \overrightarrow{X} - \dfrac{1}{\speed^2} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$

L'expression de l'opérateur Laplacien vectoriel $`\Delta`$ en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :

$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$

##### Etude de la composante $`\overrightarrow{E}`$ du champ électromagnétique.

L'idée est de calculer pour chacun des champs $`\overrightarrow{E}`$ et $`\overrightarrow{E}`$ 
l'expression de son Laplacien, pour voir si une identification avec l'équation d'onde est
réalisée.

Pour établir l'expression $`\;\;\Delta \overrightarrow{E}\;\;`$, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ à partir des équations
de Maxwell :


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br><br>
En physique classique non relativiste, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle ne change pas le résultat, donc
je peux écrire :
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)
=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right)`$

La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :

$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$

ce qui donne par identification au premier terme de l'équation d'onde :

$`\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}}`$

_(équation de propagation du champ électrique)_

Une étude de forme identique (proposée en autotest dans la partie beyond) me conduirait 
pour le champ magnétique  $`\overrightarrow{B}`$ à l'équation de propagation :

$`\mathbf{\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}}`$

_(équation de propagation du champ magnétique)_

##### Équation de propagation dans la matière

...

##### Équation de propagation dans le vide

 
 L'espace vide est caractérisé par une absence de charges, fixes ou en mouvement. 
 La densité volumique de charge $`\dens_{vide}`$ de même que le vecteur densité volumique de courant
 $`\overrightarrow{j}_{vide}`$ ont une valeur nulle dans tout l'espace vide,
 
 $`\dens_{vide}=0\quad\text{et}\quad\overrightarrow{j}_{vide}=\overrightarrow{0}`$.
 
 Dès lors, l'équation de propagation de l'onde électromagnétique dans le vide prend la forme
 de l'équation de d'Alembert :
 
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$

$`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$






#### Qu'est-ce que le vecteur de Poynting ?

à faire

#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?

à faire

#### Le champ électromagnétique peut-il céder ou prendre de l'énergie à la matière ?

à faire

#### Comment émettre une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles


#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles









