---
title: "Combinaisons d'opérateurs"
published: true
routable: true
visible: false
---

### Combinaisons d'opérateurs

<br>

**POUR L'ÉTUDE DES PHÉNOMÈNES DE PROPAGATION**
**----------------------------**

POUR L'ÉTUDE DES PHÉNOMÈNES DE PROPAGATION
----------------------------

#### L'opérateur laplacien scalaire, et la propagation d'un champ scalaire.

##### 1 - Opérateur laplacien scalaire et équation d'onde d'un champ scalaire.

* Un *champ scalaire $`f`$ se propage* s'il vérifie l'**équation d'onde scalaire**.
  <br>
  L'écriture générale de cette équation *utilise l'opérateur lagrangien scalaire $`\Delta`$* et s'écrit :   
  <br>
  **$`\Delta\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$**

* Cet opérateur laplacien scalaire **$`\Delta`$ possède une existence en soi**, 
  *indépendante de son expression dans un système de coordonnées* donné, de même qu'un vecteur à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée **en coordonnées cartésiennes**, l'*équation d'onde scalaire* s'écrit :   
  <br>
  *$`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$*
  <br>
  l'expression du laplacien scalaire **$`\Delta`$ en coordonnées cartésienne** étant :   
  <br>
  **$`\Delta=\dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$**

!!! *Exemples de champs scalaires* :   
!!! * le champ des température dans l'atmosphère terrestre.
!!! * le champ de la densité volumique de masse du globe terrestre, ou de l'atmosphère terrestre.

##### 2 - Champ scalaire et opérateur $`\overrightarrow{grad}`$

* Un **champ scalaire $`f`$**, fonction continue et au moins une fois dérivable de l'espace, peut être
  caractérisé *en chacun de ses points* par un *vecteur gradient $`\overrightarrow{grad}\,f`$*.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de gradient $`\overrightarrow{grad}\,f`$* qui est un **champ vectoriel**.

##### 3 - Définition du laplacien scalaire à partir du gradient

* Le **champ de gradient $`\overrightarrow{grad}\,f`$** d'un champ scalaire $`f`$ au moins deux fois dérivable, peut être caractérisé
  *en chacun de ses points* par sa *divergence $`div\,\overrightarrow{grad}\,f`$*.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le **champ de divergence $`div\,\overrightarrow{grad}\,f`$** qui est un champ scalaire.

* Cherchons l'expression de ce champ de divergence en fonction du champ f, en coordonnées cartésiennes.
   * L'expression cartésienne du gradient d'un champ $`f`$ est :   
     $`\overrightarrow{grad}\,f=\dfrac{\partial f}{\partial x}\overrightarrow{e_x}+\dfrac{\partial f}{\partial y}\overrightarrow{e_y}+\dfrac{\partial f}{\partial z}\overrightarrow{e_z}`$
   * L'expression cartésienne de la divergence d'un champ $`\overrightarrow{U}`$ est :  
     $`div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}`$
   * La combinaison des deux expressions permet d'exprimer la 
     *divergence du gradient de $`f`$ en coordonnées cartésiennes* :   
     <br>
     *$`div\,\overrightarrow{grad}\,f`$*
     $`\quad= \dfrac{\partial}{\partial x}\left(\dfrac{\partial f}{\partial x}\right)+\dfrac{\partial}{\partial y}\left(\dfrac{\partial f}{\partial y}\right)+\dfrac{\partial}{\partial z}\left(\dfrac{\partial f}{\partial z}\right)`$
     *$`\quad = \dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}`$*   
     <br>
     et l'**opérateur $`div\,\overrightarrow{grad}`$ en coordonnées cartésiennes** :   
     <br>
     **$`div\,\overrightarrow{grad}= \dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$**

* Nous reconnaissons l'expression cartésienne de l'opérateur laplacien.

* L'opérateur combiné $`div\,\overrightarrow{grad}`$ constitue la **définition de l'opérateur laplacien scalaire** :   
<br>
**$`\large{\Delta}=div\;\overrightarrow{grad}`$**

##### 4 - Relation entre les propriétés locales d'un champ scalaire et sa propagation

* Tout champ scalaire $`f`$ (continue et au moins deux fois dérivable) possède son champ de gradient $`\overrightarrow{f}`$.
* *Si le gradient de $`\overrightarrow{f}`$ vérifie l'* **équation d'onde** :   
  <br>
  *$`\large{div\,\overrightarrow{grad}\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0}`$*      
  <br>
  ou écrit avec le laplacien scalaire :   
  <br>
  **$`\large{\Delta\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0}`$**      
  <br>
  **alors le champ scalaire $`f`$ se propage** *à la célérité $`\mathscr{v}`$*.

<br>

-----------------------------------

#### L'opérateur laplacien vectoriel, et la propagation d'un champ vectoriel

##### 1 - Opérateur laplacien vectoriel et équation d'onde d'un champ vectoriel.

* Un *champ vectoriel $`\overrightarrow{U}`$ se propage* s'il vérifie l'**équation d'onde vectorielle**.
  <br>
  L'écriture générale de cette équation *utilise l'opérateur lagrangien vectoriel $`\overrightarrow{\Delta}`$* et s'écrit :   
  <br>
  **$`\overrightarrow{\Delta}\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}`$**

* Cet opérateur laplacien vectoriel **$`\overrightarrow{\Delta}`$ possède une existence en soi**, 
  *indépendante de son expression dans un système de coordonnées* donné, de même qu'un vecteur 
  à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée **en coordonnées cartésiennes**,   
    * Le *champ vectoriel* s'écrit :   
    <br>
    *$`\overrightarrow{U}=U_x\,\overrightarrow{e_x}+U_y\,\overrightarrow{e_y}+U_z\,\overrightarrow{e_z}`$*
    * et l'*équation d'onde vectoriel* se décompose en :   

    *$`\left\{\begin{array}{l}
    \;\left(\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_x}{\partial t^2}=0\\
    \;\left(\dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_y}{\partial t^2}=0\\    
    \;\left(\dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_z}{\partial t^2}=0   
    \end{array}\right.`$*   
    <br>
    *Chacune des composantes du champ vérifie l'équation d'onde scalaire*.

* L'expression du laplacien vectoriel **$`\overrightarrow{\Delta}\,\overrightarrow{U}`$**
  d'un vecteur $`\overrightarrow{U}`$ **en coordonnées cartésiennes** est :   
  <br>
**$`\overrightarrow{\Delta}=\left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
\dfrac{\partial^2 U_y}{\partial x^2} + \dfrac{\partial^2 U_y}{\partial y^2} + \dfrac{\partial^2 U_y}{\partial z^2}\\    
\dfrac{\partial^2 U_z}{\partial x^2} + \dfrac{\partial^2 U_z}{\partial y^2} + \dfrac{\partial^2 U_z}{\partial z^2   
\end{array}\right)`$**

**$`\overrightarrow{\Delta}=\begin{pmatrix}
\dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
\dfrac{\partial^2 U_y}{\partial x^2} + \dfrac{\partial^2 U_y}{\partial y^2} + \dfrac{\partial^2 U_y}{\partial z^2}\\    
\dfrac{\partial^2 U_z}{\partial x^2} + \dfrac{\partial^2 U_z}{\partial y^2} + \dfrac{\partial^2 U_z}{\partial z^2   
\end{pmatrix}`$**

  **$`\overrightarrow{\Delta}=
   \left(
   \begin{array}{l}
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}
    \end{array}
   \right)`$**

  **$`\overrightarrow{\Delta}=
   \left(
   \begin{array}{l}
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}
    \end{array}
   \right)`$**

  **$`\overrightarrow{\Delta}=
   \left(
   \begin{array}{l}
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}
    \end{array}
   \right)`$**
   
**$`\overrightarrow{\Delta}=\dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}`$**


<br>

##### 2 - Champ vectoriel et opérateurs $`div`$ et $`\overrightarrow{rot}`$

* Un **champ vectoriel $`\overrightarrow{U}`$**, fonction continue et au moins une fois dérivable de l'espace,
  peut être caractérisé *en chacun de ses points* par un *scalaire divergence $`div\,\overrightarrow{U}`$* et
  un *vecteur rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$*   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de divergence $`div\,\overrightarrow{U}`$* 
  qui est un **champ scalaire**.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$* 
  qui est un **champ vectoriel**.

<br>

##### 3 - Définition du laplacien vectoriel à partir de la divergence et du rotationnel

* Le **champ de divergence $`div\,\overrightarrow{U}`$** d'un champ vectoriel $`\overrightarrow{U}`$ au moins 
  deux fois dérivable, peut être caractérisé *en chacun de ses points* par : 
   * *son gradient $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$*   
   <br>
   **$`\Longrightarrow`$** nous pouvons cronstruire le 
   **champ de gradient $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$**
   qui est un champ vectoriel.

* Cherchons les coordonnées cartésiennes de $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$`\color{blue}{div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}}`$

* La divergence d'un champ vectoriel est un champ scalaire.   
      Le gradient d'un champ scalaire $`f`$ est le champ vectoriel, qui s'exprime en coordonnées cartésiennes :

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$`\overrightarrow{grad}\,f=\left(
\begin{array}{l}
\dfrac{\partial f}{\partial x}\\
\dfrac{\partial f}{\partial y}\\
\dfrac{\partial f}{\partial z}
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; donc :

$`\overrightarrow{grad}\big(\color{blue}{div\,\overrightarrow{U}}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial}{\partial x}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial y}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial z}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; et nous obtenons l'expression **en coordonnées cartésiennes** :

$`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$
**$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$**

<br>

----------------------------------

<br>


* Le **champ de rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$** d'un champ vectoriel $`\overrightarrow{U}`$ au moins 
  deux fois dérivable, peut être caractérisé *en chacun de ses points* par : 
   * son *rotationnel $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$*   
   <br>
   **$`\Longrightarrow`$** nous pouvons cronstruire le 
   **champ de rotationnel $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$**
   qui est un champ vectoriel.

* Cherchons les coordonnées cartésiennes de $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$.

$`\color{blue}{\overrightarrow{rot}\,\overrightarrow{U}=
\left(\begin{array}{l}
\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}\\
\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}\\
\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}
\end{array}\right)}`$


$`\overrightarrow{rot}\big(\color{blue}{\overrightarrow{rot}\,\overrightarrow{U}\big)}`$
$`\quad =
\left[\begin{array}{l}
\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}}
\right)
-\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}}
\right)\\
\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}}
\right)
-\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}}
\right)\\
\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}}
\right)
-\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}}
\right)\end{array}\right]`$

 &nbsp;&nbsp;&nbsp;&nbsp; Nous obtenons alors l'expression **en coordonnées cartésiennes** :

$`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
**$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_y}{\partial y\,\partial x}
-\dfrac{\partial^2 U_x}{\partial y^2}
-\dfrac{\partial^2 U_x}{\partial z^2}
+\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 U_z}{\partial z\,\partial y}
-\dfrac{\partial^2 U_y}{\partial z^2}
-\dfrac{\partial^2 U_y}{\partial x^2}
+\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 U_y}{\partial x\,\partial z}
-\dfrac{\partial^2 U_x}{\partial x^2}
-\dfrac{\partial^2 U_z}{\partial y^2}
+\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$**

<br>

----------------------------------

<br>

Un **fait important** apparaît par 
*soustraction* des composantes cartésiennes *de $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$*
*et de $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$*

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$
$`\quad - \quad
\left(\begin{array}{l}
\dfrac{\partial^2 U_y}{\partial y\,\partial x}
-\dfrac{\partial^2 U_x}{\partial y^2}
-\dfrac{\partial^2 U_x}{\partial z^2}
+\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 U_z}{\partial z\,\partial y}
-\dfrac{\partial^2 U_y}{\partial z^2}
-\dfrac{\partial^2 U_y}{\partial x^2}
+\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 U_y}{\partial x\,\partial z}
-\dfrac{\partial^2 U_x}{\partial x^2}
-\dfrac{\partial^2 U_z}{\partial y^2}
+\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$

$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\quad\quad - \dfrac{\partial^2 U_y}{\partial y\,\partial x}
+\dfrac{\partial^2 U_x}{\partial y^2}
+\dfrac{\partial^2 U_x}{\partial z^2}
-\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\quad\quad - \dfrac{\partial^2 U_z}{\partial z\,\partial y}
+\dfrac{\partial^2 U_y}{\partial z^2}
+\dfrac{\partial^2 U_y}{\partial x^2}
-\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \dfrac{\partial^2 U_y}{\partial x\,\partial z}
+\dfrac{\partial^2 U_x}{\partial x^2}
+\dfrac{\partial^2 U_z}{\partial y^2}
-\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$

* L'ordre de dérivation n'important pas,    
$`\big(\text{exemple :}\;\dfrac{\partial^2}{\partial x\,\partial y}=\dfrac{\partial^2}{\partial y\,\partial x}\big)`$,   
  nous remarquons alors que toutes les dérivées partielles du second ordre correspondant à
  des termes croisés de coordonnées s'annulent :

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
$`\require{cancel}\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\, \partial y}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial x \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial y\,\partial x}}}
+\dfrac{\partial^2 U_x}{\partial y^2}
+\dfrac{\partial^2 U_x}{\partial z^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial z\,\partial x}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial y \,\partial x}}}+\dfrac{\partial^2 U_y}{\partial y^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial z\,\partial y}}}
+\dfrac{\partial^2 U_y}{\partial z^2}
+\dfrac{\partial^2 U_y}{\partial x^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial x\,\partial y}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial z \,\partial x}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial z \,\partial y}}}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\,\partial z}}}
+\dfrac{\partial^2 U_x}{\partial x^2}
+\dfrac{\partial^2 U_z}{\partial y^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y\,\partial z}}} \\
\end{array}\right)`$

* Au total nous obtenons l'expression simple **en coordonnées cartésiennes** :

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
**$`\quad =\left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\\
\dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\\
\dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$**

* Nous reconnaissons l'expression cartésienne de l'opérateur laplacien vectoriel.

* L'opérateur combiné $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
constitue la **définition de l'opérateur laplacien vectoriel** :   
<br>
**$`\large{\overrightarrow{\Delta}=\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$**

<br>

----------------------------------

<br>

##### 4 - Relation entre les propriétés locales d'un champ vectoriel et sa propagation

* Tout champ vectoriel $`\overrightarrow{U}`$ (continue et au moins deux fois dérivable) 
possède son champ $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$.

* *Si $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$ vérifie l'* **équation d'onde** :   
  <br><br>
  *$`\large{\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$
$`\;\;\large{-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}}`$*      
  <br><br>
  ou écrit avec le laplacien scalaire :   
  <br><br>
  **$`\large{\overrightarrow{\Delta}\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}`$**      
  <<br><br>
  **alors le champ vectoriel $`f`$ se propage** *à la célérité $`\mathscr{v}`$*.







