---
title: Les équations de Maxwell
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - Les équations de Maxwell
      order: 1
---

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période d'élaboration et de construction !

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Génèse des équations de Maxwell.

À écrire.   
Dire : travail de synthèse des résultats expérimentaux...   
Au terme d'un long processus, 4 équations postulées et donc non démontrées.
Rendent compte de tous les phénomènes électriques et magnétiques observés,...
etc...

------------------------------------

#### Les 4 équations de Maxwell

<!----
$`\left \{
   \begin{array}{r c l}
      AB  & = & 192 \\
      C   & = & 5\,896 \\
      DEF & = & 0,5
   \end{array}
   \right.`$
   
   

$`\left \{
   \begin{array}{r c l}
      \text{ÉlectroStatique}  & \; & \text{Maxwell's equations} \\
      \text{cause :}\; \rho \longrightarrow \text{effet :}\overrightarrow{E} & \; & \\
      \text{cond. validité :}\; \rho=0& \; & \\
      div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}  & \; & div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0} \\
      \overrightarrow{rot} \;\overrightarrow{E} =0 & \; & \overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}
   \end{array}
   \right.`$--->

##### Les équations locales 

<!----------
IL FAUDRAIT PRENDRE L4HABITUDE DE DIRE "LOI" ET NON "EQUATION", CAR   
UNE EQUATION EST UNE EGALITE ENTRE DEUX TERMES, QUI PEUT-ËTRE VRAIE OU FAUSSE.   
UNE LOI EST UNE EGALITE ENTRE ENTRE DEUX TERMES QUI EST CONSIDEREE COMME VRAIE.   
C'EST IMPORTANT !!!   
EN LOGIQUE, ON APPRENDRA ET METTRA EN EVIDENCE QU'UNE EQUATION PEUT ËTRE VRAIE OU FAUSSE,   
ET IL EST IMPORTANT QUE L'APPRENANT, LORSQU'IL VERRA UNE EQUATION, SE POSE TOUJOURS LA QUESTION
DE SA VERICITE.
A METTRE EN APPLICATION DANS TOUT M3P2 DES QUE POSSIBLE;
--------------->

Les équations locales de Maxwell sont les plus importantes. Elles relient les propriétés locales de divergence
et de rotationnel du champ électromagnétique $`\big\overrightarrow{E}\,,\overrightarrow{B}\big)`$ à des causes locales, 
la densité volumique de charge $`\dens`$ et le vecteur densité volumique de courant $`\overrightarrow{j}`$.
Elles sont vraies en tout point de l'espace et à tout instant.

Les expressions de divergence des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ restent inchangées par rapport à leurs expressions en champs statiques.   
Ainsi :

* $`div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}\quad`$  (éq. Maxwell-Gauss)   
   Le théorème de Gauss établi en électrostatique reste vrai dans le cadre de l'électromagnétisme, et prend le nom de théorème de Maxwell-Gauss.

* $`div \overrightarrow{B} = 0\quad`$  (éq. Maxwell-flux)   
  ...    

Les expressions de rotationnel des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ sont modifiées 
par rapport aux cas statiques. Chacune d'elle couple les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$.
Elles fondent les propriétés du champs électromagnétique $`(\overrightarrow{E}\,,\,\overrightarrow{B})`$.

* $`\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}\quad`$  (éq. Maxwell Faraday),    
Équation de Maxwell-Faraday qui montre qu'un champ électrique résulte d'un champ magnétique variable dans le temps.

* $`\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\quad`$  (éq. Maxwell-Ampère),   
Équation de Maxwell-Ampère qui montre qu'un champ magnétique résulte d'un champ électrique variable dans le temps.

Dans ces équations,    
*   $`\dens`$ est la densité volumique de charge. 
*   $`\overrightarrow{j}`$ est le vecteur densité volumique de courant. 

! *Note :*   
! Dans l'équation de Maxwell-Ampère, $`\overrightarrow{j}`$ est le vecteur densité 
! volumique de courant, qui correspond à un courant élémentaire $`dI`$ réel à travers un vecteur
! surface élémentaire $`\overrightarrow{dS}`$ au point considéré : $`dI=\overrightarrow{j}\cdot\overrightarrow{dS}`$.   
! 
! Je remarque que le terme *$`\mathbf{\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$* 
! est *homogène à un vecteur densité volumique de courant.*   
!
! De ce fait il est ainsi souvent dénommé vecteur densité volumique de *courant de déplacement*
! de notation $`\mathbf{\overrightarrow{j}_{dépl}}`$*$`=\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$* .
! 
! Avec cette dénomination, l'équation de Maxwell-Ampère peut se réécrire :   
!
! $`\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\big(\overrightarrow{j} +\overrightarrow{j}_{dépl}\big)}`$
<!---------------
!! *Pour aller plus loin:*   
!! Cette remarque, que $`\rho=\rho_{totale}`$ et $`\overrightarrow{j}\overrightarrow{j}_{total}`$ prendra toute sont importance dans l'étude des équation de Maxwell dans les mieux matériels. En effet :   
!! À la densité volumique de charge libre...
------------------>

##### Les équations intégrales

à modifer, compléter et terminer.

<!--
#### Ecuaciones de Maxwell en forma integral / Equations de Maxwell intégrales / ...

$`\displaystyle\oiint_S\overrightarrow{E}\cdot\overrightarrow{dS}=\dfrac{Q_{int}}{\epsilon_0}`$
$`=\dfrac{1}{\epsilon_0} \cdot \displaystyle\iiint_{\tau\leftrightarrow S} \rho \cdot d\tau`$

$`\displaystyle\oiint_S\overrightarrow{B}\cdot\overrightarrow{dS}=0`$

*[ELECMAG4-20]*

[ES] (auto-trad) *Ley de Gauss = teorema de Gauss* <br>
[FR] (CME)  *Théorème de Gauss* <br>
[EN] (auto-trad) *Gauss' theorem* <br>
----------------->

__Équation de Maxwell-Gauss__

$`\displaystyle\iiint_{\tau} div\overrightarrow{E} \cdot d\tau= \displaystyle\iiint_{\tau}
\dfrac{\dens}{\epsilon_0} \cdot d\tau = \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \dens 
\cdot d\tau = \dfrac{Q_{int}}{\epsilon_0} `$

<!--------------------
[ES] <br>
[FR] (CME) Théorème d'Ostrogradsky = théorème de la divergence :<br>
[EN] Ostrogradsky’s theorem = divergence theorem : for all vectorial field :<br>
-------------------->


$`\vec{X}`$, $`\displaystyle\iiint_{\tau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{X}\cdot\overrightarrow{dS}`$

$`\displaystyle\iiint_{\tau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS} = \Phi_E`$

<!-------------------------
[ES] (auto-trad) Flujo eléctrico : <br>
[FR] (CME) Flux du vecteur champ électrique : $`\Phi_E`$ <br>
[EN] (auto-trad) : <br>
----------------------------->

$`\Phi_E = \displaystyle \oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0} `$


<!------------------------------
*[ELECMAG4-20]*

[ES] (auto-trad) *Ley de Faraday* <br>
[FR] (CME)  *Loi de Faraday* <br>
[EN] (auto-trad)  <br>
----------------------------->

<br><br>__Équation de Maxwell-Faraday__

$`\displaystyle\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot \overrightarrow{dS}
= -\displaystyle\iint_{S \leftrightarrow \tau} \dfrac{\partial \overrightarrow{B}}{\partial t}\cdot \overrightarrow{dS}`$

<!----------------------
[ES] (auto-trad) Mecánica newtoniana : espacio y el tiempo son desacoplados $`\Longrightarrow`$ orden de integración
/ derivación entre variables de espacio y tiempo no importa.<br>
[FR](CME) Mécanique newtonienne : espace et temps sont découplés $`\Longrightarrow`$ l'ordre d'intégration / différenciation entre 
variables d'espace et de temps n'importe pas.<br>
[EN](auto-trad)
---------------------->

En mécanique newtonnienne, l'espace et le temps sont découplés. Ainsi l'ordre d'intégration / différenciation entre 
variables d'espace et de temps n'importe pas, et je peuix écire :

$`\displaystyle\iint_S \overrightarrow{rot}\,\overrightarrow{E}\cdot \overrightarrow{dS}`$ 
$`\;= - \dfrac{\partial}{\partial t} \left( \displaystyle\iint_S \overrightarrow{B}\cdot \overrightarrow{dS}\right)`$

<!-----------------------------------------
[ES] (auto-trad) :<br>
[FR] (CME) Théorème de Stokes = théorème du rotationnel : pour tout champ vectoriel $`\vec{X}`$ :<br>
[EN] (auto-trad) Stokes' theorem  : for all vectorial field $`\vec{X}`$ :<br>
------------------------------------------>

Pour faire apparaître directement le champ électrique $`\overrightarrow{E}`$ et non sa propriété locale 
$`\overrightarrow{rot}\,\overrightarrow{E}`$, je peux utiliser le théorème de Stoke

$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$.

Appliqué au champ électrique, il donne :

$`\displaystyle\iint_{S} \overrightarrow{rot} \,\overrightarrow{E}\cdot \overrightarrow{dS}`$
$`\;= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$

J'y reconnais la circulation d'un champ électrique $`{C}_E`$, la grandeur physique associée est une tension.   
L'équation de Maxwell-Faraday s'exprime finalement :

$`\displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$
$`\;= - \dfrac{\partial}{\partial t} \left( \displaystyle\iint_S \overrightarrow{B}\cdot \overrightarrow{dS}\right)
= - \dfrac{\partial \Phi_B}{\partial t}=\mathcal{C}_E\quad\text(tension)`$ 

<!----------------------------
[ES] (auto-trad) :<br>
[FR] (CME) Théorème d'Ostrogradsky = théorème de la divergence : pour tout champ vectoriel $`\vec{X}`$ :<br>
[EN] (auto-trad) Ostrogradsky’s theorem = divergence theorem : for all vectorial field $`\vec{X}`$ :<br>
----------------------------->

<br><br>__Équation de Maxwell-flux__

...

<br><br>__Équation de Maxwell-Ampère__



#### Le champ électromagnétique

----------------------------------

#### Équations de Maxwell et conservation de la charge

-----------------------------------

#### Équations de Maxwell et propagation du champ électromagnétique

##### Rappel sur le phénomène de propagation dans l'espace et le temps

Soit une grandeur physique (scalaire ou vectorielle) représentée par un fonction continue de l'espace et du temps (donc un champ scalaire ou un champ vectoriel dépendant du temps).

Un grandeur physique se propage librement dans l'espace et le temps si aucun phénomène physique localisé dans l'espace et le temps ne vient atténuer ou amplifier, dévier ou disperser sa propagation. 

Le phénomène de propagation d'une grandeur physique qui se déplace librement  à travers l'espace et le temps, est décrit mathématiquement par l'équation d'onde simple. 

L'équation d'onde simple permet de calculer la valeur de la grandeur physique en tout point M de l'espace et à tout instant t.

##### La plus simple des équations d'onde : l'équation de d'Alembert

Pour un champ scalaire $`f(\overrightarrow{r},t)`$, l'équation d'onde simple, 
connue sous le nom d'équation de d'Alembert, est :

$`\Delta f(\overrightarrow{r},t) - \dfrac{1}{v^2} \; \dfrac{\partial^2 \;f(\overrightarrow{r},t)}{\partial\; t^2}=0`$

<!--$`\Delta \overrightarrow{X} - \dfrac{1}{v_{\phi}^2} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$-->

La solution générale s'écrit :

$`f(\overrightarrow{r},t)=\sum_i f_i(\overrightarrow{u_i}.\overrightarrow{r}-v.t)`$

Elle décrit une superposition d'ondes $`f_i`$ qui se déplacent dans les directions en sens représentées par 
les vecteurs unitaires $`\overrightarrow{u_i}`$ à la même vitesse $`v`$ (l'espace vide étant homogène et isotrope).

Pour un champ vectoriel $`\overrightarrow{X}(\overrightarrow{r},t)`$, l'équation d'onde de d'Alembert s'écrit :

$`\Delta \overrightarrow{X} - \dfrac{1}{v^2} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$

L'expression de l'opérateur Laplacien vectoriel $`\Delta`$ en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :

$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$


##### Equation d'onde pour le champ électromagnétique 

L'idée est de calculer pour chacun des champs $`\overrightarrow{E}`$ et $`\overrightarrow{E}`$ 
l'expression de son Laplacien, pour voir si une identification avec l'équation d'onde est
réalisée.

Pour établir l'expression $`\;\;\Delta \overrightarrow{E}\;\;`$, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ à partir des équations
de Maxwell :


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br><br>
En physique classique non relativiste, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle ne change pas le résultat, donc
je peux écrire :
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)
=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right)`$

La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :

$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$

ce qui donne par identification au premier terme de l'équation d'onde :

$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t} `$

_(équation de propagation du champ électrique)_

Une étude de forme identique (proposée en autotest dans la partie beyond) me conduirait 
pour le champ magnétique  $`\overrightarrow{B}`$ à l'équation de propagation :

$`\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$

_(équation de propagation du champ magnétique)_

__Dans la matière__

...

__Dans le vide__

à faire, juste quelquues mots pour expliquer que dans le vide $`\dens=0`$ et $`\overrightarrow{j}=\overrightarrow{0}`$.
La description et l'exploitation de ces équations de propagation se feront dans le chapitre 
"Propagation des ondes électromagnétiques dans le vide".

---------------------------------------

#### Équations de Maxwell et énergie électromagnétique



<!------------------

##### équation d'onde simple

$`\Delta \overrightarrow{X} - \dfrac{1}{v_{\phi}} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$

de solution

#### équation d'onde amortie

$`\Delta \overrightarrow{X} - \dfrac{1}{v_{\phi}} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=
\beta \; \dfrac{\partial \overrightarrow{X}}{\partial t}`$

où $`\beta`$ est le terme d'amortissement

de solution

L'expression de l'opérateur Laplacien vectoriel $`\Delta`$ en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :

$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$


### Equation d'onde pour le champ électromagnétique 
(Ou "Etude du Laplacien du champ électromagnétique")

Pour établir l'expression $`\;\;\Delta \overrightarrow{E}\;\;`$, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ à partir des équations
de Maxwell :


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br><br>
En physique classique non relativiste, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle ne change pas le résultat, donc
je peux écrire :
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)
=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_O} \right)`$

La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :

$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$

ce qui donne par identification au premier terme de l'équation d'onde :

$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t} `$

---------->
