---
title : Collection d'éléments de cours (étape 1) : vocabulaire et équations
published : true
routable: true
visible: false
---

### Análisis vectorial / Analyse vectorielle / Vector analysis


!!!! *Recopilar elementos de cursos / Collecte d'éléments de cours / Collecting course items*
!!!! 
!!!! No publique, no haga visible.<br>
!!!! Ne pas publier, ne pas rendre visible.<br>
!!!! Do not publish, do not make visible.<br>


#### Informaciónes / Informations

--------------------------------------------------------------------------------
 <details markdown=1>
 <summary>
 ¿Qué es un elemento del curso?<br>
 </summary>
* Este es un **componente básico** para crear un curso, que incluye :<br>
 * una o unas *frases estándar muy cortas*.
 * las *palabras clave* del vocabulario científico y técnico.
 * las *ecuaciones matemáticas*

* Se realiza **en los 3 idiomas [ES] [FR] [EN]** para:
 * Identificar el *vocabulario equivalente* en cada idioma.
 * Identificar *diferencias culturales*, especialmente en escritura matemática
 (ejemplo: $`\wedge`$ o $`\times`$)
 
* Su **rol** :
 * permitirá construir el *curso* eligiendo una *serie de elementos básicos*.
 * *redacción final libre* en cada idioma dentro de cada elemento central.
 * *se puede repetir en varios cursos*.

* **Ventajas** :
 * permite *cursos muy similares* en los 3 idiomas, que se pueden mostrar en paralelo.
 * *sin traducción palabra por palabra*.
 * permite mantener *ejemplos y expresiones lingüísticas específicas de cada cultura*.
</details>

 <details markdown=1>
 <summary>
 Qu'est-ce qu'un élement de cours? 
 </summary>
* C'est un **élément de base** pour construire un cours, comprenant :<br>
 * une ou quelques *phrases très courtes, standards*.
 * les *mots clés* du vocabulaire scientifique et technique.
 * les *équations mathématique*

* Il est **réalisé dans les 3 langues [ES] [FR] [EN]** pour :
 * Identifier le *vocabulaire équivalent* dans chaque langue.
 * Identifier les *différences culturelles*, notamment dans l'écriture mathématique<br>
 (exemple : $`\wedge`$ ou $`\times`$)
 
* Son **rôle** : 
 * permettra de construire le *cours* en choisissant une *suite d'éléments de base*.
 * *rédaction finale libre* dans chaque langue au sein de chaque élément de base.
 * *peut être repris dans plusieurs cours*.

* **Avantages** : 
 * permet des *cours très proches* dans les 3 langues, pouvant être affichés en parallèle.
 * *pas de traduction mot-à-mot*.
 * permet de garder *exemples et expressions linguistiques propres à chaque culture*.
</details>

 <details markdown=1>
 <summary>
 What is a course item?
 </summary>

 * This is a **basic block** to build a course, including: <br>
  * one or a few *very short, standard sentences*.
  * the *key words* of the scientific and technical vocabulary.
  * the *mathematical equations*

* It is **realized in the 3 languages [ES] [FR] [EN]** to:
  * Identify the *equivalent vocabulary* in each language.
  * Identify *cultural differences*, especially in mathematical writing <br>
  (example: $`\wedge`$ or $`\times`$)
 
* His **role** :
  * will allow the *course* to be built by choosing a *series of basic elements*.
  * *free final writing* in each language within each core element.
  * *can be repeated in several courses*.

* **Advantages** :
  * allows *very similar courses* in the 3 languages, which can be displayed in parallel.
  * *no word-for-word translation*.
  * allows to keep *examples and linguistic expressions specific to each culture*.
</details>

------------------

<details markdown=1>
<summary>
¿Cómo contribuir ?<br>
</summary>
* Directamente en el **GitLab M3P2 con su nombre de usuario / contraseña**, haciendo clic en Mejorar este curso
 al final de esta página.
* En el **documento de googledoc** : se especificará.<br>
</details>

<details markdown=1>
<summary>
Comment contribuer ?<br>
</summary>
* Directement sur le **GitLab M3P2 avec votre login / password**, en cliquant sur Améliorer ce cours
 à la fin de cette page.
* Sur le **document googledoc** : à préciser.<br>
</details>

<details markdown=1>
<summary>
How to contribute ? <br>
</summary>
* Directly on ** GitLab M3P2 with your login / password **, by clicking on "Improve this course"
  at the end of this page.
* On the **googledoc document**: to be specified. <br>
</details>

-----------------

<details markdown=1>
<summary>
Depositar un nuevo elemento de curso
</summary>

* **Estructura del elemento a reproducir :**<br>
<br>
Comience escribiendo el código numerado que especifica el tema, aquí :<br>
*MATO3-VA-xxx*
 (dar un *número entero xxx no presente*, un número que sigue a los números presentes o un número intermedio según la lógica de la progresión educativa).<br>
 
 Por nivel n <br>
 (*indique el nivel n = 1, 2, 3 o 4* donde se encuentra su elemento del curso).<br>
 
 * (YYY): *3 iniciales* para identificarse.
 
 * *Comentario* (no obligatorio)
 
 *[ES] + el texto en su idioma*, o *su traducción automática si es posible* en las otras, especificando (auto-tra).
 
* *[LL] (YYY) + las ecuaciones* que usas.
</details>

<details markdown=1>
<summary>
Déposer un nouvel élément de cours
</summary>
* **Struture de l'élément** à reproduire :<br>
<br>
Commencer par écrire le code numéroté qui précise le thème, ici :<br>
*MATO3-VA-xxx* <br>
 (donner un *nombre entier xxx non déjà présent*, un nombre à la suite des nombres présents ou un nombre intercalaire selon la logique de la progression pédagogique)<br>
 <br>
Pour le niveau n  <br>
 (*indiquer le niveau n=1, 2, 3 ou 4* ou se situe votre élément de cours)<br>
 <br>
 *(YYY) : 3 initiales* pour t'identifier. <br>
 <br>
*commentaire* (non obligatoire).<br>
 <br>
*[FR] + le texte dans votre langue* ; ou *sa traduction automatique si possible* dans les autres, en précisant (auto-tra). <br>
 <br>
* *[LL] (YYY) + les équations* que vous utilisez.<br>
</details>

<details markdown=1>
<summary>
Submit a new course item
</summary>
* **Structure of the item** to reproduce: <br>
<br>
Start by writing the numbered code that specifies the theme, here : <br>
*MATO3-VA-xxx* <br>
  (give an *whole number xxx not already present*, a number following the numbers present or an intermediate number according to the logic of the educational progression) <br>
  <br>
  For level n  <br>
  (*indicate level n = 1, 2, 3 or 4* where your course item is located) <br>
  <br>
  *(YYY): 3 initials* to identify you. <br>
  <br>
*comment* (not required). <br>
  <br>
*[EN] + the text in your language*; or *its automatic translation if possible* in the others, specifying (auto-tra). <br>
  <br>
* *[LL] (YYY) + the equations* you use. <br>
</details>

----------------------

<details markdown=1>
  <summary>
 Mejorar, completar, corregir un elemento del curso existente
  </summary>
* Simplemente **dentro del elemento** del curso, escriba **su contribución comenzando con (YYY-LL)**, con: <br>
YYY sus 3 iniciales, y LL su idioma (ES, FR o EN).
<br>
Si solo corrige el texto de una traducción automática en su idioma nativo,
recuerde reemplazar (auto-tra) con sus iniciales (YYY).
</details>

<details markdown=1>
  <summary>
  Améliorer, compléter, corriger un élément de cours existant
  </summary>
 * Simplement **à l'intérieur de l'élément** de cours, écrire **votre contribution en commençant par (YYY-LL)**, avec :<br>
YYY vos 3 initiales, et LL votre langue (ES, FR ou EN).
<br>
Si vous corrigez simplement le texte d'une traduction automatique dans votre langue natale,
pensez à remplacer (auto-tra) par vos initiales (YYY).
</details>
  
<details markdown = 1>
   <summary>
   Improve, complete, correct an existing course item
   </summary>
  * Simply **inside the course item**, write **your contribution starting with (YYY-LL)**, with: <br>
YYY your 3 initials, and LL your language (ES, FR or EN).
<br>
If you just correct in your native language the text of an automatic translation, 
remember to replace (auto-tra) with your initials (YYY).
</details>

--------------------------------------------------------------------------------

<!--
[ES] Esta es una oportunidad, si lo deseamos, para estandarizar nuestros notación y vocabulario,<br> 
http://www.electropedia.org/iev/iev.nsf/index?openform&part=102<br>
o para indicar en el texto la equivalencia con la norma internacional si
queremos mantener nuestras notaciones y vocabularios. Ejemplo :

[FR] C'est l'occasion, si nous le souhaitons, de normaliser notre notation et vocabulaire, <br>
http://www.electropedia.org/iev/iev.nsf/index?openform&part=102<br>
ou d'indiquer dans le texte l'équivalence avec la norme internationale si
on souhaite garder nos notations et vocabulaires. Exemple :

[EN] This is an opportunity, if we wish, to standardize our notation and vocabulary, <br>
http://www.electropedia.org/iev/iev.nsf/index?openform&part=102<br>
or to indicate in the text the equivalence with the international standard 
if we wish to keep our notations and terms. Example :

"élément scalaire de surface $`dA`$" au lieu de "surface élémentaire ou infinitésimale $`dS`$".

---

[ES] La oportunidad también de que un matemático verifique la conformidad de expresiones
matemáticas lógicas. Ejemplo :

[FR] L'occasion aussi de faire vérifier par un mathématicien la conformité des expressions
mathématiques logiques. Exemple :

[EN] The opportunity also to have a mathematician verify the conformity of logical
mathematical expressions. Example :

$`\Longrightarrow \quad\forall \overrightarrow{V}\in\mathcal{P}`$$`\quad\exists ! (\alpha,\beta)\in\mathbb{R}^2`$$`\quad
\overrightarrow{V}=\alpha\cdot\overrightarrow{a}+\beta\cdot\overrightarrow{b}`$

https://en.wikipedia.org/wiki/ISO_31-11

--------------------------------------------------------------------------------
-->


### Vectores, análisis vectorial / Vecteurs, analyse vectorielle / Vectors, vector analysis

<br>
* *MATO3-VA-10*

Vectores en el espacio euclidiano / Vecteurs dans un espace euclidien / Vectors in Euclidean Space

[ES] 3 caracteristicas : norma, dirección y sentido ? 

[FR] 3 caractéristiques : norme, direction et sens 

[EN] 2 characteritics :  magnitude (or length) and direction.

ATENCIÓN / ATTENTION / BE CAREFUL :

[ES] matemáticamente, la palabra "dirección / direction / direction" no tiene el mismo significado en francés y español, y en inglés.

[FR] mathématiquement, le mot dirección / direction / direction" n'a pas le même sens en français et espagnol, et en anglais.

[EN] mathematically, the word "dirección / direction / direction" does not have the same meaning in French and Spanish, and in English.

--------------------------------------------------------------------------------

* *MATO3-VA-20*

##### Significado de los vectores en mecánica / Signification des vecteurs en mécanique / Meaning of vectors in mechanics.

[ES] Los *vectores* pueden representar *diferentes cantidades físicas*. <br>
_ejemplo: vector de velocidad del punto M, y la fuerza que se aplica al punto M._

[FR] Les *vecteurs* peuvent représenter des *grandeurs physiques différentes*.<br>
_exemple : vecteur vitesse du point M, et la force qui s’applique sur le point M._

[EN] The *vectors* can represent *different physical quantities*. <br>
_example: velocity vector of point M, and the force that applies to point M._

[ES] Las *normas* de vectores correspondientes a diferentes cantidades físicas _(ejemplo: 
velocidad y fuerza)_ se expresan en *diferentes unidades* _(respectivamente: $`ms^{-1}`$ y $`N`$)_. 
Ellos *no se pueden comparar*.

[FR] Les *normes* de vecteurs correspondant à des grandeurs physiques différentes _(exemple :
vitesse et force)_ s’expriment dans des **unités différentes** _(respectivement : $`m.s^{-1}`$  
et  $`N`$)_. Elles *ne peuvent pas être comparées*.

[EN] The *magnitudes* of vectors corresponding to different physical quantities _(example: speed
and force)_ are expressed in *different units* _(respectively: $`ms^{-1}`$ and $`N`$)_. 
They *cannot be compared*.

--------------------------------------------------------------------------------

* *MATO3-VA-30*

##### Vectores colineales y no colineales / Vecteurs colinéaires et non colinéaires / Collinear and non-collinear vectors

[ES] Dos **vectores $`\vec{A}`$ et $`\vec{B}`$** son **colineales** si tienen *igual dirección*.

[FR] Deux *vecteurs $`\vec{A}`$ et $`\vec{B}`$* sont **colinéaires** s’ils ont la *même direction* :

[EN] Two **vectors $`\vec{A}`$ et $`\vec{B}`$** are **collinear** if they lie on the *same line or parallel lines* :

<br>Il existe alors un nombre réel $`\alpha`$ tel que l’on peut écrire $`\overrightarrow{A}=\alpha\cdot\overrightarrow{B}`$<br>
" $`\vec{A}`$ et $`\vec{B}`$ sont colinéaires" $`\Longleftrightarrow \exists \alpha\in\mathbb{R}\quad\overrightarrow{A}=\alpha\cdot\overrightarrow{B}`$


[ES]  Dos **vectores $`\vec{A}`$ et $`\vec{B}`$** son **colineales** si non tienen *igual dirección*.

[FR] Deux **vecteurs $`\vec{A}`$ et $`\vec{B}`$** sont **non colinéaires** s’ils ont des *directions différentes*.

[EN] Two **vectors $`\vec{A}`$ et $`\vec{B}`$** are **non collinear** if they lie on *non parallel lines* :

<br>Pour tout nombre réel $`\alpha`$ on peut écrire $`\overrightarrow{A} \ne \alpha\cdot\overrightarrow{B}`$.<br>
"$`\vec{A}`$ et $`\vec{B}`$ sont non colinéaires" $`\Longleftrightarrow \forall\; \alpha\in\mathbb{R}`$$`\quad\overrightarrow{A} \ne\alpha\cdot\overrightarrow{B}`$
                                   
Fig "mechanics-vectors-collinear.png" ready for use.

--------------------------------------------------------------------------------

* *MATO3-VA-40*

##### Suma y resta de vectores / addition et soustraction de vecteurs / addition and subtraction of vectors

--------------------------------------------------------------------------------

* *MATO3-VA-50*

##### multiplicación de un vector por un escalar / multiplication d'un vecteur par un scalaire / multiplication of a vector by a scalar

--------------------------------------------------------------------------------

* *MATO3-VA-60*

#### vectores libres, vecores fijos / vecteurs libres, vecteurs liés / ...

--------------------------------------------------------------------------------

* *MATO3-VA-70*

#### Base vectorial / Base vectorielle / Base of a vector space

##### en un plano $`\mathcal{P}`$ / dans un plan $`\mathcal{P}`$ / in a plane $`\mathcal{P}`$

Definición / Définition :

[ES] **2 vectores $`\vec{a}`$ y $`\vec{b}`$ pertenecientes a un plano $`\mathcal{P}`$, no nulos, no colineales y ordonados**
en una secuencia $`(\vec{a}\,,\,\vec{b})`$ forman una *base* $`(\vec{a}\,,\,\vec{b})`$ de este plano.

[FR] **2 vecteurs $`\vec{a}`$ et $`\vec{b}`$ appartenant à un plan $`\mathcal{P}`$, non nuls, non colinéaires et ordonnés** 
dans une suite $`(\vec{a}\,,\,\vec{b})`$  forment une *base* $`(\vec{a}\,,\,\vec{b})`$ de ce plan.

[EN] ...

Propiedad / Propriété :

[ES] Si $`(\vec{a}\,,\,\vec{b})`$ es una base de un plano $`\mathcal{P}`$, entonces cualquier *vector $`\vec{V}`$* de 
$`\mathcal{P}`$ se descompone *de forma única* en una **combinación lineal** *de los vectores de base* $`\vec{a}`$ et $`\vec{b}`$.

[FR] Si $`(\vec{a}\,,\,\vec{b})`$ est une base d'un plan $`\mathcal{P}`$, alors tout *vecteur $`\vec{V}`$* de $`\mathcal{P}`$
se décompose de *façon unique* en une **combinaison linéaire** *des vecteurs de base* $`\vec{a}`$ et $`\vec{b}`$.

[EN] ...

Escritura matemática / Écriture mathématique :

[ES] 

[FR]"$`(\overrightarrow{a},\overrightarrow{b})`$ est une base de $`\mathcal{P}`$"
$`\Longrightarrow \quad\forall \overrightarrow{V}\in\mathcal{P}`$$`\quad\exists ! (\alpha,\beta)\in\mathbb{R}^2`$$`\quad
\overrightarrow{V}=\alpha\cdot\overrightarrow{a}+\beta\cdot\overrightarrow{b}`$

[EN]

Fig "mechanics-vector-base-plane_L1200.gif" ready for use.

--------------------------------------------------------------------------------

* *MATO3-VA-80*

#### Base vectorial / Base vectorielle / Base of a vector space

##### en un espacio vectorial $`\mathcal{E}`$ de dimensión $`n`$ / dans un espace vectoriel $`\mathcal{E}`$ de dimension $`n`$ / in a vector space $`\mathcal{E}`$ of dimension $`n`$

--------------------------------------------------------------------------------

* *MATO3-VA-90*

[ES] En matemáticas, una **secuencia** es un *conjunto ordenado de elementos*, llamados sus "términos".
y que están *indexados por números naturales*.

[FR] En mathématiques, une **suite** est un *ensemble ordonné d'éléments*, appelés ses "termes" 
et qui sont *indexées par les entiers naturels*.(le terme "n-uplet" n'est pas bon ...)

[EN] In mathematics, a **sequence** is an *ordered set of elements*, called its "terms"
and which are *indexed by natural numbers*.

--------------------------------------------------------------------------------

* *MATO3-VA-100*

[ES] *$`n`$ vectores ordenados* en una secuencia $`(\vec{a_1},\vec{a_2},...,\vec{a_n})`$ forman 
una **base de un espacio vectorial** $`\mathcal{E}`$ de dimensión $`n`$ si *cualquier vector* de este 
espacio se descompone de *manera única en una combinación lineal* de los vectores $`\vec{a_1},\vec{a_2},...,\vec{a_n}`$.

[FR] *$`n`$ vecteurs ordonnés* dans une suite $`(\vec{a_1},\vec{a_2},...,\vec{a_n})`$ forment
une **base d'un espace vectoriel** $`\mathcal{E}`$ de dimension $`n`$, si *tout vecteur* $`\vec{V}`$
de cet espace $`\mathcal{E}`$ se décompose de *façon unique* en une *combinaison linéaire* des vecteurs  
$`\vec{a_1},\vec{a_2},...,\vec{a_n}`$.

[EN] *$`n`$ ordered vectors* in a sequence $`(\vec{a_1},\vec{a_2},...,\vec{a_n})`$ form a 
**basis of a vector space** $`\mathcal{E}`$ of dimension $`n`$ if *any vector* of this space decomposes in 
*a unique way* into a *linear combination* of the vectors $`\vec{a_1},\vec{a_2},...,\vec{a_n}`$.

[ES]

[FR]"$`(\vec{a_1},\vec{a_2},...,\vec{a_n})`$ est une base de $`\mathcal{E}`$"$`
\quad\Longrightarrow \quad\forall \overrightarrow{V}\in\mathcal{E}`$$`\quad\exists ! (\alpha_1,\alpha_1,...;\alpha_1)\in\mathbb{R}^n`$$`\quad
\overrightarrow{V}=\alpha_1\cdot\overrightarrow{a_1}+\alpha_2\cdot\overrightarrow{a_2}+...+\alpha_n\cdot\overrightarrow{a_n}`$

[EN]

--------------------------------------------------------------------------------

* *MATO3-VA-110*

[ES] Para cualquier base denotamos los vectores base $`\vec{a_i}`$.
(ejemplo : vectores de la base convencionale (no ortonormales) de un cristal en física
del estado sólido/estructura de materiales) :<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-08<br>
Reservamos la notación $`\vec{e_i}`$ para las bases normales y ortonormales:<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-28.

[FR] Pour un base quelconque nous notons les vecteurs de base $`\vec{a_i}`$.
(exemple des vecteurs de base conventionnelle (non orthonormée) d'un cristal,
en physique du solide/structure des matériaux) :<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-08<br>
Nous réservons la notation $`\vec{e_i}`$ pour les vecteurs des bases normées et orthonormée :<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-28.

[EN] For any base we denote the base vectors $`\vec{a_i}`$.
(example of the conventional base (not orthonormal) of a crystal, in solid state
physics/structure of materials) :<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-08<br>
We reserve the notation $`\vec{e_i}`$ for vectors of normal and  orthonormal bases :<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-28.

--------------------------------------------------------------------------------

#### Características de una base / Caractéristiques d’une base et d’un repère / Characteristics of a base

--------------------------------------------------------------------------------

* *MATO3-VA-120*

##### Base y ??? normales / Base et repère normés / Normal base and ????

[ES] Base normée $`(\vec{a},\vec{b},\vec{c})`$

[FR] Base normée $`(\vec{a},\vec{b},\vec{c})`$ et repère normé  $`(O,\vec{a},\vec{b},\vec{c})`$

[EN] Normal base $`(\vec{a},\vec{b},\vec{c})`$

[ES] Los vectores de una **base normal** son *vectores de norma uno* : vectores unitarios.

[FR] Les vecteurs d'une **base normée** et d'un repère normé sont des *vecteurs de norme unité* : vecteurs unitaires.

[EN] The vectors of a **normal base** ???? (I am not sure at all here...) are *vectors with a magnitude 1* (1 in the unit system).

$`||\overrightarrow{a}||=1\; ; \;||\overrightarrow{b}||=1\; ; \;||\overrightarrow{c}||=1`$ .

--------------------------------------------------------------------------------

* *MATO3-VA-130*

##### VA110 Base and ??? ortogonales / Base et repère orthogonaux / Orthogonal base and ???

[ES] Base $`(\vec{a},\vec{b},\vec{c})`$ y ???  $`(O, \vec{a},\vec{b},\vec{c})`$ 

[FR] Base $`(\vec{a},\vec{b},\vec{c})`$ et repère  $`(O, \vec{a},\vec{b},\vec{c})`$

[EN] Base $`(\vec{a},\vec{b},\vec{c})`$ and ???  $`(O, \vec{a},\vec{b},\vec{c})`$ 

[ES] Los vectores de una **base ortongonale** son *vectores perpendiculares dos a dos*.

[FR] Les vecteurs d'une **base** ou d'un **repère orthogonal** sont des *vecteurs orthogonaux 2 à 2*.

[EN] The vectors of the **orthogonal base** are *orthogonal 2 to 2 vectors*

$`\overrightarrow{a}\perp\overrightarrow{b}\; ; \;\overrightarrow{a}\perp\overrightarrow{c}\; ; \;\overrightarrow{b}\perp\overrightarrow{c}`$.


--------------------------------------------------------------------------------

* *MATO3-VA-140*
 
##### Base y ??? ortonormales / base et repère orthonormés / ???

[ES] Base orthonormal $`(\vec{e_1},\vec{e_2},\vec{e_3})`$ / ??? $`(O,\vec{e_1},\vec{e_2},\vec{e_3})`$

[FR] Base orthonormée $`(\vec{e_1},\vec{e_2},\vec{e_3})`$ / repère orthonormé $`(O,\vec{e_1},\vec{e_2},\vec{e_3})`$

[EN] ??? $`(\vec{e_1},\vec{e_2},\vec{e_3})`$ / ??? $`(O,\vec{e_1},\vec{e_2},\vec{e_3})`$

[ES]

[FR] orthonormé = **ortho**+*normé* :<br>
\- ortho : $`\forall (\vec{e_i},\vec{e_j}) \in \{\vec{e_1},\vec{e_2},\vec{e_3}\}^2 \quad \vec{e_i}\perp\vec{e_j}`$.<br>
\- normé : $`\forall \vec{e_i} \in \{\vec{e_1},\vec{e_2},\vec{e_3}\} \quad ||\vec{e_i}||=1`$.

[EN]

[ES]

[FR] orthonormé : $`\forall (\vec{e_i},\vec{e_j}) \in \{\vec{e_1},\vec{e_2},\vec{e_3}\}^2 \quad \overrightarrow{e_i}\cdot\overrightarrow{e_j}=\delta_{i\,j}`$<br>
avec le **symbole e Kronecker $`\delta_{i\,j}`$** défini par :<br>
$`\delta_{i\,j}=1`$ si $`i=j\quad`$ et $`\quad\delta_{i\,j}=0`$ si $`i \ne j`$.

[EN]

--------------------------------------------------------------------------------

* *MATO3-VA-150*

#### Regla de la mano derecha  / règle de la main droite / right-hand rule 

[ES] Dos vectores $`\vec{a}`$ y $`\vec{b}`$ distintos de cero, unitarios y ortogonales, forman
una base ortonormal $`(\vec{a},\vec{b})`$ de un plano en el espacio.

[FR] ]Deux vecteurs $`\vec{a}`$ et $`\vec{b}`$ non nuls, unitaires et orthogonaux forment
une base orthonormée $`(\vec{a},\vec{b})`$  d'un plan dans l'espace.

[FR]
 

[ES] Esta base $`(\vec{a},\vec{b})`$ se puede completar con un tercer vector $`\ve{c}`$, unitario
 y perpendicular a $`\vec{a}`$ y a $`\vec{b}`$, para formar una base ortonormal
$`(\vec{a},\vec{b},\vec{c})`$ del espacio.

[FR] Cette base $`(\vec{a},\vec{b})`$ peut être complétée par un troisième vecteur $`\vec{c}`$, unitaire 
 et perpendiculaire à $`\vec{a}`$  et à $`\vec{b}`$, pour former une base orthonormée 
$`(\vec{a},\vec{b},\vec{c})`$ de l'espace.

[EN]

[ES] Este tercer vector $`\vec{c}`$ perpendicular a los vectores $`\vec{a}`$ y
  $`\vec{b}`$ tiene **una dirección**, la 
línea recta normal (perpendicular) al plano $`\mathcal{P}`$, pero hay **dos sentidos posibles** 
para este vector $`\vec{c}`$.<br>
Estos dos posibles sentidos se distinguen por una *regla de orientación del espacío*: la
**regla de los 3 dedos de la mano derecha**.

[FR] Ce troisième vecteur $`\vec{c}`$ perpendiculaire à la fois aux vecteurs  $`\vec{a}`$  et
 $`\vec{b}`$ possède **une direction**, la *droite normale (perpendiculaire)  au plan
 $`\mathcal{P}`$, mais il y a **deux sens possibles** pour ce vecteur $`\vec{c}`$.<br>
Ces deux sens possibles sont distingués par une *règle d’orientation de l’espace* : 
la **règle des 3 doigts de la main droite**.

[EN]

Fig "physics-mechanics-space-orientation-right-hand-rule-direction_L1200_horiz_vert.jpg" ready for use.

--------------------------------------------------------------------------------

* *MATO3-VA-200*

#### Repère orthonormé direct / indirect 

--------------------------------------------------------------------------------

* *MATO3-VA-210*

#### Producto escalar de dos vectores, y norma de un vector / Produit scalaire de 2 vecteurs, et norme d’un vecteur /

##### alable dans une base $`(\vec{a},\vec{b})`$ quelconque d'un plan $`\mathcal{P}`$

$`\overrightarrow{U}\cdot\overrightarrow{V}=||\overrightarrow{U}||\cdot||\overrightarrow{V}||\cdot cos(\widehat{\overrightarrow{U},\overrightarrow{V}})`$

$`\Longrightarrow`$ commutativité : 
$`\forall(\overrightarrow{U},\overrightarrow{V})\in\mathcal{P}^2\quad\overrightarrow{U}\cdot\overrightarrow{V}=\overrightarrow{V}\cdot\overrightarrow{U}`$

$`\Longrightarrow`$ associativité : 
$`\forall(\overrightarrow{U},\overrightarrow{V},\overrightarrow{W})\in\mathcal{P}^3`$
$`\quad\overrightarrow{U}\cdot(\overrightarrow{V}+\overrightarrow{W})=\overrightarrow{U}\cdot\overrightarrow{V}+\overrightarrow{U}\cdot\overrightarrow{W}`$

$`\forall \overrightarrow{U}\in\mathcal{P}\quad\overrightarrow{U}=U_a\cdot\overrightarrow{a}+U_b\cdot\overrightarrow{b}`$<br>
$`\forall \overrightarrow{V}\in\mathcal{P}\quad\overrightarrow{V}=V_a\cdot\overrightarrow{a}+V_b\cdot\overrightarrow{b}`$<br>
$`\overrightarrow{U}\cdot\overrightarrow{V}=(U_a\cdot\overrightarrow{a}+U_b\cdot\overrightarrow{b})\cdot (V_a\cdot\overrightarrow{a}+V_b\cdot\overrightarrow{b})`$<br>
$` = U_a\,V_a\,(\overrightarrow{a}\cdot\overrightarrow{a})+U_a\,V_b\,(\overrightarrow{a}\cdot \overrightarrow{b})`$
$`+U_b\,V_a\,(\overrightarrow{b}\cdot \overrightarrow{a})+U_b\,V_b\,(\overrightarrow{b}\cdot\overrightarrow{b})`$<br>
$`= U_a\,V_a\,\overrightarrow{a}^2 + U_b\,V_b\,\overrightarrow{b}^2 + (U_a\,V_a+U_b\,V_a)\,(\overrightarrow{a}\cdot \overrightarrow{b})`$


--------------------------------------------------------------------------------

* *MATO3-VA-220*

##### Norma de un vector / norme d'un vecteur / vector magnitude

[EN] magnitude = length

$`||\overrightarrow{U}||=\sqrt{\overrightarrow{U}\cdot\overrightarrow{U}}=\overrightarrow{U}^{\frac{1}{2}}`$


--------------------------------------------------------------------------------

* *MATO3-VA-230*

##### Vector unitario / Vecteur unitaire / Unit vector

$`\overrightarrow{U}`$ est unitaire $`\quad\Longleftrightarrow\quad ||\overrightarrow{U}||=1`$


--------------------------------------------------------------------------------

* *MATO3-VA-240*

##### VA230 Producto escalar de dos vectores colineales / Produit scalaire de 2 vecteurs colinéaires / Scalar product of 2 collinear vectors

[EN] scalar product = dot product

$`\overrightarrow{U}`$ et $`\overrightarrow{V}`$ sont colinéaires
$`\quad\Longleftrightarrow\quad (\widehat{\overrightarrow{U},\overrightarrow{V}})\in\{0,\pi\}`$
$`\quad\Longleftrightarrow\quad cos(\widehat{\overrightarrow{U},\overrightarrow{V}})\in\{-1,+1\}`$

$`\overrightarrow{U}`$ et $`\overrightarrow{V}`$ sont colinéaires 
$`\;\Longrightarrow\left|\begin{array}{l}\overrightarrow{U}\cdot\overrightarrow{V}=+\;||\overrightarrow{U}||\cdot
||\overrightarrow{V}||\;\text{si}\;\widehat{\overrightarrow{U},\overrightarrow{V}}=0 
\\ \,
\\
 \overrightarrow{U}\cdot\overrightarrow{V}=-\;||\overrightarrow{U}||\cdot||\overrightarrow{V}||
 \;\text{si}\;\widehat{\overrightarrow{U},\overrightarrow{V}}=\pi\end{array}\right.`$ 
 
--------------------------------------------------------------------------------

* *MATO3-VA-250*

##### Producto escalar de dos vectores ortogonales / Produit scalaire de 2 vecteurs orthogonaux / Scalar product of two orthogonal vectors

$`\forall \overrightarrow{U}\in\mathcal{P}\quad, \forall \overrightarrow{V}\in\mathcal{P}`$
$`\overrightarrow{U}\perp\overrightarrow{V}\Longleftrightarrow\widehat{\overrightarrow{U},
\overrightarrow{V}}=\dfrac{\pi}{2}\Longleftrightarrow cos(\widehat{\overrightarrow{U},
\overrightarrow{V}})=0`$**$`\Longrightarrow\overrightarrow{U}\cdot\overrightarrow{V}=0`$**.

--------------------------------------------------------------------------------

* *MATO3-VA-250*

##### Producto escalar de dos vectores en una base ortonormal del espacio / Prduit scalaire de deux vecteurs 2 vecteurs dans une base orthonormée de l'espace / Scalar product of 2 vectors in an orthonormal basis

"$`(\vec{e_1},\vec{e_2},...,\vec{e_n})`$ est une base orthonormée.
$`\quad\Longrightarrow`$
$`\displaystyle\quad\forall \overrightarrow{U}\in\mathcal{P}\quad \overrightarrow{U}=\sum_{i=1}^n\;U_i\cdot\vec{e_i}`$ 
$`\displaystyle\quad\forall \overrightarrow{V}\in\mathcal{P}\quad \overrightarrow{V}=\sum_{i=1}^n\;V_i\cdot\vec{e_i}`$  
**$`\displaystyle\quad\overrightarrow{U}\cdot\overrightarrow{V}=U_1\,V_1 + U_2\,V_2 + ... + U_n\,V_n = \sum_{i=1}^n\;U_i\,V_i`$**

--------------------------------------------------------------------------------

* *MATO3-VA-260*

##### Cálculo del ángulo entre 2 vectores en una base ortonormal del espacio / Calcul de l’angle entre 2 vecteurs dans une base orthonormée de l'espace / Calculation of the angle between 2 vectors in an orthonormal basis

Plano euclidiano / plan euclidien / euclidian space : $`n=3`$ :

$`\left.\begin{array}{l}\overrightarrow{U}\cdot\overrightarrow{V}=||\overrightarrow{U}||\cdot||\overrightarrow{V}||\cdot 
cos (\widehat{\overrightarrow{U},\overrightarrow{V}}) \\
\overrightarrow{U}\cdot\overrightarrow{V}=U_1\,V_1 + U_2\,V_2 + U_3\,V_3\end{array}\right|`$
$`\quad\Longrightarrow\quad cos (\widehat{\overrightarrow{U},\overrightarrow{V}})=\dfrac{\overrightarrow{U}\cdot\overrightarrow{V}}
{||\overrightarrow{U}||\cdot||\overrightarrow{V}||}`$
$`\quad\Longrightarrow\quad cos (\widehat{\overrightarrow{U},\overrightarrow{V}})=\dfrac{U_1\,V_1 + U_2\,V_2 + U_3\,V_3}
{||\overrightarrow{U}||\cdot||\overrightarrow{V}||}`$
**$`\quad\Longrightarrow\quad \widehat{\overrightarrow{U},\overrightarrow{V}}= arcos\left(\dfrac{\overrightarrow{U}\cdot\overrightarrow{V}}
{||\overrightarrow{U}||\cdot||\overrightarrow{V}||}\right)`$**
**$`\quad\Longrightarrow\quad \widehat{\overrightarrow{U},\overrightarrow{V}}= arcos\left(\dfrac{U_1\,V_1 + U_2\,V_2 + U_3\,V_3}
{||\overrightarrow{U}||\cdot||\overrightarrow{V}||}\right)`$**

[ES] El ángulo se da en valor no algebraico y se expresa en radianes:

[FR] L'angle est donné en valeur non algébrique et exprimé en radian :

[ES] The angle is given in non-algebraic value and expressed in radians:

$`\widehat{\overrightarrow{U},\overrightarrow{V}}\in [0, \pi]\quad`$ (rad).

--------------------------------------------------------------------------------

* *MATO3-VA-270*

#### Producto vectorial de 2 vectores / Produit vectoriel de 2 vecteurs / Vector product of 2 vectors

Selon http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-36,
il faudrait mieux utiliser en France la notation $`\vec{U}\times\vec{V}`$ plutôt
que $`\vec{U}\land\vec{V}`$.
On le fait pour le cours en français, ou alors on garde notre notation en expliquant
notre différence avec la notation anglosaxonne ?
L'étudiant, dans le mode échange, verra le même cours en parallèle dans 2 langues, et donc verra
les différences d'écriture mathémétiques.

--------------------------------------------------------------------------------

* *MATO3-VA-280*

##### Representación en el espacio euclidiano / Représentation dans l'espace euclidien / Representation in Euclidean space.

[ES]  

[FR] (CME)
Le produit vectoriel de deux vecteurs $`\vec{U}`$ et $`\vec{V}`$ non nuls et non 
colinéaires de l'espace, noté $`\vec{U}\land\vec{V}`$ est un vecteur $`\vec{W}`$ :
 * de norme $`||\overrightarrow{W}||=||\overrightarrow{U}|\cdot||\overrightarrow{V}|\cdot sin(\widehat{\overrightarrow{U},\overrightarrow{V}})`$<br>
(l'angle est donné en valeur non algébrique et exprimé en radian : $`\widehat{\overrightarrow{U},\overrightarrow{V}}\in [0, \pi]\;`$ (rad) ).
 * de direction perpendiculaire au plan définit par les deux vecteurs $`\vec{U}`$ et $`\vec{V}`$ :
$`\overrightarrow{W}\perp\overrightarrow{U}`$ et $`\overrightarrow{W}\perp\overrightarrow{V}`$
 * de sens donné par la règle de la main droite : si le sens du premier vecteur $`\vec{U}`$ 
est indiqué par le pouce, le sens du deuxième vecteur $`\vec{V}`$ par l'index, alors le sens du
produit vectoriel $`\vec{W}=\vec{U}\land\vec{V}`$ est donné par le majeur.

[EN] 

[ES]   

[FR] La norme $`||\vec{U}\land\vec{V}||`$ du produit vectoriel de deux vecteurs $`\vec{U}`$ et $`\vec{V}`$ a pour valeur numérique
l'aire du parallélogramme engendré par les deux vecteurs $`\vec{U}`$ et $`\vec{V}`$.

[EN]     .

[ES]  

[FR] On note que, du fait de l'utilisation une fois (ou d'un nombre impair de fois) d'une (même) règle d'orientation 
de l'espace dans sa définition, le produit vectoriel est anti-commutatif :<br>
$`\overrightarrow{U}\land\overrightarrow{V}=\,-\,\overrightarrow{V}\land\overrightarrow{U}`$.

[EN]

[ES]  

[FR] Le produit vectoriel est distributif par rapport à l'addition de deux vecteurs :<br>
$`\overrightarrow{U}\land\,(\overrightarrow{V}+\overrightarrow{W})=
\overrightarrow{U}\land\overrightarrow{V}+\overrightarrow{U}\land\overrightarrow{W}`$.

[EN]

<!--
##### En relation avec les symétries ...

Le produit scalaire de deux vecteurs vraies (ou polaires) est un vecteur axial (ou pseudo vecteur)...

##### Pour un chemin sur les 4 niveaux ...

Scalaire = tenseur de rang 0, vecteur = tenseur de rang 1, tenseurs de rang 2, 3, 4 ...
tenseur polaires et tenseurs axiaux ...

Physique classique :<br>
grandeurs physique : rang 0 polaire : température,...
grandeurs physique : rang 1 polaire : position, vitesse, accélération, force, champ électrique...<br>
grandeurs physique : rang 1 axial : moment d'un force, vitesse angulaire, champ magnétique...<br>
grandeurs physique : rang 2 polaire : contrainte, déformation, ...<br>
propriété physique : rang 1 polaire : effet pyroélectrique,  ...<br>
propriété physique : rang 2 polaire : dilatation themique, ...<br>
propriété physique : rang 3 polaire : effet piézoélectrique, ...<br>
propriété physique : rang 4 polaire : élasticité, rigidité, ...<br>
Physique relativiste :<br>
tenseur de courbure, tenseur énergie-impulsion, ...
-->

--------------------------------------------------------------------------------

* *MATO3-VA-300*

##### Componentes de un producto vectorial en base ortonormal / Composantes d'un produit vectoriel dans une base orthonormée / Components of a vector product in an orthonormal basis

$`(\vec{e_1},\vec{e_2},...,\vec{e_n})`$ est une base orthonormée
$`\displaystyle\quad\forall \overrightarrow{U}\in\mathcal{P}\quad \overrightarrow{U}=\sum_{i=1}^n\;U_i\cdot\vec{e_i}`$ 
$`\displaystyle\quad\forall \overrightarrow{V}\in\mathcal{P}\quad \overrightarrow{V}=\sum_{i=1}^n\;V_i\cdot\vec{e_i}`$  

[FR] For the expression of a vector $`\vec{U}`$ in the base $`(\vec{e_1},\vec{e_2},...,\vec{e_n})`$,
we shouldn't we use (http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-03-04) : <br>
$`\overrightarrow{U}=\begin{pmatrix}U_1\\U_2\\U_3\end{pmatrix}`$ 
instead of $`\overrightarrow{U}=\left|\begin{array}{l}U_1\\U_2\\U_3\end{array}\right.`$ as we do at INSA ?

[ES] ... 

[FR] méthode des produits en croix :

[EN] ...

$`\forall\overrightarrow{U}=\begin{pmatrix}U_1\\U_2\\U_3\end{pmatrix}`$
$`\quad\forall\overrightarrow{V}=\begin{pmatrix}U_1\\U_2\\U_3\end{pmatrix}`$
$`\quad\vec{U}\land\vec{V}=\begin{pmatrix}U_1\\U_2\\U_3\end{pmatrix}\land\begin{pmatrix}V_1\\V_2\\V_3\end{pmatrix}`$
$`=\begin{pmatrix}U_2 V_3 - U_3 V_2\\U_3 V_1 - U_1 V_3\\U_1 V_2 - U_2 V_1\end{pmatrix}`$
$`=U_1V_2\,\overrightarrow{e_3}+U_2V_3\,\overrightarrow{e_1}+U_3V_1\,\overrightarrow{e_2}`$
$`-\,U_1V_3\,\overrightarrow{e_2}-U_2V_1\,\overrightarrow{e_3}-U_3V_2\,\overrightarrow{e_1}`$


[ES]  

[FR] 

[EN] method similar to the sum used to obtain the determinant of a matrix :<br>
<br>$`\vec{U}\land\vec{V}=\begin{vmatrix} \overrightarrow{e_1}&\overrightarrow{e_2}&\overrightarrow{e_3}\\
U_1 & U_2 & U_3\\V_1 & V_2 & V_3\end{vmatrix}`$
$`=U_1V_2\,\overrightarrow{e_3}+U_2V_3\,\overrightarrow{e_1}+U_3V_1\,\overrightarrow{e_2}`$
$`-\,U_1V_3\,\overrightarrow{e_2}-U_2V_1\,\overrightarrow{e_3}-U_3V_2\,\overrightarrow{e_1}`$

--------------------------------------------------------------------------------

* *MATO3-VA-310*

#### Producto mixto de 2 vectores / Produit mixte de 3 vecteurs / Scalar triple product of 3 vectors

[ES] Producto triple escala = producto mixto.

[FR] Produit mixte.

[EN] Scalar triple product = triple product.

[ES] :

[FR] Le produit mixte de 3 vecteurs ordonnés $`\vec{U}`$, $`\vec{V}`$ et $`\vec{W}`$, 
noté $`(\vec{U},\vec{V},\vec{W})`$ est le scalaire (pseudo-scalaire) défini par :<br>

[EN] :

$`(\overrightarrow{U},\overrightarrow{V},\overrightarrow{W})=\overrightarrow{U}\cdot (\overrightarrow{V}\land\overrightarrow{W})`$

Propiedades / Prppriétés / Properties :

$`(\overrightarrow{U},\overrightarrow{V},\overrightarrow{W})
=(\overrightarrow{V},\overrightarrow{W},\overrightarrow{U})
=(\overrightarrow{W},\overrightarrow{U},\overrightarrow{V})`$

$`(\overrightarrow{U},\overrightarrow{V},\overrightarrow{W})
=-\,(\overrightarrow{V},\overrightarrow{U},\overrightarrow{W})
=-(\overrightarrow{U},\overrightarrow{W},\overrightarrow{V})`$
$`=-(\overrightarrow{W},\overrightarrow{V},\overrightarrow{U})`$

--------------------------------------------------------------------------------

* *MATO3-VA-320*

##### Componentes de un producto mixto en base ortonormal / Composantes d'un produit mixte dans une base orthonormée / Components of a triple product in an orthonormal basis

$`(\vec{e_1},\vec{e_2},...,\vec{e_n})`$ est une base orthonormée
$`\displaystyle\quad\forall \overrightarrow{U}\in\mathcal{P}\quad \overrightarrow{U}=\sum_{i=1}^n\;U_i\cdot\vec{e_i}`$ 
$`\displaystyle\quad\forall \overrightarrow{V}\in\mathcal{P}\quad \overrightarrow{V}=\sum_{i=1}^n\;V_i\cdot\vec{e_i}`$  
$`\displaystyle\quad\forall \overrightarrow{W}\in\mathcal{P}\quad \overrightarrow{W}=\sum_{i=1}^n\;VW_i\cdot\vec{e_i}`$  

[ES] :

[FR] Le produit mixte $`(\vec{U},\vec{V},\vec{W})`$ se calcule comme le déterminant 
de la matrice formée par les coordonnées ordonnées en ligne des trois vecteurs 
$`\vec{U}`$, $`\vec{V}`$ et $`\vec{W}`$ ordonnés en colonne :

[EN] :

$`(\vec{U},\vec{V},\vec{W})=\begin{vmatrix} U_1 & U_2 & U_3\\
V_1 & V_2 & V_3\\W_1 & W_2 & W_3\end{vmatrix}`$
$`=U_3 V_1 W_2 + U_1 V_2 W_3 + U_2 V_3 W_1 - U_2 V_1 W_3 `$$`\;- U_3 V_2 W_1 `$$`\;- U_1 V_3 W_2`$

* *MATO3-VA-321*

##### Representación en el espacio euclidiano / Représentation dans l'espace euclidien / Representation in Euclidean space.

[ES] 

[FR] Le module du produit mixte de trois vecteurs $`(\vec{U},\vec{V},\vec{W})`$ 
donne le volume du parallélépipède construit à partir des trois vecteurs appliqués en un même point de l'espace.

[EN]

Figure à créer.

<!--------------------

#### Différentielle d'un vecteur

Por INSA / pour l'INSA / for INSA :

![](vector-differential_PolyINSA.png)

Consédérons un vecteur $`\overrightarrow{OM}`$ susceptible d'évoluer dans le temps, à la fois
en direction et en norme. Entre un instant $`t`$ et $`t+dt`$ (avec $`dt`$ une variation
infinitésimale du temps) le vecteur a varié d'une quantité $`d\left(\overrightarrow{OM}(t)\right)`$
que l'on appelle la différentielle du vecteur $`\vec{OM}`$. Ainsi on peut écrire :<br>

$`d\left(\overrightarrow{OM}(t)\right)=\overrightarrow{OM}(t+dt)-\overrightarrow{OM}(t)`$

La figure ci-contre représente les vecteurs $`\overrightarrow{OM}(t+dt)`$, $`\overrightarrow{OM}(t)`$
et $`d\left(\overrightarrow{OM}(t)\right)`$. 

Plutôt que d'utiliser les vecteurs de base "conventionnels" $`\overrightarrow{e_x}`$ et $`\overrightarrow{e_y}`$, 
nous allons exprimer l'ensemble des vecteurs dans la base $`\overrightarrow{e_{||}}`$ et $`\overrightarrow{e_{\perp}}`$.

Le vecteur $`\overrightarrow{E_{||}}`$ est parallèle à $`\overrightarrow{OM}`$ à l'instant
$`t`$ de sorte que $`\overrightarrow{OM}=||\overrightarrow{OM}|| \cdot\overrightarrow{e_{||}}`$.
De la même manière le vecteur $`\overrightarrow{E_{\perp}}`$ est perpendiculaire à $`\overrightarrow{OM}`$ à l'instant
$`t`$. Ici nous considérons le cas général dans lequel le vecteur $`\overrightarrow{OM}`$ 
a pu, pendant le temps $`dt`$, à la fois s'allonger et tourner d'un angle infinitésimal
$`\Psi`$ (avec $`\Psi=\Psi(t+dt)-\Psi(t)`$).

Nous décomposons le vecteur $`d\left(\overrightarrow{OM}(t)\right)`$ de la manière suivante (conférer figure) :

$`d\left(\overrightarrow{OM}(t)\right)=d\left(\overrightarrow{OM}(t)\right)_{||}
+d\left(\overrightarrow{OM}(t)\right)_{\perp}`$

Dans la limite où $`\Psi`$ tend vers $`0`$, $`d\left(\overrightarrow{OM}(t)\right)`$ 
va s’aligner avec $`\overrightarrow{e_{||}}`$. Dans cette situation,
$`\left|\left|d\left(\overrightarrow{OM}(t)\right)_{||}\right|\right|`$ correspond 
simplement à l’allongement du vecteur $`\overrightarrow{OM}`$. Ainsi 
$`\left|\left|d\left(\overrightarrow{OM}(t)\right)_{||}\right|\right|=\left|\left|d
\overrightarrow{OM}(t)\right|\right|`$.
Par construction, le vecteur $`d\left(\overrightarrow{OM}(t)\right)_{\perp}`$ va 
s’aligner avec le vecteur unitaire $`\overrightarrow{e_T}`$ (toujours dans la limite
où $`\Psi`$ tend vers $`0`$). En utilisant le triangle rectangle, nous déduisons que
sa norme vaut :<br>
$`\left|\left|d\left(\overrightarrow{OM}(t)\right)_{\perp}\right|\right|
= \left|\left|d\overrightarrow{OM}(t)\right|\right|\cdot tan (d\Psi)`$
$`= \left|\left|d\overrightarrow{OM}(t)\right|\right|\cdot d\Psi`$.
Ainsi, la différentielle du vecteur $`d\left(\overrightarrow{OM}(t)\right)`$
s'écrit de la manière suivante :

$`d\left(\overrightarrow{OM}(t)\right)=d\left|\left|\overrightarrow{OM}(t)_{\perp}\right|\right|
\cdot \overrightarrow{e_{||}}\,+\,\left|\left|\overrightarrow{OM}(t)_{\perp}\right|\right|
\cdot d\Psi\cdot\overrightarrow{e_{\perp}}`$

La différentielle d'un vecteur peut aussi être calculée directement à partir de son 
expression analytique. Considérons l'exemple suivant : 

$`\overrightarrow{OM}(t)=A(t)\cdot\overrightarrow{e_x}+B(t)\cdot\overrightarrow{e_y}`$

Ce vecteur est exprimé dans la base des vecteurs unitaires $`\overrightarrow{e_x}`$ 
et $`\overrightarrow{e_y})`$ qui sont "fixes" dans le référentiel d'observation. 
Les coordonnées $`A(t)`$ et $`B(t)`$ dépendent du temps avec, par exemple
$`A(t)=t^2`$, et $`B(t)=4t`$. La différentielle n'étant qu'une "simple" opération
de soustraction vectorielle, elle est distributive de sorte que :

$`d\left(\overrightarrow{OM}\right)(t)=d\left(A(t)\cdot\overrightarrow{e_x}\right)
+d\left(B(t)\cdot\overrightarrow{e_y}\right)`$
$`=d\left(A(t)\right)\cdot\overrightarrow{e_x}
+d\left(B(t)\right)\cdot\overrightarrow{e_y}`$
$`+A(t)\cdot d\overrightarrow{e_x} + B(t)\cdot d\overrightarrow{e_y}`$

Or les vecteurs $`\overrightarrow{e_x}`$ et $`\overrightarrow{e_y})`$ sont fixes, 
on a donc :

$`d\left(\overrightarrow{OM}\right)(t)=d\left(A(t)\cdot\overrightarrow{e_x}\right)
+d\left(B(t)\cdot\overrightarrow{e_y}\right)`$
$`=d\left(A(t)\right)\cdot\overrightarrow{e_x}
+d\left(B(t)\right)\cdot\overrightarrow{e_y}`$
$`=d\left(t^2\right)\cdot\overrightarrow{e_x}
+d\left(4t\right)\cdot\overrightarrow{e_y}`$
$`2\,t\,dt\cdot\overrightarrow{e_x}
+4\,dt\cdot\overrightarrow{e_y}`$



#### Dérivée d’un vecteur par rapport au temps

Por INSA / pour l'INSA / for INSA :

$`\displaystyle\dfrac{d\left(\overrightarrow{OM}\right)(t)}{dt}
=\lim_{dt\rightarrow 0}
\left(
\dfrac{\overrightarrow{OM}(t+dt)-\overrightarrow{OM}(t))}{dt}
\right)`$


##### Propongo el siguiente escrito (a discutir) / Je propose l'écriture suivante (à débattre) / I propose the following writing (to be discussed)

* [ES] En la escritura de una ecuación, vemos con relativa frecuencia vemos el error de tipo :<br>
[FR] Dans l'écriture d'une équation, nous voyons relativement souvent l'erreur de type :<br>
[EN] In the expression of an equation, we relatively often see the type of error :<br>
<br> $`d ... = \int ... d...`$<br>
[ES] En una parte del curso "Atención" (fondo rojo), deberíamos explicar esto.<br>
[FR] Dans une partie de cours "Attention" (fond rouge), nous devrions expliquer cela.<br>
[EN] In a part of the course "Attention" (red background), we should explain this.

* [ES] Si $`xxx`$ es una cantidad física escalar o vectorial, propongo que $`dxxx`$ significa una 
variación infinitesimal de esta cantidad y $`\Delta xxx`$ una variación macroscópica.<br>
[FR] Si $`xxx`$ est une grandeur physique scalaire ou vectorielle, je propose que $`dxxx`$ signifie 
une variation infinitésimale de cette grandeur, et d$`\Delta xxx`$ une variation macrosocpique.<br>
[EN] If $`xxx`$ is a scalar or vector physical quantity, I propose that $`dxxx`$ means an infinitesimal
variation of this quantity, and $`\Delta xxx`$ a macrosocpic variation.<br>
<br> Ainsi
<br> $`\displaystyle\dfrac{d\left(\overrightarrow{OM}\right)(t)}{dt}
=\lim_{dt\rightarrow 0}
\left(
\dfrac{\overrightarrow{OM}(t+dt)-\overrightarrow{OM}(t))}{dt}
\right)`$
<br>deviendrait<br>
<br> $`\displaystyle\dfrac{d\overrightarrow{OM}(t)}{dt}
=\lim_{\Delta t\rightarrow 0}
\left(
\dfrac{\overrightarrow{OM}(t+\Delta t)-\overrightarrow{OM}(t))}{\Delta t}
\right)`$
$`=\dfrac{\overrightarrow{OM}(t+dt)-\overrightarrow{OM}(t)}{dt}`$<br>
<br>
[ES] En las expresiones anteriores, también simplificaría la escritura. Algunos ejemplos :<br>
[FR] Sur les expressions ci-dessus, cela permettrait aussi de simplifier l'écriture. Quelques exemples : :<br>
[EN] On the expressions above, it would also simplify the writing. Some examples :


* Asi / ainsi / thus :<br>
$`d\left(\overrightarrow{OM}\right)(t)=d\left(A(t)\cdot\overrightarrow{e_x}\right)
+d\left(B(t)\cdot\overrightarrow{e_y}\right)`$
$`=d\left(A(t)\right)\cdot\overrightarrow{e_x}
+d\left(B(t)\right)\cdot\overrightarrow{e_y}`$
$`+A(t)\cdot d\overrightarrow{e_x} + B(t)\cdot d\overrightarrow{e_y}`$<br>
se convertiría en / deviendrait / would become :<br>
$`d\overrightarrow{OM}(t)=d\left[A(t)\cdot\overrightarrow{e_x}+B(t)\cdot\overrightarrow{e_y}\right]`$
$`=d\left[A(t)\cdot\overrightarrow{e_x}\right]+d\left[B(t)\cdot\overrightarrow{e_y}\right]`$
$`=dA(t)\cdot\overrightarrow{e_x}+A(t)\cdot d\overrightarrow{e_x}
+d(B(t)\cdot\overrightarrow{e_y}+ B(t)\cdot d\overrightarrow{e_y}`$

* Asi / ainsi / thus :<br>
$`d\left(\overrightarrow{OM}(t)\right)=d\left(\overrightarrow{OM}(t)\right)_{||}
+d\left(\overrightarrow{OM}(t)\right)_{\perp}`$<br>
se convertiría en / deviendrait / would become :<br>
$`d\overrightarrow{OM}(t)=d\overrightarrow{OM}_{||}(t)
+d\overrightarrow{OM}_{\perp}(t)`$<br>
con / avec / with <br>
$`\overrightarrow{OM}_{||}=(\overrightarrow{OM}\cdot\overrightarrow{e_{||}})\,\overrightarrow{e_{||}}\quad`$ and 
$`\quad\overrightarrow{OM}_{\perp}=(\overrightarrow{OM}\cdot\overrightarrow{e_{\perp}})\,\overrightarrow{e_{\perp}}`$ 
-->





