---
title: Define the mathematical tools required at each level
published: true
routable: true
visible: false
lessons:
    - slug: define-g12-mathematical-tools
      order: 1
---

#### Define the mathematical tools required at each level

--------------------

! To read this page :   
! in Spanish : https://m3p2.com/es/lessons/define-g12-mathematical-tools   
! in French : https://m3p2.com/fr/lessons/define-g12-mathematical-tools


#### Foreword

This is an **important step**, because the mathematical tool defines at each level
will be a **strong constraint** *that each theme must respect*
**in experimental sciences** (mechanics, electromagnetism, chemistry, ...)

**Mathematics is separate**. That it is possible that *mathematics* are *in advance of a level* 
compared to the experimental sciences will soon be *subject to a vote*.    
If the result of the vote is in this sense, the mathematics program at each level
may be different from that of the mathematical tool.   
(For example, if it is decided that differential equations appear in 
experimental science at level 3, the study of differential equations could begin in mathematics
in level 2).

#### To participate

<!----------------------
To **add a math element** to a level :
  * classify it in the corresponding chapter (and if necessary create a new chapter)    
    (example: numeration, sets, geometry, ...)
  * write your proposal, and end on the same line with three initials XXX identifying you + your native language (ES, FR or EN), all in brackets.   
    (example: (XXX-FR)).
----------------------->
    
To **add a new proposal or a new point in a proposal**    

* Start your contribution with three initials XXX identifying you + your native language (ES, FR or EN), all in brackets.   
    (example: (XXX-FR)).

<!---------------------
To **react to an existing proposal** :
   * after the element, add your comment (following the other comments)
starting with three initials XXX identifying you + your native language (ES, FR or EN), add your comment after the others
starting with three initials in parenthesis you represent, all in parenthesis.   
    (example: (XXX-FR)).
---------------------->

To **react to a point in an existing proposal** 

* add your comment (following the other comments)
starting with three initials XXX identifying you + your native language (ES, FR or EN), all in brackets.   
    (example: (XXX-FR)).


#### Where to contribute?

To **communicate my proposals**, either :
* directly on the GitLab m3p2 with your login/password, and after a little training on Git. 

   * *Click on "Edit this course"* at the bottom of each column of this page (levels 1 and 2),   
or of the page "https://m3p2.com/en/lessons/define-234-mathematical-tools" (levels 2, 3 and 4).

   * If you prefer *to see in full screen each column* on this page, go to :   
For these *general instructions* : https://m3p2.com/en/brainstorming-pedagogical-teams/synthesis-structuring/math-tools/first-steps   
For *level 1* : https://m3p2.com/en/brainstorming-pedagogical-teams/synthesis-structuring/math-tools/n1   
For *level 2* : https://m3p2.com/en/brainstorming-pedagogical-teams/synthesis-structuring/math-tools/n2   
For *level 3* : https://m3p2.com/en/brainstorming-pedagogical-teams/synthesis-structuring/math-tools/n3   
For *level 4* : https://m3p2.com/en/brainstorming-pedagogical-teams/synthesis-structuring/math-tools/n4   
then *to contribute*, click on "*Edit this course*" at the bottom of the page. 

* *In the M3P2 Googledoc* whose link has been given to you.   
The contribution is to be made in the "Herramientas matemáticas" folder, in the words documents :
   * for *level 1* : Niv/Lev_MatToo_1.docx
   * for *level 2* : Niv/Lev_MatToo_2.docx
   * for *level 3* : Niv/Lev_MatToo_3.docx
   * for *level 4* : Niv/Lev_MatToo_4.docx
   
The Gitlab will be kept up to date with your proposals, also translated into English and Spanish.    
_(This is not required, but if you can also make your contribution in French, more in_
_English or Spanish, this will ease the translation work) ._    
