---
title: Cylindrical coordinates
published: true
routable: true
visible: false
lessons:
    - slug:
      order:
    - slug: cylindrical-coordinates-linear
      order: 1
---


<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!! *LESSON  UNDER  CONSTRUCTION :* <br>
!!!! Published but invisible: does not appear in the tree structure of the m3p2.com site. This course is *under construction*, it is *not approved by the pedagogical team* at this stage. <br>
!!!! Working document intended only for the pedagogical team.

<!--MétaDonnée : INS-1°année_-->

! *Suggested method:*
!
! Each in his own language adapts with his own words, his own sentences, the content of the little ones
! numbered elements
! of jointly developed courses. So it's not a word-for-word translation, but
! the course elements being small, there is a very high corespondance on the content.
! We can really display the courses in parallel in 2 or in all 3 languages,
! it really makes sense to the student.
! If we use different mathematical notations in the 3 languages, each language
! keep its rating. The course display in "exchange" mode allows the student to compare
! vocabulary, and mathematical notations.
!
! For this part "main" of a course, this gives for example:


### Cylindrical coordinates

#### Definition of coordinates and their definition domains

! For example, this course element denoted * CS300 *:

* *CS300* :

Reference frame: Cartesian coordinate system $`(O, x, y, z)`$
\ - **1 point $`O`$ origin** of the space. <br>
\ - **3 axes** named **$`Ox,Oy,Oz`$**, intersecting at $`O`$, **orthogonal 2 to 2**. <br>
\ - **1 unit of length**. <br>

! can give :

The cylindrical coordinates are defined from a Cartesian coordinate system, i.e.
\- 1 point $`O`$ origin of space. <br>
\- 3 axes named $`Ox, Oy, Oz`$, intersecting at $`O`$, orthogonal 2 to 2. <br>
\- 1 unit of length. <br>

! The following element * CS310 *:

* *CS310* :

Cylindrical coordinates $`(\rho,\varphi,z)`$:

\- Any point $`M`$ of space is orthogonally projected onto the plane $`xOy`$ leading 
to the point $`m_{xy}`$, and on the $`Oz`$ axis leading to the point $`m_z`$.

\- The **coordinate $`\ rho_M`$** of the point $`M`$ is the *nonalgebraic distance $`Om_{xy}`$* 
between the point $`O`$ and the point $`m_ {xy}`$.<br>
\- The **coordinate $`\varphi_M`$** of the point $`M`$ is the *nonalgebraic angle 
$`\widehat{xOm_ {xy}}`$* between the axis $`Ox`$ and the half-line $`Om_{xy}`$,
the direction of rotation being such that the trihedron *$`(Ox,Om_ {xy},Oz)`$* is 
a *direct trihedron*.<br>
\- The **coordinate $`z_M`$** of the point $`M`$ is the *algebraic distance $`\overline {Om_z}`$*
between the point $`O`$ and the point $`m_z`$.

**$`\rho_M=\overline{Om_ {xy}}`$, $`\varphi_M = \widehat{xOm_y}`$, $`z_M =Om_z`$**

! can give :

The cylindrical coordinates are ordered and noted $`(\rho,\varphi,z)`$.

For any point $`M`$ in space:

\- The $`\rho_M`$ coordinate of the point $`M`$ is the nonalgebraic distance $`Om_{xy}`$
between point $`O`$ and point $`m_{xy}`$. <br>
\- The coordinate $`\varphi_M`$ of the point $`M`$ is the nonalgebraic angle
$`\widehat{xOm_{xy}}`$ between the axis $`Ox`$ and the half-line $`Om_ {xy}`$,
the direction of rotation being such that the trihedron $`(Ox,Om_{xy},Oz)`$ is a direct trihedron. <br>
\- The $`z_M`$ coordinate of the point $`M`$ is the algebraic distance $`\overline{Om_z}`$ 
between the point $`O`$ and the point $`m_z`$.

A same point $`M`$ located in $`z_M`$ on the axis $`Oz`$ can be represented by any triplet
$`(z_M, 0, \varphi)`$ where $`\varphi`$ can take all possible values. By convention,
the value $`\varphi`$ is set to 0, and the cylindrical coordinates of any point $`M`$ located
in $`z_M`$ on the $`Oz`$ axis will be $`(z_M, 0, 0)`$.

! and we continue on the sequence of course elements decided jointly:


* *CS320*

! *Note :* The first two cylindrical coordinates of a point $`M`$ are the polar coordinates
of the point $`m_{xy}`$ in the plane $`xOy`$ (plan $`z=0`$). They are also the polar 
coordinates of the poin $`M`$ in the plane $`z=z_M`$.

\- The coordinates **$`\rho`$ **et **$`z`$** are *lengths*, whose l'*S.I. unit* is the meter, of symbol *$`m`$*.<br>
\- The coordinate **$`\varphi`$** is an angle, whose l'*S.I. unit* is the radian, of symbol *$`rad`$*.

**Unités S.I. : $`\rho\;(m)`$ , $`\varphi\;(rad)`$ , $`z\;(m)`$**

--------------------

* *CS330*

\- [ES] Cualquier punto $`M`$ en el espacio, excepto el punto de origen $`O`$, se 
identifica de manera única por un único triplete compuesto por sus 3 coordenadas cilíndricas. <br>
\- [FR] Tout point $`M`$ de l'espace, excepté le point origine $`O`$,  est repéré de 
façon unique par un et un seul triplet constitué de ses 3 coordonnées cylindriques.<br>
\- [EN] Any point $`M`$ in space, except the origin point $`O`$, is identified 
in a unique way by one and only one triplet made up of its 3 cylindrical coordinates. <br>

\- [ES] En el punto de origen $`O`$ se le asignan las coordenadas cilíndricas $`(0,0,0)`$.
\- [FR] Au point origine $`O`$ est attribué les coordonnées cylindriques $`(0,0,0)`$.
\- [EN] At the origin point $`O`$ is assigned the cylindrical coordinates $`(0,0,0)`$.

\- Escribimos / on écrit / we write : $`M(\rho_M,\varphi_M,z_M)`$

\- Si el punto es cualquier punto, simplificamos / Si le point est un point quelconque, on simplifie / If the point is any point, we simplify :

$`M(\rho , \varphi , z)`$, **$`\mathbf{M(\rho , \varphi , z)}`$**

------------------

* *CS340*

\- **Todo el espacio** está cubierto por coordenadas cilíndricas que varían independientemente
en los dominios :
\- **Tout l'espace** est couvert par les coordonnées cylindriques variant indépendamment 
dans les domaines :
\- **All space** is covered by  the independently varying cylindrical coordinates
in the domains :

$`\rho\in\mathbb{R_+^{*}}=[0 ,+\infty[ `$  ,  
$`\varphi\in[0,2\pi[`$ et $`z\in\mathbb{R}=]-\infty ,+\infty\,[`$.

**$`\mathbf{\rho\in\mathbb{R_+^{*}}=[0 ,+\infty[}`$ , $`\mathbf{ \varphi\in[0,2\pi[ }`$ ,  $`\mathbf{ z\in\mathbb{R}=]-\infty ,+\infty[ } `$**


--------------

* *CS350*

! <details markdown=1>
! <summary>
! Notations on the sets of real numbers
! </summary>
! * the symbol $`\infty`$ denores infinity.
! * $`\mathbb{R}`$ : set of the real numbers :
! $`\mathbb{R}\; = \; \{x\in\mathbb{R}\}\;=\;]-\infty , +\infty\,[`$.
! * $`\mathbb{R}^{*}`$ : set of the non-zero real numbers : 
! $`\mathbb{R}^{*}\; = \; \{x\in\mathbb{R}\,|\,x\ne 0\}\; = \; ]-\infty , 0\,[ \;\cup\; ]\,0 , + \infty\,[`$.
! * $`\mathbb{R}_+`$ : set of the positive real numbers : 
! $`\mathbb{R}_+\; = \; \{x\in\mathbb{R}\,|\,x \ge 0\}\; = \; [\,0 , + \infty\,[`$.
! * $`\mathbb{R}_+`$ : set of the negative real numbers : 
! $`\mathbb{R}_+\; = \; \{x\in\mathbb{R}\,|\,x \ge 0\}\; = \; ]-\infty , 0\,]`$.
! * $`\mathbb{R}_+^{*}`$ : set of the non-zero positive real numbers : 
! $`\mathbb{R}_+^{*}\; = \; \{x\in\mathbb{R}\,|\,x \le 0\}\; = \; ]\,0 , + \infty\,[ `$.
! * $`\mathbb{R}_{-}^{*}`$ : set of the non-zero negative real numbers : 
! $`\mathbb{R}_{-}^{*}\; = \; \{x\in\mathbb{R}\,|\,x > 0\,]\;= \; ]-\infty , 0\,[ `$.
!
!    --------
! * {...} indicates a set of elements.
! * the list, the text or the logical expression in "..." specifies the elements of the set.
! * we can give a name to the set : example : A={...}.
! * the symbol " $`|`$ " means "such as". Example :<br>
!    $`\{x\in\mathbb{R} | x \lt 0\}`$ designates the set of the real numbers x, such as $`x\lt 0`$.
!
!   -------
!  The intervals, using examples: :
! * $` [2 , 3] `$ : range of real numbers between 2 and 3, 2 and 3 being included.
! * $` ]2 , 3[ `$ : range of real numbers between 2 and 3, 2 and 3 being excluded.
! * $` [2 , 3[ `$ : range of real numbers between 2 and 3, 2 being included and 3 excluded.
! * $` ]2 , 3 ]`$ : range of real numbers between 2 and 3, 2 being excluded and 3 included.
! * uses the mathematical notion of limit.
! * Infinity is always excluded, we can never reach it, it cannot be included :<br>
! $`]-\infty`$ and not $`\require{cancel}\xcancel{[-\infty}`$ , $`+\infty[`$ and not $`\require{cancel}\xcancel{+\infty]}`$
!
! </details>

<!--
Las coordenadas cilíndricas se escriben / les coordonnées cylindriques s'écrivent / The cylindrical coordinates write :

$`(\rho, \varphi, z)`$ , **$`\mathbf{(\rho, \varphi, z)}`$**

con / avec /with :

$`\rho\in [0;\infty[`$,  $`\varphi\in [0;2\pi[`$ et $`z \in [-\infty;\infty[`$ , 

**$`\mathbf{ \rho\in [0;\infty[}`$  ,  $`\mathbf{\varphi\in [0;2\pi[}`$  ,  $`\mathbf{z \in [-\infty;\infty[ }`$** 

Coordenadas cilíndricas de un punto $`M`$ /coordonnées cylindriques  d'un point $`M`$ / cylindrical  coordinates of a point $`M`$ :

$`(\rho_M, \varphi_M, z_M)`$,

Escribimos / on écrit / we write :

$`M(\rho_M, \varphi_M, z_M)`$

Si el punto es cualquier punto, simplificamos / Si le point est un point quelconque, on simplifie / If the point is any point, we simplify :

$`M(\rho, \varphi, z)`$ , **$`\mathbf{M(\rho, \varphi, z)}`$** -->


#### Cylindrical vector base and associated  ... ?

##### Variation of a coordinate and associated path length

* *CS360* 

[ES] Cuando solo la coordenada $`\rho`$ de un punto $`M(\rho, \varphi, z)`$ varía
continuamente entre los valores $`\rho`$ y $`\rho+\Delta \rho`$, el punto $`M`$ recorre un segmento
de longitud $`\Delta l_{\rho}=\Delta \rho`$. Cuando $`\Delta \rho`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_{\rho}`$ recorrida para el punto $`M`$ 
es :

[FR] Lorsque seule la coordonnées $`\rho`$ d'un point $`M(\rho, \varphi, z)`$ varie de façon 
continue entre les valeurs $`\rho`$ et $`\rho+\Delta \rho`$, le point $`M`$ parcourt un sègment
de droite de longueur $`\Delta l_{\rho}=\Delta \rho`$. Lorsque $`\Delta \rho`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\rho}`$ parcourue pour le point $`M`$ est :

[EN] When only the $`\rho`$ coordinate of a point $`M(\rho, \varphi, z)`$ varies
continuously between the values $`\rho`$ and $`\rho+\Delta \rho`$, the point $`M`$ covers
a line segment of length $`\Delta l_{\rho}=\Delta \rho`$. When $`\Delta \rho`$ tends
towards $`0`$, the infinitesimal length $`dl_{\rho}`$ covered by the point $`M`$ is :

$`\displaystyle d\rho=\lim_{\Delta \rho\rightarrow 0 \\ \Delta \rho>0} \Delta \rho`$
$`\quad\Longrightarrow\quad dl_{\rho}=d\rho`$, **$`\mathbf{dl_{\rho}=d\rho}`$**.

tambien / de même / similarly : $`dl_z=dz`$ , , **$`\mathbf{dl_z=dz}`$**.

[ES] Cuando solo la coordenada $`\varphi`$ de un punto $`M(\rho, \varphi, z)`$ varía
continuamente entre los valores $`\varphi`$ y $`\varphi +\Delta \varphi`$, el punto $`M`$ 
recorre un arco de circulo
de longitud $`\Delta l_{\varphi}=\rho\:\Delta \varphi`$. Cuando $`\Delta \varphi`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_{\varphi}`$ recorrida para el punto $`M`$ 
es :

[FR] Lorsque seule la coordonnées $`\varphi`$ d'un point $`M(\rho, \varphi, z)`$ varie de façon 
continue entre les valeurs $`\varphi`$ et $`\varphi +\Delta \varphi`$, le point $`M`$ parcourt un 
arc de cercle de longueur $`\Delta l_{\varphi}=\rho\;\Delta \varphi`$. Lorsque $`\Delta \varphi`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\varphi}`$ parcourue pour le point $`M`$ est :

[EN] When only the $`\varphi`$ coordinate of a point $`M(\rho, \varphi, z)`$ varies
continuously between the values $`\varphi`$ and $`\varphi+\Delta \varphi`$, the point $`M`$ covers
an arc of circle of length $`\Delta l_{\varphi}=\rho\,\Delta \varphi`$. When $`\Delta \varphi`$ tends
towards $`0`$, the infinitesimal length $`dl_{\varphi}`$ covered by the point $`M`$ is :

$`\displaystyle d\varphi=\lim_{\Delta \varphi\rightarrow 0 \\ \Delta \varphi>0} \Delta\varphi`$
$`\quad\Longrightarrow\quad dl_{\phi}=\rho\,d\varphi`$ , , **$`\mathbf{dl_{\varphi}=\rho\,d\varphi}`$**.

------------

* *CS370* : 

[ES] elemento escalar de línea :<br>
[FR] élément scalaire de longueur :<br>
[EN] scalar line element :

<br>$`dl=\sqrt{d\rho^2+ (\rho\,d\varphi)^2+dz^2}`$ , **$`\mathbf{dl=\sqrt{d\rho^2+ (\rho\,d\varphi)^2+dz^2}}`$**

##### Cylindrical vector base and associated  ... ?

* *CS380*

[ES] Cuando solo la coordenada $`\rho`$ de un punto $`M(\rho, \varphi, z)`$ aumenta
infinitesimalmente entre los valores $`\rho`$ y $`\rho+d\rho`$ ($`d\rho>0`$)
para llegar al punto $`M'(\rho+\Delta\rho, \varphi, z)`$, el vector de desplazamiento
$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}`$ del punto $`M`$ es el vector 
tangente a la trayectoria en el punto $`M`$, dirigido en la dirección del movimiento,
que se escribe :

[FR] Lorsque seule la coordonnées $`\rho`$ d'un point $`M(\rho, \varphi, z)`$ s'accroît de façon 
infinitésimale entre les valeurs $`\rho`$ et $`\rho+d\rho`$ ($`d\rho>0`$)
pour atteindre le point $`M'(\rho+\Delta\rho, \varphi, z)`$, le vecteur déplacement 
$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}`$ du point $`M`$ est le vecteur
tangent à la trajectoire au point $`M`$, dirigé dans le sens du mouvement, qui s'écrit :

[EN] When only the $`\rho`$ coordinate of a point $`M(x,y,z)`$ increases infinitesimally between
the values $`\rho`$ and $`\rho+d\rho`$ ($`d\rho>0`$) to reach the point
$`M'(\rho+\Delta\rho, \varphi, z)`$, the displacement vector
$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}`$ of the point $`M`$ is the 
tangent vector to the trajectory at point $`M`$ oriented in the direction of the movement. It writes :

$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}=\dfrac{\partial \overrightarrow{OM}}{\partial \rho}\cdot d\rho`$

[ES] El vector unitario tangente a la trayectoria  $`\overrightarrow{e_{\rho}}`$ (que indica la dirección y el sentido
de desplazamiento del punto $`M`$ cuando solo aumenta infinitesimalmente la coordenada $`\rho`$ se escribe:

[FR] Le vecteur unitaire tangent à la trajectoire $`\overrightarrow{e_{\rho}}`$ (qui indique la direction et le sens 
de déplacement du point $`M`$ lorsque seule la coordonnée $`\rho`$ croît de façon infinitésimale) s'écrit :

[EN] The unit vector tangent to the trajectory  $`\overrightarrow{e_{\rho}}`$  (which indicates the direction of displacement 
of the point $`M`$ when only the coordinate $`\rho`$ increases in an infinitesimal way) writes :

$`\overrightarrow{e_{\rho}}=\dfrac{\partial\overrightarrow{OM}_{\rho}}{||\partial\overrightarrow{OM}_{\rho}||}`$

tambien / de même / similarly :

$`d\overrightarrow{OM}_{\varphi}=\dfrac{\partial \overrightarrow{OM}}{\partial \varphi}\cdot d\varphi`$,
$`\quad\overrightarrow{e_{\varphi}}=\dfrac{\partial\overrightarrow{OM}_{\varphi}}{||\partial\overrightarrow{OM}_{\varphi}||}`$<br>
$`d\overrightarrow{OM}_z=\dfrac{\partial \overrightarrow{OM}}{\partial z}\cdot dz`$,
$`\quad\overrightarrow{e_z}=\dfrac{\partial\overrightarrow{OM}_z}{||\partial\overrightarrow{OM}_z||}`$

--------------------

* *CS390*

[ES] La norma del vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
es el elemento escalar de linea $`dl_{\rho}`$, entonces el vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
est l'élément de longueur $`dl_{\rho}`$, donc le vecteur $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
is the scalar line element $`dl_{\rho}`$, so the vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ writes :

$`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}=dl_{\rho}\;\overrightarrow{e_{\rho}}
=d\rho\;\overrightarrow{e_{\rho}}`$ , **$`\mathbf{\overrightarrow{dl_{\rho}}=d\rho\;\overrightarrow{e_{\rho}}}`$**

tambien / de même / similarly :

$`d\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$ ,
**$`\mathbf{\overrightarrow{dl_z}=dz\;\overrightarrow{e_z}}`$**

[ES] La norma del vector $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
es el elemento escalar de linea $`dl_{\varphi}`$, entonces el vector $`\overrightarrow{e_{\varphi}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
est l'élément de longueur $`dl_{\varphi}`$, donc le vecteur $`\overrightarrow{e_{\varphi}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{varphi}=\overrightarrow{dl_{varphi}}`$ 
is the scalar line element $`dl_{\varphi}`$, so the vector $`\overrightarrow{e_{\varphi}}`$ writes :

$`\partial\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}=dl_{\varphi}\;\overrightarrow{e_{\varphi}}
=\rho\,d\varphi\;\overrightarrow{e_{\varphi}}`$ , 
**$`\mathbf{\overrightarrow{dl_{\varphi}}=\rho\,d\varphi\;\overrightarrow{e_{\varphi}}}`$**

-------------------------

* *CS400*

[ES] El **elemento vectorial de línea** o ?? $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en coordenadas cilíndricas es
el vector de desplazamiento del punto $`M(\rho, \varphi, z)`$ al punto $`M'(\rho+ d\rho, \varphi + d\varphi, z+ dz)`$ cuando 
las coordenadas varían infinitesimalmente de $`d\rho`$, $`d\varphi`$ y $`dz`$, y se escribe :

[FR] L'**élément vectoriel d'arc** ou vecteur déplacement élémentaire $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en 
coordonnées cylindriques est le vecteur déplacement du point $`M(\rho, \varphi, z)`$ au point
$`M'(\rho+ d\rho, \varphi + d\varphi, z+ dz)`$ quand les coordonnées varient infinitésimalement des quantités
$`d\rho`$, $`d\varphi`$ et $`dz`$, et il s'écrit :

[EN] The **vector line element** or vector path element $`\overrightarrow{dOM}=\overrightarrow{dl}`$ 
in Cylindrical coordinates is the displacement vector from point $`M(\rho, \varphi, z)`$ to point 
$`M'(\rho+ d\rho, \varphi + d\varphi, z+ dz)`$ when the coordinates vary infinitesimally in quantities 
$`d\rho`$, $`d\varphi`$ and $`dz`$,
and it writes :

$`\overrightarrow{MM'}=d\overrightarrow{OM}=\overrightarrow{dr}=\overrightarrow{dl}`$
$`=d\overrightarrow{OM}_{\rho}+d\overrightarrow{OM}_{\varphi}+d\overrightarrow{OM}_z`$
$`=\overrightarrow{dl_{\rho}}+\overrightarrow{dl_{\varphi}}+\overrightarrow{dl_z}`$
$`=dl_{\rho}\;\overrightarrow{e_{\rho}}+dl_{\varphi}\;\overrightarrow{e_{\varphi}}+dl_z\;\overrightarrow{e_z}`$
$`=d\rho\;\overrightarrow{e_x}+\rho\;d\varphi\;\overrightarrow{e_y}+dz\;\overrightarrow{e_z}`$

**$`\mathbf{d\overrightarrow{OM}=\overrightarrow{dl}}`$**
**$`\mathbf{=dl_{\rho}\;\overrightarrow{e_{\rho}}+dl_{\varphi}\;\overrightarrow{e_{\varphi}}+dl_z\;\overrightarrow{e_z}}`$**
**$`\mathbf{=d\rho\;\overrightarrow{e_{\rho}}+\rho\;dl_{\varphi}\;\overrightarrow{e_{\varphi}}+dz\;\overrightarrow{e_z}}`$**

[ES] y su norma es el elemento scalar de linea :<br>
[FR] et sa norme el l'élément de longueur :<br>
[EN] y its norm (or length) is thescalar line element :

$`||\overrightarrow{dl}||=\sqrt{dl_x^2+dl_y^2+dl_z^2}=\sqrt{dx^2+dy^2+dz^2}`$

$`||\overrightarrow{dl}||=\sqrt{\overrightarrow{dl}\cdot\overrightarrow{dl}}`$
$`=\left[(dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\cdot
(dl_x\;\overrightarrow{e_x}\right.`$
$`\left.+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\right]^{1/2}`$
$`=\left[(dl_x)^2\;(\overrightarrow{e_x}\cdot\overrightarrow{e_x})\right.`$
$`+(dl_y)^2\;(\overrightarrow{e_y}\cdot\overrightarrow{e_y})`$
$`+(dl_z)^2\;(\overrightarrow{e_z}\cdot\overrightarrow{e_z})`$
$`+(2\,dl_x\,dl_y)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_y})`$
$`+(2\,dl_x\,dl_z)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_z})`$
$`\left.+(2\,dl_y\,dl_z)\,(\overrightarrow{e_y}\cdot\overrightarrow{e_z})\right]^{1/2}`$
$`=\sqrt{(dl_x)^2+(dl_y)^2+(dl_z)^2}`$
$`=\sqrt{dx^2+dy^2+dz^2}=dl`$

-------------------------------

* *CS410*
 
[ES] Los vectores $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
forman una **base ortonormal** del espacio. La base
$`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ 
es la base asociada a las coordenadas cilíndricas. En coordenadas cilíndricas, los vectores
de base asociadas cambian de direcciónes cuando el punto $`M`$ se mueve.

[FR] Les vecteurs $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
forment une **base orthonormée** de l'espace. C'est la base associée aux coordonnées cylindriques.
En coordonnées cylindriques, les vecteurs de base associés 
changent de direction lorsque le point $`M`$ se déplace.

[EN] The vectors $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
form an **orthonormal basis** of space. It is the base associated with cylindrical coordinates.
In cylindrical coordinates, the base vectors change of direction when the point $`M`$ moves.

$`||\overrightarrow{e_{\rho}}||=||\overrightarrow{e_{\varphi}}||=||\overrightarrow{e_z}||=1`$<br>
$`\overrightarrow{e_{\rho}}\perp\overrightarrow{e_{\varphi}}\quad,\quad\overrightarrow{e_{\varphi}}\perp\overrightarrow{e_z}\quad,\quad\overrightarrow{e_{\rho}}\perp\overrightarrow{e_z}`$

$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ base cartesiana *directa* $`\quad\Longleftrightarrow\quad (\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ base cilíndrica asociada *directa*.
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ base cartésienne *directe* $`\quad\Longleftrightarrow\quad (\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ base cylindrique associée *directe*.
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ *direct* Cartesian base $`\quad\Longleftrightarrow\quad (\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ *direct* associated cylindrical base.

$`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ 
base ortogonal dependiente de la posición de $`M`$ / base orthogonale dépendante
de la position de $`M`$ / orthogonal basis dependent of the position of $`M`$.

##### Vecteur déplacement élémentaire

* *CS420*

$`\overrightarrow{OM}=\overrightarrow{OM}(t)\quad\Longrightarrow\quad\left\{ \begin{array}{l}
\overrightarrow{e_{\rho}} = \overrightarrow{e_{\rho}}(t) \\
\overrightarrow{e_{\varphi}}  = \overrightarrow{e_{\varphi}}(t) \\
\overrightarrow{e_z}  = \overrightarrow{cst} \\
\end{array} \right.`$

-----------------------

* *CS430*

Método 1 para el cálculo de / Méthode 1 pour le calcul de / Method 1 for the calculation of :<br>
$`\dfrac{d e_r}{dt}`$ , $`\dfrac{d e_{\varphi}}{dt}`$. 

$`\overrightarrow{e_z}=\overrightarrow{cst}\Longrightarrow\dfrac{d e_z}{dt}=0`$ 


$`\overrightarrow{e_\rho}(t)=cos\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;sin\,\varphi(t)\;\overrightarrow{e_y}`$<br>
<br>$`\overrightarrow{e_{\varphi}}(t)=- sin\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;cos\,\varphi(t)\;\overrightarrow{e_y}`$

en la base cartesiana / dans la base cartésienne / in the Cartesian base
$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ :

$`\overrightarrow{e_{\rho}}(t)=
\left| \begin{array}{l}
cos\,\varphi(t) \\
sin\,\varphi(t) \\
0 \\
\end{array} \right.\quad`$ , 
$`\quad\overrightarrow{e_{\varphi}}(t)=
\left|\begin{array}{l}
-\,sin\,\varphi(t) \\
cos\,\varphi(t) \\
0 \\
\end{array}\right.`$ 

[ES] ? En el marco de referencia $`\mathcal{R}(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ del observador, es decir cuando la origen del espacio $`O`$ es fija y los tres vectores base verifican

[FR] Dans le référentiel $`\mathcal{R}(O,\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ de l'observateur, c'est à dire dans le référentiel où le repère cartésien $`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ est fixe, donc tel que l'origine $`O`$ est fixe et les trois vecteurs de base vérifient 

[EN] In the reference frame $`\mathcal{R}(O,\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ of the observer, i.e.when the origin $`O`$ is fixed and the three base vectors satisfy 

$`\dfrac{d\overrightarrow{e_x}}{dt}=\dfrac{d\overrightarrow{e_y}}{dt}=\dfrac{d\overrightarrow{e_z}}{dt}=0`$ :

recordando / en se rappelant / reminding : $`(fg)'=f'g+fg'`$  

$`\dfrac{d\overrightarrow{e_{\rho}}}{dt}=
\left| \begin{array}{l}
cos\,\varphi(t) \,]\\
sin\,\varphi(t)\, ] \\
0 \\
\end{array} \right.\quad`$
$`\quad =
\left| \begin{array}{l}
\dfrac{d\,cos \,\varphi}{dt} \\
\\
\dfrac{d\,sin\,\varphi}{dt} \\
\\
\dfrac{d\,0}{dt} \\
\end{array} \right.\quad`$

y recordando / et en se rappelant / and reminding : $`(f \circ g)'=(f' \circ g)\,g'`$ , 

$`\dfrac{d\overrightarrow{e_{\rho}}}{dt}=
\left| \begin{array}{l}
-\;sin\,\varphi  \cdot \dfrac{d\varphi}{dt} \\
\\
cos\,\varphi \cdot \dfrac{d\varphi}{dt}\\
\\
0 \\
\end{array} \right.\quad`$
$`=\dfrac{d\varphi}{dt}\;\overrightarrow{e_{\varphi}}`$

**$`\mathbf{\dfrac{d\overrightarrow{e_{\rho}}}{dt}=\dfrac{d\varphi}{dt}\cdot \overrightarrow{e_{\varphi}}}`$**

tambien / de même / similarly :

$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=
\left| \begin{array}{l}
\dfrac{d\,[-\,sin\,\varphi(t)]}{dt} \\
\\
\dfrac{d\cos\,\varphi(t)}{dt} \\
\\
\dfrac{d\;0}{dt} \\
\end{array} \right.\quad`$
$`\quad=
\left| \begin{array}{l}
-\,cos\,\varphi(t)\cdot\dfrac{d\varphi}{dt} \\
-\,sin\,\varphi(t)\cdot\dfrac{d\varphi}{dt} \\
0 \\
\end{array} \right.\quad`$
$`\quad\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\rho}}`$

**$`\mathbf{\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt}}\cdot\overrightarrow{e_{\rho}}`$**<br>

--------------------

* *CS440*

Método 2 para el cálculo de / Méthode 2 pour le calcul de / Method 2 for the calculation of :<br>
$`\dfrac{d e_{\rho}}{dt}`$ , $`\dfrac{d e_{\varphi}}{dt}`$ 

$`\overrightarrow{e_{\rho}}=cos\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;sin\,\varphi\;\overrightarrow{e_y}`$$`\;+\;0\;\overrightarrow{e_z}`$
$`=\overrightarrow{e_{\rho}}(\varphi)`$<br>
$`\overrightarrow{e_{\varphi}}=- sin\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;cos\,\varphi\;\overrightarrow{e_y}\;+\;0\;\overrightarrow{e_z}`$
$`=\overrightarrow{e_{\varphi}}=\overrightarrow{e_{\varphi}}(\varphi)`$

$`\overrightarrow{e_{\rho}}=\overrightarrow{e_{\rho}}(\varphi)`$ et 
$`\overrightarrow{e_{\varphi}}=\overrightarrow{e_{\varphi}}(\varphi)`$
$`\quad\Longrightarrow\quad`$ pour une variation  infinitésimale $`d\varphi`$, $`\overrightarrow{e_{\rho}}`$ et $`\overrightarrow{e_{\varphi}}`$ varient de :

$`d\overrightarrow{e_{\rho}}=\dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}\cdot d\varphi`$ <br>
$`d\overrightarrow{e_{\varphi}}=\dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}\cdot d\varphi`$

con / avec / with

$`\dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}=
\left|\begin{array}{l}
\dfrac{d\;cos\,\varphi}{d\varphi} \\
\\
\dfrac{d\;sin\,\varphi}{d\varphi} \\ 
\\
\dfrac{d\;0}{d\varphi} \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,sin\,\varphi \\
cos\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=\overrightarrow{e_{\varphi}}`$

$`\dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}=
\left|\begin{array}{l}
\dfrac{d\;(-\,sin\,\varphi}{d\varphi} \\
\\
\dfrac{d\;cos\,\varphi}{d\varphi} \\ 
\\
\dfrac{d\;0}{d\varphi} \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,cos\,\varphi \\
-\,sin\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=-\,\overrightarrow{e_{\rho}}`$

$`\varphi=\varphi(t)\quad\Longrightarrow\quad`$ pour unè variation infinitésimale  $`dt`$ , $`\varphi`$ varie de :

$`d\varphi=\dfrac{d\varphi}{dt}\cdot dt`$

$`\Longrightarrow\quad`$ pour une variation infinitésimale  $`dt`$, $`\overrightarrow{e_{\rho}}`$ et $`\overrightarrow{e_{\varphi}}`$ varient de :

$`d\overrightarrow{e_{\rho}}\quad=\dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$$\quad=\dfrac{d\varphi}{dt}\cdot dt \cdot \dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}\quad=\dfrac{d\varphi}{dt}\cdot dt \cdot
\overrightarrow{e_{\varphi}}`$

$`d\overrightarrow{e_{\varphi}}\quad=\dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$
$\quad=\dfrac{d\varphi}{dt}\cdot dt \cdot \dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}\quad=-\,\dfrac{d\varphi}{dt}\cdot dt \cdot
\overrightarrow{e_{\rho}}`$

$`\dfrac{d\overrightarrow{e_{\rho}}}{dt}=\dfrac{d\varphi}{dt} \cdot
\overrightarrow{e_{\varphi}}`$

$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt} \cdot
\overrightarrow{e_{\rho}}`$

$`\dfrac{d\overrightarrow{e_z}}{dt}=\overrightarrow{0}`$

---------------------

* *CS450* 

[ES] En la mecánica clásica, las interacciones entre cuerpos materiales se traducen en términos de fuerza $`\vec{F}`$ y conducen a una aceleración $`\vec{a}`$ de cada cuerpo en interacción proporcional a la inversa de su masa de inercia $`m_I`$ : $`\vec{a}=\dfrac{\vec{F}}{m_I}`$ (o $`\vec{F}=m_I\;\vec{a}`$ , ver capítulo mecánico). Como el vector de aceleración es la segunda derivada temporal del vector de posición, es posible que necesitemos conocer la segunda derivada  temporal de los vectores base para el estudio del movimiento.

[FR] En mécanique classique, les interactions entre les corps matériels se traduisent en terme de force $`\vec{F}`$, et conduisent à une accélération $`\vec{a}`$ de chaque corps en interaction proportionnelle à l'inverse de sa masse d'inertie  $`m_I`$ : $`\vec{a}=\dfrac{\vec{F}}{m_I}`$ (ou $`\vec{F}=m_I\;\vec{a}`$ , voir chapitre mécanique). Dans l'étude du mouvement, nous aurons besoin d'étendre l'étude à la dérivée seconde des vecteurs de base. Comme le vecteur accélaration est la dérivée seconde du vecteur position, nous pourrions avoir besoin de connaître la dérivée seconde par rapport au temps des vecteurs de base pour l'étude du mouvement.

[EN] In classical mechanics, the interactions between material bodies are expressed in terms of force $`\vec{F}`$ , and lead to an acceleration of each interacting body proportional to the inverse of its mass of inertia  $`m_I`$ : $`\vec{a}=\dfrac{\vec{F}}{m_I}`$ (or $`\vec{F}=m_I\;\vec{a}`$ , see mechanical chapter). As the acceleration vector is the second time derivative of the position vector, when studying the motion we might need to know the second time derivative of the base vectors.

$`\dfrac{d^2\,\overrightarrow{e_{\rho}}}{dt^2}\quad=\dfrac{d}{dt}\left(\dfrac{d\,\overrightarrow{e_{\rho}}}{dt}\right)\quad=\dfrac{d}{dt}\left(\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\varphi}}\right)`$
$`\quad=\dfrac{d}{dt}\left(\dfrac{d\,\varphi}{dt}\right)\cdot\overrightarrow{e_{\varphi}}\,
+\,\dfrac{d\varphi}{dt}\cdot\dfrac{d}{dt}\left(\overrightarrow{e_{\varphi}}\right)`$

$`\quad=\dfrac{d^2\varphi}{dt^2}\cdot\overrightarrow{e_{\varphi}}\,+\,\dfrac{d\varphi}{dt}\cdot
\dfrac{d\,\overrightarrow{e_{\varphi}}}{dt}`$$`\quad=\dfrac{d^2\varphi}{dt^2}\cdot\overrightarrow{e_{\varphi}}\,+\,\dfrac{d\varphi}{dt}\cdot \left( -\,\dfrac{d\varphi}{dt} \cdot e_{\rho}\right) `$
$`\quad=\dfrac{d^2\,\varphi}{dt^2}\cdot \overrightarrow{e_{\varphi}} \,-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\rho}`$

**$`\mathbf{\dfrac{d^2\,\overrightarrow{e_{\rho}}}{dt^2}=-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\rho}\,+\,\dfrac{d^2\varphi}{dt^2}\cdot \overrightarrow{e_{\varphi}}}`$**

[ES] ¡Atención! No confunda $`\dfrac{d^2\varphi}{dt^2}`$ y $`\left( \dfrac{d\varphi}{dt} \right)^2 `$ (dar un ejemplo).

[FR] Attention ! Ne pas confondre $`\dfrac{d^2\varphi}{dt^2}`$ et $`\left( \dfrac{d\varphi}{dt} \right)^2 `$ (donner un exemple).

[EN] Look out ! Do not confuse $`\dfrac{d^2\varphi}{dt^2}`$ and $`\left( \dfrac{d\varphi}{dt} \right)^2 `$ (give an example).


$`\dfrac{d^2\,\overrightarrow{e_{\varphi}}}{dt^2}\quad=\dfrac{d}{dt}\left(\dfrac{d\,\overrightarrow{e_{\varphi}}}{dt}\right)\quad=\dfrac{d}{dt}\left(-\,\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\rho}}\right)`$
$`\quad=-\,\dfrac{d}{dt} \left( \dfrac{d\varphi}{dt} \right) \cdot \overrightarrow{e_{\rho}} \,- \,\dfrac{d\varphi}{dt} \cdot \dfrac{d}{dt} \left( \overrightarrow{e_{\rho}} \right)`$
$`\quad=-\,\dfrac{d^2\varphi}{dt^2} \cdot \overrightarrow{e_{\rho}} \,-\, \dfrac{d\varphi}{dt} \cdot
\dfrac{d\,\overrightarrow{e_{\rho}}}{dt}`$
$`\quad=-\,\dfrac{d^2\varphi}{dt^2} \cdot \overrightarrow{e_{\rho}}\,-\,\dfrac{d\varphi}{dt} \cdot \left( \dfrac{d\varphi}{dt} \cdot e_{\varphi} \right) `$
$`\quad=-\,\dfrac{d^2\,\varphi}{dt^2}\cdot \overrightarrow{e_{\rho}} \,-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\varphi}`$

**$`\mathbf{\dfrac{d^2\,\overrightarrow{e_{\varphi}}}{dt^2}
=-\,\dfrac{d^2\,\varphi}{dt^2}\cdot \overrightarrow{e_{\rho}} \,-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\varphi}}`$**


$`\dfrac{d^2\,\overrightarrow{e_z}}{dt^2} \quad = \dfrac{d}{dt} \left( \dfrac{d\,\overrightarrow{e_z}}{dt} \right) \quad = \dfrac{d\,\overrightarrow{0}}{dt} \quad = \overrightarrow{0}`$

**$`\mathbf{\dfrac{d^2\,\overrightarrow{e_z}}{dt^2}=\overrightarrow{0}}`$**

---------------------

* *CS460*

[ES] La norma del vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
es el elemento escalar de linea $`dl_{\rho}`$, entonces el vector $`\overrightarrow{e_{\rho}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
est l'élément de longueur $`dl_{\rho}`$, donc le vecteur $`\overrightarrow{e_{\rho}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
is the scalar line element $`dl_{\rho}`$, so the vector $`\overrightarrow{e_{\rho}}`$ writes :

$`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}=dl_{\rho}\;\overrightarrow{e_{\rho}}
=\rho\;\overrightarrow{e_{\rho}}`$

tambien / de même / similarly :

$`d\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$

[ES] La norma del vector $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
es el elemento escalar de linea $`dl_{\varphi}`$, entonces el vector $`\overrightarrow{e_{\varphi}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
est l'élément de longueur $`dl_{\varphi}`$, donc le vecteur $`\overrightarrow{e_{\varphi}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{varphi}=\overrightarrow{dl_{varphi}}`$ 
is the scalar line element $`dl_{\varphi}`$, so the vector $`\overrightarrow{e_{\varphi}}`$ writes :

$`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}=dl_{\varphi}\;\overrightarrow{e_{\varphi}}
=\rho\,d\varphi\;\overrightarrow{e_{\varphi}}`$

------------------

* *CS470*

[ES] Los 3 vectores $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}\quad`$,
$`\quad d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}\quad`$ y
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ son 2 a 2 ortogonales.

[FR] Les 3 vecteurs $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}\quad`$,
$`\quad d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}\quad`$ et
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ sont orthogonaux 2 à 2.

[EN] The 3 vectors $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}\quad`$,
$`\quad d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}\quad`$ and
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ are 2 to 2 orthogonal.

$`\Longrightarrow`$ :

[ES] ¡Atención! El área de un elemento de superficie construido por 2 de estos vectores 
no es el producto de sus normas. Tambien el volumen definido 
por estos 3 vectores no será simplemente el producto de sus normas.

[FR] Attention ! L'aire d'un élément de surface construit par 2 de ces vecteurs n'est'
pas le produit de leurs normes. Et le volume définit par ces 3 vecteurs 
n'est le produit de leurs normes.

[EN] Warning! The area of a surface element constructed by 2 of these vectors is not 
the product of their norms. And the volume defined by these 3 vectors is not the product 
of their norms.

--------------------------

* *CS480*

http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-06.

[ES] Según la dirección elegida, los **elementos escalares de superficie $`dA`$** en coordenadas cartesianas son :<br>
[FR] Selon la direction choisie, les **éléments scalaires de surface $`dA`$** en coordonnées cartésiennes sont :<br>
[EN] According to the chosen direction, the **scalar surface elements $`dA`$** in Cartesian coordinates are :

$`dA_{\rho\varphi}=dl_{\rho}\;dl\varphi=d\rho\cdot\rho\;d\varphi\quad`$, $`\quad dA_{\rho z}=dl_{\rho}\;dlz=d\rho\;dz\quad`$, $`\quad dA_{\varphi z}=dl_{\varphi}\;dlz=\rho\,d\varphi\;dz`$

http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-07.<br>
[ES] y los **elementos vectoriales de superficie $`\overrightarrow{dA}`$** correspondiente son :<br>
[FR] et les **éléments vectoriels de surface $`\overrightarrow{dA}`$** correspondants sont :<br>
[EN] and the corresponding **vector surface elements $`\overrightarrow{dA}`$** are :


$`d\overrightarrow{A_{\rho\varphi}}=d\overrightarrow{OM}_{\rho}\land d\overrightarrow{OM}_{\varphi}`$
$`=\overrightarrow{dl_{\rho}}\land\overrightarrow{dl_{\varphi}}`$
$`= (dl_{\rho}\;\overrightarrow{e_{\rho}})\land(dl_{\varphi}\;\overrightarrow{e_{\varphi}})`$
$`=dl_{\rho}\;dl_{\varphi}\;(\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}})`$
$`=d\rho\;\rho\,d{\varphi}\;(\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}})`$<br>
<br>$`d\overrightarrow{A_{\varphi z}}=d\overrightarrow{OM}_{\varphi}\land d\overrightarrow{OM}_z`$
$`=\overrightarrow{dl_{\varphi}}\land\overrightarrow{dl_z}`$
$`= (dl_{\varphi}\;\overrightarrow{e_{\varphi}})\land (dl_z\;\overrightarrow{e_z})`$
$`=dl_{\varphi}\;dl_z\;(\overrightarrow{e_{\varphi}}\land\overrightarrow{e_z})`$
$`=\rho\,d\varphi\;dz\;(\overrightarrow{e_{\varphi}}\land\overrightarrow{e_z})`$<br>
<br>$`d\overrightarrow{A_{z \rho}}=d\overrightarrow{OM}_z\land d\overrightarrow{OM}_{\rho}`$
$`=\overrightarrow{dl_z}\land\overrightarrow{dl_{\rho}}`$
$`=(dl_z\;\overrightarrow{e_z})\land(dl_{\rho}\;\overrightarrow{e_{\rho}})`$
$`=dl_z\;dl_{\rho}\;(\overrightarrow{e_z}\land\overrightarrow{e_{\rho}})`$.
$`=dz\;d\rho\;(\overrightarrow{e_z}\land\overrightarrow{e_{\rho}})`$.

[ES] :

[FR] Base cartésien de référence $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ directe  $`\Longrightarrow`$  base cylindrique $`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ directe $`\Longrightarrow`$ :

[EN] : 

$`\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}}=+\,\overrightarrow{e_z}`$
$`\Longrightarrow d\overrightarrow{A_{\rho\varphi}}=+\,d\rho\;\rho\,d{\varphi}\,\overrightarrow{e_z})`$.<br>
$`\overrightarrow{e_{\rho}}\land\overrightarrow{e_z}=-\,\overrightarrow{e_{\varphi}}`$
$`\Longrightarrow d\overrightarrow{A_{\rho\varphi}}=+\,d\rho\;\rho\,d{\varphi}\,\overrightarrow{e_z})`$.<br>


[ES] :<br>
[FR] Base cartésien de référence $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ indirecte  $`\Longrightarrow`$  base cylindrique $`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ indirecte $`\Longrightarrow`$ :<br>
[EN] : 

$`\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}}=-\,\overrightarrow{e_z}`$.
$`\Longrightarrow d\overrightarrow{A_{\rho\varphi}}=-\,d\rho\;\rho\,d{\varphi}\,\overrightarrow{e_z})`$.

