---
title: Las ondas en física
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns-es
        name: PANORAMA-234: Las ondas, una visión general
        order: 1
---

*Curso en construcción*, **no validado**.   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-ES_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etapa 2 : Estructuración</summary>  
1. Lluvia de ideas
2. Estructuración
3. Escribiendo : 1/3
4. Escribiendo : 2/3
5. Escribiendo : 3/3
6. Revisión 
7. Probado con estudiantes.
8. Validado, aún incompleto
9. Validado, con base suficiente
10. Validado, operativo, en constante mejora.
</details>


##### Caminata en colinas

---------------------------

### ONDAS

### **Las ondas** *en física*

<br>
[versión multilingüe : EN , FR , ES](https://m3p2.com/polyglot/temporary-m3p2/waves/n2/waves-introduction/waves-in-physics)
<br>

<!--
# <p style="font-size:70%;text-align: center;">Les ondes en physique</p>
<p style="font-size:75%;text-align: center;">Naissance du concept d'onde</p>
-->

#### Nacimiento de los conceptos de campo y onda

 * Cada uno de nosotros ha lanzado un balón o arrojado una piedra. En cada instante, estos objetos ocupan una posición bien definida en el espacio y siguen una trayectoria que nuestros ojos pueden seguir. Esta experiencia sensible es la base de nuestro concepto intuitivo de **cuerpos materiales**: objetos bien definidos, de extensión limitada en el espacio, que se desplazan según las leyes de la física.
<br>
Pero nuestra experiencia sensible no se limita a estos objetos localizados. Cada uno de nosotros ha **lanzado piedras al agua** o observado gotas de lluvia caer sobre la superficie tranquila de un estanque.
<br>
Sus impactos perturban la superficie del agua, creando **pequeñas ondulaciones circulares** que
*se propagan, se refuerzan o se debilitan* cuando se cruzan, y
*rodean los obstáculos* que encuentran en su camino.

* Estas ondulaciones se traducen, *en cada instante y en cada punto* de la superficie, en una
**variación de la altura del agua** bajo la superficie.
<br>
El físico habla de **campo** para describir una
*magnitud física definida en cada punto del espacio y en cada instante*. Aquí la
magnitud física es la altura del agua, y el espacio es la superficie bidimensional
del estanque.
<br>

* Cuando el *estanque está en calma*, cuando su superficie está en **equilibrio y estable**, la *altura*
del agua bajo la superficie **varía de un punto a otro**, pero esta altura en cada punto
**no varía con el tiempo**.
<br>
El físico dice que el *campo* de la altura del agua es **estacionario**.
<br>

* Las ondulaciones se traducen en una variación de la altura del agua con respecto
a la superficie del estanque en reposo. Estas *ondulaciones* están en la
*base de nuestro concepto intuitivo de ondas*: **perturbaciones de un campo** que 
**se propagan**,
interfieren y son difractadas.
<br>
Para el físico, la **onda** aparece así como la *parte no estacionaria de un campo*,
es decir, la desviación temporal del valor de equilibrio del campo en reposo.
<br>

* Las *ondulaciones* resultan del **desplazamiento** de moléculas de agua, es decir, 
 **de materia**.
<br>
Cuando una onda caracteriza la *perturbación de un medio material*, el físico habla
de **onda mecánica**.
<br>

* Las **propiedades de las ondas mecánicas**:
   *  *Propagación*
   *  *Interferencias*
   *  *Difracción* por un obstáculo.
   *  *Reflexión y transmisión* en la interfaz entre dos medios diferentes.
   *  *Transporte de energía*, pero *no de materia* a grandes distancias.
   **se encuentran también en fenómenos más sutiles** observados en la naturaleza 
   y luego descritos matemáticamente, o primero previstos por la teoría física antes 
   de ser confirmados por la experimentación.   **se encuentran en fenómenos más sutiles** 
   observados en la naturaleza y luego descritos matemáticamente, o primero previstos 
   por la teoría física antes de ser confirmados por la experimentación.

<br>

![](waves-interferences-diffraction-2_L1200.jpg)
_Representación de los fenómenos de interferencia y difracción._

<br>

#### Ondas de diferentes tipos

#### Ondas de diferentes tipos

* Hoy en día, **cuatro tipos de ondas** han sido observados, desde las *ondas mecánicas*
hasta las ondas *electromagnéticas*, luego las ondas *gravitacionales* y las ondas *cuánticas*.
En orden, estas ondas **corresponden a niveles de realidad cada vez más sutiles**,
relacionados con la velocidad de la luz c, y modelados por teorías físicas con
matemáticas cada vez más abstractas.

<br>

![](waves-introduction-n2-ES_L1200.jpg)
_Cuatro tipos de ondas en física, para describir niveles de realidad cada vez más sutiles y abstractos._

---------

##### **Las ondas mecánicas** *($`v \lt c`$)*

* Son las *más conocidas e intuitivas*, y a menudo son muy
*fáciles de observar* o sentir. Corresponden a una **perturbación de un campo material**:
   * *ondulaciones* en la superficie del agua (campo de altura).
   * *sonidos* que se propagan en el aire (campo de presión).
   * *ondas sísmicas* en el suelo (campo de desplazamiento en la tierra).
   * *ondulaciones* de un resorte o de una cuerda de un instrumento musical (campo de desplazamiento).

* Todas **estas ondas son materiales**, su velocidad de propagación $`\mathscr{v}`$ es inferior
a la velocidad de la luz $`c`$.

* Al requerir un medio material, *no pueden viajar en el vacío*.

![](https://m3p2.com/fr/temporary-m3p2/waves/images-sounds/wave-phenomena/Waves-reflexion-interferences-e_v2_L500.gif)
_Ondas generadas en la superficie del agua en un plato, durante un impacto en una pared._


<br>

--------

##### **Las ondas electromagnéticas** *($`v = c`$)*

* No resultan de la perturbación de un medio material, sino que *están formadas*
por un **campo eléctrico y** un **campo magnético perpendiculares que se auto-mantienen**.
<br>
Como no existe un medio de soporte para las ondas electromagnéticas, estas
**pueden viajar en el vacío**, entre otros, el vacío interestelar.

* Estas ondas incluyen:
   * las *ondas de radio*
   * las *microondas*
   * los *infrarrojos*
   * la *luz visible*
   * los *ultravioleta*
   * los *rayos X*
   * los *rayos gamma*

* **Nuestros ojos perciben solamente** una pequeña parte de este espectro, la *luz visible*.
<br>
Como **estas ondas** son **energía pura** (no tienen masa en reposo), son
*mucho más abstractas*.
<br>
En todo momento, **nuestro cuerpo es atravesado** por *ondas de radio*, *ondas de televisión*, *ondas WiFi* que
transportan música, imágenes, palabras de entrevistas, etc.
**Sin la tecnología**, no tendríamos *ningún conocimiento de la mayoría de estas ondas*.
<br>

* La **velocidad de las ondas electromagnéticas** es
siempre *exactamente $`c = 299\,792\,458 m\,s^{-1}`$*, constante fundamental de la naturaleza llamada
*velocidad de la luz en el vacío*.
<br>
Al no depender del estado de movimiento del observador que mide esta velocidad, estas ondas
**desafían nuestra intuición clásica** del mundo. Constituyen *una de las pruebas experimentales* del acoplamiento del espacio y del tiempo
dentro *del espacio-tiempo* descrito primero por la **relatividad especial, luego** por la relatividad **general**.

<br>
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Dos estados de polarización diferentes, lineal (arriba) y elíptica (abajo), de una onda electromagnética.
Sin necesidad de dominar el nivel Montaña, el conocimiento visual de estos estados de polarización te permitirá entender, entre otras cosas, cómo puedes ver en 3 dimensiones una película proyectada en las 2 dimensiones de una pantalla de cine._

! *Nota*:
!
! Las **ondas electromagnéticas**, hasta muy recientemente (2015), eran la *única fuente de todo nuestro conocimiento del Universo*:
!
! La astrofísica observa las ondas electromagnéticas provenientes del *Big Bang*, de las *galaxias*, de las *estrellas*, de los *planetas* y del *medio interestelar*.

---------------

##### **Las ondas gravitacionales** *($`v = c`$)*

* A diferencia de las ondas electromagnéticas, que viajan en el espacio y el tiempo, las **ondas gravitacionales** son *aún más abstractas*: son una *vibración del tejido del espacio-tiempo mismo*.

* El **espacio-tiempo** se deforma por la presencia de materia (lo que causa la gravedad), pero además **puede vibrar** durante el *paso de ondas gravitacionales* producidas por eventos violentos en el universo.
<br>
Nuestros sentidos no pueden percibir estas ondas en absoluto.

* Descritas por la relatividad general, **viajan** *a la velocidad de la luz $`c`$*.

! *Nota*:
!
! Predichas por la relatividad general, pero observadas solo desde 2015, las **ondas gravitacionales** son la **base de una nueva astrofísica**, la *astrofísica de ondas gravitacionales*.
! <br>
! Esta disciplina observa **fenómenos violentos y masivos** en el universo, como rotaciones rápidas antes de la *fusión de agujeros negros y estrellas de neutrones*.

------

##### **Las ondas cuánticas** *($`v \gt c`$ en algunos casos)*

<br>

*A - Función de onda y medición*

* La **función de onda de una partícula** (denotada por la letra griega Psi, $`\Psi`$) está gobernada por la ecuación de Schrödinger en mecánica cuántica no relativista, o por las ecuaciones de Klein-Gordon, Dirac, Proca y Rarita-Schwinger (según el espín de la partícula) en la teoría cuántica de campos (que combina y supera la relatividad especial y la mecánica cuántica).

* No es *material*, y una de sus particularidades es *incluir una parte imaginaria* que juega un papel fundamental.

* Nadie comprende aún el significado real de esta onda.
Es **limitada por la velocidad de la luz, excepto en el momento de una medición** (colapso de la función de onda), que es un fenómeno no local, es decir, instantáneo (por lo tanto, con $v > c$).
Este **comportamiento no local** es *fundamentalmente aleatorio* y, por lo tanto, *no permite comunicarse* (de lo contrario, implicaría la existencia de paradojas temporales).

<br>

*B - Función de onda y partículas entrelazadas*

* El **entrelazamiento cuántico** corresponde a un *nivel de realidad aún más abstracto*.
<br>
El **vínculo cuántico entre dos partículas entrelazadas** (que interactuaron juntas en el pasado) es una conexión absolutamente extraordinaria que *existe fuera del espacio y del tiempo*.
<br>
Este vínculo:
   * es *indetectable* por cualquier tecnología conocida,
   * *no disminuye* con la distancia,
   * no es *detenido por obstáculos* de ningún tipo,
   * tiene un *comportamiento instantáneo*, por lo tanto, *no local*.

* **Fundamentalmente no local**, este vínculo es la *base de la teleportación cuántica*.
<br>
Cuando el **estado de una partícula es teletransportado de un lugar A a un lugar B**, la *información se propaga instantáneamente* de A a B y no pasa por el espacio físico entre A y B (por eso se dice que este vínculo existe fuera del espacio y del tiempo).
<br>
La **comprensión conceptual de este fenómeno** es *una de las grandes preguntas abiertas* en la interpretación de la física cuántica y es objeto de grandes debates entre los físicos.

<br>

*C - Función de onda y predicciones*

* La **formulación matemática de la mecánica cuántica** está:
   * perfectamente *bien comprendida*,
   * perfectamente *bien verificada experimentalmente*.

   Es su interpretación conceptual la que es materia de controversia.

* La **acción instantánea del entrelazamiento cuántico** es *aleatoria* y *no permite comunicarse*.
<br>
Sin embargo, la **teleportación cuántica permite comunicarse**, ya que incluye dos etapas:
   * una **primera etapa** *transportada por el entrelazamiento*,
   * una **segunda etapa** *limitada por la velocidad de la luz*.

   Por lo tanto, la **teleportación completa** está *limitada por la velocidad de la luz*.

! *Nota*:
!
! En mecánica cuántica y en la teoría cuántica de campos, la *función de onda $`\Psi`$* está *relacionada con la probabilidad de presencia de una partícula* en una superposición de estados cuánticos dada. La probabilidad en sí es proporcional a $` \Psi|^2`$.
! <br>
! En este sentido, *describe la dualidad onda-partícula*.

!! *Para ir más allá*:
!!
!! El marco de la teoría cuántica de campos, que combina y supera la relatividad especial y la mecánica cuántica no relativista, ha tenido numerosos éxitos. Entre ellos, la predicción previa al descubrimiento de varias partículas, como el quark top (1995) y el bosón de Higgs (2011).
!!
!! Sin embargo, no explica los fenómenos previstos por la relatividad general (dilatación del tiempo en un campo gravitacional, agujeros negros y ondas gravitacionales, verificados experimentalmente u observados).
!!
!! Así, nuestra comprensión de todos los fenómenos observados en el Universo requiere dos teorías distintas: la relatividad general y la teoría cuántica de campos, que parecen inconciliables en sus fundamentos.
!!
!! Los físicos continúan buscando un principio único que dé lugar a una teoría física unificada, de la cual la relatividad general y la teoría cuántica de campos serían solo aproximaciones, y que describiría y predeciría estadísticamente todos los fenómenos en todas las escalas de la Naturaleza.