---
title: 'Les 4 lois de l''optique géométrique'
media_order: 'Opt_Geo_refle_lim_650.gif,aef_fermat_mir_elliptique_6.gif,interaction_lumiere_surface_3_650.gif,Fermat_mir_3ray_650.gif'
published: true
routable: true
visible: false
lessons:
    - slug: geometrical-optics-basic-principles
      name: Les Bases de l'optique géométrique
      order: 2
---

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

----------


### Fondements de l'optique géométrique

#### Optique géométrique : <br>un modèle physique simple.

Ses *fondements* sont :
* Le concept de **rayon lumineux** : trajectoire orientée de l'énergie lumineuse
* Le concept d' **indice de réfraction** : caractérise  la vitesse apparente de la lumière dans un milieu homogène
* Le **principe de Fermat**


#### Rayon lumineux 

![](rays_forest.jpg)   
_L'intuition du "rayon de lumière" lors d'une promenade en forêt._

Les **rayons lumineux** sont des *lignes orientées* qui en chacun de leur point, indiquent la *direction et le sens de propagation de l'énergie lumineuse*.

Les rayons lumineux suivent des **lignes droites dans un milieu homogène**.

Les rayons lumineux *n'interagissent pas entre eux*

<br>

#### Indice de réfraction 

**Indice de réfraction $`n`$** &nbsp;&nbsp;:&nbsp;&nbsp;
**$`\large{\mathbf{n\;=\;\dfrac{c}{v}}}`$**
* **$`c`$** : *vitesse de la lumière dans le vide* (limite absolue)
* **$`v`$** : *vitesse de la lumière dans le milieu* homogène

**$`\Longrightarrow\: : \: \mathbf{n}`$** : grandeur physique **sans dimension** et **toujours >1**.

Dépendance : **$`\mathbf{n\;=\;n(\nu)\;\;\;}`$** , ou **$`\mathbf{\;\;\;n\;=\;n(\lambda_0)\;\;\;}`$**   
*(avec $`\nu`$ la fréquence et $`\lambda_0`$ lalongueur d'onde dans le vide)*

<!--
Je voulais faire cette remarque importante ici, mais ce n'est pas simple : avec effet Doppler, milieu de propagation ne mouvement par rapport à l'observateur... Il faut je pense faire la mise en garde dans le texte principal, et un récapitulatif de tout cela dans par exemple un parallèle 1 :

!!!! ATTENTION : la fréquence $`\nu`$ d'une onde (grandeur temporelle) mesurée par un observateur donné, ne dépend pas du milieu de propagation où la mesure a lieu. Cela n'est pas le cas de la longueur d'onde mesurée $`\lambda`$ , qui elle dépend du milieu de propagation car la vitesse de propagation de l'onde $`V`$ peut dépendre de ce milieu. Fréquence, longueur d'onde et vitesse de propagation d'une onde sont reliées par l'équation $`\lambda\:=\:\frac{V}{\nu}`$, mais :<br>
!!!! la **grandeur fondamentale** (indépendante du milieu) est la **fréquence $`\nu`$ (la grandeur temporelle)**.
-->

!! POUR ALLER PLUS LOIN :
!!
!!sur l'ensemble du spectre électromagnétique et pour tout milieu :
!!$`n`$ : valeur complexe dépendante de la fréquence $`\nu`$ de l'onde électromagnétique, fortes variations représentatives de tous les mécanismes d'interaction lumière/matières : $`n(\nu)=\Re[n(\nu)]+\Im[n(\nu)]`$<br>
!!
!! sur le domaine visible (où $`\lambda_0`$ s'utilise plus que $`\nu`$) et pour milieu transparent :<br>
!! valeur réelle, faibles variations de $`n`$ avec $`\lambda_0`$ $`\left(\frac{\Delta n}{n} < 1\%\right)`$

<br>

#### Chemin optique

**chemin optique**   *$\mathbf{\delta}$* &nbsp;&nbsp;&nbsp;=&nbsp;&nbsp;&nbsp;
**longueur euclidienne** *$\mathbf{s}$* &nbsp;&nbsp;X&nbsp;&nbsp;&nbsp;**indice de réfraction** *$\mathbf{n}

* **$\mathbf{\Gamma}$** :  *parcours* ( = ligne continue )
* **$\mathbf{\mathrm{d}s}$** :  *élément de longueur* en un point sur le chemin $\Gamma$
* **$\mathbf{n}$** :  *indice de réfraction*
* **$\mathbf{\mathrm{d}\delta}$** :  *chemin optique élémentaire* au point P sur le chemin $\Gamma$



**Chemin optique le long d'un parcours $`\Gamma`$ :**

* **$`\large{\mathbf{\delta}}`$** $`\displaystyle\;=\int_{\Gamma}\mathrm{d}\delta`$
  **$`\;=\large{\int_{\Gamma}n\cdot\mathrm{d}s}`$**$`\;=\;\int_{\Gamma}\dfrac{c}{v}\cdot\mathrm{d}s`$
    $`\;=\displaystyle c\;\int_{\Gamma}\frac{\mathrm{d}s}{v}\;`$
  **$`= \large{\mathbf{\;c\;\tau}}$** 
* **$\large{\mathbf{\delta}}$** est donc *proportionnel au temps de parcours* .

<br>

#### Stationnarité d'un chemin

* **$\Gamma_o$** :  *chemin entre 2 points fixes* A et B
* **$\lambda_i$ ** :  *paramètres définissant un chemin* 
* **${\Large\tau}$ ** :  *grandeur physique caractérisant un chemin*    
<br>
 
**${\Large\tau}(\Gamma_o)$ stationnaire &nbsp;&nbsp;
${\Longleftrightarrow}\:\:\:\:\:\mathrm{d}{\Large\tau}(\Gamma_o)=\displaystyle\sum_i\dfrac{\partial{\large\tau}}{\partial\lambda_i}(\Gamma_o)\;\mathrm{d}\lambda_i=0$**

![](stationnarite3_400.jpg)

<br>

#### Principe de Fermat

**Entre 2 points** de son parcours, un **rayon de lumière** suit **"le" ou "les chemins"** qui présentent un  *temps de parcours stationnaire* .

ou ( équivalent )

**Entre 2 points**  de son parcours, la **lumière**  suit **"le" ou "les chemins"**  qui présentent un  *chemin optique stationnaire* .

<br>

#### Exemples 

##### __Le miroir sphérique concave__

* **A** : *source ponctuelle* émettant lumière dans toutes les directions.
* **B** : *point fixe de l'espace*.

Pour ce miroir, **selon les positions des points A et B** :

* **Plusieurs extrema** : ici *2 maxima* et *1 minimum* **$\Longrightarrow$ plusieurs rayons** issus de A passent par B : ici *3 rayons* :

<!--à finaliser si possible :
1) DIFFICILE : mise au point automatique : largeur 100% de l'écran et bonne hauteur 'difficile cela' de toute application geogebra.
2) TRES DIFFICILE : faire en sorte que en mode connexion, l'image animée correspondante au geogebra s'affiche tant que l'animation iframe geogebra n'est pas téléchargée, puis elle ne s'affiche pas lorsque le geogeba est prêt, et que ce soit elle qui s'affiche en mode "hors connexion".-->

<!--a supprimer
[Cliquer pour animation geogebra](https://www.geogebra.org/material/iframe/id/syegm6gp)
-->

![](Fermat_mir_3ray_650.gif)

!!!! *ATTENTION* :
!!!! Comprenez bien cet exemple d'application du théorème de Fermat. Il dit que *les 3 trajectoires tracées entre A et B vérifient le principe de Fermat* et donc *sont des trajectoires possibles entre ces deux points* à l'exclusion de toute autre trajectoire. Si le point A est une source ponctuelle qui émet de la lumière dans toutes les directions, alors ces 3 trajectoires seront parcourues par la lumière. Si un rayon passe par A avec l'une de ces 3 inclinaisons, alors la trajectoire correspondante sera réalisée.
!!!! *Mais* les points *A et B ne sont pas des points conjugués au sens de l'optique paraxiale* : A n'est pas l'image de B, et vice versa.
!!! Il en est de même pour toutes les animations de ce chapitre "exemples".

* autres positions de A et B : **1 minimum $\Longrightarrow$ 1 rayon unique** issu de A passe par B .

![](Fermat_mir_1ray_min_650.gif)

* autres positions de A et B : **1 maximum $\Longrightarrow$ 1 rayon unique** issu de A passe par B .

![](Fermat_mir_1ray_max_650.gif)

<br>

##### __Le miroir elliptique concave__

* Miroir elliptique : miroir dont la surface s'inscrit dans un ellipsoïde de révolution.

! <details markdown=1>
! <summary>
! Ellipsoïde et ellipsoïde de révolution
! </summary>
! Est-il nécessaire de rapeller ici ce que sont les ellipsoïde et ellipsoïde de révolution? rappel en texte? ou 2 liens vers Wikipédia? ou lien vers une autre page m3p2 sur les quadriques en géométrie euclidienne (page encore à créer) ? Si oui, dans une partie Beyond, parler du miroir elliptique concave acoustique, c'est impressionnant quand on le vit.
! </details>

* **entre les deux "foyers géométriques"** F et F' d'un miroir elliptique, **tous les chemins interceptant le miroir sont stationnaires** : ils ont le même chemin optique<br>
**$\Longrightarrow$** : *tous les rayons issus de l'un des foyers géométriques et interceptant le miroir convergent vers le second foyer géométrique*.

<!--a supprimer
[Cliquez ici pour animation geogebra](https://www.geogebra.org/m/aaus5dpr)
-->

![](fermat_mir_elliptique_650.gif)

!!!! *ATTENTION* : 
!!! les "foyers géométriques" de l'ellipsoïde de révolution, "surface géométrique" dans laquelle s'inscrit la surface du miroir elliptique, ne correspondent pas aux "foyers" du miroir elliptique tels qu'ils seront définis au "sens optique" du terme dans la suite de ce cours.

<br> 

#### Les quatre lois de l'optique géométrique

* **Principe de Fermat** *$`\Longrightarrow`$ 4 lois de l'optique géométrique* :

##### __La loi du retour inverse de la lumière__

Chemin optique et propriété de stationnarité : concept d'orientation non utilisé<br>
*$`\Longrightarrow`$ propriété de stationarité ne dépend pas de l'orientation* du chemin.

**$`\Longrightarrow`$**  la **trajectoire** *suivi par la lumière* est **indépendant du sens de propagation**.

<br>

##### __La loi de la trajectoire rectiligne dans un milieu homogène et isotrope__

Espace euclidien : * ligne droite = plus court chemin entre 2 points*

**$\Longrightarrow$**  dans un **milieu optiquement homogène et isotrope**, la *lumière se propage en ligne droite* : les **rayons lumineux sont des sègments de droites**.

<br>

##### __Les 2 lois de la réflection et de la réfraction__

! <details markdown=1>
! <summary>
! SI NECESSAIRE : rappel des définitions des angles et indices de réfraction utilisés ci-dessous
! </summary>
! $`n_{incid}`$ : indice de réfraction du milieu d'incidence de la lumière.<br>
! $`n_{émerg}`$ : indice de réfraction du milieu d'émergence de la lumière (donc après traversée de la surface).<br>
! `$i_{incid}`$ : angle rayon incident - normale à la surface au point d'impact.<br>
! $`i_{émerg}`$ : angle rayon émergent - normale à la surface au point d'impact.<br>
! </details>

Pour tout rayon incident impactant une surface :
* La **surface au point d'impact** est *localement plane*.
* **Plan d'incidence** : plan qui *contient le rayon incident et la normale à la surface au point d'impact*.
* **Rayon réfracté et rayon réfléchi** sont *dans le plan d'incidence*, du *côté opposé au rayon incident par rapport à la normale* à la surface au point d'impact.

<br>

__*Loi de la réflection*__ : **$`\large{i_{\,réflec} = i_{\,incid}}`$**

!!!! *Attention* :   
!!!! Si les *angles* sont exprimés *en notation algébrique*, la loide lé réflexion devient   
!!!! **$`\large{i_{\,réflec} = - i_{\,incid}}`$**

<br>

__*Loi de la réfraction (Snell-Descartes)*__ : pour $`\mathbf{i_{incid}}`$ donné :
* *si $`\dfrac{n_{incid}}{n_{émerg}}\cdot\sin\,(i_{incid})\leqslant1`$* alors **phénomène de réfraction** :<br><br>
**$`\large{n_{émerg}\cdot \sin\,(i_{émerg})=n_{incid}\cdot \sin(i_{incid})}`$**<br>

<br>

* *si $`\dfrac{n_{incid}}{n_{emerg}}\cdot\sin(i_{incid})>1`$* alors **phénomène de réflexion totale** :<br>
*rayon réfléchi* sur l'interface en vérifiant la loi de la réflexion :<br><br>
**$`\large{i_{réflec} = i_{incid}}`$**   
<br>
(et $`i_{réflec} = i_{incid}`$ si les angles sont en notation algébrique)

<br>

* **Angle** *d'incidence* **limite de réflexion totale** :<br><br>
**$`\large{i_{limite}=\arcsin\left (\dfrac{n_{émerg}}{n_{incid}}\right)}`$** *$`\Longrightarrow \large{i_{émerg}=\pi/2\:rad = 90 °}`$*

<br><br>

_Phénomènes de réflexion et réfraction à une surface réfractante._

![](interaction_lumiere_surface_3_650.gif)

!! <details markdown=1>
!! <summary>
!! POUR ALLER PLUS LOIN : répartition énergétique entre faisceaux réfléchi et transmis par une surface réfractante.
!! </summary>
!! Optique géométrique : ne quantifie pas partie réfléchie $R$ et partie transmise $T$ de l'intensité d'un faisceau incident sur une surface réfractante plane. Cette réparttion varie en fonction de l'angle d'incidence, de la polarisation de la lumière incidente, de la longueur d'onde. Cela est décrit par l'électromagnétisme. 
!! Cependant un résultat simple est utile et à connaître :
!! * L'intensité lumineuse est soit réfléchie, soit transmise : $R+T=1$.
!!
!! Pour un faisceau lumineux de longueur d'onde $\lambda$ qui arrive sous incidence normale sur une surface réfractante :
!! - proportion puissance réfléchie sur puissance incidente : $R=\left(\dfrac{n_{incid}-n_{émerg}}{n_{incid}+n_{émerg}}\right)^2$
!! - proportion puissance transmise sur puissance incidente : $T=1-R$
!!</details>

_Phénomène de réflexion totale_

<!--à finaliser si possible :
1) DIFFICILE : mise au point automatique : largeur 100% de l'écran et bonne hauteur 'difficile cela' de toute application geogebra.
2) TRES DIFFICILE : faire en sorte que en mode connexion, l'image animée correspondante au geogebra s'affiche tant que l'animation iframe geogebra n'est pas téléchargée, puis elle ne s'affiche pas lorsque le geogeba est prêt, et que ce soit elle qui s'affiche en mode "hors connexion".-->

<!--
<iframe width="auto" height="auto" sandbox="allow-same-origin allow-scripts" src="https://www.geogebra.org/material/iframe/id/bg5ewxee" frameborder="0" allowfullscreen></iframe>

_smartphone : Passer en mode "paysage" pour voir les animations geoegbra_
<iframe width="640" height="360" sandbox="allow-same-origin allow-scripts" src="https://www.geogebra.org/material/iframe/id/bg5ewxee" frameborder="0" allowfullscreen></iframe>
-->
<!--image gif correspondante-->
![](Opt_Geo_refle_lim_650.gif)
<!--a supprimer
animation : https://www.geogebra.org/material/iframe/id/bg5ewxee
-->

