---
title: Synthèse
routable: false
visible: false
lessons:
    -
        slug: cylindrical-charge-or-current-distributions-integral
        name: PARALLÈLE : Distributions cylindriques de charges et de courants
        order: 2
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oint{\displaystyle\mathop{{\int}\mkern-16mu \scriptsize \bigcirc}}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etape 3 : Ecriture : 1/3</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>



##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème d' **Ampère intégral** aux :


### **Distributions cylindriques de courant**

* Le terme **cylindrique** réfère à l'*aspect extérieur* de la distribution de courant.


#### Propriétés nécessaires au théorème d'Ampère

* Le théorème d'Ampère sera utilisable si une distribution cylindrique ... à terminer    

<!--ATTENTION : ce qui est ici en commentaire est probablement faux----------
de courant possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.
--------------------------------------------------------------------------->

#### Y a t-il plusieurs configurations vérifiant ces propriétés ?

* La cause du champ $`\overrightarrow{B}`$ étant vectorielle, *deux configurations de* **courant** sont possibles. Le déplacement des charges peut s'effectuer :
   *  **en direction de l'axe de révolution** : c'est le cas d'un *fil électrique rectiligne* infini parcouru par un courant.   
      $`\Longrightarrow``$ tout plan contenant l'axe de révolution est plan de symétrie pour le courant.

   *  en **tournant circulairement autour de l'axe de révolution** : c'est le cas d'un *solénoïde* infini parcouru par un courant.   
      $`\Longrightarrow`$ tout plan contenant l'axe de révolution est plan d'anti-symétrie pour le courant.

----------------------

#### LES COURANTS SONT DIRIGÉS SELON L'AXE DE RÉVOLUTION <br><br> cas du fil conducteur rectiligne infini.

---------------------

#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques
   $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.


#### Comment caractériser cette distribution de courant ?

* Dans le cas où la *section droite* du fil conducteur est *négligée*, le **courant** est simplement décrit 
 par l'intensité *$`I`$* qui parcourt le fil. Le **sens du courant** dans le fil est *précisé par une flèche*.   
 _(en magnétostatique, le courant est constant, donc son sens ne varie pas au cours du temps)._

* Dans le cas contraire où la *section droite* est *non négligée*, le courant est décrit par un
 **vecteur densité de courant $`\overrightarrow{j}`$**.
<br>
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel} \overrightarrow{j} = \overrightarrow{j}(\rho,\xcancel{\varphi}, z)`$**.   
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\overrightarrow{j}= \overrightarrow{j}(\rho,\varphi, \xcancel{z})`$**.   
<br>
* *Au final*, le vecteur densité volumique de courant **$`\overrightarrow{j}`$ ne dépend que de z** :   
*$`\mathbf{\left.\begin{array}{l}
\overrightarrow{j}=\overrightarrow{j}\,(\rho, z) \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)}`$**

Image à faire   
_Un cylindre infini est, lorsqu'il est parcourue par un courant réparti uniformément dans son volume, est l'exemple le plus simple de distribution cylindrique de courant._



#### De quelles coordonnées dépend $`\overrightarrow{B}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{B}}`$** possède les *invariances de $`\overrightarrow{j}`$*

* $`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)\Longrightarrow}`$ **$`\mathbf{\overrightarrow{B}=\overrightarrow{B}(\rho)}`$**


#### Comment déterminer la direction de $`\overrightarrow{B}`$ ?

* *Par l'* **étude des symétries** *de la distribution de courant $`\overrightarrow{j}`$*.   
<br>

![](magnetostat-fil-symetries-direction-B_v2_L1200.gif)

1. Soit un **point $`M(\rho_M\,\varphi_M,z_M)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et l'axe $`Oz`$ est *plan de symétrie* pour la distribution de courant.
3. Le champ magnétique **$`\overrightarrow{B}`$ étant un vecteur axial**, en tout point d'un plan de symétrie 
   il est perpendiculaire à ce plan. Le plan de symétrie $`P_1`$ étant déterminé, la
   *direction de $`\overrightarrow{B}`$, selon $`\overrightarrow{e_{\varphi}}`$*, est 
   *totalement déterminée*.
4. _Étape non nécessaire :_    
_Le plan_ $`P_2`$ _qui contient le point $`M`$ et perpendiculaire à l'axe $`Oz`$ est_
 _plan de d'anti-symétrie pour la distribution de courant. En tout point d'un plan_
_d'anti-symétrie, $`\overrightarrow{B}`$ vecteur axial est contenu dans ce plan, ce qui est bien vérifié._   


* De façon plus concise :   
<br>
**En tout point $`M`$** l'espace,   
*$`\left.\begin{array}{l} \overrightarrow{B}\;\text{vecteur axial} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie}\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}}`$**
<br>

#### Comment s'exprime $`\overrightarrow{B}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\overrightarrow{j}`$ :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{B}=\overrightarrow{B}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{B}=B_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}}`$**


#### Y-a-t'il des lieux où $`\overrightarrow{B}`$ est déjà totalement déterminé par les symétries et invariances ?

à faire


#### Quel contour d'Ampère $`\Gamma_A`$ choisir ?

* Le **contour d'Ampère $`\mathbf{\Gamma_A}`$** doit :
   * être une *ligne fermée*.
   * *contenir le point $`M`$* quelconque.
   * permettre un *calcul simple de $`\displaystyle\oint_{\Gamma_A} \overrightarrow{B}\cdot \overrightarrow{dl}`$*.

Image à faire

* *Choix de $`\mathbf{\Gamma_A}`$* : **cercle**,
   * contenu dans le plan qui **contient de point $`M`$** et **perpendiculaire à l'axe $`Oz`$**.
   * de **rayon $`\rho_M`$**, coordonnées du point $`M`$ considéré.


#### Que signifie orienter le contour d'Ampère $`\Gamma_A`$ choisi ?

* orienter signifie **donner un sens "positif" de circulation**, *indiqué par une flèche* sur le contour.

* Ce sens positif **fixe le sens des vecteurs déplacement élémentaire $`\mathbf{\overrightarrow{dl}}`$ ** le long du contour : .   
  <br>
  figure explicative à faire.


#### Le choix de l'orientation est-il important ?

* Ne pas oublier d'**orienter le contour d'Ampère** est *important*.

* Choisir **un sens plutôt que l'autre** n'a *pas d'importance*.   
  <br>
  En effet :   
  * le théorème d'Ampère est une égalité entre 2 membres :   
  $`\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\,\oiint_{\mathscr{S}_A}\overrightarrow{j}\cdot\overrightarrow{dS}`$
  * Les orientations de $`\overrightarrow{dl}`$ et $`\overrightarrow{dS}`$ sont liées.
  * Changer le sens de $`\overrightarrow{dl}`$ changera aussi le sens de $`\overrightarrow{dS}`$.   
    Cela revient à multiplier par $`-1`$ chaque membre de l'égalité,    
    ce qui ne modifie pas la solution de l'équation.


#### Que vaut la circulation de $`\overrightarrow{B}`$ le long de $`\Gamma_A`$ ?

* Le **signe** devant l'expression finale contenant $`B_{\varphi}(r)`$ *dépend de l'orientation choisie* sur $`\mathbf{\Gamma_A}`$

* Si **$`\mathbf{\overrightarrow{dl}=+\,\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}}`$** :   
<br>
**$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$**   
$`\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}\big(B_{\varphi}(\rho_M)\,\overrightarrow{e_{\varphi}}\big)\cdot \big(+\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}\big)`$    
<br>
$`\displaystyle\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}B_{\varphi}(\rho_M)\,\rho_M\,\big(\overrightarrow{e_{\varphi}}\cdot \overrightarrow{e_{\varphi}}\big) d\varphi`$      
<br>
$`\displaystyle\quad\quad=\rho_M\,B_{\varphi}(\rho_M)\,\oint_{\varphi=0}^{\varphi=2\pi}d\varphi`$    
<br>
**$`\mathbf{\displaystyle\quad\quad = 2\pi\,\rho_M\, B_{\varphi}(\rho_M)}`$**

<br>
* Si *$`\mathbf{\overrightarrow{dl}=-\,\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}}`$* :   
<br>
*$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$*   
$`\displaystyle\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}\big(B_{\varphi}(\rho_M)\,\overrightarrow{e_{\varphi}}\big)\cdot \big(-\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}\big)`$      
<br>
$`\displaystyle\quad\quad=-\oint_{\varphi=0}^{\varphi=2\pi}B_{\varphi}(\rho_M)\,\rho_M\,\big(\overrightarrow{e_{\varphi}}\cdot \overrightarrow{e_{\varphi}}\big) d\varphi`$   
<br>
$`\displaystyle\quad\quad=-\rho_M\,B_{\varphi}(\rho_M)\,\oint_{\varphi=0}^{\varphi=2\pi}d\varphi`$   
<br>
*$`\mathbf{\displaystyle\quad\quad = -\,2\pi\,\rho_M\, B_{\varphi}(\rho_M)}`$*


#### Quelle surface ouverte $`\mathscr{S}_A`$ s'appuyant sur $`\Gamma_A`$ choisir ?

* La **surface d'Ampère $`\mathscr{S}_A`$** doit :
   * être une *surface ouverte s'appuyant sur le contour d'Ampère $`\Gamma_A`$*.
   * permettre un *calcul simple de $`\displaystyle\ooint_{\mathscr{S}_A} \overrightarrow{j^{3D}}\cdot \overrightarrow{dS}`$*.

Image à faire

* *Choix de $`\mathbf{\Gamma_A}`$* : le **disque** qui s'appuie sur le cercle $`\Gamma_A`$*, donc le disque :
   * contenu dans le plan qui **contient de point $`M`$** et **perpendiculaire à l'axe $`Oz`$**.
   * de **rayon $`\rho_M`$**, coordonnées du point $`M`$ considéré.   
   <br>
   **$`\displaystyle\Longrightarrow\;\forall M\in\mathscr{S}_A\,,\;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm j^{3D}\,dS**   
   ($`+`$ ou $`-`$ selon l'orientation du disque).


#### Comment orienter $`\mathscr{S}_A`$ ?

* Les **orientations du contour et de la surface** d'Ampère associée sont *couplées par la règle de la main droite*.

Image à faire



A TERMINER avec différents cas.



