---
title: 'The thin lens'
media_order: 'Const_lens_conv_point_AapresO.gif,lens-convergent-N2-en.jpeg,Const_lens_conv_point_AentreFO.gif,lens-convergent-N2-es.jpeg,lens-convergent-N2-fr.jpeg,Const_lens_conv_point_AavantF.gif,lens-divergent-N2-es.jpeg,lens-divergent-N2-fr.jpeg,lens-divergent-N2-en.jpeg,diverging-thin-lens-representation.jpeg,converging-thin-lens-representation.jpeg'
published: true
routable: true
visible: false
lessons:
   - slug: simple-optical-elements
   - order: 3
---

### What is a lens ?

#### Objective

* initial : to **focuse or disperse the light**.
* ultimate : to **realize images**, alone or as part of optical instruments.

#### Physical principle

* **uses the refractive phenomenon**, described by the Snell-Descartes' law.

#### Constitution

* Piece of **glass, quartz, plastic** (for visible and near infrared and UV).
* **Rotationally symmetrical**.
* **2 polished surfaces** perpendicular to its axis of symmetry, **either or both curved** (and most often spherical).

<!--image to build : a thin lens-->

#### Interest in optics : thin lenses

* **Thin lens** : *thickness << diameter*
* Thins lens : **most important simple optical element** that is *used alone or combined in serie in most optical instruments* : magnifying glasses, microscopes, tele and macro objectives, camera, refracting telescopes.

<!--image to build N1 ou N2 : a composition :
upper medium : a unic thin lens
upper part towards utilization of a unique lens : magnigfying glass and eyeglasses
lower medium : small serie of centered naked lenses
lower part toward utilization of combined lenses : macroscope, camera (apparatus and objective of a cellular), refracting telescope, teleopbjective-->

### Modeling a thin lens surrounded by air, gaz or vaccum.

#### Why modeling ?

* To **understand, calculate and predict images** of objects given by thin lenses

<!--picture when we see the object, the lens and the image-->

##### Why  surrounded by air, gaz or vaccum?

* **In most optical instruments**, lenses are *surrounding by air*.
* **air, gaz and vaccum** have refractive index values in the range "$1.000\pm0.001$, and can be approximated by *$n_{air}=n_{gaz}=n_{vaccum}=1$*<br>
$\Longrightarrow$ same optical behavior in air, gaz and vacuum.

#### Types and characterization of thin lenses

**Convergent** = **converging** = **convexe** = **positive** lenses

![](lens-convergent-N2-en.jpeg)

* Characterized by :<br>
\- **Focal lenght** (usually in cm) always >0 *+* adjective "**converging**"<br>
&nbsp;&nbsp;or<br>
\- Its **image focal length** $f'$ (in *algebraic value*, usually in cm), that is *positive $f'>0$*.<br>
&nbsp;&nbsp;or<br>
\- Its **vergence** $V$ (in ophtalmology) that is *positive  $V>0$*,<br>
with $V (\delta)=\dfrac{1}{f'(m)}$ ($f'$ being expresssed in m "meter" and $V$ in $\delta$ "dioptre", so $\delta=m^{-1}$).<br>
 
**Divergent** = **diverging** = **concave ** = **negative**  lenses

![](lens-divergent-N2-en.jpeg)

* Characterized by :<br>
\- **Focal lenght** (usually in cm) always >0 *+* adjective "**diverging**"<br>
&nbsp;&nbsp;or<br>
\- Its **image focal length** $f'$ (in *algebraic value*, usually in cm), that is *negative $f'<0$*.<br>
&nbsp;&nbsp;or<br>
\- Its **vergence** $V$ (in ophtalmology) that is *negative  $V<0$*,<br>
with $V (\delta)=\dfrac{1}{f'(m)}$ ($f'$ being expresssed in m "meter" and $V$ in $\delta$ "dioptre", so $\delta=m^{-1}$).<br>

<!-- suppressed
#### What physical framework, model and technics ?

* _Framework : Geometrical Optics = Light rays optics $\longrightarrow$ foothills stage_.

* _Model : paraxial model = gaussian model $\longrightarrow$ foothills stage_.

* Model splits in *two different technics (but equivalent)* :<br> **graphical modeling** AND **analytical modeling**

* *Differences between model predictions and experimental observations* : ** optical aberrations** (_under control, minimized and negligeable in optical instruments_).
-->

### Analytical modeling

(_for thin lens surrounded by air, gaz or vaccum_)

##### Thin lens equation
**$\dfrac{1}{\overline{OA'}}-\dfrac{1}{\overline{OA}}=V=-\dfrac{1}{\overline{OF}}=\dfrac{1}{\overline{OF'}}$**

##### Transverse magnification expression 
**$M_{T-thinlens}=\dfrac{\overline{OA'}}{\overline{OA}}$** 


### Graphical modeling

#### Thin lens representation

* **optical axis** = *revolution axis* of the lens, positively *oriented* in the direction of propagation of the light (_from the object towards the lens_).

* **thins lens representation** :<br><br>
\- *line segment*, perpendicular to optical axis, centered on the axis with symbolic *indication of the lens shape* at its extremities (_convexe or concave_).<br><br>
\- **S = C = O** : vertex S = nodal point C = center O of the thin lens $\Longrightarrow$ is used point O.<br><br>
\- *point O*, intersection of the line segment with optical axis.<br><br>
\- *object focal point F* and *image focal point F'*, positioned on the optical axis symmetrically with respect to the point O ($f=-f'$) at algebraic distances $\overline{OF}=f$ and $\overline{OF'}=f'$.<br><br> 
\- *object focal plane (P)* and *image focal plane (P')*, planes perpendicular to the optical axis at respectively points $F$ and $F'$.

![](converging-thin-lens-representation.jpeg)<br>
_Converging thin lens representation : $\overline{OF}<0$ , $\overline{OF'}>0$ and $|\overline{OF}|=|\overline{OF'}|$_

 ![](diverging-thin-lens-representation.jpeg)<br>
 _Divverging thin lens representation : $\overline{OF}>0$ , $\overline{OF'}<0$ and $|\overline{OF}|=|\overline{OF'}|$_
 
#### Determining conjugate points :

##### Converging thin lens

<!--
**Towards geogebra animations** :<br>
\- Graphical construction<br>
[Click here for geogebra animation](https://www.geogebra.org/material/iframe/id/zqwazusz)<br>
\- Graphical construction and light pencils <br>
[Click here for geogebra animation](https://www.geogebra.org/material/iframe/id/wkrw5qgm)<br>
\- Graphical construction and transverse magnification<br>
[Click here for geogebra animation](https://www.geogebra.org/material/iframe/id/xwbwedft)<br>
-->

* **Point source located between &infin; et F**

![](Const_lens_conv_point_AavantF.gif)

* **Point source located between F et O**

![](Const_lens_conv_point_AentreFO.gif)

* **Virtual object point** (will be seen at level foothills, to remove from here).

![](Const_lens_conv_point_AapresO.gif)

##### Diverging thin lens 

(to be implemented)
