---
title: Ondes électromagnétiques dans la matière
published: false
routable: false
visible: false
lessons:
    - 
      slug: electromagnetic-waves-from-vacuum-to-media
      name: PARALLÈLE : Propagation des ondes EM, du vide aux milieux matériels
      order: 1
    -
      slug: electromagnetic-static-field-or-waves-in-media
      name: PANORAMA : du champ statique aux ondes EM dans la matière
      order: 3
    - 
      slug: EM-waves-propagation-reflexion-transmission
      name: "PARALLÈLE : Propagation dans un milieu, Réfléxion et Transmission aux interfaces"
      order: 2
---

<!---
    - slug: electromagnetic-waves-from-vacuum-to-media
      name: PARALLÈLE : propagation des ondes EM, du vide aux milieux matériels
      order: 3
--->

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!--MétaDonnée : ... -->

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Propagation des ondes électromagnétiques<br> dans les milieux linéaires, homogènes et isotropes (L.H.I.)

#### Principe général de la propagation d'un signal électromagnétique dans un matériau

##### Equations de propagation dans un milieu

L'équation de propagation des champs électrique et magnétique d'une onde se propageant 
dans un milieu fait intervenir la densité de charge $`\rho`$ et la densité de courant 
de charge $`\vec{j}`$ du milieu. Pour le champ électrique, les variations temporelles 
et spatiales de $`\vec{E}`$ sont ainsi liées à $`\rho`$ et $`\vec{j}`$ de la façon 
suivante :

$`\Delta\vec{E}\left(M,t\right)-\dfrac{1}{c^{2}}\dfrac{\partial^{2}\vec{E}\left(M,t\right)}{\partial t^{2}}`$
$`=\dfrac{1}{\varepsilon_{0}}\;grad\left(\rho\left(M,t\right)\right)+\mu_{0}\dfrac{\partial\vec{j}\left(M,t\right)}{\partial t}`$

Le passage de l'onde dans le milieu va nécessairement perturber l'équilibre électrostatique
des charges présentes dans celui-ci et contribuer ainsi localement à leur mouvement 
et/ou à leur accumulation. Afin de résoudre les équations de propagation, il est donc
nécessaire de connaître les relations de dépendance de $`\rho`$ et $`\vec{j}`$ à $`\vec{E}`$ 
et $`\vec{B}`$. Dans ces conditions seulement, il sera possible d'obtenir la forme exacte
de l'onde électromagnétique qui se propage dans le milieu en question.

##### Notion d'échelle mésoscopique

La dépendance du mouvement des charges à l'onde é.m. qui se propage ne peut pas être
déterminée expérimentalement à l'échelle microscopique. A cette échelle en effet, 
on passe sur de très courtes distances d'une situation où le point considéré est 
proche d'un noyau (de charge positive) à celle où il est plutôt proche d'un électron
(de charge négative). Cela signifie que les champs électriques et magnétiques locaux
$`\vec{E}_{\textrm{local}}`$ et $`\vec{B}_{\textrm{local}}`$ fluctuent de façon très 
abrupte lorsque l'on considère le problème à l'échelle atomique. Il n'est donc pas 
possible d'en évaluer l'orientation et l'amplitude, ni même de déterminer
$`\rho_{\textrm{local}}`$ et $`\vec{j}_{\textrm{local}}`$. Pour décrire le système, 
il faut donc travailler à une échelle intermédiaire entre l'échelle microscopique 
et l'échelle macroscopique : on la définira comme l'échelle mésoscopique. Les grandeurs
étudiées seront alors des moyennes spatiales des grandeurs locales réalisées sur des
volumes mésoscopiques. La dimension caractéristique de ces volumes est de l'ordre de 
3 à 10 nm. A cette échelle, on s'affranchit des fluctuations rapides de densité de 
charge (et donc de champ électrique) liées à la structure de l'atome dont la dimension
caractéristique est inférieure à l'Angström ($`10^{-10}\,m)`$.
Ainsi :

$`\vec{E}=\langle \vec{E}_{\textrm{local}}\rangle_{3 - 10~\textrm{nm}}`$ et 
$`\vec{B}=\langle \vec{B}_{\textrm{local}}\rangle_{3 - 10~\textrm{nm}}`$


![](Mesoscopique.PNG) 

Suite au choix de cette échelle, on doit nécessairement se limiter aux ondes é.m. 
dont les champs ne varient que très peu sur des distances de 3 à 10 nm, i.e. $`\lambda\gg 3`$ 
nm, soit $`\lambda\geq`$ 300 nm. En considérant une vitesse de phase égale à $`c`$,
cela signifie qu'on doit se limiter à des fréquences $`\nu \leq 10^{15}`$ Hz. Cette
condition sera vérifiée dans la suite du cours et nous permettra de définir des relations
"macroscopiques" entre $`\rho`$, $`\vec{j}`$, $`\vec{E}`$ et $`\vec{B}`$.

##### Décomposition d'un signal électromagnétique périodique en une somme d'OPPM (série de Fourier)

Tant que l'on reste dans un régime linéaire pour le comportement du milieu vis à 
vis des champs électrique et magnétique des ondes qui s'y propagent, on peut considérer
que si plusieurs ondes vérifient les équations de propagation, alors tout signal représenté 
comme la combinaison linéaire de ces ondes vérifie lui aussi les équations de propagation. 
Or, tout signal périodique peut être décomposer en une somme de fonctions sinusoïdales 
selon l'équation suivante (en notation complexe avec $`T`$ la période):

$`f(u)=\displaystyle\sum_{n=-\infty}^{+\infty}A_{n}(f)\cdot e^{2i\pi\frac{n}{T}u}`$

De ce fait, on pourra se limiter dans la suite du cours à l'étude des signaux é.m. 
les plus simples, c'est-à-dire les OPPMs.

##### Notion de vitesse de groupe

Lorsque l'on étudie la propagation d'un paquet d'ondes (ensemble d'OPPMs caractérisant 
un signal réel par exemple) dans un milieu, chacune d'entre elles est caractérisée par 
sa pulsation $`\omega`$, donc par son nombre d'onde $`k`$ et par une certaine vitesse 
de phase $`v_\varphi`$ qui en découle. Pour des pulsations différentes, la vitesse
de phase peut varier. De ce fait, les ondes du paquet ne se déplacent pas toutes à 
la même allure et le paquet se disperse dans le temps en fonction de la distance 
parcourue dans le milieu. On peut définir une vitesse de propagation du paquet d'onde,
appelée vitesse de groupe $`v_g`$, qui tient compte de cette dispersion et qui se 
détermine de la façon suivante :


$`v_g = \dfrac{\omega}{k}.`$

La vitesse de groupe est une des grandeurs caractéristiques de la propagation des 
ondes dans un milieu comme nous allons le voir par la suite.

#### Propriétés des milieux

Afin de résoudre l'équation de propagation des champs, il est nécessaire d'introduire 
d'abord quelques notions sur le comportement des milieux soumis à des champs électrique
et magnétique. Nous allons nous intéresser à l'interaction de trois principaux types
de milieu avec $`\vec{E}`$ et $`\vec{B}`$.


##### Milieux conducteurs : conductivité

Les milieux conducteurs sont définis comme les milieux contenant des charges électriques
libres de se déplacer. Ils comprennent donc les métaux qui sont de bons conducteurs, 
les solutions ioniques et les plasmas (gaz ionisés). Les conducteurs sont caractérisés
par une densité de charges libres $`\rho_{\textrm{libre}}`$ (en $`C.m^{-3}`$), et par
une conductivité $`\sigma`$ (en $`\Omega.m^{-1}`$).

Lorsque ces charges libres sont soumises à un champ électrique, elles se mettent 
en mouvement et génèrent une densité volumique de courant de charges libre $`\overrightarrow{j}_{lib}`$ 
caractérisée par la loi d'Ohm locale :

$`\vec{j}_{\textrm{lib}}=\sigma \vec{E}`$

Cette relation reste valide si le champ électrique varie avec le temps.
La réponse à un champ électrique tend à annuler la cause : la séparation des charges
positives et négatives dans des directions opposées vis à vis du champ électrique 
appliqué génère un champ électrique induit opposé et dont l'amplitude augmente jusqu'à
annuler totalement le champ initial. Le conducteur revient alors à l'équilibre électrostatique.
Ce retour à l'équilibre est relativement rapide dans le cas des très bons conducteurs
et on peut considérer alors qu'une onde é.m. ne peut pas y pénétrer car le champ 
électrique moyen y est maintenu nul constamment (voir le modèle du métal parfait 
en fin de chapitre).


#### Milieux diélectriques : polarisation

Les milieux diélectriques (ou isolants) sont caractérisés par la présence de charges 
dites de polarisation ou liées (par opposition aux charges libres). Sous l'influence 
d'un champ électrique, ces charges peuvent se déplacer sur des distances limitées 
(électron en interaction forte avec un noyau par exemple). La séparation locale 
des charges induit la création de petits moments dipolaires dont la somme $`\Delta\vec{p}`$ 
sur un volume mésoscopique $`\Delta\tau`$ est caractérisée par le vecteur polarisation 
diélectrique $`\vec{P}`$ telle que :

$`\vec{P}=\dfrac{\Delta\vec{p}}{\Delta\tau}`$


La norme de $`\vec{P}`$ s'exprime en C.m$^{-2}$.
Si le vecteur polarisation diélectrique n'est pas homogène dans tout le milieu, il
y aura des accumulations locales de charges de polarisation telles que :

$`\rho_{p}=- div \vec{P}`$

Cette relation reste valide si le champ électrique varie avec le temps. Dans ce cas,
$`\rho_p`$ dépend aussi du temps et ses variations temporelles entraînent la création 
d'une densité volumique de courant de charges de polarisation $`\vec{j}_{p}`$ définie 
par :


$`\vec{j}_{p}=\dfrac{\partial\vec{P}(t)}{\partial t}`$

Ces définitions de $`\rho_p`$ et de $`\vec{j}_{p}`$ permettent de vérifier l'équation
de conservation des charges de polarisation.


! *Remarque} :*
!
! A la surface du milieu, la discontinuité de $`\vec{P}`$ entraîne la création d'une densité surfacique de charges de polarisation $`\sigma_p`$ telle que ($\vec{n}$, vecteur unitaire orthogonal à la surface) :
!
! $`\sigma_p = \vec{P}.\vec{n}`$
!


##### Milieux magnétiques : aimantation

Les milieux magnétiques sont caractérisés par l'existence de moments dipolaires 
magnétiques individuels $`\vec{m}_i`$ localisés sur les atomes, ions ou molécules 
qui les composent. Pour un volume $`\Delta\tau`$, le moment magnétique $`\Delta\vec{m}`$ 
n'est autre que la somme de ces moments magnétiques individuels contenus dans $`\Delta\tau`$.
La densité volumique des moments magnétiques est représentée par le vecteur aimantation
$`\vec{M}`$ défini par :

$`\vec{M} = \dfrac{\Delta\vec{m}}{\Delta\tau}`$

Le vecteur aimantation, ou plus simplement l'aimantation, a pour unité $`A.m^{-1}`$. 
Lorsque l'aimantation d'un milieu n'est pas homogène, il y apparaît une densité 
volumique de courant d'aimantation $`\vec{j}_M`$ non nulle telle que :

$`\vec{j}_M = rot \vec{M}`$

A la surface du matériau, cela se traduit par une densité surfacique de courant 
d'aimantation $`\vec{j}_{M_{\textrm{ surf}}}`$ telle que :

$`\vec{j}_{M_{\textrm{surf}}} = \vec{M}\wedge\vec{n}`$

où $`\vec{n}`$ est le vecteur unitaire normal à la surface du matériau.
Toutes ces relations restent valides lorsque l'aimantation $`\vec{M}(t)`$ dépend du temps.

! *Remarque :*
!
! Il n'existe pas en physique de charge magnétique, \emph{i.e.} un point de l'espace
qui pourrait à lui seul générer un champ magnétique (par analogie avec une charge 
électrique et le champ électrique qu'elle génère). De ce fait, on ne peut pas définir 
de densité volumique de charge magnétique, contrairement à ce que nous venons de voir
dans le cas des charges liées dans les milieux diélectriques.
!

#### Equations de Maxwell généralisées aux milieux

##### Equations de Maxwell

En écrivant les équations de Maxwell dans un milieu différent du vide, il faut maintenant
tenir compte de toutes les contributions à la densité volumique de charge et à la 
densité volumique de courant. On obtient alors :

$`\quad div\;\vec{B} \; = \; 0`$,

$`\quad rot \; \vec{E} \; = \; -\dfrac{\partial \vec{B}}{\partial t}`$,

$`\quad div \; \vec{E} \; = \; \dfrac{\rho_{total}}{\epsilon_0}`$,

$`\quad rot\; \vec{B} \; = \; \mu_0\;\left( \vec{j}_{total} +\epsilon_0\; \dfrac{\partial \vec{E}}{\partial t}\right)`$,
<!--
$`\begin{eqnarray}
div\;\vec{B} \; = \; 0,\\
rot \; \vec{E} \; = \; -\dfrac{\partial \vec{B}}{\partial t},\\
div \; \vec{E} \; = \; \dfrac{\rho_{total}}{\epsilon_0},\\
rot\; \vec{B} \; = \; \mu_0\;\left( \vec{j}_{total} +\epsilon_0\; \dfrac{\partial \vec{E}}{\partial t}\right),
\end{eqnarray}`$-->

avec $`\;\rho_{total}=\rho_{libre}+\rho_{P}\;`$ et $`\;\vec{j}_{total}= \vec{j}_{libre} + \vec{j}_{P} + \vec{j}_{M}.`$

D'après le paragraphe précédent et après développement, ces équations deviennent :

$`\quad div\; \vec{B} \; = \; 0\;`$,

$`\quad rot\;   \vec{E} \; = \; -\dfrac{\partial \vec{B}}{\partial t}\;`$,

$`\quad div\; \vec{D} \; = \; \rho_{libre}`$ ,

$`\quad rot\;   \vec{H} \; = \; \vec{j}_{libre} +\dfrac{\partial\vec{D}}{\partial t}`$

avec

$`\quad \vec{D}  \;  =  \;  \epsilon_0 \vec{E}+\vec{P}\quad`$ , l'induction électrique
(en $`C.m^{-2}`$), et

$`\quad \vec{H}  \;  =  \;  \dfrac{\vec{B}}{\mu_0}-\vec{M}\quad`$,  l'excitation 
magnétique (en $`A.m^{-1}`$).

Ces 4 équations de Maxwell dites généralisées prennent en compte les propriétés 
du milieu traversé par l'onde électromagnétique.

De plus, dans un milieu, le vecteur de Poynting s'écrit de façon générale (exprimé 
en $`W.m^{-2}`$) :


\begin{equation}
\vec{\Pi} = \vec{E} \wedge \vec{H} \, \text{,}
\end{equation}
et la densité volumique d'énergie (exprimé en W.m$^{-3}$) :
\begin{equation}
u = \dfrac{1}{2} (\vec{E}.\vec{D} + \vec{B}.\vec{H}) \, \text{.}
\end{equation}

##### Relations constitutives des milieux

**Lorsque les milieux sont linéaires** (au sens vectoriel du terme) , ils sont alors
caractérisés par des grandeurs intrinsèques qui permettent de relier simplement 
la densité volumique de courant de charge libre $`\vec{j}_{libre}`$, l'induction 
électrique $`\vec{D}`$ et l'excitation magnétique $`\vec{H}`$ aux champs électrique 
$`\vec{E}`$ et magnétique $`\vec{B}`$ auxquels ils sont soumis. On peut ainsi définir
*trois relations constitutives des milieux* :

**$`\quad \vec{j}_{libre} \; = \;  \sigma \vec{E}\quad`$** , avec *$`\sigma`$* la
*conductivité électrique* du milieu,

**$`\quad \vec{D} \;  = \;  \epsilon \vec{E}\quad`$**, avec *$`\epsilon`$* la *permittivité
diélectrique* du milieu,

**$`\quad \vec{B} \;  = \;  \mu \vec{H}\quad`$**, avec *$`\mu`$* la *perméabilité 
magnétique* du milieu.

<!--=====Je n'arrive pas à faire passer ce tableau=======
\begin{eqnarray}
\vec{j}_{libre} & = & \sigma \vec{E} \, \text{, avec $`\sigma`$ la conductivité électrique du milieu,}\\
\vec{D} & = & \epsilon \vec{E} \, \text{, avec $`\epsilon`$ la permittivité diélectrique du milieu,}\\
\vec{B} & = & \mu \vec{H}\, \text{, avec $`\mu`$ la perméabilité magnétique du milieu}.
\end{eqnarray}
==================-->

Il est possible de définir des **grandeurs relatives par rapport au vide** pour 
les deux dernières, à savoir :

**$`\quad \epsilon_r \; =  \; \dfrac{\epsilon}{\epsilon_0}\quad `$**  la *permittivité 
diélectrique relative* du milieu,

**$`\quad  \mu_r  \; =  \; \dfrac{\mu}{\mu_0}\quad`$** la *perméabilité magnétique 
relative* du milieu

<!--=====Je n'arrive pas à faire passer ce tableau=======
\begin{eqnarray}
\epsilon_r & = & \frac{\epsilon}{\epsilon_0} \, \text{, la permittivité diélectrique relative du milieu,}\\
\mu_r & = & \dfrac{\mu}{\mu_0} \, \text{, la perméabilité magnétique relative du milieu}.
\end{eqnarray}
==================-->

Les relations constitutives pour $`\vec{D}`$ et $`\vec{B}`$ dérivent des deux relations suivantes :

**$`\quad\vec{P}=\epsilon_0\, \chi_e\, \vec{E}\quad`$** avec *$`\chi_e`$* la *susceptibilité diélectrique* du milieu,

**$`\quad\vec{M}=\chi_m\, \vec{H}\quad`$** , avec *$`\chi_m`$* la *susceptibilité magnétique* du milieu.

<!--=====Je n'arrive pas à faire passer ce tableau=======
\begin{eqnarray}
\vec{P}=\epsilon_0 \chi_e \vec{E} \, \text{, avec $`\chi_e`$ la susceptibilité diélectrique du milieu,}\\
\vec{M}=\chi_m \vec{H} \, \text{, avec $`\chi_m`$ la susceptibilité magnétique du milieu}.
\end{eqnarray}
==================-->

Ceci permet aussi d'écrire :

**\begin{equation}
\epsilon_r = 1 + \chi_e  \quad \text{ et } \quad
\mu_r = 1 + \chi_m.
\end{equation}**

##### Milieux linéaires, homogènes et isotropes (M.L.H.I.)

Dans le cas général d'un milieu linéaire quelconque, les grandeurs $`\sigma`$, 
$`\epsilon`$ et $`\mu`$ définies précédemment, sont des tenseurs de rang 2 qui dépendent
du point $`M`$ considéré dans le milieu :

\[
\vec{\vec{\sigma}}(M,t) \,\text{ , } \vec{\vec{\epsilon}}(M,t) \,\text{ , } \vec{\vec{\mu}}(M,t).
\]

Cela signifie que $`\vec{j}_{libre}`$, $`\vec{D}`$ et $`\vec{B}`$ ne sont pas nécessairement
colinéaires à $`\vec{E}`$ et $`\vec{H}`$.

Par contre, lorsque le milieu est homogène, ces grandeurs sont indépendantes du point 
$`M`$ considéré. Si le milieu est isotrope, ce qui signifie si sa réponse à une 
perturbation électromagnétique est identique quelle que soit l'orientation de la 
perturbation, alors ces tenseurs de rang 2 deviennent des scalaires. De ce fait, 
un milieu linéaire, homogène et isotrope sera caractérisé par les trois relations 
constitutives où $`\sigma`$, $`\epsilon`$ et $`\mu`$ seront des scalaires indépendants 
du point de l'espace considéré. On note ces milieux des M.L.H.I.

Nous nous limiterons dans la suite du cours à l'étude de la propagation d'une onde 
électromagnétique. dans ces milieux particuliers afin de simplifier la résolution 
des équations de propagation des champs.


#### OPPM dans un M.L.H.I.

Nous allons maintenant nous attacher à déterminer les caractéristiques d'une OPPM
se propageant dans un M.L.H.I. en résolvant l'équation de propagation de champs 
électrique et magnétique.

##### Equation de dispersion et constante diélectrique généralisée

Le calcul de l'équation de propagation du champ $`\vec{E}`$ ou $`\vec{B}`$ à partir
des équations de Maxwell généralisées conduit, lorsque l'on travaille en notation 
complexe, à l'équation de dispersion du milieu :

\begin{equation}
k^2=\underline{\mu} \,\underline{\epsilon}_{g} \,\omega^2 \, \text{ ,}
\end{equation}

où  $`\underline{\epsilon}_{g}`$ est la constante diélectrique généralisée définie par :

\begin{equation}
 \underline{\epsilon}_{g}(\omega) = \underline{\epsilon} + \dfrac{i \underline{\sigma}}{\omega}.
\end{equation}

! *Remarque :* Dans certains livres de référence la notation de $`\underline{\epsilon}_{g}`$
est souvent $`\underline{\epsilon}^{\ast}`$. 
!

L'équation de dispersion relie donc le nombre d'onde $`k`$ aux propriétés du milieu
L.H.I. ($`\sigma`$, $`\epsilon`$ et $`\mu`$) et à la pulsation de l'onde $`\omega`$.
Dans le cas général :`

\begin{eqnarray}
\underline{\sigma}(\omega) & = & \sigma^{'}(\omega) + i\sigma^{''}(\omega) \, \text{ ,} \\
\underline{\epsilon}(\omega) & = & \epsilon^{'}(\omega) + i\epsilon^{''}(\omega) \, \text{ ,} \\
\underline{\mu}(\omega) & = & \mu^{'}(\omega) + i\mu^{''}(\omega) \, \text{ .}
\end{eqnarray}

$`\underline{k}`$ sera par conséquent un nombre complexe dépendant de $`\omega`$.


##### Trois types de propagation

L'analyse de l'équation de dispersion conduit à la distinction de 3 types de propagation 
en fonction de $`k^2`$.

**Si  $`k^2`$ réel positif** :

Dans ce cas, *$`k`$ sera un réel pur* tel que $`k=\pm k^{'}`$, avec $`k^{'}(\omega) \in \Re^+`$ 
; le signe de $`k`$ sera fonction du sens de propagation. En optant ici pour le signe 
positif, le champ $`\underline{\vec{E}}`$ s'écrit alors :

**$`\underline{\vec{E}} = \vec{E}_0 \exp{i(\vec{k}.\vec{r}-\omega t)} = \vec{E}_0 \exp{i(\vec{k\,'}.\vec{r}-\omega t)}`$**

On retrouve l'expression d'une **OPPM qui se propage sans atténuation dans le milieu**.

![](prop_lib_g.png)

* **Si $`k^2`$ réel négatif**

Dans ce cas, *$`k`$ sera un imaginaire pur* tel que $`k=\pm i k''`$, avec $`k''(\omega) \in \Re^+`$ 
; le signe de $`k`$ sera fonction du sens de propagation et, en physique, devra
nécessairement conduire à une atténuation de l'amplitude des champs au fur et à 
mesure que l'onde s'y enfonce (s'il n'y a aucune source extérieure apportant de 
l'énergie à l'onde). En optant ici pour le signe positif, le champ $`\underline{\vec{E}}`$ 
s'écrit alors :

$`\underline{\vec{E}} = \vec{E}_0 \exp{i(\vec{k}.\vec{r}-\omega t)} = \vec{E}_0 \exp{i(i\vec{k}^{''}.\vec{r}-\omega t)}`$

soit 

**$`\underline{\vec{E}} = \vec{E}_0 \exp{(-\vec{k}^{''}.\vec{r})}\exp{(-i\omega t)}`$**

On obtient une *expression réelle du champ* sous la forme :

*$`\vec{E} = \vec{E}_0 e^{-\vec{k}^{''}.\vec{r}} \cos{(\omega t)}\;`$*,

ce qui correspond à une *onde stationnaire atténuée*, encore appelée **onde évanescente**.

![](electromagnetic-wave-media-evanescente.jpg)

* **Si $`k^2`$ complexe**

Dans ce cas général, *$`\underline{k}`$ sera un complexe* tel que
$`\underline{k}=\pm (k^{'} + i k^{''})`$, 
avec $`k^{'}(\omega)`$ et $`k^{''}(\omega) \in \Re^+`$ ; le signe de $`\underline{k}`$ 
sera fonction du sens de propagation et, en physique, devra nécessairement conduire 
à une atténuation de l'amplitude des champs au fur et à mesure que l'onde s'y enfonce 
(s'il n'y a aucune source extérieure apportant de l'énergie à l'onde). En optant ici 
pour le signe positif, le champ $`\underline{\vec{E}}`$ s'écrit alors :

$`\underline{\vec{E}} = \vec{E}_0 \exp{i(\vec{\underline{k}}.\vec{r}-\omega t)}`$

soit 

**$`\underline{\vec{E}} = \vec{E}_0 \exp{(-\vec{k}^{''}.\vec{r})} \exp{i(\vec{k}^{'}.\vec{r}-\omega t)}`$**

On obtient ainsi une *expression réelle du champ* sous la forme :

*$`\vec{E} = \vec{E}_0 e^{-\vec{k}^{''}.\vec{r}} \cos{(\vec{k}^{'}.\vec{r}-\omega t)} \, \text{,}`$*

![](electromagnetic-wave-media-attenuation.jpg)

Lorsque $`\underline{k}`$ est complexe, \emph{i.e.} lorsque **l'amplitude de l'onde 
est atténuée**, ce qui caractérise un **milieu dissipatif**.


##### Vitesse de phase, vitesse de groupe, indice

La **vitesse de phase** *d'une OPPM se propageant dans un M.L.H.I.* est définie par :

**$`\quad v_\varphi = \dfrac{\omega}{k\,'(\omega)}.`$**

Si *$`v_\varphi`$ est fonction de $`\omega`$* alors cela caractérise un **milieu 
dispersif** . Ceci revient à dire que la fonction $`k\,'(\omega)`$ n'évolue pas 
linéairement avec $`\omega`$.

Dans le cas d'un milieu dispersif, un paquet d'OPPMs de pulsations différentes 
centrées autour d'une valeur de référence $`\omega_0`$ s'étalera au fur et à mesure
qu'il progresse dans le milieu, la vitesse de propagation $`v_\varphi`$ de chaque OPPM 
étant différente. Si on souhaite caractériser la vitesse de propagation du paquet d'OPPMs,
il faut utiliser la notion de vitesse de groupe au "point" $`\omega_0`$, définie par :

\begin{equation}
v_g = \dfrac{d \omega}{dk\,'}.
\end{equation}

Si $`v_\varphi`$ est fonction de $`\omega`$, alors $`v_g`$ l'est aussi nécessairement.

On peut enfin définir l'**indice complexe du milieu** par :

**\begin{equation}
\underline{n}(\omega) = n\,' (\omega) + i~n\,''(\omega) = \dfrac{c \underline{k}}{\omega}
\end{equation}**

La *partie réelle $`n\,'`$* correspond à l'**indice de réfraction** ou indice optique
$`n_{opt}`$, et la *partie imaginaire $`n\,''`$* à l' **indice d'extinction** du milieu.
D'après ce qu'on vient de voir, on peut aussi définir l'indice de réfraction de la 
façon suivante :

**$`\quad n\,' (\omega) = n_{opt}(\omega) = \dfrac{c}{v_{\phi}(\omega)}`$**

##### Courbe de dispersion

Pour faciliter l'analyse rapide du comportement d'un milieu vis-à-vis de la propagation 
d'une OPPM, on trace la **courbe de dispersion du milieu $`\omega (k\,')`$**. Celle-ci
n'est bien sûr définie que lorsqu'il peut y avoir propagation, c'est-à-dire lorsque 
$`k\,'`$ est non nul. Cette courbe *permet de distinguer* très rapidement les 
**bandes passantes** (gammes des pulsations pour lesquelles $`k^2`$ est réel positif 
ou complexe), des **bandes non-passantes** (gammes des pulsations pour lesquelles 
$`k^2`$ est réel négatif). La courbe de dispersion d'un milieu est de plus toujours 
comparée à celle du vide pour laquelle on a $`\omega = c\,k`$. Il s'agit dans ce cas 
d'une droite de pente $`c`$.

![](electromagnetic-waves-media-dispersion2.jpg)

Par définition, la **vitesse de phase $`v_\varphi (\omega_1)`$** est donnée par la
*pente du segment reliant l'origine au point $`M_1(k_{1}^{'},\omega_1)`$ de la courbe 
de dispersion*. En effet, celle-ci vaut bien :

**$`\quad v_\varphi = \dfrac{\omega_1}{k_{1}^{'}} \, \text{.}`$**

Il est donc très facile d'estimer l'évolution de $`v_\varphi`$ en fonction de 
$`\omega`$, en suivant l'évolution de cette pente.

De même, la **vitesse de groupe $`v_{g}(\omega_2)`$** est par définition donnée
par la *pente de la tangente à la courbe de dispersion au point $`M_2(k_{2}',\omega_2)`$.* 
En effet :

**$`\quad v_{g}(\omega_2) = \left(\dfrac{d \omega}{d k\,'}\right)_{M_2} = \omega\,'(k\,'_2)`$**

Sachant cela, il est alors aisé de déterminer si le milieu est dispersif (i.e si 
$`v_\varphi`$ varie en fonction de $`\omega`$), et de comparer $`v_\varphi`$ et $`v_g`$
en fonction $`c`$, la vitesse de phase et de groupe de toute OPPM dans le vide.


#### Cas d'un M.L.H.I. diélectrique

##### Equation de dispersion

On se place maintenant dans le cas d'un **milieu L.H.I. diélectrique** tel que
**$`\sigma = 0`$, $`\mu = \mu_0`$** et 
**$`\underline{\epsilon}(\omega) =  \epsilon\,'(\omega) + i\epsilon\,''(\omega)`$**. 
L'équation de dispersion se réduit alors à :

**\begin{equation}
\quad\underline{k}^2=\mu_0 \underline{\epsilon} \omega^2 \, \text{,}
\end{equation}**

ou encore :

**\begin{equation}
\quad\underline{k}^2=\dfrac{\omega^2}{c^2} \underline{\epsilon}_r  \, \text{,}
\end{equation}**

avec **$`\underline{\epsilon}_r (\omega) =  \epsilon^{'}_r(\omega) + i\epsilon^{''}_r(\omega) = \dfrac{\underline{\epsilon}}{\epsilon_0}`$.**

L'étude de la propagation d'une OPPM dans ce diélectrique revient à étudier les 
variations de $`\underline{\epsilon}(\omega)$.

##### Diélectrique non-absorbant, et indice optique

Lorsque le **diélectrique est non-absorbant**, cela se traduit par une *constante 
diélectrique réelle* pour toutes valeurs de $`\omega`$  (soit $`\epsilon\,''(\omega)=0`$, 
$`\forall \omega`$).<br>
On en déduit que la **propagation** a bien lieu **sans atténuation**, caractérisée par :

<!--=========ce tableau ne passe pas===========
\begin{eqnarray}
\quad k \, = \, \sqrt{\epsilon_r}~\dfrac{\omega}{c} \text{,} \\
\quadv_\varphi \, = \,  \dfrac{c}{\sqrt{\epsilon_r}} \text{,} \\
\quadv_g \, = \,  \dfrac{c}{\sqrt{\epsilon_r}} \text{.}
\end{eqnarray}
=======================================-->

**$`\quad k \, = \, \sqrt{\epsilon_r}~\dfrac{\omega}{c}`$**,

**$`\quad v_\varphi \, = \,  \dfrac{c}{\sqrt{\epsilon_r}(\omega)}`$**,

**$`\quad v_g \, = \,  \dfrac{ 2c\,\sqrt{\epsilon_r}(\omega)}{\omega\cdot \epsilon_r'(\omega)+2\;\epsilon_r(\omega)}`$**

L'**indice optique** s'écrit alors **$`n_{opt}(\omega) = \sqrt{\epsilon_r (\omega)}`$**.

La **longueur d'onde** de l'OPPM dans ce milieu vaut 
**$`\lambda = \dfrac{\lambda_0}{n_{\textrm{opt}}}`$**, où $`\lambda_0 = c/\nu`$ est 
la longueur d'onde dans le vide.

Si on note $`\vec{u}`$ le vecteur unitaire indiquant la direction et le sens de 
propagation, le champ magnétique $`\vec{B}`$ s'écrit :

\begin{equation}
\quad\underline{\vec{B}}=\dfrac{n_{opt}}{c} (\vec{u} \wedge \vec{E}).
\end{equation}

On en déduit, en notation réelle, que :

<!--======ne passe pas ===================
\begin{eqnarray}
\quadu & = & \epsilon E^2 \\
\quad\vec{\Pi} & = & c n_{\textrm{opt}} \epsilon_0 E^2 \, \vec{u} \\
\quad\text{soit } \vec{\Pi} & = & v_\varphi u \, \vec{u}\, \\
\quad\text{et } \langle \vec{\Pi}\rangle_T & = & \dfrac{1}{2} v_\varphi \, \epsilon E^{2}_0 \, \vec{u}\, \text{.}
\end{eqnarray}
===================================-->

$`\quad u \, = \, \epsilon E^2`$

$`\quad \vec{\Pi} \, = \, c n_{\textrm{opt}} \epsilon_0 E^2 \, \vec{u}`$

soit

$`\quad \vec{\Pi} \, = \, v_\varphi u \, \vec{u}`$

$`\quad  \langle \vec{\Pi}\rangle_T \, = \, \dfrac{1}{2} v_\varphi \, \epsilon E^{2}_0 \, \vec{u}`$


##### Diélectrique absorbant

Un **diélectrique absorbant** est un diélectrique dans lequel  le *vecteur polarisation
$`\vec{P}(t)`$* *suit les variations de $`\vec{E}(t)`$ avec un certain retard $`\varphi_p`$*
, de sorte que :

<!--======================================
**\begin{equation}
\quad\underline{\vec{P}}(t)= \epsilon_0 \,\underline{\chi}_e \,\underline{\vec{E}}(t)
\end{equation}**
======================================-->
**$`\quad \underline{\vec{P}}(t)= \epsilon_0 \,\underline{\chi}_e \,\underline{\vec{E}}(t)`$**

avec

**$`\quad \underline{\chi}_e = \chi_e' + i\,\chi_e'' = \chi_e^{0}\cdot e^{i\,\phi_p}`$**

<!--======================================
**\begin{equation}
\quad \underline{\chi}_e = \chi_e' + i\,\chi_e'' = \chi_e^{0}\cdot e^{i\,\phi_p}
\end{equation}**
======================================-->

En notation réelle, on obtient finalement pour l'induction électrique :

$`\displaystyle \overrightarrow{D}(\overrightarrow{r},t) = \epsilon_0 \cdot e^{-\overrightarrow{k''}.\overrightarrow{r}}`$$`\times \left( \epsilon_r' \; cos (\overrightarrow{k'}.\overrightarrow{r} - \omega t) - \epsilon_r'' \; sin (\overrightarrow{k'} \,\overrightarrow{r}-\omega t) \right) \overrightarrow{E}_0`$

avec

$`\quad\epsilon_r' (\omega) = 1 + \chi_e' (\omega) \; \text{ et } \; \epsilon_r''(\omega) = \chi_e'' (\omega)`$

On peut aussi écrire l'induction électrique sous la forme :

$`\displaystyle \quad \overrightarrow{D}(\overrightarrow{r},t) = \epsilon_0\;\sqrt{\epsilon_r'^2+\epsilon_r''^2}\cdot e^{-\overrightarrow{k''}.\overrightarrow{r}}`$$`\times \;cos\,\left(\overrightarrow{k'} .\overrightarrow{r}-\omega. t+\phi_D) \right) \overrightarrow{E}_0`$,

avec

$`\quad\tan{\varphi_D}=\dfrac{\epsilon^{''}_r}{\epsilon^{'}_r}`$


Comme $`\vec{D}`$ est nécessairement en retard sur $`\vec{E}`$, $`\epsilon_r'' (\omega)`$
est positive. Pour les très faibles fréquences cependant ($\omega \rightarrow 0$), 
le retard à la polarisation tend vers $`0`$ donc $`\epsilon_r''`$ tend vers $`0`$
et $`\epsilon_r'`$ tend vers $`(1+\chi'_{e}(\omega))`$.

##### Indice complexe

L'équation de dispersion s'écrit à nouveau :

\begin{equation}
\quad \underline{k}^2=\mu_0 \underline{\epsilon} \omega^2 \, \text{,}
\end{equation}

ce qui se décompose en un système de 2 équations à 2 inconnues lorsqu'on identifie
les parties réelles et imaginaires :

$`\left\{ \begin{array}{ccc}
k'^{2} - k''^{2} \, = \, \mu_0\, \epsilon' \omega^2 \\
2\, k' k'' \, = \, \mu_0\, \epsilon'' \omega^2
\end{array}
\right.`$

L'indice complexe $`\underline{n}`$ du milieu est défini par :

$`\quad \underline{n}^{2} \, = \, \underline{\epsilon}_{r}\quad`$ , ou encore
$`\quad \underline{n}^{2} \, = \, \dfrac{c^2 \underline{k}^2}{\omega ^2}`$

Dans ces conditions, le système d'équations à résoudre devient :

$`\left\{ \begin{array}{ccc}
n'^{2} - n''^{2} \, = \, \epsilon_r' \\
2 \,n' n'' \, = \, \epsilon_r'
\end{array}
\right.`$

La vitesse de phase $`v_\varphi`$ se définit comme :
$`v_\varphi = \dfrac{\omega}{k'} = \dfrac{c}{n'}`$

**Définition :**

La **partie réelle $`n'`$** est appelée *indice de réfraction* du milieu alors que 
la **partie imaginaire** correspond à l' *indice d'extinction*.


##### Propagation de l'énergie

Le vecteur de Poynting associé à une OPPM qui se propage selon $`(Ox)`$ vers les 
$`x`$ croissants, dans ce diélectrique absorbant est le suivant :

$`\vec{\Pi}=\dfrac{\vec{E}\wedge \vec{B}}{\mu_0}=c \,\epsilon_0\,{E_0}^2 \,e^{-2k''x}`$
$`\times \left[ n^{'} \cos^2 (k'x-\omega t) -   n'' \sin (k'x-\omega t)\right.`$
$`\left.\,cos (k'x-\omega t)\right]~\vec{e}_x `$,

et sa valeur moyenne associée :

$`\displaystyle\langle \vec{\Pi} \rangle_T =c n' \frac{\epsilon_0 {E_0}^2}{2} \;e^{\left(-2n'' \dfrac{\omega}{c}x\right)}~\vec{e}_x `$

La décroissance de la puissance propagée par l'onde est caractérisée par le coefficient
d'extinction $`\beta`$ (ou coefficient d'atténuation) du milieu : 
$`\beta = 2 k'' = 2 n'' \dfrac{\omega}{c}`$.

#### Cas d'un M.L.H.I. très bon conducteur

##### Temps de relaxation d'un bon conducteur

D'après l'équation de conservation de la charge et la loi d'Ohm locale dans un 
conducteur, la densité volumique de charge libre $`\rho_{\textrm{libre}}`$ vérifie
l'équation différentielle suivante :

$`\dfrac{\partial \rho_{libre}}{\partial t} \,+ \,div\, \vec{j}_{libre} = 0`$

avec $`\quad\vec{j}_{libre}=\sigma \vec{E}\quad`$ et
$`\quad div\, \vec{E}=\dfrac{\rho_{libre}}{\epsilon_0}`$

d'où :

$`\dfrac{\partial \rho_{libre}}{\partial t} + \dfrac{\sigma}{\epsilon_0}\rho_{libre} = 0`$

Si on suppose une accumulation de charge de densité non-nulle $`\rho_0`$ à l'instant 
$`t = 0`$ dans le métal, celle-ci disparaîtra exponentiellement selon la loi :

$`\rho_{libre} = \rho_0\;e^{-\frac{t}{\tau}}\quad`$ avec $`\quad \tau = \dfrac{\epsilon_0}{\sigma}`$

Dans le cas du cuivre par exemple où $`\sigma = 0,57.10^{8}~\Omega^{-1}\,m^{-1}`$,
$`\tau = 1,5.10^{-19}\,s`$. Pour des temps si courts, la loi d'ohm locale n'est plus 
valable car la conductivité est définie par l'intermédiaire du temps de libre parcours 
moyen des porteurs de charge entre 2 chocs qui est de l'ordre de $`10^{-14}\,s `$. 
A l'échelle mésoscopique, nous travaillons cependant avec des OPPMs de période temporelle
$`T`$ supérieure à $`10^{-14}\,s`$. Ainsi, comme $`\tau \gg T`$, nous pourrons considérer
que $`\rho_{libre} = 0`$ à tout instant dans le bon conducteur.

De plus, la comparaison des amplitudes des densités volumiques de courant de charges
libres et de courant de déplacement conduit à :

\begin{equation}
\dfrac{\left| \underline{\overrightarrow{j}} \right|}{\left| \epsilon_0 \dfrac{\partial \underline{\overrightarrow{E}}}{\partial t} \right|} = \dfrac{\sigma}{\epsilon_0 \omega} = 2 \pi \dfrac{T}{\tau} \ll 1
\end{equation}

Ceci montre que nous pouvons négliger dans ce cas la densité volumique de courant 
de déplacement.

##### Equation de dispersion et profondeur de pénétration

Les 4 équations de Maxwell s'écrivent alors :


$`\quad div\, \vec{B} \, = \, 0 `$

$`\quad rot\, \vec{E} \, = \, -\dfrac{\partial\vec{B}}{\partial t}`$

$`\quad div\, \vec{E} \, = \, 0 `$

$`\quad rot\, \vec{B} \, = \, \mu_0 \,\vec{j}_{libre} = \mu_0 \,\sigma\, \vec{E} = \dfrac{\sigma}{\epsilon_0 c^2}\, \vec{E}`$


Ceci conduit à l'équation de propagation pour le champ électrique suivante (en notation complexe) :

\begin{equation}
\Delta \underline{\vec{E}} + i\dfrac{\sigma \omega}{\epsilon_0 c^2} \underline{\vec{E}} = \vec{0}.
\end{equation}

D'où l'équation de dispersion du milieu :

\begin{equation}
\underline{k}^2 = i\dfrac{\sigma \omega}{\epsilon_0 c^2}.
\end{equation}

Ainsi $`\underline{k}`$ s'écrit pour une onde se propageant dans le sens "positif" :

\begin{equation}
\underline{k} = \dfrac{1+i}{\delta} \, \text{ avec } \delta = \sqrt{\dfrac{2 \epsilon_0 c^2}{\sigma \omega}}.
\end{equation}

$`\delta`$ est appelé la profondeur de pénétration de l'onde dans le métal, exprimée 
en m. On est donc dans le cas d'une propagation avec atténuation de l'OPPM avec comme 
vitesse de phase $`v_\varphi = \omega \delta`$. L'indice de réfraction du milieu 
est donc défini par $`n' = \dfrac{c}{\omega \delta}`$. Ces 2 dernières grandeurs 
dépendent de la pulsation de l'OPPM donc le milieu est dispersif.

##### Modèle du métal parfait

Pour un bon conducteur, la profondeur de pénétration $`\delta`$ n'excède généralement 
pas quelques mm aux fréquences les plus basses comme on peut le voir dans le tableau 
donné ci-dessous pour le cuivre.\\

-----------------
 |  |  |  |  |
| :---: | :---: | :---: | :---: | :---: | :---: |
| Fréquence | $`\lambda`$ | $`\delta`$ | $`v_\varphi`$ | $`n'`$ |
| 100 Hz | 3000 km | 6,5 mm | 4,1 m.s$`^{-1}`$ | 7,4 10$`^7`$ |
| 10 GHz | 3 cm | 0,65 $`\mu`$m | 4,1 10$`^4`$ m.s$`^{-1}`$ | 7,4 10$`^3`$ |
--------------

_Valeurs à deux fréquences typiques de la profondeur de pénétration et des grandeurs
associées pour le cuivre massif._


Ceci nous permet de justifier l'utilisation du modèle du métal parfait, c'est-à-dire 
un métal de conductivité infinie. Dans ce cas, $`\tau`$ tend vers $`0`$, ainsi que $`\delta`$. 
L'OPPM est donc instantanément, et totalement atténuée dès son entrée dans le métal 
parfait. On considère alors qu'en tout point du métal parfait le champ électrique $`\vec{E}`$ 
est nul (et par conséquent le champ magnétique $`\vec{B}`$ aussi), et qu'il ne peut 
exister d'onde é.m. L'utilisation de ce modèle rend bien compte, -comme nous allons
le voir au chapitre suivant-, de la très bonne réflectivité des métaux (utilisés 
comme miroir de ce fait).

A l'interface de 2 matériaux dont un modélisé par un métal parfait, la réflexion 
d'une OPPM génère une densité surfacique de courant non nulle sur la surface. 
Ce qui reste en accord avec une loi d'Ohm locale pour laquelle $`\sigma`$ est
infinie et $`\vec{E}`$ est égal à $`\vec{0}`$.


