---
title: 'Application du théorème de Gauss local : méthode'
published: true
routable: true
visible: true
lessons:
    -
        slug: electrostatics-gauss-application-method-3
        name: LINÉAIRE : Théorème de Gauss : méthode générale
        order: 3
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

### Forme locale

#### Introduction

Soit une *distribution de charges maintenues immobiles* dans l'espace décrite par 
une densité de charge $`\dens`$.

Le **théorème de Gauss local** démontre que en tout point de l'espace la 
*divergence $`\mathbf{div\overrightarrow{E}}`$* du champ électrique créé par une distribution
de charge, est égal à la *densité volumique de charge $`\dens^{3D}`$* qui la représente 
divisée par la constante diélectrique $`\epsilon_0`$.<br>

**$`\large\mathbf{div\,\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}}`$**


! *Remarque :*   
! La *forme locale* du théorème de Gauss est *simplement dérivée de sa forme intégrale*, en faisant *tendre vers 0 le volume de la surface de Gauss* autour du point considéré.
!
! Le point représente donc en fait un volume mésoscopique, apparaissant comme ponctuel à l'échelle d'observation spatiale, mais suffisamment grand pour qu'une densité volumique de charge moyenne $`\dens^{3D}`$ stable à l'échelle d'observation temporelle puisse être définie.

**Le théorème de Gauss local ne s'applique qu'** à une distribution des charges représentée par une *densité volumique de charge $`\dens^{3D}`$*.

**Le théorème de Gauss local ne s'applique pas** si la distribution de charge est modélisée par une *densité surfacique de charge $`\dens^{2D}`$*, **sauf si il est complété** par les *relations de continuité de $`\overrightarrow{E}`$ à la traversée d'une surface chargée*.


##### Relations de continuité de $`\overrightarrow{E}`$ à la traversée d'une surface chargée.

Ces relations de continuité de $`\overrightarrow{E}`$ à la traversée d'une surface $`\mathcal{S}`$ chargée de densité $`\dens^{2D}`$ sont **démontrées grâce au théorème de Gauss intégral** dans le *cas appliqué dun plan infini uniformément chargé*.

> _Redonner ici le lien vers la page parallèle où cette colonne et la première colonne restent inchangées, mais où la colonne centrale est l'application du théorème intégral de Gauss aux distributions de charges planes._

Soit **$`M`$** un **point quelconque** d'une *surface chargée uniformément ou non uniformément*.   

Dans le *voisinage de $`M`$*, la surface chargée sépare son espace local $`\Delta\mathscr{E}`$ en **deux sous-espaces $`\Delta\mathscr{E}_1`$ et $`\Delta\mathscr{E}_2`$** situés de part et d'autre de la surface. Les indices 1 et 2 peuvent sont attribués de façon arbitraire aux deux sous-espaces.    

! *note :* sur la *signification du mot "voisinage" en physique* :   
! à construire.

!! *au-delà :* sur la *définition du mot "voisinage" en mathématique* :    
!! à construire.

**Orientons la surface $`\mathcal{S}`$** en $`M`$ par un **vecteur unitaire $`u_{12}`$** *perpendiculaire à  $`\mathcal{S}`$* et dans le sens *de $`\Delta\mathscr{E}_1`$ vers $`\Delta\mathscr{E}_2`$*.

Le champ électrique $`\overrightarrow{E}`$ peut alors se décomposer en une *composante parallèle $`E_{\parallel}`$* et une *composante perpendiculaire $`E_{\perp}`$* à ce plan :    

**$`\mathbf{\overrightarrow{E}=E_{\parallel}\,\overrightarrow{e_{\parallel}}+E_{\perp}\,\overrightarrow{e_{\perp}}}`$**

Quatre composantes  $`E_{1\perp}`$,  $`E_{2\perp}`$, $`E_{1\parallel}`$ et  $`E_{2\parallel}`$ sont alors définies selon que $`\overrightarrow{E}`$ se situe dans  $`\Delta\mathscr{E}_1`$ ou $`\Delta\mathscr{E}_2`$.

*Dans ce voisinage*, la surface chargée peut-être assimilée à un **plan infini chargé uniformément** avec une densité de charge **$`\mathbf{\dens^{2D}=cste}`$**.

Les **relations de continuité de $`\overrightarrow{E}`$** à travers cette surface chargée sont :

* Il y a *discontinuité de la composante perpendiculaire* $`E_{\perp}`$, telle que :   
  **$`\mathbf{E_{2\perp}-E_{1\perp}=\dfrac{\dens^{2D}}{\epsilon_0}}`$**
  
* Il y a *continuité de la composante parallèle* $`E_{\parallel}`$ :   
  **$`\mathbf{E_{2\parallel}-E_{1\parallel}=0}`$**
  
<br>

--------------------

**De façon plus abstraite, mais plus concise** mathématiquement car l'écriture reste 
au niveau des vecteurs et non de leurs diverses compoisantes, ces *relations de continuité*
s'écrivent :

   * pour la *discontinuité de la composante normale* :    
     **$`\mathbf{\overrightarrow{n}_{12}\cdot \left(\overrightarrow{E}_2 - \overrightarrow{E}_1\right) = \dfrac{\dens^{2D}}{\epsilon_0}}`$**
   * pour la *continuité de la composante tangentielle* :
    **$`\mathbf{\overrightarrow{n}_{12}\land \left(\overrightarrow{E}_2 - \overrightarrow{E}_1\right) = \overrightarrow{0}}`$**
    
! *Note :*
!
! Bien que plus abstraite, ces *relations* sont *faciles à comprendre et à retrouver*.
!
! * $`\overrightarrow{n}_{12}\cdot \left(\overrightarrow{E}_2 - \overrightarrow{E}_1\right)`$ 
! contient l'*opérateur de projection parallèle à $`\mathbf{\overrightarrow{n}_{12}}`$*, 
! en direction et sens :  
! <br>
! $`\mathbf{\overrightarrow{n}_{12}\Large\cdot}`$     
! <br>
! qui appliqué à un vecteur $`\overrightarrow{V}`$ donne la composante de ce vecteur 
! selon $`\overrightarrow{n}_{12}`$. Ce dernier étant perpendiculaire au plan local 
! de la surface, cet opérateur $`\overrightarrow{n}_{12}\cdot`$ appliqué à $`\overrightarrow{V}`$ 
! *donne la composante perpendiculaire $`V_{\perp}`$ à la surface*.
! 
! * $`\overrightarrow{n}_{12}\land \left(\overrightarrow{E}_2 - \overrightarrow{E}_1\right)`$ 
! contient l'*opérateur de projection perpendiculaire à $`\mathbf{\overrightarrow{n}_{12}}`$*, 
! selon le sens direct :   
! <br>
! $`\mathbf{\overrightarrow{n}_{12}\,\large\land}`$     
! <br>
! qui appliqué à un vecteur $`\overrightarrow{V}`$ donne la composante de ce vecteur 
! perpendiculaire à $`\overrightarrow{n}_{12}`$. Si ce dernier est perpendiculaire 
! à un plan, cet opérateur $`\overrightarrow{n}_{12}\land`$ appliqué à $`\overrightarrow{V}`$ 
! *donne la composante $`V_{\parallel}`$ parallèle à la surface*.


#### 2° étape : Choix de l'expression de la divergence, puis simplification

Le théorème de Gauss dans sa forme locale est vrai en tout point $`M`$ de l'espace.

À cette étape 2, l'intérêt se porte sur le *premier terme du théorème de Gauss*. Il s'agit ici d'**identifier l'expression de la divergence**, puis de la **simplifier** à partir de l'expression $`\overrightarrow{E}`$ obtenue après étude des symétries et invariances.    
<br>
*ÉTAPE 2 :* **$`\;\;\large\mathbf{div\,\overrightarrow{E}}`$**$`\;=\dfrac{\dens^{3D}}{\epsilon_0}`$

Le *repère de l'espace* adapté à la distribution de charge à l'origine du champ étudié a été *sélectionné à l'étape 1*. Il s'agit maintenant d'identifier er de sélectionner l'*expression de la divergence dans ce repère*.

Les **expressions de la divergence** dans les 3 repères usuels de l'espace sont :

* *repère cartésien :*    
<br>
**$`\mathbf{div\overrightarrow{E}=
\dfrac{\partial E_x}{\partial\,x}
+\dfrac{\partial E_y}{\partial\,y}
+\dfrac{\partial E_z}{\partial\,z}}`$**   

* *repère cylindrique :*   
<br>
**$`\mathbf{div\overrightarrow{E}=
\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}
+\dfrac{\partial\,E_z}{\partial\,z}}`$**

* *repère sphérique :*   
<br>
**$`\mathbf{div\overrightarrow{E}=
\dfrac{1}{r^2}\cdot\dfrac{\partial\left(r^2\,E_r\right)}{\partial\,r}}`$**
**$`\mathbf{\;+\dfrac{1}{r\,\sin\theta}\cdot\dfrac{\partial\left(\sin\theta\,E_{\theta}\right)}{\partial\,\theta}}`$**
**$`\mathbf{\;+\dfrac{1}{r\,\sin\theta}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}}`$**

Une fois l'expression de travail sélectionné, il faut voir si elle peut être simplifiée.

##### Éléments physiques conduisant à la simplification de l'écriture de $`div\overrightarrow{E}`$.

en cours de rédaction ... 

Supposons que *dans un repère de l'espace
$`(O, \overrightarrow{e_{\alpha}},\overrightarrow{e_{\beta}},\overrightarrow{e_{\gamma}})`$*, les symétries et invariances nous indiquent que le champ électrique est de la forme    **$`\mathbf{\overrightarrow{E}=E_{\beta}\,(\beta)\,\overrightarrow{e_{\beta}}}`$**.



#### 3° étape : 



#### 4° étape, finale  : Calcul de $`\overrightarrow{E}`$









