---
title: Brainstorming on the mathematical tools required at each level
published: true
routable: true
visible: false
---

<!----------------------------------------------------
lessons:
    - slug: define-g12-mathematical-tools
      order: 2
    - slug: define-1-mathematical-tools-polyglot
      order: 3
----------------------------------------------------->


#### Define the mathematical tools required at level 1

--------------------------------

with a **first classification to sort out** the brainstorming (counting, geometry, etc.).
It *does not presage chapter titles*.

Feel free to create a new classification if necessary.


! *Numeration and operations*
!

(CME-FR) _Good mastery, with exercises to develop automatisms:_

- *Digits and numbers (base 10)*
- *Whole numbers, positive and negative*
- *Real numbers*
- *The four operations: $`+, -, ×, ÷`$*   
  and therefore the sign $`=`$
- *Power of 10 $`(10^p)`$*, power *of any integer n $`(n^p)`$*
- *$`n^p \times n^q = n^{\,p + q}`$*

RESPOND:
(XXX-YY) ...

--------------------
(CME-FR) _Good mastery, with exercises to develop automatisms:_

 - The *fractions* (related to the Pythagorean theorem in the right-angled triangle, and the cross-multiplication's rule)

RESPOND:
(XXX-YY) ...

---------------------
(CME-FR) _Good mastery, with exercises to develop automatisms:_
- *Comparison of numbers: $`\ lt, \ gt, \ le, \ ge`$*

RESPOND:
... (XXX-YY)

---------------------
(CME-FR) _Simply discovered, or more if it is useful to explain the number system,
and better understand base 10? It can be very fun with animated figures_

- The *numerical bases* (in connection with the sets)

_Idea: this can be very useful in physics, to introduce ideas very early
on counting and large numbers._

RESPOND:
... (XXX-YY)

---------------------

(XXX-YY) ...

RESPOND:
... (XXX-YY)

------------------

! *Sets*
!

(CME-FR) _Whatever our level, all our life we characterize, classify in categories_
_and sets. A first approach seems essential to me from this level 1 (with the idea of learning_
_not to be binary and to relativize). And it can be very visual and very fun, with_
_thousands of possible examples in everyday life._

_It seems useful to understand: _
_- base 10 numbering (and the others)._
_- what is an equation (and therefore later a correlation or a physical law of cause and effect)._

RESPOND:
... (XXX-YY)

---------------------
(CME-FR)
- *Elements, characterize* elements
- *Indistinguishable or distinct elements*
- *Sets and subsets*.
- *Union $`\cup`$ and intersection $`\cap`$*
  
RESPOND:
... (XXX-YY)

---------------------

(XXX-YY) ...

RESPOND:
... (XXX-YY)

------------------

! *Geometry*
!

(CME-FR) _Good mastery, with exercises to develop automatisms:_
* *Pytahgore's theorem / the cross-multiplication's rule* (in relation to fractions and the right-angled triangle)

RESPOND:
... (XXX-YY)

------------------

! *The equations*
!

(CME-FR)
- *equality $`=`$*
- *write an equality, maybe true or false*.
- *equation in mathematics*.
- *equation in physics (members of the same nature, in the same units)*


---------------------

(XXX-YY) ...

RESPOND:
... (XXX-YY)

------------------ 