---
title: Magnétostatique 1
published: true
routable: true
visible: false
lessons:
    - 
       slug: stationary-magnetic-field
       name: LINÉAIRE-3 : Les causes d'un champ magnétostatique
       order: 1
    -
       slug: rectilinear-line-electrosta-magnetostat-electromag
       name: PANORAMA-34 : le fil, en ElectroStat., MagnétoStat. et ÉlectroMag.
       order: 2
    -
       slug: causes-stationary-electric-magnetic-fields
       name: PARALLÈLE-3 : Les causes des champs E et B statiques
       order: 3
    - 
       slug: from-current-to-induced-magnetic-field
       name: PARALLÈLE-3 : du courant au champ magnétique induit
       order: 2
    - 
       slug: biot-savard-magnetostatics
       name: "LINÉAIRE-3 : Magnétostatique de Biot et Savard"
       order: 2
---

<!------------
     - 
       slug: from-current-to-induced-magnetic-field
       name: PARALLÈLE : du courant au champ magnétique induit
       order: 2
------------->

<!--définitions spécifiques LaTex-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$


!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!--MétaDonnée : ... -->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------


### Magnétostatique

#### Quelles sont les causes d'un champ magnétique stationnaire ?

* Les causes d'un champ magnétique stationnaire sont :
   * des **courants électriques stationnaires dans des circuits conducteurs immobiles**.   
   * la présence d'**aimants permanents immobiles**.

![](coil-magnetic-field-1-L1200-LR.jpg)

<!--titre partie principale : MAGNÉTOSTATIQUE
#### Comment créer un champ magnétique stationnaire ?
* **Technologiquement**, dans le vide ou en absence de matériaux magnétiques, un **champ magnétique stationnaire** 
est *créé par des courants stationnaires dans des circuits conducteurs immobiles*.-->   


<!-----------
!!! *Exemple de courants :*   
!!! * microscopiques : un flux d'électrons extraits d'une cathode chauffée et accélérés par une anode se propageant dans le vide.
!!! * macroscopiques : les courants de conduction circulant dans un circuit conducteur soumis à une différence de potentiel électrique.
----------->

##### Qu'est-ce qu'un élément de courant ?

* Tout **courant électrique** macroscopique par la pensée *peut être décomposé en ses* **éléménts de courant**.

* **Élément de courant** = **courant infinitésimal** = **courant élémentaire**.

<!--[terminologie recommandée](http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=121-11-17) -->

* Un **courant élémentaire $`\mathbf{I \cdot\overrightarrow{dl}}`$** de longueur et sens donnés
par le vecteur élémentaire $`\overrightarrow{dl}`$ situé en un point P de l'espace 
(la surface élémentaire $`dS`$ perpendiculaire à $`\overrightarrow{dl}`$ 
traversée par le courant $`I`$ étant négligeable) *peut aussi s'exprimer* :<br>
   * en fonction du vecteur densité volumique $`\overrightarrow{j}`$ sur un volume élémentaire $`d\tau=dS\,dl`$ au point P.<br>
   * en terme de charge élémentaire $`q`$ se déplaçant à la vitesse $`\overrightarrow{v}`$, de sorte que nous avons l'équivalence :<br>
<br>**$\mathbf{I \cdot\overrightarrow{dl} \quad\equiv \;\overrightarrow{j} \cdot d\tau\quad \equiv \;q \cdot \overrightarrow{v}}`$**

* Les équations aux dimensions de ces expressions équivalentes montrent qu'elles sont caractérisées par la
**même grandeur physique**, un *courant électrique multiplié par une longueur* :
   * $`[I \cdot L]= I \cdot L`$<br>
   * $`[q \cdot v]=[q]\cdot[v] = [q]\cdot L \cdot T^{-1} `$
$`\quad = ([q]\cdot T^{-1})\cdot L = I \cdot L`$
   * $`[j \cdot \tau]=[j]\cdot L^3 = I \cdot L^{-2} \cdot L^3 = I \cdot L`$

* Quelque soit l'expression utilisée, l'**unité d'un élément de courant est l'Ampère mètre, $`\mathbf{A\cdot m}`$**  , dans le *système internationale de mesure (SI)*.

##### Champ magnétique créé par un courant élémentaire : loi de Biot et Savard

* Permet le **calcul direct du champ magnétique** créé en tout point de l'espace par des courants.

* Les effets induits du champ magnétique ( force magnétique, force de Laplace, moments et couple sur une spire de courant, champ électromoteur et force électromotrice ) sont fonction du vecteur induction magnétique $`\overrightarrow{B}`$. Le **champ d'induction magnétique $`\overrightarrow{B}`$** est donc le *champ fondamental à prendre en compte pour décrire les effets magnétiques*.

* La **loi de Biot et Savart** *exprimée en fonction du champ d'induction magnétique $`\overrightarrow{B}`$* ) donne l'expression du champ magnétique élémentaire $`d\overrightarrow{B}_M`$ créé dans le vide, en tout point $`M`$ de l'espace par un élément de courant $`I \cdot\overrightarrow{dl}_P`$ localisé en un point $`P`$, s'écrit :<br>
<br>**$`\mathbf{\overrightarrow{dB}_M=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\vec{dl}_P\land\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}}`$**<br>
<br>soit encore :<br>
<br>**$`\mathbf{\overrightarrow{dB}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\land\overrightarrow{r}}{r^3}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\land\overrightarrow{e_r}}{r^2}}`$**, avec $`\overrightarrow{r}=r\;\overrightarrow{e_r}`$ et $`r>0`$, l'élément de courant étant localisé en $`\overrightarrow{r}=\overrightarrow{0}`$, <br>
<br>où **$`\mu_0`$** est la **constante magnétique**, encore appelée **perméabilité magnétique du vide**.  *Son unité et sa valeur* dans le système international sont :<br>
<br>$`\mu_0 = 1.256\,6... \cdot 10^{-6}\; kg\,m\,A^{-2}\,s^{-2}`$
$`\quad\approx 4\pi \cdot 10^{-7} \;T\,m \,A^{-1}`$

* *Unité SI de champ d'induction magnétique $`\overrightarrow{B}`$* : Le **tesla (T)**.

!! *Pour aller plus loin :* sur la *nature de $`\overrightarrow{B}`$* : <br>
!! Dans la définition de $`\overrightarrow{B}`$ entre un produit vectoriel de deux vecteurs vrais (deux vecteurs polaires), donc dans sa définition entre une fois la règle d'orientation de l'espace $`\Longrightarrow`$  l'induction magnétique $`\overrightarrow{B}`$ est un *pseudo-vecteur* (ou *vecteur axial*).
!!
!! Cette remarque est importante pour ceux qui devront maîtriser les équations de l'électromagnétisme (les équations de Maxwell). Vecteurs vrais (ou vecteur polaires) et pseudo-vecteurs (ou vecteurs axiaux) se comportent différemment lors de certaines opérations de symétrie. Leur distinction sera fondamentale dans la compréhension et l'utilisation des théorèmes de Gauss en électrostatique et d'Ampère en magnétostatique, première étape avant d'aborder l'électromagnétisme de Maxwell.
!!
!! L'étude des propriétés de symétrie des vecteurs vrais et des pseudo-vecteurs sera un préalable sur le chemin de l'électromagnétisme.

* Ainsi exprimée en fonction du champ d'induction magnétique $`\overrightarrow{B}`$, la loi de Biot et Savart peut prendre les **trois expressions équivalentes**, *à utiliser selon les besoins* :<br>
<br>$`\overrightarrow{dB}_M=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}_P\land\overrightarrow{PM}}{||\overrightarrow{PM}||^3}\quad`$   
<br>
$`\overrightarrow{dB}_M=\dfrac{\mu_0}{4\pi}\cdot\dfrac{\overrightarrow{j} \cdot d\tau_P\land\overrightarrow{PM}}{||\overrightarrow{PM}||^3}\quad`$   
<br>
$`\overrightarrow{dB}_M=\dfrac{\mu_O}{4\pi}\cdot\dfrac{q_P \cdot \overrightarrow{v}\land\overrightarrow{PM}}{||\overrightarrow{PM}||^3}`$
<br><br>

![](causes-magnetism-B-L1200-gif.gif)

* **Dans le vide et uniquement dans le vide**, le **champ magnétique** se représente aussi bien par le *champ d'induction magnétique $`\overrightarrow{B}`$* que par le *champ d'excitation magnétique $`\overrightarrow{H}`$*, qui se déduisent l'un de l'autre par la simple multiplication par une constante : la constante magnétique encore appelée perméabilité magnétique absolue du vide.

* **Dans le vide : $`\mathbf{\overrightarrow{B}=\mu_0\,\overrightarrow{H}}`$**

<!--MAGST-120-->
! *Note sur l'interprétation des champs $`\overrightarrow{B}`$ et $`\overrightarrow{H}`$*
!
! Nous pouvons interpréter les champs  et  de la façon suivante :<br>
! Un courant électrique excite magnétiquement l'espace *vide*, interprété comme un *milieu linéaire isotrope ($`\overrightarrow{B}\propto \overrightarrow{H}`$)* parmi d'autres. Sous l'effet de ce champ d'excitation magnétique $`\overrightarrow{H}`$, le milieu réagit en créant le champ d'induction $`\overrightarrow{B}`$, qui sera la cause des différents effets induits, dont la force magnétique $`\overrightarrow{F}_B = q \; (\overrightarrow{v}\land\overrightarrow{B})`$ , partie due au champ magnétique de la force de Lorentz $`\overrightarrow{F}_{Lor} = q \; (\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B})`$
!
! Le vide est caractérisé par le *rapport de proportionnalité* entre $`\overrightarrow{B}`$ et $`\overrightarrow{H}`$, appelé *constante magnétique* ou encore *perméabilité magnétique du vide*  notée *$`\mu_0`$*.

<!--MAGST-130-->
!! *Pour aller plus loin* :<br>
!! Nous verrons lors de l'étude de la magnétostatique dans les milieux magnétiques, que sous l'excitation d'un champ d'excitation magnétique $`\overrightarrow{H}`$, le milieu développera une aimantation $`\overrightarrow{M}`$ (grandeur physique de même dimension physique que $`\overrightarrow{H}`$ donc d'unité SI $`A\cdot m`$) qui complètera $`\overrightarrow{H}`$ pour donner le champ d'induction magnétique $`\overrightarrow{B}`$ :<br>
!! $`\overrightarrow{B}=\mu_0\,(\overrightarrow{H}+\overrightarrow{M})\quad`$ ,     soit     $`\quad\overrightarrow{H}=\dfrac{\overrightarrow{B}}{\mu_0}+\overrightarrow{M}`$.
!!<!--MAGST-140-->
!! Un *milieu magnétique linéaire isotrope* sera caractérisé des *vecteurs $`\overrightarrow{B}`$ et $`\overrightarrow{H}`$ simplement proportionnels*, tels que :<br>
!! *$`\overrightarrow{B}=\mu\overrightarrow{H}=\mu_0\mu_r\overrightarrow{H}\quad[eq.2].`$*<br>
!! où la perméabilité absolue $`\mu`$ comme la perméabilité relative $`\mu_r`$ du milieu caractérise son comportement magnétique.
!!
!! Si le milieu magnétique est linéaire ET anisotrope, $`[eq.2]`$ restera vérifiée, mais $`\mu`$ et $`\mu_r`$ seront de nature tensorielle.

<!--MAGST-150-->
* La **loi de Biot et Savart** *exprimée en fonction du champ d'excitation magnétique $`\overrightarrow{H}`$* s'écrit :<br>
<br>**$`\mathbf{\overrightarrow{dH}_M=\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\vec{dl}_P\land\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}}`$**<br>
<br>soit encore :<br>
<!--MAGST-160-->
<br>**$`\mathbf{\overrightarrow{dH}=\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\land\overrightarrow{r}}{r^3}=\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\land\overrightarrow{e_r}}{r^2}}`$**, avec $`\overrightarrow{r}=r\;\overrightarrow{e_r}`$ et $`r>0`$, l'élément de courant étant localisé en $`\overrightarrow{r}=\overrightarrow{0}`$, <br>
<br>

![](causes-magnetism-H-L1200-gif.gif)

<!--MAGST-170-->
* L'équation au dimension du champ d'excitation magnétique $`\overrightarrow{H}`$ peut être obtenue à partir de cette loi de Biot et Savard :<br>
<br>$`[H]=\dfrac{I \cdot L \cdot L}{L^3}= I \cdot L^{2-3} = I \cdot L^{-1}`$<br>
<br>L'**unité du champ d'excitation magnétique** est l'**Ampère par mètre, $`\mathbf{A\cdot m^{-1}}`$**, dans le *système internationale de mesure (SI)*.

<!--MAGST-180-->
! *Note :*
! * Séparer des charges de signes opposées créé un *champ électrique $`\overrightarrow{E}`$ * dont l'*unité SI* est le *Volt par mètre*, *$`V\cdot m^{-1}`$*. 
! * Générer des courants électriques créé un *champ d'excitation magnétique $`\overrightarrow{H}`$ * dont l'*unité SI* est l'*Ampère par mètre*,  *$`A\cdot m^{-1}`$*. 

<!--MAGST-190-->
!! *Pour aller plus loin* sur la *nature de $`\overrightarrow{H}`$* :<br>
!! Pour les mêmes raisons que l'induction magnétique , l'excitation magnétique $`\overrightarrow{H}`$ est un *pseudo vecteur* (ou *vecteur axial*).

#### Qu'est-ce que le calcul direct d'un champ magnétique ?

* La **calcul direct** consiste à :
  * *décomposer* la distribution spatiale des courants *en éléments de courants*.
  * *appliquer à chacun d'eux la loi de Biot et Savard* pour calculer le champ magnétique élémentaire induit en un point quelconque de l'espace. 
  * *intégrer les champs magnétiques élémentaires* créés par l'ensemble des éléments de courant de la distribution.

* Cette méthode n'est réalisable analytiquement que dans quelques cas très simples.
* Cette méthode peut être traduite en un programme informatique.

<!--MAGST-200-->

#### Quel est le champ magnétique créé par un fil conducteur rectiligne infini parcouru par un courant constant ?

<!--MAGST-300-->

##### Description et paramétrage du problème

* Le **fil conducteur rectiligne infini** est parcouru par un *courant d'intensité $`I`$ constante*.

![](magnetic-field-fil-rectiligne-infini_1_L1200.jpg)

* Le *champ magnétique* doit être calculé **en tout point de l'espace**. <br>
Pour cela nous prenons un **point $`M`$ quelconque, représentatif** de tout point de l'espace.<br>
* Il faut *décomposer le courant* dans le fil **en ses éléments de courant**.<br>
Nous prenons un **élément de courant $`I\cdot\overrightarrow{dl}_P`$ en un point P quelconque, représentatif** de tous les points du fil.
* Ceci nous permettra :<br>
\- dans une première étape, de calculer le champ magnétique $`\overrightarrow{dB_M}`$ créé par $`I\cdot\overrightarrow{dl}_P`$ au point $`M`$.<br>
\- dans une seconde étape seront intégrés l'ensemble des $`\overrightarrow{dB_M}`$ créés par tous les élement de courant constituant le courant dans le fil, pour conduire au champ mégnétique $`\overrightarrow{B_M}`$ total.

![](magnetic-field-fil-rectiligne-infini-2_v2_L1200.jpg)

* Il faut ensuite **choisir le bon repère de l'espace** dans lequel la description mathématique de la situation et les calculs seront simples :<br>

* Un **fil rectiligne infini** est *invariant par rotation d'angle $`\varphi`$* quelconque et *par translation $`z`$* quelconque, si nous choissisons un **repère cylindrique $`(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$ dont l'axe $`Oz`$ est l'axe du fil**, comme repère de l'espace.
* Nous choisirons de positionner l'**origine $`O`$** du repère au *point de projection orthogonale du point $`M`$ sur le fil*. Ainsi le point $`M`$ de coordonnées cylindriques $`\rho; \varphi, z)`$ est suité à la distance $`z`$ du fil. 

![](magnetic-field-fil-rectiligne-infini-3_v2_L1200.jpg)<br>

* L'avantage de cette position de l'origine $`O`$ est que **les trois points $`(P, O, M)`$** forment un **triangle rectangle** en $`O`$.<br>
 Ainsi *les distances $`z`$, $`\rho`$ et $`d=||\,\overrightarrow{PM}\,||`$* qui interviendront dans le calcul de $`\overrightarrow{dB_M}`$, sont aussi les longueurs d'arête de ce triangle rectangle vérifient **$`d^2=\rho^2+z^2`$** et les **relations trigonométriques simples d'un triangle rectangle**.
 
L'élément de courant $`I\cdot\overrightarrow{dl_P}`$ et un point $`M`$ définissent un plan $`\mathcal{P}`$. Le produit vectoriel $`I\cdot\overrightarrow{dl_P}\wedge\overrightarrow{PM}`$ est un vecteur perpendiculaire à ce plan. La **règle d'orientation de l'espace de la main droite** *permet de connaître le sens du champ magnétique*.   

! *Remarque :*   
! Dans le cas d'un courant filaire rectiligne, tous les éléments de courant constitutifs et le point $`M`$ sont situés dans un même plan $`\mathcal{P}`$. Ils conduiront en ce point $`M`$ à des champs magnétiques élémentaires qui pointeronts dans une même direction et un même sens. Ainsi en chaque point de l'espace, l'orientation et le sens du champ magnétique total peut être connu. 
!   
! ![](magnetic-field-fil-rectiligne-infini-4_v2_L1200.jpg)   
!   
! Bien sûr, cette remarque n'est pas nécessaire, les calculs directs redonneront ce résultats, mais cette remarque *permet de vérifier la véracité du calcul* sur ce point.

* Il est possible de **paramétrer le problème**, introduire les *grandeurs physiques intermédiaires utiles* à notre perception du problème. Ainsi nous portons sur la figure :   
<br>
![](magnetic-field-fil-rectiligne-infini-6_v2_L1200.jpg)   
<br>
   * la distance $`d=||\,\overrightarrow{PM}\,||`$ qui intervient dans la loi de Biot et Savard
   * le vecteur $`\overrightarrow{e_d}`$ tel que le vecteur $`\overrightarrow{PM}`$ s'écrive $`\overrightarrow{PM}=d\cdot \overrightarrow{e_d}`$
   * l'angle $`\alpha =\widehat{OMP}`$


##### Expression du champ magnétique élémentaire

* Calculons le **champ magnétique élémentaire** au point $`M`$ :   

   * champ d'excitation magnétique élémentaire :   
$`\overrightarrow{dH}_M\quad=\quad\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}_P\land\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}`$
$`\quad=\quad\dfrac{1}{4\pi}\cdot\dfrac{I\cdot dz\,\overrightarrow{e_z}\land d\,\overrightarrow{e_d}}{d^3}`$
$`\quad=\quad\dfrac{I}{4\pi}\cdot\dfrac{dz\;d}{d^3}\cdot \overrightarrow{e_z}\wedge \overrightarrow{e_d}`$   
 
   * champ d'induction magnétique élémentaire :      
$`\overrightarrow{dB}_M\quad=\quad\mu_0\,\overrightarrow{dH}_M`$


* Nous devons décomposer le vecteur $`\overrightarrow{e_d}`$ en fonction des vecteurs de la base cylindrique choisie, ce qui donne :<br>
$`\quad\overrightarrow{e_d}=\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\quad`$

* $`\overrightarrow{e_z}\wedge \overrightarrow{e_d}\quad=\quad\overrightarrow{e_z}\wedge(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z})`$
$`\quad=\quad \cos\alpha\cdot(\overrightarrow{e_z}\wedge\overrightarrow{e_{\rho}})-\sin\alpha\cdot(\overrightarrow{e_z}\wedge\overrightarrow{e_z})`$
$`\quad=\quad\cos\alpha\cdot(\overrightarrow{e_z}\wedge\overrightarrow{e_{\rho}})\quad=\quad\cos\alpha\cdot\overrightarrow{e_{\varphi}}`$

*  Nous obtenons alors :<br>
<br>**$`\mathbf{\overrightarrow{dH}_M=\dfrac{I}{4\pi}\cdot\dfrac{dz}{d^2}\cdot\cos\alpha\cdot\overrightarrow{e_{\varphi}}}\quad`$**,   
soit   
**$`\mathbf{\overrightarrow{dB}_M=\dfrac{\mu_0\;I}{4\pi}\cdot\dfrac{dz}{d^2}\cdot\cos\alpha\cdot\overrightarrow{e_{\varphi}}}`$**


##### Calcul du champ magnétique total par intégration

* Pour obtenir le *champ magnétique total*, il reste à **intégrer tous les champs magnétiques élémentaires** créés par les éléments de courant qui composent le courant filaire.

!!!! *ATTENTION :* un *fil* est une *variété à une dimension* (variété = espace) : la position d'un élément de courant $`I\cdot dl_P`$ sur le fil est repérée par *une seule coordonnée, $`z`$* dans le repère choisi.
!!!!
!!!! *Intégrer sur le fil infini* signifie tenir compte de tous les éléments de courant $`I\cdot dz`$ en faisant varier *$`z`$ entre $`-\infty`$ et $`+\infty`$*.
!!!!
!!!! Mais dans notre expression du champ magnétique élémentaire, la variable $`z`$ peut être liée à d'autres variables intermédiaires utilisées dans la description du problème. La *question à se poser* est :<br>
!!!! *Si le point $`P`$ se déplace, quelles variables utilisées varient?*
!!!!
!!!! *Si plusieurs variables sont liées* à ce déplacement unidimensionnel de $`P`$, alors elles sont liées. Il faut alors *choisir l'une d'elles comme variable d'intégration*, puis *exprimer les autres en fonction de celle choisie* AVANT de réaliser l'intégration.

* Dans cette étude, lorsque l'élément de courant se déplace le long du fil, les trois variables **$`z`$, $`d`$ et $`\alpha`$ varient de façon non indépendantes**, elles sont liés. Il faut donc **choisir l'une d'elle comme variable d'intégration**. Nous avons la *liberté de choix*, il en résultera simplement des calculs plus ou moins difficiles, un résultat d'écriture plus ou moins smple, un éclairage particulier sur l'interprétation finale. Pour montrer cela, nous choisirons successivement $`z`$, puis $`\alpha`$.

*_Choix de $`z`$ comme variable d'intégration_*

à faire

_*Choix de $`\alpha`$ comme variable d'intégration*_

* C'est le choix la plupart du temps présenté lors de l'étude du fil rectiligne infini. Il conduit 
facilement à une expression simple du champ magnétique total. 

* Il faut **exprimer $`dz`$ et $`d`$ en fonction de $`\alpha`$**. Le triangle $`(P,O,M)`$ étant rectangle en $`O`$, nous avons :   
<br>
![](electric-magnetic-field-fil-rectiligne-infini-6_v2_L1200.jpg)
<br>
   * *$`\color{blue}{\dfrac{z}{\rho}=\tan\alpha}`$*$`\quad\Longrightarrow\quad z=\rho\cdot \tan\alpha`$<br>
<br>$`\Longrightarrow\quad\dfrac{dz}{d\alpha}=\rho\cdot \dfrac{d}{d\alpha}\left(\dfrac{\sin\alpha}{\cos\alpha}\right)`$
$`\quad\quad=\rho\cdot \dfrac{\cos^2\alpha+\sin^2\alpha}{\cos^2\alpha}=\dfrac{\rho}{\cos^2\alpha}`$<br>
<br>**$`\mathbf{\Longrightarrow\quad dz=\dfrac{\rho}{\cos^2\alpha}\cdot d\alpha}`$**

  * $`\color{blue}{\dfrac{\rho}{d}= \cos\alpha\quad}`$**$`\mathbf{\Longrightarrow\quad\dfrac{1}{d^2}=\dfrac{\cos^2\alpha}{\rho^2}}`$**


* Exprimé seulement en fonction de$`\alpha`$, le champ magnétique élémentaire s'écrit :<br>
<br>**$`\overrightarrow{dH}_M`$**$`\;=\dfrac{I}{4\pi}\cdot\dfrac{dz}{d^2}\cdot\cos\alpha\cdot d\alpha\cdot\overrightarrow{e_{\varphi}}`$
$`\quad=\quad\dfrac{I}{4\pi}\cdot\dfrac{\rho\cdot d\alpha}{\cos^2\alpha}\cdot\dfrac{\cos^2\alpha}{\rho^2}\cdot\cos\alpha\cdot d\alpha\cdot\overrightarrow{e_{\varphi}}`$
**$`\quad=\quad\dfrac{I}{4\pi\rho}\cdot\cos\alpha\cdot d\alpha\cdot\overrightarrow{e_{\varphi}}`$**

* Le fil étant rectiligne, il s'inscrit dans un plan $`\mathcal{P}`$ contenant le fil lui-même est le point $`M`$. Dès lors, un observateur au point $`M`$ peut quantifier par un angle $`\hat{A}`$ le champ sous lequel il voit le fil.<br>
<br>Un fil infini vu depuis tout point $`M`$ est vu sous un angle $`\hat{A}=\pi`$ qui correspond aux valeurs limites $`\alpha_1=-\dfrac{\pi}{2}`$ et $`\alpha_2=+\dfrac{\pi}{2}`$. 
Il est nécessaire ici de considérer l'angle $`\alpha`$ en valeur algébrique. Tout élément de courant 
$`I\cdot dz_P`$ du fil est observé dans une direction du plan $`\mathcal{P}`$ caractérisée par son 
angle $`\alpha_P\in\, \left]-\dfrac{\pi}{2}\,,+\dfrac{\pi}{2}\,\right[`$ 

!! *Pour aller plus loin :*<br>
!! Il serait facile de calculer le champ magnétique créé par un fil rectiligne d'extrémités C et D parcouru par un courant $`I`$. Si ces extrémités sont observées dans des directions $`\alpha_C`$ et $`\alpha_D`$, le calcul du champ magnétique total serait simplement $`\overrightarrow{H}=\int_{\alpha_C}^{\alpha_D} d\overrightarrow{H}`$ (avec $`\alpha_C<\alpha_D`$).
!!
!!Mais physiquement une telle distribution de courant n'a que peu de sens, un courant nécessite un circuit fermé sinon les charges s'accumulent. C'est la raison pour laquelle seul le cas du fil infini est traditionnellement traité. Mais un courant filaire rectigne d'extrémités C et D peut être la partie d'un circuit plus vaste, par exemple un cadre rectangulaire ABCD parcouru par un courant $`I`$. Il suffirait de calculer le champ magnétique créé par chacune des branches AB, BC, CD, DA, puis de calculer le champ magnétique total créé par le cadre grâce au théorème de superposition. 
!!
!! L'intérêt serait de montrer qu'à grande distance, le champ magnétique créé par ce cadre serait identique au champ créé par une spire circulaire de même orientation et de même aire. Ce serait un exemple pour montrer un résultat concernant le champ magnétique à grande distance créé par une petite boucle de courant inscrite dans un plan : à orientation et aire équivalentes, le champ magnétique créé à grande distance par cette boucle ne dépend pas de sa forme. Ce remarque trouvera son sens dans l'étude des propriétés magnétiques des matériaux.


* Par intégration, l'expression du champ magnétique créé par un fil infini en tout point de l'espace (à l'exception des points situés sur le fil lui-même) est :<br>
<br>$`\displaystyle \overrightarrow{H}=\int_{-\pi / 2}^{+ \pi / 2} \dfrac{I}{4\pi\rho}\cdot \cos\alpha \cdot d\alpha \cdot \overrightarrow{e_{\varphi}}`$
$`=\dfrac{I}{4\pi\rho}\cdot \left[ \sin\alpha \right]_{-\pi / 2}^{+\pi / 2}\cdot \overrightarrow{e_{\varphi}}`$
$`=\dfrac{I}{4\pi\rho}\cdot [1-(-1)] \cdot \overrightarrow{e_{\varphi}}= \dfrac{I}{2\pi\rho} \cdot \overrightarrow{e_{\varphi}}`$

##### Expression du champ magnétique total

Le champ magnétique créé par un *courant $`I`$ filaire rectiligne infini* en tout point de l'espace situé à une *distance $`\rho>0`$* du fil s'écrit :

* exprimé sous forme de *champ d'excitation magnétique* $`\overrightarrow{H}`$ :<br>
<br>**$`\mathbf{\overrightarrow{H}=\dfrac{I}{2\pi\rho} \cdot \overrightarrow{e_{\varphi}}}`$**

* exprimé sous forme de *champ d'induction magnétique* $`\overrightarrow{B}=\mu_0\,\overrightarrow{H}`$ :<br>
<br>**$`\mathbf{\overrightarrow{B}=\dfrac{\mu_0\,I}{2\pi\rho} \cdot \overrightarrow{e_{\varphi}}}`$**

! *Remarque :*<br>
! Ces expressions impliquent une valeur de champ magnétique qui tend vers l'infini quand la distance au fil tend vers zéro. Est-ce physiquement réaliste ?
!
! Dans la modélisation de l'expérience, nous avons considéré un fil de section nulle. Nous avons ainsi fait un modèle approximé à 1 dimension (1D) d'une réalité physique tridimensionnelle (3D). Une reprise 3D de cette étude réalisée à une résolution mésoscopique (le "point" représentant en réalité un volume non résolvable à l'échelle d'observation) ferait apparaître à l'intérieur du fil un champ magnétique qui s'éloigne des prédictions du modèle filaire 1D. Notamment les valeurs limites infinis disparaitraient.

!! *Pour aller plus loin :*<br>
!! Faire cette étude 3D de façon analytique en calculs directs serait extrêmement difficile. Une façon de faire serait d'implémenter la loi de Biot et Savard dans un calcul informatique avec un certain maillage de l'espace et une longeur de fil limitée. Par contre, le courant filaire présentant des invariances et symétries suffisantes, ce calcul sera très facile en utilisant le théorème d'Ampère (première étape réservée à ceux qui se destinent à maîtriser l'électromagnétisme de Maxwell).
!!
!! L'électron étant considéré comme une particule ponctuelle, même dans une description 3D les valeurs du champ électrique et de champ magnétique induit par son déplacement tendent vers l'infini quand la distance à l'électron tend vers 0. 
!!
!! A la résolution de la plupart de nos expérience, nous utiliseront la notion de volume mésoscopique. C'est un volume infinitésimal à l'échelle d'observation et donc considéré comme ponctuel dans la modélisation, mais très grand devant les dimensions atomiques. Cela permet d'attribuer au volume mésoscopique la valeur moyenne des champs à l'intérieur de celui-ci, évitant ainsi les valeurs infinies. Dans l'étude des propriétés des matériaux, l'ordre de grandeur d'un volume mésoscopique est de quelques nanomètres cube à quelques dizaines de microns cube, selon les moyens de caractérisations.

#### Quel est le champ magnétique créé en un point de son axe par une spire conductrice circulaire parcourue par un courant constant ?

<!--MAGST-400-->

##### Description de la distribution de courants

figure

* Une **spire circulaire $`\mathcal{C}`$** de **rayon $`R`$** et dont la section droite 
est négligée, est parcourue par un *courant constant $`I`$* de *sens indiqué par une flèche* 
sur la figure.

* Pour décrire la situation et réaliser les calculs, choisissons le point **origine O**
et le système de **coordonnées cylindriques $`(\rho, \varphi, z)`$**, tel que la 
*spire $`\mathcal{C}`$* soit de *centre $`O`$*, s'inscrive 
*dans le plan perpendiculaire à l'axe $`Oz`$*, et tel que le *sens du courant* soit *trigonométrique direct*.


* La *spire $`\mathcal{C}`$ parcourue par le courant $`I`$* se décompose mentalement, pour le sens de $`I`$ indiqué et le sens
positif choisi de l'axe  $`Oz`$, en ses **éléments de courant d'expression**   
<br>
**$`\boldsymbol{\mathbf{I\,\overrightarrow{dl}_P = I\;R\,d\varphi\,\overrightarrow{e_{\varphi}}}}\quad`$**(A &nbsp;m)   
<br>
situés en tout *point $`P`$ de la spire* de coordonnées cylindriques
*$`P = (\rho_P=R,\,\varphi_P,\,z_P=0)`$*.

* Il est possible de **paramétrer le problème**, 'introduire des *grandeurs physiques intermédiaires utiles à notre perception* du problème. Ainsi nous portons sur la figure :   
<br>
   * la *distance $`d=||\,\overrightarrow{PM}\,||=\sqrt{R^2+z^2}`$* qui intervient dans la loi de Biot et Savard
   * le *vecteur $`\overrightarrow{e_d}`$* tel que le vecteur $`\overrightarrow{PM}`$ s'écrive $`\overrightarrow{PM}=d\cdot \overrightarrow{e_d}`$
   * l'*angle $`\alpha =\widehat{OMP}`$*


##### Expression du champ magnétique élémentaire, puis calcul de $`\overrightarrow{B}`$

* Selon la loi de Biot et Savart, l'élément de courant $`I\,\overrightarrow{dl}_P`$
en tout point $`P`$ de la spire parcourue par le courant $`I`$ créé 
*en tout point M* de l'espace le **champ magnétique élémentaire**   
<br>
**$`\mathbf{\overrightarrow{dB}_{P\rightarrow M}}`$**$`\;=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}_P
\land\overrightarrow{PM}}{||\overrightarrow{PM}||^3}`$   

$`\hspace{2cm}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot R\,d\varphi\,\overrightarrow{e_{\varphi}}\land d\,\overrightarrow{e_d}}{d^3}`$   

*$`\boldsymbol{\mathbf{\hspace{2cm}=\dfrac{\mu_0\,I}{4\pi}\cdot\dfrac{R\,d\varphi}{d^2}\cdot \overrightarrow{e_{\varphi}}\wedge \overrightarrow{e_d}}}`$*  
<br>

* **Pour tout point $`P`$** de la spire portant l'élément de courant $`I\,\vec{dl}_P`$ de la spire
**existe $`P'`$** point sur la spire *symétrique de $`P`$ par rapport an centre $`O`$*
de la spire, qui porte l'élément de courant $`I\,\overrightarrow{dl}_{P'}`$ 
**tel que**    
**$`\mathbf{I\,\overrightarrow{dl}_{P'} = - I\,\overrightarrow{dl}_P}`$**.   
<br>

* La figure suivante montre une coupe de la spire dans le *plan $`\mathcal{P}`$* qui 
*contient l'axe $`Oz`$ et* les points *$`P`$ et $`P'`$*.    
   * les vecteurs $`\overrightarrow{e_D}_P`$ et $`\overrightarrow{e_D}_{P'}`$ sont contenus dans le plan $`\mathcal{P}`$,   
   * les vecteurs $`I\,\overrightarrow{dl}_P`$ et $`I\,\overrightarrow{dl}_{P'}`$ sont perpendiculaires à $`\mathcal{P}`$,  
   Donc, de par les propriétés du produit vectoriel, les champs magnétiques élémentaires **$`\overrightarrow{dB}_{P\rightarrow M}`$
   et $`\overrightarrow{dB}_{P'\rightarrow M}`$** créés **appartiennent à $`\mathcal{P}`$**.   
   <br>

* La *symétrie* de $`\overrightarrow{dB}_{P\rightarrow M}`$ et $`\overrightarrow{dB}_{P'\rightarrow M}`$ par rapport
  à l'axe $`Oz`$ montre que la **somme de ces deux contributions** au champ magnétique total $`\overrightarrow{dB}_{M}`$
  est **dirigée selon $`\overrightarrow{e_z}`$**.   
  <br>
  Ainsi, **seule la composante   
  $`\mathbf{\overrightarrow{dB}_{P\rightarrow M}\cdot\overrightarrow{e_z}=dB_{P,\,z}=sin\,\alpha\times dB_P}`$**   
  du champ magnétique élémentaire créé par chaque point $`P`$ appartenant à la spire, *contribuera à $`\overrightarrow{dB}_{M}`$*,   

  et tu peux écrire :   
  <br>
  **$`\mathbf{\displaystyle\overrightarrow{B_M}}`$**$`\displaystyle\;\,=\int_{P\in\mathcal{C}}\overrightarrow{dB}_{P\rightarrow M} = \int_{P\in\mathcal{C}} dB_{P,z}\;\overrightarrow{e_z}`$   
  <br>
  *$`\displaystyle\hspace{1cm}=\int_{P\in\mathcal{C}} sin\,\alpha\; dB_P\times\overrightarrow{e_z}`$*   
  <br>
  $`\displaystyle\hspace{1cm}=sin\,\alpha \int_{\varphi=0}^{2\pi} \dfrac{\mu_0\,I}{4\pi}\cdot\dfrac{R\,d\varphi}{d^2}\;\overrightarrow{e_z}`$   
  <br>
  $`\displaystyle\hspace{1cm}=sin\,\alpha\;\dfrac{\mu_0\,I}{4\pi}\cdot\dfrac{R}{d^2}  \;\Big[\varphi\Big]_0^{2\pi}\;\overrightarrow{e_z}`$    
  <br>
  **$`\boldsymbol{\mathbf{\hspace{1cm}=\dfrac{\mu_0\,I}{2}\dfrac{R\;sin\,\alpha}{d^2}\;\overrightarrow{e_z}}}`$**   
  <br>

* Il est temps de **réécrire** le résultat précédent en le réexprimant **en fonction des données initiales** décrivant la
distrubution de courant, soit :
   * le *rayon $`R`$* de la spire.
   * l'*intensité $`I`$* qui la traverse, le sens de $`I`$ étant indiqué par une flèche sur la spire.
   * la *coordonnée $`z`$* de tout point $`M`$ pris sur l'axe de révolution de la spire.  
   
   En se souvenant que  *$`\quad d=\sqrt{R^2+z^2}`$*   
   et en remarquant que  
   *$`\quad sin\;\alpha`$*$`\;= \dfrac{R}{d}`$ *$`\;= \dfrac{R}{\sqrt{R^2+z^2}}`$*   
   Nous obtenons :

* Le **champ magnétique $`\overrightarrow{B}`$** créé en tout point de coordonnées $`z`$ 
  **sur l'axe de révolution $`Oz`$** (l'origine $`O`$ étant le centre de la spire) par une *spire de rayon $`R`$* 
  parcourue par un *courant constant d'intensité $`I`$* dans le 
  *sens trigonométrique direct* s'ecrit :   
  <br>
  **$`\mathbf{\overrightarrow{B}}`$**$`\;=\dfrac{\mu_0\,I}{2}\cdot R \cdot sin\,\alpha\cdot \dfrac{1}{d^2}\cdot \overrightarrow{e_z}`$   
  <br>
  $`\hspace{0.7cm}=\dfrac{\mu_0\,I}{2}\cdot R\cdot \dfrac{R}{\sqrt{R^2+z^2}}\cdot \dfrac{1}{R^2+z^2}\cdot \overrightarrow{e_z}`$   
  <br>
  **$`\mathbf{\hspace{0.7cm}=\dfrac{\mu_0\,I}{2}\;\dfrac{R^2}{\big(R^2+z^2\big)^{3/2}}\;\overrightarrow{e_z}}`$**   


##### Interprétation du résultat

* L'ensemble de l'information est contenue dans l'équation précédente de $`\overrightarrow{B}`$, mais    
  <br>
  Il est *utile* de **d'étudier puis visualiser le profil de variation de $`B`$** le long de cet axe.

* à terminer

figure à faire, profil de variation de $`B`$

!! *Pour aller plus loin : Les bobines de Helmholz*   
!! à faire



#### Quel est le champ magnétique créé dans tous l'espace par une spire conductrice circulaire parcourue par un courant constant ?

<!--MAGST-500-->

#### Qu'est-ce qu'un dipôle magnétique, et quel champ magnétique créé t-il ?

<!--MAGST-600-->

